/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.agencypay;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;

public class AgencyPayInfoService {
    public void adjustAgencyPayInfoPanel(List<Long> releasePkList) {
        DynamicObject[] agencyPays;
        List<Long> payDetailIds = this.queryPayDetailIds(releasePkList);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_agencypaybill");
        QFilter qFilter = new QFilter("entryentity.paydetail.id", "in", payDetailIds);
        for (DynamicObject agencyPay : agencyPays = serviceHelper.query("id,totalcount,entryentity,paydetail,entryentity.paydetail.onholdstatus", qFilter.toArray())) {
            DynamicObjectCollection dyColl = agencyPay.getDynamicObjectCollection("entryentity");
            int totalCount = dyColl.size();
            int unpayCountofAbandon = 0;
            for (DynamicObject dyObj : dyColl) {
                int onholdStatus = dyObj.getInt("paydetail.onholdstatus");
                if (onholdStatus != OnHoldStatusEnum.ABANDON.getCode()) continue;
                ++unpayCountofAbandon;
            }
            agencyPay.set("totalcount", (Object)(totalCount -= unpayCountofAbandon));
        }
        serviceHelper.save(agencyPays);
    }

    private List<Long> queryPayDetailIds(List<Long> releasePkList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter filter = new QFilter("caltableid", "in", releasePkList);
        DynamicObject[] payDetails = helper.query("id", filter.toArray());
        HashSet<Long> payDetailIds = new HashSet<Long>(16);
        for (DynamicObject payDetail : payDetails) {
            payDetailIds.add(payDetail.getLong("id"));
        }
        return new ArrayList<Long>(payDetailIds);
    }
}

