/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.agencypay.payresult;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hsas.business.agencypay.AgencyPayWriteBackService;
import kd.swc.hsas.business.agencypay.payresult.vo.AgentPayResult;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class AgentPayResultWriteBackHelper {
    private static final Log logger = LogFactory.getLog(AgentPayResultWriteBackHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePayStatus(DynamicObject[] billDyns, DynamicObject[] detailDyns, Map<Long, DynamicObject> payDetailIdAndAgentEntryDynMap) {
        try (TXHandle tx = TX.requiresNew();){
            logger.info("[PayResult]AgentPayResultWriteBackHelper \u8d22\u52a1\u5de5\u8d44\u4ee3\u53d1\u5355\u53cd\u5199\u85aa\u8d44\u4ee3\u53d1\u5355\u4e8b\u52a1\u5f00\u542f...");
            AgentPayResultWriteBackHelper.updateAgentPayBillStatus(billDyns);
            AgentPayResultWriteBackHelper.updatePayDetailStatus(detailDyns, payDetailIdAndAgentEntryDynMap);
            logger.info("[PayResult]AgentPayResultWriteBackHelper \u8d22\u52a1\u5de5\u8d44\u4ee3\u53d1\u5355\u53cd\u5199\u85aa\u8d44\u4ee3\u53d1\u5355\u4e8b\u52a1\u5b8c\u6210...");
        }
    }

    public static void updateAgentPayBillStatus(DynamicObject[] billDyns) {
        logger.info("[PayResult]AgentPayResultWriteBackHelper \u66f4\u65b0\u4ee3\u53d1\u5355\u72b6\u6001\u5f00\u59cb...");
        if (billDyns == null) {
            return;
        }
        for (DynamicObject bill : billDyns) {
            DynamicObjectCollection ents = bill.getDynamicObjectCollection("entryentity");
            int paidCount = 0;
            int unpayCount = 0;
            int payFailed = 0;
            for (DynamicObject ent : ents) {
                String payState = ent.getString("paystate");
                if (SWCStringUtils.equals((String)"1", (String)payState)) {
                    ++paidCount;
                    continue;
                }
                if (SWCStringUtils.equals((String)"-1", (String)payState)) {
                    ++payFailed;
                    continue;
                }
                ++unpayCount;
            }
            if (unpayCount == 0) {
                bill.set("auditstatus", (Object)"K");
            } else if (paidCount == 0 && payFailed == 0) {
                bill.set("auditstatus", (Object)"B");
            } else {
                bill.set("auditstatus", (Object)"J");
            }
            bill.set("unpaycount", (Object)payFailed);
            bill.set("paidcount", (Object)paidCount);
        }
        new SWCDataServiceHelper("hsas_agencypaybill").update(billDyns);
        logger.info("[PayResult]AgentPayResultWriteBackHelper \u66f4\u65b0\u4ee3\u53d1\u5355\u72b6\u6001\u7ed3\u675f...");
    }

    public static void updatePayDetailStatus(DynamicObject[] detailDyns, Map<Long, DynamicObject> payDetailIdAndAgentEntryDynMap) {
        logger.info("[PayResult]AgentPayResultWriteBackHelper \u66f4\u65b0\u53d1\u653e\u660e\u7ec6\u72b6\u6001\u5f00\u59cb...");
        if (CollectionUtils.isEmpty(payDetailIdAndAgentEntryDynMap) || detailDyns == null) {
            return;
        }
        HashSet<Long> caltableIdSet = new HashSet<Long>(16);
        Date currTime = new Date();
        for (DynamicObject detail : detailDyns) {
            long detailId = detail.getLong("id");
            DynamicObject agentPayEntryDyn = payDetailIdAndAgentEntryDynMap.get(detailId);
            if (agentPayEntryDyn == null) continue;
            String agentPayState = agentPayEntryDyn.getString("paystate");
            Date payedTime = null;
            if (SWCStringUtils.equals((String)"1", (String)agentPayState)) {
                payedTime = currTime;
            }
            String detailPayState = AgentPayResultWriteBackHelper.getDetailPayState(agentPayState);
            detail.set("paystate", (Object)detailPayState);
            detail.set("payedtime", (Object)payedTime);
            caltableIdSet.add(detail.getLong("calpersonid"));
        }
        new SWCDataServiceHelper("hsas_paydetail").update(detailDyns);
        logger.info("[PayResult]AgentPayResultWriteBackHelper \u66f4\u65b0\u6838\u7b97\u5217\u8868\u6570\u636e\u5f00\u59cb...");
        new AgencyPayWriteBackService().updateCaltablePayState(caltableIdSet);
        logger.info("[PayResult]AgentPayResultWriteBackHelper \u66f4\u65b0\u6838\u7b97\u5217\u8868\u6570\u636e\u7ed3\u675f...");
        logger.info("[PayResult]AgentPayResultWriteBackHelper \u66f4\u65b0\u53d1\u653e\u660e\u7ec6\u72b6\u6001\u7ed3\u675f...");
    }

    public static String getDetailPayState(String agentPayState) {
        String detailPayState = SWCStringUtils.equals((String)"1", (String)agentPayState) ? PayStateEnum.PAID.getCode() : (SWCStringUtils.equals((String)"-1", (String)agentPayState) ? PayStateEnum.PAYFAIL.getCode() : PayStateEnum.PAYING.getCode());
        return detailPayState;
    }

    public static DynamicObject[] queryAgentPayBill(List<AgentPayResult> agentPayResults) {
        if (CollectionUtils.isEmpty(agentPayResults)) {
            return null;
        }
        Set<Long> agentPayBillIds = agentPayResults.stream().map(AgentPayResult::getPayBillId).collect(Collectors.toSet());
        return AgentPayResultWriteBackHelper.queryAgentPayBill(agentPayBillIds);
    }

    public static DynamicObject[] queryAgentPayBill(Set<Long> agentPayBillIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hsas_agencypaybill");
        QFilter qFilter = new QFilter("id", "in", agentPayBillIds);
        String fields = "auditstatus,unpaycount,paidcount,entryentity.id,entryentity.paydetail,entryentity.paystate,entryentity.failreason";
        return serviceHelper.query(fields, new QFilter[]{qFilter});
    }

    public static Map<Long, DynamicObject> transToPayBillEntryMap(DynamicObject[] query) {
        if (query == null) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashMap dbAgentPayBillEntryDyn = Maps.newHashMapWithExpectedSize((int)query.length);
        Arrays.stream(query).forEach(obj -> {
            DynamicObjectCollection entrys = obj.getDynamicObjectCollection("entryentity");
            entrys.forEach(en -> dbAgentPayBillEntryDyn.put(en.getLong("id"), en));
        });
        return dbAgentPayBillEntryDyn;
    }

    public static DynamicObject[] queryPayDetailDyns(Set<Long> payDetailIds) {
        if (CollectionUtils.isEmpty(payDetailIds)) {
            return null;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        String selectProperties = "id,paystate,calpersonid,payedtime,abandonedstatus,agencypaybill,acctmodifybill.billstatus";
        QFilter filter = new QFilter("id", "in", payDetailIds);
        QFilter[] filters = new QFilter[]{filter};
        return helper.query(selectProperties, filters);
    }

    public static Map<Long, DynamicObject> transToIdAndDynMap(DynamicObject[] query) {
        if (query == null || query.length == 0) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        return Arrays.stream(query).collect(Collectors.toMap(k1 -> k1.getLong("id"), k1 -> k1, (k1, k2) -> k1));
    }
}

