/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.agencypay.payresult.handler;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.agencypay.payresult.AgentPayResultWriteBackErrorEnum;
import kd.swc.hsas.business.agencypay.payresult.AgentPayResultWriteBackHelper;
import kd.swc.hsas.business.agencypay.payresult.handler.IAgentPayResultHandler;
import kd.swc.hsas.business.agencypay.payresult.vo.AgentPayResult;

public abstract class AgentPayResultBaseHandler
implements IAgentPayResultHandler {
    private static final Log logger = LogFactory.getLog(AgentPayResultBaseHandler.class);

    @Override
    public Object handPayResult(Map<String, Object> param) {
        String errorInfo;
        String code = "0";
        try {
            List<AgentPayResult> agentPayResults = this.parseParam(param);
            this.writeResultToAgentBill(agentPayResults, this.isOnlyValidate());
            errorInfo = this.getReturnMsg(agentPayResults);
            logger.info("[PayResult]AgentPayResultBaseHandler handPayResult agentPayResults is {}.", agentPayResults);
        }
        catch (Exception e) {
            logger.info("[PayResult]AgentPayResultBaseHandler handPayResult error:{}", (Object)e);
            errorInfo = ResManager.loadKDString((String)"\u85aa\u916c\u56de\u5199\u5f02\u5e38\uff1a%s\u3002", (String)"AgentPayResultBaseHandler_0", (String)"swc-hsas-business", (Object[])new Object[]{e.getMessage()});
        }
        if (!StringUtils.isEmpty((CharSequence)errorInfo)) {
            code = "500";
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)2);
        resultMap.put("code", code);
        resultMap.put("errorInfo", errorInfo);
        return resultMap;
    }

    protected void writeResultToAgentBill(List<AgentPayResult> agentPayResults, boolean isOnlyValidate) {
        if (CollectionUtils.isEmpty(agentPayResults)) {
            logger.info("[PayResult]AgentPayResultBaseHandler writeResultToAgentBill agentPayResults is null...");
            return;
        }
        DynamicObject[] billDyns = AgentPayResultWriteBackHelper.queryAgentPayBill(agentPayResults);
        Map<Long, DynamicObject> dbAgentPayBillEntryDyn = AgentPayResultWriteBackHelper.transToPayBillEntryMap(billDyns);
        HashMap payDetailIdAndAgentEntryDynMap = Maps.newHashMapWithExpectedSize((int)agentPayResults.size());
        boolean isValid = true;
        for (AgentPayResult payResult : agentPayResults) {
            long entryId = payResult.getPayBillEntryId();
            DynamicObject entryDyn = dbAgentPayBillEntryDyn.get(entryId);
            if (entryDyn == null) {
                payResult.writeBackFail(AgentPayResultWriteBackErrorEnum.COMMON_DATANOTEXIST.getErrorMsg());
                isValid = false;
                continue;
            }
            if (!this.validateAgentPayBill(payResult, entryDyn)) {
                isValid = false;
                continue;
            }
            long detailId = entryDyn.getLong("paydetail.id");
            payResult.setDetailId(detailId);
            payDetailIdAndAgentEntryDynMap.put(detailId, entryDyn);
            entryDyn.set("paystate", (Object)payResult.getPayState());
            entryDyn.set("failreason", (Object)payResult.getFailReason());
        }
        if (!isValid || isOnlyValidate && this.isFinishValidate()) {
            return;
        }
        DynamicObject[] detailDyns = AgentPayResultWriteBackHelper.queryPayDetailDyns(payDetailIdAndAgentEntryDynMap.keySet());
        Map<Long, DynamicObject> payDetailDynMap = AgentPayResultWriteBackHelper.transToIdAndDynMap(detailDyns);
        isValid = this.validatePayDetail(agentPayResults, payDetailDynMap);
        if (!isValid || isOnlyValidate) {
            return;
        }
        AgentPayResultWriteBackHelper.updatePayStatus(billDyns, detailDyns, payDetailIdAndAgentEntryDynMap);
    }

    protected boolean isFinishValidate() {
        return false;
    }

    protected boolean validatePayDetail(List<AgentPayResult> agentPayResults, Map<Long, DynamicObject> payDetailDynMap) {
        return true;
    }

    protected boolean validateAgentPayBill(AgentPayResult payResult, DynamicObject entryDyn) {
        return true;
    }

    protected boolean isOnlyValidate() {
        return false;
    }

    protected abstract List<AgentPayResult> parseParam(Map<String, Object> var1);

    protected abstract void fillAgentPayResult(AgentPayResult var1);

    private String getReturnMsg(List<AgentPayResult> agentPayResults) {
        if (CollectionUtils.isEmpty(agentPayResults)) {
            return "";
        }
        List msgs = agentPayResults.stream().filter(obj -> !obj.isWriteBackSuccess()).map(AgentPayResult::getBackFailReason).collect(Collectors.toList());
        return String.join((CharSequence)";", msgs);
    }
}

