/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.agencypay.payresult.handler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.agencypay.payresult.handler.AgentPayResultBaseHandler;
import kd.swc.hsas.business.agencypay.payresult.vo.AgentPayResult;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AgentPayResultForDynParamHandler
extends AgentPayResultBaseHandler {
    private static Log logger = LogFactory.getLog(AgentPayResultForDynParamHandler.class);

    @Override
    protected List<AgentPayResult> parseParam(Map<String, Object> param) {
        if (param == null) {
            logger.info("[PayResult]AgentPayResultForDynParamHandler parseParam param is null...");
            return null;
        }
        Object info = param.get("info");
        if (info == null) {
            logger.info("[PayResult]AgentPayResultForDynParamHandler parseParam info is null...");
            return null;
        }
        Object[] casAgentBillArr = (Object[])info;
        ArrayList agentPayResults = Lists.newArrayListWithCapacity((int)casAgentBillArr.length);
        for (Object casAgentBillObj : casAgentBillArr) {
            DynamicObject casAgentBill = (DynamicObject)casAgentBillObj;
            String failReason = casAgentBill.getString("reason");
            DynamicObjectCollection entry = casAgentBill.getDynamicObjectCollection("entry");
            for (DynamicObject ent : entry) {
                long srcBillId = ent.getLong("sourcebillid");
                long srcEntId = ent.getLong("sourceentryid");
                boolean isSuccess = ent.getBoolean("e_issuccess");
                AgentPayResult agentPayResult = new AgentPayResult(srcBillId, srcEntId, isSuccess, failReason);
                this.fillAgentPayResult(agentPayResult);
                agentPayResults.add(agentPayResult);
            }
        }
        return agentPayResults;
    }

    @Override
    public Object handPayResult(Map<String, Object> param) {
        Object map = super.handPayResult(param);
        if (map != null) {
            Map resultMap = (Map)map;
            if (this.isOnlyValidate() && !CollectionUtils.isEmpty((Map)resultMap)) {
                String code = MapUtils.getString((Map)resultMap, (Object)"code");
                if (StringUtils.equals((CharSequence)code, (CharSequence)"0")) {
                    return null;
                }
                return MapUtils.getString((Map)resultMap, (Object)"errorInfo");
            }
        }
        return null;
    }
}

