/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.agencypay.payresult.handler;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.agencypay.payresult.AgentPayResultWriteBackErrorEnum;
import kd.swc.hsas.business.agencypay.payresult.handler.AgentPayResultForMapParamHandler;
import kd.swc.hsas.business.agencypay.payresult.vo.AgentPayResult;
import kd.swc.hsbp.common.enums.PayStateEnum;

public class CancelRenoteResultHandler
extends AgentPayResultForMapParamHandler {
    @Override
    protected void fillAgentPayResult(AgentPayResult agentPayResult) {
        agentPayResult.setPayState("1");
        agentPayResult.setFailReason("");
    }

    @Override
    protected boolean validateAgentPayBill(AgentPayResult payResult, DynamicObject entryDyn) {
        String payState = entryDyn.getString("paystate");
        if (!StringUtils.equals((CharSequence)payState, (CharSequence)"-1")) {
            payResult.writeBackFail(AgentPayResultWriteBackErrorEnum.CANCELRENOTE_PAYSTATUS.getErrorMsg());
            return false;
        }
        return true;
    }

    @Override
    protected boolean validatePayDetail(List<AgentPayResult> agentPayResults, Map<Long, DynamicObject> payDetailDynMap) {
        if (CollectionUtils.isEmpty(agentPayResults)) {
            return true;
        }
        boolean isValid = true;
        for (AgentPayResult payResult : agentPayResults) {
            boolean isNewAgencyBill;
            long detailId = payResult.getDetailId();
            DynamicObject detailDyn = payDetailDynMap.get(detailId);
            if (detailDyn == null) {
                payResult.setFailReason(AgentPayResultWriteBackErrorEnum.CANCELRENOTE_DETAIL.getErrorMsg());
                isValid = false;
                continue;
            }
            boolean abandonedStatus = detailDyn.getBoolean("abandonedstatus");
            boolean isPayFail = StringUtils.equals((CharSequence)detailDyn.getString("paystate"), (CharSequence)PayStateEnum.PAYFAIL.getCode());
            String acctModifyBillStatus = detailDyn.getString("acctmodifybill.billstatus");
            boolean isNoAcctModify = StringUtils.isEmpty((CharSequence)acctModifyBillStatus) || StringUtils.equals((CharSequence)acctModifyBillStatus, (CharSequence)"E");
            boolean bl = isNewAgencyBill = payResult.getPayBillId() == detailDyn.getLong("agencypaybill.id");
            if (!abandonedStatus && isPayFail && isNoAcctModify && isNewAgencyBill) continue;
            payResult.writeBackFail(AgentPayResultWriteBackErrorEnum.CANCELRENOTE_DETAILSTATUS.getErrorMsg());
            isValid = false;
        }
        return isValid;
    }
}

