/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.approve;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IFormView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import org.apache.commons.lang.StringUtils;

public class ApproveBillTplService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMsg(Long pkId, String modifyType) {
        SWCDataServiceHelper approveBillTplHelper = new SWCDataServiceHelper("hsas_approvebilltpl");
        QFilter approveBillTplFilter = new QFilter("schemeentryentity.reportscheme.sourceid", "=", (Object)pkId);
        BaseDataHisHelper.addHisCurrFilter((QFilter)approveBillTplFilter);
        Object[] approveBillTplArr = approveBillTplHelper.query("id,name,creator.id,schemeentryentity.reportscheme, schemeentryentity.referreport", new QFilter[]{approveBillTplFilter});
        if (ArrayUtils.isEmpty((Object[])approveBillTplArr)) {
            return;
        }
        SWCDataServiceHelper approveSchemeMsgHelper = new SWCDataServiceHelper("hsas_approveschememsg");
        DynamicObjectCollection addApproveSchemeMsgs = new DynamicObjectCollection();
        Date nowDate = new Date();
        HashSet reportSchemeIdTemp = Sets.newHashSetWithExpectedSize((int)16);
        for (Object approveBillTplDy : approveBillTplArr) {
            DynamicObjectCollection schemeCollection = approveBillTplDy.getDynamicObjectCollection("schemeentryentity");
            reportSchemeIdTemp.clear();
            for (DynamicObject schemeDy : schemeCollection) {
                long sourceSchemeId = schemeDy.getLong("reportscheme.sourceid");
                long reportSchemeId = schemeDy.getLong("reportscheme.id");
                if (!SWCObjectUtils.equals((Object)sourceSchemeId, (Object)pkId) || !reportSchemeIdTemp.add(reportSchemeId)) continue;
                DynamicObject approveSchemeMsgDy = approveSchemeMsgHelper.generateEmptyDynamicObject();
                approveSchemeMsgDy.set("issolved", (Object)Boolean.FALSE);
                Long approveBillTplId = approveBillTplDy.getLong("id");
                approveSchemeMsgDy.set("approvebilltpl", (Object)approveBillTplId);
                approveSchemeMsgDy.set("reportscheme", (Object)reportSchemeId);
                Long userId = approveBillTplDy.getLong("creator.id");
                approveSchemeMsgDy.set("creator", (Object)userId);
                approveSchemeMsgDy.set("modifier", (Object)userId);
                approveSchemeMsgDy.set("createtime", (Object)nowDate);
                approveSchemeMsgDy.set("modifytime", (Object)nowDate);
                approveSchemeMsgDy.set("modifytype", (Object)modifyType);
                addApproveSchemeMsgs.add((Object)approveSchemeMsgDy);
            }
        }
        QFilter approveSchemeMsgFilter = new QFilter("reportscheme.sourceid", "=", (Object)pkId);
        approveSchemeMsgFilter.and(new QFilter("issolved", "=", (Object)Boolean.FALSE));
        try (TXHandle txHandle = TX.required();){
            approveSchemeMsgHelper.deleteByFilter(new QFilter[]{approveSchemeMsgFilter});
            approveSchemeMsgHelper.save(addApproveSchemeMsgs);
            txHandle.commit();
        }
    }

    public static List<QFilter> getSchemeFilters(ListShowParameter showParameter, IFormView view, String referReport, List<Long> sourceSchemeIds) {
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        Long userId = RequestContext.get().getCurrUserId();
        QFilter filterScheme = new QFilter("creator", "=", (Object)userId);
        filterScheme.or("sharescheme", "=", (Object)Boolean.TRUE);
        QFilter filter = new QFilter("reportformid", "not in", (Object)"hsas_calapprovebilldetail");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryrptdisplayschm");
        if (null != referReport) {
            if (StringUtils.equals((String)"1", (String)referReport)) {
                filter.and(new QFilter("reportformid", "in", (Object)"hsas_salarydetailrpt"));
                DynamicObject[] salaryRptArr = helper.query("id", new QFilter[]{filter, filterScheme});
                if (null == salaryRptArr || salaryRptArr.length == 0) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u62a5\u8868\u663e\u793a\u65b9\u6848\uff0c\u8bf7\u524d\u5f80\u201c\u85aa\u8d44\u62a5\u8868>\u5458\u5de5\u85aa\u8d44\u660e\u7ec6\u8868\u201d\u7ef4\u62a4\u62a5\u8868\u663e\u793a\u65b9\u6848\u3002", (String)"ApproveBillTplService_01", (String)"swc-hsas-business", (Object[])new Object[0]));
                    return null;
                }
            } else {
                filter.and(new QFilter("reportformid", "in", (Object)"hsas_salarysumrpt"));
                DynamicObject[] salaryRptArr = helper.query("id", new QFilter[]{filter, filterScheme});
                if (null == salaryRptArr || salaryRptArr.length == 0) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u62a5\u8868\u663e\u793a\u65b9\u6848\uff0c\u8bf7\u524d\u5f80\u201c\u85aa\u8d44\u62a5\u8868>\u85aa\u8d44\u6c47\u603b\u8868\u201d\u7ef4\u62a4\u62a5\u8868\u663e\u793a\u65b9\u6848\u3002", (String)"ApproveBillTplService_02", (String)"swc-hsas-business", (Object[])new Object[0]));
                    return null;
                }
            }
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5f15\u7528\u6570\u636e\u6e90\u201d\u3002", (String)"ApproveBillTplService_03", (String)"swc-hsas-business", (Object[])new Object[0]));
            return null;
        }
        qFilters.add(filterScheme);
        qFilters.add(filter);
        return qFilters;
    }

    public static List<Long> getSourceSchemeIds(DynamicObjectCollection schemeEntryEntity) {
        ArrayList<Long> schemeIds = new ArrayList<Long>(10);
        for (DynamicObject schemeDy : schemeEntryEntity) {
            Long schemeId = schemeDy.getLong("reportscheme.id");
            schemeIds.add(schemeId);
        }
        ArrayList<Long> sourceSchemeIds = new ArrayList<Long>(10);
        if (!CollectionUtils.isEmpty(schemeIds)) {
            DynamicObject[] schemeRptArr;
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryrptdisplayschm");
            QFilter filter = new QFilter("id", "in", schemeIds);
            for (DynamicObject schemeRptDy : schemeRptArr = helper.query("id, sourceid", new QFilter[]{filter})) {
                Long sourceId = schemeRptDy.getLong("sourceid");
                sourceSchemeIds.add(sourceId);
            }
        }
        return sourceSchemeIds;
    }

    public static List<QFilter> packageFilterForTpl(boolean isCurrentVersion) {
        return ApproveBillTplService.packageFilterForTpl(isCurrentVersion, "47150e89000000ac");
    }

    public static List<QFilter> packageFilterForTpl(Long orgId, boolean isCurrentVersion) {
        return ApproveBillTplService.packageFilterForTpl(orgId, isCurrentVersion, "47150e89000000ac");
    }

    public static List<QFilter> packageFilterForTpl(boolean isCurrentVersion, String permId) {
        HasPermOrgResult permOrg = SWCPermissionServiceHelper.getPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_approvebilltpl");
        if (permOrg.hasAllOrgPerm()) {
            return Lists.newArrayList((Object[])new QFilter[]{new QFilter("1", "=", (Object)1)});
        }
        List hasPermOrgIds = permOrg.getHasPermOrgs();
        if (CollectionUtils.isEmpty((Collection)hasPermOrgIds)) {
            return Lists.newArrayList((Object[])new QFilter[]{new QFilter("1", "=", (Object)2)});
        }
        return ApproveBillTplService.packageFilterForTpl(hasPermOrgIds, isCurrentVersion, permId);
    }

    public static List<QFilter> packageFilterForTpl(List<Long> orgIds, boolean isCurrentVersion, String permId) {
        List filter;
        ArrayList allFilters = Lists.newArrayListWithExpectedSize((int)5);
        QFilter permFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsas_approvebilltpl", orgIds, (boolean)true);
        List nests = permFilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            QFilter nestFilter = nest.getFilter();
            String property = nestFilter.getProperty();
            if (!"id".equals(property)) continue;
            String value = (String)nestFilter.getValue();
            value = value.replace(" fid ", " fboid ");
            value = value.replace(" FID ", " FBOID ");
            nestFilter.__setProperty("boid");
            nestFilter.__setValue((Object)value);
        }
        allFilters.add(permFilter);
        allFilters.add(new QFilter("iseffect", "=", (Object)Boolean.TRUE));
        if (isCurrentVersion) {
            allFilters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        }
        if ((filter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_approvebilltpl", (String)permId)) != null) {
            allFilters.addAll(filter);
        } else {
            allFilters.add(new QFilter("1", "!=", (Object)1));
        }
        return allFilters;
    }

    public static List<QFilter> packageFilterForTpl(Long orgId, boolean isCurrentVersion, String permId) {
        List filter;
        ArrayList allFilters = Lists.newArrayListWithExpectedSize((int)5);
        allFilters.add(SWCPermissionServiceHelper.getBaseDataFilter((String)"hsas_approvebilltpl", (Long)orgId));
        allFilters.add(new QFilter("iseffect", "=", (Object)Boolean.TRUE));
        if (isCurrentVersion) {
            allFilters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        }
        if ((filter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_approvebilltpl", (String)permId)) != null) {
            allFilters.addAll(filter);
        } else {
            allFilters.add(new QFilter("1", "!=", (Object)1));
        }
        return allFilters;
    }

    public static QFilter packageTplFilterForSchemeMsg() {
        HasPermOrgResult permOrg = SWCPermissionServiceHelper.getPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_approvebilltpl");
        QFilter result = new QFilter("approvebilltpl.status", "!=", (Object)"B");
        result.and(new QFilter("approvebilltpl.enable", "!=", (Object)"0"));
        if (permOrg.hasAllOrgPerm()) {
            return result;
        }
        List hasPermOrgs = permOrg.getHasPermOrgs();
        if (CollectionUtils.isEmpty((Collection)hasPermOrgs)) {
            return new QFilter("1", "=", (Object)2);
        }
        result.and(new QFilter("approvebilltpl.createorg.id", "in", (Object)hasPermOrgs));
        List filter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_approvebilltpl", (String)"47150e89000000ac");
        if (filter != null) {
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_approvebilltpl");
            Object[] ids = serviceHelper.queryOriginalArray("id", filter.toArray(new QFilter[0]));
            if (ArrayUtils.isEmpty((Object[])ids)) {
                result.and(new QFilter("1", "!=", (Object)1));
            } else {
                result.and(new QFilter("approvebilltpl.id", "in", Arrays.stream(ids).map(ele -> ele.getLong("id")).collect(Collectors.toList())));
            }
        } else {
            result.and(new QFilter("1", "!=", (Object)1));
        }
        return result;
    }
}

