/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.assignbankcard;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.assignbankcard.AssignBankCardDTO;
import kd.swc.hsas.business.paysalarysetting.PaySalarySettingHelper;
import kd.swc.hsas.business.paysalarysetting.paysetting.thread.UpdatePaySettingThread;
import kd.swc.hsas.common.constants.AssignBankCardConstants;
import kd.swc.hsas.common.dto.PersonRangeDTO;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;

public class AssignBankCardHelper
implements AssignBankCardConstants {
    private static final Log logger = LogFactory.getLog(UpdatePaySettingThread.class);

    public static DynamicObject[] findDetailAbleToAssign(List<Long> payDetailIdList) {
        SWCDataServiceHelper detailHelper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter detailFilter = new QFilter("id", "in", payDetailIdList);
        detailFilter.and("ismustbankcard", "=", (Object)Boolean.TRUE);
        detailFilter.and("abandonedstatus", "=", (Object)Boolean.FALSE);
        String[] onHoldStatusStr = new String[]{String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()), " "};
        QFilter onHoldFilter = new QFilter("onholdstatus", "in", (Object)onHoldStatusStr);
        onHoldFilter.or("onholdstatus", "is null", null);
        detailFilter.and(onHoldFilter);
        QFilter perBankCardFilter = new QFilter("perbankcard.id", "=", (Object)0L);
        perBankCardFilter.or("perbankcard.id", "is null", null);
        detailFilter.and(perBankCardFilter);
        QFilter billStatusFilter = new QFilter("acctmodifybill.billstatus", "=", (Object)"E");
        billStatusFilter.or("acctmodifybill.billstatus", "=", (Object)" ");
        billStatusFilter.or("acctmodifybill.billstatus", "is null", null);
        detailFilter.and(billStatusFilter);
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_paydetail", (String)"47150e89000000ac");
        if (authorizedDataRuleQFilter == null) {
            detailFilter.and(new QFilter("1", "!=", (Object)1));
            logger.info("have no right filter to assign bank card for these details.");
        } else {
            for (QFilter filter : authorizedDataRuleQFilter) {
                detailFilter.and(filter);
            }
            logger.info("add right filters to assign bank card for these details.");
        }
        DynamicObject[] paydetailResults = detailHelper.loadDynamicObjectArray(new QFilter[]{detailFilter});
        return paydetailResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBankCardForBatchDetail(List<AssignBankCardDTO> dtoForSetCardList) {
        int index = 0;
        DynamicObject[] payDetails = new DynamicObject[dtoForSetCardList.size()];
        HashSet<Long> calPersonSet = new HashSet<Long>(16);
        for (AssignBankCardDTO assignBankCardDTO : dtoForSetCardList) {
            DynamicObject payDetail = assignBankCardDTO.getPayDetail();
            Long chosenPerBankCard = assignBankCardDTO.getChosenPerBankCard();
            payDetail.set("perbankcard", (Object)chosenPerBankCard);
            payDetail.set("bank", (Object)assignBankCardDTO.getChosenBankId());
            payDetails[index++] = payDetail;
            calPersonSet.add(payDetail.getLong("calpersonid"));
        }
        DynamicObject[] calPersons = AssignBankCardHelper.setCalPersonModify(calPersonSet);
        try (TXHandle txHandle = TX.requiresNew();){
            SWCDataServiceHelper payDetailHelper = new SWCDataServiceHelper("hsas_paydetail");
            payDetailHelper.update(payDetails);
            SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
            calPersonHelper.save(calPersons);
        }
    }

    private static DynamicObject[] setCalPersonModify(Set<Long> calPersonSet) {
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", calPersonSet);
        DynamicObject[] calPersons = calPersonHelper.query("modifier,modifytime", new QFilter[]{filter});
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        for (DynamicObject calPerson : calPersons) {
            calPerson.set("modifier", (Object)currUserId);
            calPerson.set("modifytime", (Object)date);
        }
        return calPersons;
    }

    public static void setPaySettingEntryIdForBatchDTO(List<AssignBankCardDTO> assignBankCardDTOList) {
        try {
            assignBankCardDTOList.forEach(assignBankCardDTO -> {
                DynamicObject payDetail = assignBankCardDTO.getPayDetail();
                Long paySettingEntryId = payDetail.getLong("paysettingentryid");
                assignBankCardDTO.setPaySettingEntryId(paySettingEntryId);
            });
        }
        catch (Exception e) {
            logger.error("setPaySettingEntryIdForBatchDTOError:", (Throwable)e);
        }
    }

    public static void setSeqForBatchDTO(List<AssignBankCardDTO> assignBankCardDTOList) {
        try {
            HashSet paySettingIds = Sets.newHashSetWithExpectedSize((int)16);
            HashMap paySettingEntryCollectionMap = Maps.newHashMapWithExpectedSize((int)16);
            assignBankCardDTOList.forEach(assignBankCardDTO -> {
                DynamicObject paySetting = assignBankCardDTO.getPaySetting();
                Long paySettingId = paySetting.getLong("id");
                paySettingIds.add(paySettingId);
            });
            SWCDataServiceHelper entryHelper = new SWCDataServiceHelper("hsas_paysetting");
            QFilter[] entryFilters = new QFilter[]{new QFilter("id", "in", (Object)paySettingIds)};
            DynamicObject[] paySettingQuerys = entryHelper.query("id,entryentity,entryentity.id,entryentity.seq", entryFilters);
            Stream.of(paySettingQuerys).forEach(paySettingQuery -> {
                Long paySettingId = paySettingQuery.getLong("id");
                DynamicObjectCollection entryEntity = paySettingQuery.getDynamicObjectCollection("entryentity");
                paySettingEntryCollectionMap.put(paySettingId, entryEntity);
            });
            assignBankCardDTOList.forEach(assignBankCardDTO -> {
                Long paySettingEntryId = assignBankCardDTO.getPaySettingEntryId();
                DynamicObject paySetting = assignBankCardDTO.getPaySetting();
                Long paySettingId = paySetting.getLong("id");
                DynamicObjectCollection entryEntity = (DynamicObjectCollection)paySettingEntryCollectionMap.get(paySettingId);
                for (DynamicObject entry : entryEntity) {
                    Long entryId = entry.getLong("id");
                    Integer seq = entry.getInt("seq");
                    if (!paySettingEntryId.equals(entryId)) continue;
                    assignBankCardDTO.setSeq(seq);
                }
            });
        }
        catch (Exception e) {
            logger.error("setSeqForBatchDTOError:", (Throwable)e);
        }
    }

    public static void setSalaryFileForBatchDTO(List<AssignBankCardDTO> assignBankCardDTOList) {
        try {
            Set salaryFileIds = assignBankCardDTOList.stream().map(data -> data.getPayDetail().getLong("salaryfilehis.id")).collect(Collectors.toSet());
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
            String selectProperties = "id,org,status,payrollregion,employee,number,depcytype,payrollgroup,empgroup,payrollregion,person,adminorg.name,laborrelrecord.lawentity.name";
            QFilter salaryFileFilter = new QFilter("id", "in", salaryFileIds);
            QFilter[] filters = new QFilter[]{salaryFileFilter};
            DynamicObject[] query = helper.query(selectProperties, filters);
            HashMap<Long, DynamicObject> salaryFileMap = new HashMap<Long, DynamicObject>(query.length);
            for (DynamicObject salaryFile : query) {
                salaryFileMap.put(salaryFile.getLong("id"), salaryFile);
            }
            assignBankCardDTOList.forEach(assignBankCardDTO -> {
                DynamicObject payDetail = assignBankCardDTO.getPayDetail();
                DynamicObject salaryFile = payDetail.getDynamicObject("salaryfilehis");
                assignBankCardDTO.setSalaryFile((DynamicObject)salaryFileMap.get(salaryFile.getLong("id")));
            });
        }
        catch (Exception e) {
            logger.error("setSalaryFileForBatchDTOError:", (Throwable)e);
        }
    }

    public static void setPaySettingForBatchDTO(List<AssignBankCardDTO> assignBankCardDTOList) {
        try {
            assignBankCardDTOList.forEach(assignBankCardDTO -> {
                DynamicObject payDetail = assignBankCardDTO.getPayDetail();
                DynamicObject paySetting = payDetail.getDynamicObject("paysettinghis");
                assignBankCardDTO.setPaySetting(paySetting);
            });
        }
        catch (Exception e) {
            logger.error("setPaySettingForBatchDTOError:", (Throwable)e);
        }
    }

    public static void setEableBankCardSetForBatchDTO(List<AssignBankCardDTO> assignBankCardDTOList) {
        try {
            DynamicObject[] perBankCardObjects;
            ArrayList personIdList = Lists.newArrayListWithExpectedSize((int)10);
            HashMap personIdPerBankCardListMap = Maps.newHashMapWithExpectedSize((int)16);
            assignBankCardDTOList.forEach(assignBankCardDTO -> {
                DynamicObject salaryFile = assignBankCardDTO.getSalaryFile();
                Long personId = salaryFile.getLong("person.id");
                personIdList.add(personId);
            });
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hrpi_perbankcard");
            String selectProperties = "id,person.id,accountrelation.id,cardpurpose,sourcevid,bankdeposit.id";
            QFilter filter = new QFilter("person.id", "in", (Object)personIdList);
            filter.and("isdelete", "=", (Object)Boolean.FALSE);
            BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
            QFilter[] filters = new QFilter[]{filter};
            for (DynamicObject perBankCardObject : perBankCardObjects = helper.query(selectProperties, filters)) {
                Long personId = perBankCardObject.getLong("person.id");
                List perBankCardObjectList = personIdPerBankCardListMap.getOrDefault(personId, Lists.newArrayListWithExpectedSize((int)10));
                perBankCardObjectList.add(perBankCardObject);
                personIdPerBankCardListMap.put(personId, perBankCardObjectList);
            }
            assignBankCardDTOList.forEach(assignBankCardDTO -> {
                DynamicObject salaryFile = assignBankCardDTO.getSalaryFile();
                Long personId = salaryFile.getLong("person.id");
                List perBankCardIdList = (List)personIdPerBankCardListMap.get(personId);
                assignBankCardDTO.setPerBankCardList(perBankCardIdList);
            });
        }
        catch (Exception e) {
            logger.error("setEableBankCardSetForBatchDTOError:", (Throwable)e);
        }
    }

    public static void setPersonRangeForBatchDTO(List<AssignBankCardDTO> assignBankCardDTOList) {
        try {
            HashMap payRuleMap = new HashMap(16);
            HashMap<Long, List> payRuleSalaryFileIdListMap = new HashMap<Long, List>(16);
            HashMap personFileInfo = new HashMap(16);
            assignBankCardDTOList.forEach(assignBankCardDTO -> {
                DynamicObject payRule = assignBankCardDTO.getPayRule();
                DynamicObject salaryFile = assignBankCardDTO.getSalaryFile();
                if (payRule != null) {
                    Long payRuleId = payRule.getLong("id");
                    payRuleMap.put(payRuleId, payRule);
                    List salaryIdList = payRuleSalaryFileIdListMap.getOrDefault(payRuleId, new ArrayList(10));
                    salaryIdList.add(salaryFile.getLong("id"));
                    payRuleSalaryFileIdListMap.put(payRuleId, salaryIdList);
                }
            });
            payRuleSalaryFileIdListMap.forEach((payRuleId, idList) -> {
                DynamicObject payRule = (DynamicObject)payRuleMap.get(payRuleId);
                PaySalarySettingHelper.getSalaryFilePersonRangeRule(payRule, idList, personFileInfo);
            });
            assignBankCardDTOList.forEach(assignBankCardDTO -> {
                DynamicObject salaryFile = assignBankCardDTO.getSalaryFile();
                PersonRangeDTO personRangeDTO = (PersonRangeDTO)personFileInfo.get(salaryFile.getLong("id"));
                assignBankCardDTO.setPersonRange(personRangeDTO);
            });
        }
        catch (Exception e) {
            logger.error("setCurrencyForBatchDTOError:", (Throwable)e);
        }
    }
}

