/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.assignbankcard;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.assignbankcard.AssignBankCardDTO;
import kd.swc.hsas.business.assignbankcard.AssignBankCardHelper;
import kd.swc.hsas.business.assignbankcard.AssignBankCardType;
import kd.swc.hsas.business.assignbankcard.MatchBankCardByRuleStrategy;
import kd.swc.hsas.business.paysalarysetting.paysetting.thread.UpdatePaySettingThread;

public class MatchBankCardByRuleThread
implements Runnable {
    private static final Log logger = LogFactory.getLog(UpdatePaySettingThread.class);
    private RequestContext requestContext;
    private CountDownLatch countDownLatch;
    private List<AssignBankCardDTO> dtoSplit;
    private AssignBankCardType assignBankCardType;
    private List<AssignBankCardDTO> dtoForSetCardList;

    public MatchBankCardByRuleThread(RequestContext requestContext, CountDownLatch countDownLatch, List<AssignBankCardDTO> dtoSplit, AssignBankCardType assignBankCardType) {
        this.requestContext = requestContext;
        this.countDownLatch = countDownLatch;
        this.dtoSplit = dtoSplit;
        this.assignBankCardType = assignBankCardType;
        this.dtoForSetCardList = Lists.newArrayListWithCapacity((int)10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<AssignBankCardDTO> detailCardMatchByRule = this.assignBankCardType.getDetailCardMatchByRule();
        List<AssignBankCardDTO> detailNeedManuallyAssign = this.assignBankCardType.getDetailNeedManuallyAssign();
        ArrayList failList = Lists.newArrayListWithExpectedSize((int)10);
        try {
            RequestContext.copyAndSet((RequestContext)this.requestContext);
            this.batchSetAssignBankCardDTO(this.dtoSplit);
            MatchBankCardByRuleStrategy matchBankCardByRuleStrategy = new MatchBankCardByRuleStrategy();
            for (AssignBankCardDTO assignBankCardDTO : this.dtoSplit) {
                boolean success = matchBankCardByRuleStrategy.matchBankCard(assignBankCardDTO);
                if (success) {
                    this.dtoForSetCardList.add(assignBankCardDTO);
                    continue;
                }
                failList.add(assignBankCardDTO);
            }
            if (this.dtoForSetCardList.size() != 0) {
                AssignBankCardHelper.setBankCardForBatchDetail(this.dtoForSetCardList);
            }
        }
        catch (Exception e) {
            logger.error("Match Bank Card Thread Exception:", (Throwable)e);
            failList.addAll(this.dtoSplit);
        }
        finally {
            detailCardMatchByRule.removeIf(DTO -> failList.contains(DTO));
            detailNeedManuallyAssign.addAll(failList);
            this.countDownLatch.countDown();
        }
    }

    private void batchSetAssignBankCardDTO(List<AssignBankCardDTO> dtoSplit) {
        AssignBankCardHelper.setPaySettingEntryIdForBatchDTO(dtoSplit);
        AssignBankCardHelper.setSalaryFileForBatchDTO(dtoSplit);
        AssignBankCardHelper.setPaySettingForBatchDTO(dtoSplit);
        AssignBankCardHelper.setSeqForBatchDTO(dtoSplit);
        AssignBankCardHelper.setEableBankCardSetForBatchDTO(dtoSplit);
        AssignBankCardHelper.setPersonRangeForBatchDTO(dtoSplit);
    }
}

