/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.attbizdata;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import org.apache.commons.collections.MapUtils;

public class AttBizDataListHelper {
    private static final Log LOGGER = LogFactory.getLog(AttBizDataListHelper.class);
    public static final String KEY_SHOWTYPE = "showType";
    public static final String KEY_HORIZONTALTAB = "horizontaltab";
    public static final String KEY_LONGITUDINALTAB = "longitudinaltab";
    public static final String OP_VIEWHISATT = "donothing_viewhisatt";
    public static final String OP_CLOSE = "close";
    public static final String FILTERPANELAP = "filterpanelap";
    public static final String LISTPANELAP = "listpanelap";

    public static String openPopPage(String billFormId, String formId, String targetKey, ShowType showType, IFormView view) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(billFormId);
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)listShowParameter);
        listShowParameter.setFormId(formId);
        listShowParameter.setSendToClient(true);
        listShowParameter.getOpenStyle().setShowType(showType);
        listShowParameter.getOpenStyle().setTargetKey(targetKey);
        view.showForm((FormShowParameter)listShowParameter);
        return listShowParameter.getPageId();
    }

    public QFilter buildUsageCountOptionFilter(Object value) {
        List<String> valueList = new ArrayList(4);
        if (!SWCObjectUtils.isEmpty((Object)value) && value instanceof String) {
            String str = value.toString();
            valueList.add(str);
        } else {
            valueList = (List)value;
        }
        QFilter filter0 = null;
        QFilter filter1 = null;
        QFilter filter2 = null;
        QFilter filter3 = null;
        Iterator iterator = valueList.iterator();
        while (iterator.hasNext()) {
            String valueStr;
            switch (valueStr = (String)iterator.next()) {
                case "0": {
                    filter0 = new QFilter("usagecount", "=", (Object)0);
                    break;
                }
                case "1": {
                    filter1 = new QFilter("usagecount", "=", (Object)1);
                    break;
                }
                case "2": {
                    filter2 = new QFilter("usagecount", ">=", (Object)1);
                    break;
                }
                case "3": {
                    filter3 = new QFilter("usagecount", ">", (Object)1);
                    break;
                }
            }
        }
        QFilter newFilter = null;
        if (filter0 != null) {
            if (newFilter != null) {
                newFilter.or(filter0);
            } else {
                newFilter = filter0;
            }
        }
        if (filter1 != null) {
            if (newFilter != null) {
                newFilter.or(filter1);
            } else {
                newFilter = filter1;
            }
        }
        if (filter2 != null) {
            if (newFilter != null) {
                newFilter.or(filter2);
            } else {
                newFilter = filter2;
            }
        }
        if (filter3 != null) {
            if (newFilter != null) {
                newFilter.or(filter3);
            } else {
                newFilter = filter3;
            }
        }
        return newFilter;
    }

    public QFilter buildUsageCountOptionFilter(Object usageCount, String filedKey) {
        String str = String.valueOf(usageCount);
        String[] usageCountArr = str.split(",");
        QFilter filter0 = null;
        QFilter filter1 = null;
        QFilter filter2 = null;
        QFilter filter3 = null;
        String[] stringArray = usageCountArr;
        int n = stringArray.length;
        block12: for (int i = 0; i < n; ++i) {
            String valueStr;
            switch (valueStr = stringArray[i]) {
                case "0": {
                    filter0 = new QFilter(filedKey, "=", (Object)0);
                    continue block12;
                }
                case "1": {
                    filter1 = new QFilter(filedKey, "=", (Object)1);
                    continue block12;
                }
                case "2": {
                    filter2 = new QFilter(filedKey, ">=", (Object)1);
                    continue block12;
                }
                case "3": {
                    filter3 = new QFilter(filedKey, ">", (Object)1);
                    continue block12;
                }
            }
        }
        QFilter newFilter = null;
        if (filter0 != null) {
            if (newFilter != null) {
                newFilter.or(filter0);
            } else {
                newFilter = filter0;
            }
        }
        if (filter1 != null) {
            if (newFilter != null) {
                newFilter.or(filter1);
            } else {
                newFilter = filter1;
            }
        }
        if (filter2 != null) {
            if (newFilter != null) {
                newFilter.or(filter2);
            } else {
                newFilter = filter2;
            }
        }
        if (filter3 != null) {
            if (newFilter != null) {
                newFilter.or(filter3);
            } else {
                newFilter = filter3;
            }
        }
        return newFilter;
    }

    public QFilter getMonthAndYearFilter(QFilter filter) {
        QFilter[] filters = filter.recombine();
        QFilter startDateFilter = null;
        QFilter endDateFilter = null;
        for (QFilter oldFilter : filters) {
            if (startDateFilter == null) {
                startDateFilter = new QFilter("attstartdate", oldFilter.getCP(), oldFilter.getValue());
            } else {
                startDateFilter.and(new QFilter("attstartdate", oldFilter.getCP(), oldFilter.getValue()));
            }
            if (endDateFilter == null) {
                endDateFilter = new QFilter("attenddate", oldFilter.getCP(), oldFilter.getValue());
                continue;
            }
            endDateFilter.and(new QFilter("attenddate", oldFilter.getCP(), oldFilter.getValue()));
        }
        if (startDateFilter != null && endDateFilter != null) {
            startDateFilter.and(endDateFilter);
        }
        QFilter newFilter = startDateFilter;
        return newFilter;
    }

    public QFilter getMonthAndYearFilter(HashMap<String, Object> paramMap, String startDateKey, String endDateKey) {
        Date startDate = (Date)paramMap.get("attstartdate");
        Date endDate = (Date)paramMap.get("attenddate");
        QFilter newFilter = new QFilter(startDateKey, ">=", (Object)startDate).and(endDateKey, "<", (Object)endDate);
        return newFilter;
    }

    public QFilter getAttBizDataBizItemFilter(String entityName, String permItemId) {
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)entityName, (String)permItemId);
        if (hasPermOrgResult.hasAllOrgPerm()) {
            return new QFilter("1", "=", (Object)1);
        }
        List allOrgList = hasPermOrgResult.getHasPermOrgs();
        QFilter orgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_attbizitem", (List)allOrgList, (boolean)true);
        return orgFilter;
    }

    public DynamicObjectCollection getDepEmp(QFilter[] filters) {
        SWCDataServiceHelper salaryFileHelper = new SWCDataServiceHelper("hrpi_depemp");
        return salaryFileHelper.queryOriginalCollection("id,person.name", filters);
    }

    public DynamicObject[] getDepEmp(List<QFilter> depEmpFilterList, List<QFilter> filters) {
        if (filters != null) {
            depEmpFilterList.addAll(filters);
        }
        QFilter[] depEmpFilters = new QFilter[depEmpFilterList.size()];
        depEmpFilters = depEmpFilterList.toArray(depEmpFilters);
        SWCDataServiceHelper salaryFileHelper = new SWCDataServiceHelper("hrpi_depemp");
        return salaryFileHelper.query("id,person.name,isprimary ,employee.id,person,adminorg,number", depEmpFilters, "isprimary desc, startdate desc");
    }

    @NotNull
    public List<QFilter> getAttBizdataFilterList(String allFilterListStr) {
        HashMap paramMap = (HashMap)SerializationUtils.deSerializeFromBase64((String)allFilterListStr);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(paramMap.size());
        if (MapUtils.isNotEmpty((Map)paramMap)) {
            Object usageCount;
            Object monthAndYear;
            Object auditStatus;
            Object attItem;
            Object depemp = paramMap.get("depemp");
            if (!ObjectUtils.isEmpty(depemp)) {
                QFilter filter = new QFilter("depemp.id", "in", depemp);
                filters.add(filter);
            }
            if (!ObjectUtils.isEmpty(attItem = paramMap.get("attbizitem"))) {
                QFilter filter = new QFilter("attbizitem", "in", attItem);
                filters.add(filter);
            }
            if (!ObjectUtils.isEmpty(auditStatus = paramMap.get("auditstatus"))) {
                QFilter filter = new QFilter("auditstatus", "in", (Object)((String)auditStatus).split(","));
                filters.add(filter);
            }
            if (!ObjectUtils.isEmpty(monthAndYear = paramMap.get("monthandyearoption"))) {
                QFilter filter = this.getMonthAndYearFilter(paramMap, "attstartdate", "attenddate");
                filters.add(filter);
            }
            if (!ObjectUtils.isEmpty(usageCount = paramMap.get("usagecountoption"))) {
                QFilter filter = this.buildUsageCountOptionFilter(usageCount, "usagecount");
                filters.add(filter);
            }
        }
        return filters;
    }

    public static void openHisAttPop(Map<String, Object> paramMap, IFormView view) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_attviewhis");
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)showParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("params", (Object)kd.bos.login.actions.SerializationUtils.serializeToBase64(paramMap));
        view.showForm(showParameter);
    }
}

