/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.attintegrate;

import java.util.HashMap;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.mq.AttIntegratePublisher;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.MessageStateEnum;

public class AttIntegrateBatchMsgPublishTask
implements Callable {
    private static final Log LOGGER = LogFactory.getLog(AttIntegrateBatchMsgPublishTask.class);
    private RequestContext requestContext;

    public AttIntegrateBatchMsgPublishTask(RequestContext requestContext) {
        this.requestContext = requestContext;
        Thread.currentThread().setUncaughtExceptionHandler((thread, exception) -> LOGGER.warn("AttIntegrateBatchMsgPublishTask Error occurs", exception));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call() throws Exception {
        if (this.requestContext != null) {
            RequestContext.copyAndSet((RequestContext)this.requestContext);
        }
        RequestContext currentContext = RequestContext.get();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_attintegbatchlog");
        DynamicObject[] batchLogs = helper.query("id,msgstate,creator.id", new QFilter[]{new QFilter("msgstate", "=", (Object)"0")});
        try {
            for (DynamicObject batchLog : batchLogs) {
                Long batchLogId = batchLog.getLong("id");
                Long creatorId = batchLog.getLong("creator.id");
                if (this.requestContext == null) {
                    RequestContextCreator.createBatch((String)currentContext.getTenantId(), (String)currentContext.getAccountId(), (String)String.valueOf(creatorId), (long)currentContext.getOrgId(), (Lang)currentContext.getLang(), (boolean)false);
                }
                HashMap<String, Object> param = new HashMap<String, Object>(2);
                param.put("batchLogId", batchLogId);
                param.put("creatorId", creatorId);
                AttIntegratePublisher.publishIntegrateBatchMsg(param);
                batchLog.set("msgstate", (Object)MessageStateEnum.COMPLETE.getCode());
                helper.saveOne(batchLog);
            }
        }
        finally {
            RequestContext.copyAndSet((RequestContext)currentContext);
        }
        return null;
    }
}

