/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bankoffer;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hsas.business.extpoint.paydetail.IBankOfferExtService;
import kd.sdk.swc.hsas.common.events.paydetail.BankOfferExportSplitEvent;
import kd.sdk.swc.hsas.common.events.paydetail.BankOfferExportSplitResult;
import kd.swc.hsas.business.bankoffer.BankOfferHelper;
import kd.swc.hsas.business.bankoffer.BankOfferServiceImpl;
import kd.swc.hsas.business.bankoffer.thread.BankOfferExportThread;
import kd.swc.hsas.common.dto.BankOfferBatchExportDTO;
import kd.swc.hsas.common.dto.BankOfferExportErrorDTO;
import kd.swc.hsas.common.dto.BankOfferExportFiledDTO;
import kd.swc.hsas.common.dto.BankOfferProgressInfo;
import kd.swc.hsas.common.dto.BankOfferSelectTplDTO;
import kd.swc.hsas.common.enums.BankOfferEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;

public class BankOfferExportService {
    private static final Log logger = LogFactory.getLog(BankOfferExportService.class);
    private static final HashSet NOT_PAY_DETAIL_FILED = new LinkedHashSet(16);

    public void checkPayDetailByBankOfferTpl(List<Long> payDetailIds, List<BankOfferSelectTplDTO> selectBankList, String recordId, IFormView view, Map<String, Object> map) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_BANKOFFER_%s", recordId));
        if (appCache == null) {
            return;
        }
        BankOfferExportSplitEvent exportSplitEvent = new BankOfferExportSplitEvent(Collections.unmodifiableList(payDetailIds));
        this.beforeBankOfferSplit(exportSplitEvent);
        Map payDetailErrorMap = exportSplitEvent.getPayDetailErrorMap();
        int totalNum = payDetailIds.size();
        Map<Long, DynamicObject> bankOfferTplMap = this.buildBankOfferTplMap(exportSplitEvent, selectBankList);
        HashMap<String, List<Long>> dataSourceMap = new HashMap<String, List<Long>>(selectBankList.size());
        boolean isSpilt = this.buildBankOfferSelectTpl(exportSplitEvent, payDetailIds, bankOfferTplMap, selectBankList, dataSourceMap);
        if (!isSpilt) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"BankOfferExportService_4", (String)"swc-hsas-business", (Object[])new Object[0]));
            return;
        }
        StringBuilder bankOfferTplName = new StringBuilder();
        selectBankList.forEach(bank -> bankOfferTplName.append(bank.getBankOfferTplName()));
        this.createBaskgroundTask(appCache, view, bankOfferTplName.toString(), map);
        ArrayList<Long> payDetailEnableAllIds = new ArrayList<Long>(10);
        HashSet<Long> calPersonAllIds = new HashSet<Long>(10);
        ArrayList<String> batchIdIds = new ArrayList<String>(selectBankList.size());
        appCache.put(String.format(Locale.ROOT, "isCancel_%s", recordId), (Object)Boolean.FALSE);
        appCache.put(String.format(Locale.ROOT, "isProgressBall_%s", recordId), (Object)Boolean.FALSE);
        this.setBankOfferStartProgressInfo(recordId, totalNum);
        for (BankOfferSelectTplDTO selectBank : selectBankList) {
            Long bankOfferTplId = selectBank.getBankOfferTplId();
            DynamicObject bankOfferTpl = bankOfferTplMap.get(bankOfferTplId);
            if (bankOfferTpl == null) {
                logger.info("bankOfferTpl is null : %s", (Object)bankOfferTplId);
                continue;
            }
            Set<String> fileTableHeadSet = this.getFileTableHeadValue(bankOfferTpl);
            List<BankOfferExportFiledDTO> exportFileDTO = this.getExportFileDTO(bankOfferTpl);
            ArrayList<Long> payDetailEnableIds = new ArrayList<Long>(10);
            HashSet<Long> calPersonIds = new HashSet<Long>(10);
            List payDetailDataList = (List)dataSourceMap.get(selectBank.getId());
            DynamicObject[] dynamicObjects = this.getPayDetailValueByIds(payDetailDataList, selectBank.getBankCgSettingId(), selectBank.getNoAcctExport(), selectBank.getMul());
            if (dynamicObjects == null || dynamicObjects.length == 0) continue;
            this.setPayDetailBankOfferStatus(dynamicObjects, payDetailEnableIds, calPersonIds);
            try {
                payDetailIds.removeAll(payDetailEnableIds);
                payDetailEnableAllIds.addAll(payDetailEnableIds);
                calPersonAllIds.addAll(calPersonIds);
                String batchId = UUID.randomUUID().toString();
                batchIdIds.add(batchId);
                BankOfferBatchExportDTO bankOfferBatch = new BankOfferBatchExportDTO(recordId, batchId, payDetailEnableIds);
                this.exportPayDetailData(bankOfferBatch, fileTableHeadSet, bankOfferTpl, selectBank, exportFileDTO, dynamicObjects);
            }
            catch (Exception e) {
                logger.info("bankOffer export fail {}", (Object)e.getMessage());
                appCache.remove("cache_bankreport_key");
            }
        }
        if (!payDetailIds.isEmpty()) {
            DynamicObject[] query;
            ArrayList<BankOfferExportErrorDTO> errorDTOS = new ArrayList<BankOfferExportErrorDTO>(payDetailIds.size());
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
            for (DynamicObject payDetail : query = helper.query(String.join((CharSequence)",", BankOfferHelper.getPayDetailErrorFieldList()), new QFilter[]{new QFilter("id", "in", payDetailIds)})) {
                if (payDetailErrorMap != null) {
                    BankOfferHelper.isSplitProxyError(payDetailErrorMap.getOrDefault(payDetail.getLong("id"), ""), payDetail, errorDTOS);
                    continue;
                }
                BankOfferHelper.isNotSamePayBank(selectBankList.stream().anyMatch(BankOfferSelectTplDTO::getNoAcctExport), payDetail, errorDTOS);
            }
            appCache.put("bankOfferExportError", (Object)JSON.toJSONString(errorDTOS));
            if (payDetailIds.size() == totalNum) {
                this.setBankOfferStopProgressInfo(recordId, totalNum);
                return;
            }
            BankOfferHelper.updateBankOfferProgressInfo(appCache, recordId, payDetailIds.size(), payDetailIds.size());
        }
        appCache.put("SWC_BANKOFFER_BATCH_IDS", batchIdIds);
        appCache.put("calPayDetailEnableList", payDetailEnableAllIds);
        appCache.put("calTableIds", calPersonAllIds);
    }

    private void createBaskgroundTask(ISWCAppCache appCache, IFormView view, String bankOfferTplName, Map<String, Object> map) {
        StringBuilder name = new StringBuilder(ResManager.loadKDString((String)"\u5bfc\u51fa\u62a5\u76d8", (String)"BankOfferExportService_3", (String)"swc-hsas-business", (Object[])new Object[0]));
        name.append("(");
        name.append(bankOfferTplName);
        name.append(")");
        String floatingTaskId = HRBackgroundTaskHelper.getInstance().createBaskgroundTask("swc_hsas_paydetailbankoffer", name.toString(), true, view.getPageId(), map);
        appCache.put("platformTaskInfo", (Object)floatingTaskId);
    }

    private void beforeBankOfferSplit(BankOfferExportSplitEvent event) {
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)new BankOfferServiceImpl(), IBankOfferExtService.class, (String)"kd.sdk.swc.hsas.business.extpoint.paydetail.IBankOfferExtService#beforeBankOfferSplit", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.beforeBankOfferSplit(event);
            return null;
        });
    }

    private Map<Long, DynamicObject> buildBankOfferTplMap(BankOfferExportSplitEvent event, List<BankOfferSelectTplDTO> selectBankList) {
        Boolean successSplit = event.getSuccessSplit();
        if (successSplit == null || !successSplit.booleanValue()) {
            return this.getBankOfferTplMap(selectBankList.stream().map(BankOfferSelectTplDTO::getBankOfferTplId).collect(Collectors.toList()));
        }
        List splitResultList = event.getExportSplitResultList();
        if (splitResultList == null) {
            return new HashMap<Long, DynamicObject>(16);
        }
        return this.getBankOfferTplMap(splitResultList.stream().map(BankOfferExportSplitResult::getBankOfferTplId).collect(Collectors.toList()));
    }

    private boolean buildBankOfferSelectTpl(BankOfferExportSplitEvent event, List<Long> payDetailIds, Map<Long, DynamicObject> bankOfferTplMap, List<BankOfferSelectTplDTO> selectBankList, Map<String, List<Long>> dataSourceMap) {
        Boolean successSplit = event.getSuccessSplit();
        if (successSplit == null || !successSplit.booleanValue()) {
            selectBankList.forEach(bank -> dataSourceMap.put(bank.getId(), payDetailIds));
            return !selectBankList.isEmpty();
        }
        logger.info("successSplit is true");
        selectBankList.clear();
        List splitResultList = event.getExportSplitResultList();
        if (splitResultList != null) {
            int totalSplitNum = 0;
            for (BankOfferExportSplitResult splitResult : splitResultList) {
                List splitPayDetailIdList = splitResult.getSplitPayDetailIdList();
                if (splitPayDetailIdList == null || !payDetailIds.containsAll(splitPayDetailIdList)) {
                    return false;
                }
                Long bankOfferTplId = splitResult.getBankOfferTplId();
                DynamicObject tplData = bankOfferTplMap.get(bankOfferTplId);
                if (tplData == null) {
                    return false;
                }
                totalSplitNum += splitPayDetailIdList.size();
                BankOfferSelectTplDTO selectTpl = new BankOfferSelectTplDTO(splitResult.getBankCgSettingId(), "", splitResult.getBankOfferDesc(), bankOfferTplId, Long.valueOf(tplData.getLong("sourcevid")), tplData.getString("name"), "", Boolean.TRUE, Boolean.FALSE);
                selectBankList.add(selectTpl);
                dataSourceMap.put(selectTpl.getId(), splitPayDetailIdList);
            }
            Map payDetailErrorMap = event.getPayDetailErrorMap();
            if (payDetailErrorMap != null) {
                totalSplitNum += payDetailErrorMap.size();
            }
            return payDetailIds.size() == totalSplitNum;
        }
        return false;
    }

    private Map<Long, DynamicObject> getBankOfferTplMap(List<Long> tplIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bankoffertpl");
        QFilter filter = new QFilter("id", "in", tplIds);
        DynamicObject[] bankOfferTplArray = helper.query("id,name,sourcevid,filetype,filename,txthead,isshowhead,isshowseq,isempty,headtype,subheadcontent,fieldshowtype,alignment,collocation,selectfield,limitcontent,limitline,limitamount,separateways,separator,fixlength,fieldname,fieldsource,fieldvalue,fieldselect,fieldlength,fixway,fixcontent,isshowthousandth,isnull,currencyid,fieldquerytable", new QFilter[]{filter});
        HashMap<Long, DynamicObject> bankOfferTplMap = new HashMap<Long, DynamicObject>(bankOfferTplArray.length);
        for (DynamicObject bankOfferTpl : bankOfferTplArray) {
            bankOfferTplMap.put(bankOfferTpl.getLong("id"), bankOfferTpl);
        }
        return bankOfferTplMap;
    }

    private void exportPayDetailData(BankOfferBatchExportDTO bankOfferBatch, Set<String> fileTableHeadSet, DynamicObject bankOfferTpl, BankOfferSelectTplDTO selectTpl, List<BankOfferExportFiledDTO> exportFileDTO, DynamicObject[] dynamicObjects) throws Exception {
        try {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
            helper.update(dynamicObjects);
            SWCThreadPoolFactory.getCommonExportThreadpool().execute((Runnable)new BankOfferExportThread(fileTableHeadSet, bankOfferBatch, bankOfferTpl, RequestContext.get(), selectTpl, exportFileDTO));
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private List<BankOfferExportFiledDTO> getExportFileDTO(DynamicObject bankOfferTpl) {
        DynamicObjectCollection detailCollection = bankOfferTpl.getDynamicObjectCollection("detailent");
        ArrayList<BankOfferExportFiledDTO> bankOfferExportFiledDTOS = new ArrayList<BankOfferExportFiledDTO>(detailCollection.size());
        Map<String, String> detailFieldToNameMap = BankOfferHelper.getPayDetailFieldMap();
        Map<String, String> customNameMap = BankOfferHelper.getCustomNameMap(detailCollection.stream().filter(data -> "4".equals(data.getString("fieldsource"))).map(data -> data.getLong("fieldselect")).collect(Collectors.toList()));
        int seq = 0;
        for (DynamicObject detail : detailCollection) {
            String fieldSelect = detail.getString("fieldselect");
            String fieldName = detail.getString("fieldname");
            String fieldSource = detail.getString("fieldsource");
            String fieldValue = "";
            if ("1".equals(fieldSource)) {
                fieldValue = detail.getString("fieldvalue");
            } else if ("2".equals(fieldSource)) {
                fieldValue = detailFieldToNameMap.get(fieldSelect);
            } else if ("4".equals(fieldSource)) {
                fieldValue = customNameMap.get(fieldSelect);
            }
            int fieldLength = detail.getInt("fieldlength");
            String fixWay = detail.getString("fixway");
            String fixContent = detail.getString("fixcontent");
            Boolean isShowThousandth = detail.getBoolean("isshowthousandth");
            Boolean isNull = detail.getBoolean("isnull");
            BankOfferExportFiledDTO dto = new BankOfferExportFiledDTO(fieldName, fieldSource, fieldValue, fieldSelect, Integer.valueOf(fieldLength), fixWay, fixContent, isShowThousandth, isNull, new AtomicInteger(0));
            dto.setSeq(Integer.valueOf(seq++));
            dto.setId(Long.valueOf(detail.getLong("id")));
            dto.setFieldQueryTable(detail.getString("fieldquerytable"));
            bankOfferExportFiledDTOS.add(dto);
        }
        return bankOfferExportFiledDTOS;
    }

    private void setBankOfferStartProgressInfo(String recordId, int totalNum) {
        BankOfferProgressInfo progress = new BankOfferProgressInfo();
        progress.setStatus(0);
        progress.setTotal(totalNum);
        progress.setSuccess(0);
        progress.setFail(0);
        progress.setFinish(0);
        progress.setRemain(totalNum);
        SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_BANKOFFER_%s", recordId)).put("cache_bankreport_key", (Object)progress);
    }

    private void setBankOfferStopProgressInfo(String recordId, int totalNum) {
        BankOfferProgressInfo progress = new BankOfferProgressInfo();
        progress.setStatus(2);
        progress.setTotal(totalNum);
        progress.setSuccess(0);
        progress.setFail(totalNum);
        progress.setFinish(totalNum);
        progress.setRemain(0);
        SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_BANKOFFER_%s", recordId)).put("cache_bankreport_key", (Object)progress);
    }

    private Set<String> getFileTableHeadValue(DynamicObject bankOfferTpl) {
        String fileName = bankOfferTpl.getString("filename");
        HashSet<String> fileNameSet = new HashSet<String>(16);
        BankOfferHelper.extractMessage(fileName, fileNameSet, null);
        boolean isShowHead = bankOfferTpl.getBoolean("isshowhead");
        if (!isShowHead) {
            return fileNameSet;
        }
        String fileType = bankOfferTpl.getString("filetype");
        if ("1".equals(fileType)) {
            this.getTableHeadValueByExcel(bankOfferTpl, fileNameSet);
        } else {
            String txtHead = bankOfferTpl.getString("txthead");
            this.getTableHeadValueByTxt(txtHead, fileNameSet);
        }
        return fileNameSet;
    }

    private void getTableHeadValueByExcel(DynamicObject bankOfferTpl, Set<String> fileNameSet) {
        DynamicObjectCollection excelCollection = bankOfferTpl.getDynamicObjectCollection("exceltitleent");
        for (DynamicObject excelObj : excelCollection) {
            boolean isEmpty = excelObj.getBoolean("isempty");
            if (isEmpty) continue;
            DynamicObjectCollection excelHeads = excelObj.getDynamicObjectCollection("headcontententity");
            for (DynamicObject excelHead : excelHeads) {
                String selectField;
                String headType = excelHead.getString("headtype");
                if (!"1".equals(headType) || NOT_PAY_DETAIL_FILED.contains(selectField = excelHead.getString("selectfield"))) continue;
                selectField = BankOfferHelper.getBaseDataValue(selectField);
                fileNameSet.add(selectField);
                if (!"payamount".equals(selectField)) continue;
                fileNameSet.add("paycurrency");
                fileNameSet.add("salaryitem");
            }
        }
    }

    private void getTableHeadValueByTxt(String textHead, Set<String> fileNameSet) {
        BankOfferHelper.extractMessage(textHead, fileNameSet, null);
    }

    private DynamicObject[] getPayDetailValueByIds(List<Long> payDetailIds, Long bankCgSettingId, Boolean isNoAcctExport, Boolean isMul) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter filter = new QFilter("id", "in", payDetailIds);
        if (!isNoAcctExport.booleanValue()) {
            filter.and(new QFilter("agentpaybank.bank_cate.id", "!=", (Object)0L));
            filter.and(new QFilter("agentpaybank.id", "!=", (Object)0L));
        }
        if (!isMul.booleanValue()) {
            return helper.query("bankofferstatus,calpersonid", new QFilter[]{filter});
        }
        if (isNoAcctExport.booleanValue()) {
            filter.and(new QFilter("agentpaybank.bank_cate.id", "=", (Object)0L).or(new QFilter("agentpaybank.id", "=", (Object)0L)));
        }
        if (bankCgSettingId != 0L) {
            filter.and(new QFilter("agentpaybank.bank_cate.id", "=", (Object)bankCgSettingId));
        }
        return helper.query("bankofferstatus,calpersonid", new QFilter[]{filter});
    }

    private void setPayDetailBankOfferStatus(DynamicObject[] payDetails, List<Long> payDetailEnableIds, Set<Long> calTableIds) {
        for (DynamicObject dynamicObject : payDetails) {
            Long calPkid = dynamicObject.getLong("calpersonid");
            calTableIds.add(calPkid);
            dynamicObject.set("bankofferstatus", (Object)BankOfferEnum.EXPORTING.getCode());
            long id = dynamicObject.getLong("id");
            payDetailEnableIds.add(id);
        }
    }

    static {
        NOT_PAY_DETAIL_FILED.add("totalnum");
        NOT_PAY_DETAIL_FILED.add("exportdate");
    }
}

