/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bankoffer;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.bankoffer.excel.ExcelHelper;
import kd.swc.hsas.business.bankoffer.excel.PageBatchDataProvider;
import kd.swc.hsas.business.bankoffer.excel.WorkbookBankOfferDeclareExport;
import kd.swc.hsas.business.bankoffer.vo.ExportResult;
import kd.swc.hsas.business.bankoffer.vo.WorkbookInfo;
import kd.swc.hsas.common.dto.BankOfferExportErrorDTO;
import kd.swc.hsas.common.dto.BankOfferExportFiledDTO;
import kd.swc.hsas.common.dto.BankOfferProgressInfo;
import kd.swc.hsas.common.enums.BankOfferEnum;
import kd.swc.hsbp.business.servicehelper.SWCBaseDataSummaryHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class BankOfferHelper {
    private static final Log logger = LogFactory.getLog(BankOfferHelper.class);
    private static final Interner<String> progressLock = Interners.newWeakInterner();
    private static final Map<String, String> BASEDATA_MAP = new HashMap<String, String>(16);
    private static final String EMPTY = "";
    private static final String EXCEL_SUFFIX = ".xlsx";
    private static final HashSet<String> NOT_PAY_DETAIL_FILED = new LinkedHashSet<String>(16);

    public static String extractMessage(String fileName, boolean isLabel, boolean isFileName) {
        int start = 0;
        int startFlag = 0;
        int endFlag = 0;
        String newFileName = fileName + EMPTY;
        for (int i = 0; i < fileName.length(); ++i) {
            if (fileName.charAt(i) == '{') {
                if (endFlag > 0) {
                    startFlag = 0;
                    endFlag = 0;
                }
                ++startFlag;
                start = i;
                continue;
            }
            if (fileName.charAt(i) != '}') continue;
            if (startFlag > 0) {
                startFlag = 0;
                endFlag = 0;
            }
            if (endFlag == 0) {
                String flagName = fileName.substring(start + 1, i);
                String name = isLabel ? BankOfferHelper.getValueLabel(flagName, isFileName) : BankOfferHelper.getLabelValue(flagName, isFileName);
                if (StringUtils.isNotBlank((String)name)) {
                    newFileName = newFileName.replaceFirst("\\{" + flagName + "\\}", "\\{" + name + "\\}");
                }
            }
            ++endFlag;
        }
        return newFileName;
    }

    public static Map<String, String> getNameToDemoMap() {
        HashMap<String, String> filedNameLangMap = new HashMap<String, String>(16);
        String name = ResManager.loadKDString((String)"\u603b\u7b14\u6570", (String)"BankOfferHelper_5", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "1000");
        name = ResManager.loadKDString((String)"\u6536\u6b3e\u5e01\u79cd", (String)"BankOfferHelper_90", (String)"swc-hsas-business", (Object[])new Object[0]);
        String value = ResManager.loadKDString((String)"\u4eba\u6c11\u5e01", (String)"BankOfferHelper_79", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, value);
        name = ResManager.loadKDString((String)"\u6536\u6b3e\u5e01\u79cd\u603b\u91d1\u989d", (String)"BankOfferHelper_91", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "8,000,000.00");
        name = ResManager.loadKDString((String)"\u652f\u4ed8\u4e3b\u4f53.\u540d\u79f0", (String)"BankOfferHelper_67", (String)"swc-hsas-business", (Object[])new Object[0]);
        value = ResManager.loadKDString((String)"\u67d0\u67d0\u516c\u53f8", (String)"BankOfferHelper_80", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, value);
        name = ResManager.loadKDString((String)"\u652f\u4ed8\u4e3b\u4f53.\u7f16\u7801", (String)"BankOfferHelper_68", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "0010");
        name = ResManager.loadKDString((String)"\u85aa\u8d44\u6240\u5c5e\u5e74\u6708", (String)"BankOfferHelper_9", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "202101");
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c.\u94f6\u884c\u7c7b\u522b.\u540d\u79f0", (String)"BankOfferHelper_65", (String)"swc-hsas-business", (Object[])new Object[0]);
        value = ResManager.loadKDString((String)"\u67d0\u67d0\u94f6\u884c", (String)"BankOfferHelper_81", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, value);
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c.\u94f6\u884c\u7c7b\u522b.\u884c\u522b\u4ee3\u7801", (String)"BankOfferHelper_66", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "XXX");
        name = ResManager.loadKDString((String)"\u5bfc\u51fa\u62a5\u76d8\u65e5\u671f", (String)"BankOfferHelper_11", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "20210101");
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7", (String)"BankOfferHelper_84", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "6214********8888");
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c.\u8054\u884c\u53f7", (String)"BankOfferHelper_85", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "102655030396");
        return filedNameLangMap;
    }

    public static Map<String, String> getFieldToDemoMap() {
        HashMap<String, String> filedNameLangMap = new HashMap<String, String>(16);
        filedNameLangMap.put("totalnum", "1000");
        String value = ResManager.loadKDString((String)"\u4eba\u6c11\u5e01", (String)"BankOfferHelper_79", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("paycurrency", value);
        filedNameLangMap.put("totalamount", "8,000,000.00");
        value = ResManager.loadKDString((String)"\u67d0\u67d0\u516c\u53f8", (String)"BankOfferHelper_80", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("paysubjecthis", value);
        filedNameLangMap.put("paysubjecthisnum", "0010");
        filedNameLangMap.put("payrolldate", "202101");
        value = ResManager.loadKDString((String)"\u67d0\u67d0\u94f6\u884c", (String)"BankOfferHelper_81", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("bankcgsettingid", value);
        filedNameLangMap.put("bankcgsettingnum", "XXX");
        filedNameLangMap.put("exportdate", "20210101");
        filedNameLangMap.put("agentpayaccount", "6214********8888");
        filedNameLangMap.put("agentpaybank", "102655030396");
        return filedNameLangMap;
    }

    public static String extractMessage(String fileName, Set<String> filedName, Map<String, String> filedNameMap) {
        int start = 0;
        int startFlag = 0;
        int endFlag = 0;
        String newFileName = fileName + EMPTY;
        Map<String, String> fileFieldToNameMap = BankOfferHelper.getFileFieldToNameMap();
        fileFieldToNameMap.putAll(BankOfferHelper.getContentFieldToNameMap());
        Set<String> keySet = fileFieldToNameMap.keySet();
        for (int i = 0; i < fileName.length(); ++i) {
            if (fileName.charAt(i) == '{') {
                if (endFlag > 0) {
                    startFlag = 0;
                    endFlag = 0;
                }
                ++startFlag;
                start = i;
                continue;
            }
            if (fileName.charAt(i) != '}') continue;
            if (startFlag > 0) {
                startFlag = 0;
                endFlag = 0;
            }
            if (endFlag == 0) {
                String flagName = fileName.substring(start + 1, i);
                if (filedName != null && keySet.contains(flagName) && !NOT_PAY_DETAIL_FILED.contains(flagName)) {
                    flagName = BASEDATA_MAP.get(flagName) == null ? flagName : BASEDATA_MAP.get(flagName);
                    filedName.add(flagName);
                    if ("payamount".equals(flagName)) {
                        filedName.add("paycurrency");
                        filedName.add("salaryitem");
                    }
                }
                if (filedNameMap != null) {
                    String name = filedNameMap.get(flagName);
                    newFileName = StringUtils.isNotEmpty((String)name) ? newFileName.replaceFirst("\\{" + flagName + "\\}", name) : newFileName.replaceFirst("\\{" + flagName + "\\}", EMPTY);
                }
            }
            ++endFlag;
        }
        return newFileName;
    }

    public static String getBaseDataValue(String flagName) {
        return BASEDATA_MAP.get(flagName) == null ? flagName : BASEDATA_MAP.get(flagName);
    }

    public static String getLabelValue(String key, boolean isFileName) {
        if (isFileName) {
            return BankOfferHelper.getFileFieldToNameMap().get(key);
        }
        return BankOfferHelper.getContentFieldToNameMap().get(key);
    }

    public static String getValueLabel(String key, boolean isFileName) {
        if (isFileName) {
            return BankOfferHelper.getFileNameToFieldMap().get(key);
        }
        return BankOfferHelper.getContentNameToFieldMap().get(key);
    }

    public static Map<String, String> getFileFieldToNameMap() {
        HashMap<String, String> filedNameLangMap = new HashMap<String, String>(16);
        String name = ResManager.loadKDString((String)"\u603b\u7b14\u6570", (String)"BankOfferHelper_5", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("totalnum", name);
        name = ResManager.loadKDString((String)"\u6536\u6b3e\u5e01\u79cd", (String)"BankOfferHelper_90", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("paycurrency", name);
        name = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u6240\u5c5e\u56fd\u5bb6\u5730\u533a", (String)"BankOfferHelper_59", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("country", name);
        name = ResManager.loadKDString((String)"\u85aa\u8d44\u6240\u5c5e\u5e74\u6708", (String)"BankOfferHelper_9", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("payrolldate", name);
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c.\u94f6\u884c\u7c7b\u522b.\u540d\u79f0", (String)"BankOfferHelper_65", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("bankcgsettingid", name);
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c.\u94f6\u884c\u7c7b\u522b.\u884c\u522b\u4ee3\u7801", (String)"BankOfferHelper_66", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("bankcgsettingnum", name);
        name = ResManager.loadKDString((String)"\u5bfc\u51fa\u62a5\u76d8\u65e5\u671f", (String)"BankOfferHelper_11", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("exportdate", name);
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7", (String)"BankOfferHelper_84", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("agentpayaccount", name);
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c.\u8054\u884c\u53f7", (String)"BankOfferHelper_85", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("agentpaybank", name);
        return filedNameLangMap;
    }

    public static Map<String, String> getFileNameToFieldMap() {
        HashMap<String, String> filedNameLangMap = new HashMap<String, String>(16);
        String name = ResManager.loadKDString((String)"\u603b\u7b14\u6570", (String)"BankOfferHelper_5", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "totalnum");
        name = ResManager.loadKDString((String)"\u6536\u6b3e\u5e01\u79cd", (String)"BankOfferHelper_90", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "paycurrency");
        name = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u6240\u5c5e\u56fd\u5bb6\u5730\u533a", (String)"BankOfferHelper_59", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "country");
        name = ResManager.loadKDString((String)"\u85aa\u8d44\u6240\u5c5e\u5e74\u6708", (String)"BankOfferHelper_9", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "payrolldate");
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c.\u94f6\u884c\u7c7b\u522b.\u540d\u79f0", (String)"BankOfferHelper_65", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "bankcgsettingid");
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c.\u94f6\u884c\u7c7b\u522b.\u884c\u522b\u4ee3\u7801", (String)"BankOfferHelper_66", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "bankcgsettingnum");
        name = ResManager.loadKDString((String)"\u5bfc\u51fa\u62a5\u76d8\u65e5\u671f", (String)"BankOfferHelper_11", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "exportdate");
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7", (String)"BankOfferHelper_84", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "agentpayaccount");
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c.\u8054\u884c\u53f7", (String)"BankOfferHelper_85", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "agentpaybank");
        return filedNameLangMap;
    }

    public static Map<String, String> getContentFieldToNameMap() {
        HashMap<String, String> filedNameLangMap = new HashMap<String, String>(16);
        String name = ResManager.loadKDString((String)"\u603b\u7b14\u6570", (String)"BankOfferHelper_5", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("totalnum", name);
        name = ResManager.loadKDString((String)"\u6536\u6b3e\u5e01\u79cd", (String)"BankOfferHelper_90", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("paycurrency", name);
        name = ResManager.loadKDString((String)"\u6536\u6b3e\u5e01\u79cd\u603b\u91d1\u989d", (String)"BankOfferHelper_91", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("totalamount", name);
        name = ResManager.loadKDString((String)"\u652f\u4ed8\u4e3b\u4f53.\u540d\u79f0", (String)"BankOfferHelper_67", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("paysubjecthis", name);
        name = ResManager.loadKDString((String)"\u652f\u4ed8\u4e3b\u4f53.\u7f16\u7801", (String)"BankOfferHelper_68", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("paysubjecthisnum", name);
        name = ResManager.loadKDString((String)"\u85aa\u8d44\u6240\u5c5e\u5e74\u6708", (String)"BankOfferHelper_9", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("payrolldate", name);
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c.\u94f6\u884c\u7c7b\u522b.\u540d\u79f0", (String)"BankOfferHelper_65", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("bankcgsettingid", name);
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c.\u94f6\u884c\u7c7b\u522b.\u884c\u522b\u4ee3\u7801", (String)"BankOfferHelper_66", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("bankcgsettingnum", name);
        name = ResManager.loadKDString((String)"\u5bfc\u51fa\u62a5\u76d8\u65e5\u671f", (String)"BankOfferHelper_11", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("exportdate", name);
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7", (String)"BankOfferHelper_84", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("agentpayaccount", name);
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c.\u8054\u884c\u53f7", (String)"BankOfferHelper_85", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("agentpaybank", name);
        return filedNameLangMap;
    }

    public static Map<String, String> getContentNameToFieldMap() {
        HashMap<String, String> filedNameLangMap = new HashMap<String, String>(16);
        String name = ResManager.loadKDString((String)"\u603b\u7b14\u6570", (String)"BankOfferHelper_5", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "totalnum");
        name = ResManager.loadKDString((String)"\u6536\u6b3e\u5e01\u79cd", (String)"BankOfferHelper_90", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "paycurrency");
        name = ResManager.loadKDString((String)"\u6536\u6b3e\u5e01\u79cd\u603b\u91d1\u989d", (String)"BankOfferHelper_91", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "totalamount");
        name = ResManager.loadKDString((String)"\u652f\u4ed8\u4e3b\u4f53.\u540d\u79f0", (String)"BankOfferHelper_67", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "paysubjecthis");
        name = ResManager.loadKDString((String)"\u652f\u4ed8\u4e3b\u4f53.\u7f16\u7801", (String)"BankOfferHelper_68", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "paysubjecthisnum");
        name = ResManager.loadKDString((String)"\u85aa\u8d44\u6240\u5c5e\u5e74\u6708", (String)"BankOfferHelper_9", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "payrolldate");
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c.\u94f6\u884c\u7c7b\u522b.\u540d\u79f0", (String)"BankOfferHelper_65", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "bankcgsettingid");
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c.\u94f6\u884c\u7c7b\u522b.\u884c\u522b\u4ee3\u7801", (String)"BankOfferHelper_66", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "bankcgsettingnum");
        name = ResManager.loadKDString((String)"\u5bfc\u51fa\u62a5\u76d8\u65e5\u671f", (String)"BankOfferHelper_11", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "exportdate");
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7", (String)"BankOfferHelper_84", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "agentpayaccount");
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c.\u8054\u884c\u53f7", (String)"BankOfferHelper_85", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put(name, "agentpaybank");
        return filedNameLangMap;
    }

    public static Map<String, String> getAllFieldToNameMap() {
        HashMap<String, String> allFiledNameLangMap = new HashMap<String, String>(16);
        allFiledNameLangMap.putAll(BankOfferHelper.getFileFieldToNameMap());
        String name = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u6240\u5c5e\u56fd\u5bb6\u5730\u533a", (String)"BankOfferHelper_59", (String)"swc-hsas-business", (Object[])new Object[0]);
        allFiledNameLangMap.put("caltask.country", name);
        allFiledNameLangMap.putAll(BankOfferHelper.getContentFieldToNameMap());
        name = ResManager.loadKDString((String)"\u652f\u4ed8\u4e3b\u4f53.\u7f16\u7801", (String)"BankOfferHelper_68", (String)"swc-hsas-business", (Object[])new Object[0]);
        allFiledNameLangMap.put("paysubjecthis.number", name);
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c.\u8054\u884c\u53f7", (String)"BankOfferHelper_85", (String)"swc-hsas-business", (Object[])new Object[0]);
        allFiledNameLangMap.put("agentpaybank.union_number", name);
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c.\u94f6\u884c\u7c7b\u522b.\u540d\u79f0", (String)"BankOfferHelper_65", (String)"swc-hsas-business", (Object[])new Object[0]);
        allFiledNameLangMap.put("agentpaybank.bank_cate", name);
        name = ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c.\u94f6\u884c\u7c7b\u522b.\u884c\u522b\u4ee3\u7801", (String)"BankOfferHelper_66", (String)"swc-hsas-business", (Object[])new Object[0]);
        allFiledNameLangMap.put("agentpaybank.bank_cate.type_code", name);
        return allFiledNameLangMap;
    }

    public static Map<String, String> getAmountTypeMap() {
        HashMap<String, String> amountTypeMap = new HashMap<String, String>(16);
        String name = ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d", (String)"BankOfferHelper_35", (String)"swc-hsas-business", (Object[])new Object[0]);
        amountTypeMap.put(name, "payamount");
        name = ResManager.loadKDString((String)"\u539f\u5e01\u91d1\u989d", (String)"BankOfferHelper_38", (String)"swc-hsas-business", (Object[])new Object[0]);
        amountTypeMap.put(name, "oriamount");
        name = ResManager.loadKDString((String)"\u6838\u7b97\u91d1\u989d", (String)"BankOfferHelper_40", (String)"swc-hsas-business", (Object[])new Object[0]);
        amountTypeMap.put(name, "calamount");
        return amountTypeMap;
    }

    public static Map<String, String> getAmountPrecisionMap() {
        HashMap<String, String> amountPrecisionMap = new HashMap<String, String>(16);
        amountPrecisionMap.put("payamount", "paycurrency.amtprecision");
        amountPrecisionMap.put("oriamount", "oricurrency.amtprecision");
        amountPrecisionMap.put("calamount", "calcurrency.amtprecision");
        return amountPrecisionMap;
    }

    public static Map<String, String> getPayDetailFieldMap() {
        LinkedHashMap<String, String> filedNameLangMap = new LinkedHashMap<String, String>(16);
        BankOfferHelper.getPayDetailFieldMap("hsas_bankofferexport", filedNameLangMap);
        BankOfferHelper.getPayDetailFieldMap("hsas_bankofferexport_person", filedNameLangMap);
        return filedNameLangMap;
    }

    private static void getPayDetailFieldMap(String tableName, Map<String, String> filedNameLangMap) {
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)tableName);
        List selectFields = queryEntityType.getSelectFields();
        filedNameLangMap.putAll(selectFields.stream().collect(Collectors.toMap(QuerySelectField::getAlias, QuerySelectField::getDisplayName)));
    }

    public static List<String> getPayDetailErrorFieldList() {
        List<String> filedNameLangList = Arrays.asList("salaryfilehis.person.name", "salaryfilehis.person.number", "org.name", "bankofferstatus", "adminorg.name", "empgroup.name", "company.name", "department.name", "position.name", "job.name", "laborreltype.name", "laborrelstatus.name", "caltask.number", "payrollgroup.name", "payrolldate", "bankofferlog.id", "caltask.calcount", "salaryitem.name", "paycurrency", "payamount", "payrate", "paytype", "paysubjecthis", "agentpaybank.id", "receivername", "payrollacrel.name", "perbankcard.bankdeposit.name", "oricurrency", "calcurrency", "agentpayaccount", "perbankcard.bankcardnum");
        return filedNameLangList;
    }

    public static Map<String, String> getPayDetailErrorDTOFieldMap() {
        LinkedHashMap<String, String> filedNameLangMap = new LinkedHashMap<String, String>(16);
        String name = ResManager.loadKDString((String)"\u59d3\u540d", (String)"BankOfferHelper_12", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("personName", name);
        name = ResManager.loadKDString((String)"\u5de5\u53f7", (String)"BankOfferHelper_13", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("empNumber", name);
        name = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u7f16\u53f7", (String)"BankOfferHelper_88", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("salaryFileNumber", name);
        name = ResManager.loadKDString((String)"\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7", (String)"BankOfferHelper_15", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("orgName", name);
        name = ResManager.loadKDString((String)"\u6302\u9760\u884c\u653f\u7ec4\u7ec7", (String)"BankOfferHelper_16", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("adminorgName", name);
        name = ResManager.loadKDString((String)"\u8ba1\u85aa\u4eba\u5458\u7ec4", (String)"BankOfferHelper_17", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("empgroupName", name);
        name = ResManager.loadKDString((String)"\u516c\u53f8", (String)"BankOfferHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("companyName", name);
        name = ResManager.loadKDString((String)"\u90e8\u95e8", (String)"BankOfferHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("departmentName", name);
        name = ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"BankOfferHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("positionName", name);
        name = ResManager.loadKDString((String)"\u804c\u4f4d", (String)"BankOfferHelper_18", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("jobName", name);
        name = ResManager.loadKDString((String)"\u7528\u5de5\u5173\u7cfb\u7c7b\u578b", (String)"BankOfferHelper_19", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("laborreltypeName", name);
        name = ResManager.loadKDString((String)"\u7528\u5de5\u5173\u7cfb\u72b6\u6001", (String)"BankOfferHelper_20", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("laborrelstatusName", name);
        name = ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u4efb\u52a1", (String)"BankOfferHelper_24", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("calTaskNumber", name);
        name = ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4", (String)"BankOfferHelper_25", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("payrollGroupName", name);
        name = ResManager.loadKDString((String)"\u85aa\u8d44\u6240\u5c5e\u5e74\u6708", (String)"BankOfferHelper_27", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("payrollDate", name);
        name = ResManager.loadKDString((String)"\u6838\u7b97\u6b21\u6570", (String)"BankOfferHelper_28", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("calCount", name);
        name = ResManager.loadKDString((String)"\u5b9e\u53d1\u9879\u76ee", (String)"BankOfferHelper_32", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("salaryItemName", name);
        name = ResManager.loadKDString((String)"\u6536\u6b3e\u5e01\u79cd", (String)"BankOfferHelper_90", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("payCurrencyName", name);
        name = ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d", (String)"BankOfferHelper_35", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("payAmount", name);
        name = ResManager.loadKDString((String)"\u5360\u6bd4(%)", (String)"BankOfferHelper_36", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("payRate", name);
        name = ResManager.loadKDString((String)"\u652f\u4ed8\u5f62\u5f0f", (String)"BankOfferHelper_43", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("payType", name);
        name = ResManager.loadKDString((String)"\u652f\u4ed8\u4e3b\u4f53", (String)"BankOfferHelper_44", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("paySubjectHisName", name);
        name = ResManager.loadKDString((String)"\u8d26\u6237\u540d", (String)"BankOfferHelper_46", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("receiverName", name);
        name = ResManager.loadKDString((String)"\u8d26\u6237\u5173\u7cfb", (String)"BankOfferHelper_47", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("payrollacrelName", name);
        name = ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7", (String)"BankOfferHelper_48", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("bankAccount", name);
        name = ResManager.loadKDString((String)"\u6536\u6b3e\u94f6\u884c", (String)"BankOfferHelper_49", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("bebankName", name);
        name = ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"BankOfferHelper_60", (String)"swc-hsas-business", (Object[])new Object[0]);
        filedNameLangMap.put("errorMsg", name);
        return filedNameLangMap;
    }

    public static TableValueSetter createHeadContentTableSetter() {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("headtype", new Object[0]);
        setter.addField("subheadcontent", new Object[0]);
        setter.addField("selectfield", new Object[0]);
        setter.addField("fieldshowtype", new Object[0]);
        setter.addField("alignment", new Object[0]);
        setter.addField("collocation", new Object[0]);
        return setter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateBankOfferProgressInfo(ISWCAppCache appCache, String recordId, int batchSize, int errorSize) {
        String string = (String)progressLock.intern((Object)recordId);
        synchronized (string) {
            BankOfferProgressInfo progressInfo = (BankOfferProgressInfo)appCache.get("cache_bankreport_key", BankOfferProgressInfo.class);
            if (progressInfo == null) {
                return;
            }
            int remain = progressInfo.getRemain();
            int finishCount = progressInfo.getFinish();
            int fail = progressInfo.getFail();
            int success = progressInfo.getSuccess();
            progressInfo.setFinish(finishCount + batchSize);
            progressInfo.setSuccess(success + (batchSize - errorSize));
            progressInfo.setFail(fail + errorSize);
            progressInfo.setRemain(remain - batchSize);
            appCache.put("cache_bankreport_key", (Object)progressInfo);
            String floatingTaskId = (String)appCache.get("platformTaskInfo", String.class);
            HRBackgroundTaskHelper.getInstance().feedbackProgress(floatingTaskId, (progressInfo.getSuccess() + progressInfo.getFail()) * 100 / progressInfo.getTotal(), EMPTY, null);
        }
    }

    public static void setErrorPayDetailInfo(List<BankOfferExportErrorDTO> errorDTOS) {
        if (CollectionUtils.isEmpty(errorDTOS)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        List splitBankOfferExportErrorList = SWCListUtils.split(errorDTOS, (int)2000);
        for (List split : splitBankOfferExportErrorList) {
            DynamicObject[] query;
            Map<Long, BankOfferExportErrorDTO> dtoMap = split.stream().collect(Collectors.toMap(BankOfferExportErrorDTO::getId, data -> data, (o1, o2) -> o1));
            QFilter filter = new QFilter("id", "in", dtoMap.keySet());
            for (DynamicObject payDetail : query = helper.query(String.join((CharSequence)",", BankOfferHelper.getPayDetailErrorFieldList()), new QFilter[]{filter})) {
                BankOfferExportErrorDTO dto = dtoMap.get(payDetail.getLong("id"));
                BankOfferHelper.setErrorDTO(dto, payDetail);
                long bankOfferLogId = payDetail.getLong("bankofferlog.id");
                if (bankOfferLogId == 0L) {
                    payDetail.set("bankofferstatus", (Object)BankOfferEnum.UNDEXPORT.getCode());
                    continue;
                }
                payDetail.set("bankofferstatus", (Object)BankOfferEnum.INVALIDED.getCode());
            }
            helper.update(query);
        }
    }

    public static Map<String, DynamicObject> getCustomDataMap(List<Long> ids) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bankofferfetchcfg");
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObjectCollection query = helper.queryOriginalCollection("id,number,fetchpath", new QFilter[]{filter});
        return query.stream().collect(Collectors.toMap(data -> data.getString("id"), data -> data));
    }

    public static Map<String, String> getCustomNameMap(List<Long> ids) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bankofferfetchcfg");
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObjectCollection query = helper.queryOriginalCollection("id,name", new QFilter[]{filter});
        return query.stream().collect(Collectors.toMap(data -> data.getString("id"), data -> data.getString("name")));
    }

    public static Set<Long> getCustomEnableSet(List<Long> ids) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bankofferfetchcfg");
        QFilter filter = new QFilter("id", "in", ids);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection query = helper.queryOriginalCollection("id,name", new QFilter[]{filter});
        return query.stream().map(data -> data.getLong("id")).collect(Collectors.toSet());
    }

    public static boolean isNotSamePayCurrency(DynamicObject currency, DynamicObject payCurrency, DynamicObject payDetail, List<BankOfferExportErrorDTO> errorDTOS) {
        Long payCurrencyId;
        Long currencyId = currency.getLong("id");
        if (currencyId.equals(payCurrencyId = Long.valueOf(payCurrency.getLong("id")))) {
            return false;
        }
        String currencyName = currency.getString("name");
        String payCurrencyName = payCurrency.getString("name");
        String errorMsg = ResManager.loadKDString((String)"\u53d1\u653e\u660e\u7ec6\u7684\u6536\u6b3e\u5e01\u79cd\uff08{0}\uff09\u4e0e\u62a5\u76d8\u6a21\u677f\u9002\u7528\u5e01\u79cd\uff08{1}\uff09\u4e0d\u4e00\u81f4\uff0c\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25\u3002", (String)"BankOfferHelper_92", (String)"swc-hsas-business", (Object[])new Object[]{payCurrencyName, currencyName});
        BankOfferExportErrorDTO errorDTO = BankOfferHelper.getErrorDTO(errorMsg, payDetail.getLong("id"));
        errorDTOS.add(errorDTO);
        return true;
    }

    public static boolean isSameFileName(List<String> errorFiledList, List<Long> idList, List<BankOfferExportErrorDTO> errorDTOS) {
        if (errorFiledList.isEmpty()) {
            return false;
        }
        List list = errorFiledList.stream().map(err -> BankOfferHelper.getAllFieldToNameMap().get(err)).collect(Collectors.toList());
        String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u503c\u4e0d\u552f\u4e00\uff0c\u5bfc\u81f4\u6587\u4ef6\u540d\u6216\u8868\u5934\u4fe1\u606f\u751f\u6210\u5931\u8d25\uff0c\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25\u3002", (String)"BankOfferExportService_0", (String)"swc-hsas-business", (Object[])new Object[0]), String.join((CharSequence)",", list));
        for (Long id : idList) {
            BankOfferExportErrorDTO errorDTO = BankOfferHelper.getErrorDTO(errorMsg, id);
            errorDTOS.add(errorDTO);
        }
        return true;
    }

    public static boolean isLargeLimitAmount(BigDecimal limitAmount, BigDecimal payAmount, DynamicObject payDetail, List<BankOfferExportErrorDTO> errorDTOS) {
        if (limitAmount.compareTo(payAmount) >= 0) {
            return false;
        }
        String errorMsg = String.format(ResManager.loadKDString((String)"\u62a5\u76d8\u660e\u7ec6\u6536\u6b3e\u91d1\u989d\u5927\u4e8e\u5355\u4e2a\u91d1\u989d\u4e0a\u9650\uff0c\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25\u3002", (String)"BankOfferHelper_83", (String)"swc-hsas-business", (Object[])new Object[0]), new Object[0]);
        BankOfferExportErrorDTO errorDTO = BankOfferHelper.getErrorDTO(errorMsg, payDetail.getLong("id"));
        errorDTOS.add(errorDTO);
        return true;
    }

    public static void isNotSamePayBank(Boolean isNoAcctExport, DynamicObject payDetail, List<BankOfferExportErrorDTO> errorDTOS) {
        String errorMsg;
        DynamicObject bankCate;
        Long payBankCateId = 0L;
        String payBankCateName = " ";
        DynamicObject agentPayBankObject = payDetail.getDynamicObject("agentpaybank");
        if (agentPayBankObject != null && (bankCate = agentPayBankObject.getDynamicObject("bank_cate")) != null) {
            payBankCateId = bankCate.getLong("id");
            payBankCateName = bankCate.getString("name");
        }
        if (!isNoAcctExport.booleanValue() && payBankCateId == 0L) {
            errorMsg = ResManager.loadKDString((String)"\u672c\u6b21\u62a5\u76d8\u4e0d\u5bfc\u51fa\u65e0\u4ed8\u6b3e\u4fe1\u606f\u7684\u53d1\u653e\u660e\u7ec6\u3002", (String)"BankOfferHelper_89", (String)"swc-hsas-business", (Object[])new Object[]{payBankCateName});
            BankOfferExportErrorDTO errorDTO = BankOfferHelper.getErrorDTO(errorMsg, payDetail.getLong("id"));
            BankOfferHelper.setErrorDTO(errorDTO, payDetail);
            errorDTOS.add(errorDTO);
            return;
        }
        errorMsg = ResManager.loadKDString((String)"\u53d1\u653e\u660e\u7ec6\u7684\u4ed8\u6b3e\u94f6\u884c\u7c7b\u522b\uff08{0}\uff09\u672a\u6307\u5b9a\u94f6\u884c\u62a5\u76d8\u6a21\u677f\uff0c\u5bfc\u51fa\u5931\u8d25\u3002", (String)"BankOfferHelper_86", (String)"swc-hsas-business", (Object[])new Object[]{payBankCateName});
        BankOfferExportErrorDTO errorDTO = BankOfferHelper.getErrorDTO(errorMsg, payDetail.getLong("id"));
        BankOfferHelper.setErrorDTO(errorDTO, payDetail);
        errorDTOS.add(errorDTO);
    }

    public static void isSplitProxyError(String errorMsg, DynamicObject payDetail, List<BankOfferExportErrorDTO> errorDTOS) {
        BankOfferExportErrorDTO errorDTO = BankOfferHelper.getErrorDTO(errorMsg, payDetail.getLong("id"));
        BankOfferHelper.setErrorDTO(errorDTO, payDetail);
        errorDTOS.add(errorDTO);
    }

    public static List<Object[]> getBankOfferTplDetailEntData() {
        ArrayList<Object[]> list = new ArrayList<Object[]>(3);
        String name = ResManager.loadKDString((String)"\u59d3\u540d", (String)"BankOfferHelper_12", (String)"swc-hsas-business", (Object[])new Object[0]);
        Object[] one = new Object[]{name, "2", name, "salaryfilehis.person.name", "hsas_bankofferexport", 0, null, EMPTY, Boolean.FALSE, Boolean.FALSE};
        String amount = ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d", (String)"BankOfferHelper_35", (String)"swc-hsas-business", (Object[])new Object[0]);
        Object[] two = new Object[]{amount, "2", amount, "payamount", "hsas_bankofferexport", 0, null, EMPTY, Boolean.TRUE, Boolean.FALSE};
        String bankAccount = ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7", (String)"BankOfferHelper_48", (String)"swc-hsas-business", (Object[])new Object[0]);
        Object[] three = new Object[]{bankAccount, "2", bankAccount, "perbankcard.bankcardnum", "hsas_bankofferexport", 0, null, EMPTY, Boolean.FALSE, Boolean.FALSE};
        list.add(one);
        list.add(two);
        list.add(three);
        return list;
    }

    public static boolean isNotRightFiledLength(String payDetailValue, String filedValue, String fieldName, int filedLength, StringBuilder errorMsg) {
        if (filedLength >= BankOfferHelper.length(payDetailValue)) {
            return false;
        }
        String msg = ResManager.loadKDString((String)"\u62a5\u76d8\u660e\u7ec6\u5b57\u6bb5\u201c{0}\u201d\u7684\u5b57\u6bb5\u6765\u6e90\u201c{1}\u201d\u503c\u957f\u5ea6\u8d85\u8fc7\u6a21\u677f\u9650\u5236\u201c{2}\u201d\u3002", (String)"BankOfferHelper_62", (String)"swc-hsas-business", (Object[])new Object[]{fieldName, filedValue, String.valueOf(filedLength)});
        errorMsg.append(msg);
        return true;
    }

    public static boolean isNull(Object payDetailValue, String fieldName, String filedValue, StringBuilder errorMsg) {
        if (payDetailValue != null && SWCStringUtils.isNotEmpty((String)payDetailValue.toString())) {
            return false;
        }
        String msg = ResManager.loadKDString((String)"\u62a5\u76d8\u660e\u7ec6\u5b57\u6bb5\u201c{0}\u201d\u7684\u5b57\u6bb5\u6765\u6e90\u201c{1}\u201d\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankOfferHelper_82", (String)"swc-hsas-business", (Object[])new Object[]{fieldName, filedValue});
        errorMsg.append(msg);
        return true;
    }

    public static void getFiledLengthErrorDTO(StringBuilder errorMsg, Long payDetailId, List<BankOfferExportErrorDTO> errorDTOS) {
        errorMsg.append(ResManager.loadKDString((String)"\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25\u3002", (String)"BankOfferHelper_63", (String)"swc-hsas-business", (Object[])new Object[0]));
        BankOfferExportErrorDTO errorDTO = BankOfferHelper.getErrorDTO(errorMsg.toString(), payDetailId);
        errorDTOS.add(errorDTO);
    }

    private static BankOfferExportErrorDTO getErrorDTO(String errorMsg, Long id) {
        BankOfferExportErrorDTO dto = new BankOfferExportErrorDTO();
        dto.setId(id);
        dto.setErrorMsg(errorMsg);
        return dto;
    }

    private static void setErrorDTO(BankOfferExportErrorDTO dto, DynamicObject payDetail) {
        String personName = payDetail.getString("salaryfilehis.person.name");
        String empNumber = payDetail.getString("salaryfilehis.person.number");
        String salaryFileHisNumber = payDetail.getString("salaryfilehis.number");
        String orgName = payDetail.getString("org.name");
        String adminorgName = payDetail.getString("adminorg.name");
        String empgroupName = payDetail.getString("empgroup.name");
        String companyName = payDetail.getString("company.name");
        String departmentName = payDetail.getString("department.name");
        String positionName = payDetail.getString("position.name");
        String jobName = payDetail.getString("job.name");
        String laborreltypeName = payDetail.getString("laborreltype.name");
        String laborrelstatusName = payDetail.getString("laborrelstatus.name");
        String calTaskNumber = payDetail.getString("caltask.number");
        String payrollGroupName = payDetail.getString("payrollgroup.name");
        Date payrollDate = payDetail.getDate("payrolldate");
        String salaryItemName = payDetail.getString("salaryitem.name");
        String payCurrencyName = payDetail.getString("paycurrency.name");
        String payAmount = payDetail.getString("payamount");
        String payTypeName = payDetail.getString("paytype.name");
        String paySubjectHisName = payDetail.getString("paysubjecthis.name");
        dto.setPersonName(personName);
        dto.setEmpNumber(empNumber);
        dto.setSalaryFileNumber(salaryFileHisNumber);
        dto.setOrgName(orgName);
        dto.setAdminorgName(adminorgName);
        dto.setEmpgroupName(empgroupName);
        dto.setCompanyName(companyName);
        dto.setDepartmentName(departmentName);
        dto.setPositionName(positionName);
        dto.setJobName(jobName);
        dto.setLaborreltypeName(laborreltypeName);
        dto.setLaborrelstatusName(laborrelstatusName);
        dto.setCalTaskNumber(calTaskNumber);
        dto.setPayrollGroupName(payrollGroupName);
        dto.setPayrollDate(payrollDate);
        dto.setSalaryItemName(salaryItemName);
        dto.setPayCurrencyName(payCurrencyName);
        dto.setPayAmount(payAmount);
        dto.setPayType(payTypeName);
        dto.setPaySubjectHisName(paySubjectHisName);
    }

    public static int length(String value) {
        int valueLength = 0;
        if (SWCStringUtils.isEmpty((String)value)) {
            return valueLength;
        }
        String chinese = "[\u0391-\uffe5]";
        for (int i = 0; i < value.length(); ++i) {
            String temp = value.substring(i, i + 1);
            if (temp.matches(chinese)) {
                valueLength += 2;
                continue;
            }
            ++valueLength;
        }
        return valueLength;
    }

    public static String getTabString(int fieldLength, int maxLength) {
        double maxTabNum = Math.ceil((float)maxLength / 8.0f);
        int fieldTabNum = (int)Math.ceil((float)(8.0 * maxTabNum - (double)fieldLength) / 8.0f);
        StringBuilder tabString = new StringBuilder();
        for (int i = 0; i < fieldTabNum; ++i) {
            tabString.append('\t');
        }
        return tabString.toString();
    }

    public static String fmtMicrometer(String text) {
        BigDecimal bigDecimal = new BigDecimal(text);
        NumberFormat numberInstance = DecimalFormat.getNumberInstance();
        numberInstance.setMinimumFractionDigits(bigDecimal.scale());
        return numberInstance.format(bigDecimal);
    }

    public static String swallowField(String filedValue, String fixWay, int fieldLength, String fixContent) {
        StringBuilder builder = new StringBuilder();
        if ("1".equals(fixWay) || "3".equals(fixWay)) {
            String swallowFiled = StringUtils.leftPad((String)EMPTY, (int)(fieldLength - BankOfferHelper.length(filedValue)), (String)fixContent);
            builder.append(swallowFiled);
            builder.append(filedValue);
        } else {
            String swallowFiled = StringUtils.rightPad((String)EMPTY, (int)(fieldLength - BankOfferHelper.length(filedValue)), (String)fixContent);
            builder.append(filedValue);
            builder.append(swallowFiled);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(Workbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            String attachmentFullUrl;
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            fileName = fileName + EXCEL_SUFFIX;
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            RequestContext requestContext = RequestContext.get();
            String list = UUID.randomUUID().toString();
            String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)list, (String)fileName);
            FileItem item = new FileItem(fileName, pathParam, (InputStream)inStream);
            String path = fileService.upload(item);
            String string = attachmentFullUrl = UrlService.getAttachmentFullUrl((String)path);
            return string;
        }
        catch (Exception e) {
            logger.error("get errorExcel fail:", (Throwable)e);
            logger.info("get errorExcel fail {}", (Object)e.getMessage());
            String string = EMPTY;
            return string;
        }
        finally {
            if (null != outStream) {
                outStream.close();
            }
            if (null != inStream) {
                inStream.close();
            }
        }
    }

    public static String[] getFiledName(Object obj) {
        Field[] fields = obj.getClass().getDeclaredFields();
        String[] fieldNames = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldNames[i] = fields[i].getName();
        }
        return fieldNames;
    }

    public static Object getFieldValueByName(String fieldName, Object obj) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = obj.getClass().getMethod(getter, new Class[0]);
            Object value = method.invoke(obj, new Object[0]);
            return value;
        }
        catch (Exception e) {
            logger.info("get fieldValue reflex fail {}", (Object)e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void errorExcelExport(List<BankOfferExportErrorDTO> allErrorDTOS, String recordId) {
        if (CollectionUtils.isEmpty(allErrorDTOS)) {
            return;
        }
        String excelUrl = null;
        ExportResult exportResult = new ExportResult(0);
        ArrayList payDetailIds = new ArrayList(10);
        allErrorDTOS.forEach(dto -> payDetailIds.add(dto.getId()));
        String now = SWCDateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd");
        String fileName = MessageFormat.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u62a5\u76d8\u5931\u8d25\u8be6\u60c5_{0}", (String)"BankOfferTpl_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]), now);
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("errorDTO", new BankOfferExportErrorDTO());
        param.put("filename", fileName);
        param.put("fieldNameMap", BankOfferHelper.getPayDetailErrorDTOFieldMap());
        WorkbookInfo workbookInfo = WorkbookBankOfferDeclareExport.generateErrorWb(param);
        List<?> data = BankOfferHelper.getData(allErrorDTOS);
        SXSSFWorkbook wb = new SXSSFWorkbook(workbookInfo.getRowAccessWindowSize());
        ExcelHelper.writeData((Workbook)wb, workbookInfo, new PageBatchDataProvider(){}.addData(data), exportResult, new ArrayList<BankOfferExportFiledDTO>(), true);
        try {
            excelUrl = BankOfferHelper.writeFile((Workbook)wb, fileName);
        }
        catch (IOException e) {
            logger.info("get export excel write fail {}", (Object)e.getMessage());
        }
        try {
            ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_BANKOFFER_%s", recordId));
            appCache.put("failDetailUrl", (Object)excelUrl);
        }
        catch (Exception e) {
            logger.info("get export excel fail {}", (Object)e.getMessage());
        }
        finally {
            try {
                wb.close();
            }
            catch (Exception e) {
                logger.error("Template file close fail when newWorkbook", (Throwable)e);
            }
        }
    }

    public static List<?> getData(List<BankOfferExportErrorDTO> allErrorDTOS) {
        ArrayList dataList = new ArrayList(10);
        String[] filedNameArr = BankOfferHelper.getFiledName(new BankOfferExportErrorDTO());
        for (BankOfferExportErrorDTO errorDTO : allErrorDTOS) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            for (String filedName : filedNameArr) {
                Object fieldValue;
                if ("id".equals(filedName) || "serialVersionUID".equals(filedName) || null == (fieldValue = BankOfferHelper.getFieldValueByName(filedName, errorDTO))) continue;
                if ("payrollDate".equals(filedName)) {
                    Date date = (Date)fieldValue;
                    dataMap.put(filedName, SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd"));
                    continue;
                }
                if ("calCount".equals(filedName)) {
                    dataMap.put(filedName, String.valueOf(fieldValue));
                    continue;
                }
                dataMap.put(filedName, fieldValue);
            }
            dataList.add(dataMap);
        }
        return dataList;
    }

    public static String FieldStringToName(String field, String value) {
        String str = EMPTY;
        if ("periodcategory".equals(field)) {
            if ("1".equals(value)) {
                str = ResManager.loadKDString((String)"\u56fa\u5b9a\u6838\u7b97\u5468\u671f", (String)"BankOfferHelper_77", (String)"swc-hsas-business", (Object[])new Object[0]);
            } else if ("0".equals(value)) {
                str = ResManager.loadKDString((String)"\u4e34\u65f6\u6838\u7b97\u5468\u671f", (String)"BankOfferHelper_78", (String)"swc-hsas-business", (Object[])new Object[0]);
            }
        } else {
            str = "paytype".equals(field) ? SWCBaseDataSummaryHelper.getPaymethod((String)value) : value;
        }
        return str;
    }

    public static RoundingMode getRoundingMode(long dataRoundId) {
        if (dataRoundId == 1010L) {
            return RoundingMode.HALF_UP;
        }
        if (dataRoundId == 1020L) {
            return RoundingMode.DOWN;
        }
        if (dataRoundId == 1030L) {
            return RoundingMode.UP;
        }
        return RoundingMode.HALF_UP;
    }

    public static Map<String, String> getSeparateDropDownMap() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("0", "|");
        map.put("1", ",");
        map.put("2", ";");
        map.put("3", EMPTY);
        map.put("4", " ");
        map.put("5", EMPTY);
        return map;
    }

    public static Object getPayDetailValueString(Object payDetailObjValue, String fieldSelect, DynamicObject payDetail) {
        String payDetailValue = EMPTY;
        if (payDetailObjValue instanceof Date) {
            payDetailValue = "payrolldate".equals(fieldSelect) ? SWCDateTimeUtils.format((Date)((Date)payDetailObjValue), (String)"yyyy-MM") : ("STARTDATE".equals(fieldSelect) || "ENDDATE".equals(fieldSelect) ? SWCInteDateTimeUtil.formatDate((String)"hsas_calpayrolltask", (String)fieldSelect, (Date)((Date)payDetailObjValue)) : SWCDateTimeUtils.format((Date)((Date)payDetailObjValue), (String)"yyyy-MM-dd"));
        } else {
            if (payDetailObjValue instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)payDetailObjValue;
                String amountPrecision = BankOfferHelper.getAmountPrecisionMap().get(fieldSelect);
                if (SWCStringUtils.isNotEmpty((String)amountPrecision)) {
                    long dataRoundId = payDetail.getLong("salaryitem.dataround.id");
                    bigDecimal = bigDecimal.setScale(payDetail.getInt(amountPrecision), BankOfferHelper.getRoundingMode(dataRoundId));
                } else {
                    bigDecimal = bigDecimal.stripTrailingZeros();
                }
                return bigDecimal;
            }
            if (payDetailObjValue != null) {
                payDetailValue = payDetailObjValue.toString();
                payDetailValue = BankOfferHelper.FieldStringToName(fieldSelect, payDetailValue);
            }
        }
        return payDetailValue;
    }

    static {
        BASEDATA_MAP.put("country", "caltask.country");
        BASEDATA_MAP.put("totalamount", "payamount");
        BASEDATA_MAP.put("paysubjecthisnum", "paysubjecthis.number");
        BASEDATA_MAP.put("agentpaybank", "agentpaybank.union_number");
        BASEDATA_MAP.put("bankcgsettingid", "agentpaybank.bank_cate");
        BASEDATA_MAP.put("bankcgsettingnum", "agentpaybank.bank_cate.type_code");
        NOT_PAY_DETAIL_FILED.add("totalnum");
        NOT_PAY_DETAIL_FILED.add("exportdate");
    }
}

