/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bankoffer;

import com.google.common.collect.HashBasedTable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.swc.hsas.business.agencypay.AgencyPayWriteBackService;
import kd.swc.hsas.business.bankoffer.BankOfferHelper;
import kd.swc.hsas.business.bankoffer.IExportService;
import kd.swc.hsas.business.bankoffer.exportsource.BaseExportSource;
import kd.swc.hsas.business.bankoffer.exportsource.BlankExportSource;
import kd.swc.hsas.business.bankoffer.exportsource.CustomExportSource;
import kd.swc.hsas.business.bankoffer.exportsource.FieldExportSource;
import kd.swc.hsas.business.bankoffer.exportsource.FixedExportSource;
import kd.swc.hsas.business.bankoffer.exportsource.SeqExportSource;
import kd.swc.hsas.business.bankoffer.vo.exportPackage.DataPackage;
import kd.swc.hsas.business.bankoffer.vo.exportPackage.ResultPackage;
import kd.swc.hsas.common.dto.BankOfferBatchExportDTO;
import kd.swc.hsas.common.dto.BankOfferExportErrorDTO;
import kd.swc.hsas.common.dto.BankOfferExportFiledDTO;
import kd.swc.hsas.common.dto.BankOfferFetchResultDTO;
import kd.swc.hsas.common.dto.BankOfferSelectTplDTO;
import kd.swc.hsas.common.dto.BankOfferSplitBatchDTO;
import kd.swc.hsas.common.enums.BankOfferEnum;
import kd.swc.hsbp.business.coderule.CodeRuleHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public abstract class BaseExportService
implements IExportService {
    protected static final Log log = LogFactory.getLog(BaseExportService.class);
    private static final ExecutorService EXPORT_PAYDETAILEXPORT_POOL = ThreadPools.newExecutorService((String)"EXPORT_PAYDETAILEXPORT_POOL", (int)4);
    private DataPackage dataPackage;
    private ResultPackage resultPackage;

    public BaseExportService(DataPackage dataPackage) {
        this.dataPackage = dataPackage;
        this.resultPackage = new ResultPackage();
    }

    public final void handleExport() {
        try {
            this.getExportData();
            this.assembleExportData();
            this.dealExportData();
        }
        catch (Exception e) {
            log.error("export error :", (Throwable)e);
            this.exceptionResultDeal(e.getMessage().substring(0, 100));
        }
    }

    protected DataPackage getDataPackage() {
        return this.dataPackage;
    }

    public void exceptionResultDeal(String errorMsg) {
    }

    public void assembleExportDataAfter(List<List<Object>> dataList, List<BankOfferExportFiledDTO> exportFiledCopy) {
    }

    public List<List<Object>> getDataList(List<Long> splitPayDetailIds, List<BankOfferExportFiledDTO> exportFiledDTO, HashBasedTable<Long, Integer, Object> dataTable) {
        return new ArrayList<List<Object>>(10);
    }

    public List<BaseBankOfferBatchExportThread> dealExportDataBefore(List<BankOfferSplitBatchDTO> splitBatchDTOList) {
        return new ArrayList<BaseBankOfferBatchExportThread>(10);
    }

    @Override
    public void getExportData() {
        BankOfferBatchExportDTO batchExport = this.dataPackage.getBatchExport();
        List<BankOfferExportFiledDTO> exportFiledList = this.dataPackage.getExportFiledDTO();
        DynamicObject bankOfferTpl = this.dataPackage.getBankOfferTpl();
        Set<String> fileTableHeadSet = this.dataPackage.getFileTableHeadSet();
        List payDetailIds = batchExport.getIds();
        Map groupMap = exportFiledList.stream().collect(Collectors.groupingBy(BankOfferExportFiledDTO::getFieldSource, Collectors.toList()));
        BankOfferFetchResultDTO fetchResult = new BankOfferFetchResultDTO(payDetailIds);
        groupMap.forEach((source, filedList) -> {
            BaseExportSource exportSource = this.getExportSource((String)source);
            exportSource.setBankOfferTpl(bankOfferTpl);
            exportSource.setFileHeadSet(fileTableHeadSet);
            exportSource.getExportData(fetchResult, (List<BankOfferExportFiledDTO>)filedList);
        });
        Map exportErrorMap = fetchResult.getExportErrorMap();
        HashBasedTable dataTable = fetchResult.getDataTable();
        List exportErrorDTOS = batchExport.getExportErrorDTOS();
        exportErrorDTOS.addAll(exportErrorMap.values());
        batchExport.setExportErrorDTOS(exportErrorDTOS);
        this.dataPackage.setHeadTable((HashBasedTable<Long, String, Object>)fetchResult.getHeadTable());
        this.dataPackage.setDataTable((HashBasedTable<Long, Integer, Object>)dataTable);
        this.dataPackage.setLimitSeq(fetchResult.getLimitSeq());
        this.dataPackage.setFiledDataTypeTable((HashBasedTable<String, String, String>)fetchResult.getFiledDataTypeTable());
    }

    @Override
    public void assembleExportData() {
        BankOfferBatchExportDTO batchExport = this.dataPackage.getBatchExport();
        List payDetailIds = batchExport.getIds();
        List errorDTOS = batchExport.getExportErrorDTOS();
        errorDTOS.forEach(exportError -> {
            Long id = exportError.getId();
            payDetailIds.remove(id);
        });
        String recordId = batchExport.getRecordId();
        ArrayList<BankOfferSplitBatchDTO> splitBatchList = new ArrayList<BankOfferSplitBatchDTO>(10);
        if (!payDetailIds.isEmpty()) {
            BankOfferSplitBatchDTO splitBatch;
            HashBasedTable<Long, Integer, Object> dataTable = this.dataPackage.getDataTable();
            Integer limitSeq = this.dataPackage.getLimitSeq();
            List<List<Long>> spiltIdList = this.groupData(payDetailIds, dataTable, limitSeq);
            HashBasedTable<Long, String, Object> headTable = this.dataPackage.getHeadTable();
            for (List<Long> splitPayDetailIds : spiltIdList) {
                splitBatch = this.checkUnique(splitPayDetailIds, headTable);
                if (splitBatch == null) continue;
                List<BankOfferExportFiledDTO> exportFiledCopy = this.dataPackage.getExportFiledDTO().stream().map(BankOfferExportFiledDTO::cloneThis).collect(Collectors.toList());
                List<List<Object>> dataList = this.getDataList(splitPayDetailIds, exportFiledCopy, dataTable);
                this.assembleExportDataAfter(dataList, exportFiledCopy);
                splitBatch.setDataList(dataList);
                splitBatch.setExportFiledDTOList(exportFiledCopy);
                splitBatchList.add(splitBatch);
            }
            if (!splitBatchList.isEmpty()) {
                long[] batchIds = DB.genLongIds((String)"hsas_bankofferrrec", (int)splitBatchList.size());
                for (int index = 0; index < splitBatchList.size(); ++index) {
                    splitBatch = (BankOfferSplitBatchDTO)splitBatchList.get(index);
                    splitBatch.setBatchId(Long.valueOf(batchIds[index]));
                }
                this.saveExportPayDetail(batchIds, recordId, RequestContext.get().getCurrUserId(), splitBatchList);
            }
        }
        BankOfferHelper.setErrorPayDetailInfo(batchExport.getExportErrorDTOS());
        ISWCAppCache cache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_BANKOFFER_%s", recordId));
        cache.put(String.format(Locale.ROOT, "SWC_BANKOFFER_BATCH_%s", batchExport.getId()), (Object)batchExport);
        BankOfferHelper.updateBankOfferProgressInfo(cache, recordId, batchExport.getExportErrorDTOS().size(), batchExport.getExportErrorDTOS().size());
        log.info("finish num : {}", (Object)batchExport.getExportErrorDTOS().size());
        this.resultPackage.setSplitBatchDTOList(splitBatchList);
    }

    @Override
    public void dealExportData() {
        List<BankOfferSplitBatchDTO> splitBatchDTOList = this.resultPackage.getSplitBatchDTOList();
        List<BaseBankOfferBatchExportThread> exportThreadList = this.dealExportDataBefore(splitBatchDTOList);
        exportThreadList.forEach(EXPORT_PAYDETAILEXPORT_POOL::submit);
        this.dataPackage.getDataTable().clear();
        this.dataPackage.getHeadTable().clear();
    }

    private BaseExportSource getExportSource(String source) {
        BaseExportSource baseExportSource;
        switch (source) {
            case "1": {
                baseExportSource = new FixedExportSource();
                break;
            }
            case "2": {
                baseExportSource = new FieldExportSource();
                break;
            }
            case "3": {
                baseExportSource = new SeqExportSource();
                break;
            }
            case "4": {
                baseExportSource = new CustomExportSource();
                break;
            }
            case "5": {
                baseExportSource = new BlankExportSource();
                break;
            }
            default: {
                baseExportSource = new BlankExportSource();
            }
        }
        return baseExportSource;
    }

    private List<List<Long>> groupData(List<Long> payDetailIds, HashBasedTable<Long, Integer, Object> dataTable, Integer limitSeq) {
        DynamicObject bankOfferTpl = this.dataPackage.getBankOfferTpl();
        String limitContent = bankOfferTpl.getString("limitcontent");
        List<List<Long>> splitPayDetailIdList = new ArrayList<ArrayList<Long>>(10);
        if ("1".equals(limitContent)) {
            int limitLine = bankOfferTpl.getInt("limitline");
            splitPayDetailIdList = SWCListUtils.split(new ArrayList<Long>(payDetailIds), (int)limitLine);
        } else if ("3".equals(limitContent)) {
            BigDecimal limitAmount = bankOfferTpl.getBigDecimal("limitamount");
            splitPayDetailIdList = this.listSplitByAmount(dataTable, payDetailIds, limitAmount, limitSeq);
        } else {
            splitPayDetailIdList.add(new ArrayList<Long>(payDetailIds));
        }
        return splitPayDetailIdList;
    }

    private List<List<Long>> listSplitByAmount(HashBasedTable<Long, Integer, Object> dataTable, List<Long> payDetailIds, BigDecimal limitAmount, Integer limitSeq) {
        ArrayList<List<Long>> splitPayDetailIdList = new ArrayList<List<Long>>(10);
        ArrayList<Long> splitList = new ArrayList<Long>(10);
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (Long payDetailId : payDetailIds) {
            ArrayList<Long> splitListCopy;
            BigDecimal payAmount = (BigDecimal)dataTable.get((Object)payDetailId, (Object)limitSeq);
            payAmount = payAmount != null ? payAmount : BigDecimal.ZERO;
            if (limitAmount.compareTo(totalAmount = totalAmount.add(payAmount)) > 0) {
                splitList.add(payDetailId);
                continue;
            }
            if (limitAmount.compareTo(totalAmount) == 0) {
                splitList.add(payDetailId);
                splitListCopy = new ArrayList(splitList.size());
                splitListCopy.addAll(splitList);
                splitList.clear();
                totalAmount = BigDecimal.ZERO;
                splitPayDetailIdList.add(splitListCopy);
                continue;
            }
            splitListCopy = new ArrayList<Long>(splitList.size());
            splitListCopy.addAll(splitList);
            splitPayDetailIdList.add(splitListCopy);
            splitList.clear();
            totalAmount = payAmount;
            splitList.add(payDetailId);
        }
        if (splitList.size() > 0) {
            splitPayDetailIdList.add(splitList);
        }
        return splitPayDetailIdList;
    }

    private BankOfferSplitBatchDTO checkUnique(List<Long> splitPayDetailIds, HashBasedTable<Long, String, Object> headTable) {
        BankOfferBatchExportDTO batchExport = this.dataPackage.getBatchExport();
        HashSet<String> errorFields = new HashSet<String>(16);
        Map<String, String> filedNameMap = this.getErrorField(splitPayDetailIds, headTable, errorFields);
        ArrayList<BankOfferExportErrorDTO> errorDTOS = new ArrayList<BankOfferExportErrorDTO>(splitPayDetailIds.size());
        if (BankOfferHelper.isSameFileName(new ArrayList<String>(errorFields), splitPayDetailIds, errorDTOS)) {
            List exportErrorDTOS = batchExport.getExportErrorDTOS();
            exportErrorDTOS.addAll(errorDTOS);
            batchExport.setExportErrorDTOS(exportErrorDTOS);
            return null;
        }
        return new BankOfferSplitBatchDTO(splitPayDetailIds, null, filedNameMap);
    }

    private Map<String, String> getErrorField(List<Long> payDetailIds, HashBasedTable<Long, String, Object> headTable, Set<String> errorFields) {
        HashMap<String, String> mapFileName = new HashMap<String, String>(16);
        HashMap<String, Set> map = new HashMap<String, Set>(16);
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (Long payDetailId : payDetailIds) {
            Map nameMap = headTable.row((Object)payDetailId);
            for (Map.Entry entry : nameMap.entrySet()) {
                String entryKey = (String)entry.getKey();
                Object entryValue = entry.getValue();
                if ("payamount".equals(entryKey)) {
                    totalAmount = totalAmount.add((BigDecimal)entryValue);
                    continue;
                }
                Set valueSet = map.getOrDefault(entryKey, new HashSet());
                if (valueSet.size() > 1) continue;
                if (SWCStringUtils.isNotEmpty((String)entryValue.toString())) {
                    valueSet.add(entryValue);
                }
                map.put(entryKey, valueSet);
            }
        }
        map.forEach((key, value) -> {
            if (value.size() > 1) {
                errorFields.add((String)key);
            } else if (value.isEmpty()) {
                mapFileName.put((String)key, "");
            } else {
                mapFileName.put((String)key, value.iterator().next().toString());
            }
        });
        if (errorFields.isEmpty()) {
            this.getNameMap(mapFileName, payDetailIds, totalAmount);
        }
        return mapFileName;
    }

    private void getNameMap(Map<String, String> mapFileName, List<Long> payDetailIds, BigDecimal totalAmount) {
        mapFileName.put("exportdate", SWCInteDateTimeUtil.formateDate((Date)new Date()));
        mapFileName.put("totalnum", String.valueOf(payDetailIds.size()));
        mapFileName.put("country", mapFileName.get("caltask.country"));
        mapFileName.put("bankcgsettingid", mapFileName.get("agentpaybank.bank_cate"));
        mapFileName.put("totalamount", totalAmount.toPlainString());
        mapFileName.put("bankcgsettingnum", this.getBankCate(mapFileName.get("agentpaybank.bank_cate.type_code")));
        mapFileName.put("paysubjecthisnum", mapFileName.get("paysubjecthis.number"));
        mapFileName.put("agentpaybank", mapFileName.get("agentpaybank.union_number"));
    }

    private String getBankCate(String id) {
        if (SWCStringUtils.isEmpty((String)id)) {
            return "";
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("bd_bankcgsetting");
        String selectProperties = "id,type_code";
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(id));
        DynamicObject dynamicObject = helper.queryOne(selectProperties, new QFilter[]{filter});
        return dynamicObject.getString("type_code");
    }

    private void saveExportPayDetail(long[] batchIds, String recordId, Long userId, List<BankOfferSplitBatchDTO> splitBatchDTOS) {
        SWCDataServiceHelper exportRecordHelper = new SWCDataServiceHelper("hsas_bankofferrrec");
        Date nowDate = new Date();
        DynamicObjectCollection exportBatchCollection = new DynamicObjectCollection();
        int idNum = 0;
        for (BankOfferSplitBatchDTO splitBatchDTO : splitBatchDTOS) {
            long id = batchIds[idNum++];
            DynamicObject exportRecord = exportRecordHelper.generateEmptyDynamicObject();
            exportRecord.set("reportstatus", (Object)BankOfferEnum.EXPORTING.getCode());
            exportRecord.set("reportoperation", (Object)recordId);
            exportRecord.set("createtime", (Object)nowDate);
            exportRecord.set("modifytime", (Object)nowDate);
            exportRecord.set("creator", (Object)userId);
            exportRecord.set("modifier", (Object)userId);
            exportRecord.set("id", (Object)id);
            DynamicObjectCollection exportRecordCollection = exportRecord.getDynamicObjectCollection("entryentity");
            exportRecord.set("entryentity", (Object)exportRecordCollection);
            List payDetailIdList = splitBatchDTO.getPayDetailIdList();
            for (int num = 0; num < payDetailIdList.size(); ++num) {
                Long payDetailId = (Long)payDetailIdList.get(num);
                DynamicObject payEntryDynamicObject = exportRecordHelper.generateEmptyEntryDynamicObject("entryentity");
                payEntryDynamicObject.set("seq", (Object)num);
                payEntryDynamicObject.set("paydetail", (Object)payDetailId);
                exportRecordCollection.add(num, payEntryDynamicObject);
            }
            exportBatchCollection.add((Object)exportRecord);
        }
        exportRecordHelper.save(exportBatchCollection);
    }

    public class BaseBankOfferBatchExportThread
    implements Runnable {
        private RequestContext requestContext;
        protected BankOfferSplitBatchDTO splitBatch;
        protected BankOfferBatchExportDTO dto;
        protected DynamicObject bankOfferTpl;
        protected BankOfferSelectTplDTO selectTpl;
        protected List<BankOfferExportFiledDTO> exportFileDTO;
        protected String fileExportName;

        public BaseBankOfferBatchExportThread(RequestContext requestContext, BankOfferSplitBatchDTO splitBatch, BankOfferBatchExportDTO dto, DynamicObject bankOfferTpl, BankOfferSelectTplDTO selectTpl) {
            this.splitBatch = splitBatch;
            this.dto = dto;
            this.bankOfferTpl = bankOfferTpl;
            this.requestContext = requestContext;
            this.selectTpl = selectTpl;
            this.exportFileDTO = splitBatch.getExportFiledDTOList();
        }

        @Override
        public void run() {
            String recordId = this.dto.getRecordId();
            RequestContext.copyAndSet((RequestContext)this.requestContext);
            try {
                this.getExportFileName();
                String exportUrl = this.getExportUrl();
                ISWCAppCache cache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_BANKOFFER_%s", recordId));
                Boolean isCancel = (Boolean)cache.get(String.format(Locale.ROOT, "isCancel_%s", recordId), Boolean.class);
                if (isCancel.booleanValue()) {
                    return;
                }
                this.dto.addUrl(exportUrl);
                cache.put(String.format(Locale.ROOT, "SWC_BANKOFFER_BATCH_%s", this.dto.getId()), (Object)this.dto);
                int totalNum = this.splitBatch.getDataList().size();
                BankOfferHelper.updateBankOfferProgressInfo(cache, recordId, totalNum, 0);
                this.inverseExportData(exportUrl, totalNum, 0);
            }
            catch (Exception exception) {
                log.error("export error :", (Throwable)exception);
            }
        }

        void getExportFileName() {
            Map filedNameMap = this.splitBatch.getFiledNameMap();
            String fileName = this.bankOfferTpl.getString("filename");
            this.fileExportName = BankOfferHelper.extractMessage(fileName, null, filedNameMap);
            this.fileExportName = SWCStringUtils.isEmpty((String)this.fileExportName) ? " " : this.fileExportName;
        }

        public String getExportUrl() throws Exception {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void inverseExportData(String exportUrl, int totalNum, int errorNum) {
            try (TXHandle txHandle = TX.requiresNew();){
                Long batchId = this.splitBatch.getBatchId();
                this.updateBankOfferRec(batchId);
                Long bankOfferLogId = 0L;
                int successNum = totalNum - errorNum;
                if (successNum > 0) {
                    bankOfferLogId = this.insertBankOfferLog(exportUrl, successNum, batchId);
                }
                HashSet<Long> calPersonIds = new HashSet<Long>(16);
                List payDetailIds = this.splitBatch.getPayDetailIdList();
                this.updatePayDetailBankOfferStatus(payDetailIds, bankOfferLogId, calPersonIds);
                AgencyPayWriteBackService service = new AgencyPayWriteBackService();
                service.updateCaltablePayState(calPersonIds);
                log.info("finish num :" + payDetailIds.size());
            }
        }

        private void updateBankOfferRec(Long batchId) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bankofferrrec");
            String selectProperties = "id,reportstatus,modifytime";
            QFilter filter = new QFilter("id", "=", (Object)batchId);
            DynamicObject dynamicObject = helper.queryOne(selectProperties, new QFilter[]{filter});
            if (dynamicObject != null) {
                dynamicObject.set("reportstatus", (Object)BankOfferEnum.EXPORTED.getCode());
                dynamicObject.set("modifytime", (Object)new Date());
            }
            helper.updateOne(dynamicObject);
        }

        private Long insertBankOfferLog(String url, int dataAmount, Long batchId) {
            Date date = new Date();
            long userId = RequestContext.get().getCurrUserId();
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bankreportlog");
            DynamicObject dynamicObject = helper.generateEmptyDynamicObject();
            String number = CodeRuleHelper.getNumber((DynamicObject)dynamicObject, null);
            dynamicObject.set("number", (Object)number);
            dynamicObject.set("bankcgsetting", (Object)this.selectTpl.getBankCgSettingId());
            dynamicObject.set("bankoffertpl", (Object)this.selectTpl.getBankOfferTplVId());
            dynamicObject.set("dataamount", (Object)dataAmount);
            dynamicObject.set("bankofferdesc", (Object)this.selectTpl.getBankOfferDesc());
            dynamicObject.set("isfailure", (Object)Boolean.FALSE);
            dynamicObject.set("bankofferurl", (Object)url);
            dynamicObject.set("bankofferrrec", (Object)batchId);
            dynamicObject.set("createtime", (Object)date);
            dynamicObject.set("modifytime", (Object)date);
            dynamicObject.set("creator", (Object)userId);
            dynamicObject.set("modifier", (Object)userId);
            helper.saveOne(dynamicObject);
            return dynamicObject.getLong("id");
        }

        private void updatePayDetailBankOfferStatus(List<Long> payDetailIds, Long logId, Set<Long> calPersonIds) {
            DynamicObject[] query;
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
            String selectProperties = "id,bankofferstatus,bankoffertimes,bankofferlog,calpersonid,paystate";
            QFilter filter = new QFilter("id", "in", payDetailIds);
            for (DynamicObject dynamicObject : query = helper.query(selectProperties, new QFilter[]{filter})) {
                dynamicObject.set("bankofferstatus", (Object)BankOfferEnum.EXPORTED.getCode());
                dynamicObject.set("bankofferlog", (Object)logId);
                dynamicObject.set("bankoffertimes", (Object)(dynamicObject.getInt("bankoffertimes") + 1));
                dynamicObject.set("paystate", (Object)PayStateEnum.UNPAY.getCode());
                calPersonIds.add(dynamicObject.getLong("calpersonid"));
            }
            helper.update(query);
        }
    }
}

