/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bankoffer.excel;

import java.util.Map;
import kd.bos.extension.ExtensionFactory;
import kd.swc.hsas.business.bankoffer.excel.BaseCellStyleGenerator;
import kd.swc.hsas.business.bankoffer.excel.CellStyleGeneratorSupplier;
import kd.swc.hsas.business.bankoffer.excel.CustomParamCellStyleGenerator;
import kd.swc.hsas.business.bankoffer.vo.BaseDataConverter;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;

public class CellStyleFactory {
    private static final ExtensionFactory<CellStyleGeneratorSupplier> SUPPLIER_MAP = ExtensionFactory.getExtensionFacotry(CellStyleGeneratorSupplier.class);

    public static CellStyle generateCellStyle(Workbook wb, Map<String, Object> param, String generatorName) {
        BaseCellStyleGenerator prevGenerator;
        CellStyle cellStyle = wb.createCellStyle();
        if (!StringUtils.isEmpty((CharSequence)generatorName) && (prevGenerator = CellStyleFactory.getGeneratorByName(generatorName, param)) != null) {
            prevGenerator.decorate(cellStyle, wb);
        }
        if (!MapUtils.isEmpty(param)) {
            new CustomParamCellStyleGenerator().ofParams(param).decorate(cellStyle, wb);
        }
        return cellStyle;
    }

    public static CellStyle generateCellStyle(Workbook wb, Map<String, Object> param, String ... generatorNames) {
        CellStyle cellStyle = wb.createCellStyle();
        CellStyleFactory.decorate(wb, cellStyle, param, generatorNames);
        return cellStyle;
    }

    public static void decorate(Workbook wb, CellStyle cellStyle, Map<String, Object> param, String[] generatorNames) {
        if (generatorNames != null) {
            for (String name : generatorNames) {
                BaseCellStyleGenerator prevGenerator;
                if (StringUtils.isEmpty((CharSequence)name) || (prevGenerator = CellStyleFactory.getGeneratorByName(name, param)) == null) continue;
                prevGenerator.decorate(cellStyle, wb);
            }
        }
        if (param != null && param.size() > 0) {
            new CustomParamCellStyleGenerator().ofParams(param).decorate(cellStyle, wb);
        }
    }

    private static BaseCellStyleGenerator getGeneratorByName(String name, Map<String, Object> param) {
        CellStyleGeneratorSupplier extension;
        try {
            extension = (CellStyleGeneratorSupplier)SUPPLIER_MAP.getExtension(name);
        }
        catch (Exception e) {
            return null;
        }
        BaseCellStyleGenerator supply = extension.supply();
        if (supply instanceof CustomParamCellStyleGenerator) {
            ((CustomParamCellStyleGenerator)supply).ofParams(param);
        }
        return supply;
    }

    public static Font cloneFont(Font font, Workbook wb, Map<String, Object> fontParams) {
        Font newFont = wb.createFont();
        newFont.setColor(font.getColor());
        if (fontParams != null && fontParams.size() > 0) {
            for (Map.Entry<String, Object> entry : fontParams.entrySet()) {
                switch (entry.getKey()) {
                    case "color": {
                        newFont.setColor(BaseDataConverter.convert(entry.getValue(), Short.class, font.getColor()).shortValue());
                        break;
                    }
                }
            }
        }
        return newFont;
    }
}

