/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bankoffer.excel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.bankoffer.excel.CellStyleFactory;
import kd.swc.hsas.business.bankoffer.excel.DataProvider;
import kd.swc.hsas.business.bankoffer.excel.ValueWrapper;
import kd.swc.hsas.business.bankoffer.vo.BaseDataConverter;
import kd.swc.hsas.business.bankoffer.vo.DataBatch;
import kd.swc.hsas.business.bankoffer.vo.ExportResult;
import kd.swc.hsas.business.bankoffer.vo.GlobalParam;
import kd.swc.hsas.business.bankoffer.vo.HeadCellBar;
import kd.swc.hsas.business.bankoffer.vo.HeadCellInfo;
import kd.swc.hsas.business.bankoffer.vo.SheetInfo;
import kd.swc.hsas.business.bankoffer.vo.WorkbookInfo;
import kd.swc.hsas.business.stream.StreamUtil;
import kd.swc.hsas.common.dto.BankOfferExportFiledDTO;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.streaming.SXSSFSheet;

public class ExcelHelper {
    private static final Log LOGGER = LogFactory.getLog(ExcelHelper.class);

    private ExcelHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Workbook writeData(Workbook wb, WorkbookInfo workbookInfo, DataProvider dataProvider, ExportResult exportResult, List<BankOfferExportFiledDTO> exportFileDTO, boolean isErrorExcel) {
        try {
            Workbook workbook;
            List<SheetInfo> sheetInfoList = workbookInfo.getSheetInfoList();
            if (CollectionUtils.isEmpty(sheetInfoList)) {
                LOGGER.error("Sheet of WB {} is empty", (Object)workbookInfo.fullName());
                exportResult.setFailue(true);
                Workbook workbook2 = null;
                return workbook2;
            }
            CountDownLatch latch = new CountDownLatch(sheetInfoList.size());
            for (int i = 0; i < sheetInfoList.size(); ++i) {
                SheetInfo sheetInfo = sheetInfoList.get(i);
                Sheet sheet = wb.getSheet(sheetInfo.getName());
                if (sheet == null) {
                    sheet = wb.createSheet();
                    int sheetIndex = wb.getSheetIndex(sheet);
                    wb.setSheetName(sheetIndex, sheetInfo.getName());
                }
                if (sheet instanceof SXSSFSheet) {
                    ((SXSSFSheet)sheet).setRandomAccessWindowSize(-1);
                }
                ExcelHelper.fillSheet(dataProvider, exportResult, latch, sheetInfo, sheet, exportFileDTO, isErrorExcel);
            }
            try {
                boolean await = latch.await(5L, TimeUnit.MINUTES);
                if (!await) {
                    exportResult.setFailue(true);
                    workbook = null;
                    return workbook;
                }
            }
            catch (Exception ignored) {
                exportResult.setFailue(true);
                LOGGER.error("export error", (Object)ignored.getMessage());
                workbook = null;
                return workbook;
            }
            Workbook workbook3 = wb;
            return workbook3;
        }
        finally {
            GlobalParam.remove();
        }
    }

    private static void fillSheet(DataProvider dataProvider, ExportResult exportResult, CountDownLatch latch, SheetInfo sheetInfo, Sheet finalSheet, List<BankOfferExportFiledDTO> exportFileDTO, boolean isErrorExcel) {
        RequestContext ctx = RequestContext.get();
        SWCThreadPoolFactory.getCommonExportThreadpool().execute(() -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            try {
                Map<String, CellStyle> bodyCellStyleMap;
                HashMap<String, CellStyle> bodyCellCustomStyleMap = new HashMap<String, CellStyle>(16);
                if (sheetInfo.isNeedFillHead()) {
                    bodyCellStyleMap = ExcelHelper.fillHead(finalSheet, sheetInfo);
                    if (bodyCellStyleMap == null || bodyCellStyleMap.size() == 0) {
                        return;
                    }
                } else {
                    bodyCellStyleMap = new HashMap<String, CellStyle>(0);
                }
                while (dataProvider.hasNextData(sheetInfo.getDataKey())) {
                    DataBatch dataBatch = dataProvider.getNextData(sheetInfo.getDataKey());
                    if (dataBatch != null && dataBatch.hasData()) {
                        RequestContext.copyAndSet((RequestContext)ctx);
                        try {
                            ExcelHelper.fillContent(finalSheet, sheetInfo, dataBatch.getDataList(), dataBatch.getStartRow() + sheetInfo.getBodyRow(), bodyCellStyleMap, bodyCellCustomStyleMap, exportResult, exportFileDTO, isErrorExcel);
                            continue;
                        }
                        catch (Exception e) {
                            LOGGER.error("Error occurs when fillContent", (Throwable)e);
                            continue;
                        }
                        finally {
                            dataProvider.completeBatch(dataBatch);
                            continue;
                        }
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(500L);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                exportResult.setFailue(true);
                LOGGER.error("Error occurs when fillSheet", (Throwable)e);
            }
            finally {
                latch.countDown();
            }
        });
    }

    private static Map<String, CellStyle> fillHead(Sheet sheet, SheetInfo sheetInfo) {
        HeadCellBar headCellBar = sheetInfo.getHeadCellBar();
        if (headCellBar == null) {
            return null;
        }
        int row = sheetInfo.getHeadRow();
        int headSize = headCellBar.size();
        Workbook workbook = sheet.getWorkbook();
        CellStyle defaultHeadCellStyle = CellStyleFactory.generateCellStyle(workbook, null, headCellBar.getHeadCellStyleName());
        CellStyle defaultBodyCellStyle = CellStyleFactory.generateCellStyle(sheet.getWorkbook(), null, headCellBar.getBodyCellStyleName());
        List<HeadCellInfo> headCellInfoList = headCellBar.getHeadCellInfoList();
        HashMap<String, CellStyle> result = new HashMap<String, CellStyle>(headSize);
        for (HeadCellInfo cellInfo : headCellInfoList) {
            if (cellInfo.isContent()) {
                if (cellInfo.needBodySpecialStyle()) {
                    CellStyle bodyCellStyle = CellStyleFactory.generateCellStyle(workbook, cellInfo.getBodyStyleParam(), cellInfo.getBodyStyleName(), headCellBar.getBodyCellStyleName());
                    bodyCellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
                    result.put(cellInfo.getPosFlag(), bodyCellStyle);
                } else {
                    defaultBodyCellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
                    result.put(cellInfo.getPosFlag(), defaultBodyCellStyle);
                }
            }
            if (!headCellBar.isHeadShouldWritten()) continue;
            int realRow = row + cellInfo.getRowNum();
            CellStyle headCellStyle = defaultHeadCellStyle;
            if (cellInfo.needHeadSpecialStyle()) {
                headCellStyle = CellStyleFactory.generateCellStyle(workbook, cellInfo.getHeadStyleParam(), cellInfo.getHeadStyleName(), headCellBar.getHeadCellStyleName());
            }
            Cell cell = ExcelHelper.newCell(sheet, realRow, cellInfo.getColNum(), cellInfo.getRowSpan(), cellInfo.getColSpan(), cellInfo, headCellBar.isHorizontal(), headCellStyle);
            String headValueWrapper = cellInfo.getHeadValueWrapper();
            if (StringUtils.isEmpty((CharSequence)headValueWrapper)) {
                cell.setCellValue(cellInfo.getI18nDesc());
            } else {
                cell.setCellValue(ValueWrapper.wrapWith(cellInfo.getI18nDesc(), String.class, headValueWrapper));
            }
            ExcelHelper.setWidthAndHeight(sheet, headCellBar, cellInfo, realRow);
        }
        return result;
    }

    private static void fillContent(Sheet sheet, SheetInfo sheetInfo, List<?> dataList, int baseRow, Map<String, CellStyle> bodyCellStyleMap, Map<String, CellStyle> bodyCellCustomStyleMap, ExportResult exportResult, List<BankOfferExportFiledDTO> exportFileDTO, boolean isErrorExcel) {
        HeadCellBar headCellBar = sheetInfo.getHeadCellBar();
        if (null == headCellBar) {
            return;
        }
        List<HeadCellInfo> contentHeadList = headCellBar.getContentHeadCellInfoList();
        if (CollectionUtils.isEmpty(contentHeadList)) {
            return;
        }
        if (isErrorExcel) {
            ExcelHelper.errorExcelExport(sheet, dataList, baseRow, bodyCellStyleMap, exportResult, headCellBar, contentHeadList);
        } else {
            ExcelHelper.detailExport(sheet, dataList, baseRow, bodyCellStyleMap, bodyCellCustomStyleMap, exportResult, headCellBar, contentHeadList);
        }
    }

    private static void errorExcelExport(Sheet sheet, List<?> dataList, int baseRow, Map<String, CellStyle> bodyCellStyleMap, ExportResult exportResult, HeadCellBar headCellBar, List<HeadCellInfo> contentHeadList) {
        int currRow = baseRow;
        int dataSize = dataList.size();
        for (int i = 0; i < dataSize; ++i) {
            Map map = (Map)dataList.get(i);
            for (HeadCellInfo headCellInfo : contentHeadList) {
                int colNum = headCellInfo.getColNum();
                String valueProp = headCellInfo.getValueProp();
                String currValue = (String)map.get(valueProp);
                CellStyle bodyCellStyle = bodyCellStyleMap.get(headCellInfo.getPosFlag());
                if ("errorMsg".equals(valueProp)) {
                    bodyCellStyle.setWrapText(true);
                }
                Cell cell = ExcelHelper.newCell(sheet, currRow, colNum, 1, headCellInfo.getColSpan(), headCellInfo, headCellBar.isHorizontal(), bodyCellStyle);
                cell.setCellValue(currValue);
            }
            ++currRow;
            exportResult.incrementAndGet();
        }
    }

    private static void setWidthAndHeight(Sheet sheet, HeadCellBar headCellBar, HeadCellInfo cellInfo, int realRow) {
        int width = cellInfo.getWidth();
        short height = cellInfo.getHeight();
        if (headCellBar.isHorizontal()) {
            sheet.setColumnWidth(cellInfo.getColNum(), sheet.getColumnWidth(cellInfo.getColNum()) * 2);
            if (width > 0) {
                sheet.setColumnWidth(cellInfo.getColNum(), width);
            }
            if (height > 0) {
                sheet.getRow(realRow).setHeight(height);
            }
        } else {
            if (width > 0) {
                sheet.getRow(cellInfo.getColNum()).setHeight(BaseDataConverter.convert(width, Short.class, (short)0).shortValue());
            }
            if (height > 0) {
                sheet.setColumnWidth(realRow, (int)height);
            }
        }
    }

    private static void detailExport(Sheet sheet, List<?> dataList, int baseRow, Map<String, CellStyle> bodyCellStyleMap, Map<String, CellStyle> bodyCellCustomStyleMap, ExportResult exportResult, HeadCellBar headCellBar, List<HeadCellInfo> contentHeadList) {
        int currRow = baseRow;
        int dataSize = dataList.size();
        for (int i = 0; i < dataSize; ++i) {
            Object data = dataList.get(i);
            int index = 0;
            for (HeadCellInfo headCellInfo : contentHeadList) {
                int colNum = headCellInfo.getColNum();
                String valueProp = headCellInfo.getValueProp();
                Object currValue = BaseDataConverter.getValueByProp(data, valueProp);
                CellStyle bodyCellStyle = ExcelHelper.getBodyCellStyle(currValue, sheet, headCellInfo, bodyCellStyleMap, bodyCellCustomStyleMap);
                Cell cell = ExcelHelper.newCell(sheet, currRow, colNum, 1, headCellInfo.getColSpan(), headCellInfo, headCellBar.isHorizontal(), bodyCellStyle);
                if (currValue instanceof BigDecimal) {
                    cell.setCellValue(((BigDecimal)currValue).doubleValue());
                } else {
                    String payDetailValue = String.valueOf(currValue);
                    cell.setCellValue(payDetailValue);
                }
                ++index;
            }
            ++currRow;
            exportResult.incrementAndGet();
        }
    }

    private static CellStyle getBodyCellStyle(Object currValue, Sheet sheet, HeadCellInfo headCellInfo, Map<String, CellStyle> bodyCellStyleMap, Map<String, CellStyle> bodyCellCustomStyleMap) {
        if (currValue instanceof BigDecimal) {
            String baseFormat = "@".equals(headCellInfo.getBaseFormat()) ? "0" : headCellInfo.getBaseFormat();
            StringBuilder keyBuilder = new StringBuilder();
            int scale = ((BigDecimal)currValue).scale();
            keyBuilder.append(baseFormat);
            keyBuilder.append("#");
            keyBuilder.append(scale);
            CellStyle cellStyle = bodyCellCustomStyleMap.get(keyBuilder.toString());
            if (cellStyle == null) {
                StringBuilder sb = new StringBuilder(baseFormat);
                if (scale > 0) {
                    sb.append('.');
                    for (int i = 0; i < scale; ++i) {
                        sb.append('0');
                    }
                }
                sb.append("_ ");
                Workbook workbook = sheet.getWorkbook();
                DataFormat dataFormat = workbook.createDataFormat();
                cellStyle = workbook.createCellStyle();
                cellStyle.setDataFormat(dataFormat.getFormat(sb.toString()));
                bodyCellCustomStyleMap.put(keyBuilder.toString(), cellStyle);
            }
            return cellStyle;
        }
        return bodyCellStyleMap.get(headCellInfo.getPosFlag());
    }

    private static Cell newCell(Sheet sheet, int rowNum, int colNum, int rowSpan, int colSpan, HeadCellInfo headCellInfo, boolean horizontal, CellStyle cellStyle) {
        Cell cell;
        Row row;
        if (!horizontal) {
            int temp = rowNum;
            rowNum = colNum;
            colNum = temp;
            temp = rowSpan;
            rowSpan = colSpan;
            colSpan = temp;
        }
        if ((row = sheet.getRow(rowNum)) == null) {
            row = sheet.createRow(rowNum);
        }
        if ((cell = row.getCell(colNum)) == null) {
            cell = row.createCell(colNum);
        }
        if (cellStyle != null) {
            cell.setCellStyle(cellStyle);
            if (rowSpan > 1 || colSpan > 1) {
                CellRangeAddress region = new CellRangeAddress(rowNum, rowNum + rowSpan - 1, colNum, colNum + colSpan - 1);
                sheet.addMergedRegion(region);
                ExcelHelper.setRangeStyle(region, cellStyle, sheet);
            }
        }
        return cell;
    }

    private static void setRangeStyle(CellRangeAddress region, CellStyle cellStyle, Sheet sheet) {
        RegionUtil.setBorderBottom((BorderStyle)cellStyle.getBorderBottom(), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderTop((BorderStyle)cellStyle.getBorderTop(), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)cellStyle.getBorderLeft(), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)cellStyle.getBorderRight(), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBottomBorderColor((int)cellStyle.getBottomBorderColor(), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setTopBorderColor((int)cellStyle.getTopBorderColor(), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setLeftBorderColor((int)cellStyle.getLeftBorderColor(), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setRightBorderColor((int)cellStyle.getRightBorderColor(), (CellRangeAddress)region, (Sheet)sheet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String storeFile(Workbook wb, String fileName) {
        String string;
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            string = StreamUtil.storeFile(fileName, inStream);
            StreamUtil.closeSafely((OutputStream)outStream, (InputStream)inStream);
        }
        catch (Exception e) {
            LOGGER.warn("Error occurs when storeFile", (Throwable)e);
            String string2 = null;
            return string2;
        }
        try {
            wb.close();
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
        finally {
            StreamUtil.closeSafely((OutputStream)outStream, inStream);
            try {
                wb.close();
            }
            catch (Exception exception) {}
        }
    }
}

