/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bankoffer.exportsource;

import com.google.common.collect.HashBasedTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.swc.hsas.common.events.paydetail.BankOfferExportEvent;
import kd.sdk.swc.hsas.service.api.IBankOfferExportService;
import kd.swc.hsas.business.bankoffer.BankOfferHelper;
import kd.swc.hsas.business.bankoffer.exportsource.BaseExportSource;
import kd.swc.hsas.common.dto.BankOfferExportErrorDTO;
import kd.swc.hsas.common.dto.BankOfferExportFiledDTO;
import kd.swc.hsas.common.dto.BankOfferFetchResultDTO;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CustomExportSource
extends BaseExportSource {
    protected static final Log log = LogFactory.getLog(CustomExportSource.class);

    @Override
    public void getExportData(BankOfferFetchResultDTO fetchDTO, List<BankOfferExportFiledDTO> exportFileDTO) {
        List payDetailIds = fetchDTO.getPayDetailIds();
        HashBasedTable dataTable = fetchDTO.getDataTable();
        ArrayList errorDTOS = new ArrayList(10);
        List<Long> ids = exportFileDTO.stream().map(data -> Long.parseLong(data.getFieldSelect())).collect(Collectors.toList());
        Map<String, DynamicObject> customDyMap = BankOfferHelper.getCustomDataMap(ids);
        exportFileDTO.forEach(data -> {
            String fieldSelect = data.getFieldSelect();
            HashMap<Long, Map<String, Object>> customDataMap = new HashMap<Long, Map<String, Object>>(16);
            String number = "";
            try {
                DynamicObject cfg = (DynamicObject)customDyMap.get(fieldSelect);
                number = cfg.getString("number");
                IBankOfferExportService service = this.getService(cfg.getString("fetchpath"));
                ArrayList<String> keyList = new ArrayList<String>(10);
                keyList.add(number);
                BankOfferExportEvent bankOfferExportEvent = new BankOfferExportEvent(payDetailIds, keyList);
                customDataMap = service != null ? service.fetchDataPayDetail(bankOfferExportEvent) : null;
            }
            catch (Exception e) {
                log.info("CustomExportSource error :{}", (Object)e.getMessage());
            }
            this.checkCustomData((BankOfferExportFiledDTO)data, payDetailIds, (Map<Long, Map<String, Object>>)customDataMap, number, errorDTOS, (HashBasedTable<Long, Integer, Object>)dataTable);
        });
        fetchDTO.addExportErrorDTOS(errorDTOS);
    }

    private IBankOfferExportService getService(String className) {
        if (SWCStringUtils.isEmpty((String)className)) {
            throw new RuntimeException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230\u3002", (String)"ServiceFactory_0", (String)"swc-hsas-servicehelper", (Object[])new Object[0]), className));
        }
        Object service = TypesContainer.createInstance((String)className);
        if (service instanceof IBankOfferExportService) {
            return (IBankOfferExportService)service;
        }
        return null;
    }

    private void checkCustomData(BankOfferExportFiledDTO dto, List<Long> payDetailIds, Map<Long, Map<String, Object>> customDataMap, String number, List<BankOfferExportErrorDTO> errorDTOS, HashBasedTable<Long, Integer, Object> dataTable) {
        String filedName = dto.getFieldName();
        Boolean isCanNull = dto.getNull();
        String fieldValue = dto.getFieldValue();
        StringBuilder errorMsg = new StringBuilder();
        for (Long payDetailId : payDetailIds) {
            Map<String, Object> map = customDataMap.get(payDetailId);
            Object payDetailObjValue = "";
            if (map != null) {
                payDetailObjValue = map.get(number);
            }
            if (!isCanNull.booleanValue() && BankOfferHelper.isNull(payDetailObjValue, filedName, fieldValue, errorMsg)) {
                BankOfferHelper.getFiledLengthErrorDTO(errorMsg, payDetailId, errorDTOS);
                continue;
            }
            dataTable.put((Object)payDetailId, (Object)dto.getSeq(), payDetailObjValue);
        }
    }
}

