/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bankoffer.exportsource;

import com.google.common.collect.HashBasedTable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRQueryEntityHelper;
import kd.swc.hsas.business.bankoffer.BankOfferHelper;
import kd.swc.hsas.business.bankoffer.excel.DataTypeEnum;
import kd.swc.hsas.business.bankoffer.exportsource.BaseExportSource;
import kd.swc.hsas.common.dto.BankOfferExportErrorDTO;
import kd.swc.hsas.common.dto.BankOfferExportFiledDTO;
import kd.swc.hsas.common.dto.BankOfferFetchResultDTO;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class FieldExportSource
extends BaseExportSource {
    @Override
    public void getExportData(BankOfferFetchResultDTO fetchDTO, List<BankOfferExportFiledDTO> exportFiledDTO) {
        Set<String> fileHeadSet = this.getFileHeadSet();
        List payDetailIds = fetchDTO.getPayDetailIds();
        HashSet<String> filedPayDetailSet = new HashSet<String>(16);
        HashSet<String> filedPersonSet = new HashSet<String>(16);
        exportFiledDTO.forEach(data -> {
            String fieldQueryTable = data.getFieldQueryTable();
            if ("hsas_bankofferexport".equals(fieldQueryTable)) {
                filedPayDetailSet.add(data.getFieldSelect());
                if ("payamount".equals(data.getFieldSelect())) {
                    fetchDTO.setLimitSeq(data.getSeq());
                }
                if ("calamount".equals(data.getFieldSelect())) {
                    filedPayDetailSet.add("calcurrency");
                }
                if ("oriamount".equals(data.getFieldSelect())) {
                    filedPayDetailSet.add("oricurrency");
                }
            }
            if ("hsas_bankofferexport_person".equals(fieldQueryTable)) {
                filedPayDetailSet.add("salaryfilehis.person.id");
                filedPersonSet.add(data.getFieldSelect());
            }
        });
        HashBasedTable filedDataTypeTable = fetchDTO.getFiledDataTypeTable();
        this.getFiledDataType((HashBasedTable<String, String, String>)filedDataTypeTable, "hsas_bankofferexport", filedPayDetailSet);
        this.getFiledDataType((HashBasedTable<String, String, String>)filedDataTypeTable, "hsas_bankofferexport_person", filedPersonSet);
        filedPayDetailSet.add("paycurrency");
        filedPayDetailSet.add("salaryitem");
        filedPayDetailSet.addAll(fileHeadSet);
        HashBasedTable headTable = fetchDTO.getHeadTable();
        HashBasedTable dataTable = fetchDTO.getDataTable();
        ArrayList<BankOfferExportErrorDTO> errorDTOS = new ArrayList<BankOfferExportErrorDTO>(10);
        List splitPayDetailIdList = SWCListUtils.split((List)payDetailIds, (int)2000);
        for (List splitPayDetailIds : splitPayDetailIdList) {
            DynamicObject[] payDetailData = this.getPayDetailData(filedPayDetailSet, splitPayDetailIds);
            Map<Long, DynamicObject> personDataMap = null;
            if (!filedPersonSet.isEmpty()) {
                HashSet<Long> personIds = new HashSet<Long>(16);
                for (DynamicObject payDetail : payDetailData) {
                    personIds.add(payDetail.getLong("salaryfilehis.person.id"));
                }
                personDataMap = this.getPersonDataMap(filedPersonSet, personIds);
            }
            this.checkPayDetailExportByTpl(payDetailData, personDataMap, exportFiledDTO, (HashBasedTable<Long, Integer, Object>)dataTable, (HashBasedTable<Long, String, Object>)headTable, errorDTOS);
        }
        fetchDTO.addExportErrorDTOS(errorDTOS);
    }

    private void getFiledDataType(HashBasedTable<String, String, String> filedDataTypeTable, String number, Set<String> filedSet) {
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)number).getProperties();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if (!filedSet.contains(name)) continue;
            String filedDataType = "";
            if (property instanceof AmountProp) {
                filedDataType = DataTypeEnum.BIG_DECIMAL.name();
            }
            filedDataTypeTable.put((Object)number, (Object)name, (Object)filedDataType);
        }
    }

    private DynamicObject[] getPayDetailData(Set<String> filedList, List<Long> payDetailIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bankofferexport");
        QFilter filter = new QFilter("id", "in", payDetailIds);
        return helper.query(String.join((CharSequence)",", filedList), new QFilter[]{filter});
    }

    private Map<Long, DynamicObject> getPersonDataMap(Set<String> filedList, Set<Long> personIds) {
        QFilter filter = new QFilter("id", "in", personIds);
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)"hsas_bankofferexport_person");
        DynamicObjectCollection personData = HRQueryEntityHelper.getInstance().getQueryDyoColl(queryEntityType, String.join((CharSequence)",", filedList), new QFilter[]{filter}, "");
        HashMap<Long, DynamicObject> personDataMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject person : personData) {
            personDataMap.put(person.getLong("id"), person);
        }
        return personDataMap;
    }

    private void checkPayDetailExportByTpl(DynamicObject[] payDetails, Map<Long, DynamicObject> personDataMap, List<BankOfferExportFiledDTO> exportFiledDTO, HashBasedTable<Long, Integer, Object> dataTable, HashBasedTable<Long, String, Object> headTable, List<BankOfferExportErrorDTO> errorDTOS) {
        DynamicObject bankOfferTpl = this.getBankOfferTpl();
        Set<String> fileHeadSet = this.getFileHeadSet();
        DynamicObject currency = bankOfferTpl.getDynamicObject("currencyid");
        String limitContent = bankOfferTpl.getString("limitcontent");
        boolean isAmount = "3".equals(limitContent);
        BigDecimal limitAmount = bankOfferTpl.getBigDecimal("limitamount");
        for (DynamicObject payDetail : payDetails) {
            BigDecimal payAmount;
            Long id = payDetail.getLong("id");
            DynamicObject payCurrency = payDetail.getDynamicObject("paycurrency");
            if (BankOfferHelper.isNotSamePayCurrency(currency, payCurrency, payDetail, errorDTOS) || isAmount && BankOfferHelper.isLargeLimitAmount(limitAmount, payAmount = payDetail.getBigDecimal("payamount"), payDetail, errorDTOS)) continue;
            StringBuilder errorMsg = new StringBuilder();
            Boolean isEnableExport = Boolean.TRUE;
            for (BankOfferExportFiledDTO dto : exportFiledDTO) {
                String filedName = dto.getFieldName();
                String fieldQueryTable = dto.getFieldQueryTable();
                if (!"2".equals(dto.getFieldSource())) continue;
                String fieldSelect = dto.getFieldSelect();
                String fieldValue = dto.getFieldValue();
                Object payDetailObjValue = this.getValueByQueryTable(fieldQueryTable, fieldSelect, payDetail, personDataMap);
                Boolean isCanNull = dto.getNull();
                if (!isCanNull.booleanValue() && BankOfferHelper.isNull(payDetailObjValue, filedName, fieldValue, errorMsg)) {
                    isEnableExport = Boolean.FALSE;
                    continue;
                }
                Object payDetailValue = BankOfferHelper.getPayDetailValueString(payDetailObjValue, fieldSelect, payDetail);
                String payDetailValueString = payDetailObjValue instanceof BigDecimal ? ((BigDecimal)payDetailValue).toPlainString() : (payDetailValue == null ? "" : payDetailValue.toString());
                Boolean showThousandth = dto.getShowThousandth();
                if (showThousandth.booleanValue()) {
                    payDetailValueString = BankOfferHelper.fmtMicrometer(payDetailValueString);
                }
                int fieldLength = dto.getFieldLength();
                String fieldName = dto.getFieldName();
                if (0 != fieldLength && BankOfferHelper.isNotRightFiledLength(payDetailValueString, fieldValue, fieldName, fieldLength, errorMsg)) {
                    isEnableExport = Boolean.FALSE;
                    continue;
                }
                if (!isEnableExport.booleanValue()) continue;
                dataTable.put((Object)id, (Object)dto.getSeq(), payDetailValue == null ? "" : payDetailValue);
            }
            if (isEnableExport.booleanValue()) {
                this.setFieldDataMap(payDetail, fileHeadSet, headTable);
                continue;
            }
            BankOfferHelper.getFiledLengthErrorDTO(errorMsg, id, errorDTOS);
        }
    }

    private void setFieldDataMap(DynamicObject payDetail, Set<String> fieldSet, HashBasedTable<Long, String, Object> headTable) {
        DynamicObjectType dyObjType = payDetail.getDynamicObjectType();
        Long id = payDetail.getLong("id");
        for (String fileName : fieldSet) {
            String value;
            if ("salaryitem".equals(fileName)) continue;
            if ("payamount".equals(fileName)) {
                BigDecimal bigDecimal = payDetail.getBigDecimal(fileName);
                long dataRoundId = payDetail.getLong("salaryitem.dataround.id");
                bigDecimal = bigDecimal.setScale(payDetail.getInt("paycurrency.amtprecision"), BankOfferHelper.getRoundingMode(dataRoundId));
                headTable.put((Object)id, (Object)fileName, (Object)bigDecimal);
                continue;
            }
            DynamicProperty dp = dyObjType.getProperty(fileName);
            if (dp == null || dp instanceof BasedataProp) {
                switch (fileName) {
                    case "agentpaybank.union_number": 
                    case "paysubjecthis.number": {
                        value = payDetail.getString(fileName);
                        break;
                    }
                    case "agentpaybank.bank_cate.type_code": {
                        Long bankCateId = payDetail.getLong("agentpaybank.bank_cate.id");
                        value = 0L == bankCateId ? "" : String.valueOf(bankCateId);
                        break;
                    }
                    default: {
                        value = payDetail.getString(fileName + ".name");
                        break;
                    }
                }
            } else {
                value = dp instanceof DateProp ? SWCInteDateTimeUtil.formatDateByFieldProp((Date)payDetail.getDate(fileName), (DateTimeProp)((DateTimeProp)dp)) : payDetail.getString(fileName);
            }
            if (SWCStringUtils.isEmpty((String)value)) {
                value = "";
            }
            headTable.put((Object)id, (Object)fileName, (Object)value);
        }
    }

    private Object getValueByQueryTable(String fieldQueryTable, String fieldSelect, DynamicObject payDetail, Map<Long, DynamicObject> personDataMap) {
        if ("hsas_bankofferexport".equals(fieldQueryTable)) {
            return payDetail.get(fieldSelect);
        }
        if ("hsas_bankofferexport_person".equals(fieldQueryTable)) {
            if (personDataMap == null) {
                return "";
            }
            DynamicObject personDetail = personDataMap.get(payDetail.getLong("salaryfilehis.person.id"));
            if (personDetail == null) {
                return "";
            }
            return personDetail.get(fieldSelect);
        }
        return "";
    }
}

