/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bankoffer.strategy;

import com.google.common.collect.HashBasedTable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.swc.hsas.business.bankoffer.BankOfferHelper;
import kd.swc.hsas.business.bankoffer.BaseExportService;
import kd.swc.hsas.business.bankoffer.vo.exportPackage.DataPackage;
import kd.swc.hsas.common.dto.BankOfferBatchExportDTO;
import kd.swc.hsas.common.dto.BankOfferExportFiledDTO;
import kd.swc.hsas.common.dto.BankOfferSelectTplDTO;
import kd.swc.hsas.common.dto.BankOfferSplitBatchDTO;
import kd.swc.hsas.common.dto.BankOfferTXTSeparateWayDTO;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class TextExportService
extends BaseExportService {
    private static final Log logger = LogFactory.getLog(TextBatchExportThread.class);

    public TextExportService(DataPackage dataPackage) {
        super(dataPackage);
    }

    @Override
    public List<List<Object>> getDataList(List<Long> splitPayDetailIds, List<BankOfferExportFiledDTO> exportFiledDTO, HashBasedTable<Long, Integer, Object> dataTable) {
        ArrayList<List<Object>> dataList = new ArrayList<List<Object>>(splitPayDetailIds.size());
        splitPayDetailIds.forEach(payDetailId -> {
            ArrayList list = new ArrayList(exportFiledDTO.size());
            exportFiledDTO.forEach(exportFiled -> {
                String fieldSource = exportFiled.getFieldSource();
                Integer seq = exportFiled.getSeq();
                if ("3".equals(fieldSource)) {
                    list.add(seq, String.valueOf(dataList.size() + 1));
                } else {
                    Object payDetailObjValue = dataTable.get(payDetailId, (Object)seq);
                    payDetailObjValue = payDetailObjValue != null ? payDetailObjValue : "";
                    int fieldLength = exportFiled.getFieldLength();
                    String fieldValue = this.dealDataBefore(payDetailObjValue, (BankOfferExportFiledDTO)exportFiled);
                    String fixWay = exportFiled.getFixWay();
                    String fixContent = exportFiled.getFixContent();
                    if (SWCStringUtils.isNotEmpty((String)fieldValue) && SWCStringUtils.isNotEmpty((String)fixWay)) {
                        fieldValue = BankOfferHelper.swallowField(fieldValue, fixWay, fieldLength, fixContent);
                    }
                    list.add(seq, fieldValue);
                }
            });
            dataList.add(list);
        });
        return dataList;
    }

    private String dealDataBefore(Object value, BankOfferExportFiledDTO exportFiled) {
        String str = value instanceof BigDecimal ? ((BigDecimal)value).toPlainString() : String.valueOf(value);
        if (exportFiled.getShowThousandth().booleanValue()) {
            return BankOfferHelper.fmtMicrometer(str);
        }
        return str;
    }

    @Override
    public void assembleExportDataAfter(List<List<Object>> dataList, List<BankOfferExportFiledDTO> exportFiledCopy) {
        BankOfferTXTSeparateWayDTO txtSeparateWay = this.getTXTSeparateWay();
        String separator = this.getTxTSeparateWay(txtSeparateWay);
        if ("3".equals(txtSeparateWay.getSeparateWay())) {
            this.getFiledMaxLength(dataList, exportFiledCopy);
            this.setTabLength(dataList, exportFiledCopy);
        }
        this.setSeparator(dataList, exportFiledCopy, separator);
    }

    @Override
    public List<BaseExportService.BaseBankOfferBatchExportThread> dealExportDataBefore(List<BankOfferSplitBatchDTO> splitBatchDTOList) {
        DataPackage dataPackage = this.getDataPackage();
        BankOfferBatchExportDTO batchExport = dataPackage.getBatchExport();
        DynamicObject bankOfferTpl = dataPackage.getBankOfferTpl();
        RequestContext requestContext = dataPackage.getRequestContext();
        BankOfferSelectTplDTO selectTpl = dataPackage.getSelectTpl();
        ArrayList<BaseExportService.BaseBankOfferBatchExportThread> exportThreadList = new ArrayList<BaseExportService.BaseBankOfferBatchExportThread>(splitBatchDTOList.size());
        splitBatchDTOList.forEach(data -> exportThreadList.add(new TextBatchExportThread(requestContext, (BankOfferSplitBatchDTO)data, batchExport, bankOfferTpl, selectTpl)));
        return exportThreadList;
    }

    private BankOfferTXTSeparateWayDTO getTXTSeparateWay() {
        DynamicObject bankOfferTpl = this.getDataPackage().getBankOfferTpl();
        String separateWay = bankOfferTpl.getString("separateways");
        String separator = bankOfferTpl.getString("separator");
        int fixLength = bankOfferTpl.getInt("fixlength");
        Boolean isShowSeq = bankOfferTpl.getBoolean("isshowseq");
        return new BankOfferTXTSeparateWayDTO(separateWay, separator, Integer.valueOf(fixLength), isShowSeq);
    }

    private String getTxTSeparateWay(BankOfferTXTSeparateWayDTO txtSeparateWay) {
        String separateWay = txtSeparateWay.getSeparateWay();
        if ("5".equals(separateWay)) {
            return txtSeparateWay.getSeparator();
        }
        if ("4".equals(separateWay)) {
            Integer fixLength = txtSeparateWay.getFixLength();
            StringBuilder separator = new StringBuilder();
            for (int i = 0; i < fixLength; ++i) {
                separator.append(' ');
            }
            return separator.toString();
        }
        return BankOfferHelper.getSeparateDropDownMap().get(separateWay);
    }

    private void getFiledMaxLength(List<List<Object>> dataList, List<BankOfferExportFiledDTO> exportFiledDTO) {
        for (BankOfferExportFiledDTO dto : exportFiledDTO) {
            int fieldValueLength;
            int maxLength;
            String fieldName = dto.getFieldName();
            int fieldNameLength = BankOfferHelper.length(fieldName);
            int n = maxLength = fieldNameLength > (fieldValueLength = this.getFieldValueMaxLength(dataList, dto.getSeq())) ? fieldNameLength : fieldValueLength;
            if (maxLength % 8 == 0) {
                maxLength += 8;
            }
            double maxTabNum = Math.ceil((float)maxLength / 8.0f);
            maxLength = (int)(8.0 * maxTabNum);
            dto.setFieldMaxLength(maxLength);
        }
    }

    private int getFieldValueMaxLength(List<List<Object>> dataList, Integer seq) {
        int maxLength = 0;
        for (List<Object> list : dataList) {
            Object payDetailObjValue = list.get(seq);
            String payDetailValue = payDetailObjValue != null ? payDetailObjValue.toString() : " ";
            int length = BankOfferHelper.length(payDetailValue);
            if (length <= maxLength) continue;
            maxLength = length;
        }
        return maxLength;
    }

    private void setTabLength(List<List<Object>> dataList, List<BankOfferExportFiledDTO> exportFiledDTO) {
        for (BankOfferExportFiledDTO dto : exportFiledDTO) {
            Integer seq = dto.getSeq();
            int fieldMaxLength = dto.getFieldMaxLength();
            String fieldName = dto.getFieldName();
            dto.addSeparateToFieldName(BankOfferHelper.getTabString(BankOfferHelper.length(fieldName), fieldMaxLength));
            dataList.forEach(data -> {
                String val = String.valueOf(data.get(seq));
                data.set(seq, val + BankOfferHelper.getTabString(BankOfferHelper.length(val), fieldMaxLength));
            });
        }
    }

    private void setSeparator(List<List<Object>> dataList, List<BankOfferExportFiledDTO> exportFiledDTO, String separator) {
        for (int index = 0; index < exportFiledDTO.size() - 1; ++index) {
            BankOfferExportFiledDTO dto = exportFiledDTO.get(index);
            Integer seq = dto.getSeq();
            dto.addSeparateToFieldName(separator);
            dataList.forEach(data -> {
                String val = String.valueOf(data.get(seq));
                data.set(seq, val + separator);
            });
        }
    }

    private String getTxTDownUrl(String fileName, SequenceInputStream sis) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        RequestContext requestContext = RequestContext.get();
        String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)UUID.randomUUID().toString(), (String)fileName);
        FileItem item = new FileItem(fileName, pathParam, (InputStream)sis);
        String path = fileService.upload(item);
        return UrlService.getAttachmentFullUrl((String)path);
    }

    class TextBatchExportThread
    extends BaseExportService.BaseBankOfferBatchExportThread {
        public TextBatchExportThread(RequestContext requestContext, BankOfferSplitBatchDTO splitBatch, BankOfferBatchExportDTO dto, DynamicObject bankOfferTpl, BankOfferSelectTplDTO selectTpl) {
            super(requestContext, splitBatch, dto, bankOfferTpl, selectTpl);
        }

        @Override
        public String getExportUrl() throws Exception {
            String url;
            Map filedNameMap = this.splitBatch.getFiledNameMap();
            List dataList = this.splitBatch.getDataList();
            this.fileExportName = this.fileExportName + ".txt";
            LinkedHashSet<ByteArrayInputStream> headSet = new LinkedHashSet<ByteArrayInputStream>(16);
            String txtHead = this.bankOfferTpl.getString("txthead");
            if (SWCStringUtils.isNotEmpty((String)txtHead)) {
                txtHead = BankOfferHelper.extractMessage(txtHead, null, filedNameMap);
                txtHead = txtHead + "\n";
                txtHead = txtHead.replaceAll("\n", "\r\n");
            }
            ByteArrayInputStream inStreamHead = new ByteArrayInputStream(txtHead.getBytes("UTF-8"));
            headSet.add(inStreamHead);
            StringBuilder builder = new StringBuilder();
            for (BankOfferExportFiledDTO dto : this.exportFileDTO) {
                String fieldName = dto.getFieldName();
                builder.append(fieldName);
            }
            builder.append('\n');
            String columnHead = builder.toString();
            columnHead = columnHead.replaceAll("\n", "\r\n");
            ByteArrayInputStream inStreamColumnHead = new ByteArrayInputStream(columnHead.getBytes("UTF-8"));
            headSet.add(inStreamColumnHead);
            List splitDataList = SWCListUtils.split((List)dataList, (int)500);
            for (List splitList : splitDataList) {
                String exportContent = this.getBatchTextExportContent(splitList);
                exportContent = exportContent.replaceAll("\n", "\r\n");
                ByteArrayInputStream inStream = new ByteArrayInputStream(exportContent.getBytes("UTF-8"));
                headSet.add(inStream);
            }
            final Iterator it = headSet.iterator();
            Enumeration<ByteArrayInputStream> enumeration = new Enumeration<ByteArrayInputStream>(){

                @Override
                public boolean hasMoreElements() {
                    return it.hasNext();
                }

                @Override
                public ByteArrayInputStream nextElement() {
                    return (ByteArrayInputStream)it.next();
                }
            };
            try (SequenceInputStream sis = new SequenceInputStream((Enumeration<? extends InputStream>)enumeration);){
                url = TextExportService.this.getTxTDownUrl(this.fileExportName, sis);
            }
            return url;
        }

        private String getBatchTextExportContent(List<List<Object>> splitList) {
            StringBuilder builder = new StringBuilder();
            this.getTXTTableValue(builder, splitList);
            return builder.toString();
        }

        private void getTXTTableValue(StringBuilder builder, List<List<Object>> splitList) {
            for (List<Object> data : splitList) {
                StringBuilder tempBuilder = new StringBuilder();
                for (Object aData : data) {
                    tempBuilder.append(aData);
                }
                tempBuilder.append('\n');
                builder.append((CharSequence)tempBuilder);
            }
        }
    }
}

