/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bankoffer.thread;

import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.bankoffer.BaseExportService;
import kd.swc.hsas.business.bankoffer.strategy.ExcelExportService;
import kd.swc.hsas.business.bankoffer.strategy.TextExportService;
import kd.swc.hsas.business.bankoffer.vo.exportPackage.DataPackage;
import kd.swc.hsas.common.dto.BankOfferBatchExportDTO;
import kd.swc.hsas.common.dto.BankOfferExportFiledDTO;
import kd.swc.hsas.common.dto.BankOfferSelectTplDTO;

public class BankOfferExportThread
implements Runnable {
    private static final Log logger = LogFactory.getLog(BankOfferExportThread.class);
    private Set<String> fileTableHeadSet;
    private BankOfferBatchExportDTO dto;
    private DynamicObject bankOfferTpl;
    private BankOfferSelectTplDTO selectTpl;
    private RequestContext requestContext;
    private List<BankOfferExportFiledDTO> exportFileDTO;

    public BankOfferExportThread(Set<String> fileTableHeadSet, BankOfferBatchExportDTO dto, DynamicObject bankOfferTpl, RequestContext requestContext, BankOfferSelectTplDTO selectTpl, List<BankOfferExportFiledDTO> exportFileDTO) {
        this.fileTableHeadSet = fileTableHeadSet;
        this.dto = dto;
        this.bankOfferTpl = bankOfferTpl;
        this.requestContext = requestContext;
        this.selectTpl = selectTpl;
        this.exportFileDTO = exportFileDTO;
    }

    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.requestContext);
        String fileType = this.bankOfferTpl.getString("filetype");
        DataPackage dataPackage = new DataPackage(this.requestContext, this.dto, this.bankOfferTpl, this.fileTableHeadSet, this.selectTpl, this.exportFileDTO);
        try {
            BaseExportService exportService = "2".equals(fileType) ? new TextExportService(dataPackage) : new ExcelExportService(dataPackage);
            exportService.handleExport();
        }
        catch (Exception e) {
            e.getMessage();
        }
    }
}

