/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bankoffer.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import kd.swc.hsas.business.bankoffer.excel.CellStyleName;
import kd.swc.hsas.business.bankoffer.excel.DefaultCellStyleNameEnum;
import kd.swc.hsas.business.bankoffer.vo.HeadCellInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class HeadCellBar
implements Serializable {
    private static final long serialVersionUID = 6098515691059483401L;
    private String headCellStyleName;
    private String bodyCellStyleName;
    private List<HeadCellInfo> headCellInfoList;
    private List<HeadCellInfo> contentHeadCellInfoList;
    private boolean ready;
    private int headRowNum = 1;
    private boolean horizontal = true;
    private int headRowHeight;
    private int contentRowHeight;
    private boolean headShouldWritten = true;

    public int size() {
        return this.contentHeadCellInfoList == null ? 0 : this.contentHeadCellInfoList.size();
    }

    public boolean ready() {
        if (CollectionUtils.isEmpty(this.headCellInfoList)) {
            this.ready = true;
            return true;
        }
        Collections.sort(this.headCellInfoList, new HeadCellInfo.PosComparator());
        HashMap<Integer, Integer> colNumOfRow = new HashMap<Integer, Integer>(4);
        this.contentHeadCellInfoList = new ArrayList<HeadCellInfo>(this.headCellInfoList.size());
        for (HeadCellInfo headCellInfo : this.headCellInfoList) {
            if (!headCellInfo.ready(colNumOfRow)) {
                this.ready = false;
                return false;
            }
            if (!headCellInfo.isContent()) continue;
            this.contentHeadCellInfoList.add(headCellInfo);
        }
        this.headRowNum = colNumOfRow.size();
        Collections.sort(this.contentHeadCellInfoList, Comparator.comparingInt(HeadCellInfo::getColNum));
        this.ready = true;
        return true;
    }

    public HeadCellInfo get(int i) {
        return this.headCellInfoList.get(i);
    }

    public HeadCellBar addHeadCellInfos(HeadCellInfo ... headCellInfos) {
        if (headCellInfos == null) {
            return this;
        }
        if (this.headCellInfoList == null) {
            this.headCellInfoList = new ArrayList<HeadCellInfo>(headCellInfos.length == 1 ? 16 : headCellInfos.length);
        }
        for (HeadCellInfo headCellInfo : headCellInfos) {
            if (headCellInfo == null) continue;
            this.headCellInfoList.add(headCellInfo);
        }
        return this;
    }

    public void ofHeadCellStyle(CellStyleName cellStyleName) {
        if (cellStyleName != null) {
            this.setHeadCellStyleName(cellStyleName.getStyleName());
        }
    }

    public void ofBodyCellStyle(CellStyleName cellStyleName) {
        if (cellStyleName != null) {
            this.setBodyCellStyleName(cellStyleName.getStyleName());
        }
    }

    public String getHeadCellStyleName() {
        return StringUtils.isEmpty((CharSequence)this.headCellStyleName) ? DefaultCellStyleNameEnum.HEAD.getStyleName() : this.headCellStyleName;
    }

    public void setHeadCellStyleName(String headCellStyleName) {
        this.headCellStyleName = headCellStyleName;
    }

    public String getBodyCellStyleName() {
        return StringUtils.isEmpty((CharSequence)this.bodyCellStyleName) ? DefaultCellStyleNameEnum.BODY.getStyleName() : this.bodyCellStyleName;
    }

    public void setBodyCellStyleName(String bodyCellStyleName) {
        this.bodyCellStyleName = bodyCellStyleName;
    }

    public List<HeadCellInfo> getHeadCellInfoList() {
        return this.headCellInfoList;
    }

    public void setHeadCellInfoList(List<HeadCellInfo> headCellInfoList) {
        this.headCellInfoList = headCellInfoList;
    }

    public List<HeadCellInfo> getContentHeadCellInfoList() {
        return this.contentHeadCellInfoList;
    }

    public void setContentHeadCellInfoList(List<HeadCellInfo> contentHeadCellInfoList) {
        this.contentHeadCellInfoList = contentHeadCellInfoList;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public int getHeadRowNum() {
        return this.headRowNum;
    }

    public void setHeadRowNum(int headRowNum) {
        this.headRowNum = headRowNum;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
    }

    public int getHeadRowHeight() {
        return this.headRowHeight;
    }

    public void setHeadRowHeight(int headRowHeight) {
        this.headRowHeight = headRowHeight;
    }

    public int getContentRowHeight() {
        return this.contentRowHeight;
    }

    public void setContentRowHeight(int contentRowHeight) {
        this.contentRowHeight = contentRowHeight;
    }

    public boolean isHeadShouldWritten() {
        return this.headShouldWritten;
    }

    public void setHeadShouldWritten(boolean headShouldWritten) {
        this.headShouldWritten = headShouldWritten;
    }
}

