/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bankoffer.vo;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.swc.hsas.business.bankoffer.excel.CellStyleName;
import kd.swc.hsas.business.bankoffer.excel.DataTypeEnum;
import kd.swc.hsas.business.bankoffer.excel.ValueWrapperName;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class HeadCellInfo
implements Serializable {
    private static final long serialVersionUID = 2495076241389449357L;
    public static final String DEFAULT_FORMAT = "@";
    private String valueProp;
    private boolean required;
    private boolean hidden;
    private String headValueWrapper;
    private String bodyValueWrapper;
    private String defaultDesc;
    private String i18nBase;
    private String i18nKey;
    private short height;
    private int width;
    private int rowNum;
    private int colNum;
    private int rowSpan = 1;
    private int colSpan = 1;
    private boolean ready;
    private boolean mergeRowWithSameValue;
    private String dataType;
    private String baseFormat = "@";
    private String sign;
    private int scale;
    private String headStyleName;
    private String bodyStyleName;
    private Map<String, Object> headStyleParam;
    private Map<String, Object> bodyStyleParam;
    private String comment;
    private String posFlag;
    private List<String> dropDownVals;

    public HeadCellInfo() {
    }

    public HeadCellInfo(String valueProp) {
        this.valueProp = valueProp;
    }

    public boolean ready(Map<Integer, Integer> colNumOfRow) {
        Integer nextColNum = colNumOfRow.get(this.rowNum);
        if (nextColNum != null && nextColNum > this.colNum) {
            this.colNum = nextColNum;
        }
        nextColNum = this.colNum + this.colSpan;
        colNumOfRow.put(this.rowNum, nextColNum);
        if (this.rowSpan > 1) {
            for (int i = 1; i < this.rowSpan; ++i) {
                colNumOfRow.put(this.rowNum + i, nextColNum);
            }
        }
        if (MapUtils.isEmpty(this.headStyleParam) && StringUtils.isEmpty((CharSequence)this.headStyleName)) {
            this.genDefaultHeadStyle();
        }
        if (MapUtils.isEmpty(this.bodyStyleParam) && StringUtils.isEmpty((CharSequence)this.bodyStyleName)) {
            this.genDefaultBodyStyle();
        }
        this.posFlag = "R" + this.rowNum + "C" + this.colNum;
        this.ready = true;
        return true;
    }

    public String getPosFlag() {
        return this.posFlag;
    }

    public boolean isContent() {
        return !StringUtils.isEmpty((CharSequence)this.valueProp);
    }

    public String getI18nDesc() {
        return ResManager.loadKDString((String)this.defaultDesc, (String)this.i18nKey, (String)this.i18nBase, (Object[])new Object[0]);
    }

    public String fullFormat() {
        if (StringUtils.isEmpty((CharSequence)this.baseFormat) || !DataTypeEnum.isNumber(this.dataType)) {
            return this.baseFormat;
        }
        if (this.sign == null) {
            this.sign = "";
        }
        String styleStr = this.sign + this.baseFormat;
        if (!DataTypeEnum.isDecimal(this.dataType) && !DataTypeEnum.isCurrency(this.dataType)) {
            return styleStr;
        }
        StringBuilder sb = new StringBuilder(styleStr);
        if (this.scale > 0) {
            sb.append('.');
            for (int i = 0; i < this.scale; ++i) {
                sb.append('0');
            }
        }
        return sb.toString();
    }

    public boolean needHeadSpecialStyle() {
        return !MapUtils.isEmpty(this.headStyleParam) || !StringUtils.isEmpty((CharSequence)this.headStyleName);
    }

    public boolean needBodySpecialStyle() {
        return !MapUtils.isEmpty(this.bodyStyleParam) || !StringUtils.isEmpty((CharSequence)this.bodyStyleName);
    }

    private void genDefaultHeadStyle() {
        if (this.headStyleParam == null) {
            this.headStyleParam = new HashMap<String, Object>(4);
        }
        if (this.required) {
            this.headStyleParam.put("font.bold", Boolean.TRUE);
            this.headStyleParam.put("font.color", (short)10);
        }
    }

    private void genDefaultBodyStyle() {
        String format;
        if (this.bodyStyleParam == null) {
            this.bodyStyleParam = new HashMap<String, Object>(4);
        }
        if (!StringUtils.isEmpty((CharSequence)(format = this.fullFormat()))) {
            this.bodyStyleParam.put("dataFormat", format);
        } else if (!StringUtils.isEmpty((CharSequence)this.dataType)) {
            switch (this.dataType) {
                case "DATE": 
                case "LOCAL_DATE": {
                    this.bodyStyleParam.put("dataFormat", "yyyy-MM-dd");
                    break;
                }
                case "DATE_TIME": 
                case "LOCAL_DATE_TIME": {
                    this.bodyStyleParam.put("dataFormat", "yyyy-MM-dd HH:mm:ss");
                    break;
                }
            }
        } else {
            this.bodyStyleParam.put("dataFormat", DEFAULT_FORMAT);
        }
    }

    public HeadCellInfo ofHeadValueWrapper(ValueWrapperName valueWrapperName) {
        if (valueWrapperName == null) {
            this.setHeadValueWrapper(null);
        } else {
            this.setHeadValueWrapper(valueWrapperName.getWrapperName());
        }
        return this;
    }

    public HeadCellInfo ofBodyValueWrapper(ValueWrapperName valueWrapperName) {
        if (valueWrapperName == null) {
            this.setBodyValueWrapper(null);
        } else {
            this.setBodyValueWrapper(valueWrapperName.getWrapperName());
        }
        return this;
    }

    public void setHeadStyle(CellStyleName cellStyleName) {
        if (cellStyleName != null) {
            this.setHeadStyleName(cellStyleName.getStyleName());
        } else {
            this.setHeadStyleName(null);
        }
    }

    public void setBodyStyle(CellStyleName cellStyleName) {
        if (cellStyleName != null) {
            this.setBodyStyleName(cellStyleName.getStyleName());
        } else {
            this.setBodyStyleName(null);
        }
    }

    public Map<String, Object> getHeadStyleParam() {
        return this.headStyleParam;
    }

    public Map<String, Object> getBodyStyleParam() {
        return this.bodyStyleParam;
    }

    public void setHeadStyleParam(Map<String, Object> headStyleParam) {
        this.headStyleParam = headStyleParam;
    }

    public void setBodyStyleParam(Map<String, Object> bodyStyleParam) {
        this.bodyStyleParam = bodyStyleParam;
    }

    public String getHeadStyleName() {
        return this.headStyleName;
    }

    public void setHeadStyleName(String headStyleName) {
        this.headStyleName = headStyleName;
    }

    public String getBodyStyleName() {
        return this.bodyStyleName;
    }

    public void setBodyStyleName(String bodyStyleName) {
        this.bodyStyleName = bodyStyleName;
    }

    public String getValueProp() {
        return this.valueProp;
    }

    public void setValueProp(String valueProp) {
        this.valueProp = valueProp;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public String getHeadValueWrapper() {
        return this.headValueWrapper;
    }

    public void setHeadValueWrapper(String headValueWrapper) {
        this.headValueWrapper = headValueWrapper;
    }

    public String getBodyValueWrapper() {
        return this.bodyValueWrapper;
    }

    public void setBodyValueWrapper(String bodyValueWrapper) {
        this.bodyValueWrapper = bodyValueWrapper;
    }

    public String getDefaultDesc() {
        return this.defaultDesc;
    }

    public void setDefaultDesc(String defaultDesc) {
        this.defaultDesc = defaultDesc;
    }

    public String getI18nBase() {
        return this.i18nBase;
    }

    public void setI18nBase(String i18nBase) {
        this.i18nBase = i18nBase;
    }

    public String getI18nKey() {
        return this.i18nKey;
    }

    public void setI18nKey(String i18nKey) {
        this.i18nKey = i18nKey;
    }

    public short getHeight() {
        return this.height;
    }

    public void setHeight(short height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public void setRowNum(int rowNum) {
        this.rowNum = rowNum;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public void setColSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public boolean isMergeRowWithSameValue() {
        return this.mergeRowWithSameValue;
    }

    public void setMergeRowWithSameValue(boolean mergeRowWithSameValue) {
        this.mergeRowWithSameValue = mergeRowWithSameValue;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getBaseFormat() {
        return this.baseFormat;
    }

    public void setBaseFormat(String baseFormat) {
        this.baseFormat = baseFormat;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<String> getDropDownVals() {
        return this.dropDownVals;
    }

    public void setDropDownVals(List<String> dropDownVals) {
        this.dropDownVals = dropDownVals;
    }

    public static class PosComparator
    implements Comparator<HeadCellInfo> {
        @Override
        public int compare(HeadCellInfo o1, HeadCellInfo o2) {
            int div = o1.getColNum() - o2.getColNum();
            if (div != 0) {
                return div;
            }
            return o1.getRowNum() - o2.getRowNum();
        }
    }
}

