/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.bizdata.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hsas.business.extpoint.bizdata.IBizDataSynExtService;
import kd.sdk.swc.hsas.common.events.bizdata.AfterBizDataListEvent;
import kd.swc.hsas.business.bizdata.BizDataHelper;
import kd.swc.hsas.business.bizdata.entity.BizDataModifyRecEntity;
import kd.swc.hsas.business.bizdata.service.BizDataModifyRecHelper;
import kd.swc.hsas.business.bizdata.service.BizDataSynExtService;
import kd.swc.hsas.business.personchange.PersonChangeService;
import kd.swc.hsas.business.salaryfile.SalaryFileServiceHelper;
import kd.swc.hsas.common.utils.BizDataUniqueCodeUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.enums.BizDataFailStatusEnum;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.enums.BizDataUpdateFieldEnum;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.jetbrains.annotations.NotNull;

public class BizDataServiceHelper {
    public final Log log = LogFactory.getLog(BizDataServiceHelper.class);
    private static final int PERSONCHANGE_BATCHSIZE = 1000;
    private int pageNum;
    private int totalSize;
    private static final int BETWEEN_DAYS = 365;

    public Map<String, Object> synBizData(Map<String, Object> params) {
        boolean bySalaryFile = false;
        return this.dealBizData(params, bySalaryFile);
    }

    public Map<String, Object> synBizDataBySalaryFile(Map<String, Object> params) {
        boolean bySalaryFile = true;
        return this.dealBizData(params, bySalaryFile);
    }

    public List<Map<String, Object>> getBizDatas(Map<String, Object> params) {
        String fields;
        SWCDataServiceHelper helper;
        DynamicObject[] bizdatas;
        this.log.info("getBizDatas params is :{}", (Object)String.valueOf(JSON.toJSON(params)));
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(10);
        Long bizitemid = (Long)params.get("bizitemid");
        Date startdate = (Date)params.get("startdate");
        Date enddate = (Date)params.get("enddate");
        if (bizitemid == null || bizitemid == 0L || startdate == null || enddate == null) {
            retList.add(this.getBizDataErrorInfo(BizDataFailStatusEnum.FAILSTATUS_1080.getCode(), null));
            return retList;
        }
        String empnumber = (String)params.get("empnumber");
        Set salaryfileidset = (Set)params.get("salaryfileidset");
        Long depempid = (Long)params.get("depempid");
        if (!(!SWCStringUtils.isEmpty((String)empnumber) || salaryfileidset != null && salaryfileidset.size() != 0 || depempid != null && depempid != 0L)) {
            retList.add(this.getBizDataErrorInfo(BizDataFailStatusEnum.FAILSTATUS_1081.getCode(), null));
            return retList;
        }
        if (startdate.getTime() > enddate.getTime()) {
            retList.add(this.getBizDataErrorInfo(BizDataFailStatusEnum.FAILSTATUS_1082.getCode(), null));
            return retList;
        }
        long days = SWCDateTimeUtils.getTwoDateBetweenDays((Date)startdate, (Date)enddate);
        if (days > 365L) {
            String errorCode = BizDataFailStatusEnum.FAILSTATUS_1083.getCode();
            String errorMsg = BizDataFailStatusEnum.getDesc((String)errorCode);
            retList.add(this.getBizDataErrorInfo(errorCode, MessageFormat.format(errorMsg, 365)));
            return retList;
        }
        List matchSalaryFileList = null;
        if (depempid != null && depempid != 0L) {
            ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>(1);
            HashMap<String, Long> paramMap = new HashMap<String, Long>(2);
            paramMap.put("depEmpId", depempid);
            paramList.add(paramMap);
            SalaryFileServiceHelper salaryFileHelper = new SalaryFileServiceHelper();
            List<Map<String, Object>> salaryFileRsMap = salaryFileHelper.matchSalaryFile(paramList);
            if (salaryFileRsMap != null && salaryFileRsMap.size() > 0) {
                Map<String, Object> matchSalaryFileMap = salaryFileRsMap.get(0);
                matchSalaryFileList = (List)matchSalaryFileMap.get("matchSalaryFileIds");
            }
        }
        QFilter salaryFileFilter = this.getSalaryFileQfilter(empnumber, salaryfileidset, depempid, matchSalaryFileList);
        DynamicObject bizItemObj = this.getBizItemInfoById(bizitemid);
        if (SWCObjectUtils.isEmpty((Object)bizItemObj)) {
            retList.add(this.getBizDataErrorInfo(BizDataFailStatusEnum.FAILSTATUS_1021.getCode(), null));
            return retList;
        }
        QFilter bizItemFilter = new QFilter("bizitem.id", "=", (Object)bizitemid);
        boolean isRecur = false;
        String cycle = bizItemObj.getString("cycle");
        if (SWCStringUtils.equals((String)cycle, (String)"1")) {
            isRecur = true;
        }
        QFilter dateFilter = this.buildDateFilter(isRecur, startdate, enddate);
        String entityName = "hsas_nonrecurbizdata";
        if (isRecur) {
            entityName = "hsas_recurbizdata";
        }
        if ((bizdatas = (helper = new SWCDataServiceHelper(entityName)).query(fields = "salaryfile.employee.empnumber,salaryfile.id,salaryfile.number,salaryfile.name,bizitem.id,bizitem.number,bizitem.name,bsed,bsled,identifynumber,auditstatus,datavalue", new QFilter[]{salaryFileFilter, bizItemFilter, dateFilter})) == null || bizdatas.length == 0) {
            return retList;
        }
        for (DynamicObject bizDataObj : bizdatas) {
            HashMap<String, Object> bizDataMap = new HashMap<String, Object>(16);
            bizDataMap.put("empnumber", bizDataObj.getString("salaryfile.employee.empnumber"));
            bizDataMap.put("salaryfileid", bizDataObj.get("salaryfile.id"));
            bizDataMap.put("salaryfilenumber", bizDataObj.getString("salaryfile.number"));
            bizDataMap.put("salaryfilename", bizDataObj.getString("salaryfile.name"));
            if (depempid != null && depempid != 0L) {
                bizDataMap.put("depempid", depempid);
            }
            bizDataMap.put("bizitemid", bizDataObj.get("bizitem.id"));
            bizDataMap.put("bizitemname", bizDataObj.getString("bizitem.name"));
            bizDataMap.put("bizitemnumber", bizDataObj.getString("bizitem.number"));
            bizDataMap.put("bsed", bizDataObj.get("bsed"));
            bizDataMap.put("bsled", bizDataObj.get("bsled"));
            bizDataMap.put("bizdatacode", bizDataObj.get("identifynumber"));
            bizDataMap.put("auditstatus", bizDataObj.get("auditstatus"));
            bizDataMap.put("value", bizDataObj.get("datavalue"));
            retList.add(bizDataMap);
        }
        return retList;
    }

    private QFilter buildDateFilter(boolean isRecur, Date startdate, Date enddate) {
        if (isRecur) {
            QFilter aFilter = new QFilter("bsled", ">=", (Object)startdate).or(QFilter.isNull((String)"bsled"));
            QFilter bFilter = new QFilter("bsed", "<=", (Object)enddate);
            return aFilter.and(bFilter);
        }
        return new QFilter("bsed", ">=", (Object)startdate).and("bsed", "<=", (Object)enddate);
    }

    private DynamicObject getBizItemInfoById(Long bizItemId) {
        QFilter filter = new QFilter("id", "=", (Object)bizItemId);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitem");
        return helper.queryOne("id,cycle", new QFilter[]{filter});
    }

    private QFilter getSalaryFileQfilter(String empnumber, Set<Long> salaryfileidset, Long depempid, List<Long> matchSalaryFileList) {
        if (SWCStringUtils.isNotEmpty((String)empnumber) && salaryfileidset != null && salaryfileidset.size() > 0 && depempid != null && depempid != 0L) {
            if (matchSalaryFileList == null || matchSalaryFileList.size() == 0) {
                return new QFilter("1", "!=", (Object)1);
            }
            salaryfileidset.retainAll(matchSalaryFileList);
            QFilter filter = new QFilter("salaryfile.id", "in", salaryfileidset);
            filter.and("salaryfile.employee.empnumber", "=", (Object)empnumber);
            return filter;
        }
        if (SWCStringUtils.isNotEmpty((String)empnumber) && salaryfileidset != null && salaryfileidset.size() > 0 && (depempid == null || depempid == 0L)) {
            QFilter filter = new QFilter("salaryfile.employee.empnumber", "=", (Object)empnumber);
            filter.and("salaryfile.id", "in", salaryfileidset);
            return filter;
        }
        if (!(!SWCStringUtils.isNotEmpty((String)empnumber) || salaryfileidset != null && salaryfileidset.size() != 0 || depempid != null && depempid != 0L)) {
            return new QFilter("salaryfile.employee.empnumber", "=", (Object)empnumber);
        }
        if (SWCStringUtils.isEmpty((String)empnumber) && salaryfileidset != null && salaryfileidset.size() > 0 && depempid != null && depempid != 0L) {
            if (matchSalaryFileList == null || matchSalaryFileList.size() == 0) {
                return new QFilter("1", "!=", (Object)1);
            }
            salaryfileidset.retainAll(matchSalaryFileList);
            return new QFilter("salaryfile.id", "in", salaryfileidset);
        }
        if (SWCStringUtils.isEmpty((String)empnumber) && (salaryfileidset == null || salaryfileidset.size() == 0) && depempid != null && depempid != 0L) {
            if (matchSalaryFileList == null || matchSalaryFileList.size() == 0) {
                return new QFilter("1", "!=", (Object)1);
            }
            return new QFilter("salaryfile.id", "in", matchSalaryFileList);
        }
        if (SWCStringUtils.isEmpty((String)empnumber) && salaryfileidset != null && salaryfileidset.size() > 0 && (depempid == null || depempid == 0L)) {
            return new QFilter("salaryfile.id", "in", salaryfileidset);
        }
        if (SWCStringUtils.isNotEmpty((String)empnumber) && (salaryfileidset == null || salaryfileidset.size() == 0) && depempid != null && depempid != 0L) {
            if (matchSalaryFileList == null || matchSalaryFileList.size() == 0) {
                return new QFilter("1", "!=", (Object)1);
            }
            QFilter filter = new QFilter("salaryfile.id", "in", matchSalaryFileList);
            filter.and("salaryfile.employee.empnumber", "=", (Object)empnumber);
            return filter;
        }
        return new QFilter("1", "=", (Object)1);
    }

    private Map<String, Object> getBizDataErrorInfo(String errorCode, String errorMsg) {
        HashMap<String, Object> retMap = new HashMap<String, Object>(2);
        retMap.put("errorcode", errorCode);
        if (SWCStringUtils.isEmpty((String)errorMsg)) {
            retMap.put("errormsg", BizDataFailStatusEnum.getDesc((String)errorCode));
        } else {
            retMap.put("errormsg", errorMsg);
        }
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> dealBizData(Map<String, Object> params, boolean bySalaryFile) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(params.size());
        Date earliestBsed = null;
        Date lastBsled = null;
        if (bySalaryFile) {
            this.log.info("synBizDataBySalaryFile params is :{}", (Object)String.valueOf(JSON.toJSON(params)));
        } else {
            this.log.info("synBizData params is :{}", (Object)String.valueOf(JSON.toJSON(params)));
        }
        String operate = MapUtils.getString(params, (Object)"operate");
        String opSystem = MapUtils.getString(params, (Object)"opsystem");
        List addBizDataMapList = (List)params.get("data");
        HashSet<Long> bizItemSet = new HashSet<Long>(16);
        HashMap<String, Comparable<Long>> salaryFileParamMap = null;
        ArrayList<Map<String, Object>> salaryFileParamList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> allSalaryFileParamList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> validateParamList = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Object> validateParamMap = null;
        ArrayList<Map> mustInputCheckSuccList = new ArrayList<Map>(10);
        HashSet<String> errorIdentifyNums = new HashSet<String>(16);
        for (Map bizdata : addBizDataMapList) {
            Boolean aBoolean = this.checkBizDataMustInput(operate, bizdata, bySalaryFile);
            String bizDataCode = MapUtils.getString((Map)bizdata, (Object)"bizdatacode");
            if (!aBoolean.booleanValue()) {
                HashMap<String, String> failMap = new HashMap<String, String>();
                failMap.put("bizdatacode", bizDataCode);
                failMap.put("status", "0");
                failMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1080.getCode());
                failMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1080.getDesc());
                failMap.put("calpayrollid", null);
                failMap.put("salaryfileid", null);
                resultList.add(failMap);
                errorIdentifyNums.add(bizDataCode);
                continue;
            }
            mustInputCheckSuccList.add(bizdata);
            Long bizItemId = MapUtils.getLong((Map)bizdata, (Object)"bizitemid");
            bizItemSet.add(bizItemId);
            salaryFileParamMap = new HashMap<String, Comparable<Long>>(2);
            if (!bySalaryFile) {
                Long depempId = MapUtils.getLong((Map)bizdata, (Object)"depempid");
                salaryFileParamMap.put("depEmpId", depempId);
                Date bsed = (Date)bizdata.get("bsed");
                salaryFileParamMap.put("endDate", bsed);
                salaryFileParamList.add(salaryFileParamMap);
                String datasources = MapUtils.getString((Map)bizdata, (Object)"datasources");
                if (SWCStringUtils.equals((String)opSystem, (String)"hpdi") && SWCStringUtils.equals((String)datasources, (String)"3")) {
                    HashMap<String, Long> allSalaryFileMap = new HashMap<String, Long>(2);
                    allSalaryFileMap.put("depEmpId", depempId);
                    allSalaryFileParamList.add(allSalaryFileMap);
                }
            }
            validateParamMap = new HashMap<String, Object>(4);
            validateParamMap.put("bizdatacode", MapUtils.getString((Map)bizdata, (Object)"bizdatacode"));
            validateParamMap.put("bizitemid", bizItemId);
            validateParamMap.put("value", MapUtils.getString((Map)bizdata, (Object)"value"));
            validateParamMap.put("isencrypted", MapUtils.getString((Map)bizdata, (Object)"isencrypted"));
            validateParamMap.put("currencyid", MapUtils.getLong((Map)bizdata, (Object)"currencyid"));
            validateParamMap.put("propdatalist", bizdata.get("propdatalist"));
            validateParamList.add(validateParamMap);
        }
        Map<Long, DynamicObject> bizItemPropMap = this.getBizItemProp(validateParamList);
        Map<String, Object> validateResultMap = this.validateDataValue(validateParamList, bizItemPropMap);
        HashMap<String, Object> propErrorMap = new HashMap<String, Object>(16);
        HashMap<String, String> errorMsgMap = new HashMap<String, String>(16);
        Map<String, String> errorCodeMap = this.fetchErrorCode(validateResultMap, propErrorMap, errorMsgMap);
        HashMap<Long, DynamicObject> collectFileMap = new HashMap<Long, DynamicObject>(salaryFileParamList.size());
        HashMap<Long, Map<String, Object>> depEmpMap = new HashMap(16);
        Map<Object, Object> allDepEmpMap = new HashMap(16);
        Set<Object> salaryFileIdSet = new HashSet(16);
        Map<Object, Object> cacheSalaryFileIdAndOrgId = new HashMap(16);
        HashMap<Long, Set<Long>> cacheDepempAndSalaryFileRelMap = new HashMap<Long, Set<Long>>(16);
        SalaryFileServiceHelper salaryFileHelper = new SalaryFileServiceHelper();
        if (bySalaryFile) {
            Set<Long> checkFileIdSet = addBizDataMapList.stream().map(map -> (Long)map.get("salaryfileid")).collect(Collectors.toSet());
            salaryFileIdSet = salaryFileHelper.filterSalaryFileById(checkFileIdSet);
            if (salaryFileIdSet != null && salaryFileIdSet.size() > 0) {
                cacheSalaryFileIdAndOrgId = salaryFileHelper.getSalaryFileIdAndOrgIdRelation(salaryFileIdSet);
            }
        } else {
            long startTime = System.currentTimeMillis();
            List<Map<String, Object>> salaryFileRsMap = salaryFileHelper.matchSalaryFile(salaryFileParamList, collectFileMap);
            long endTime = System.currentTimeMillis();
            this.log.info("first query matchSalaryFile use time:{}", (Object)(endTime - startTime));
            depEmpMap = salaryFileRsMap.stream().collect(Collectors.toMap(map -> (Long)map.get("depEmpId"), map -> map, (k1, k2) -> k1));
            if (allSalaryFileParamList != null && allSalaryFileParamList.size() > 0) {
                startTime = System.currentTimeMillis();
                List<Map<String, Object>> allSalaryFileRsMap = salaryFileHelper.matchSalaryFile(allSalaryFileParamList);
                endTime = System.currentTimeMillis();
                this.log.info("second query matchSalaryFile use time:{}", (Object)(endTime - startTime));
                allDepEmpMap = allSalaryFileRsMap.stream().collect(Collectors.toMap(map -> (Long)map.get("depEmpId"), map -> map, (k1, k2) -> k1));
                if (allDepEmpMap != null && allDepEmpMap.size() > 0) {
                    for (Map.Entry<Object, Object> entry : allDepEmpMap.entrySet()) {
                        List list;
                        Long depempId = (Long)entry.getKey();
                        Map map2 = (Map)entry.getValue();
                        if (map2 == null || map2.size() == 0 || (list = (List)map2.get("matchSalaryFileIds")) == null || list.size() == 0) continue;
                        cacheDepempAndSalaryFileRelMap.put(depempId, new HashSet(list));
                    }
                }
            }
        }
        HashMap<Long, DynamicObject> collectBizItemMap = new HashMap<Long, DynamicObject>(bizItemSet.size());
        Map<Long, Boolean> bizItemMap = this.getBizItemMap(bizItemSet, collectBizItemMap);
        this.log.info("bizItemMap is :{}", (Object)String.valueOf(JSON.toJSON(bizItemMap)));
        HashMap<Long, Set<Long>> salaryFileOrgAndBizItemIdMap = new HashMap<Long, Set<Long>>(16);
        ArrayList<Map<String, Object>> recurSuccList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> nonRecurSuccList = new ArrayList<Map<String, Object>>(10);
        for (Map paramMap : mustInputCheckSuccList) {
            String bizDataCode = MapUtils.getString((Map)paramMap, (Object)"bizdatacode");
            HashMap<String, Object> failMap = new HashMap<String, Object>(16);
            failMap.put("bizdatacode", bizDataCode);
            String string = errorCodeMap.get(bizDataCode);
            if (!SWCStringUtils.isEmpty((String)string)) {
                failMap.put("status", "0");
                failMap.put("errorcode", string);
                failMap.put("errormsg", errorMsgMap.get(bizDataCode));
                failMap.put("calpayrollid", null);
                failMap.put("salaryfileid", null);
                List list = (List)propErrorMap.get(bizDataCode);
                if (list != null && list.size() > 0) {
                    failMap.put("properrorinfo", list);
                }
                resultList.add(failMap);
                errorIdentifyNums.add(bizDataCode);
                continue;
            }
            if (bySalaryFile) {
                Long l = MapUtils.getLong((Map)paramMap, (Object)"salaryfileid");
                if (!salaryFileIdSet.contains(l)) {
                    failMap.put("status", "0");
                    failMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_3010.getCode());
                    failMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_3010.getDesc());
                    failMap.put("calpayrollid", null);
                    failMap.put("salaryfileid", null);
                    resultList.add(failMap);
                    errorIdentifyNums.add(bizDataCode);
                    continue;
                }
                Long bizItemId = MapUtils.getLong((Map)paramMap, (Object)"bizitemid");
                DynamicObject bizItem = (DynamicObject)collectBizItemMap.get(bizItemId);
                Long orgId = (Long)cacheSalaryFileIdAndOrgId.get(l);
                if (orgId != null && !SWCStringUtils.equals((String)bizItem.getString("ctrlstrategy"), (String)"5")) {
                    Set queryBizItemIdSet = (Set)salaryFileOrgAndBizItemIdMap.get(orgId);
                    if (queryBizItemIdSet == null) {
                        long startTime = System.currentTimeMillis();
                        queryBizItemIdSet = SWCPermissionServiceHelper.queryBaseDataUseOrgSet((String)"hsbs_bizitem", (Long)orgId, bizItemSet);
                        long endTime = System.currentTimeMillis();
                        this.log.info("queryBaseDataUseOrgSet bizitem use time:{}", (Object)(endTime - startTime));
                    }
                    salaryFileOrgAndBizItemIdMap.put(orgId, queryBizItemIdSet);
                    if (!queryBizItemIdSet.contains(bizItemId)) {
                        failMap.put("status", "0");
                        failMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1034.getCode());
                        failMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1034.getDesc());
                        failMap.put("calpayrollid", null);
                        failMap.put("salaryfileid", null);
                        resultList.add(failMap);
                        errorIdentifyNums.add(bizDataCode);
                        continue;
                    }
                }
            } else {
                long l = System.currentTimeMillis();
                if (!this.checkMatchSalaryFile(resultList, depEmpMap, paramMap, failMap, collectFileMap, salaryFileOrgAndBizItemIdMap, collectBizItemMap, bizItemSet)) {
                    errorIdentifyNums.add(bizDataCode);
                    continue;
                }
                long endTime = System.currentTimeMillis();
                this.log.info("checkMatchSalaryFile by depmentId use time:{}", (Object)(endTime - l));
            }
            this.setEarliestAndLastDate(earliestBsed, lastBsled, paramMap);
            Long l = MapUtils.getLong((Map)paramMap, (Object)"bizitemid");
            Boolean isRecur = bizItemMap.get(l);
            if (isRecur.booleanValue()) {
                if (SWCStringUtils.equals((String)operate, (String)"2")) {
                    failMap.put("status", "0");
                    failMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1005.getCode());
                    failMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1005.getDesc());
                    failMap.put("calpayrollid", null);
                    failMap.put("salaryfileid", null);
                    resultList.add(failMap);
                    errorIdentifyNums.add(bizDataCode);
                    continue;
                }
                recurSuccList.add(paramMap);
                continue;
            }
            nonRecurSuccList.add(paramMap);
        }
        this.log.info("recurSuccList size  is :{}", (Object)recurSuccList.size());
        this.log.info("nonrecurSuccList size is :{}", (Object)nonRecurSuccList.size());
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        ArrayList<Map<String, Object>> dataRsList = new ArrayList<Map<String, Object>>(params.size());
        try {
            List bizDataRecordMapList;
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_recurbizdata");
            if (recurSuccList.size() > 0) {
                List<List<Map<String, Object>>> bizDataList = this.getRecurBizDataList(recurSuccList);
                for (List<Map<String, Object>> list : bizDataList) {
                    this.getBizDataList(helper, list, dataRsList, operate, opSystem, Boolean.TRUE, errorIdentifyNums, bizItemPropMap, cacheDepempAndSalaryFileRelMap);
                }
            }
            if (nonRecurSuccList.size() > 0) {
                helper.setEntityName("hsas_nonrecurbizdata");
                this.getBizDataList(helper, nonRecurSuccList, dataRsList, operate, opSystem, Boolean.FALSE, errorIdentifyNums, bizItemPropMap, null);
            }
            if ((bizDataRecordMapList = (List)params.get("data_record")) != null && bizDataRecordMapList.size() > 0) {
                this.getBizDataRecordList(bizDataRecordMapList, nonRecurSuccList, errorIdentifyNums);
            }
            resultMap.put("success", Boolean.TRUE);
            resultMap.put("message", "ok");
            resultList.addAll(dataRsList);
            resultMap.put("result", resultList);
        }
        catch (Exception e) {
            for (Map map3 : dataRsList) {
                map3.put("status", "0");
                map3.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_2020.getCode());
                map3.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_2020.getDesc());
                resultList.add(map3);
            }
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("message", e.toString());
        }
        finally {
            resultMap.put("result", resultList);
        }
        this.log.info("synBizData result is :{}", (Object)String.valueOf(JSON.toJSON(resultMap)));
        return resultMap;
    }

    private void getBizDataRecordList(List<Map<String, Object>> bizDataRecordMapList, List<Map<String, Object>> nonRecurSuccList, Set<String> errorIdentifyNums) {
        HashMap<Long, Long> cacheSalaryFileRecordIdMap = new HashMap<Long, Long>(nonRecurSuccList.size());
        for (Map<String, Object> nonRecurSuccMap : nonRecurSuccList) {
            Long recordId = MapUtils.getLong(nonRecurSuccMap, (Object)"bizdatarecord");
            Long salaryFileId = MapUtils.getLong(nonRecurSuccMap, (Object)"salaryfileid");
            cacheSalaryFileRecordIdMap.put(recordId, salaryFileId);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bizdatarecord");
        List<DynamicObject> saveArray = new ArrayList(bizDataRecordMapList.size());
        for (int i = 0; i < bizDataRecordMapList.size(); ++i) {
            Date bsled;
            Date bsed;
            Long currencyId;
            Long calFrequencyId;
            String srcSystem;
            String dataSources;
            Long bizDataAccessTplId;
            String batchCode;
            String bizDataCode;
            Map<String, Object> bizDataRecordMap = bizDataRecordMapList.get(i);
            if (errorIdentifyNums.contains(bizDataRecordMap.get("bizdatacode"))) continue;
            DynamicObject recordObj = helper.generateEmptyDynamicObject();
            Long bizDataRecord = (Long)bizDataRecordMap.get("bizdatarecord");
            Long salaryFileId = (Long)cacheSalaryFileRecordIdMap.get(bizDataRecord);
            if (salaryFileId == null) continue;
            recordObj.set("salaryfile", (Object)salaryFileId);
            if (bizDataRecord != null) {
                recordObj.set("id", (Object)bizDataRecord);
            }
            if (SWCStringUtils.isNotEmpty((String)(bizDataCode = (String)bizDataRecordMap.get("bizdatacode")))) {
                recordObj.set("identifynumber", (Object)bizDataCode);
            }
            if (SWCStringUtils.isNotEmpty((String)(batchCode = (String)bizDataRecordMap.get("batchcode")))) {
                recordObj.set("batchnumber", (Object)batchCode);
            }
            if ((bizDataAccessTplId = (Long)bizDataRecordMap.get("bizdataaccesstplid")) != null) {
                recordObj.set("bizdataaccesstpl", (Object)bizDataAccessTplId);
            }
            if (SWCStringUtils.isNotEmpty((String)(dataSources = (String)bizDataRecordMap.get("datasources")))) {
                recordObj.set("datasources", (Object)dataSources);
            }
            if (SWCStringUtils.isNotEmpty((String)(srcSystem = (String)bizDataRecordMap.get("srcsystem")))) {
                recordObj.set("srcsystem", (Object)srcSystem);
            }
            if ((calFrequencyId = (Long)bizDataRecordMap.get("calfrequencyid")) != null) {
                recordObj.set("frequency", (Object)calFrequencyId);
            }
            if ((currencyId = (Long)bizDataRecordMap.get("currencyid")) != null) {
                recordObj.set("currency", (Object)currencyId);
            }
            if ((bsed = (Date)bizDataRecordMap.get("bsed")) != null) {
                try {
                    bsed = SWCDateTimeUtils.formatDateToDate((Date)bsed, (String)"yyyy-MM-dd");
                    bizDataRecordMap.put("bsed", bsed);
                }
                catch (ParseException e) {
                    this.log.info("bizdatarecord bsed formate error!");
                }
                recordObj.set("bsed", (Object)bsed);
            }
            if ((bsled = (Date)bizDataRecordMap.get("bsled")) != null) {
                try {
                    bsled = SWCDateTimeUtils.formatDateToDate((Date)bsled, (String)"yyyy-MM-dd");
                    bizDataRecordMap.put("bsled", bsled);
                }
                catch (ParseException e) {
                    this.log.info("bizdatarecord bsled formate error!");
                }
                recordObj.set("bsled", (Object)bsled);
            }
            recordObj.set("auditstatus", (Object)"C");
            long userId = RequestContext.get().getCurrUserId();
            recordObj.set("creator", (Object)userId);
            recordObj.set("modifier", (Object)userId);
            this.commSetExtPropValue(recordObj, bizDataRecordMap);
            saveArray.add(recordObj);
        }
        AfterBizDataListEvent afterBizDataListEvent = new AfterBizDataListEvent(null, saveArray);
        this.invokeAfterBizDataList(afterBizDataListEvent);
        saveArray = afterBizDataListEvent.getBizDataRecordList();
        if (saveArray != null && saveArray.size() > 0) {
            DynamicObject[] saveObjs = new DynamicObject[saveArray.size()];
            for (int i = 0; i < saveArray.size(); ++i) {
                saveObjs[i] = (DynamicObject)saveArray.get(i);
            }
            helper.save(saveObjs);
        }
    }

    @NotNull
    private List<List<Map<String, Object>>> getRecurBizDataList(List<Map<String, Object>> recurSuccList) {
        recurSuccList.sort((o1, o2) -> {
            if (o1 != null && o2 != null && o1.get("bsed") != null && o2.get("bsed") != null) {
                return ((Date)o1.get("bsed")).compareTo((Date)o2.get("bsed"));
            }
            return 1;
        });
        Map<String, List<Map>> map = recurSuccList.stream().collect(Collectors.groupingBy(data -> data.get("salaryfileid") + "-" + data.get("bizitemid")));
        ArrayList<List<Map<String, Object>>> bizDataList = new ArrayList<List<Map<String, Object>>>(10);
        for (Map.Entry<String, List<Map>> entry : map.entrySet()) {
            List<Map> dataList = entry.getValue();
            for (int index = 0; index < dataList.size(); ++index) {
                List<Map> subList;
                if (bizDataList.size() <= index) {
                    subList = new ArrayList();
                    bizDataList.add(subList);
                } else {
                    subList = (List)bizDataList.get(index);
                }
                subList.add(dataList.get(index));
            }
        }
        return bizDataList;
    }

    private boolean checkMatchSalaryFile(List<Map<String, Object>> resultList, Map<Long, Map<String, Object>> depEmpMap, Map<String, Object> paramMap, Map<String, Object> failMap, Map<Long, DynamicObject> collectFileMap, Map<Long, Set<Long>> salaryFileOrgAndBizItemIdMap, Map<Long, DynamicObject> collectBizItemMap, Set<Long> bizItemSet) {
        Long depEmpId = MapUtils.getLong(paramMap, (Object)"depempid");
        Map<String, Object> resultMap = depEmpMap.get(depEmpId);
        if (SWCObjectUtils.isEmpty(resultMap)) {
            failMap.put("status", "0");
            failMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1032.getCode());
            failMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1032.getDesc());
            failMap.put("calpayrollid", null);
            failMap.put("salaryfileid", null);
            resultList.add(failMap);
            this.log.info("checkMatchSalaryFile resultMap is empty!");
            return false;
        }
        Integer queryRowCount = (Integer)resultMap.get("queryRowCount");
        if (0 == queryRowCount) {
            failMap.put("status", "0");
            failMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1032.getCode());
            failMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1032.getDesc());
            failMap.put("calpayrollid", null);
            failMap.put("salaryfileid", null);
            resultList.add(failMap);
            this.log.info("checkMatchSalaryFile queryRowCount is 0!");
            return false;
        }
        if (queryRowCount > 1) {
            failMap.put("status", "0");
            failMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1033.getCode());
            failMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1033.getDesc());
            failMap.put("calpayrollid", null);
            failMap.put("salaryfileid", null);
            resultList.add(failMap);
            this.log.info("checkMatchSalaryFile queryRowCount > 1!");
            return false;
        }
        Long salaryFileId = (Long)resultMap.get("matchSalaryFileId");
        Long bizItemId = MapUtils.getLong(paramMap, (Object)"bizitemid");
        DynamicObject salaryFile = collectFileMap.get(salaryFileId);
        DynamicObject bizItem = collectBizItemMap.get(bizItemId);
        if (salaryFile != null && !SWCStringUtils.equals((String)bizItem.getString("ctrlstrategy"), (String)"5")) {
            Long orgId = salaryFile.getLong("org.id");
            Set queryBizItemIdSet = salaryFileOrgAndBizItemIdMap.get(orgId);
            if (queryBizItemIdSet == null) {
                queryBizItemIdSet = SWCPermissionServiceHelper.queryBaseDataUseOrgSet((String)"hsbs_bizitem", (Long)orgId, bizItemSet);
            }
            salaryFileOrgAndBizItemIdMap.put(orgId, queryBizItemIdSet);
            if (!queryBizItemIdSet.contains(bizItemId)) {
                failMap.put("status", "0");
                failMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1034.getCode());
                failMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1034.getDesc());
                failMap.put("calpayrollid", null);
                failMap.put("salaryfileid", null);
                resultList.add(failMap);
                resultList.add(failMap);
                return false;
            }
        }
        paramMap.put("salaryfileid", salaryFileId);
        return true;
    }

    public Map<String, Object> updateBlsed(Map<String, Object> params) {
        this.log.info("updateBlsed params is :{}", (Object)String.valueOf(JSON.toJSON(params)));
        List updateBlsedList = (List)params.get("data");
        String opsystem = MapUtils.getString(params, (Object)"opsystem");
        HashSet<Long> bizItemSet = new HashSet<Long>(16);
        for (Map bizdata : updateBlsedList) {
            Long bizItemId = MapUtils.getLong((Map)bizdata, (Object)"bizitemid");
            bizItemSet.add(bizItemId);
        }
        Map<Long, Boolean> bizItemMap = this.getBizItemMap(bizItemSet);
        this.log.info("bizItem isrecur Map:{}", (Object)String.valueOf(JSON.toJSON(bizItemMap)));
        ArrayList<String> recurList = new ArrayList<String>(10);
        ArrayList<String> nonRecurList = new ArrayList<String>(10);
        HashMap<String, Map<String, Object>> recurParamMap = new HashMap<String, Map<String, Object>>(16);
        HashMap<String, Set<Long>> cacheBizDataCodeAndBizItem = new HashMap<String, Set<Long>>(updateBlsedList.size());
        for (Map dataMap : updateBlsedList) {
            Long bizItem = MapUtils.getLong((Map)dataMap, (Object)"bizitemid");
            String bizDataCode = MapUtils.getString((Map)dataMap, (Object)"bizdatacode");
            HashSet<Long> bizItemIdSet = (HashSet<Long>)cacheBizDataCodeAndBizItem.get(bizDataCode);
            if (bizItemIdSet == null) {
                bizItemIdSet = new HashSet<Long>(16);
            }
            bizItemIdSet.add(bizItem);
            cacheBizDataCodeAndBizItem.put(bizDataCode, bizItemIdSet);
            if (bizItemMap.get(bizItem).booleanValue()) {
                recurList.add(bizDataCode);
                recurParamMap.put(bizDataCode, dataMap);
                continue;
            }
            nonRecurList.add(bizDataCode);
        }
        this.log.info("recurList size  is :{}", (Object)recurList.size());
        this.log.info("nonRecurList size is :{}", (Object)nonRecurList.size());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_recurbizdata");
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(recurList.size());
        if (recurList.size() > 0) {
            this.updateBizDataBsled(helper, recurList, recurParamMap, resultList, opsystem, cacheBizDataCodeAndBizItem);
        }
        if (nonRecurList.size() > 0) {
            for (String bizDataCode : nonRecurList) {
                HashMap<String, String> resltMap = new HashMap<String, String>(3);
                resltMap.put("status", "0");
                resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1099.getCode());
                resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1099.getDesc());
                resltMap.put("bizdatacode", bizDataCode);
                resultList.add(resltMap);
            }
        }
        HashMap<String, Object> responseMap = new HashMap<String, Object>(3);
        responseMap.put("success", Boolean.TRUE);
        responseMap.put("message", "ok");
        responseMap.put("result", resultList);
        this.log.info("updateBlsed result is :{}", (Object)String.valueOf(JSON.toJSON(responseMap)));
        return responseMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBizDataBsled(SWCDataServiceHelper helper, List<String> bizDataList, Map<String, Map<String, Object>> paramMap, List<Map<String, Object>> resultList, String opsystem, Map<String, Set<Long>> cacheBizDataCodeAndBizItem) {
        block25: {
            DynamicObject[] bizDataColl = this.getBizDataColl(helper, bizDataList, opsystem, false);
            ArrayList<Long> bizDataIdList = new ArrayList<Long>(bizDataColl.length);
            HashMap<String, DynamicObject> identifynumBizdataMap = new HashMap<String, DynamicObject>(bizDataColl.length);
            HashSet<Long> salaryFileIdSet = new HashSet<Long>(16);
            HashSet<Long> bizItemIdSet = new HashSet<Long>(16);
            HashMap<String, Date> bizDataBsledDateMap = new HashMap<String, Date>(16);
            for (DynamicObject bizData : bizDataColl) {
                String identifynum = bizData.getString("identifynumber");
                long bizItemId = bizData.getLong("bizitem.id");
                identifynumBizdataMap.put(identifynum, bizData);
                bizDataIdList.add(bizData.getLong("id"));
                Long salaryFileId = bizData.getLong("salaryfile.id");
                salaryFileIdSet.add(salaryFileId);
                bizItemIdSet.add(bizItemId);
                Date oldBsled = bizData.getDate("bsled");
                if (oldBsled == null) continue;
                bizDataBsledDateMap.put(identifynum + '#' + bizItemId, oldBsled);
            }
            this.log.info("bizDataIdList  is :{}", (Object)JSON.toJSONString(bizDataIdList));
            this.log.info("identifynumBizdataMap keyset is :{}", (Object)JSON.toJSONString(identifynumBizdataMap.keySet()));
            BizDataHelper bizDataHelper = new BizDataHelper();
            HashMap<String, String> cacheAuditStatusMap = new HashMap<String, String>(16);
            Table<Long, Long, Set<DynamicObject>> failMap = bizDataHelper.checkBizDateUpdateBsledFailTable(helper, salaryFileIdSet, bizItemIdSet, cacheAuditStatusMap);
            ArrayList<DynamicObject> updateDysList = new ArrayList<DynamicObject>(10);
            HashSet<String> waitRollBackCodes = new HashSet<String>(16);
            for (String bizDataCode : bizDataList) {
                Set bizDataIdSet;
                Map<String, Object> param;
                Date bsled;
                HashMap<String, String> resltMap = new HashMap<String, String>(3);
                this.log.info("bizDataCode is :{}", (Object)bizDataCode);
                resltMap.put("bizdatacode", bizDataCode);
                if (!identifynumBizdataMap.containsKey(bizDataCode)) {
                    resltMap.put("status", "0");
                    resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1020.getCode());
                    resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1020.getDesc());
                    resultList.add(resltMap);
                    continue;
                }
                String auditStatus = (String)cacheAuditStatusMap.get(bizDataCode);
                if (!SWCStringUtils.equals((String)auditStatus, (String)"C")) {
                    resltMap.put("status", "0");
                    resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1041.getCode());
                    resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1041.getDesc());
                    resultList.add(resltMap);
                    continue;
                }
                DynamicObject bizDataObj = (DynamicObject)identifynumBizdataMap.get(bizDataCode);
                Long bizItemId = bizDataObj.getLong("bizitem.id");
                Set<Long> cacheBizItemIdSet = cacheBizDataCodeAndBizItem.get(bizDataCode);
                if (cacheBizItemIdSet == null || !cacheBizItemIdSet.contains(bizItemId)) {
                    resltMap.put("status", "0");
                    resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1022.getCode());
                    resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1022.getDesc());
                    resltMap.put("bizdatacode", bizDataCode);
                    resultList.add(resltMap);
                    continue;
                }
                Date bsed = bizDataObj.getDate("bsed");
                if (bsed != null) {
                    try {
                        bsed = SWCDateTimeUtils.formatDateToDate((Date)bsed, (String)"yyyy-MM-dd");
                    }
                    catch (ParseException e) {
                        this.log.info("updateBizDataBsled bsed formatDateToDate error!");
                    }
                }
                if ((bsled = (Date)(param = paramMap.get(bizDataCode)).get("bsled")) != null) {
                    try {
                        bsled = SWCDateTimeUtils.formatDateToDate((Date)bsled, (String)"yyyy-MM-dd");
                    }
                    catch (ParseException e) {
                        this.log.info("updateBizDataBsled bsled formatDateToDate error!");
                    }
                }
                if (bsled != null && bsed != null && bsed.compareTo(bsled) > 0) {
                    resltMap.put("status", "0");
                    resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1060.getCode());
                    resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1060.getDesc());
                    resultList.add(resltMap);
                    continue;
                }
                Long salaryFileId = bizDataObj.getLong("salaryfile.id");
                long updateId = bizDataObj.getLong("id");
                Set<String> overlapBizDatas = bizDataHelper.getOverlapIdentifyNumbers(updateId, bsled, bsed, bizDataIdSet = (Set)failMap.get((Object)salaryFileId, (Object)bizItemId));
                if (CollectionUtils.isNotEmpty(overlapBizDatas)) {
                    resltMap.put("status", "0");
                    resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1075.getCode());
                    resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1075.getDesc());
                    resultList.add(resltMap);
                    continue;
                }
                bizDataObj.set("bsled", (Object)bsled);
                bizDataObj.set("opsystem", (Object)opsystem);
                updateDysList.add(bizDataObj);
                if (!"1".equals(MapUtils.getString(param, (Object)"operate"))) continue;
                waitRollBackCodes.add(MapUtils.getString(param, (Object)"bizdatacode"));
            }
            HashMap<String, DynamicObject> latestRelatedDataMap = new HashMap();
            if (CollectionUtils.isNotEmpty(waitRollBackCodes)) {
                latestRelatedDataMap = this.getLatestBsledRecord(waitRollBackCodes, BizDataOperateEnum.OPERATE_UPDATE.getCode());
            }
            if (updateDysList.size() > 0) {
                HashMap<String, String> resltMap;
                ArrayList<Map<String, Object>> updateBizDataList = new ArrayList<Map<String, Object>>(updateDysList.size());
                SWCDataServiceHelper bsledRecordHelper = new SWCDataServiceHelper("hsas_bizdatabsledrecord");
                ArrayList<DynamicObject> bsledDataList = new ArrayList<DynamicObject>(updateDysList.size());
                ArrayList<BizDataModifyRecEntity> needSaveLogDataList = new ArrayList<BizDataModifyRecEntity>(updateDysList.size());
                long userId = RequestContext.get().getCurrUserId();
                ArrayList<DynamicObject> needUpdateBsledStatusList = new ArrayList<DynamicObject>(updateDysList.size());
                this.buildUpdateBsledDatas(updateDysList, bsledRecordHelper, opsystem, bizDataBsledDateMap, paramMap, latestRelatedDataMap, needUpdateBsledStatusList, userId, bsledDataList, needSaveLogDataList, updateBizDataList);
                String statusFlag = "";
                String code = null;
                String errorMsg = null;
                TXHandle txHandle = TX.requiresNew();
                try {
                    helper.update(updateDysList.toArray(new DynamicObject[updateDysList.size()]));
                    bsledRecordHelper.save(bsledDataList.toArray(new DynamicObject[bsledDataList.size()]));
                    statusFlag = "1";
                    if (updateBizDataList.size() > 0) {
                        Map result = (Map)SWCMServiceUtils.invokeSWCService((String)"hpdi", (String)"IHPDIBizDataService", (String)"updateBizData", (Object[])new Object[]{updateBizDataList});
                        this.log.info("BizDataServiceHelper IHPDIBizDataService result is:{}", (Object)result);
                    }
                    if (needSaveLogDataList.size() > 0) {
                        this.log.info("BizDataServiceHelper update bsled log");
                        BizDataModifyRecHelper.saveBizDataModifyRec(needSaveLogDataList);
                    }
                    if (needUpdateBsledStatusList.size() > 0) {
                        bsledRecordHelper.update(needUpdateBsledStatusList.toArray(new DynamicObject[0]));
                    }
                }
                catch (Exception e) {
                    statusFlag = "0";
                    code = BizDataFailStatusEnum.FAILSTATUS_2020.getCode();
                    errorMsg = BizDataFailStatusEnum.FAILSTATUS_2020.getDesc();
                    txHandle.markRollback();
                    break block25;
                }
                finally {
                    for (DynamicObject updateBizData : updateDysList) {
                        resltMap = new HashMap<String, String>(3);
                        resltMap.put("bizdatacode", updateBizData.getString("identifynumber"));
                        resltMap.put("status", statusFlag);
                        resltMap.put("errorcode", code);
                        resltMap.put("errormsg", errorMsg);
                        resultList.add(resltMap);
                    }
                    txHandle.close();
                }
                for (DynamicObject updateBizData : updateDysList) {
                    resltMap = new HashMap(3);
                    resltMap.put("bizdatacode", updateBizData.getString("identifynumber"));
                    resltMap.put("status", statusFlag);
                    resltMap.put("errorcode", code);
                    resltMap.put("errormsg", errorMsg);
                    resultList.add(resltMap);
                }
                txHandle.close();
            }
        }
    }

    private void buildUpdateBsledDatas(List<DynamicObject> updateDysList, SWCDataServiceHelper bsledRecordHelper, String opsystem, Map<String, Date> bizDataBsledDateMap, Map<String, Map<String, Object>> paramMap, Map<String, DynamicObject> latestRelatedDataMap, List<DynamicObject> needUpdateBsledStatusList, long userId, List<DynamicObject> bsledDataList, List<BizDataModifyRecEntity> needSaveLogDataList, List<Map<String, Object>> updateBizDataList) {
        for (DynamicObject updateObj : updateDysList) {
            DynamicObject bsledRecordObj = bsledRecordHelper.generateEmptyDynamicObject();
            Long updateSalaryFileId = updateObj.getLong("salaryfile.id");
            bsledRecordObj.set("salaryfile", (Object)updateSalaryFileId);
            Long oldBizItemId = updateObj.getLong("bizitem.id");
            bsledRecordObj.set("bizitem", (Object)oldBizItemId);
            String bizDataCode = updateObj.getString("identifynumber");
            bsledRecordObj.set("bizdatacode", (Object)bizDataCode);
            bsledRecordObj.set("opbizdatacode", (Object)bizDataCode);
            Date beforeBsled = bizDataBsledDateMap.get(bizDataCode + '#' + oldBizItemId);
            if (beforeBsled != null) {
                bsledRecordObj.set("beforebsled", (Object)beforeBsled);
            }
            bsledRecordObj.set("afterbsled", (Object)updateObj.getDate("bsled"));
            if (SWCStringUtils.equals((String)opsystem, (String)"hpdi")) {
                String operate;
                bsledRecordObj.set("optype", (Object)BizDataOperateEnum.OPERATE_UPDATE.getCode());
                Map<String, Object> param = paramMap.get(bizDataCode);
                if (param != null && param.size() > 0 && SWCStringUtils.equals((String)(operate = MapUtils.getString(param, (Object)"operate")), (String)"1")) {
                    bsledRecordObj.set("optype", (Object)BizDataOperateEnum.OPERATE_ROLLBACK_UPDATE.getCode());
                    bsledRecordObj.set("isabandon", (Object)"1");
                    DynamicObject bsledRecord = latestRelatedDataMap.get(bizDataCode);
                    if (!SWCObjectUtils.isEmpty((Object)bsledRecord)) {
                        bsledRecord.set("isabandon", (Object)"1");
                        needUpdateBsledStatusList.add(bsledRecord);
                    }
                }
            } else {
                bsledRecordObj.set("optype", (Object)BizDataOperateEnum.OPERATE_ITF_UPDATE.getCode());
            }
            bsledRecordObj.set("modifier", (Object)userId);
            bsledRecordObj.set("modifytime", (Object)new Date());
            bsledDataList.add(bsledRecordObj);
            BizDataModifyRecEntity dataModifyRec = new BizDataModifyRecEntity();
            dataModifyRec.setSalaryFileId(updateSalaryFileId);
            dataModifyRec.setBizDataNum(bizDataCode);
            dataModifyRec.setBizItemId(oldBizItemId);
            dataModifyRec.setUpdateField(BizDataUpdateFieldEnum.BSLED.getCode());
            if (beforeBsled != null) {
                String beforeUpdateBsed = SWCDateTimeUtils.format((Date)beforeBsled, (String)"yyyy-MM-dd");
                dataModifyRec.setBeforeUpdate(beforeUpdateBsed);
            }
            if (updateObj.getDate("bsled") != null) {
                String afterUpdateBsed = SWCDateTimeUtils.format((Date)updateObj.getDate("bsled"), (String)"yyyy-MM-dd");
                dataModifyRec.setAfterUpdate(afterUpdateBsed);
            }
            dataModifyRec.setDataSources(updateObj.getString("datasources"));
            if (SWCStringUtils.equals((String)opsystem, (String)"hpdi")) {
                String operate;
                dataModifyRec.setOperate(BizDataOperateEnum.OPERATE_UPDATE.getCode());
                Map<String, Object> param = paramMap.get(bizDataCode);
                if (param != null && param.size() > 0 && SWCStringUtils.equals((String)(operate = MapUtils.getString(param, (Object)"operate")), (String)"1")) {
                    dataModifyRec.setOperate(BizDataOperateEnum.OPERATE_ROLLBACK_UPDATE.getCode());
                }
            } else {
                dataModifyRec.setOperate(BizDataOperateEnum.OPERATE_ITF_UPDATE.getCode());
            }
            dataModifyRec.setDataId(updateObj.getLong("id"));
            dataModifyRec.setModelType("1");
            needSaveLogDataList.add(dataModifyRec);
            if (SWCStringUtils.equals((String)opsystem, (String)"hpdi")) continue;
            HashMap<String, Object> updateBizDataMap = new HashMap<String, Object>(16);
            updateBizDataMap.put("bizdatacode", bizDataCode);
            updateBizDataMap.put("bizitem", oldBizItemId);
            updateBizDataMap.put("salaryfile", updateSalaryFileId);
            updateBizDataMap.put("modeltype", "1");
            updateBizDataMap.put("operate", BizDataOperateEnum.OPERATE_UPDATE.getCode());
            updateBizDataMap.put("bsled", updateObj.getDate("bsled"));
            updateBizDataMap.put("modifier", userId);
            updateBizDataList.add(updateBizDataMap);
        }
    }

    public Map<String, Object> delBizData(Map<String, Object> param) {
        this.log.info("delBizData params is :{}", (Object)String.valueOf(JSON.toJSON(param)));
        List dataMapList = (List)param.get("data");
        HashSet<Long> bizItemSet = new HashSet<Long>(16);
        HashMap<String, Object> responseMap = new HashMap<String, Object>(3);
        if (CollectionUtils.isEmpty((Collection)dataMapList)) {
            responseMap.put("success", Boolean.FALSE);
            responseMap.put("message", "data is empty");
            responseMap.put("result", null);
            return responseMap;
        }
        HashMap<String, String> cacheOpReasonMap = new HashMap<String, String>(dataMapList.size());
        for (Map bizdata : dataMapList) {
            String bizDataCode;
            Long bizItemId = MapUtils.getLong((Map)bizdata, (Object)"bizitemid");
            bizItemSet.add(bizItemId);
            String opReason = MapUtils.getString((Map)bizdata, (Object)"opreason");
            if (!SWCStringUtils.isNotEmpty((String)opReason) || !SWCStringUtils.isNotEmpty((String)(bizDataCode = MapUtils.getString((Map)bizdata, (Object)"bizdatacode")))) continue;
            cacheOpReasonMap.put(bizDataCode, opReason);
        }
        Map<Long, Boolean> bizItemMap = this.getBizItemMap(bizItemSet);
        if (bizItemMap.isEmpty() || bizItemMap.size() == 0) {
            responseMap.put("success", Boolean.TRUE);
            responseMap.put("message", "ok");
            HashMap<String, String> resltMap = new HashMap<String, String>(2);
            resltMap.put("status", "0");
            resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1022.getCode());
            resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1022.getDesc());
            responseMap.put("result", resltMap);
            return responseMap;
        }
        ArrayList<String> recurList = new ArrayList<String>(10);
        ArrayList<String> nonRecurList = new ArrayList<String>(10);
        for (Object dataMap : dataMapList) {
            Long bizItem = MapUtils.getLong((Map)dataMap, (Object)"bizitemid");
            String identifynumber = MapUtils.getString((Map)dataMap, (Object)"bizdatacode");
            if (bizItemMap.get(bizItem) == null) continue;
            if (bizItemMap.get(bizItem).booleanValue()) {
                recurList.add(identifynumber);
                continue;
            }
            nonRecurList.add(identifynumber);
        }
        HashMap<String, Set<Long>> cacheBizDataCodeAndBizItem = new HashMap<String, Set<Long>>(dataMapList.size());
        for (Map dataMap : dataMapList) {
            String bizDataCode = (String)dataMap.get("bizdatacode");
            Long bizItemId = (Long)dataMap.get("bizitemid");
            HashSet<Long> bizItemIdSet = (HashSet<Long>)cacheBizDataCodeAndBizItem.get(bizDataCode);
            if (bizItemIdSet == null) {
                bizItemIdSet = new HashSet<Long>(16);
            }
            bizItemIdSet.add(bizItemId);
            cacheBizDataCodeAndBizItem.put(bizDataCode, bizItemIdSet);
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(recurList.size());
        String operate = MapUtils.getString(param, (Object)"operate");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_recurbizdata");
        String opsystem = MapUtils.getString(param, (Object)"opsystem");
        if (recurList.size() > 0) {
            boolean isRecur = true;
            this.abandonOrDelBizData(helper, operate, recurList, resultList, opsystem, isRecur, cacheBizDataCodeAndBizItem, cacheOpReasonMap);
        }
        if (nonRecurList.size() > 0) {
            helper.setEntityName("hsas_nonrecurbizdata");
            boolean isRecur = false;
            this.abandonOrDelBizData(helper, operate, nonRecurList, resultList, opsystem, isRecur, cacheBizDataCodeAndBizItem, cacheOpReasonMap);
        }
        responseMap.put("success", Boolean.TRUE);
        responseMap.put("message", "ok");
        responseMap.put("result", resultList);
        this.log.info("delBizData result is :{}", (Object)String.valueOf(JSON.toJSON(responseMap)));
        return responseMap;
    }

    public Map<String, Object> queryUsageCount(Map<String, Object> params) {
        this.log.info("queryUsageCount params is :{}", (Object)String.valueOf(JSON.toJSON(params)));
        List dataMapList = (List)params.get("data");
        HashSet<Long> bizItemSet = new HashSet<Long>(16);
        for (Map bizdata : dataMapList) {
            Long bizItemId = MapUtils.getLong((Map)bizdata, (Object)"bizitemid");
            bizItemSet.add(bizItemId);
        }
        Map<Long, Boolean> bizItemMap = this.getBizItemMap(bizItemSet);
        ArrayList<String> recurList = new ArrayList<String>(10);
        ArrayList<String> nonRecurList = new ArrayList<String>(10);
        for (Map dataMap : dataMapList) {
            Long bizItem = MapUtils.getLong((Map)dataMap, (Object)"bizitemid");
            String identifynumber = MapUtils.getString((Map)dataMap, (Object)"bizdatacode");
            if (bizItemMap.get(bizItem).booleanValue()) {
                recurList.add(identifynumber);
                continue;
            }
            nonRecurList.add(identifynumber);
        }
        String opsystem = MapUtils.getString(params, (Object)"opsystem");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_recurbizdata");
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(recurList.size());
        if (recurList.size() > 0) {
            this.queryBizDataUsageCountAll(helper, recurList, resultList, opsystem);
        }
        if (nonRecurList.size() > 0) {
            helper.setEntityName("hsas_nonrecurbizdata");
            this.queryBizDataUsageCountAll(helper, nonRecurList, resultList, opsystem);
        }
        HashMap<String, Object> responseMap = new HashMap<String, Object>(3);
        responseMap.put("success", Boolean.TRUE);
        responseMap.put("message", "ok");
        responseMap.put("result", resultList);
        this.log.info("queryUsageCount result is :{}", (Object)String.valueOf(JSON.toJSON(responseMap)));
        return responseMap;
    }

    public Map<String, Object> queryUsagePeriod(Map<String, Object> params) {
        this.log.info("queryUsagePeriod params is :{}", (Object)String.valueOf(JSON.toJSON(params)));
        List dataMapList = (List)params.get("data");
        HashSet<Long> bizItemSet = new HashSet<Long>(16);
        for (Map bizdata : dataMapList) {
            Long bizItemId = MapUtils.getLong((Map)bizdata, (Object)"bizitemid");
            bizItemSet.add(bizItemId);
        }
        Map<Long, Boolean> bizItemMap = this.getBizItemMap(bizItemSet);
        ArrayList<String> recurList = new ArrayList<String>(10);
        ArrayList<String> nonRecurList = new ArrayList<String>(10);
        for (Map dataMap : dataMapList) {
            Long bizItem = MapUtils.getLong((Map)dataMap, (Object)"bizitemid");
            String identifynumber = MapUtils.getString((Map)dataMap, (Object)"bizdatacode");
            if (bizItemMap.get(bizItem).booleanValue()) {
                recurList.add(identifynumber);
                continue;
            }
            nonRecurList.add(identifynumber);
        }
        String opsystem = MapUtils.getString(params, (Object)"opsystem");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_recurbizdata");
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(recurList.size());
        if (recurList.size() > 0) {
            this.queryBizDataUsagePeriod(helper, recurList, resultList, opsystem, true);
        }
        if (nonRecurList.size() > 0) {
            helper.setEntityName("hsas_nonrecurbizdata");
            this.queryBizDataUsagePeriod(helper, nonRecurList, resultList, opsystem, false);
        }
        HashMap<String, Object> responseMap = new HashMap<String, Object>(3);
        responseMap.put("success", Boolean.TRUE);
        responseMap.put("message", "ok");
        responseMap.put("result", resultList);
        this.log.info("queryUsagePeriod result is :{}", (Object)String.valueOf(JSON.toJSON(responseMap)));
        return responseMap;
    }

    private void queryBizDataUsagePeriod(SWCDataServiceHelper helper, List<String> bizDataList, List<Map<String, Object>> resultList, String opsystem, boolean isRecur) {
        HashMap<String, Object> resltMap;
        DynamicObject[] bizDataColl = this.getBizDataColl(helper, bizDataList, opsystem, isRecur);
        HashMap<String, DynamicObject> identifynumBizdataMap = new HashMap<String, DynamicObject>(bizDataColl.length);
        ArrayList<Long> bizDataIdList = new ArrayList<Long>(bizDataColl.length);
        for (DynamicObject bizData : bizDataColl) {
            String identifyNum = bizData.getString("identifynumber");
            identifynumBizdataMap.put(identifyNum, bizData);
            bizDataIdList.add(bizData.getLong("id"));
        }
        if (identifynumBizdataMap == null || identifynumBizdataMap.size() <= 0) {
            for (String bizDataCode : bizDataList) {
                HashMap<String, Object> resltMap2 = new HashMap<String, Object>(4);
                resltMap2.put("bizdatacode", bizDataCode);
                resltMap2.put("usageperiod", -1);
                resltMap2.put("periodname", null);
                resltMap2.put("enddate", null);
                resultList.add(resltMap2);
            }
            return;
        }
        BizDataHelper bizDataHelper = new BizDataHelper();
        Map<Long, DynamicObject> calTaskBizDataRelMap = bizDataHelper.getCalPeriodAndBizDataRel(bizDataIdList, isRecur);
        if (calTaskBizDataRelMap == null || calTaskBizDataRelMap.size() <= 0) {
            for (String bizDataCode : bizDataList) {
                resltMap = new HashMap<String, Object>(4);
                resltMap.put("bizdatacode", bizDataCode);
                resltMap.put("usageperiod", null);
                resltMap.put("periodname", null);
                resltMap.put("enddate", null);
                resultList.add(resltMap);
            }
            return;
        }
        for (String bizDataCode : bizDataList) {
            resltMap = new HashMap(4);
            resltMap.put("bizdatacode", bizDataCode);
            if (!identifynumBizdataMap.containsKey(bizDataCode)) {
                resltMap.put("usageperiod", -1);
                resltMap.put("periodname", null);
                resltMap.put("enddate", null);
                resultList.add(resltMap);
                continue;
            }
            DynamicObject bizDataObj = (DynamicObject)identifynumBizdataMap.get(bizDataCode);
            Long bizDataId = bizDataObj.getLong("id");
            DynamicObject calPeriod = calTaskBizDataRelMap.get(bizDataId);
            if (!SWCObjectUtils.isEmpty((Object)calPeriod)) {
                resltMap.put("usageperiod", calPeriod.getLong("calperiod.id"));
                resltMap.put("periodname", calPeriod.getString("calperiod.name"));
                resltMap.put("enddate", calPeriod.getDate("calperiod.enddate"));
            }
            resultList.add(resltMap);
        }
    }

    private void queryBizDataUsageCountAll(SWCDataServiceHelper helper, List<String> bizDataList, List<Map<String, Object>> resultList, String opsystem) {
        Integer threshold = Integer.parseInt(System.getProperty("orm.opt.in.threshold", "2000"));
        if (bizDataList.size() >= threshold) {
            List partitionList = Lists.partition(bizDataList, (int)(threshold - 1));
            for (List subList : partitionList) {
                this.queryBizDataUsageCount(helper, subList, resultList, opsystem);
            }
        } else {
            this.queryBizDataUsageCount(helper, bizDataList, resultList, opsystem);
        }
    }

    private void queryBizDataUsageCount(SWCDataServiceHelper helper, List<String> bizDataList, List<Map<String, Object>> resultList, String opsystem) {
        DynamicObject[] bizDataColl = this.getBizDataColl(helper, bizDataList, opsystem, false);
        HashMap<String, List> identifynumBizdataMap = new HashMap<String, List>(bizDataColl.length);
        for (DynamicObject bizData2 : bizDataColl) {
            String identifynum = bizData2.getString("identifynumber");
            List subList = identifynumBizdataMap.getOrDefault(identifynum, new ArrayList());
            subList.add(bizData2);
            identifynumBizdataMap.put(identifynum, subList);
        }
        if (identifynumBizdataMap == null || identifynumBizdataMap.size() <= 0) {
            for (String bizDataCode : bizDataList) {
                HashMap<String, Object> resltMap = new HashMap<String, Object>(2);
                resltMap.put("bizdatacode", bizDataCode);
                resltMap.put("usagecount", -1);
                resultList.add(resltMap);
            }
            return;
        }
        HashSet<String> processedBizData = new HashSet<String>(bizDataList.size());
        for (String bizDataCode : bizDataList) {
            if (processedBizData.contains(bizDataCode)) continue;
            processedBizData.add(bizDataCode);
            HashMap<String, Object> resltMap = new HashMap<String, Object>(3);
            resltMap.put("bizdatacode", bizDataCode);
            if (!identifynumBizdataMap.containsKey(bizDataCode)) {
                resltMap.put("usagecount", -1);
                resultList.add(resltMap);
                continue;
            }
            List bizDataObjs = (List)identifynumBizdataMap.get(bizDataCode);
            int usageCount = bizDataObjs.stream().mapToInt(bizData -> bizData.getInt("usagecount")).sum();
            resltMap.put("usagecount", usageCount);
            resultList.add(resltMap);
        }
    }

    private void abandonOrDelBizData(SWCDataServiceHelper helper, String operate, List<String> bizDataList, List<Map<String, Object>> resultList, String opsystem, boolean isRecur, Map<String, Set<Long>> cacheBizDataCodeAndBizItem, Map<String, String> cacheOpReasonMap) {
        DynamicObject[] bizDataColl = this.getBizDataColl(helper, bizDataList, opsystem, isRecur);
        ArrayList<DynamicObject> filterBizDataList = new ArrayList<DynamicObject>(bizDataColl.length);
        for (DynamicObject bizDataObj : bizDataColl) {
            String identifyNumber = bizDataObj.getString("identifynumber");
            long bizItemId = bizDataObj.getLong("bizitem.id");
            Set<Long> cacheBizItemIdSet = cacheBizDataCodeAndBizItem.get(identifyNumber);
            if (cacheBizItemIdSet == null || !cacheBizItemIdSet.contains(bizItemId)) {
                HashMap<String, String> resltMap = new HashMap<String, String>(2);
                resltMap.put("status", "0");
                resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1022.getCode());
                resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1022.getDesc());
                resultList.add(resltMap);
                continue;
            }
            filterBizDataList.add(bizDataObj);
        }
        DynamicObject[] bizDataRecordColl = this.getBizDataRecordColl(bizDataList, opsystem);
        Map<Object, Object> identifynumBizDataRecordMap = new HashMap(16);
        if (null != bizDataRecordColl && bizDataRecordColl.length > 0) {
            identifynumBizDataRecordMap = Arrays.stream(bizDataRecordColl).collect(Collectors.toMap(dy -> dy.getString("identifynumber"), dy -> dy, (k1, k2) -> k1));
        }
        HashMap<String, List> identifynumBizdataMap = new HashMap<String, List>(filterBizDataList.size());
        List subList = null;
        for (DynamicObject bizData2 : filterBizDataList) {
            String identifynum = bizData2.getString("identifynumber");
            subList = identifynumBizdataMap.getOrDefault(identifynum, new ArrayList());
            subList.add(bizData2);
            identifynumBizdataMap.put(identifynum, subList);
        }
        HashSet<String> processedBizData = new HashSet<String>(bizDataList.size());
        ArrayList<DynamicObject> opBizDataRecordList = new ArrayList<DynamicObject>(identifynumBizDataRecordMap.size());
        ArrayList<DynamicObject> opBizDataList = new ArrayList<DynamicObject>(bizDataList.size());
        ArrayList<DynamicObject> delBizDataList = new ArrayList<DynamicObject>(bizDataList.size());
        ArrayList<DynamicObject> delBizDataRecordList = new ArrayList<DynamicObject>(bizDataList.size());
        ArrayList<DynamicObject> abandonBizDataList = new ArrayList<DynamicObject>(bizDataList.size());
        ArrayList<DynamicObject> abandonBizDataRecordList = new ArrayList<DynamicObject>(bizDataList.size());
        for (String bizDataCode : bizDataList) {
            String opReason;
            Object identifynumber;
            String opReason2;
            String identifynumber2;
            if (processedBizData.contains(bizDataCode)) continue;
            processedBizData.add(bizDataCode);
            HashMap<String, String> resltMap = new HashMap<String, String>(3);
            resltMap.put("bizdatacode", bizDataCode);
            if (!identifynumBizdataMap.containsKey(bizDataCode)) {
                resltMap.put("status", "0");
                resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1020.getCode());
                resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1020.getDesc());
                resultList.add(resltMap);
                continue;
            }
            List bizDataObjs = (List)identifynumBizdataMap.get(bizDataCode);
            int usageCount = bizDataObjs.stream().mapToInt(bizData -> bizData.getInt("usagecount")).sum();
            int noCountTimes = bizDataObjs.stream().mapToInt(bizData -> bizData.getInt("nocounttimes")).sum();
            usageCount += noCountTimes;
            DynamicObject bizDataRecord = (DynamicObject)identifynumBizDataRecordMap.get(bizDataCode);
            if (SWCStringUtils.equals((String)operate, (String)"E")) {
                if (!this.isAllAuditPassStatus(bizDataObjs)) {
                    resltMap.put("status", "0");
                    resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1041.getCode());
                    resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1041.getDesc());
                    resultList.add(resltMap);
                    continue;
                }
                for (DynamicObject bizDataObj : bizDataObjs) {
                    bizDataObj.set("auditstatus", (Object)"F");
                    bizDataObj.set("opsystem", (Object)opsystem);
                    identifynumber2 = bizDataObj.getString("identifynumber");
                    opReason2 = cacheOpReasonMap.get(identifynumber2);
                    if (!SWCStringUtils.isNotEmpty((String)opReason2)) continue;
                    bizDataObj.set("opreason", (Object)opReason2);
                }
                if (Objects.nonNull(bizDataRecord)) {
                    bizDataRecord.set("auditstatus", (Object)"F");
                    bizDataRecord.set("opsystem", (Object)opsystem);
                    identifynumber = bizDataRecord.getString("identifynumber");
                    opReason = cacheOpReasonMap.get(identifynumber);
                    if (SWCStringUtils.isNotEmpty((String)opReason)) {
                        bizDataRecord.set("opreason", (Object)opReason);
                    }
                }
            } else if (SWCStringUtils.equals((String)operate, (String)"LD")) {
                if (this.checkBsedUpdateTimes(isRecur, bizDataObjs, bizDataRecord)) {
                    resltMap.put("status", "0");
                    resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1110.getCode());
                    resultList.add(resltMap);
                    continue;
                }
                if (usageCount > 0) {
                    resltMap.put("status", "0");
                    resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1050.getCode());
                    resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1050.getDesc());
                    resultList.add(resltMap);
                    continue;
                }
                if (!this.isAllAuditPassStatus(bizDataObjs)) {
                    resltMap.put("status", "0");
                    resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1041.getCode());
                    resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1041.getDesc());
                    resultList.add(resltMap);
                    continue;
                }
            } else if (SWCStringUtils.equals((String)operate, (String)"LDE")) {
                if (usageCount > 0) {
                    if (!this.isAllAuditPassStatus(bizDataObjs)) {
                        resltMap.put("status", "0");
                        resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1041.getCode());
                        resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1041.getDesc());
                        resltMap.put("operate", "E");
                        resultList.add(resltMap);
                        continue;
                    }
                    for (DynamicObject bizDataObj : bizDataObjs) {
                        bizDataObj.set("auditstatus", (Object)"F");
                        bizDataObj.set("opsystem", (Object)opsystem);
                        identifynumber2 = bizDataObj.getString("identifynumber");
                        opReason2 = cacheOpReasonMap.get(identifynumber2);
                        if (!SWCStringUtils.isNotEmpty((String)opReason2)) continue;
                        bizDataObj.set("opreason", (Object)opReason2);
                    }
                    if (Objects.nonNull(bizDataRecord)) {
                        bizDataRecord.set("auditstatus", (Object)"F");
                        bizDataRecord.set("opsystem", (Object)opsystem);
                        identifynumber = bizDataRecord.getString("identifynumber");
                        opReason = cacheOpReasonMap.get(identifynumber);
                        if (SWCStringUtils.isNotEmpty((String)opReason)) {
                            bizDataRecord.set("opreason", (Object)opReason);
                        }
                    }
                    abandonBizDataList.addAll(bizDataObjs);
                    if (Objects.nonNull(bizDataRecord)) {
                        abandonBizDataRecordList.add(bizDataRecord);
                    }
                } else {
                    if (this.checkBsedUpdateTimes(isRecur, bizDataObjs, bizDataRecord)) {
                        resltMap.put("status", "0");
                        resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1041.getCode());
                        resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1041.getDesc());
                        resultList.add(resltMap);
                        continue;
                    }
                    if (!this.isAllAuditPassStatus(bizDataObjs)) {
                        resltMap.put("status", "0");
                        resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1041.getCode());
                        resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1041.getDesc());
                        resltMap.put("operate", "LD");
                        resultList.add(resltMap);
                        continue;
                    }
                    delBizDataList.addAll(bizDataObjs);
                    if (Objects.nonNull(bizDataRecord)) {
                        delBizDataRecordList.add(bizDataRecord);
                    }
                }
            }
            opBizDataList.addAll(bizDataObjs);
            if (!Objects.nonNull(bizDataRecord)) continue;
            opBizDataRecordList.add(bizDataRecord);
        }
        if (isRecur) {
            this.recurBizDataDelOrAbandon(opBizDataList, operate, helper, opBizDataRecordList, delBizDataList, delBizDataRecordList, abandonBizDataList, abandonBizDataRecordList, resultList);
        } else {
            this.nonRecurBizDataDelOrAbandon(opBizDataList, operate, helper, opBizDataRecordList, delBizDataList, delBizDataRecordList, abandonBizDataList, abandonBizDataRecordList, resultList);
        }
    }

    private boolean checkBsedUpdateTimes(boolean isRecur, List<DynamicObject> bizDataObjs, DynamicObject bizDataRecord) {
        if (!isRecur) {
            int updateTimes = 0;
            updateTimes = Objects.nonNull(bizDataRecord) ? bizDataRecord.getInt("updatetimes") : bizDataObjs.get(0).getInt("updatetimes");
            if (updateTimes > 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recurBizDataDelOrAbandon(List<DynamicObject> opBizDataList, String operate, SWCDataServiceHelper helper, List<DynamicObject> opBizDataRecordList, List<DynamicObject> delBizDataList, List<DynamicObject> delBizDataRecordList, List<DynamicObject> abandonBizDataList, List<DynamicObject> abandonBizDataRecordList, List<Map<String, Object>> resultList) {
        block51: {
            String statusFlag = "";
            String code = null;
            String errorMsg = null;
            ArrayList<DynamicObject> filterDelBizDataList = new ArrayList<DynamicObject>(10);
            ArrayList<DynamicObject> filterAbandonBizDataList = new ArrayList<DynamicObject>(10);
            HashSet<String> filterBizDataSet = new HashSet<String>(16);
            SWCDataServiceHelper recordHelper = new SWCDataServiceHelper("hsas_bizdatarecord");
            TXHandle txHandle = TX.requiresNew();
            try {
                Object dataPks;
                this.log.info("abandonOrDelBizData opBizDataList size is:{}", (Object)opBizDataList.size());
                if (opBizDataList.size() <= 0) {
                    return;
                }
                Iterator cacheBizDataInfoMap = new HashMap<Long, DynamicObject>(opBizDataList.size());
                for (DynamicObject bizDataObj : opBizDataList) {
                    cacheBizDataInfoMap.put(bizDataObj.getLong("id"), bizDataObj);
                }
                HashMap<Long, String> cacheBizDataMap = new HashMap<Long, String>(16);
                ArrayList<DynamicObject> otherBizDataList = new ArrayList<DynamicObject>(10);
                List<Map<String, Object>> personChangeList = this.getPersonChangeInfo(opBizDataList, cacheBizDataMap, otherBizDataList);
                if (personChangeList.size() > 0) {
                    PersonChangeService personChangeService = new PersonChangeService();
                    Map<String, Object> map = personChangeService.abandonPersonChange("2", personChangeList);
                    Boolean successFlag = (Boolean)map.get("success");
                    if (successFlag != null && !successFlag.booleanValue()) {
                        for (Map.Entry entry : cacheBizDataMap.entrySet()) {
                            HashMap<String, String> resltMap = new HashMap<String, String>(5);
                            resltMap.put("status", "0");
                            resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1101.getCode());
                            resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1101.getDesc());
                            resltMap.put("bizdatacode", (String)entry.getValue());
                            resultList.add(resltMap);
                        }
                    } else if (successFlag != null && successFlag.booleanValue()) {
                        List detailResultList = (List)map.get("result");
                        if (detailResultList == null || detailResultList.size() == 0) {
                            for (Map.Entry entry : cacheBizDataMap.entrySet()) {
                                HashMap<String, String> resltMap = new HashMap<String, String>(5);
                                resltMap.put("status", "0");
                                resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1101.getCode());
                                resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1101.getDesc());
                                resltMap.put("bizdatacode", (String)entry.getValue());
                                resultList.add(resltMap);
                            }
                        } else {
                            for (Map detailResultMap : detailResultList) {
                                Long bizDataId;
                                Boolean detailSuccessFlag = (Boolean)detailResultMap.get("success");
                                if (detailSuccessFlag != null && !detailSuccessFlag.booleanValue()) {
                                    bizDataId = (Long)detailResultMap.get("bizDataId");
                                    HashMap<String, String> resltMap = new HashMap<String, String>(5);
                                    resltMap.put("status", "0");
                                    resltMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1101.getCode());
                                    resltMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1101.getDesc());
                                    resltMap.put("bizdatacode", (String)cacheBizDataMap.get(bizDataId));
                                    resultList.add(resltMap);
                                    continue;
                                }
                                if (detailSuccessFlag == null || !detailSuccessFlag.booleanValue() || cacheBizDataInfoMap.get(bizDataId = (Long)detailResultMap.get("bizDataId")) == null) continue;
                                otherBizDataList.add((DynamicObject)cacheBizDataInfoMap.get(bizDataId));
                            }
                        }
                    }
                }
                for (Map map : resultList) {
                    filterBizDataSet.add((String)map.get("bizdatacode"));
                }
                if (SWCStringUtils.equals((String)operate, (String)"E")) {
                    if (otherBizDataList.size() > 0) {
                        helper.update(otherBizDataList.toArray(new DynamicObject[otherBizDataList.size()]));
                    }
                    if (CollectionUtils.isNotEmpty(opBizDataRecordList)) {
                        recordHelper.update(opBizDataRecordList.toArray(new DynamicObject[opBizDataRecordList.size()]));
                    }
                } else if (SWCStringUtils.equals((String)operate, (String)"LD")) {
                    this.log.info("abandonOrDelBizData operate is LD");
                    dataPks = otherBizDataList.stream().map(bizData -> bizData.getLong("id")).toArray();
                    this.log.info("abandonOrDelBizData prepare delete dataPks");
                    helper.delete((Object[])dataPks);
                    this.log.info("abandonOrDelBizData  opBizDataRecordList size is:{}", (Object)opBizDataRecordList.size());
                    if (CollectionUtils.isNotEmpty(opBizDataRecordList)) {
                        Object[] objectArray = opBizDataRecordList.stream().map(record -> record.getLong("id")).toArray();
                        this.log.info("abandonOrDelBizData prepare delete recordPks");
                        recordHelper.delete(objectArray);
                    }
                } else if (SWCStringUtils.equals((String)operate, (String)"LDE")) {
                    String identifyNum;
                    if (delBizDataList.size() > 0) {
                        for (DynamicObject dynamicObject : delBizDataList) {
                            identifyNum = dynamicObject.getString("identifynumber");
                            if (filterBizDataSet.contains(identifyNum)) continue;
                            filterDelBizDataList.add(dynamicObject);
                        }
                        if (filterDelBizDataList.size() > 0) {
                            this.log.info("delBizData operate is LDE");
                            dataPks = filterDelBizDataList.stream().map(bizData -> bizData.getLong("id")).toArray();
                            this.log.info("delBizData prepare delete dataPks LDE");
                            helper.delete((Object[])dataPks);
                        }
                    }
                    if (delBizDataRecordList.size() > 0) {
                        Object[] recordPks = delBizDataRecordList.stream().map(record -> record.getLong("id")).toArray();
                        this.log.info("delBizData prepare delete recordPks LDE");
                        recordHelper.delete(recordPks);
                    }
                    if (abandonBizDataList.size() > 0) {
                        for (DynamicObject dynamicObject : abandonBizDataList) {
                            identifyNum = dynamicObject.getString("identifynumber");
                            if (filterBizDataSet.contains(identifyNum)) continue;
                            filterAbandonBizDataList.add(dynamicObject);
                        }
                        if (filterAbandonBizDataList.size() > 0) {
                            helper.update(filterAbandonBizDataList.toArray(new DynamicObject[filterAbandonBizDataList.size()]));
                        }
                    }
                    if (abandonBizDataRecordList.size() > 0) {
                        recordHelper.update(abandonBizDataRecordList.toArray(new DynamicObject[abandonBizDataRecordList.size()]));
                    }
                }
                statusFlag = "1";
                code = null;
            }
            catch (Exception e) {
                statusFlag = "0";
                code = BizDataFailStatusEnum.FAILSTATUS_2020.getCode();
                errorMsg = BizDataFailStatusEnum.FAILSTATUS_2020.getDesc();
                this.log.error("abandonOrDelBizData() error :", (Throwable)e);
                txHandle.markRollback();
                break block51;
            }
            finally {
                if (SWCStringUtils.equals((String)operate, (String)"E") || SWCStringUtils.equals((String)operate, (String)"LD")) {
                    for (DynamicObject opBizData : opBizDataList) {
                        String bizdatacode = opBizData.getString("identifynumber");
                        if (filterBizDataSet.contains(bizdatacode)) continue;
                        HashMap<String, String> resltMap = new HashMap<String, String>(3);
                        resltMap.put("bizdatacode", bizdatacode);
                        resltMap.put("status", statusFlag);
                        resltMap.put("errorcode", code);
                        resltMap.put("errormsg", errorMsg);
                        resultList.add(resltMap);
                    }
                } else if (SWCStringUtils.equals((String)operate, (String)"LDE")) {
                    HashMap<String, String> resltMap;
                    if (filterDelBizDataList.size() > 0) {
                        for (DynamicObject delBizData : filterDelBizDataList) {
                            resltMap = new HashMap<String, String>(4);
                            resltMap.put("bizdatacode", delBizData.getString("identifynumber"));
                            resltMap.put("status", statusFlag);
                            resltMap.put("errorcode", code);
                            resltMap.put("errormsg", errorMsg);
                            resltMap.put("operate", "LD");
                            resultList.add(resltMap);
                        }
                    }
                    if (filterAbandonBizDataList.size() > 0) {
                        for (DynamicObject abandonBizData : filterAbandonBizDataList) {
                            resltMap = new HashMap(4);
                            resltMap.put("bizdatacode", abandonBizData.getString("identifynumber"));
                            resltMap.put("status", statusFlag);
                            resltMap.put("errorcode", code);
                            resltMap.put("errormsg", errorMsg);
                            resltMap.put("operate", "E");
                            resultList.add(resltMap);
                        }
                    }
                }
                txHandle.close();
            }
            if (SWCStringUtils.equals((String)operate, (String)"E") || SWCStringUtils.equals((String)operate, (String)"LD")) {
                for (DynamicObject opBizData : opBizDataList) {
                    String bizdatacode = opBizData.getString("identifynumber");
                    if (filterBizDataSet.contains(bizdatacode)) continue;
                    HashMap<String, String> resltMap = new HashMap<String, String>(3);
                    resltMap.put("bizdatacode", bizdatacode);
                    resltMap.put("status", statusFlag);
                    resltMap.put("errorcode", code);
                    resltMap.put("errormsg", errorMsg);
                    resultList.add(resltMap);
                }
            } else if (SWCStringUtils.equals((String)operate, (String)"LDE")) {
                HashMap<String, String> resltMap;
                if (filterDelBizDataList.size() > 0) {
                    for (DynamicObject delBizData : filterDelBizDataList) {
                        resltMap = new HashMap<String, String>(4);
                        resltMap.put("bizdatacode", delBizData.getString("identifynumber"));
                        resltMap.put("status", statusFlag);
                        resltMap.put("errorcode", code);
                        resltMap.put("errormsg", errorMsg);
                        resltMap.put("operate", "LD");
                        resultList.add(resltMap);
                    }
                }
                if (filterAbandonBizDataList.size() > 0) {
                    for (DynamicObject abandonBizData : filterAbandonBizDataList) {
                        resltMap = new HashMap(4);
                        resltMap.put("bizdatacode", abandonBizData.getString("identifynumber"));
                        resltMap.put("status", statusFlag);
                        resltMap.put("errorcode", code);
                        resltMap.put("errormsg", errorMsg);
                        resltMap.put("operate", "E");
                        resultList.add(resltMap);
                    }
                }
            }
            txHandle.close();
        }
    }

    private List<Map<String, Object>> getPersonChangeInfo(List<DynamicObject> opBizDataList, Map<Long, String> cacheBizDataMap, List<DynamicObject> otherBizDataList) {
        ArrayList<Map<String, Object>> personChangeList = new ArrayList<Map<String, Object>>(opBizDataList.size());
        for (DynamicObject bizDataObj : opBizDataList) {
            long bizDataId = bizDataObj.getLong("id");
            String identifyNum = bizDataObj.getString("identifynumber");
            cacheBizDataMap.put(bizDataId, identifyNum);
            long salaryadjustrsn = bizDataObj.getLong("salaryadjustrsn.id");
            long action = bizDataObj.getLong("action.id");
            if (salaryadjustrsn != 0L || action != 0L) {
                HashMap<String, Number> personChangeMap = new HashMap<String, Number>(3);
                personChangeMap.put("bizDataId", bizDataId);
                personChangeMap.put("cycle", 1);
                personChangeList.add(personChangeMap);
                continue;
            }
            otherBizDataList.add(bizDataObj);
        }
        return personChangeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nonRecurBizDataDelOrAbandon(List<DynamicObject> opBizDataList, String operate, SWCDataServiceHelper helper, List<DynamicObject> opBizDataRecordList, List<DynamicObject> delBizDataList, List<DynamicObject> delBizDataRecordList, List<DynamicObject> abandonBizDataList, List<DynamicObject> abandonBizDataRecordList, List<Map<String, Object>> resultList) {
        block31: {
            TXHandle txHandle;
            block32: {
                HashMap<String, String> resltMap;
                String errorMsg;
                String code;
                String statusFlag;
                block29: {
                    block30: {
                        statusFlag = "";
                        code = null;
                        errorMsg = null;
                        txHandle = TX.requiresNew();
                        try {
                            Object[] dataPks;
                            this.log.info("abandonOrDelBizData opBizDataList size is:{}", (Object)opBizDataList.size());
                            if (opBizDataList.size() <= 0) {
                                return;
                            }
                            SWCDataServiceHelper recordHelper = new SWCDataServiceHelper("hsas_bizdatarecord");
                            if (SWCStringUtils.equals((String)operate, (String)"E")) {
                                helper.update(opBizDataList.toArray(new DynamicObject[opBizDataList.size()]));
                                if (CollectionUtils.isNotEmpty(opBizDataRecordList)) {
                                    recordHelper.update(opBizDataRecordList.toArray(new DynamicObject[opBizDataRecordList.size()]));
                                }
                            } else if (SWCStringUtils.equals((String)operate, (String)"LD")) {
                                this.log.info("abandonOrDelBizData operate is LD");
                                dataPks = opBizDataList.stream().map(bizData -> bizData.getLong("id")).toArray();
                                this.log.info("abandonOrDelBizData prepare delete dataPks");
                                helper.delete(dataPks);
                                this.log.info("abandonOrDelBizData  opBizDataRecordList size is:{}", (Object)opBizDataRecordList.size());
                                if (CollectionUtils.isNotEmpty(opBizDataRecordList)) {
                                    Object[] recordPks = opBizDataRecordList.stream().map(record -> record.getLong("id")).toArray();
                                    this.log.info("abandonOrDelBizData prepare delete recordPks");
                                    recordHelper.delete(recordPks);
                                }
                            } else if (SWCStringUtils.equals((String)operate, (String)"LDE")) {
                                if (delBizDataList.size() > 0) {
                                    this.log.info("delBizData operate is LDE");
                                    dataPks = delBizDataList.stream().map(bizData -> bizData.getLong("id")).toArray();
                                    this.log.info("delBizData prepare delete dataPks LDE");
                                    helper.delete(dataPks);
                                }
                                if (delBizDataRecordList.size() > 0) {
                                    Object[] recordPks = delBizDataRecordList.stream().map(record -> record.getLong("id")).toArray();
                                    this.log.info("delBizData prepare delete recordPks LDE");
                                    recordHelper.delete(recordPks);
                                }
                                if (abandonBizDataList.size() > 0) {
                                    helper.update(abandonBizDataList.toArray(new DynamicObject[abandonBizDataList.size()]));
                                }
                                if (abandonBizDataRecordList.size() > 0) {
                                    recordHelper.update(abandonBizDataRecordList.toArray(new DynamicObject[abandonBizDataRecordList.size()]));
                                }
                            }
                            statusFlag = "1";
                            code = null;
                            if (!SWCStringUtils.equals((String)operate, (String)"LDE")) break block29;
                            if (delBizDataList.size() <= 0) break block30;
                        }
                        catch (Exception e) {
                            statusFlag = "0";
                            code = BizDataFailStatusEnum.FAILSTATUS_2020.getCode();
                            errorMsg = BizDataFailStatusEnum.FAILSTATUS_2020.getDesc();
                            this.log.error("abandonOrDelBizData() error:", (Throwable)e);
                            txHandle.markRollback();
                            break block31;
                        }
                        finally {
                            if (SWCStringUtils.equals((String)operate, (String)"LDE")) {
                                HashMap<String, String> resltMap2;
                                if (delBizDataList.size() > 0) {
                                    for (DynamicObject delBizData : delBizDataList) {
                                        resltMap2 = new HashMap<String, String>(4);
                                        resltMap2.put("bizdatacode", delBizData.getString("identifynumber"));
                                        resltMap2.put("status", statusFlag);
                                        resltMap2.put("errorcode", code);
                                        resltMap2.put("errormsg", errorMsg);
                                        resltMap2.put("operate", "LD");
                                        resultList.add(resltMap2);
                                    }
                                }
                                if (abandonBizDataList.size() > 0) {
                                    for (DynamicObject abandonBizData : abandonBizDataList) {
                                        resltMap2 = new HashMap(4);
                                        resltMap2.put("bizdatacode", abandonBizData.getString("identifynumber"));
                                        resltMap2.put("status", statusFlag);
                                        resltMap2.put("errorcode", code);
                                        resltMap2.put("errormsg", errorMsg);
                                        resltMap2.put("operate", "E");
                                        resultList.add(resltMap2);
                                    }
                                }
                            } else {
                                for (DynamicObject opBizData : opBizDataList) {
                                    HashMap<String, String> resltMap3 = new HashMap<String, String>(3);
                                    resltMap3.put("bizdatacode", opBizData.getString("identifynumber"));
                                    resltMap3.put("status", statusFlag);
                                    resltMap3.put("errorcode", code);
                                    resltMap3.put("errormsg", errorMsg);
                                    resultList.add(resltMap3);
                                }
                            }
                            txHandle.close();
                        }
                        for (DynamicObject delBizData : delBizDataList) {
                            resltMap = new HashMap(4);
                            resltMap.put("bizdatacode", delBizData.getString("identifynumber"));
                            resltMap.put("status", statusFlag);
                            resltMap.put("errorcode", code);
                            resltMap.put("errormsg", errorMsg);
                            resltMap.put("operate", "LD");
                            resultList.add(resltMap);
                        }
                    }
                    if (abandonBizDataList.size() > 0) {
                        for (DynamicObject abandonBizData : abandonBizDataList) {
                            resltMap = new HashMap(4);
                            resltMap.put("bizdatacode", abandonBizData.getString("identifynumber"));
                            resltMap.put("status", statusFlag);
                            resltMap.put("errorcode", code);
                            resltMap.put("errormsg", errorMsg);
                            resltMap.put("operate", "E");
                            resultList.add(resltMap);
                        }
                    }
                    break block32;
                }
                for (DynamicObject opBizData : opBizDataList) {
                    resltMap = new HashMap<String, String>(3);
                    resltMap.put("bizdatacode", opBizData.getString("identifynumber"));
                    resltMap.put("status", statusFlag);
                    resltMap.put("errorcode", code);
                    resltMap.put("errormsg", errorMsg);
                    resultList.add(resltMap);
                }
            }
            txHandle.close();
        }
    }

    private boolean isAllAuditPassStatus(List<DynamicObject> bizDataObjs) {
        for (DynamicObject bizDataObj : bizDataObjs) {
            String status = bizDataObj.getString("auditstatus");
            if (SWCStringUtils.equals((String)status, (String)"C")) continue;
            return false;
        }
        return true;
    }

    private Boolean checkBizDataMustInput(String operate, Map<String, Object> bizDataMap, boolean bySalaryFile) {
        List propDataList;
        Boolean flag = Boolean.TRUE;
        StringBuilder stringBuilder = new StringBuilder();
        if (SWCStringUtils.isEmpty((String)MapUtils.getString(bizDataMap, (Object)"bizdatacode"))) {
            flag = Boolean.FALSE;
            stringBuilder.append(ResManager.loadKDString((String)"\u3010\u524d\u7aef\u4e1a\u52a1\u6570\u636e\u552f\u4e00\u8bc6\u522b\u7801\u3011", (String)"BizDataServiceHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]));
        }
        if (SWCStringUtils.isEmpty((String)MapUtils.getString(bizDataMap, (Object)"batchcode"))) {
            flag = Boolean.FALSE;
            stringBuilder.append(ResManager.loadKDString((String)"\u3010\u6279\u6b21\u53f7\u3011", (String)"BizDataServiceHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]));
        }
        if (bySalaryFile) {
            if (SWCObjectUtils.isEmpty((Object)MapUtils.getLong(bizDataMap, (Object)"salaryfileid"))) {
                flag = Boolean.FALSE;
                stringBuilder.append(ResManager.loadKDString((String)"\u3010\u85aa\u8d44\u6863\u6848\u3011", (String)"BizDataServiceHelper_10", (String)"swc-hsas-business", (Object[])new Object[0]));
            }
        } else {
            if (SWCObjectUtils.isEmpty((Object)MapUtils.getLong(bizDataMap, (Object)"depempid"))) {
                flag = Boolean.FALSE;
                stringBuilder.append(ResManager.loadKDString((String)"\u3010\u7ec4\u7ec7\u4eba\u3011", (String)"BizDataServiceHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]));
            }
            if (SWCObjectUtils.isEmpty((Object)MapUtils.getLong(bizDataMap, (Object)"employeeid"))) {
                flag = Boolean.FALSE;
                stringBuilder.append(ResManager.loadKDString((String)"\u3010\u4f01\u4e1a\u4eba\u3011", (String)"BizDataServiceHelper_9", (String)"swc-hsas-business", (Object[])new Object[0]));
            }
        }
        if (SWCObjectUtils.isEmpty((Object)MapUtils.getLong(bizDataMap, (Object)"bizitemid"))) {
            flag = Boolean.FALSE;
            stringBuilder.append(ResManager.loadKDString((String)"\u3010\u4e1a\u52a1\u9879\u76ee\u3011", (String)"BizDataServiceHelper_6", (String)"swc-hsas-business", (Object[])new Object[0]));
        }
        if (SWCStringUtils.isEmpty((String)MapUtils.getString(bizDataMap, (Object)"value"))) {
            flag = Boolean.FALSE;
            stringBuilder.append(ResManager.loadKDString((String)"\u3010\u503c\u3011", (String)"BizDataServiceHelper_7", (String)"swc-hsas-business", (Object[])new Object[0]));
        }
        if (SWCObjectUtils.isEmpty((Object)bizDataMap.get("bsed"))) {
            flag = Boolean.FALSE;
            stringBuilder.append(ResManager.loadKDString((String)"\u3010\u751f\u6548\u65e5\u671f\u3011", (String)"BizDataServiceHelper_8", (String)"swc-hsas-business", (Object[])new Object[0]));
        }
        if (SWCStringUtils.equals((String)operate, (String)"1")) {
            if (SWCStringUtils.isEmpty((String)MapUtils.getString(bizDataMap, (Object)"datasources"))) {
                flag = Boolean.FALSE;
                stringBuilder.append(ResManager.loadKDString((String)"\u3010\u6570\u636e\u6765\u6e90\u3011", (String)"BizDataServiceHelper_4", (String)"swc-hsas-business", (Object[])new Object[0]));
            }
            if (SWCStringUtils.isEmpty((String)MapUtils.getString(bizDataMap, (Object)"srcsystem"))) {
                flag = Boolean.FALSE;
                stringBuilder.append(ResManager.loadKDString((String)"\u3010\u524d\u7aef\u7cfb\u7edf\u3011", (String)"BizDataServiceHelper_5", (String)"swc-hsas-business", (Object[])new Object[0]));
            }
        }
        if ((propDataList = (List)bizDataMap.get("propdatalist")) != null && propDataList.size() > 0) {
            boolean isNeedBreak = false;
            for (Map propDataMap : propDataList) {
                if (SWCObjectUtils.isEmpty((Object)MapUtils.getLong((Map)propDataMap, (Object)"bizitempropid"))) {
                    flag = Boolean.FALSE;
                    stringBuilder.append(ResManager.loadKDString((String)"\u3010\u4e1a\u52a1\u9879\u76ee\u5c5e\u6027\u3011", (String)"BizDataServiceHelper_11", (String)"swc-hsas-business", (Object[])new Object[0]));
                    isNeedBreak = true;
                }
                if (SWCStringUtils.isEmpty((String)MapUtils.getString((Map)propDataMap, (Object)"propvalue"))) {
                    flag = Boolean.FALSE;
                    stringBuilder.append(ResManager.loadKDString((String)"\u3010\u4e1a\u52a1\u9879\u76ee\u5c5e\u6027\u503c\u3011", (String)"BizDataServiceHelper_12", (String)"swc-hsas-business", (Object[])new Object[0]));
                    isNeedBreak = true;
                }
                if (!isNeedBreak) continue;
                break;
            }
        }
        if (!flag.booleanValue()) {
            this.log.info("must input verification failed, bizDataCode : {}", (Object)new StringBuilder(MapUtils.getString(bizDataMap, (Object)"bizdatacode")).append((CharSequence)stringBuilder).append(" is empty!"));
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getBizDataList(SWCDataServiceHelper helper, List<Map<String, Object>> bizDataMapList, List<Map<String, Object>> dataRsList, String operate, String opsystem, Boolean isRecur, Set<String> errorIdentifyNums, Map<Long, DynamicObject> bizItemPropMap, Map<Long, Set<Long>> cacheDepempAndSalaryFileRelMap) {
        List<Object> bizDataList = new ArrayList(bizDataMapList.size());
        long[] bizDataIds = null;
        bizDataIds = isRecur != false ? DB.genLongIds((String)"hsas_recurbizdata", (int)bizDataMapList.size()) : DB.genLongIds((String)"hsas_nonrecurbizdata", (int)bizDataMapList.size());
        ArrayList<String> bizDataCodes = new ArrayList<String>(10);
        HashSet<Long> salaryFileIds = new HashSet<Long>(bizDataMapList.size());
        HashSet<Long> bizItemIds = new HashSet<Long>(bizDataMapList.size());
        HashSet<Long> needDepempUpdateSalaryFileSet = new HashSet<Long>(bizDataMapList.size());
        BizDataHelper bizDataHelper = new BizDataHelper();
        for (Map<String, Object> bizDataMap : bizDataMapList) {
            Set<Long> allSalaryFileIdSet;
            Long depempid;
            String identifynumber = MapUtils.getString(bizDataMap, (Object)"bizdatacode");
            bizDataCodes.add(identifynumber);
            Long salaryFileId = MapUtils.getLong(bizDataMap, (Object)"salaryfileid");
            salaryFileIds.add(salaryFileId);
            Object[] bizItemId = MapUtils.getLong(bizDataMap, (Object)"bizitemid");
            bizItemIds.add((Long)bizItemId);
            if (!isRecur.booleanValue() || cacheDepempAndSalaryFileRelMap == null || cacheDepempAndSalaryFileRelMap.size() == 0 || (depempid = MapUtils.getLong(bizDataMap, (Object)"depempid")) == null || (allSalaryFileIdSet = cacheDepempAndSalaryFileRelMap.get(depempid)) == null || allSalaryFileIdSet.size() == 0) continue;
            salaryFileIds.addAll(allSalaryFileIdSet);
            String string = MapUtils.getString(bizDataMap, (Object)"datasources");
            if (!SWCStringUtils.equals((String)opsystem, (String)"hpdi") || !SWCStringUtils.equals((String)string, (String)"3")) continue;
            needDepempUpdateSalaryFileSet.addAll(allSalaryFileIdSet);
        }
        Table<Long, Long, List<DynamicObject>> recurBizData = null;
        if (isRecur.booleanValue()) {
            recurBizData = bizDataHelper.getRecurBizData(salaryFileIds, bizItemIds);
        }
        Map<Long, DynamicObject> salaryFileDataMap = this.getSalaryFileData(salaryFileIds);
        Object[] bizDataColl = this.getBizDataColl(helper, bizDataCodes, opsystem, false);
        HashMap<String, DynamicObject> identifynumBizdataMap = new HashMap<String, DynamicObject>(bizDataColl.length);
        for (DynamicObject dynamicObject : bizDataColl) {
            String identifynum = dynamicObject.getString("identifynumber");
            identifynumBizdataMap.put(identifynum, dynamicObject);
        }
        ArrayList<DynamicObject> allUpdateBsledList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> bizDataBsledRecordList = new ArrayList<DynamicObject>(10);
        ArrayList needPushHpdiDataList = new ArrayList(10);
        ArrayList<BizDataModifyRecEntity> arrayList = new ArrayList<BizDataModifyRecEntity>(10);
        HashMap<String, Date> bizDataBsledDateMap = new HashMap<String, Date>(16);
        SWCDataServiceHelper bsledRecordHelper = new SWCDataServiceHelper("hsas_bizdatabsledrecord");
        this.log.info("bizDataMapList size is:{}", (Object)bizDataMapList.size());
        ArrayList personChangeInfoList = new ArrayList(10);
        int bizDataIdIndex = 0;
        for (Map<String, Object> bizDataMap : bizDataMapList) {
            DynamicObject salaryFileObj;
            Date bsled;
            String identifyNum = MapUtils.getString(bizDataMap, (Object)"bizdatacode");
            if (errorIdentifyNums.contains(identifyNum)) continue;
            Date bsed = (Date)bizDataMap.get("bsed");
            if (bsed != null) {
                try {
                    bsed = SWCDateTimeUtils.formatDateToDate((Date)bsed, (String)"yyyy-MM-dd");
                    bizDataMap.put("bsed", bsed);
                }
                catch (ParseException e) {
                    this.log.info("getBizDataList bsed formatDateToDate error!");
                }
            }
            if ((bsled = (Date)bizDataMap.get("bsled")) != null) {
                try {
                    bsled = SWCDateTimeUtils.formatDateToDate((Date)bsled, (String)"yyyy-MM-dd");
                    bizDataMap.put("bsled", bsled);
                }
                catch (ParseException e) {
                    this.log.info("getBizDataList bsled formatDateToDate error!");
                }
            }
            Long salaryFileId = MapUtils.getLong(bizDataMap, (Object)"salaryfileid");
            Long bizItemGroupId = MapUtils.getLong(bizDataMap, (Object)"bizdataaccesstplid");
            String string = MapUtils.getString(bizDataMap, (Object)"batchcode");
            Long bizItemId = MapUtils.getLong(bizDataMap, (Object)"bizitemid");
            Long bizDataRecordId = MapUtils.getLong(bizDataMap, (Object)"bizdatarecord");
            List propdatalist = (List)bizDataMap.get("propdatalist");
            HashMap<String, Object> rsMap = new HashMap<String, Object>(16);
            rsMap.put("bizdatacode", identifyNum);
            rsMap.put("salaryfileid", salaryFileId);
            if (bsed != null && bsled != null && bsed.getTime() > bsled.getTime()) {
                rsMap.put("status", "0");
                rsMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1060.getCode());
                rsMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1060.getDesc());
                dataRsList.add(rsMap);
                errorIdentifyNums.add(identifyNum);
                continue;
            }
            if (SWCStringUtils.equals((String)operate, (String)"2")) {
                if (!identifynumBizdataMap.containsKey(identifyNum)) {
                    rsMap.put("status", "0");
                    rsMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1020.getCode());
                    rsMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1020.getDesc());
                    dataRsList.add(rsMap);
                    errorIdentifyNums.add(identifyNum);
                    this.log.info("correct bizdata ,bizdatacode not find!");
                    continue;
                }
                DynamicObject dyObj = (DynamicObject)identifynumBizdataMap.get(identifyNum);
                int usageCount = dyObj.getInt("usagecount");
                if (usageCount > 0) {
                    rsMap.put("status", "0");
                    rsMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1050.getCode());
                    rsMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1050.getDesc());
                    dataRsList.add(rsMap);
                    errorIdentifyNums.add(identifyNum);
                    continue;
                }
            } else if (identifynumBizdataMap.containsKey(identifyNum)) {
                rsMap.put("status", "0");
                rsMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1010.getCode());
                rsMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1010.getDesc());
                dataRsList.add(rsMap);
                errorIdentifyNums.add(identifyNum);
                this.log.info("add new bizdata ,bizdatacode already exists!");
                continue;
            }
            if (SWCObjectUtils.isEmpty((Object)(salaryFileObj = salaryFileDataMap.get(salaryFileId)))) {
                rsMap.put("status", "0");
                rsMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1032.getCode());
                rsMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1032.getDesc());
                dataRsList.add(rsMap);
                errorIdentifyNums.add(identifyNum);
                continue;
            }
            Long calpayrollid = salaryFileObj.getLong("payrollgroup.id");
            rsMap.put("calpayrollid", calpayrollid);
            this.log.info("calpayrollid is \uff1a{}", (Object)calpayrollid);
            Date firstBsed = salaryFileObj.getDate("firstbsed");
            this.log.info("get firstBsed value is:{}", (Object)firstBsed);
            if (firstBsed == null) {
                rsMap.put("status", "0");
                rsMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1031.getCode());
                rsMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1031.getDesc());
                dataRsList.add(rsMap);
                errorIdentifyNums.add(identifyNum);
                continue;
            }
            if (isRecur.booleanValue() && recurBizData != null) {
                Set<Long> cacheSalaryFileIdSet;
                this.log.info("start to recurBizData!");
                List dynamicObjects = (List)recurBizData.get((Object)salaryFileId, (Object)bizItemId);
                if (dynamicObjects != null && dynamicObjects.size() > 0) {
                    this.log.info("recurBizData start get errorIdentifyNumList!");
                    List<String> errorIdentifyNumList = bizDataHelper.getUpdateBsledErrorList(bsed, bsled, dynamicObjects, identifyNum);
                    this.log.info("recurBizData get errorIdentifyNumList size:{}", (Object)errorIdentifyNumList.size());
                    if (errorIdentifyNumList.size() > 0) {
                        this.log.info("start get errorIdentifyNumList size!");
                        rsMap.put("status", "0");
                        rsMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1035.getCode());
                        rsMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1035.getDesc());
                        dataRsList.add(rsMap);
                        errorIdentifyNums.add(identifyNum);
                        continue;
                    }
                    for (DynamicObject dataObj : dynamicObjects) {
                        String oldBizDataCode = dataObj.getString("identifynumber");
                        Iterator oldBizItemId = dataObj.getLong("bizitem.id");
                        Date oldBsled = dataObj.getDate("bsled");
                        if (oldBsled == null) continue;
                        bizDataBsledDateMap.put(oldBizDataCode + '#' + oldBizItemId, oldBsled);
                    }
                }
                ArrayList<DynamicObject> currentNeedUpdateBsledList = new ArrayList<DynamicObject>(10);
                this.log.info("recurBizData start get needUpdateBsledList!");
                List<DynamicObject> needUpdateBsledList = bizDataHelper.dealNeedUpdateBsledData(recurBizData, salaryFileId, bizItemId, bsed, bsled);
                this.log.info("need needUpdateBsledList value is:{}", needUpdateBsledList);
                if (needUpdateBsledList != null && needUpdateBsledList.size() > 0) {
                    allUpdateBsledList.addAll(needUpdateBsledList);
                    currentNeedUpdateBsledList.addAll(needUpdateBsledList);
                }
                this.log.info("recurBizData salaryFileIds is:{}", salaryFileIds);
                Long depempId = MapUtils.getLong(bizDataMap, (Object)"depempid");
                if (depempId != null && (cacheSalaryFileIdSet = cacheDepempAndSalaryFileRelMap.get(depempId)) != null) {
                    for (Long depempSalaryFileId : cacheSalaryFileIdSet) {
                        if (depempSalaryFileId.longValue() == salaryFileId.longValue()) continue;
                        this.log.info("start to depempt recurBizData!");
                        List depempDynamicObjects = (List)recurBizData.get((Object)depempSalaryFileId, (Object)bizItemId);
                        if (depempDynamicObjects != null && depempDynamicObjects.size() > 0) {
                            this.log.info("recurBizData depempt start get errorIdentifyNumList!");
                            List<String> errorIdentifyNumList = bizDataHelper.getUpdateBsledErrorList(bsed, bsled, depempDynamicObjects, identifyNum);
                            this.log.info("recurBizData depempt get errorIdentifyNumList size:{}", (Object)errorIdentifyNumList.size());
                            if (errorIdentifyNumList.size() > 0) {
                                this.log.info("start get depempt errorIdentifyNumList is:{}", errorIdentifyNumList);
                                continue;
                            }
                        }
                        this.log.info("recurBizData depempt start get needUpdateBsledList!");
                        List<DynamicObject> depempNeedUpdateBsledList = bizDataHelper.dealNeedUpdateBsledData(recurBizData, depempSalaryFileId, bizItemId, bsed, bsled);
                        this.log.info("need depempt needUpdateBsledList value is:{}", depempNeedUpdateBsledList);
                        if (depempNeedUpdateBsledList == null || depempNeedUpdateBsledList.size() <= 0) continue;
                        allUpdateBsledList.addAll(depempNeedUpdateBsledList);
                        currentNeedUpdateBsledList.addAll(depempNeedUpdateBsledList);
                    }
                }
                if (currentNeedUpdateBsledList != null && currentNeedUpdateBsledList.size() > 0) {
                    Long oldBizItemId;
                    String opBizDataCode = MapUtils.getString(bizDataMap, (Object)"bizdatacode");
                    for (DynamicObject updateObj : currentNeedUpdateBsledList) {
                        DynamicObject bsledRecordObj = bsledRecordHelper.generateEmptyDynamicObject();
                        Long updateSalaryFileId = updateObj.getLong("salaryfile.id");
                        bsledRecordObj.set("salaryfile", (Object)updateSalaryFileId);
                        oldBizItemId = updateObj.getLong("bizitem.id");
                        bsledRecordObj.set("bizitem", (Object)oldBizItemId);
                        String bizDataCode = updateObj.getString("identifynumber");
                        bsledRecordObj.set("bizdatacode", (Object)bizDataCode);
                        bsledRecordObj.set("opbizdatacode", (Object)opBizDataCode);
                        Date beforeBsled = (Date)bizDataBsledDateMap.get(bizDataCode + '#' + oldBizItemId);
                        if (beforeBsled != null) {
                            bsledRecordObj.set("beforebsled", (Object)beforeBsled);
                        }
                        bsledRecordObj.set("afterbsled", (Object)updateObj.getDate("bsled"));
                        if (needDepempUpdateSalaryFileSet.contains(updateSalaryFileId)) {
                            bsledRecordObj.set("optype", (Object)BizDataOperateEnum.OPERATE_ADD.getCode());
                        } else {
                            bsledRecordObj.set("optype", (Object)BizDataOperateEnum.OPERATE_ITF_ADD.getCode());
                        }
                        bsledRecordObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
                        bsledRecordObj.set("modifytime", (Object)new Date());
                        bizDataBsledRecordList.add(bsledRecordObj);
                        BizDataModifyRecEntity dataModifyRec = new BizDataModifyRecEntity();
                        dataModifyRec.setSalaryFileId(updateSalaryFileId);
                        dataModifyRec.setBizDataNum(bizDataCode);
                        dataModifyRec.setOpBizDataNum(opBizDataCode);
                        dataModifyRec.setBizItemId(oldBizItemId);
                        dataModifyRec.setUpdateField(BizDataUpdateFieldEnum.BSLED.getCode());
                        if (beforeBsled != null) {
                            String beforeUpdateBsed = SWCDateTimeUtils.format((Date)beforeBsled, (String)"yyyy-MM-dd");
                            dataModifyRec.setBeforeUpdate(beforeUpdateBsed);
                        }
                        if (updateObj.getDate("bsled") != null) {
                            String afterUpdateBsed = SWCDateTimeUtils.format((Date)updateObj.getDate("bsled"), (String)"yyyy-MM-dd");
                            dataModifyRec.setAfterUpdate(afterUpdateBsed);
                        }
                        dataModifyRec.setDataSources(updateObj.getString("datasources"));
                        if (needDepempUpdateSalaryFileSet.contains(updateSalaryFileId)) {
                            dataModifyRec.setOperate(BizDataOperateEnum.OPERATE_ADD.getCode());
                        } else {
                            dataModifyRec.setOperate(BizDataOperateEnum.OPERATE_ITF_ADD.getCode());
                        }
                        dataModifyRec.setDataId(updateObj.getLong("id"));
                        dataModifyRec.setModelType("1");
                        arrayList.add(dataModifyRec);
                    }
                    for (DynamicObject updateObj : currentNeedUpdateBsledList) {
                        HashMap<String, Object> needPushHpdiDataMap = new HashMap<String, Object>(16);
                        String bizDataCode = updateObj.getString("identifynumber");
                        needPushHpdiDataMap.put("bizdatacode", bizDataCode);
                        needPushHpdiDataMap.put("operatebizdatacode", opBizDataCode);
                        oldBizItemId = updateObj.getLong("bizitem.id");
                        needPushHpdiDataMap.put("bizitem", oldBizItemId);
                        Long updateSalaryFileId = updateObj.getLong("salaryfile.id");
                        needPushHpdiDataMap.put("salaryfile", updateSalaryFileId);
                        needPushHpdiDataMap.put("modeltype", "1");
                        if (needDepempUpdateSalaryFileSet.contains(updateSalaryFileId)) {
                            needPushHpdiDataMap.put("operate", BizDataOperateEnum.OPERATE_ADD.getCode());
                        } else {
                            needPushHpdiDataMap.put("operate", BizDataOperateEnum.OPERATE_ITF_ADD.getCode());
                        }
                        needPushHpdiDataMap.put("bsled", updateObj.getDate("bsled"));
                        needPushHpdiDataMap.put("modifier", RequestContext.get().getCurrUserId());
                        needPushHpdiDataList.add(needPushHpdiDataMap);
                    }
                }
            }
            DynamicObject bizDataObj = helper.generateEmptyDynamicObject();
            String dataValue = null;
            if (null != bizDataMap.get("isencrypted") && MapUtils.getBoolean(bizDataMap, (Object)"isencrypted").booleanValue()) {
                this.log.info("get start Encrypters decode value");
                dataValue = Encrypters.decode((String)MapUtils.getString(bizDataMap, (Object)"value"));
                this.log.info("get Encrypters decode value is:{}", (Object)dataValue);
            } else {
                this.log.info("get start MapUtils value");
                dataValue = MapUtils.getString(bizDataMap, (Object)"value");
                this.log.info("get MapUtils value is:{}", (Object)dataValue);
            }
            Long bizDataId = bizDataIds[bizDataIdIndex];
            bizDataObj.set("id", (Object)bizDataId);
            bizDataObj.set("identifynumber", (Object)identifyNum);
            bizDataObj.set("opsystem", (Object)opsystem);
            bizDataObj.set("batchnumber", (Object)string);
            bizDataObj.set("bizdataaccesstpl", (Object)bizItemGroupId);
            bizDataObj.set("salaryfile", (Object)salaryFileId);
            bizDataObj.set("bizitem", (Object)bizItemId);
            bizDataObj.set("currency", (Object)MapUtils.getLong(bizDataMap, (Object)"currencyid"));
            bizDataObj.set("bsed", bizDataMap.get("bsed"));
            bizDataObj.set("bsled", bizDataMap.get("bsled"));
            bizDataObj.set("description", (Object)MapUtils.getString(bizDataMap, (Object)"description"));
            bizDataObj.set("datavalue", (Object)dataValue);
            bizDataObj.set("datasources", (Object)MapUtils.getString(bizDataMap, (Object)"datasources"));
            bizDataObj.set("srcsystem", (Object)MapUtils.getString(bizDataMap, (Object)"srcsystem"));
            bizDataObj.set("auditstatus", (Object)"C");
            bizDataObj.set("employee", (Object)MapUtils.getLong(bizDataMap, (Object)"employeeid"));
            bizDataObj.set("depemp", (Object)MapUtils.getLong(bizDataMap, (Object)"depempid"));
            bizDataObj.set("frequency", (Object)MapUtils.getLong(bizDataMap, (Object)"calfrequencyid"));
            bizDataObj.set("payrollgroupid", (Object)calpayrollid);
            long userId = RequestContext.get().getCurrUserId();
            bizDataObj.set("creator", (Object)userId);
            bizDataObj.set("modifier", (Object)userId);
            bizDataObj.set("bizuniquecode", (Object)BizDataUniqueCodeUtils.getBizDataUniqueCode((String)identifyNum, (Long)bizItemId));
            if (isRecur.booleanValue()) {
                Map personChangeInfo = MapUtils.getMap(bizDataMap, (Object)"personchangeinfo");
                if (personChangeInfo != null && personChangeInfo.size() > 0) {
                    Long action;
                    Long salaryadjustrsn = MapUtils.getLong((Map)personChangeInfo, (Object)"salaryadjustrsn");
                    boolean needSave = false;
                    if (salaryadjustrsn != null && salaryadjustrsn != 0L) {
                        bizDataObj.set("salaryadjustrsn", (Object)salaryadjustrsn);
                        needSave = true;
                    }
                    if ((action = MapUtils.getLong((Map)personChangeInfo, (Object)"action")) != null && action != 0L) {
                        bizDataObj.set("action", (Object)action);
                        needSave = true;
                    }
                    if (needSave && operate.equals("1")) {
                        HashMap<String, Object> personChangeInfoMap = new HashMap<String, Object>(16);
                        personChangeInfoMap.put("salaryFileId", salaryFileId);
                        if (salaryadjustrsn != null && salaryadjustrsn != 0L) {
                            personChangeInfoMap.put("salaryAdjustRsnId", salaryadjustrsn);
                        }
                        if (action != null && action != 0L) {
                            personChangeInfoMap.put("actionId", action);
                        }
                        personChangeInfoMap.put("bizDataCode", identifyNum);
                        personChangeInfoMap.put("cycle", 1);
                        personChangeInfoMap.put("bizDataId", bizDataId);
                        personChangeInfoMap.put("changeDate", bizDataMap.get("bsed"));
                        personChangeInfoList.add(personChangeInfoMap);
                    }
                }
                StringBuilder propSb = new StringBuilder();
                DynamicObjectCollection propValEntry = helper.generateEmptyEntryCollection(bizDataObj, "recurbizpropentry");
                if (propdatalist != null && propdatalist.size() > 0) {
                    int size = propdatalist.size();
                    for (int i = 0; i < size; ++i) {
                        Map propdatamap = (Map)propdatalist.get(i);
                        Long bizitempropid = MapUtils.getLong((Map)propdatamap, (Object)"bizitempropid");
                        String propvalue = MapUtils.getString((Map)propdatamap, (Object)"propvalue");
                        DynamicObject propValObj = new DynamicObject(propValEntry.getDynamicObjectType());
                        propValObj.set("bizitemprop", (Object)bizitempropid);
                        propValObj.set("propdatavalue", (Object)propvalue);
                        propValEntry.add((Object)propValObj);
                        DynamicObject propObj = bizItemPropMap.get(bizitempropid);
                        if (SWCObjectUtils.isEmpty((Object)propObj)) continue;
                        propSb.append(propObj.getString("name")).append('\uff1a').append(propvalue);
                        if (i == size - 1) continue;
                        propSb.append('\uff1b');
                    }
                }
                if (propValEntry.size() > 0) {
                    bizDataObj.set("recurbizpropentry", (Object)propValEntry);
                    bizDataObj.set("propval", (Object)propSb.toString());
                }
            } else {
                bizDataObj.set("org", (Object)salaryFileObj.getLong("org.id"));
                bizDataObj.set("payrollgroup", (Object)calpayrollid);
                bizDataObj.set("payrollregion", (Object)salaryFileObj.getLong("payrollregion.id"));
                bizDataObj.set("adminorg", (Object)salaryFileObj.getLong("adminorg.id"));
                bizDataObj.set("empgroup", (Object)salaryFileObj.getLong("empgroup.id"));
                if (bizDataRecordId == null) {
                    bizDataObj.set("bizdatarecord", (Object)(-bizDataId.longValue()));
                } else {
                    bizDataObj.set("bizdatarecord", (Object)bizDataRecordId);
                }
            }
            this.commSetExtPropValue(bizDataObj, bizDataMap);
            bizDataList.add(bizDataObj);
            ++bizDataIdIndex;
        }
        this.log.info("add bizDataList size is :{}", (Object)bizDataList.size());
        AfterBizDataListEvent afterBizDataListEvent = new AfterBizDataListEvent(bizDataList, null);
        this.invokeAfterBizDataList(afterBizDataListEvent);
        bizDataList = afterBizDataListEvent.getBizDataList();
        String status = "";
        String code = null;
        String message = null;
        boolean errorIdNumsNotNull = CollectionUtils.isNotEmpty(errorIdentifyNums);
        if (bizDataList.size() > 0) {
            TXHandle txHandle = TX.requiresNew();
            try {
                if (errorIdNumsNotNull) {
                    bizDataList = bizDataList.stream().filter(bizData -> !errorIdentifyNums.contains(bizData.getString("identifynumber"))).collect(Collectors.toList());
                }
                if (bizDataColl.length > 0 && operate.equals("2")) {
                    if (errorIdNumsNotNull) {
                        List<DynamicObject> bizDataCollNew = Arrays.stream(bizDataColl).filter(bizData -> !errorIdentifyNums.contains(bizData.getString("identifynumber"))).collect(Collectors.toList());
                        bizDataColl = bizDataCollNew.toArray(new DynamicObject[bizDataCollNew.size()]);
                    }
                    helper.delete(bizDataColl);
                }
                helper.save(bizDataList.toArray(new DynamicObject[bizDataList.size()]));
                if (null != allUpdateBsledList && allUpdateBsledList.size() > 0) {
                    long startTime = System.currentTimeMillis();
                    helper.update(allUpdateBsledList.toArray(new DynamicObject[allUpdateBsledList.size()]));
                    long endTime = System.currentTimeMillis();
                    this.log.info("allUpdateBsledList update bsled use time:{}", (Object)(endTime - startTime));
                    if (bizDataBsledRecordList != null && bizDataBsledRecordList.size() > 0) {
                        startTime = System.currentTimeMillis();
                        bsledRecordHelper.save(bizDataBsledRecordList.toArray(new DynamicObject[bizDataBsledRecordList.size()]));
                        endTime = System.currentTimeMillis();
                        this.log.info("bizDataBsledRecordList insert bsledrecord use time:{}", (Object)(endTime - startTime));
                    }
                    if (needPushHpdiDataList != null && needPushHpdiDataList.size() > 0) {
                        this.log.info("BizDataServiceHelper needPushHpdiDataList is:{}", needPushHpdiDataList);
                        startTime = System.currentTimeMillis();
                        Map result = (Map)SWCMServiceUtils.invokeSWCService((String)"hpdi", (String)"IHPDIBizDataService", (String)"updateBizData", (Object[])new Object[]{needPushHpdiDataList});
                        endTime = System.currentTimeMillis();
                        this.log.info("needPushHpdiDataList cal use time:{}", (Object)(endTime - startTime));
                        this.log.info("BizDataServiceHelper needPushHpdiDataList result is:{}", (Object)result);
                    }
                    if (arrayList.size() > 0) {
                        this.log.info("BizDataServiceHelper synBizData save bizData log");
                        startTime = System.currentTimeMillis();
                        BizDataModifyRecHelper.saveBizDataModifyRec(arrayList);
                        endTime = System.currentTimeMillis();
                        this.log.info("needSaveLogDataList saveBizDataModifyRec use time:{}", (Object)(endTime - startTime));
                    }
                }
                if (personChangeInfoList.size() > 0) {
                    this.totalSize = personChangeInfoList.size();
                    int totalPage = 0;
                    totalPage = this.totalSize % 1000 == 0 ? this.totalSize / 1000 : this.totalSize / 1000 + 1;
                    this.pageNum = totalPage;
                    RequestContext requestContext = RequestContext.copyAndSet((RequestContext)RequestContext.get());
                    SWCThreadPoolFactory.getCommonAsyncThreadpool().execute(() -> {
                        RequestContext.copyAndSet((RequestContext)ctx);
                        PersonChangeService personChangeService = new PersonChangeService();
                        for (int i = 0; i < this.pageNum; ++i) {
                            List<Map<String, Object>> sendList = null;
                            sendList = i == this.pageNum - 1 ? personChangeInfoList.subList(i * 1000, this.totalSize) : personChangeInfoList.subList(i * 1000, (i + 1) * 1000);
                            personChangeService.genPersonChangeForBizData(sendList);
                        }
                    });
                }
                status = "1";
                this.log.info("excute save DB success !");
            }
            catch (Exception e) {
                String string = e.getMessage().toLowerCase();
                status = "0";
                if (string.contains("duplicate")) {
                    code = BizDataFailStatusEnum.FAILSTATUS_1010.getCode();
                    message = BizDataFailStatusEnum.FAILSTATUS_1010.getDesc();
                    this.log.error("Duplicate key Exception!!");
                } else {
                    code = BizDataFailStatusEnum.FAILSTATUS_2020.getCode();
                    message = BizDataFailStatusEnum.FAILSTATUS_2020.getDesc();
                }
                this.log.error("excute save DB fail !");
                txHandle.markRollback();
            }
            finally {
                for (DynamicObject dynamicObject : bizDataList) {
                    HashMap<String, Object> rsMap = new HashMap<String, Object>();
                    rsMap.put("bizdatacode", dynamicObject.getString("identifynumber"));
                    rsMap.put("calpayrollid", dynamicObject.getLong("payrollgroupid"));
                    rsMap.put("salaryfileid", dynamicObject.getLong("salaryfile"));
                    rsMap.put("status", status);
                    rsMap.put("errorcode", code);
                    rsMap.put("errormsg", message);
                    dataRsList.add(rsMap);
                }
                txHandle.close();
            }
        }
    }

    private void invokeAfterBizDataList(AfterBizDataListEvent args) {
        BizDataSynExtService ExtService = new BizDataSynExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)ExtService, IBizDataSynExtService.class, (String)"kd.sdk.swc.hsas.business.extpoint.bizdata.IBizDataSynExtService#afterBizDataList", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.afterBizDataList(args);
            return null;
        });
    }

    private void commSetExtPropValue(DynamicObject bizDataObj, Map<String, Object> bizDataMap) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)bizDataObj.getDataEntityType().getName());
        Map fieldTypeMap = mainEntityType.getFields();
        for (Map.Entry field : fieldTypeMap.entrySet()) {
            boolean bizValIsNull;
            String propkey = (String)field.getKey();
            Object bizVal = bizDataObj.get(propkey);
            boolean bl = bizValIsNull = bizVal == null;
            if (bizVal instanceof Long && (Long)bizVal == 0L) {
                bizValIsNull = true;
            }
            if (bizVal instanceof String && SWCStringUtils.isEmpty((String)((String)bizVal))) {
                bizValIsNull = true;
            }
            if (field.getValue() instanceof BasedataProp) {
                propkey = (String)field.getKey() + "id";
            }
            Object mapVal = bizDataMap.get(propkey);
            if (!bizValIsNull || mapVal == null) continue;
            bizDataObj.set((String)field.getKey(), mapVal);
        }
    }

    private Map<Long, DynamicObject> getSalaryFileData(Set<Long> salaryFileIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter filter = new QFilter("id", "in", salaryFileIds);
        DynamicObject[] salaryFileColl = helper.query("id, firstbsed, payrollgroup, org.id, payrollregion.id, adminorg.id, empgroup.id", new QFilter[]{filter});
        HashMap<Long, DynamicObject> salaryFileDataMap = new HashMap<Long, DynamicObject>(salaryFileColl.length);
        for (DynamicObject salaryFile : salaryFileColl) {
            salaryFileDataMap.put(salaryFile.getLong("id"), salaryFile);
        }
        return salaryFileDataMap;
    }

    private DynamicObject[] getBizDataColl(SWCDataServiceHelper helper, List<String> bizDataCodes, String opsystem, boolean isRecur) {
        QFilter filter = new QFilter("identifynumber", "in", bizDataCodes);
        filter.and("opsystem", "=", (Object)opsystem);
        if (isRecur) {
            return helper.query("id, identifynumber, usagecount,nocounttimes, auditstatus, bsed, bsled, opsystem, salaryfile, bizitem, datasources, opreason, salaryadjustrsn, action", new QFilter[]{filter});
        }
        return helper.query("id, identifynumber, usagecount,nocounttimes, auditstatus, bsed, bsled, opsystem, salaryfile, bizitem, datasources, opreason, updatetimes", new QFilter[]{filter});
    }

    private void setEarliestAndLastDate(Date earliestBsed, Date lastBsled, Map<String, Object> paramMap) {
        Date bsed = (Date)paramMap.get("bsed");
        Date bsled = (Date)paramMap.get("blsed");
        if (earliestBsed == null || bsed.before(earliestBsed)) {
            earliestBsed = bsed;
        }
        if (lastBsled == null || bsled.after(lastBsled)) {
            lastBsled = bsled;
        }
    }

    private Map<Long, Boolean> getBizItemMap(Set<Long> bizItemSet, Map<Long, DynamicObject> collectBizItemMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitem");
        QFilter filter = new QFilter("id", "in", bizItemSet);
        filter.and(BizDataHelper.getClassificationFilter());
        DynamicObject[] bizItemColl = helper.query("id,cycle,ctrlstrategy,bizitempropentry.bizitemprop", new QFilter[]{filter});
        HashMap<Long, Boolean> bizItemIsRecurMap = new HashMap<Long, Boolean>(bizItemColl.length);
        for (DynamicObject bizItem : bizItemColl) {
            Boolean isRecurItem = bizItem.getBoolean("cycle");
            bizItemIsRecurMap.put(bizItem.getLong("id"), isRecurItem);
            if (collectBizItemMap == null) continue;
            collectBizItemMap.put(bizItem.getLong("id"), bizItem);
        }
        return bizItemIsRecurMap;
    }

    private Map<Long, Boolean> getBizItemMap(Set<Long> bizItemSet) {
        return this.getBizItemMap(bizItemSet, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> validateDataValue(List<Map<String, Object>> params, Map<Long, DynamicObject> bizItemPropMap) {
        this.log.info("validateDataValue params is :{}", (Object)String.valueOf(JSON.toJSON(params)));
        HashSet<Long> bizItemIdSet = new HashSet<Long>(16);
        HashSet<Long> usedCurrencySet = new HashSet<Long>(16);
        for (Map<String, Object> param : params) {
            Long bizItemId = MapUtils.getLong(param, (Object)"bizitemid");
            bizItemIdSet.add(bizItemId);
            Long usedCurrencyId = MapUtils.getLong(param, (Object)"currencyid");
            usedCurrencySet.add(usedCurrencyId);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitem");
        String selectField = "id, datatype,datatype.id, datalength, minvalue, isminvalnull, maxvalue, ismaxvalnull, earliestdate, lastdate, scalelimit, currency,bizitempropentry.bizitemprop";
        QFilter filter = new QFilter("id", "in", bizItemIdSet);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        filter.and(BizDataHelper.getClassificationFilter());
        DynamicObject[] bizItemColl = helper.query(selectField, new QFilter[]{filter});
        HashMap<Long, DynamicObject> bizItemMap = new HashMap<Long, DynamicObject>(bizItemColl.length);
        for (DynamicObject dynamicObject : bizItemColl) {
            bizItemMap.put(dynamicObject.getLong("id"), dynamicObject);
        }
        helper.setEntityName("bd_currency");
        String selectFields = "id,amtprecision";
        DynamicObject[] currencyColl = helper.queryOriginalArray(selectFields, new QFilter[]{new QFilter("id", "in", usedCurrencySet)});
        HashMap<Long, DynamicObject> useCurrencyMap = new HashMap<Long, DynamicObject>(currencyColl.length);
        for (DynamicObject currency : currencyColl) {
            useCurrencyMap.put(currency.getLong("id"), currency);
        }
        ArrayList arrayList = new ArrayList(params.size());
        HashMap<String, Object> resultMap = null;
        for (Map<String, Object> param : params) {
            Map<String, Object> retMap;
            List propDataList;
            boolean checkResult;
            List propErrorInfo;
            String errorMsg;
            String errorCode;
            DynamicObject bizItemObj;
            block65: {
                String dataValue;
                long dataTypeId;
                block67: {
                    Long currencyId;
                    block66: {
                        block64: {
                            String bizDataCode = MapUtils.getString(param, (Object)"bizdatacode");
                            Long bizItemId = MapUtils.getLong(param, (Object)"bizitemid");
                            resultMap = new HashMap<String, Object>(4);
                            resultMap.put("bizdatacode", bizDataCode);
                            resultMap.put("bizitemid", bizItemId);
                            resultMap.put("status", 1);
                            resultMap.put("errorcode", null);
                            bizItemObj = (DynamicObject)bizItemMap.get(bizItemId);
                            if (SWCObjectUtils.isEmpty((Object)bizItemObj)) {
                                resultMap.put("status", 0);
                                resultMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1021.getCode());
                                resultMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1021.getDesc());
                                arrayList.add(resultMap);
                                continue;
                            }
                            dataTypeId = bizItemObj.getLong("datatype.id");
                            String value = MapUtils.getString(param, (Object)"value");
                            errorCode = null;
                            errorMsg = null;
                            propErrorInfo = null;
                            checkResult = true;
                            resultMap = new HashMap(4);
                            resultMap.put("bizdatacode", bizDataCode);
                            resultMap.put("bizitemid", bizItemId);
                            resultMap.put("status", 1);
                            resultMap.put("errorcode", null);
                            dataValue = value;
                            if (null != param.get("isencrypted") && MapUtils.getBoolean(param, (Object)"isencrypted").booleanValue()) {
                                try {
                                    dataValue = Encrypters.decode((String)value);
                                }
                                catch (Exception e) {
                                    resultMap.put("status", 0);
                                    resultMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1091.getCode());
                                    resultMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1091.getDesc());
                                    arrayList.add(resultMap);
                                    continue;
                                }
                            }
                            if (dataTypeId != 1030L) break block64;
                            currencyId = MapUtils.getLong(param, (Object)"currencyid");
                            if (currencyId != null) {
                                errorCode = BizDataFailStatusEnum.FAILSTATUS_1088.getCode();
                                errorMsg = BizDataFailStatusEnum.FAILSTATUS_1088.getDesc();
                                checkResult = false;
                            }
                            if (checkResult) {
                                int dataLength = bizItemObj.getInt("datalength");
                                if (dataValue.length() > dataLength) {
                                    errorCode = BizDataFailStatusEnum.FAILSTATUS_1090.getCode();
                                    errorMsg = BizDataFailStatusEnum.FAILSTATUS_1090.getDesc();
                                    checkResult = false;
                                }
                            }
                            break block65;
                        }
                        if (dataTypeId != 1010L) break block66;
                        currencyId = MapUtils.getLong(param, (Object)"currencyid");
                        if (currencyId != null) {
                            errorCode = BizDataFailStatusEnum.FAILSTATUS_1088.getCode();
                            errorMsg = BizDataFailStatusEnum.FAILSTATUS_1088.getDesc();
                            checkResult = false;
                        }
                        if (checkResult) {
                            BigDecimal decimalValue = null;
                            boolean flag = true;
                            try {
                                decimalValue = new BigDecimal(dataValue);
                            }
                            catch (Exception e) {
                                flag = false;
                            }
                            finally {
                                if (flag) {
                                    checkResult = this.checkNumScaleLimit(bizItemObj, dataValue);
                                    if (checkResult) {
                                        checkResult = this.checkMaxAndMinValue(bizItemObj, decimalValue);
                                        if (!checkResult) {
                                            errorCode = BizDataFailStatusEnum.FAILSTATUS_1092.getCode();
                                            errorMsg = BizDataFailStatusEnum.FAILSTATUS_1092.getDesc();
                                        }
                                    } else {
                                        errorCode = BizDataFailStatusEnum.FAILSTATUS_1096.getCode();
                                        errorMsg = BizDataFailStatusEnum.FAILSTATUS_1096.getDesc();
                                    }
                                } else {
                                    errorCode = BizDataFailStatusEnum.FAILSTATUS_1091.getCode();
                                    errorMsg = BizDataFailStatusEnum.FAILSTATUS_1091.getDesc();
                                    checkResult = false;
                                }
                            }
                        }
                        break block65;
                    }
                    if (dataTypeId != 1050L) break block67;
                    currencyId = MapUtils.getLong(param, (Object)"currencyid");
                    if (currencyId != null) {
                        errorCode = BizDataFailStatusEnum.FAILSTATUS_1088.getCode();
                        errorMsg = BizDataFailStatusEnum.FAILSTATUS_1088.getDesc();
                        checkResult = false;
                    }
                    if (checkResult) {
                        Date dateValue = null;
                        boolean flag = true;
                        try {
                            if (!SWCDateTimeUtils.validDateEffecitive((String)dataValue)) {
                                flag = false;
                            }
                            dateValue = SWCDateTimeUtils.parseDate((String)dataValue, (String)"yyyy-MM-dd");
                        }
                        catch (ParseException e) {
                            flag = false;
                        }
                        finally {
                            if (!flag) {
                                checkResult = false;
                                errorCode = BizDataFailStatusEnum.FAILSTATUS_1091.getCode();
                                errorMsg = BizDataFailStatusEnum.FAILSTATUS_1091.getDesc();
                            } else {
                                checkResult = this.checkDateEarlistAndLastValue(bizItemObj, dateValue);
                                if (!checkResult) {
                                    errorCode = BizDataFailStatusEnum.FAILSTATUS_1093.getCode();
                                    errorMsg = BizDataFailStatusEnum.FAILSTATUS_1093.getDesc();
                                }
                            }
                        }
                    }
                    break block65;
                }
                if (dataTypeId == 1020L) {
                    block62: {
                        HashMap<Long, DynamicObject> currencyMap;
                        DynamicObjectCollection currencys;
                        BigDecimal decimalValue = null;
                        boolean flag = true;
                        try {
                            decimalValue = new BigDecimal(dataValue);
                            if (!flag) break block62;
                        }
                        catch (Exception e) {
                            block63: {
                                try {
                                    flag = false;
                                    if (!flag) break block63;
                                }
                                catch (Throwable throwable) {
                                    if (flag) {
                                        Long usedCurrencyId = MapUtils.getLong(param, (Object)"currencyid");
                                        checkResult = this.checkCurrencyMustInput(usedCurrencyId);
                                        if (!checkResult) {
                                            errorCode = BizDataFailStatusEnum.FAILSTATUS_1094.getCode();
                                            errorMsg = BizDataFailStatusEnum.FAILSTATUS_1094.getDesc();
                                        } else {
                                            DynamicObjectCollection currencys2 = bizItemObj.getDynamicObjectCollection("currency");
                                            HashMap<Long, DynamicObject> currencyMap2 = new HashMap<Long, DynamicObject>(currencys2.size());
                                            for (DynamicObject currencyObj : currencys2) {
                                                currencyMap2.put(currencyObj.getDynamicObject("fbasedataid").getLong("id"), currencyObj);
                                            }
                                            checkResult = this.checkCurrencyRange(usedCurrencyId, currencyMap2);
                                            if (!checkResult) {
                                                errorCode = BizDataFailStatusEnum.FAILSTATUS_1095.getCode();
                                                errorMsg = BizDataFailStatusEnum.FAILSTATUS_1095.getDesc();
                                            } else if (!(checkResult = this.checkCurrencyPrecision(dataValue, checkResult, usedCurrencyId, useCurrencyMap))) {
                                                errorCode = BizDataFailStatusEnum.FAILSTATUS_1097.getCode();
                                                errorMsg = BizDataFailStatusEnum.FAILSTATUS_1097.getDesc();
                                            }
                                        }
                                    } else {
                                        errorCode = BizDataFailStatusEnum.FAILSTATUS_1091.getCode();
                                        errorMsg = BizDataFailStatusEnum.FAILSTATUS_1091.getDesc();
                                        checkResult = false;
                                    }
                                    throw throwable;
                                }
                                Long usedCurrencyId = MapUtils.getLong(param, (Object)"currencyid");
                                checkResult = this.checkCurrencyMustInput(usedCurrencyId);
                                if (!checkResult) {
                                    errorCode = BizDataFailStatusEnum.FAILSTATUS_1094.getCode();
                                    errorMsg = BizDataFailStatusEnum.FAILSTATUS_1094.getDesc();
                                } else {
                                    currencys = bizItemObj.getDynamicObjectCollection("currency");
                                    currencyMap = new HashMap(currencys.size());
                                    for (DynamicObject currencyObj : currencys) {
                                        currencyMap.put(currencyObj.getDynamicObject("fbasedataid").getLong("id"), currencyObj);
                                    }
                                    checkResult = this.checkCurrencyRange(usedCurrencyId, currencyMap);
                                    if (!checkResult) {
                                        errorCode = BizDataFailStatusEnum.FAILSTATUS_1095.getCode();
                                        errorMsg = BizDataFailStatusEnum.FAILSTATUS_1095.getDesc();
                                    } else if (!(checkResult = this.checkCurrencyPrecision(dataValue, checkResult, usedCurrencyId, useCurrencyMap))) {
                                        errorCode = BizDataFailStatusEnum.FAILSTATUS_1097.getCode();
                                        errorMsg = BizDataFailStatusEnum.FAILSTATUS_1097.getDesc();
                                    }
                                }
                            }
                            errorCode = BizDataFailStatusEnum.FAILSTATUS_1091.getCode();
                            errorMsg = BizDataFailStatusEnum.FAILSTATUS_1091.getDesc();
                            checkResult = false;
                        }
                        Long usedCurrencyId = MapUtils.getLong(param, (Object)"currencyid");
                        checkResult = this.checkCurrencyMustInput(usedCurrencyId);
                        if (!checkResult) {
                            errorCode = BizDataFailStatusEnum.FAILSTATUS_1094.getCode();
                            errorMsg = BizDataFailStatusEnum.FAILSTATUS_1094.getDesc();
                        } else {
                            currencys = bizItemObj.getDynamicObjectCollection("currency");
                            currencyMap = new HashMap<Long, DynamicObject>(currencys.size());
                            for (DynamicObject currencyObj : currencys) {
                                currencyMap.put(currencyObj.getDynamicObject("fbasedataid").getLong("id"), currencyObj);
                            }
                            checkResult = this.checkCurrencyRange(usedCurrencyId, currencyMap);
                            if (!checkResult) {
                                errorCode = BizDataFailStatusEnum.FAILSTATUS_1095.getCode();
                                errorMsg = BizDataFailStatusEnum.FAILSTATUS_1095.getDesc();
                            } else if (!(checkResult = this.checkCurrencyPrecision(dataValue, checkResult, usedCurrencyId, useCurrencyMap))) {
                                errorCode = BizDataFailStatusEnum.FAILSTATUS_1097.getCode();
                                errorMsg = BizDataFailStatusEnum.FAILSTATUS_1097.getDesc();
                            }
                        }
                        break block65;
                    }
                    errorCode = BizDataFailStatusEnum.FAILSTATUS_1091.getCode();
                    errorMsg = BizDataFailStatusEnum.FAILSTATUS_1091.getDesc();
                    checkResult = false;
                }
            }
            if (checkResult && (propDataList = (List)param.get("propdatalist")) != null && propDataList.size() > 0 && !(checkResult = ((Boolean)(retMap = this.checkPropDataValue(propDataList, bizItemObj, bizItemPropMap)).get("checkResult")).booleanValue())) {
                errorCode = (String)retMap.get("errorCode");
                errorMsg = (String)retMap.get("errorMsg");
                propErrorInfo = (List)retMap.get("propErrorInfo");
            }
            if (!checkResult) {
                resultMap.put("status", 0);
                resultMap.put("errorcode", errorCode);
                resultMap.put("errormsg", errorMsg);
                if (propErrorInfo != null && propErrorInfo.size() > 0) {
                    resultMap.put("propErrorInfo", propErrorInfo);
                }
            }
            arrayList.add(resultMap);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        result.put("success", Boolean.TRUE);
        result.put("message", null);
        result.put("result", arrayList);
        this.log.info("validateDataValue result is :{}", (Object)String.valueOf(JSON.toJSON(result)));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> checkPropDataValue(List<Map<String, Object>> propDataList, DynamicObject bizItemObj, Map<Long, DynamicObject> bizItemPropMap) {
        DynamicObject bizItemPropObj;
        Long bizitempropid;
        HashMap<String, Object> retMap = new HashMap<String, Object>(2);
        retMap.put("checkResult", Boolean.TRUE);
        DynamicObjectCollection entryColl = bizItemObj.getDynamicObjectCollection("bizitempropentry");
        if (entryColl == null || entryColl.size() == 0) {
            return retMap;
        }
        HashSet<Long> entryPoroIdSet = new HashSet<Long>(entryColl.size());
        for (Object entryObj : entryColl) {
            DynamicObject dynamicObject = entryObj.getDynamicObject("bizitemprop");
            if (SWCObjectUtils.isEmpty((Object)dynamicObject)) continue;
            entryPoroIdSet.add(dynamicObject.getLong("id"));
        }
        ArrayList propErrorList = new ArrayList(propDataList.size());
        for (Map map : propDataList) {
            HashMap<String, Object> propErrorMap;
            Long bizitempropid2 = (Long)map.get("bizitempropid");
            DynamicObject bizItemPropObj3 = bizItemPropMap.get(bizitempropid2);
            if (SWCObjectUtils.isEmpty((Object)bizItemPropObj3)) {
                propErrorMap = new HashMap<String, Object>(16);
                propErrorMap.put("bizitempropid", bizitempropid2);
                propErrorList.add(propErrorMap);
                continue;
            }
            if (entryPoroIdSet.contains(bizitempropid2)) continue;
            propErrorMap = new HashMap(16);
            propErrorMap.put("bizitempropid", bizitempropid2);
            propErrorMap.put("bizitempropname", bizItemPropObj3.getString("name"));
            propErrorMap.put("bizitempropnumber", bizItemPropObj3.getString("number"));
            propErrorList.add(propErrorMap);
        }
        if (propErrorList.size() > 0) {
            retMap.put("checkResult", Boolean.FALSE);
            retMap.put("errorCode", BizDataFailStatusEnum.FAILSTATUS_1102.getCode());
            retMap.put("errorMsg", BizDataFailStatusEnum.FAILSTATUS_1102.getDesc());
            retMap.put("propErrorInfo", propErrorList);
            return retMap;
        }
        HashSet<Long> bizItemPropIdSet = new HashSet<Long>(propDataList.size());
        for (Map<String, Object> propDataMap : propDataList) {
            bizitempropid = (Long)propDataMap.get("bizitempropid");
            bizItemPropObj = bizItemPropMap.get(bizitempropid);
            if (bizItemPropIdSet.contains(bizitempropid)) {
                HashMap<String, Object> propErrorMap = new HashMap<String, Object>(16);
                propErrorMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1085.getCode());
                propErrorMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1085.getDesc());
                propErrorMap.put("bizitempropid", bizitempropid);
                propErrorMap.put("bizitempropname", bizItemPropObj.getString("name"));
                propErrorMap.put("bizitempropnumber", bizItemPropObj.getString("number"));
                propErrorList.add(propErrorMap);
                break;
            }
            bizItemPropIdSet.add(bizitempropid);
        }
        if (propErrorList.size() > 0) {
            retMap.put("checkResult", Boolean.FALSE);
            retMap.put("errorCode", BizDataFailStatusEnum.FAILSTATUS_1098.getCode());
            retMap.put("errorMsg", BizDataFailStatusEnum.FAILSTATUS_1098.getDesc());
            retMap.put("propErrorInfo", propErrorList);
            return retMap;
        }
        for (Map<String, Object> propDataMap : propDataList) {
            block30: {
                HashMap<String, Object> propErrorMap;
                block31: {
                    bizitempropid = (Long)propDataMap.get("bizitempropid");
                    bizItemPropObj = bizItemPropMap.get(bizitempropid);
                    long dataTypeId = bizItemPropObj.getLong("datatype.id");
                    String propValue = MapUtils.getString(propDataMap, (Object)"propvalue");
                    if (dataTypeId == 1030L) {
                        int dataLength = bizItemPropObj.getInt("datalength");
                        if (propValue.length() <= dataLength) continue;
                        HashMap<String, Object> propErrorMap2 = new HashMap<String, Object>(16);
                        propErrorMap2.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1090.getCode());
                        propErrorMap2.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1090.getDesc());
                        propErrorMap2.put("bizitempropid", bizitempropid);
                        propErrorMap2.put("bizitempropname", bizItemPropObj.getString("name"));
                        propErrorMap2.put("bizitempropnumber", bizItemPropObj.getString("number"));
                        propErrorList.add(propErrorMap2);
                        continue;
                    }
                    if (dataTypeId == 1050L) {
                        Date dateValue;
                        block29: {
                            HashMap<String, Object> propErrorMap3;
                            dateValue = null;
                            boolean flag = true;
                            try {
                                if (!SWCDateTimeUtils.validDateEffecitive((String)propValue)) {
                                    flag = false;
                                } else {
                                    dateValue = SWCDateTimeUtils.parseDate((String)propValue, (String)"yyyy-MM-dd");
                                }
                                if (flag) break block29;
                                propErrorMap3 = new HashMap<String, Object>(16);
                                propErrorMap3.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1091.getCode());
                            }
                            catch (ParseException e) {
                                flag = false;
                                continue;
                            }
                            finally {
                                if (!flag) {
                                    HashMap<String, Object> propErrorMap4 = new HashMap<String, Object>(16);
                                    propErrorMap4.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1091.getCode());
                                    propErrorMap4.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1091.getDesc());
                                    propErrorMap4.put("bizitempropid", bizitempropid);
                                    propErrorMap4.put("bizitempropname", bizItemPropObj.getString("name"));
                                    propErrorMap4.put("bizitempropnumber", bizItemPropObj.getString("number"));
                                    propErrorList.add(propErrorMap4);
                                    continue;
                                }
                                boolean checkResult = this.checkDateEarlistAndLastValue(bizItemPropObj, dateValue);
                                if (checkResult) continue;
                                propErrorMap = new HashMap<String, Object>(16);
                                propErrorMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1093.getCode());
                                propErrorMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1093.getDesc());
                                propErrorMap.put("bizitempropid", bizitempropid);
                                propErrorMap.put("bizitempropname", bizItemPropObj.getString("name"));
                                propErrorMap.put("bizitempropnumber", bizItemPropObj.getString("number"));
                                propErrorList.add(propErrorMap);
                                continue;
                            }
                            propErrorMap3.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1091.getDesc());
                            propErrorMap3.put("bizitempropid", bizitempropid);
                            propErrorMap3.put("bizitempropname", bizItemPropObj.getString("name"));
                            propErrorMap3.put("bizitempropnumber", bizItemPropObj.getString("number"));
                            propErrorList.add(propErrorMap3);
                            continue;
                        }
                        boolean checkResult = this.checkDateEarlistAndLastValue(bizItemPropObj, dateValue);
                        if (checkResult) continue;
                        propErrorMap = new HashMap(16);
                        propErrorMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1093.getCode());
                        propErrorMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1093.getDesc());
                        propErrorMap.put("bizitempropid", bizitempropid);
                        propErrorMap.put("bizitempropname", bizItemPropObj.getString("name"));
                        propErrorMap.put("bizitempropnumber", bizItemPropObj.getString("number"));
                        propErrorList.add(propErrorMap);
                        continue;
                    }
                    if (dataTypeId != 1010L) continue;
                    BigDecimal decimalValue = null;
                    boolean flag = true;
                    try {
                        decimalValue = new BigDecimal(propValue);
                        if (!flag) break block30;
                        boolean checkResult = this.checkNumScaleLimit(bizItemPropObj, propValue);
                        if (!checkResult) break block31;
                        checkResult = this.checkMaxAndMinValue(bizItemPropObj, decimalValue);
                        if (checkResult) continue;
                        propErrorMap = new HashMap(16);
                        propErrorMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1092.getCode());
                    }
                    catch (Exception e) {
                        block32: {
                            block33: {
                                try {
                                    flag = false;
                                    if (!flag) break block32;
                                    boolean checkResult = this.checkNumScaleLimit(bizItemPropObj, propValue);
                                    if (!checkResult) break block33;
                                    checkResult = this.checkMaxAndMinValue(bizItemPropObj, decimalValue);
                                    if (checkResult) continue;
                                    propErrorMap = new HashMap(16);
                                    propErrorMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1092.getCode());
                                }
                                catch (Throwable throwable) {
                                    if (flag) {
                                        boolean checkResult = this.checkNumScaleLimit(bizItemPropObj, propValue);
                                        if (checkResult) {
                                            checkResult = this.checkMaxAndMinValue(bizItemPropObj, decimalValue);
                                            if (!checkResult) {
                                                HashMap<String, Object> propErrorMap5 = new HashMap<String, Object>(16);
                                                propErrorMap5.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1092.getCode());
                                                propErrorMap5.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1092.getDesc());
                                                propErrorMap5.put("bizitempropid", bizitempropid);
                                                propErrorMap5.put("bizitempropname", bizItemPropObj.getString("name"));
                                                propErrorMap5.put("bizitempropnumber", bizItemPropObj.getString("number"));
                                                propErrorList.add(propErrorMap5);
                                            }
                                        } else {
                                            HashMap<String, Object> propErrorMap6 = new HashMap<String, Object>(16);
                                            propErrorMap6.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1096.getCode());
                                            propErrorMap6.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1096.getDesc());
                                            propErrorMap6.put("bizitempropid", bizitempropid);
                                            propErrorMap6.put("bizitempropname", bizItemPropObj.getString("name"));
                                            propErrorMap6.put("bizitempropnumber", bizItemPropObj.getString("number"));
                                            propErrorList.add(propErrorMap6);
                                        }
                                    } else {
                                        HashMap<String, Object> propErrorMap7 = new HashMap<String, Object>(16);
                                        propErrorMap7.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1091.getCode());
                                        propErrorMap7.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1091.getDesc());
                                        propErrorMap7.put("bizitempropid", bizitempropid);
                                        propErrorMap7.put("bizitempropname", bizItemPropObj.getString("name"));
                                        propErrorMap7.put("bizitempropnumber", bizItemPropObj.getString("number"));
                                        propErrorList.add(propErrorMap7);
                                    }
                                    throw throwable;
                                }
                                propErrorMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1092.getDesc());
                                propErrorMap.put("bizitempropid", bizitempropid);
                                propErrorMap.put("bizitempropname", bizItemPropObj.getString("name"));
                                propErrorMap.put("bizitempropnumber", bizItemPropObj.getString("number"));
                                propErrorList.add(propErrorMap);
                                continue;
                            }
                            propErrorMap = new HashMap(16);
                            propErrorMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1096.getCode());
                            propErrorMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1096.getDesc());
                            propErrorMap.put("bizitempropid", bizitempropid);
                            propErrorMap.put("bizitempropname", bizItemPropObj.getString("name"));
                            propErrorMap.put("bizitempropnumber", bizItemPropObj.getString("number"));
                            propErrorList.add(propErrorMap);
                            continue;
                        }
                        HashMap<String, Object> propErrorMap8 = new HashMap<String, Object>(16);
                        propErrorMap8.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1091.getCode());
                        propErrorMap8.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1091.getDesc());
                        propErrorMap8.put("bizitempropid", bizitempropid);
                        propErrorMap8.put("bizitempropname", bizItemPropObj.getString("name"));
                        propErrorMap8.put("bizitempropnumber", bizItemPropObj.getString("number"));
                        propErrorList.add(propErrorMap8);
                        continue;
                    }
                    propErrorMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1092.getDesc());
                    propErrorMap.put("bizitempropid", bizitempropid);
                    propErrorMap.put("bizitempropname", bizItemPropObj.getString("name"));
                    propErrorMap.put("bizitempropnumber", bizItemPropObj.getString("number"));
                    propErrorList.add(propErrorMap);
                    continue;
                }
                propErrorMap = new HashMap(16);
                propErrorMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1096.getCode());
                propErrorMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1096.getDesc());
                propErrorMap.put("bizitempropid", bizitempropid);
                propErrorMap.put("bizitempropname", bizItemPropObj.getString("name"));
                propErrorMap.put("bizitempropnumber", bizItemPropObj.getString("number"));
                propErrorList.add(propErrorMap);
                continue;
            }
            HashMap<String, Object> propErrorMap = new HashMap<String, Object>(16);
            propErrorMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1091.getCode());
            propErrorMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1091.getDesc());
            propErrorMap.put("bizitempropid", bizitempropid);
            propErrorMap.put("bizitempropname", bizItemPropObj.getString("name"));
            propErrorMap.put("bizitempropnumber", bizItemPropObj.getString("number"));
            propErrorList.add(propErrorMap);
        }
        if (propErrorList.size() > 0) {
            retMap.put("checkResult", Boolean.FALSE);
            retMap.put("errorCode", BizDataFailStatusEnum.FAILSTATUS_1098.getCode());
            retMap.put("errorMsg", BizDataFailStatusEnum.FAILSTATUS_1098.getDesc());
            retMap.put("propErrorInfo", propErrorList);
        }
        return retMap;
    }

    private boolean checkCurrencyPrecision(String value, boolean checkResult, Long usedCurrencyId, Map<Long, DynamicObject> useCurrencyMap) {
        int amtPrecision = 10;
        DynamicObject useCurrency = useCurrencyMap.get(usedCurrencyId);
        if (SWCObjectUtils.isEmpty((Object)useCurrency)) {
            return checkResult;
        }
        amtPrecision = useCurrency.getInt("amtprecision");
        int indexOf = value.indexOf(46);
        int precision = 0;
        if (indexOf > 0) {
            precision = value.substring(indexOf + 1, value.length()).length();
        }
        if (amtPrecision < precision) {
            checkResult = false;
        }
        return checkResult;
    }

    private boolean checkCurrencyRange(Long usedCurrencyId, Map<Long, DynamicObject> currencyMap) {
        boolean isMatch;
        boolean checkResult = true;
        if (currencyMap.size() > 0 && !(isMatch = currencyMap.containsKey(usedCurrencyId))) {
            checkResult = false;
        }
        return checkResult;
    }

    private boolean checkCurrencyMustInput(Long usedCurrencyId) {
        boolean checkResult = true;
        if (SWCObjectUtils.isEmpty((Object)usedCurrencyId)) {
            checkResult = false;
        }
        return checkResult;
    }

    private boolean checkDateEarlistAndLastValue(DynamicObject bizItemObj, Date dateValue) {
        Date earliestDate = bizItemObj.getDate("earliestdate");
        Date lastDate = bizItemObj.getDate("lastdate");
        boolean checkResult = earliestDate == null && lastDate == null ? true : (earliestDate == null ? !lastDate.before(dateValue) : (lastDate == null ? !earliestDate.after(dateValue) : !lastDate.before(dateValue) && !earliestDate.after(dateValue)));
        return checkResult;
    }

    private boolean checkMaxAndMinValue(DynamicObject bizItemObj, BigDecimal decimalValue) {
        BigDecimal minValue = bizItemObj.getBigDecimal("minvalue");
        BigDecimal maxValue = bizItemObj.getBigDecimal("maxvalue");
        Boolean isMinValNull = bizItemObj.getBoolean("isminvalnull");
        boolean isMaxValNull = bizItemObj.getBoolean("ismaxvalnull");
        boolean checkResult = isMinValNull != false && isMaxValNull ? true : (isMinValNull != false ? maxValue.compareTo(decimalValue) >= 0 : (isMaxValNull ? minValue.compareTo(decimalValue) <= 0 : minValue.compareTo(decimalValue) <= 0 && maxValue.compareTo(decimalValue) >= 0));
        return checkResult;
    }

    private boolean checkNumScaleLimit(DynamicObject bizItemObj, String value) {
        boolean checkResult = true;
        int indexOf = value.indexOf(46);
        int precision = 0;
        if (indexOf > 0) {
            precision = value.substring(indexOf + 1, value.length()).length();
        }
        String scaleLimit = bizItemObj.getString("scalelimit");
        int scale = 10;
        if (!SWCStringUtils.isEmpty((String)scaleLimit)) {
            scale = Integer.parseInt(scaleLimit);
        }
        if (scale < precision) {
            checkResult = false;
        }
        return checkResult;
    }

    private Map<String, String> fetchErrorCode(Map<String, Object> validateResult, Map<String, Object> propErrorMap, Map<String, String> errorMsgMap) {
        List result = (List)validateResult.get("result");
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)result.size());
        for (Map oneData : result) {
            int status = (Integer)oneData.get("status");
            if (status != 0) continue;
            String bizDataCode = (String)oneData.get("bizdatacode");
            String errorCode = (String)oneData.get("errorcode");
            resultMap.putIfAbsent(bizDataCode, errorCode);
            errorMsgMap.putIfAbsent(bizDataCode, (String)oneData.get("errormsg"));
            List propErrorInfo = (List)oneData.get("propErrorInfo");
            if (propErrorInfo == null || propErrorInfo.size() <= 0) continue;
            propErrorMap.put(bizDataCode, propErrorInfo);
        }
        return resultMap;
    }

    public Map<String, Object> validateBizDataNotUse(Map<String, Object> param) {
        QFilter statusFilter;
        QFilter notUseFilter;
        QFilter bsedFilter;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_nonrecurbizdata");
        QFilter fileIdFilter = new QFilter("salaryfile.id", "=", param.get("fileId"));
        DynamicObject[] bizDys = helper.query("bizitem.name", new QFilter[]{fileIdFilter, bsedFilter = new QFilter("bsed", "<=", param.get("bsled")), notUseFilter = new QFilter("usagecount", "=", (Object)0), statusFilter = new QFilter("auditstatus", "=", (Object)"C")});
        if (bizDys == null || bizDys.length == 0) {
            param.put("isHasNotUseBizData", Boolean.FALSE);
        } else {
            String intervalMsg = ResManager.loadKDString((String)"\uff0c", (String)"BizDataServiceHelper_13", (String)"swc-hsas-business", (Object[])new Object[0]);
            StringBuilder sb = new StringBuilder();
            for (DynamicObject biz : bizDys) {
                if (sb.length() >= 1) {
                    sb.append(intervalMsg);
                }
                sb.append(biz.getString("bizitem.name"));
            }
            param.put("notUseBizData", sb.toString());
            param.put("isHasNotUseBizData", Boolean.TRUE);
        }
        return param;
    }

    private DynamicObject[] getBizDataRecordColl(List<String> bizDataCodes, String opsystem) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bizdatarecord");
        QFilter filter = new QFilter("identifynumber", "in", bizDataCodes);
        return helper.query("id, identifynumber, usagecount, auditstatus, bsed, opsystem, salaryfile, opreason, updatetimes", new QFilter[]{filter});
    }

    public Map<Long, DynamicObject> getBizItemProp(List<Map<String, Object>> dataList) {
        HashSet<Long> bizItemPropIdSet = new HashSet<Long>(16);
        for (Map<String, Object> dataMap : dataList) {
            List propDataList = (List)dataMap.get("propdatalist");
            if (propDataList == null || propDataList.size() == 0) continue;
            for (Map propDataMap : propDataList) {
                Long propId = MapUtils.getLong((Map)propDataMap, (Object)"bizitempropid");
                if (propId == null) continue;
                bizItemPropIdSet.add(propId);
            }
        }
        if (bizItemPropIdSet.size() == 0) {
            return new HashMap<Long, DynamicObject>(16);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitemprop");
        String field = "id,name,number,datatype.id,datatype.storagetype,datalength,scalelimit,isminvalnull,minvalue,ismaxvalnull,maxvalue,earliestdate,lastdate";
        QFilter filter = new QFilter("id", "in", bizItemPropIdSet);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        DynamicObjectCollection propColl = helper.queryOriginalCollection(field, new QFilter[]{filter});
        if (propColl == null || propColl.size() == 0) {
            return new HashMap<Long, DynamicObject>(16);
        }
        HashMap<Long, DynamicObject> retMap = new HashMap<Long, DynamicObject>(propColl.size());
        for (DynamicObject propObj : propColl) {
            retMap.put(propObj.getLong("id"), propObj);
        }
        return retMap;
    }

    public List<Map<String, Object>> getBizItemInfoByNumbers(String bizItemNumbers) {
        String[] bizItemNumberArray = bizItemNumbers.split(",");
        ArrayList<Map<String, Object>> retBizItemImfoList = new ArrayList<Map<String, Object>>(bizItemNumberArray.length);
        this.batchGetBizItemInfo(Arrays.asList(bizItemNumberArray), retBizItemImfoList);
        return retBizItemImfoList;
    }

    private void batchGetBizItemInfo(List<String> bizItemNumberList, List<Map<String, Object>> retBizItemImfoList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitem");
        String field = "id,number,name,createorg.id,createorg.number,createorg.name,ctrlstrategy,areatype,country.id,country.number,country.name,bizitemcategory.id,bizitemcategory.number,bizitemcategory.name,datatype.id,datatype.number,datatype.name,cycle,bizitempropentry,bizitempropentry.bizitemprop,bizitempropentry.bizitemprop.id,bizitempropentry.bizitemprop.number,bizitempropentry.bizitemprop.name,issalarystd,multipleinput,maxinputtime,datalength,scalelimit,minvalue,maxvalue,earliestdate,lastdate,currency.fbasedataid.id,currency.fbasedataid.number,currency.fbasedataid.name,consumemethod,oneoffconsume,islistgenerate,status,enable";
        QFilter filter = new QFilter("number", "in", bizItemNumberList);
        DynamicObject[] queryBizItemInfos = helper.query(field, new QFilter[]{filter});
        if (queryBizItemInfos == null || queryBizItemInfos.length == 0) {
            return;
        }
        for (DynamicObject bizItemObj : queryBizItemInfos) {
            DynamicObjectCollection propEntryColl;
            Date lastdate;
            Date earliestdate;
            HashMap<String, Object> bizItemMap = new HashMap<String, Object>(30);
            bizItemMap.put("bizitemid", bizItemObj.getLong("id"));
            bizItemMap.put("bizitemnumber", bizItemObj.getString("number"));
            bizItemMap.put("bizitemname", bizItemObj.getString("name"));
            bizItemMap.put("createorgid", bizItemObj.getLong("createorg.id"));
            bizItemMap.put("createorgnumber", bizItemObj.getString("createorg.number"));
            bizItemMap.put("createorgname", bizItemObj.getString("createorg.name"));
            bizItemMap.put("ctrlstrategy", bizItemObj.getString("ctrlstrategy"));
            bizItemMap.put("areatype", bizItemObj.getString("areatype"));
            bizItemMap.put("countryid", bizItemObj.getLong("country.id"));
            bizItemMap.put("countrynumber", bizItemObj.getString("country.number"));
            bizItemMap.put("countryname", bizItemObj.getString("country.name"));
            bizItemMap.put("bizitemcategoryid", bizItemObj.getLong("bizitemcategory.id"));
            bizItemMap.put("bizitemcategorynumber", bizItemObj.getString("bizitemcategory.number"));
            bizItemMap.put("bizitemcategoryname", bizItemObj.getString("bizitemcategory.name"));
            bizItemMap.put("datatypeid", bizItemObj.getLong("datatype.id"));
            bizItemMap.put("datatypenumber", bizItemObj.getString("datatype.number"));
            bizItemMap.put("datatypename", bizItemObj.getString("datatype.name"));
            String cycle = bizItemObj.getString("cycle");
            if (SWCStringUtils.equals((String)cycle, (String)"0")) {
                bizItemMap.put("cycle", Boolean.FALSE);
            } else {
                bizItemMap.put("cycle", Boolean.TRUE);
            }
            bizItemMap.put("issalarystd", bizItemObj.getString("issalarystd"));
            bizItemMap.put("multipleinput", bizItemObj.getString("multipleinput"));
            bizItemMap.put("maxinputtime", bizItemObj.getInt("maxinputtime"));
            bizItemMap.put("datalength", bizItemObj.getInt("datalength"));
            String scalelimit = bizItemObj.getString("scalelimit");
            if (SWCStringUtils.isNotEmpty((String)scalelimit)) {
                Object maxValObj;
                int scale = Integer.parseInt(scalelimit);
                Object minValObj = bizItemObj.get("minvalue");
                if (minValObj != null) {
                    BigDecimal minVal = (BigDecimal)minValObj;
                    bizItemMap.put("inputminval", minVal.setScale(scale, 4));
                }
                if ((maxValObj = bizItemObj.get("maxvalue")) != null) {
                    BigDecimal maxVal = (BigDecimal)maxValObj;
                    bizItemMap.put("inputmaxval", maxVal.setScale(scale, 4));
                }
            }
            if ((earliestdate = bizItemObj.getDate("earliestdate")) != null) {
                bizItemMap.put("earliestdate", SWCDateTimeUtils.format((Date)earliestdate, (String)"yyyy-MM-dd"));
            }
            if ((lastdate = bizItemObj.getDate("lastdate")) != null) {
                bizItemMap.put("lastdate", SWCDateTimeUtils.format((Date)lastdate, (String)"yyyy-MM-dd"));
            }
            bizItemMap.put("consumemethod", bizItemObj.getString("consumemethod"));
            bizItemMap.put("oneoffconsume", bizItemObj.getString("oneoffconsume"));
            bizItemMap.put("islistgenerate", bizItemObj.getString("islistgenerate"));
            bizItemMap.put("status", bizItemObj.getString("status"));
            bizItemMap.put("enable", bizItemObj.getString("enable"));
            DynamicObjectCollection currencyColl = bizItemObj.getDynamicObjectCollection("currency");
            if (currencyColl != null && currencyColl.size() > 0) {
                ArrayList currencyList = new ArrayList(currencyColl.size());
                for (DynamicObject currencyObj : currencyColl) {
                    HashMap<String, Object> currencyMap = new HashMap<String, Object>(5);
                    currencyMap.put("currencyid", currencyObj.getLong("fbasedataid.id"));
                    currencyMap.put("currencynumber", currencyObj.getString("fbasedataid.number"));
                    currencyMap.put("currencyname", currencyObj.getString("fbasedataid.name"));
                    currencyList.add(currencyMap);
                }
                bizItemMap.put("currencylist", currencyList);
            }
            if ((propEntryColl = bizItemObj.getDynamicObjectCollection("bizitempropentry")) != null && propEntryColl.size() > 0) {
                ArrayList propList = new ArrayList(propEntryColl.size());
                for (DynamicObject propEntryObj : propEntryColl) {
                    DynamicObject bizItemPropObj = propEntryObj.getDynamicObject("bizitemprop");
                    if (SWCObjectUtils.isEmpty((Object)bizItemPropObj)) continue;
                    HashMap<String, Object> propMap = new HashMap<String, Object>(5);
                    propMap.put("bizitempropid", bizItemPropObj.getLong("id"));
                    propMap.put("bizitempropnumber", bizItemPropObj.getString("number"));
                    propMap.put("bizitempropname", bizItemPropObj.getString("name"));
                    propList.add(propMap);
                }
                bizItemMap.put("bizitemproplist", propList);
            }
            retBizItemImfoList.add(bizItemMap);
        }
    }

    public Map<String, Long> buildBaseDataIdAndNumberRelation(String entityName, List<String> numberList, List<QFilter> filterList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        String field = "id,number";
        ArrayList<QFilter> queryList = new ArrayList<QFilter>(10);
        QFilter filter = new QFilter("number", "in", numberList);
        queryList.add(filter);
        if (filterList != null && filterList.size() > 0) {
            queryList.addAll(filterList);
        }
        HashMap<String, Long> retMap = new HashMap<String, Long>(16);
        QFilter[] filters = new QFilter[queryList.size()];
        queryList.toArray(filters);
        DynamicObjectCollection dataColl = helper.queryOriginalCollection(field, filters);
        if (dataColl == null || dataColl.size() == 0) {
            return retMap;
        }
        for (DynamicObject dataObj : dataColl) {
            Long id = dataObj.getLong("id");
            String number = dataObj.getString("number");
            retMap.put(number, id);
        }
        return retMap;
    }

    public Set<Long> buildSalaryFileIdAndNumberRelation(String entityName, String number, List<QFilter> otherFilterList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        String field = "id,number";
        ArrayList<QFilter> queryList = new ArrayList<QFilter>(10);
        QFilter filter = new QFilter("number", "=", (Object)number);
        if (otherFilterList != null && otherFilterList.size() > 0) {
            for (QFilter qFilter : otherFilterList) {
                filter.and(qFilter);
            }
        }
        filter.and("iscurrentversion", "=", (Object)"1");
        queryList.add(filter);
        HashSet<Long> retSet = new HashSet<Long>(16);
        QFilter[] filters = new QFilter[queryList.size()];
        queryList.toArray(filters);
        DynamicObjectCollection dataColl = helper.queryOriginalCollection(field, filters);
        if (dataColl == null || dataColl.size() == 0) {
            return retSet;
        }
        for (DynamicObject dataObj : dataColl) {
            Long id = dataObj.getLong("id");
            retSet.add(id);
        }
        return retSet;
    }

    public List<Map<String, Object>> getPayRollGroupsInfo(Long orgId, Long countryId) {
        this.log.info("getPayRollGroupsInfo orgId is {}, countryId is {}", (Object)orgId, (Object)countryId);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrp");
        String field = "boid,org.id,org.number,org.name,country.id,country.number,country.name,currency.id,currency.number,currency.name";
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and("iscurrentversion", "=", (Object)"1");
        if (orgId != null && orgId != 0L) {
            filter.and("org.id", "=", (Object)orgId);
        }
        if (countryId != null && countryId != 0L) {
            filter.and("country.id", "=", (Object)countryId);
        }
        this.log.info("getPayRollGroupsInfo filter is:{}", (Object)filter.toString());
        DynamicObjectCollection dataColl = helper.queryOriginalCollection(field, new QFilter[]{filter}, "index asc");
        if (dataColl == null || dataColl.size() == 0) {
            return null;
        }
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(dataColl.size());
        for (DynamicObject dataObj : dataColl) {
            HashMap<String, Object> retMap = new HashMap<String, Object>(16);
            retMap.put("boid", dataObj.getLong("boid"));
            retMap.put("orgid", dataObj.getLong("org.id"));
            retMap.put("orgnumber", dataObj.getString("org.number"));
            retMap.put("orgname", dataObj.getString("org.name"));
            retMap.put("countryid", dataObj.getLong("country.id"));
            retMap.put("countrynumber", dataObj.getString("country.number"));
            retMap.put("countryname", dataObj.getString("country.name"));
            retMap.put("currencyid", dataObj.getLong("currency.id"));
            retMap.put("currencynumber", dataObj.getString("currency.number"));
            retMap.put("currencyname", dataObj.getString("currency.name"));
            retList.add(retMap);
        }
        return retList;
    }

    public Map<Long, Long> getEmployeeIdByDepempIds(Set<Long> depempIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hrpi_depemp");
        QFilter filter = new QFilter("id", "in", depempIds);
        DynamicObject[] datas = helper.query("id,employee.id", new QFilter[]{filter});
        HashMap<Long, Long> retMap = new HashMap<Long, Long>(16);
        if (datas == null || datas.length == 0) {
            return retMap;
        }
        for (DynamicObject dataObj : datas) {
            retMap.put(dataObj.getLong("id"), dataObj.getLong("employee.id"));
        }
        return retMap;
    }

    private Map<String, DynamicObject> getLatestBsledRecord(Set<String> relatedBizDataCodes, String opType) {
        HashMap<String, DynamicObject> latestRelatedDataMap = new HashMap<String, DynamicObject>(16);
        if (CollectionUtils.isEmpty(relatedBizDataCodes)) {
            return latestRelatedDataMap;
        }
        SWCDataServiceHelper bsledHelper = new SWCDataServiceHelper("hsas_bizdatabsledrecord");
        QFilter filter = new QFilter("bizdatacode", "in", relatedBizDataCodes);
        if (SWCStringUtils.isNotEmpty((String)opType)) {
            filter.and("optype", "=", (Object)opType);
        }
        filter.and("isabandon", "!=", (Object)"1");
        String orderBy = "createtime desc";
        String queryField = "bizdatacode,opbizdatacode,beforebsled,afterbsled,optype,isabandon";
        Object[] bsledRecordDatas = bsledHelper.query(queryField, new QFilter[]{filter}, orderBy);
        if (SWCArrayUtils.isEmpty((Object[])bsledRecordDatas)) {
            return latestRelatedDataMap;
        }
        for (Object record : bsledRecordDatas) {
            String bizDataCode = record.getString("bizdatacode");
            if (latestRelatedDataMap.containsKey(bizDataCode)) continue;
            latestRelatedDataMap.put(bizDataCode, (DynamicObject)record);
        }
        return latestRelatedDataMap;
    }

    public Map<String, Object> getSalaryFileIdByPayRollGrpId(Map<String, Object> params) {
        HashMap<String, Object> responseMap = new HashMap<String, Object>(16);
        responseMap.put("sueecss", "1");
        List personIdList = (List)params.get("personIdList");
        if (personIdList == null || personIdList.size() == 0) {
            responseMap.put("sueecss", "0");
            responseMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1160.getCode());
            responseMap.put("message", BizDataFailStatusEnum.FAILSTATUS_1160.getDesc());
            return responseMap;
        }
        Long payRollGroupId = (Long)params.get("payRollGroupId");
        if (payRollGroupId == null) {
            responseMap.put("sueecss", "0");
            responseMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1161.getCode());
            responseMap.put("message", BizDataFailStatusEnum.FAILSTATUS_1161.getDesc());
            return responseMap;
        }
        BizDataHelper bizDataHelper = new BizDataHelper();
        responseMap.put("data", bizDataHelper.getSalaryFileIdByPayRollGrpId(new HashSet<Long>(personIdList), payRollGroupId));
        return responseMap;
    }
}

