/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.calreport.helper;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.swc.hsas.business.cal.calreport.dto.CalDetailExportDto;
import kd.swc.hsas.business.cal.export.SWCExportDataHelper;
import kd.swc.hsas.common.constants.CalTableExportProgressConstants;
import kd.swc.hsas.common.utils.TaskUtil;
import kd.swc.hsas.common.vo.CalTableExportProgressInfo;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class CalDetailExportHelper {
    private static final Log logger = LogFactory.getLog(CalDetailExportHelper.class);
    private static final String SYSTEM_NAME = "swc-hsas-business";
    private static final int CONTENT_ROW_START_LINE = 1;
    private static final String PROGRESS = "progress";
    private static final String COMPLETE = "complete";

    public Map<String, String> getCalMessageExportHeaders() {
        LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>(16);
        headerMap.put("filenumber", ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7", (String)"CalDetailExportHelper_1", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"CalDetailExportHelper_2", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("empnumber", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"CalDetailExportHelper_3", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("formula", ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f", (String)"CalDetailExportHelper_21", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("message", ResManager.loadKDString((String)"\u6d88\u606f\u6587\u672c", (String)"CalDetailExportHelper_22", (String)SYSTEM_NAME, (Object[])new Object[0]));
        return headerMap;
    }

    public Map<String, String> getExportHeaders() {
        LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>(16);
        headerMap.put("salaryfilenumber", ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7", (String)"CalDetailExportHelper_1", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("salaryfileemployeeshowname", ResManager.loadKDString((String)"\u59d3\u540d", (String)"CalDetailExportHelper_2", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("salaryfileemployeeempnumber", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"CalDetailExportHelper_3", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("calstatus", ResManager.loadKDString((String)"\u8ba1\u7b97\u72b6\u6001", (String)"CalDetailExportHelper_4", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("failtype", ResManager.loadKDString((String)"\u5931\u8d25\u7c7b\u578b", (String)"CalDetailExportHelper_5", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("errorelement", ResManager.loadKDString((String)"\u51fa\u9519\u5143\u7d20", (String)"CalDetailExportHelper_6", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("failmsg", ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0", (String)"CalDetailExportHelper_7", (String)SYSTEM_NAME, (Object[])new Object[0]));
        return headerMap;
    }

    public void mutiThreadExport(RequestContext ctx, String fileName, Map<String, String> headers, int totalPages, QFilter[] filters, CountDownLatch countDownLatch, IFormView view, int totalElements, String downLoadTaskId) {
        CalTableExportProgressInfo progressInfo = new CalTableExportProgressInfo();
        ThreadPools.executeOnce((String)"EXPORT_EXCEL_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            logger.info("starting export data: {}", (Object)stopWatch.toString());
            try (SXSSFWorkbook wb = new SXSSFWorkbook(CalTableExportProgressConstants.ROW_ACCESS_WINDOWS_SIZE);){
                SXSSFSheet sheet = wb.createSheet();
                sheet.setRandomAccessWindowSize(-1);
                wb.setSheetName(0, fileName);
                this.write2ExportHead(sheet, headers);
                ReentrantLock lock = new ReentrantLock();
                int pageIndex = 0;
                while (pageIndex < totalPages) {
                    int currentPage = pageIndex++;
                    SWCThreadPoolFactory.getCommonExportThreadpool().execute(() -> {
                        try {
                            RequestContext.copyAndSet((RequestContext)ctx);
                            List<Map<String, Object>> data = this.getExportData(filters, currentPage, CalTableExportProgressConstants.PAGE_SIZE);
                            lock.lock();
                            this.createContentColumn(sheet, currentPage * CalTableExportProgressConstants.PAGE_SIZE + 1, data, headers);
                        }
                        catch (Exception e) {
                            logger.error("CalTableExportPlugin.doExportAll.error. ", (Throwable)e);
                        }
                        finally {
                            lock.unlock();
                            countDownLatch.countDown();
                            SWCPageCache pageCache = new SWCPageCache(view);
                            double percent = (double)((long)totalPages - countDownLatch.getCount()) * 100.0 / (double)totalPages;
                            double progress = BigDecimal.valueOf(percent).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
                            long complete = 0L;
                            complete = totalElements < 100 ? (long)totalElements : ((long)totalPages - countDownLatch.getCount()) * (long)CalTableExportProgressConstants.PAGE_SIZE.intValue();
                            pageCache.put(PROGRESS + downLoadTaskId, (Object)progress);
                            pageCache.put(COMPLETE + downLoadTaskId, (Object)complete);
                            pageCache.saveChanges();
                            TaskUtil.addTaskInfoToCache((CalTableExportProgressInfo)progressInfo, (int)totalElements, (Double)progress, (int)((int)complete), (String)downLoadTaskId);
                        }
                    });
                }
                if (countDownLatch.await(10L, TimeUnit.MINUTES)) {
                    this.flushAll(headers, sheet, fileName, totalPages, stopWatch, countDownLatch, downLoadTaskId, progressInfo, totalElements, view);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        });
    }

    private void flushAll(Map<String, String> headers, SXSSFSheet sheet, String fileName, int totalPages, StopWatch stopWatch, CountDownLatch countDownLatch, String downLoadTaskId, CalTableExportProgressInfo progressInfo, int totalElements, IFormView view) throws IOException {
        List<Map<String, String>> headList = SWCExportDataHelper.HeadMapToListMap(headers);
        for (int i = 0; i < headList.size(); ++i) {
            int columnWidth = sheet.getColumnWidth(i);
            sheet.setColumnWidth(i, columnWidth * 4);
        }
        String url = SWCExportDataHelper.writeFile(sheet.getWorkbook(), fileName);
        SWCPageCache pageCache = new SWCPageCache(view);
        Double percent = totalPages <= 0 ? Double.valueOf(100.0) : Double.valueOf((double)((long)totalPages - countDownLatch.getCount()) * 100.0 / (double)totalPages);
        if (percent.intValue() >= 100) {
            pageCache.put("url" + downLoadTaskId, (Object)url);
            pageCache.put(PROGRESS + downLoadTaskId, (Object)percent);
            pageCache.put(COMPLETE + downLoadTaskId, (Object)totalElements);
            pageCache.saveChanges();
            progressInfo.setUrl(url);
        }
        double progress = BigDecimal.valueOf(percent).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
        TaskUtil.addTaskInfoToCache((CalTableExportProgressInfo)progressInfo, (int)totalElements, (Double)progress, (int)totalElements, (String)downLoadTaskId);
        stopWatch.stop();
        logger.info("ending export data: {},countdown: {}", (Object)stopWatch.toString(), (Object)countDownLatch.getCount());
    }

    private void createContentColumn(SXSSFSheet sheet, Integer beginIndex, List<Map<String, Object>> exportDataList, Map<String, String> headMap) {
        if (exportDataList.isEmpty()) {
            return;
        }
        for (int rowIndex = beginIndex.intValue(); rowIndex < exportDataList.size() + beginIndex; ++rowIndex) {
            SXSSFRow contentRow = sheet.createRow(rowIndex);
            Map<String, Object> exportDataMap = null;
            exportDataMap = exportDataList.get(rowIndex - beginIndex);
            int columnIndex = 0;
            for (Map.Entry<String, String> entry : headMap.entrySet()) {
                SXSSFCell columnCell = contentRow.createCell(columnIndex);
                String key = entry.getKey();
                Object value = exportDataMap.get(key);
                if (SWCStringUtils.equals((String)key, (String)"calstatus") || SWCStringUtils.equals((String)key, (String)"failtype")) {
                    value = this.getCalStatus(key, value);
                }
                String dataType = "text";
                CalDetailExportHelper.parseCellValue(columnCell, value, dataType);
                columnCell.setCellType(CalDetailExportHelper.getCellType(dataType));
                ++columnIndex;
            }
        }
    }

    private String getCalStatus(String key, Object value) {
        String retStr = "";
        if (SWCStringUtils.equals((String)key, (String)"calstatus")) {
            String strVal = String.valueOf(value);
            if (SWCStringUtils.equals((String)strVal, (String)"1")) {
                retStr = ResManager.loadKDString((String)"\u6210\u529f", (String)"CalDetailExportHelper_8", (String)SYSTEM_NAME, (Object[])new Object[0]);
            } else if (SWCStringUtils.equals((String)strVal, (String)"2")) {
                retStr = ResManager.loadKDString((String)"\u5931\u8d25", (String)"CalDetailExportHelper_9", (String)SYSTEM_NAME, (Object[])new Object[0]);
            } else if (SWCStringUtils.equals((String)strVal, (String)"3")) {
                retStr = ResManager.loadKDString((String)"\u7ec8\u6b62", (String)"CalDetailExportHelper_10", (String)SYSTEM_NAME, (Object[])new Object[0]);
            }
        } else if (SWCStringUtils.equals((String)key, (String)"failtype")) {
            String strVal = String.valueOf(value);
            if (SWCStringUtils.equals((String)strVal, (String)"1")) {
                retStr = ResManager.loadKDString((String)"\u89e3\u6790\u5931\u8d25", (String)"CalDetailExportHelper_11", (String)SYSTEM_NAME, (Object[])new Object[0]);
            } else if (SWCStringUtils.equals((String)strVal, (String)"2")) {
                retStr = ResManager.loadKDString((String)"\u53d6\u6570\u5931\u8d25", (String)"CalDetailExportHelper_12", (String)SYSTEM_NAME, (Object[])new Object[0]);
            } else if (SWCStringUtils.equals((String)strVal, (String)"3")) {
                retStr = ResManager.loadKDString((String)"\u8ba1\u7b97\u5931\u8d25", (String)"CalDetailExportHelper_13", (String)SYSTEM_NAME, (Object[])new Object[0]);
            } else if (SWCStringUtils.equals((String)strVal, (String)"4")) {
                retStr = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"CalDetailExportHelper_14", (String)SYSTEM_NAME, (Object[])new Object[0]);
            } else if (SWCStringUtils.equals((String)strVal, (String)"5")) {
                retStr = ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25", (String)"CalDetailExportHelper_15", (String)SYSTEM_NAME, (Object[])new Object[0]);
            } else if (SWCStringUtils.equals((String)strVal, (String)"6")) {
                retStr = ResManager.loadKDString((String)"\u63a8\u9001\u4e2a\u7a0e\u5931\u8d25", (String)"CalDetailExportHelper_16", (String)SYSTEM_NAME, (Object[])new Object[0]);
            } else if (SWCStringUtils.equals((String)strVal, (String)"7")) {
                retStr = ResManager.loadKDString((String)"\u8ba1\u7b97\u4e2a\u7a0e\u5931\u8d25", (String)"CalDetailExportHelper_17", (String)SYSTEM_NAME, (Object[])new Object[0]);
            } else if (SWCStringUtils.equals((String)strVal, (String)"8")) {
                retStr = ResManager.loadKDString((String)"\u62c9\u53d6\u4e2a\u7a0e\u5931\u8d25", (String)"CalDetailExportHelper_18", (String)SYSTEM_NAME, (Object[])new Object[0]);
            } else if (SWCStringUtils.equals((String)strVal, (String)"9")) {
                retStr = ResManager.loadKDString((String)"\u8ba1\u7b97\u56de\u6eda\u5931\u8d25", (String)"CalDetailExportHelper_19", (String)SYSTEM_NAME, (Object[])new Object[0]);
            }
        }
        return retStr;
    }

    public static CellType getCellType(String dataType) {
        if (SWCStringUtils.isEmpty((String)dataType)) {
            return CellType.STRING;
        }
        if (SWCStringUtils.equals((String)dataType, (String)"num")) {
            return CellType.NUMERIC;
        }
        if (SWCStringUtils.equals((String)dataType, (String)"date")) {
            return CellType.STRING;
        }
        if (SWCStringUtils.equals((String)dataType, (String)"amount")) {
            return CellType.NUMERIC;
        }
        return CellType.STRING;
    }

    public static void parseCellValue(SXSSFCell cell, Object value, String dataType) {
        if (SWCStringUtils.equals((String)dataType, (String)"text")) {
            cell.setCellValue(value.toString());
        }
    }

    private List<Map<String, Object>> getCalMessageData(QFilter[] filters, int currentPage, int pageSize) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
        String field = "salaryfile.number, salaryfile.employee.showname, salaryfile.employee.empnumber, formula.name, message,index";
        String orderBy = "salaryfile.number asc,index asc";
        DynamicObject[] calMessageArray = BusinessDataServiceHelper.load((String)"hsas_calmessage", (String)field, (QFilter[])filters, (String)orderBy, (int)currentPage, (int)pageSize);
        LinkedHashMap<String, String> tempMap = null;
        for (DynamicObject obj : calMessageArray) {
            tempMap = new LinkedHashMap<String, String>(16);
            tempMap.put("filenumber", obj.getString("salaryfile.number"));
            tempMap.put("name", obj.getString("salaryfile.employee.showname"));
            tempMap.put("empnumber", obj.getString("salaryfile.employee.empnumber"));
            tempMap.put("formula", obj.getString("formula.name"));
            tempMap.put("message", obj.getString("message"));
            dataList.add(tempMap);
        }
        return dataList;
    }

    private List<Map<String, Object>> getExportData(QFilter[] filters, int currentPage, int pageSize) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
        String field = "salaryfile.number, salaryfile.employee.showname, salaryfile.employee.empnumber, calstatus, failtype, errorelement, failmsg";
        String orderBy = "salaryfile.number asc";
        for (DynamicObject dataObj : BusinessDataServiceHelper.load((String)"hsas_caldetail", (String)field, (QFilter[])filters, (String)orderBy, (int)currentPage, (int)pageSize)) {
            LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>(16);
            valueMap.put("salaryfilenumber", dataObj.get("salaryfile.number"));
            valueMap.put("salaryfileemployeeshowname", dataObj.get("salaryfile.employee.showname"));
            valueMap.put("salaryfileemployeeempnumber", dataObj.get("salaryfile.employee.empnumber"));
            valueMap.put("calstatus", dataObj.get("calstatus"));
            valueMap.put("failtype", dataObj.get("failtype"));
            valueMap.put("errorelement", dataObj.get("errorelement"));
            valueMap.put("failmsg", dataObj.get("failmsg"));
            dataList.add(valueMap);
        }
        return dataList;
    }

    private Sheet write2ExportHead(SXSSFSheet sheet, Map<String, String> headMap) {
        int row = 0;
        SXSSFRow headRow = sheet.createRow(row);
        SXSSFWorkbook wb = sheet.getWorkbook();
        int index = 0;
        for (Map.Entry<String, String> entry : headMap.entrySet()) {
            SXSSFCell cell = headRow.createCell(index);
            String headString = entry.getValue();
            cell.setCellValue(headString);
            CellStyle headColumnStyle = this.getHeadColumnStyle(wb);
            cell.setCellStyle(headColumnStyle);
            ++index;
        }
        return sheet;
    }

    private CellStyle getHeadColumnStyle(SXSSFWorkbook wb) {
        CellStyle headColumnStyle = wb.createCellStyle();
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderTop(BorderStyle.THIN);
        headColumnStyle.setBorderLeft(BorderStyle.THIN);
        headColumnStyle.setBorderRight(BorderStyle.THIN);
        headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setHidden(true);
        return headColumnStyle;
    }

    public void exportCalMessageData(String fileName, CalDetailExportDto dto, int totalPages, CountDownLatch countDownLatch, IFormView view, int totalElements, String downLoadTaskId) {
        logger.info("exportCalMessageData start");
        RequestContext ctx = RequestContext.get();
        Map<String, String> headers = dto.getHeaders();
        QFilter[] filters = dto.getFilters();
        CalTableExportProgressInfo progressInfo = new CalTableExportProgressInfo();
        ThreadPools.executeOnce((String)"EXPORT_EXCEL_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            logger.info("starting exportCalMessageData : {}", (Object)stopWatch.toString());
            try (SXSSFWorkbook wb = new SXSSFWorkbook(CalTableExportProgressConstants.ROW_ACCESS_WINDOWS_SIZE);){
                SXSSFSheet sheet = wb.createSheet();
                sheet.setRandomAccessWindowSize(-1);
                wb.setSheetName(0, fileName);
                this.write2ExportHead(sheet, headers);
                ReentrantLock lock = new ReentrantLock();
                int pageIndex = 0;
                while (pageIndex < totalPages) {
                    int currentPage = pageIndex++;
                    SWCThreadPoolFactory.getCommonExportThreadpool().execute(() -> {
                        try {
                            RequestContext.copyAndSet((RequestContext)ctx);
                            List<Map<String, Object>> data = this.getCalMessageData(filters, currentPage, CalTableExportProgressConstants.PAGE_SIZE);
                            lock.lock();
                            this.createContentColumn(sheet, currentPage * CalTableExportProgressConstants.PAGE_SIZE + 1, data, headers);
                        }
                        catch (Exception e) {
                            logger.error("exportCalMessageData getCalMessageData error. ", (Throwable)e);
                        }
                        finally {
                            lock.unlock();
                            countDownLatch.countDown();
                            SWCPageCache pageCache = new SWCPageCache(view);
                            double percent = (double)((long)totalPages - countDownLatch.getCount()) * 100.0 / (double)totalPages;
                            double progress = BigDecimal.valueOf(percent).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
                            long complete = 0L;
                            complete = totalElements < 100 ? (long)totalElements : ((long)totalPages - countDownLatch.getCount()) * (long)CalTableExportProgressConstants.PAGE_SIZE.intValue();
                            pageCache.put(PROGRESS + downLoadTaskId, (Object)progress);
                            pageCache.put(COMPLETE + downLoadTaskId, (Object)complete);
                            pageCache.saveChanges();
                            TaskUtil.addTaskInfoToCache((CalTableExportProgressInfo)progressInfo, (int)totalElements, (Double)progress, (int)((int)complete), (String)downLoadTaskId);
                        }
                    });
                }
                if (countDownLatch.await(10L, TimeUnit.MINUTES)) {
                    this.flushAll(headers, sheet, fileName, totalPages, stopWatch, countDownLatch, downLoadTaskId, progressInfo, totalElements, view);
                }
            }
            catch (Exception ex) {
                logger.error("exportCalMessageData error", (Throwable)ex);
            }
        });
    }
}

