/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.check;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.helper.CalTableCalHelper;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryCalCheckService {
    public String beforeCalCheck(CalPayRollTask calPayRollTask, DynamicObject taskDyObj, Map<String, Object> extParmaMap) {
        if (CalTableCalHelper.checkIsHasCalingRecord(calPayRollTask.getCalPayRollTaskId(), "1")) {
            String errMsg = ResManager.loadKDString((String)"%s\u6b63\u5728\u8ba1\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"SalaryCalCheckService_0", (String)"swc-hsas-business", (Object[])new Object[0]);
            return String.format(Locale.ROOT, errMsg, calPayRollTask.getNumber());
        }
        return this.checkCalConditionInvalid(calPayRollTask, taskDyObj, extParmaMap);
    }

    public String checkCalConditionInvalid(CalPayRollTask calPayRollTaskVo, DynamicObject taskDyObj, Map<String, Object> extParmaMap) {
        SWCDataServiceHelper calRuleHisHelper = new SWCDataServiceHelper("hsas_calrule");
        DynamicObject calRuleHisObj = taskDyObj.getDynamicObject("calrulev");
        QFilter qFilter = new QFilter("id", "=", (Object)calRuleHisObj.getLong("id"));
        DynamicObjectCollection calRuleData = calRuleHisHelper.queryOriginalCollection("id,name,calruleitementry.id,calruleitementry.salaryitem.id,calruleitementry.salaryitem.number,calruleitementry.salaryitem.name,calruleitementry.seq,calruleitementry.salaryitem.calblock,calruleitementry.salaryitem.taxtag", new QFilter[]{qFilter});
        String errorMsg = this.checkCalRuleData(calRuleData, calRuleHisObj.getString("name"));
        if (SWCStringUtils.isNotEmpty((String)errorMsg)) {
            return errorMsg;
        }
        Map<String, String> operationParam = calPayRollTaskVo.getOperationParam();
        if (SWCStringUtils.equals((String)"1", (String)calPayRollTaskVo.getOpenTaxCal()) && SWCStringUtils.isNotEmpty((String)(errorMsg = this.preCalCheck(calRuleData, taskDyObj, operationParam, extParmaMap)))) {
            return errorMsg;
        }
        operationParam.put("salaryItemCount", String.valueOf(calRuleData.size()));
        operationParam.put("calRuleHisId", String.valueOf(calRuleHisObj.getLong("id")));
        return null;
    }

    private String checkCalRuleData(DynamicObjectCollection calRuleData, String calRuleName) {
        String msg = null;
        if (calRuleData == null || calRuleData.size() == 0) {
            msg = ResManager.loadKDString((String)"\u8ba1\u7b97\u89c4\u5219\u201c%s\u201d\u6ca1\u6709\u7ef4\u62a4\u85aa\u916c\u9879\u76ee\u3002", (String)"SalaryCalCheckService_1", (String)"swc-hsas-business", (Object[])new Object[0]);
            return String.format(Locale.ROOT, msg, calRuleName);
        }
        for (DynamicObject entry : calRuleData) {
            if (null != entry.getString("calruleitementry.salaryitem.number")) continue;
            String errorMsg = ResManager.loadKDString((String)"\u8ba1\u7b97\u89c4\u5219\u201c{0}\u201d\u7684\u7b2c{1}\u884c\u5206\u5f55\u7684\u85aa\u916c\u9879\u76ee\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u8ba1\u7b97\u89c4\u5219\u3002", (String)"SalaryCalCheckService_2", (String)"swc-hsas-business", (Object[])new Object[0]);
            return MessageFormat.format(errorMsg, calRuleName, entry.getInt("calruleitementry.seq"));
        }
        return null;
    }

    private String preCalCheck(DynamicObjectCollection calRuleData, DynamicObject task, Map<String, String> operationParam, Map<String, Object> extParmaMap) {
        String msg;
        HashMap<Long, DynamicObject> taxSourceItemMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, DynamicObject> taxResultItemMap = new HashMap<Long, DynamicObject>(16);
        boolean haveNoItemForPreTax = false;
        boolean haveNoItemForAfterTax = false;
        for (DynamicObject entryObj : calRuleData) {
            if (SWCStringUtils.equals((String)entryObj.getString("calruleitementry.salaryitem.taxtag"), (String)"1")) {
                taxSourceItemMap.put(entryObj.getLong("calruleitementry.salaryitem.id"), entryObj);
                continue;
            }
            if (SWCStringUtils.equals((String)entryObj.getString("calruleitementry.salaryitem.taxtag"), (String)"2")) {
                taxResultItemMap.put(entryObj.getLong("calruleitementry.salaryitem.id"), entryObj);
                continue;
            }
            if (SWCStringUtils.equals((String)entryObj.getString("calruleitementry.salaryitem.calblock"), (String)"0")) {
                haveNoItemForPreTax = true;
                continue;
            }
            haveNoItemForAfterTax = true;
        }
        if (!haveNoItemForPreTax || !haveNoItemForAfterTax || taxSourceItemMap.size() == 0 || taxResultItemMap.size() == 0) {
            String msg2 = ResManager.loadKDString((String)"\u8ba1\u7b97\u89c4\u5219\u201c{0}\u201d\u4e2d\uff0c\u81f3\u5c11\u5305\u542b\u4e00\u4e2a\u7a0e\u524d\u7684\u975e\u4e2a\u7a0e\u9879\u76ee\u3001\u7a0e\u524d\u7684\u4e2a\u7a0e\u6e90\u9879\u76ee\u3001\u7a0e\u540e\u7684\u4e2a\u7a0e\u7ed3\u679c\u9879\u76ee\u3001\u7a0e\u540e\u7684\u975e\u4e2a\u7a0e\u9879\u76ee\u3002", (String)"SalaryCalCheckService_3", (String)"swc-hsas-business", (Object[])new Object[]{((DynamicObject)calRuleData.get(0)).getString("name")});
            return msg2;
        }
        long taxItemSchemeVid = task.getLong("taxitemschemev.id");
        if (taxItemSchemeVid != 0L) {
            operationParam.put("TAXITEMSCHEMEVID", String.valueOf(taxItemSchemeVid));
        }
        if (SWCStringUtils.isNotEmpty((String)(msg = this.checkTaxItemSchema(task, taxSourceItemMap, taxResultItemMap, operationParam, extParmaMap)))) {
            return msg;
        }
        return null;
    }

    private String checkTaxItemSchema(DynamicObject task, Map<Long, DynamicObject> taxSourceItemMap, Map<Long, DynamicObject> taxResultItemMap, Map<String, String> operationParam, Map<String, Object> extParmaMap) {
        DynamicObject taxProjectSchObj = this.matchTaxProjSchemeHis(task.getLong("org.id"), task.getLong("country.id"), task.getDate("enddate"));
        if (taxProjectSchObj == null) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u4efb\u52a1\u65e0\u5bf9\u5e94\u4e2a\u7a0e\u9879\u76ee\u6620\u5c04\u65b9\u6848\u3002", (String)"SalaryCalCheckService_4", (String)"swc-hsas-business", (Object[])new Object[0]);
        }
        DynamicObjectCollection salaryMapEntry = taxProjectSchObj.getDynamicObjectCollection("salarymapentry");
        DynamicObjectCollection taxMapEntry = taxProjectSchObj.getDynamicObjectCollection("taxmapentry");
        List preItemIdList = salaryMapEntry.stream().map(salaryMap -> salaryMap.getLong("presalaryitem.id")).collect(Collectors.toList());
        List afterItemIdList = taxMapEntry.stream().map(salaryMap -> salaryMap.getLong("aftersalaryitem.id")).collect(Collectors.toList());
        boolean isMatch = true;
        ArrayList<String> failList = new ArrayList<String>(10);
        for (Map.Entry<Long, DynamicObject> sourceEntry : taxSourceItemMap.entrySet()) {
            if (preItemIdList.contains(sourceEntry.getKey())) continue;
            isMatch = false;
            failList.add(sourceEntry.getValue().getString("calruleitementry.salaryitem.number") + "\uff1a" + sourceEntry.getValue().getString("calruleitementry.salaryitem.name"));
        }
        for (Map.Entry<Long, DynamicObject> resultEntry : taxResultItemMap.entrySet()) {
            if (afterItemIdList.contains(resultEntry.getKey())) continue;
            isMatch = false;
            failList.add(resultEntry.getValue().getString("calruleitementry.salaryitem.number") + "\uff1a" + resultEntry.getValue().getString("calruleitementry.salaryitem.name"));
        }
        if (!isMatch) {
            String title = MessageFormat.format(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u4efb\u52a1\u5bf9\u5e94\u7684\u4e2a\u7a0e\u9879\u76ee\u6620\u5c04\u65b9\u6848\u201c{0}\u201d\u672a\u5305\u542b\u4ee5\u4e0b\u4e2a\u7a0e\u6e90\u9879\u76ee/\u4e2a\u7a0e\u7ed3\u679c\u9879\u76ee\u3002", (String)"SalaryCalCheckService_6", (String)"swc-hsas-business", (Object[])new Object[0]), taxProjectSchObj.getString("name"));
            extParmaMap.put("isShowForm", Boolean.TRUE);
            extParmaMap.put("title", title);
            extParmaMap.put("failList", failList);
            Set failParamSet = failList.stream().collect(Collectors.toSet());
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u4efb\u52a1\u5bf9\u5e94\u7684\u4e2a\u7a0e\u9879\u76ee\u6620\u5c04\u65b9\u6848\u201c{0}\u201d\u672a\u5305\u542b\u4ee5\u4e0b\u4e2a\u7a0e\u6e90\u9879\u76ee/\u4e2a\u7a0e\u7ed3\u679c\u9879\u76ee:{1}\u3002", (String)"SalaryCalCheckService_7", (String)"swc-hsas-business", (Object[])new Object[0]), taxProjectSchObj.getString("name"), SWCListUtils.join(failParamSet, (String)","));
            return msg;
        }
        operationParam.put("TAXITEMSCHEMEVID", String.valueOf(taxProjectSchObj.getLong("id")));
        return null;
    }

    private DynamicObject matchTaxProjSchemeHis(long orgId, long countryId, Date endDate) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_taxprojscheme");
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("country", "=", (Object)countryId);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        DynamicObject[] taxProjSchObjArray = helper.query("id", new QFilter[]{filter});
        if (taxProjSchObjArray.length == 0) {
            return null;
        }
        DynamicObject taxProjSch = taxProjSchObjArray[0];
        QFilter qFilter = new QFilter("boid", "=", (Object)taxProjSch.getLong("id"));
        qFilter.and("bsed", "<", (Object)endDate);
        qFilter.and("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        BaseDataHisHelper.addHisVerFilter((QFilter)filter);
        return helper.queryOne("id,name,salarymapentry,presalaryitem,taxmapentry,aftersalaryitem", new QFilter[]{qFilter}, "bsed desc");
    }
}

