/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.export;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.swc.hsbp.business.url.SWCURLHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class SWCExportDataHelper {
    private static final String EXCEL_SUFFIX = ".xlsx";
    private static final Object DATATYPE = "dataType";
    private static Log logger = LogFactory.getLog(SWCExportDataHelper.class);
    private static List<String> hideField = new ArrayList<String>();

    private SWCExportDataHelper() {
    }

    public static List<Map<String, String>> HeadMapToListMap(Map<String, String> headData) {
        LinkedList<Map<String, String>> list = new LinkedList<Map<String, String>>();
        for (Map.Entry<String, String> entry : headData.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (hideField.indexOf(key) >= 0) continue;
            HashMap<String, String> temp = new HashMap<String, String>();
            temp.put("key", key);
            temp.put("value", value);
            list.add(temp);
        }
        return list;
    }

    public static String getCellStyleKey(Map<String, Object> itemInfoMap, String sign) {
        StringBuilder keyBuilder = new StringBuilder();
        String dataType = "";
        Integer scale = 0;
        String format = "";
        if (null == itemInfoMap) {
            dataType = "text";
        } else {
            dataType = (String)itemInfoMap.get(DATATYPE);
            scale = (Integer)itemInfoMap.get("scale");
            format = (String)itemInfoMap.get("format");
        }
        if (SWCStringUtils.isEmpty((String)dataType)) {
            dataType = "text";
        }
        keyBuilder.append(dataType);
        keyBuilder.append('#');
        keyBuilder.append(scale);
        keyBuilder.append('#');
        keyBuilder.append(sign);
        keyBuilder.append('#');
        keyBuilder.append(format);
        return keyBuilder.toString();
    }

    public static CellType getCellType(String dataType) {
        if (SWCStringUtils.isEmpty((String)dataType)) {
            return CellType.STRING;
        }
        if (SWCStringUtils.equals((String)dataType, (String)"num")) {
            return CellType.NUMERIC;
        }
        if (SWCStringUtils.equals((String)dataType, (String)"date")) {
            return CellType.STRING;
        }
        if (SWCStringUtils.equals((String)dataType, (String)"amount")) {
            return CellType.NUMERIC;
        }
        return CellType.STRING;
    }

    private static void getDateCellStyle(SXSSFWorkbook wb, CellStyle cellStyle, String formatStr) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        DataFormat format = wb.createDataFormat();
        cellStyle.setDataFormat(format.getFormat(formatStr));
    }

    private static void getStringCellStyle(SXSSFWorkbook wb, CellStyle cellStyle) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        DataFormat format = wb.createDataFormat();
        String styleStr = "@";
        cellStyle.setDataFormat(format.getFormat(styleStr));
    }

    private static void getNumberCellStyle(SXSSFWorkbook wb, CellStyle cellStyle, int scale) {
        DataFormat format = wb.createDataFormat();
        String styleStr = "#,##0";
        StringBuilder sb = new StringBuilder(styleStr);
        if (scale > 0) {
            sb.append('.');
            for (int i = 0; i < scale; ++i) {
                sb.append('0');
            }
        }
        cellStyle.setDataFormat(format.getFormat(sb.toString()));
    }

    private static void getAmountCellStyle(SXSSFWorkbook wb, CellStyle cellStyle, String sign, int scale) {
        if (SWCStringUtils.isEmpty((String)sign)) {
            sign = "";
        }
        DataFormat format = wb.createDataFormat();
        String styleStr = sign + "#,##0";
        StringBuilder sb = new StringBuilder(styleStr);
        if (scale > 0) {
            sb.append('.');
            for (int i = 0; i < scale; ++i) {
                sb.append('0');
            }
        }
        cellStyle.setDataFormat(format.getFormat(sb.toString()));
    }

    public static CellStyle getDefaultCellStyle(Map<String, Object> itemInfoMap, String sign, SXSSFWorkbook wb) {
        String dataType = "";
        Integer scale = 0;
        String format = "";
        CellStyle cellStyle = wb.createCellStyle();
        if (null == itemInfoMap) {
            dataType = "text";
        } else {
            dataType = (String)itemInfoMap.get(DATATYPE);
            scale = (Integer)itemInfoMap.get("scale");
            format = (String)itemInfoMap.get("format");
        }
        if (SWCStringUtils.isEmpty((String)dataType)) {
            dataType = "text";
        }
        if (SWCStringUtils.equals((String)dataType, (String)"num")) {
            SWCExportDataHelper.getNumberCellStyle(wb, cellStyle, scale);
        } else if (SWCStringUtils.equals((String)dataType, (String)"date")) {
            SWCExportDataHelper.getDateCellStyle(wb, cellStyle, format);
        } else if (SWCStringUtils.equals((String)dataType, (String)"amount")) {
            SWCExportDataHelper.getAmountCellStyle(wb, cellStyle, sign, scale);
        } else {
            SWCExportDataHelper.getStringCellStyle(wb, cellStyle);
        }
        return cellStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(SXSSFWorkbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            fileName = fileName + EXCEL_SUFFIX;
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
            return string;
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            String string = "";
            return string;
        }
        finally {
            if (null != outStream) {
                outStream.close();
            }
            if (null != inStream) {
                inStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String safeWriteFile(SXSSFWorkbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            fileName = fileName + EXCEL_SUFFIX;
            String downloadUrl = SWCExportDataHelper.getDownLoadUrl(inStream, fileName);
            String string = SWCURLHelper.getSafeUrl((String)"hsas", (String)"hsas_bizdatarecord", (String)downloadUrl);
            return string;
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            String string = "";
            return string;
        }
        finally {
            if (null != outStream) {
                outStream.close();
            }
            if (null != inStream) {
                inStream.close();
            }
        }
    }

    private static String getDownLoadUrl(InputStream inStream, String fileName) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        RequestContext requestContext = RequestContext.get();
        String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)"bizDataRecordExport", (String)fileName);
        FileItem item = new FileItem(fileName, pathParam, inStream);
        String path = fileService.upload(item);
        return UrlService.getAttachmentFullUrl((String)path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String storeFile(Workbook wb, String fileName) {
        String string;
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            fileName = fileName + EXCEL_SUFFIX;
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            RequestContext requestContext = RequestContext.get();
            String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)"salaryFile", (String)fileName);
            String path = fileService.upload(new FileItem(fileName, pathParam, (InputStream)inStream));
            string = UrlService.getAttachmentFullUrl((String)path);
            SWCExportDataHelper.closeSafely(outStream, inStream);
        }
        catch (Exception e) {
            String string2 = null;
            return string2;
        }
        try {
            wb.close();
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
        finally {
            SWCExportDataHelper.closeSafely(outStream, inStream);
            try {
                wb.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void closeSafely(OutputStream os, InputStream in) {
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        hideField.add("oricurrency");
        hideField.add("calcurrency");
        hideField.add("payrollcurrency");
    }
}

