/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.helper;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.cal.vo.CalPayRollTaskContext;
import kd.swc.hsas.common.vo.CalPayRollTaskProcessVO;
import kd.swc.hsas.common.vo.CalProcessVO;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalPayRollTaskCalHelper {
    private static Log log = LogFactory.getLog(CalPayRollTaskCalHelper.class);
    public static final String CAL_PAY_ROLL_TASK_PROCESS_PARAMS = "params";

    public static FormShowParameter getCalTaskConfirmFormShowParamter(long calPayRollTaskCounts) {
        FormShowParameter formShowParameter;
        if (calPayRollTaskCounts == 1L) {
            String caption = ResManager.loadKDString((String)"\u8ba1\u7b97\u65b9\u5f0f\u786e\u8ba4", (String)"CalPayRollTaskCalHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]);
            formShowParameter = CalPayRollTaskCalHelper.getModalFormShowParameter("hsas_calmodeconfirm", caption);
        } else {
            String caption = ResManager.loadKDString((String)"\u8ba1\u7b97\u786e\u8ba4", (String)"CalPayRollTaskCalHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]);
            formShowParameter = CalPayRollTaskCalHelper.getModalFormShowParameter("hsas_caltaskconfirm", caption);
        }
        return formShowParameter;
    }

    public static Map<Long, CalPayRollTask> groupCalPayRollTask(long taskId, Set<Long> ids) {
        HashMap<Long, CalPayRollTask> selectCalPayRollTaskMap = new HashMap<Long, CalPayRollTask>(1);
        DynamicObject calTaskInfo = CalPayRollTaskCalHelper.getCalTaskInfo(taskId, "id,name,number,tasktype");
        CalPayRollTask calPayRollTask = new CalPayRollTask();
        calPayRollTask.setCalPayRollTaskId(calTaskInfo.getLong("id"));
        calPayRollTask.setName(calTaskInfo.getString("name"));
        calPayRollTask.setNumber(calTaskInfo.getString("number"));
        calPayRollTask.setTaskType(calTaskInfo.getString("tasktype"));
        selectCalPayRollTaskMap.put(taskId, calPayRollTask);
        calPayRollTask.setCalPersons(new ArrayList<Long>(ids));
        return selectCalPayRollTaskMap;
    }

    public static DynamicObject getCalTaskInfo(long taskId, String selectProperties) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        return helper.queryOne(selectProperties, (Object)taskId);
    }

    public static Map<Long, CalPayRollTask> groupCalPayRollTask(ListSelectedRowCollection listSelectedData) {
        HashMap<Long, CalPayRollTask> selectCalPayRollTaskMap = new HashMap<Long, CalPayRollTask>(listSelectedData.size());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObjectCollection calTasks = helper.queryOriginalCollection("id,tasktype", new QFilter[]{new QFilter("id", "in", (Object)listSelectedData.getPrimaryKeyValues())});
        Map<Long, String> calTaskTypeMap = calTasks.stream().collect(Collectors.toMap(calTask -> calTask.getLong("id"), calTask -> calTask.getString("tasktype")));
        for (ListSelectedRow listSelectedDatum : listSelectedData) {
            CalPayRollTask calPayRollTask = new CalPayRollTask();
            calPayRollTask.setCalPayRollTaskId((Long)listSelectedDatum.getPrimaryKeyValue());
            calPayRollTask.setName(listSelectedDatum.getName());
            calPayRollTask.setNumber(listSelectedDatum.getNumber());
            calPayRollTask.setTaskType(calTaskTypeMap.get(listSelectedDatum.getPrimaryKeyValue()));
            selectCalPayRollTaskMap.put((Long)listSelectedDatum.getPrimaryKeyValue(), calPayRollTask);
        }
        return selectCalPayRollTaskMap;
    }

    public static FormShowParameter getModalFormShowParameter(String formId, String caption) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        if (SWCStringUtils.isNotEmpty((String)caption)) {
            formShowParameter.setCaption(caption);
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        return formShowParameter;
    }

    public static FormShowParameter getModalFormShowParameter(String formId) {
        return CalPayRollTaskCalHelper.getModalFormShowParameter(formId, "");
    }

    public static FormShowParameter getCalProcessPage(String formId, List<Map<String, Object>> datas, String traceId, String rootPageId) {
        FormShowParameter showParameter = CalPayRollTaskCalHelper.getModalFormShowParameter(formId);
        CalPayRollTaskProcessVO calPayRollTaskProcessVO = new CalPayRollTaskProcessVO();
        calPayRollTaskProcessVO.setTraceId(traceId);
        ArrayList<CalProcessVO> calProcessVOS = new ArrayList<CalProcessVO>(datas.size());
        for (Map<String, Object> datum : datas) {
            CalProcessVO calProcessVO = new CalProcessVO();
            calProcessVO.setCalType((String)datum.get("calType"));
            calProcessVO.setCalCount(((Integer)datum.get("calCount")).intValue());
            calProcessVO.setCalRecordId((Long)datum.get("calRecordId"));
            calProcessVO.setCalTaskId((Long)datum.get("calTaskId"));
            calProcessVO.setCalPayRollTaskName((String)datum.get("calTaskName"));
            calProcessVOS.add(calProcessVO);
        }
        calPayRollTaskProcessVO.setCalProcessVOs(calProcessVOS);
        try {
            calPayRollTaskProcessVO.setStartTime(SWCDateTimeUtils.parseDate((String)(datas.get(0).get("starttime") + "")));
        }
        catch (ParseException exception) {
            log.error("date parse error", (Throwable)exception);
        }
        calPayRollTaskProcessVO.setRootPageId(rootPageId);
        showParameter.setCustomParam(CAL_PAY_ROLL_TASK_PROCESS_PARAMS, (Object)SerializationUtils.toJsonString((Object)calPayRollTaskProcessVO));
        showParameter.setCustomParam("calTaskCount", (Object)datas.size());
        return showParameter;
    }

    public static List<Long> filterCalData(Long calPayRollTaskId, CalPersonOperationEnum calPersonOperationEnum, String openTaxCal) {
        QFilter filter;
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter condition = new QFilter("calmainid", "=", (Object)0L);
        QFilter calPayRollTaskFilter = new QFilter("caltask", "=", (Object)calPayRollTaskId);
        calPayRollTaskFilter.and(condition);
        switch (calPersonOperationEnum) {
            case OP_CAL: {
                filter = CalPayRollTaskCalHelper.filterCalDataForCal(openTaxCal);
                break;
            }
            case CANCEL_CAL: {
                filter = CalPayRollTaskCalHelper.filterCancelCalData(openTaxCal);
                break;
            }
            default: {
                filter = null;
            }
        }
        if (filter != null) {
            calPayRollTaskFilter.and(filter);
        }
        try {
            List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)calPersonOperationEnum.getPermission());
            if (authorizedDataRuleQFilter != null) {
                for (QFilter authFilter : authorizedDataRuleQFilter) {
                    calPayRollTaskFilter.and(authFilter);
                }
            } else {
                calPayRollTaskFilter.and(new QFilter("1", "!=", (Object)1));
            }
        }
        catch (Exception exception) {
            log.error("invoke hrcs IHRCSDataPermissionService error", (Throwable)exception);
        }
        ArrayList<Long> calPersonIds = new ArrayList<Long>(10);
        DynamicObject[] query = calPersonHelper.queryOriginalArray("id", new QFilter[]{calPayRollTaskFilter});
        if (query == null || query.length == 0) {
            return calPersonIds;
        }
        for (DynamicObject dynamicObject : query) {
            calPersonIds.add(dynamicObject.getLong("id"));
        }
        return calPersonIds;
    }

    private static QFilter filterCancelCalData(String openTaxCal) {
        if ("0".equals(openTaxCal)) {
            return new QFilter("calstatus", "in", (Object)new String[]{CalStateEnum.AFTERCAL_ERROR.getCode(), CalStateEnum.ALL_CALED.getCode(), CalStateEnum.CANCELCAL_ERROR.getCode(), CalStateEnum.PRECAL_ERROR.getCode(), CalStateEnum.PARTIAL_CALED.getCode()});
        }
        return new QFilter("calstatus", "in", (Object)new String[]{CalStateEnum.PULLTAX_ERROR.getCode(), CalStateEnum.AFTERCAL_ERROR.getCode(), CalStateEnum.ALL_CALED.getCode(), CalStateEnum.CANCELCAL_ERROR.getCode(), CalStateEnum.PRECAL_ERROR.getCode(), CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.PUSHTAX_ERROR.getCode(), CalStateEnum.TAXCAL_ERROR.getCode()});
    }

    public static QFilter filterCalDataForCal(String openTaxCal) {
        QFilter qFilter = null;
        qFilter = "0".equals(openTaxCal) ? new QFilter("calstatus", "in", (Object)new String[]{CalStateEnum.UNCAL.getCode(), CalStateEnum.PRECAL_ERROR.getCode(), CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.AFTERCAL_ERROR.getCode(), CalStateEnum.ALL_CALED.getCode()}) : new QFilter("calstatus", "in", (Object)new String[]{CalStateEnum.UNCAL.getCode(), CalStateEnum.PRECAL_ERROR.getCode(), CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.PUSHTAX_ERROR.getCode(), CalStateEnum.TAXCAL_ERROR.getCode(), CalStateEnum.PULLTAX_ERROR.getCode(), CalStateEnum.AFTERCAL_ERROR.getCode(), CalStateEnum.ALL_CALED.getCode()});
        qFilter.and(new QFilter("onholdstatus", "!=", (Object)(OnHoldStatusEnum.STATUS_STOPPAY.getCode() + "")));
        return qFilter;
    }

    public static void clearProcessCache(String batchId, List<CalPayRollTask> validDatas, List<CalPayRollTask> invalidDatas) {
        ISWCAppCache appCache = SWCAppCache.get((String)"SWC_PAYROLL_TASK");
        ArrayList<CalPayRollTask> calPayRollTasks = new ArrayList<CalPayRollTask>(validDatas.size() + invalidDatas.size());
        calPayRollTasks.addAll(validDatas);
        calPayRollTasks.addAll(invalidDatas);
        for (CalPayRollTask validData : calPayRollTasks) {
            appCache.remove("process" + batchId + validData.getCalPayRollTaskId());
        }
    }

    public static void clearProcessCache(CalPayRollTaskContext calPayRollTaskContext) {
        String batchId = calPayRollTaskContext.getTraceId();
        List<CalPayRollTask> validDatas = calPayRollTaskContext.getValidDatas();
        List<CalPayRollTask> invalidDatas = calPayRollTaskContext.getInvalidDatas();
        CalPayRollTaskCalHelper.clearProcessCache(batchId, validDatas, invalidDatas);
    }

    public static int getCalPersonCount(Long calPayRollTaskId) {
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("caltask.id", "=", (Object)calPayRollTaskId);
        filter.and(new QFilter("calmainid", "=", (Object)0L));
        return calPersonHelper.count(new QFilter[]{filter});
    }
}

