/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.helper;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.RuleParamTypeEnum;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalPersonListHelper {
    private static final Log logger = LogFactory.getLog(CalPersonListHelper.class);
    private static final String SWC_HSAS_BUSINESS = "swc-hsas-business";

    public FormShowParameter getProgressView(Map<String, Object> jobFormInfo, String formId, CloseCallBack closeCallBack) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.getCustomParams().put("ServiceAppId", "hsas");
        String jobInfoStr = SerializationUtils.toJsonString(jobFormInfo);
        formShowParameter.getCustomParams().put("sch_clientjobinfo", jobInfoStr);
        formShowParameter.setCloseCallBack(closeCallBack);
        return formShowParameter;
    }

    public Map<String, String> getStatusMap() {
        LinkedHashMap<String, String> statusMap = new LinkedHashMap<String, String>(16);
        statusMap.put("calstatus", ResManager.loadKDString((String)"\u6838\u7b97\u72b6\u6001", (String)"CalPersonListHelper_0", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]));
        statusMap.put("taxstatus", ResManager.loadKDString((String)"\u4e2a\u7a0e\u6570\u636e\u72b6\u6001", (String)"CalPersonListHelper_1", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]));
        statusMap.put("paystatus", ResManager.loadKDString((String)"\u53d1\u653e\u72b6\u6001", (String)"CalPersonListHelper_2", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]));
        statusMap.put("allotstatus", ResManager.loadKDString((String)"\u5206\u644a\u72b6\u6001", (String)"CalPersonListHelper_3", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]));
        statusMap.put("salarystatus", ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u72b6\u6001", (String)"CalPersonListHelper_4", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]));
        return statusMap;
    }

    public static List<String> getStatusList() {
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("calstatus");
        statusList.add("taxstatus");
        statusList.add("paystatus");
        statusList.add("allotstatus");
        statusList.add("salarystatus");
        return statusList;
    }

    public static Set<Long> getFitDataRuleIds(long userId, String appId, String entityNumber, String permItemId, Object ids) {
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)10);
        if (PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId())) {
            logger.info("SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter: the current user is supper user.");
            qFilters.add(new QFilter("1", "=", (Object)1));
        } else {
            QFilter qFilter = (QFilter)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRule", (Object[])new Object[]{userId, appId, entityNumber, permItemId, new HashMap()});
            if (qFilter == null) {
                qFilter = new QFilter("1", "=", (Object)1);
            }
            logger.info("SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter: the filter info is [{}]", (Object)qFilter.toString());
            qFilters.add(qFilter);
        }
        qFilters.add(new QFilter("id", "in", ids));
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityNumber);
        DynamicObjectCollection objs = helper.queryOriginalCollection("id", qFilters.toArray(new QFilter[0]));
        return objs.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
    }

    public static List<Long> getSelectedPkid(BillList billList) {
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        ArrayList<Long> selectedRowIdList = new ArrayList<Long>(10);
        for (ListSelectedRow row : selectedRows) {
            selectedRowIdList.add((Long)row.getPrimaryKeyValue());
        }
        return selectedRowIdList;
    }

    public static void setCostTime(Date startDate, Label timeLabel, Date endDate, Boolean isFinish) {
        Date end = new Date();
        if (endDate != null) {
            end = endDate;
        }
        long between = end.getTime() - startDate.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
        String hms = formatter.format(between);
        if (isFinish.booleanValue()) {
            timeLabel.setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8017\u65f6%s", (String)"CalPersonListHelper_6", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), hms));
        } else {
            timeLabel.setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5df2\u8017\u65f6%s", (String)"CalPersonListHelper_5", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), hms));
        }
    }

    public static void updatePersonCount(Long calTaskId) {
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        SWCDataServiceHelper calpersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter taskFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
        int count = calpersonHelper.count(new QFilter[]{taskFilter});
        DynamicObject task = taskHelper.queryOne("id,calpersoncount", (Object)calTaskId);
        task.set("calpersoncount", (Object)count);
        taskHelper.updateOne(task);
    }

    public static void showGetRefreshProgress(String refreshType, IFormView view) {
        CalPersonListHelper calPersonListHelper = new CalPersonListHelper();
        CloseCallBack closeCallBack = new CloseCallBack("kd.swc.hsas.formplugin.web.calpersonlist.CalPersonListViewPlugin", "getRefreshListBack");
        Long calTaskId = (Long)view.getFormShowParameter().getCustomParam("payrolltaskdataid");
        String calTaskName = view.getPageCache().get("calTaskName");
        if (SWCStringUtils.isEmpty((String)calTaskName)) {
            SWCDataServiceHelper calTaskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
            DynamicObject calTask = calTaskHelper.queryOne("name", (Object)calTaskId);
            calTaskName = calTask.getString("name");
        }
        String title = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u83b7\u53d6\u66f4\u65b0\u5185\u5bb9_%s", (String)"CalPersonOperateList_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]), calTaskName);
        HashMap<String, Object> jobFormInfo = new HashMap<String, Object>(16);
        jobFormInfo.put("calTaskId", calTaskId);
        jobFormInfo.put("calTaskName", calTaskName);
        jobFormInfo.put("refreshType", refreshType);
        jobFormInfo.put("parentId", view.getPageId());
        jobFormInfo.put("taskName", title);
        FormShowParameter formShowParameter = calPersonListHelper.getProgressView(jobFormInfo, "hsas_calgetrefreshprog", closeCallBack);
        formShowParameter.setCustomParam("refreshType", (Object)refreshType);
        formShowParameter.setCustomParam("calTaskId", (Object)calTaskId);
        formShowParameter.setCustomParam("calTaskName", (Object)calTaskName);
        BillList billList = (BillList)view.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        List selectIds = selectedRows.stream().map(o -> (Long)o.getPrimaryKeyValue()).collect(Collectors.toList());
        SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"ICalPersonService", (String)"getCalRefreshList", (Object[])new Object[]{calTaskId, selectIds, refreshType});
        view.showForm(formShowParameter);
    }

    public static void showGetAddProgress(IFormView view) {
        Long calTaskId = (Long)view.getFormShowParameter().getCustomParam("payrolltaskdataid");
        String calTaskName = view.getPageCache().get("calTaskName");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("payrolltaskdataid", (Object)calTaskId);
        formShowParameter.setCustomParam("calTaskName", (Object)calTaskName);
        formShowParameter.setFormId("hsas_getaddperprogress");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.getCustomParams().put("ServiceAppId", "hsas");
        view.showForm(formShowParameter);
    }

    public String getCalPersonNameByCalPersonId(long calPersonId) {
        SWCDataServiceHelper calpersonHelper = new SWCDataServiceHelper("hsas_calperson");
        String field = "name";
        QFilter filter = new QFilter("id", "=", (Object)calPersonId);
        DynamicObject calPersonObj = calpersonHelper.queryOriginalOne(field, new QFilter[]{filter}, null);
        if (calPersonObj != null) {
            return calPersonObj.getString("name");
        }
        return "";
    }

    public static boolean validateRuleVersion(Long taskId, IFormView view, boolean isAdd) {
        return true;
    }

    public static void showDelResult(int total, List<String> errMsgList, IFormView view) {
        if (view == null) {
            return;
        }
        int fail = errMsgList.size();
        view.invokeOperation("refresh");
        if (fail == 0) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"CalPersonListHelper_7", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]));
            return;
        }
        if (total == 1) {
            view.showErrorNotification(errMsgList.get(0));
        } else {
            String title = ResManager.loadKDString((String)"\u5171{0}\u4eba\uff0c\u5220\u9664\u6210\u529f{1}\u4eba\uff0c\u5931\u8d25{2}\u4eba\u3002", (String)"CalPersonListHelper_8", (String)SWC_HSAS_BUSINESS, (Object[])new Object[]{total, total - fail, fail});
            FormShowParameter resultParameter = SWCShowFormServiceHelper.getOperationResultParameter((String)CalPersonOperationEnum.OP_DELCALPERSON.getOperationName(), (String)title, errMsgList);
            view.showForm(resultParameter);
        }
    }

    public static Map<String, Object> syncRelExtProp(Map<String, Object> param) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (result.containsKey("success")) {
                return result;
            }
            Map<String, Object> datas = CalPersonListHelper.syncRelExtPropCore(param);
            result.put("success", Boolean.TRUE);
            result.put("data", datas);
        }
        catch (Exception ex) {
            logger.error("CalPersonListHelper...syncRelExtProp.error\uff1a", (Throwable)ex);
            result.put("success", Boolean.FALSE);
            result.put("message", ex.getMessage());
        }
        return result;
    }

    private static Map<String, Object> syncRelExtPropCore(Map<String, Object> param) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> presetDataMap = new HashMap<String, Object>();
        CalPersonListHelper.dealCalListCfgExtField(param, presetDataMap);
        result.put("presetDataMap", presetDataMap);
        return result;
    }

    public static void dealCalListCfgExtField(Map<String, Object> param, Map<String, Object> presetDataMap) {
        logger.info("param:{}", param);
        String bizEntityNumber = String.valueOf(param.get("bizEntityNumber"));
        ArrayList<Long> setIds = new ArrayList<Long>(10);
        ArrayList<Long> delIds = new ArrayList<Long>(10);
        ArrayList<DynamicObject> saveCfgs = new ArrayList<DynamicObject>(10);
        SWCDataServiceHelper cfgHelper = new SWCDataServiceHelper("hsbs_callistfieldcfg");
        QFilter filter = new QFilter("perruleobj.number", "=", (Object)bizEntityNumber);
        DynamicObject[] cfgs = cfgHelper.query(SWCHisBaseDataHelper.getSelectProperties((String)cfgHelper.getEntityName()), filter.toArray());
        if (cfgs == null || cfgs.length < 1) {
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bizEntityNumber);
        Map<String, DynamicObject> paramMap = Arrays.stream(cfgs).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy, (v1, v2) -> v1));
        String preKey = null;
        DynamicObject cfgtpl = null;
        for (DynamicObject cfg : cfgs) {
            cfgtpl = cfg;
            String calpersonField = cfgtpl.getString("field");
            if (!calpersonField.contains(".") && !calpersonField.contains("org.name")) continue;
            preKey = calpersonField.split("\\.")[0];
            break;
        }
        if (SWCStringUtils.isEmpty(preKey)) {
            return;
        }
        int index = cfgs.length + 1;
        List<String> personInfoEntitys = Arrays.asList("hsas_personhr", "hsas_employee", "hsas_pernontsprop");
        if (personInfoEntitys.contains(bizEntityNumber)) {
            index = cfgHelper.count(new QFilter[]{new QFilter("perruleobj.number", "in", personInfoEntitys)}) + 1;
        }
        Map allFields = dataEntityType.getAllFields();
        List fields = (List)param.get("data");
        for (Map field : fields) {
            String fieldkey = String.valueOf(field.get("number"));
            String type = String.valueOf(field.get("type"));
            Boolean isDelete = (Boolean)field.get("delete");
            IDataEntityProperty property = (IDataEntityProperty)allFields.get(fieldkey);
            if (property == null || "BasedataPropField".equals(type) || "MulBasedataField".equals(type) || "AttachmentPanelAp".equals(type) || "DateTimeField".equals(type)) continue;
            DynamicObject cfgDb = paramMap.get(fieldkey);
            if (cfgDb != null && !isDelete.booleanValue()) {
                setIds.add(cfgDb.getLong("id"));
                continue;
            }
            if (cfgDb != null) {
                delIds.add(cfgDb.getLong("id"));
                continue;
            }
            DynamicObject cfg = cfgHelper.generateEmptyDynamicObject();
            cfg.set("name", (Object)property.getDisplayName());
            cfg.set("isusedbyrule", (Object)Boolean.FALSE);
            cfg.set("isusedbyviewsch", (Object)Boolean.FALSE);
            cfg.set("perruleobj", cfgtpl.get("perruleobj"));
            cfg.set("number", (Object)fieldkey);
            cfg.set("index", (Object)index);
            cfg.set("field", (Object)(preKey + '.' + fieldkey));
            if (property instanceof BasedataProp) {
                cfg.set("type", (Object)RuleParamTypeEnum.DYNAMICOBJECT.getValue());
                cfg.set("field", (Object)(preKey + '.' + fieldkey + '.' + "name"));
            } else if (property instanceof TextProp) {
                cfg.set("type", (Object)RuleParamTypeEnum.STRING.getValue());
            } else if (property instanceof DateTimeProp) {
                cfg.set("type", (Object)RuleParamTypeEnum.DATE.getValue());
            } else if (property instanceof ComboProp) {
                cfg.set("type", (Object)RuleParamTypeEnum.ENUM.getValue());
            } else if (property instanceof BooleanProp) {
                cfg.set("type", (Object)RuleParamTypeEnum.BOOLEAN.getValue());
            } else {
                if (!(property instanceof DecimalProp)) continue;
                cfg.set("type", (Object)RuleParamTypeEnum.NUMBER.getValue());
            }
            saveCfgs.add(cfg);
            ++index;
        }
        cfgHelper.save(saveCfgs.toArray(new DynamicObject[0]));
        cfgHelper.delete(delIds.toArray());
        saveCfgs.forEach(o -> setIds.add(o.getLong("id")));
        presetDataMap.put(cfgHelper.getEntityName(), setIds);
    }
}

