/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.Features;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hsas.common.events.calperson.CalResultCoverSalaryItemEvent;
import kd.sdk.swc.hsas.formplugin.extpoint.resultcover.ICalResultCoverSalaryItemExtPlugin;
import kd.swc.hsas.business.cal.helper.HSASCalListHelper;
import kd.swc.hsas.business.cal.impl.CalResultCoverSalaryItemExtPlugin;
import kd.swc.hsas.business.cal.service.CalResultCoverService;
import kd.swc.hsas.business.cal.service.CalRollBackService;
import kd.swc.hsas.business.cal.service.ResultCoverProrationService;
import kd.swc.hsas.business.cal.service.ResultCoverService;
import kd.swc.hsas.business.cal.service.ResultCoverSumService;
import kd.swc.hsas.business.calpayrolltask.CalPayrollTaskHelper;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.dynamic.grid.DateParamContainer;
import kd.swc.hsbp.common.dynamic.grid.DecimalFieldParamContainer;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainer;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainerBaseHelper;
import kd.swc.hsbp.common.dynamic.grid.TextFieldParamContainer;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.SWCShowType;
import kd.swc.hsbp.common.enums.TaxStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCGridUtils;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class CalResultCoverHelper {
    private static final Log logger = LogFactory.getLog(CalResultCoverHelper.class);
    private static String fixedField = "name,filenumber,empnumber";

    public static boolean checkHasCaledPerson(String personPageId, Long taskId, String coverType) {
        Map<String, List<Long>> personIdListCalblockMap;
        List<Map<String, String>> prorationPersonDataList = CalResultCoverHelper.getCacheProrationCoverDataList(taskId, personPageId, false);
        Map<String, Map<String, String>> personSimpleDataMap = CalResultCoverHelper.getCachePersonSimpleDataMap(taskId, personPageId, false);
        Map<String, Map<String, String>> cacheSalaryItemMap = CalResultCoverHelper.getCacheSalaryItemMap(taskId, personPageId);
        Map<String, Map<String, Object>> sumChangeData = CalResultCoverHelper.getSumChangeData(personPageId, taskId);
        Map<String, Object> prorationChangeData = CalResultCoverHelper.getProrationChangeData(personPageId, taskId);
        List<String> waitDeleteIdList = CalResultCoverHelper.getWaitDeleteData(personPageId, taskId);
        if (SWCStringUtils.equals((String)"2", (String)coverType)) {
            List<Long> waitDeletePersonIdList = waitDeleteIdList.stream().map(single -> Long.valueOf(single)).collect(Collectors.toList());
            personIdListCalblockMap = CalResultCoverHelper.getSumPersonIdListCalblockMap(cacheSalaryItemMap, sumChangeData, personSimpleDataMap, waitDeletePersonIdList);
        } else {
            personIdListCalblockMap = CalResultCoverHelper.getProrationPersonIdListCalblockMap(waitDeleteIdList, prorationPersonDataList, prorationChangeData);
        }
        List<Long> backToUncalList = personIdListCalblockMap.get("0");
        List<Long> backToPrecalList = personIdListCalblockMap.get("1");
        return !SWCListUtils.isEmpty(backToPrecalList) || !SWCListUtils.isEmpty(backToUncalList);
    }

    public static void updateModelToChangeData(int pageRows, String currentPageIndex, String coverType, DynamicObjectCollection entryEntity, Long taskId, String personPageId) {
        if (SWCListUtils.isEmpty((List)entryEntity)) {
            return;
        }
        Map<String, Object> taskMap = CalResultCoverHelper.getTaskCurrencyPrecision(taskId);
        int precision = Integer.parseInt(taskMap.get("precision") + "");
        if (SWCStringUtils.equals((String)"2", (String)coverType)) {
            CalResultCoverHelper.compareAndUpdateSumChangeData(pageRows, currentPageIndex, precision, taskId, personPageId, entryEntity);
        } else {
            CalResultCoverHelper.compareAndUpdateProrationChangeData(pageRows, currentPageIndex, precision, taskId, personPageId, entryEntity);
        }
    }

    private static void compareAndUpdateSumChangeData(int pageRows, String currentPageIndex, int precision, Long taskId, String personPageId, DynamicObjectCollection entryEntity) {
        List idStrList = entryEntity.stream().map(single -> single.getString("idstr")).collect(Collectors.toList());
        Map<String, Map<String, String>> salaryItemMap = CalResultCoverHelper.getCacheSalaryItemMap(taskId, personPageId);
        List<Long> itemIdList = salaryItemMap.keySet().stream().map(itemId -> Long.parseLong(itemId)).collect(Collectors.toList());
        List<Long> personIdList = idStrList.stream().map(single -> Long.parseLong(single)).collect(Collectors.toList());
        Map<Long, Map<Long, Object>> itemDataMap = CalResultCoverHelper.assembleSalaryItemDataMap(null, new HashMap<String, Map<String, Object>>(0), personIdList, itemIdList);
        LinkedHashMap memoMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        Map<Long, Map<Long, Object>> newItemDataMap = CalResultCoverHelper.assembleNewSumItemDataMap(entryEntity, itemIdList, memoMap);
        Map<String, Map<String, Object>> newSumChangeData = CalResultCoverHelper.getSumDiffData(precision, itemDataMap, newItemDataMap);
        CalResultCoverHelper.updateSumChangeData(pageRows, currentPageIndex + "", newSumChangeData, taskId, personPageId);
        CalResultCoverHelper.updateMemoChangeData(pageRows, currentPageIndex + "", memoMap, taskId, personPageId);
    }

    private static void compareAndUpdateProrationChangeData(int pageRows, String currentPageIndex, int precision, Long taskId, String personPageId, DynamicObjectCollection entryEntity) {
        List<String> idStrList = entryEntity.stream().map(single -> single.getString("idstr")).collect(Collectors.toList());
        Map<String, Object> oldCoverDataMap = CalResultCoverHelper.getOldProrationCoverDataMapByIdStr(idStrList);
        HashMap<String, String> memoMap = new HashMap<String, String>(16);
        Map<String, Object> newItemDataMap = CalResultCoverHelper.assembleNewProrationItemDataMap(entryEntity, memoMap);
        Map<String, Object> newProrationChangeData = CalResultCoverHelper.getProrationDiffData(precision, oldCoverDataMap, newItemDataMap);
        CalResultCoverHelper.updateProrationChangeData(pageRows, currentPageIndex, newProrationChangeData, taskId, personPageId);
        CalResultCoverHelper.updateMemoChangeData(pageRows, currentPageIndex + "", memoMap, taskId, personPageId);
    }

    public static void updateSumChangeData(int pageRows, String currentPageIndex, Map<String, Map<String, Object>> newSumChangeData, Long taskId, String personPageId) {
        Map<String, Map<String, Map<String, Object>>> sumTotalChangeData = CalResultCoverHelper.getSumChangeDataAllPage(personPageId, taskId);
        if (newSumChangeData.size() > pageRows) {
            List<Map<String, Map<String, Object>>> list = CalResultCoverHelper.splitByChunkSize(newSumChangeData, pageRows);
            for (int i = 0; i < list.size(); ++i) {
                int index = Integer.parseInt(currentPageIndex) + i;
                sumTotalChangeData.put(index + "", list.get(i));
            }
        } else {
            sumTotalChangeData.put(currentPageIndex, newSumChangeData);
        }
        CalResultCoverHelper.updateCacheChangeData(sumTotalChangeData, taskId, personPageId);
    }

    public static void updateMemoChangeData(int pageRows, String currentPageIndex, Map<String, String> newMemoChangeData, Long taskId, String personPageId) {
        Map<String, Map<String, String>> totalMemoChangeData = CalResultCoverHelper.getMemoChangeDataAllPage(personPageId, taskId);
        if (newMemoChangeData.size() > pageRows) {
            List<Map<String, String>> list = CalResultCoverHelper.splitByChunkSize(newMemoChangeData, pageRows);
            for (int i = 0; i < list.size(); ++i) {
                int index = Integer.parseInt(currentPageIndex) + i;
                totalMemoChangeData.put(index + "", list.get(i));
            }
        } else {
            totalMemoChangeData.put(currentPageIndex, newMemoChangeData);
        }
        CalResultCoverHelper.updateCacheMemoChangeData(totalMemoChangeData, taskId, personPageId);
    }

    public static void updateProrationChangeData(int pageRows, String currentPageIndex, Map<String, Object> newSumChangeData, Long taskId, String personPageId) {
        Map<String, Map<String, Object>> prorationChangeData = CalResultCoverHelper.getProrationChangeDataAllPage(personPageId, taskId);
        if (newSumChangeData.size() > pageRows) {
            List<Map<String, Object>> list = CalResultCoverHelper.splitByChunkSize(newSumChangeData, pageRows);
            for (int i = 0; i < list.size(); ++i) {
                int index = Integer.parseInt(currentPageIndex) + i;
                prorationChangeData.put(index + "", list.get(i));
            }
        } else {
            prorationChangeData.put(currentPageIndex, newSumChangeData);
        }
        List<String> waitDeleteIdList = CalResultCoverHelper.getWaitDeleteData(personPageId, taskId);
        for (Map.Entry<String, Object> entry : newSumChangeData.entrySet()) {
            String itemStr = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            waitDeleteIdList.remove(itemStr);
        }
        CalResultCoverHelper.updateWaitDeleteData(waitDeleteIdList, personPageId, taskId);
        CalResultCoverHelper.updateCacheProrationChangeData(prorationChangeData, taskId, personPageId);
    }

    public static void updateCacheChangeData(Map<String, Map<String, Map<String, Object>>> changeData, Long taskId, String personPageId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        String cacheKey = String.format(Locale.ROOT, "changeData_%d_%s", taskId, personPageId);
        appCache.put(cacheKey, (Object)SerializationUtils.serializeToBase64(changeData));
    }

    public static void updateCacheMemoChangeData(Map<String, Map<String, String>> changeData, Long taskId, String personPageId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        String cacheKey = String.format(Locale.ROOT, "memoChangeData_%d_%s", taskId, personPageId);
        appCache.put(cacheKey, changeData);
    }

    public static void updateCacheProrationChangeData(Map<String, Map<String, Object>> changeData, Long taskId, String personPageId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        String cacheKey = String.format(Locale.ROOT, "prorationChangeData_%d_%s", taskId, personPageId);
        appCache.put(cacheKey, changeData);
    }

    public static <K, V> List<Map<K, V>> splitByChunkSize(Map<K, V> map, int chunkSize) {
        if (Objects.isNull(map) || map.isEmpty() || chunkSize < 1) {
            return Collections.emptyList();
        }
        int mapSize = map.size();
        int groupSize = mapSize / chunkSize + (mapSize % chunkSize == 0 ? 0 : 1);
        ArrayList list = Lists.newArrayListWithCapacity((int)groupSize);
        if (chunkSize >= mapSize) {
            list.add(map);
            return list;
        }
        int count = 0;
        LinkedHashMap subMap = Maps.newLinkedHashMapWithExpectedSize((int)chunkSize);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (count < chunkSize) {
                subMap.put(entry.getKey(), entry.getValue());
                ++count;
                continue;
            }
            list.add(subMap);
            subMap = Maps.newLinkedHashMapWithExpectedSize((int)chunkSize);
            subMap.put(entry.getKey(), entry.getValue());
            count = 1;
        }
        list.add(subMap);
        return list;
    }

    private static Map<String, List<Long>> getProrationPersonIdListCalblockMap(List<String> waitDeleteIdList, List<Map<String, String>> prorationPersonDataList, Map<String, Object> prorationChangeData) {
        HashMap<String, List<Long>> personCalblockMap = new HashMap<String, List<Long>>(16);
        HashMap itemCalblockMap = new HashMap(16);
        HashMap personStatusMap = new HashMap(16);
        prorationPersonDataList.stream().forEach(dataMap -> {
            String personId = (String)dataMap.get("personid");
            String itemId = (String)dataMap.get("itemid");
            String calblock = (String)dataMap.get("calblock");
            String status = (String)dataMap.get("calstatus");
            itemCalblockMap.put(itemId, calblock);
            personStatusMap.put(personId, status);
        });
        ArrayList<Long> backToUncalPersonList = new ArrayList<Long>(10);
        ArrayList<Long> backToPreCaledPersonList = new ArrayList<Long>(10);
        List<String> caledStatusList = Arrays.asList(CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.ALL_CALED.getCode());
        HashMap<Long, Set> personItemCalblockMap = new HashMap<Long, Set>(16);
        waitDeleteIdList.addAll(prorationChangeData.keySet());
        for (String string : waitDeleteIdList) {
            String[] split = string.split("#");
            String personId = split[0];
            String calStatus = (String)personStatusMap.get(personId);
            if (!caledStatusList.contains(calStatus)) continue;
            Set calblockSet = personItemCalblockMap.computeIfAbsent(Long.valueOf(personId), valueSet -> new HashSet(16));
            String itemId = split[1];
            String itemCalblock = (String)itemCalblockMap.get(itemId);
            calblockSet.add(itemCalblock);
        }
        for (Map.Entry entry : personItemCalblockMap.entrySet()) {
            Long personId = (Long)entry.getKey();
            Set blockSet = (Set)entry.getValue();
            String status = (String)personStatusMap.get(personId + "");
            if (blockSet.contains("0")) {
                backToUncalPersonList.add(personId);
            }
            if (!SWCStringUtils.equals((String)CalStateEnum.ALL_CALED.getCode(), (String)status) || blockSet.contains("0")) continue;
            backToPreCaledPersonList.add(personId);
        }
        personCalblockMap.put("1", backToPreCaledPersonList);
        personCalblockMap.put("0", backToUncalPersonList);
        return personCalblockMap;
    }

    public static Map<String, List<Long>> getSumPersonIdListCalblockMap(Map<String, Map<String, String>> cacheSalaryItemMap, Map<String, Map<String, Object>> sumChangeData, Map<String, Map<String, String>> personSimpleDataMap, List<Long> waitDeletePersonIdList) {
        Object personId;
        String itemCalblock;
        String itemId;
        QFilter qFilter;
        SWCDataServiceHelper helper;
        DynamicObjectCollection dynamicObjects;
        Map<String, String> itemCalblockMap = cacheSalaryItemMap.values().stream().collect(Collectors.toMap(key -> (String)key.get("itemid"), value -> (String)value.get("calblock")));
        Map<String, String> personStatusMap = personSimpleDataMap.values().stream().collect(Collectors.toMap(key -> (String)key.get("id"), value -> (String)value.get("calstatus")));
        HashMap<String, List<Long>> personCalblockMap = new HashMap<String, List<Long>>(16);
        ArrayList<Object> backToUncalPersonList = new ArrayList<Object>(10);
        ArrayList<Object> backToPreCaledPersonList = new ArrayList<Object>(10);
        List<String> caledStatusList = Arrays.asList(CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.ALL_CALED.getCode());
        ArrayList<Long> needBackList = new ArrayList<Long>(10);
        for (Long personId2 : waitDeletePersonIdList) {
            String string = personStatusMap.get(personId2 + "");
            if (!caledStatusList.contains(string)) continue;
            needBackList.add(personId2);
        }
        HashMap<Long, Set> personItemCalblockMap = new HashMap<Long, Set>(16);
        if (!SWCListUtils.isEmpty(needBackList) && !SWCListUtils.isEmpty((List)(dynamicObjects = (helper = new SWCDataServiceHelper("hsas_calresultcoverdata")).queryOriginalCollection("calperson,salaryitem.id", new QFilter[]{qFilter = new QFilter("calperson", "in", needBackList)})))) {
            for (DynamicObject obj : dynamicObjects) {
                long calperson = obj.getLong("calperson");
                Set calblockSet = personItemCalblockMap.computeIfAbsent(calperson, valueSet -> new HashSet(16));
                itemId = obj.getString("salaryitem.id");
                itemCalblock = itemCalblockMap.get(itemId);
                calblockSet.add(itemCalblock);
            }
        }
        for (Map.Entry<String, Map<String, Object>> entry : sumChangeData.entrySet()) {
            personId = entry.getKey();
            String status = personStatusMap.get(personId);
            if (!caledStatusList.contains(status)) continue;
            Map<String, Object> itemMap = entry.getValue();
            Set calblockSet = personItemCalblockMap.computeIfAbsent(Long.valueOf((String)personId), valueSet -> new HashSet(16));
            for (String itemIdStr : itemMap.keySet()) {
                itemId = itemIdStr.substring(4);
                itemCalblock = itemCalblockMap.get(itemId);
                calblockSet.add(itemCalblock);
            }
        }
        for (Map.Entry<String, Map<String, Object>> entry : personItemCalblockMap.entrySet()) {
            personId = (Long)((Object)entry.getKey());
            Set blockSet = (Set)((Object)entry.getValue());
            String status = personStatusMap.get(personId + "");
            if (blockSet.contains("0")) {
                backToUncalPersonList.add(personId);
            }
            if (!SWCStringUtils.equals((String)CalStateEnum.ALL_CALED.getCode(), (String)status) || blockSet.contains("0")) continue;
            backToPreCaledPersonList.add(personId);
        }
        personCalblockMap.put("1", backToPreCaledPersonList);
        personCalblockMap.put("0", backToUncalPersonList);
        return personCalblockMap;
    }

    public static void cleanPersonCoverData(List<Long> personIdList) {
        if (SWCListUtils.isEmpty(personIdList)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calresultcoverdata");
        QFilter filter = new QFilter("calperson", "in", personIdList);
        helper.deleteByFilter(new QFilter[]{filter});
        helper = new SWCDataServiceHelper("hsas_proratecoverdata");
        helper.deleteByFilter(new QFilter[]{filter});
    }

    public static Set<Long> assembleValidProrationPersonIdSet(Long taskId, String personPageId) {
        HashSet<Long> validPersonIdSet = new HashSet<Long>(16);
        List<Map<String, String>> prorationCoverDataMap = CalResultCoverHelper.getCacheProrationCoverDataList(taskId, personPageId, false);
        Set idStrSet = prorationCoverDataMap.stream().map(single -> (String)single.get("idstr")).collect(Collectors.toSet());
        DynamicObject task = CalPayrollTaskHelper.queryTaskInfoById(taskId);
        DynamicObject calRuleHisObj = task.getDynamicObject("calrulev");
        List<DynamicObject> personProrationItemList = CalResultCoverHelper.getProrationItemDataList(calRuleHisObj.getLong("id"), null, true, taskId);
        if (SWCListUtils.isEmpty(personProrationItemList)) {
            return validPersonIdSet;
        }
        HashSet<String> validIdStrSet = new HashSet<String>(16);
        for (DynamicObject dynamicObject : personProrationItemList) {
            StringBuilder rowsIdSb = new StringBuilder();
            String personId = dynamicObject.getString("calpersonid");
            String salaryItemId = dynamicObject.getString("salaryitem.id");
            String startDate = SWCDateTimeUtils.format((Date)dynamicObject.getDate("startdate"), (String)"yyyy-MM-dd");
            String endDate = SWCDateTimeUtils.format((Date)dynamicObject.getDate("enddate"), (String)"yyyy-MM-dd");
            rowsIdSb.append(personId).append('#').append(salaryItemId).append('#').append(startDate).append('#').append(endDate);
            validIdStrSet.add(rowsIdSb.toString());
        }
        validIdStrSet.removeAll(idStrSet);
        if (validIdStrSet.size() == 0) {
            return validPersonIdSet;
        }
        for (String idStr : validIdStrSet) {
            String[] split = idStr.split("#");
            validPersonIdSet.add(Long.parseLong(split[0]));
        }
        return validPersonIdSet;
    }

    public static Map<Long, Map<Long, Object>> assembleNewSumItemDataMap(DynamicObjectCollection entryEntity, List<Long> itemIdList, Map<String, String> memoMap) {
        LinkedHashMap dataMap = Maps.newLinkedHashMapWithExpectedSize((int)entryEntity.size());
        for (DynamicObject obj : entryEntity) {
            long personId = obj.getLong("personid");
            Map itemDataMap = dataMap.computeIfAbsent(personId, map -> Maps.newHashMapWithExpectedSize((int)itemIdList.size()));
            for (Long itemId : itemIdList) {
                String itemIdStr = "key_" + itemId;
                itemDataMap.put(itemId, obj.get(itemIdStr));
            }
            String memo = obj.getString("memo");
            if (!SWCStringUtils.isNotEmpty((String)memo)) continue;
            memoMap.put(personId + "", memo);
        }
        return dataMap;
    }

    public static Map<String, Object> assembleNewProrationItemDataMap(DynamicObjectCollection entryEntity, Map<String, String> memoMap) {
        LinkedHashMap dataMap = Maps.newLinkedHashMapWithExpectedSize((int)entryEntity.size());
        for (DynamicObject obj : entryEntity) {
            String idstr = obj.getString("idstr");
            Object coverValue = obj.get("value");
            dataMap.put(idstr, coverValue);
            String memo = obj.getString("memo");
            if (!SWCStringUtils.isNotEmpty((String)memo)) continue;
            memoMap.put(idstr, memo);
        }
        return dataMap;
    }

    public static void initImportProgressMap(Long taskId, int total, String cacheKey) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "cache_swc_result_progress_%s", taskId));
        HashMap<String, Integer> progressMap = new HashMap<String, Integer>(3);
        String curCacheKey = String.format(Locale.ROOT, cacheKey, RequestContext.get().getCurrUserId());
        progressMap.put("successcount", 0);
        progressMap.put("failcount", 0);
        progressMap.put("totalcount", total);
        appCache.put(curCacheKey, progressMap, 3600);
    }

    public static synchronized void updateImportProgress(Long taskId, int successCnt, int failCnt, String cacheKey) {
        Integer existSuccessCount;
        String curCacheKey;
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "cache_swc_result_progress_%s", taskId));
        HashMap<String, Integer> progressMap = (HashMap<String, Integer>)appCache.get(curCacheKey = String.format(Locale.ROOT, cacheKey, RequestContext.get().getCurrUserId()), Map.class);
        if (progressMap == null || progressMap.size() == 0) {
            progressMap = new HashMap<String, Integer>(3);
        }
        if ((existSuccessCount = (Integer)progressMap.get("successcount")) == null) {
            existSuccessCount = 0;
        }
        existSuccessCount = existSuccessCount + successCnt;
        Integer existFailCount = (Integer)progressMap.get("failcount");
        if (existFailCount == null) {
            existFailCount = 0;
        }
        existFailCount = existFailCount + failCnt;
        progressMap.put("successcount", existSuccessCount);
        progressMap.put("failcount", existFailCount);
        logger.info("updateProgress,success:{},fail:{}", (Object)existSuccessCount, (Object)existFailCount);
        appCache.put(curCacheKey, progressMap, 3600);
        Integer totalCnt = (Integer)progressMap.get("totalcount");
        int percentage = new BigDecimal(String.valueOf(existSuccessCount + existFailCount)).divide(new BigDecimal(String.valueOf(totalCnt)), 2, 1).multiply(new BigDecimal("100")).intValue();
        CalResultCoverHelper.updateImportFloatingProcess(percentage, taskId);
    }

    public static void updateImportFloatingProcess(int percentage, Long taskId) {
        ISWCAppCache bgAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "resultcoverimport_bggroud_taskid_%s", taskId));
        String bgTaskId = (String)bgAppCache.get("bgTaskId", String.class);
        if (SWCStringUtils.isNotEmpty((String)bgTaskId)) {
            HRBackgroundTaskHelper.getInstance().feedbackProgress(bgTaskId, percentage, "", null);
        }
    }

    public static Map<String, Integer> getImportProgressMap(Long taskId, String cacheKey) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "cache_swc_result_progress_%s", taskId));
        long userId = RequestContext.get().getCurrUserId();
        String curCacheKey = String.format(Locale.ROOT, cacheKey, userId);
        Map progressMap = (Map)appCache.get(curCacheKey, Map.class);
        return progressMap;
    }

    public static boolean checkHasDoingTask(Long taskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrecord");
        QFilter filter = new QFilter("caltask", "=", (Object)taskId);
        filter.and("calstatus", "=", (Object)"1");
        int count = helper.count(new QFilter[]{filter});
        return count > 0;
    }

    public static boolean checkHasImporting(Long taskId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "cache_swc_result_progress_%s", taskId));
        long userId = RequestContext.get().getCurrUserId();
        String cacheKey = "resultcoverimport_%s";
        String curCacheKey = String.format(Locale.ROOT, cacheKey, userId);
        if (CalResultCoverHelper.checkImporting(appCache, curCacheKey)) {
            return true;
        }
        cacheKey = "prorationcoverimport_%s";
        curCacheKey = String.format(Locale.ROOT, cacheKey, userId);
        return CalResultCoverHelper.checkImporting(appCache, curCacheKey);
    }

    private static boolean checkImporting(ISWCAppCache appCache, String curCacheKey) {
        Map progressMap = (Map)appCache.get(curCacheKey, Map.class);
        if (progressMap != null) {
            Integer totalCnt = (Integer)progressMap.get("totalcount");
            Integer successCount = (Integer)progressMap.get("successcount");
            Integer failCount = (Integer)progressMap.get("failcount");
            if (totalCnt != successCount + failCount) {
                return true;
            }
        }
        return false;
    }

    public static Map<String, Map<String, Object>> getSumDiffData(int precision, Map<Long, Map<Long, Object>> itemDataMap, Map<Long, Map<Long, Object>> newItemDataMap) {
        LinkedHashMap changeDataMap = Maps.newLinkedHashMapWithExpectedSize((int)newItemDataMap.size());
        for (Map.Entry<Long, Map<Long, Object>> entry : newItemDataMap.entrySet()) {
            Long personId = entry.getKey();
            Map<Long, Object> newItemMap = entry.getValue();
            if (!itemDataMap.containsKey(personId)) continue;
            Map<Long, Object> existItemMap = itemDataMap.get(personId);
            for (Map.Entry<Long, Object> dataEntry : newItemMap.entrySet()) {
                Object existValue;
                Long itemId = dataEntry.getKey();
                String itemIdStr = "key_" + itemId;
                Object newValue = dataEntry.getValue();
                boolean check = SWCObjectUtils.equals((Object)newValue, (Object)(existValue = existItemMap.get(itemId))) || SWCObjectUtils.isEmpty((Object)newValue) && SWCObjectUtils.isEmpty((Object)existValue);
                if (check) continue;
                if (newValue instanceof BigDecimal) {
                    BigDecimal evalue;
                    BigDecimal nvalue = newValue == null ? BigDecimal.ZERO : new BigDecimal(newValue.toString()).setScale(precision, 4);
                    boolean flag = nvalue.compareTo(evalue = existValue == null ? BigDecimal.ZERO : new BigDecimal(existValue.toString()).setScale(precision, 4)) != 0 || nvalue.compareTo(BigDecimal.ZERO) == 0 && existValue == null;
                    if (!flag) continue;
                    Map dataMap = changeDataMap.computeIfAbsent(personId + "", valueMap -> Maps.newHashMapWithExpectedSize((int)newItemMap.size()));
                    dataMap.put(itemIdStr, newValue);
                    continue;
                }
                Map dataMap = changeDataMap.computeIfAbsent(personId + "", valueMap -> Maps.newHashMapWithExpectedSize((int)newItemMap.size()));
                dataMap.put(itemIdStr, newValue);
            }
        }
        return changeDataMap;
    }

    public static Map<String, Object> getOldProrationCoverDataMapByIdStr(List<String> idList) {
        HashMap<String, Object> oldCoverDataMap = new HashMap<String, Object>(idList.size());
        QFilter filter = CalResultCoverHelper.getProrationQFilterByIdstrList(idList);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_proratecoverdata");
        String fields = "calperson,salaryitem.id,startdate,enddate,covervalue";
        DynamicObjectCollection coverDataObjs = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)coverDataObjs)) {
            return oldCoverDataMap;
        }
        for (DynamicObject coverObj : coverDataObjs) {
            StringBuilder idSb = new StringBuilder();
            idSb.append(coverObj.getString("calperson")).append('#').append(coverObj.getString("salaryitem.id")).append('#').append(SWCDateTimeUtils.format((Date)coverObj.getDate("startdate"), (String)"yyyy-MM-dd")).append('#').append(SWCDateTimeUtils.format((Date)coverObj.getDate("enddate"), (String)"yyyy-MM-dd"));
            if (!idList.contains(idSb.toString())) continue;
            oldCoverDataMap.put(idSb.toString(), coverObj.getString("covervalue"));
        }
        return oldCoverDataMap;
    }

    public static Map<String, Object> getOldProrationCoverDataMap(List<Long> idList) {
        HashMap<String, Object> oldCoverDataMap = new HashMap<String, Object>(idList.size());
        QFilter filter = new QFilter("calperson", "in", idList);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_proratecoverdata");
        String fields = "calperson,salaryitem.id,startdate,enddate,covervalue";
        DynamicObjectCollection coverDataObjs = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)coverDataObjs)) {
            return oldCoverDataMap;
        }
        for (DynamicObject coverObj : coverDataObjs) {
            StringBuilder idSb = new StringBuilder();
            idSb.append(coverObj.getString("calperson")).append('#').append(coverObj.getString("salaryitem.id")).append('#').append(SWCDateTimeUtils.format((Date)coverObj.getDate("startdate"), (String)"yyyy-MM-dd")).append('#').append(SWCDateTimeUtils.format((Date)coverObj.getDate("enddate"), (String)"yyyy-MM-dd"));
            oldCoverDataMap.put(idSb.toString(), coverObj.getString("covervalue"));
        }
        return oldCoverDataMap;
    }

    public static QFilter getProrationQFilterByIdstrList(List<String> idList) {
        HashSet<Long> personIdSet = new HashSet<Long>(16);
        HashSet<Long> itemIdSet = new HashSet<Long>(16);
        for (String idstr : idList) {
            String[] split = idstr.split("#");
            String personId = split[0];
            String itemId = split[1];
            if (SWCStringUtils.isNotEmpty((String)personId)) {
                personIdSet.add(Long.parseLong(personId));
            }
            if (!SWCStringUtils.isNotEmpty((String)itemId)) continue;
            itemIdSet.add(Long.parseLong(itemId));
        }
        QFilter filter = new QFilter("calperson", "in", personIdSet);
        filter.and("salaryitem.id", "in", itemIdSet);
        return filter;
    }

    public static Map<String, Object> getProrationDiffData(int precision, Map<String, Object> oldCoverDataMap, Map<String, Object> newItemDataMap) {
        LinkedHashMap changeDataMap = Maps.newLinkedHashMapWithExpectedSize((int)newItemDataMap.size());
        for (Map.Entry<String, Object> entry : newItemDataMap.entrySet()) {
            BigDecimal evalue;
            Object existValue;
            String idstr = entry.getKey();
            Object newValue = entry.getValue();
            if (newValue == (existValue = oldCoverDataMap.get(idstr))) continue;
            if (newValue == null || existValue == null) {
                changeDataMap.put(idstr, newValue);
                continue;
            }
            BigDecimal nvalue = new BigDecimal(newValue.toString()).setScale(precision, 4);
            if (nvalue.compareTo(evalue = new BigDecimal(existValue.toString()).setScale(precision, 4)) == 0) continue;
            changeDataMap.put(idstr, newValue);
        }
        return changeDataMap;
    }

    public static List<String> checkPersonStatus(Long taskId, List<String> idStrList, String coverType, String permItemId) {
        DynamicObject[] calPersonData;
        List<DynamicObject> validCalPersonList;
        ArrayList<String> validIdStrList = new ArrayList<String>(10);
        List<Object> personIdList = Lists.newArrayListWithCapacity((int)idStrList.size());
        Boolean taxCalEnable = TaxCalServiceHelper.getTaxCalEnableStatusByTaskId((Long)taskId);
        if (SWCStringUtils.equals((String)"1", (String)coverType)) {
            for (String idStr : idStrList) {
                String[] split = idStr.split("#");
                personIdList.add(Long.parseLong(split[0]));
            }
        } else {
            personIdList = idStrList.stream().map(single -> Long.parseLong(single)).collect(Collectors.toList());
        }
        if (SWCListUtils.isEmpty(validCalPersonList = CalResultCoverHelper.checkValidCalPersonList(taskId, taxCalEnable, calPersonData = CalResultCoverHelper.getCalPersonData((List<Long>)personIdList, taskId, false, permItemId)))) {
            return validIdStrList;
        }
        if (SWCStringUtils.equals((String)"2", (String)coverType)) {
            for (DynamicObject dynamicObject : validCalPersonList) {
                validIdStrList.add(dynamicObject.getString("id"));
            }
        } else {
            for (DynamicObject dynamicObject : validCalPersonList) {
                for (String idStr : idStrList) {
                    if (!idStr.contains(dynamicObject.getString("id"))) continue;
                    validIdStrList.add(idStr);
                }
            }
        }
        return validIdStrList;
    }

    public static Map<String, List<Long>> assembleNeedCalBackPersonId(Long taskId, List<String> idList, String coverType) {
        ArrayList<Long> caledIdList = new ArrayList<Long>(10);
        Set<Object> idSet = new HashSet(idList.size());
        if (SWCStringUtils.equals((String)"2", (String)coverType)) {
            idSet = idList.stream().map(id -> Long.parseLong(id)).collect(Collectors.toSet());
        } else {
            for (String idStr : idList) {
                String[] split = idStr.split("#");
                idSet.add(Long.parseLong(split[0]));
            }
        }
        DynamicObject[] calPersonData = CalResultCoverHelper.getCalPersonData(new ArrayList<Long>(idSet), taskId, false, "2DXPSF5JTISP");
        List<String> caledStatusList = Arrays.asList(CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.ALL_CALED.getCode());
        for (String string : calPersonData) {
            String calstatus = string.getString("calstatus");
            if (!caledStatusList.contains(calstatus)) continue;
            caledIdList.add(string.getLong("id"));
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        map.put("0", caledIdList);
        return map;
    }

    public static void deleteProrationCoverDataByKeys(List<String> idList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_proratecoverdata");
        QFilter filter = CalResultCoverHelper.getProrationQFilterByIdstrList(idList);
        DynamicObjectCollection coverDataObjs = helper.queryOriginalCollection("id,calperson,salaryitem.id,startdate,enddate", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)coverDataObjs)) {
            return;
        }
        ArrayList<Long> dataIdList = new ArrayList<Long>(10);
        for (DynamicObject coverObj : coverDataObjs) {
            StringBuilder idSb = new StringBuilder();
            idSb.append(coverObj.getString("calperson")).append('#').append(coverObj.getString("salaryitem.id")).append('#').append(SWCDateTimeUtils.format((Date)coverObj.getDate("startdate"), (String)"yyyy-MM-dd")).append('#').append(SWCDateTimeUtils.format((Date)coverObj.getDate("enddate"), (String)"yyyy-MM-dd"));
            if (!idList.contains(idSb.toString())) continue;
            dataIdList.add(coverObj.getLong("id"));
        }
        filter = new QFilter("id", "in", dataIdList);
        helper.deleteByFilter(new QFilter[]{filter});
    }

    public static void deleteSumCoverDataByIds(List<String> idList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calresultcoverdata");
        List personIdList = idList.stream().map(single -> Long.valueOf(single)).collect(Collectors.toList());
        QFilter filter = new QFilter("calperson", "in", personIdList);
        helper.deleteByFilter(new QFilter[]{filter});
    }

    public static EntryAp createEntryAp(int precision, EntityMetadata entityMetadata, Map<String, Map<String, String>> salaryItemMap, String coverType, boolean isView) {
        List<EntryParamContainer> params = CalResultCoverHelper.createEntryBuildParam(precision, entityMetadata, salaryItemMap, coverType, isView);
        EntryAp entryAp = EntryParamContainerBaseHelper.createEntryAp((String)"entryentity");
        entryAp.setShowSelChexkbox(true);
        entryAp.setMulti(true);
        entryAp.setShowSeq(true);
        entryAp.setShowGridConfig(true);
        entryAp.setSplitPage(true);
        return EntryParamContainerBaseHelper.createControlAp((EntryAp)entryAp, params);
    }

    public static void registerProp(EntryType entryType, Map<String, Map<String, String>> salaryItemMap, String coverType, Long taskId, boolean isView) {
        Map<String, Object> taskMap = CalResultCoverHelper.getTaskCurrencyPrecision(taskId);
        List<EntryParamContainer> params = CalResultCoverHelper.createEntryBuildParam(Integer.parseInt(taskMap.get("precision") + ""), null, salaryItemMap, coverType, isView);
        EntryParamContainerBaseHelper.registProp(params, (EntityType)entryType);
    }

    public static void loadGridData(IDataModel model, int pageIndex, int pageRows, IPageCache pageCache, String entryKey, IClientViewProxy clientViewProxy, boolean isView) {
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection entryEntities = model.getEntryEntity(entryKey);
        entryEntities.clear();
        Long taskId = Long.parseLong(pageCache.get("taskId"));
        String personPageId = pageCache.get("personPageId");
        String coverType = pageCache.get("coverType");
        Map<String, Object> taskCurrencyPrecision = CalResultCoverHelper.getTaskCurrencyPrecision(taskId);
        int precision = Integer.parseInt(taskCurrencyPrecision.get("precision") + "");
        String searchText = CalResultCoverHelper.getCacheSearchText(taskId, personPageId);
        int newPageIndex = CalResultCoverHelper.getPageData(clientViewProxy, precision, searchText, isView, pageRows, entryEntities, pageIndex, taskId, personPageId, coverType);
        int rowCount = isView ? CalResultCoverHelper.getCacheResultCoverDataCount(taskId, personPageId) : CalResultCoverHelper.getRowCount(pageCache, taskId, personPageId, coverType, isView);
        logger.info("rowCount:{},pageRows:{}", (Object)rowCount, (Object)pageRows);
        int startRowIndex = (newPageIndex - 1) * pageRows;
        pageCache.put("currentPageIndex", newPageIndex + "");
        dataEntity.getDataEntityState().setEntryRowCount(entryKey, rowCount);
        dataEntity.getDataEntityState().setEntryStartRowIndex(entryKey, startRowIndex);
        dataEntity.getDataEntityState().setEntryPageSize(entryKey, pageRows);
    }

    public static int getPageData(IClientViewProxy clientService, int precision, String searchText, boolean isView, int pageRows, DynamicObjectCollection entryEntities, Integer pageIndex, Long taskId, String personPageId, String coverType) {
        HashMap<String, List<Integer>> lockCellMap = new HashMap<String, List<Integer>>(16);
        HashMap<String, String> rowsIdMap = new HashMap<String, String>(16);
        List<String> waitDeletePersonIdList = CalResultCoverHelper.getWaitDeleteData(personPageId, taskId);
        Map<String, String> sortColumnMap = CalResultCoverHelper.assemblePersonSortColumnMap(taskId);
        long start = System.currentTimeMillis();
        if (SWCStringUtils.equals((String)"1", (String)coverType)) {
            List<Object> curPageProrationCoverDataList = Lists.newArrayListWithExpectedSize((int)pageRows);
            if (isView) {
                logger.info("getProrationResultCoverViewPersonDataMap begin");
                pageIndex = CalResultCoverHelper.getProrationResultCoverViewPersonDataMap((List<Map<String, String>>)curPageProrationCoverDataList, taskId, personPageId, pageRows, pageIndex, searchText);
                logger.info("getProrationResultCoverViewPersonDataMap end cost:{} ms", (Object)(System.currentTimeMillis() - start));
                if (SWCListUtils.isEmpty((List)curPageProrationCoverDataList)) {
                    return 1;
                }
                sortColumnMap.put("6", "itemname|asc");
                sortColumnMap.put("7", "startdate|asc");
                CalResultCoverHelper.sortProrationPersonData(sortColumnMap, (List<Map<String, String>>)curPageProrationCoverDataList);
                CalResultCoverHelper.addProrationCoverEntryData(null, true, waitDeletePersonIdList, rowsIdMap, pageRows, pageIndex, precision, entryEntities, curPageProrationCoverDataList, new HashMap<Long, Set<Long>>(0), lockCellMap);
            } else {
                List<Map<String, String>> prorationCoverDataList = CalResultCoverHelper.getCacheProrationCoverDataList(taskId, personPageId, false);
                List<Map<String, String>> matchProrationPersonDataList = CalResultCoverHelper.getMatchProrationPersonDataList(prorationCoverDataList, searchText);
                if (matchProrationPersonDataList.size() == 0) {
                    return 1;
                }
                sortColumnMap.put("6", "itemname|asc");
                sortColumnMap.put("7", "startdate|asc");
                CalResultCoverHelper.sortProrationPersonData(sortColumnMap, matchProrationPersonDataList);
                if (matchProrationPersonDataList.size() < pageRows) {
                    pageIndex = 1;
                    curPageProrationCoverDataList.addAll(matchProrationPersonDataList);
                } else {
                    curPageProrationCoverDataList = CalResultCoverHelper.getCurPageProrationCoverDataList(matchProrationPersonDataList, pageRows, pageIndex);
                    while (SWCListUtils.isEmpty((List)curPageProrationCoverDataList)) {
                        if (pageIndex > 0) {
                            pageIndex = pageIndex - 1;
                            curPageProrationCoverDataList = CalResultCoverHelper.getCurPageProrationCoverDataList(matchProrationPersonDataList, pageRows, pageIndex);
                            continue;
                        }
                        return 1;
                    }
                }
                HashSet<Long> personIdSet = new HashSet<Long>(16);
                HashSet<Long> itemIdSet = new HashSet<Long>(16);
                for (Map map : curPageProrationCoverDataList) {
                    personIdSet.add(Long.valueOf((String)map.get("personid")));
                    itemIdSet.add(Long.valueOf((String)map.get("itemid")));
                }
                Map<Long, Set<Long>> existPersonItemMap = CalResultCoverHelper.assembleExistPersonItemMap(new ArrayList<Long>(personIdSet), new ArrayList<Long>(itemIdSet), "2");
                Map<String, String> map = CalResultCoverHelper.getMemoChangeData(personPageId, taskId);
                CalResultCoverHelper.addProrationCoverEntryData(map, false, waitDeletePersonIdList, rowsIdMap, pageRows, pageIndex, precision, entryEntities, curPageProrationCoverDataList, existPersonItemMap, lockCellMap);
            }
        } else if (SWCStringUtils.equals((String)"2", (String)coverType)) {
            List<Long> personIdList;
            Map<Object, Object> matchPersonDataMap;
            Map<String, Map<String, String>> salaryItemMap = CalResultCoverHelper.getCacheSalaryItemMap(taskId, personPageId);
            Map<Long, Map<Long, Object>> itemDataMap = new HashMap<Long, Map<Long, Object>>(16);
            if (isView) {
                matchPersonDataMap = Maps.newLinkedHashMapWithExpectedSize((int)pageRows);
                logger.info("getSumResultCoverViewPersonDataMap begin");
                pageIndex = CalResultCoverHelper.getResultCoverViewPersonDataMap(itemDataMap, (Map<String, Map<String, String>>)matchPersonDataMap, taskId, personPageId, pageRows, pageIndex, searchText);
                logger.info("getSumResultCoverViewPersonDataMap end cost:{} ms", (Object)(System.currentTimeMillis() - start));
                if (matchPersonDataMap.size() == 0) {
                    return 1;
                }
                personIdList = matchPersonDataMap.keySet().stream().map(single -> Long.parseLong(single)).collect(Collectors.toList());
                logger.info("matchPersonDataMap.personIdList.size:{}", (Object)personIdList.size());
                CalResultCoverHelper.addSumCoverEntryData(null, rowsIdMap, precision, isView, pageRows, entryEntities, pageIndex, salaryItemMap, matchPersonDataMap, personIdList, itemDataMap, lockCellMap, new HashMap<Long, Set<Long>>(0));
            } else {
                Map<String, Map<String, String>> personSimpleDataMap = CalResultCoverHelper.getCachePersonSimpleDataMap(taskId, personPageId, isView);
                matchPersonDataMap = CalResultCoverHelper.getMatchSumPersonDataMap(personSimpleDataMap = CalResultCoverHelper.sortSumPersonData(sortColumnMap, personSimpleDataMap), searchText);
                if (matchPersonDataMap.size() == 0) {
                    return 1;
                }
                if (matchPersonDataMap.size() < pageRows) {
                    pageIndex = 1;
                    personIdList = matchPersonDataMap.keySet().stream().map(personId -> Long.valueOf(personId)).collect(Collectors.toList());
                } else {
                    personIdList = CalResultCoverHelper.getCurPagePersonIdList(matchPersonDataMap, pageRows, pageIndex);
                    while (SWCListUtils.isEmpty(personIdList)) {
                        if (pageIndex > 0) {
                            pageIndex = pageIndex - 1;
                            personIdList = CalResultCoverHelper.getCurPagePersonIdList(matchPersonDataMap, pageRows, pageIndex);
                            continue;
                        }
                        return 1;
                    }
                }
                List<Long> itemIds = salaryItemMap.keySet().stream().map(id -> Long.valueOf(id)).collect(Collectors.toList());
                Map<String, Map<String, Object>> map = CalResultCoverHelper.getSumChangeData(personPageId, taskId);
                Map<String, String> memoChangeData = CalResultCoverHelper.getMemoChangeData(personPageId, taskId);
                itemDataMap = CalResultCoverHelper.assembleSalaryItemDataMap(waitDeletePersonIdList, map, personIdList, itemIds);
                Map<Long, Set<Long>> existPersonItemMap = CalResultCoverHelper.assembleExistPersonItemMap(personIdList, itemIds, "1");
                CalResultCoverHelper.addSumCoverEntryData(memoChangeData, rowsIdMap, precision, isView, pageRows, entryEntities, pageIndex, salaryItemMap, matchPersonDataMap, personIdList, itemDataMap, lockCellMap, existPersonItemMap);
            }
        }
        CalResultCoverHelper.cacheRowsIdMap(taskId, personPageId, rowsIdMap);
        if (!lockCellMap.isEmpty()) {
            HashMap<String, int[]> lastLockCellMap = new HashMap<String, int[]>(16);
            for (Map.Entry salaryItemNumberEntry : lockCellMap.entrySet()) {
                String salaryItemNumber = (String)salaryItemNumberEntry.getKey();
                int[] cellRowList = ((List)salaryItemNumberEntry.getValue()).stream().sorted().mapToInt(Integer::intValue).toArray();
                lastLockCellMap.put(salaryItemNumber, cellRowList);
            }
            SWCGridUtils.lockCell((IClientViewProxy)clientService, (String)"entryentity", lastLockCellMap, (boolean)true);
        }
        return pageIndex;
    }

    private static List<EntryParamContainer> createEntryBuildParam(int precision, EntityMetadata entityMetadata, Map<String, Map<String, String>> salaryItemMap, String coverType, boolean isView) {
        Features copyAndExport = EntryParamContainerBaseHelper.createInitFeature((boolean)false);
        copyAndExport.setCopyable(true);
        copyAndExport.setExportable(true);
        ArrayList<EntryParamContainer> allContainer = new ArrayList<EntryParamContainer>(10);
        CalResultCoverHelper.addFixedField(entityMetadata, copyAndExport, allContainer);
        if (SWCStringUtils.equals((String)"1", (String)coverType)) {
            CalResultCoverHelper.addProrationTypeField(precision, entityMetadata, copyAndExport, allContainer, isView);
        } else if (SWCStringUtils.equals((String)"2", (String)coverType)) {
            CalResultCoverHelper.addSumTypeField(precision, entityMetadata, copyAndExport, allContainer, salaryItemMap, isView);
        }
        return allContainer;
    }

    private static void addSumTypeField(int precision, EntityMetadata entityMetadata, Features copyAndExport, List<EntryParamContainer> allContainer, Map<String, Map<String, String>> salaryItemMap, boolean isView) {
        String lock;
        String string = lock = isView ? "new,edit,view,submit,audit" : "";
        if (salaryItemMap == null || salaryItemMap.size() == 0) {
            return;
        }
        if (!isView) {
            String memoStr = ResManager.loadKDString((String)"\u5907\u6ce8", (String)"CalResultCoverHelper_7", (String)"swc-hsas-business", (Object[])new Object[0]);
            TextFieldParamContainer memo = CalResultCoverHelper.getTextFieldParamContainer("memo", memoStr, "180px", false, entityMetadata, copyAndExport, lock, 255);
            allContainer.add((EntryParamContainer)memo);
        }
        for (Map.Entry<String, Map<String, String>> itemEntry : salaryItemMap.entrySet()) {
            String itemId = "key_" + itemEntry.getKey();
            Map<String, String> itemMap = itemEntry.getValue();
            String dataType = itemMap.get("datatype");
            String itemName = itemMap.get("itemname");
            int dataLength = Integer.parseInt(itemMap.get("datalength"));
            int scale = Integer.parseInt(itemMap.get("scale"));
            if (SWCStringUtils.equals((String)SWCShowType.DATE.getCode(), (String)dataType)) {
                DateParamContainer dateField = CalResultCoverHelper.getDateParamContainer(itemId, itemName, "180px", false, entityMetadata, copyAndExport, lock);
                dateField.setRegionType(1);
                allContainer.add((EntryParamContainer)dateField);
                continue;
            }
            if (SWCStringUtils.equals((String)SWCShowType.AMOUNT.getCode(), (String)dataType)) {
                DecimalFieldParamContainer amountField = CalResultCoverHelper.getDecimalFieldParamContainer(itemId, itemName, "180px", false, entityMetadata, copyAndExport, precision, lock);
                allContainer.add((EntryParamContainer)amountField);
                continue;
            }
            if (SWCStringUtils.equals((String)SWCShowType.NUM.getCode(), (String)dataType)) {
                DecimalFieldParamContainer decimalField = CalResultCoverHelper.getDecimalFieldParamContainer(itemId, itemName, "180px", false, entityMetadata, copyAndExport, scale, lock);
                allContainer.add((EntryParamContainer)decimalField);
                continue;
            }
            TextFieldParamContainer textField = CalResultCoverHelper.getTextFieldParamContainer(itemId, itemName, "180px", false, entityMetadata, copyAndExport, lock, dataLength);
            allContainer.add((EntryParamContainer)textField);
        }
    }

    private static void addProrationTypeField(int precision, EntityMetadata entityMetadata, Features copyAndExport, List<EntryParamContainer> allContainer, boolean isView) {
        String lock = isView ? "new,edit,view,submit,audit" : "";
        TextFieldParamContainer itemId = CalResultCoverHelper.getTextFieldParamContainer("itemid", "itemid", "180px", true, entityMetadata, copyAndExport, "new,edit,view,submit,audit", 200);
        allContainer.add((EntryParamContainer)itemId);
        String itemNameStr = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee", (String)"CalResultCoverHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]);
        TextFieldParamContainer itemName = CalResultCoverHelper.getTextFieldParamContainer("itemname", itemNameStr, "180px", false, entityMetadata, copyAndExport, "new,edit,view,submit,audit", 200);
        allContainer.add((EntryParamContainer)itemName);
        String startDateStr = ResManager.loadKDString((String)"\u5206\u6bb5\u5f00\u59cb\u65e5\u671f", (String)"CalResultCoverHelper_4", (String)"swc-hsas-business", (Object[])new Object[0]);
        DateParamContainer startDate = CalResultCoverHelper.getDateParamContainer("startdate", startDateStr, "180px", false, entityMetadata, copyAndExport, "new,edit,view,submit,audit");
        allContainer.add((EntryParamContainer)startDate);
        String endDateStr = ResManager.loadKDString((String)"\u5206\u6bb5\u7ed3\u675f\u65e5\u671f", (String)"CalResultCoverHelper_5", (String)"swc-hsas-business", (Object[])new Object[0]);
        DateParamContainer endDate = CalResultCoverHelper.getDateParamContainer("enddate", endDateStr, "180px", false, entityMetadata, copyAndExport, "new,edit,view,submit,audit");
        allContainer.add((EntryParamContainer)endDate);
        String coverValueStr = ResManager.loadKDString((String)"\u8986\u76d6\u503c", (String)"CalResultCoverHelper_6", (String)"swc-hsas-business", (Object[])new Object[0]);
        DecimalFieldParamContainer coverValue = CalResultCoverHelper.getDecimalFieldParamContainer("value", coverValueStr, "180px", false, entityMetadata, copyAndExport, precision, lock);
        allContainer.add((EntryParamContainer)coverValue);
        if (!isView) {
            String memoStr = ResManager.loadKDString((String)"\u5907\u6ce8", (String)"CalResultCoverHelper_7", (String)"swc-hsas-business", (Object[])new Object[0]);
            TextFieldParamContainer memo = CalResultCoverHelper.getTextFieldParamContainer("memo", memoStr, "180px", false, entityMetadata, copyAndExport, lock, 255);
            allContainer.add((EntryParamContainer)memo);
        }
    }

    private static void addFixedField(EntityMetadata entityMetadata, Features copyAndExport, List<EntryParamContainer> allContainer) {
        TextFieldParamContainer id = CalResultCoverHelper.getTextFieldParamContainer("idstr", "idstr", "180px", true, entityMetadata, copyAndExport, "new,edit,view,submit,audit", 200);
        allContainer.add((EntryParamContainer)id);
        TextFieldParamContainer personId = CalResultCoverHelper.getTextFieldParamContainer("personid", "personid", "180px", true, entityMetadata, copyAndExport, "new,edit,view,submit,audit", 200);
        allContainer.add((EntryParamContainer)personId);
        String numberStr = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7", (String)"CalResultCoverHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]);
        TextFieldParamContainer fileNumber = CalResultCoverHelper.getTextFieldParamContainer("filenumber", numberStr, "180px", false, entityMetadata, copyAndExport, "new,edit,view,submit,audit", 200);
        allContainer.add((EntryParamContainer)fileNumber);
        String nameStr = ResManager.loadKDString((String)"\u59d3\u540d", (String)"CalResultCoverHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]);
        TextFieldParamContainer name = CalResultCoverHelper.getTextFieldParamContainer("name", nameStr, "180px", false, entityMetadata, copyAndExport, "new,edit,view,submit,audit", 200);
        allContainer.add((EntryParamContainer)name);
        String empNumberStr = ResManager.loadKDString((String)"\u5de5\u53f7", (String)"CalResultCoverHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]);
        TextFieldParamContainer empNumber = CalResultCoverHelper.getTextFieldParamContainer("empnumber", empNumberStr, "180px", false, entityMetadata, copyAndExport, "new,edit,view,submit,audit", 200);
        allContainer.add((EntryParamContainer)empNumber);
    }

    private static DecimalFieldParamContainer getDecimalFieldParamContainer(String key, String name, String width, boolean hide, EntityMetadata entityMetadata, Features features, int scale, String lock) {
        DecimalFieldParamContainer field = new DecimalFieldParamContainer();
        field.setKey(key);
        field.setName(name);
        field.setWidth(width);
        field.setZeroShow(true);
        field.setEnableNull(true);
        field.setScale(scale);
        field.setPrecision(13 + scale);
        field.setLock(lock);
        field.setTextAlign("right");
        if (hide) {
            field.setVisible("");
        }
        field.setEntityMetadata(entityMetadata);
        field.setFeatures(features);
        return field;
    }

    private static DateParamContainer getDateParamContainer(String key, String name, String width, boolean hide, EntityMetadata entityMetadata, Features features, String lock) {
        DateParamContainer field = new DateParamContainer();
        field.setKey(key);
        field.setName(name);
        field.setWidth(width);
        field.setLock(lock);
        field.setRegionType(1);
        if (hide) {
            field.setVisible("");
        }
        field.setEntityMetadata(entityMetadata);
        field.setFeatures(features);
        return field;
    }

    private static TextFieldParamContainer getTextFieldParamContainer(String key, String name, String width, boolean hide, EntityMetadata entityMetadata, Features copyAndExport, String lock, int dataLength) {
        TextFieldParamContainer field = new TextFieldParamContainer();
        field.setKey(key);
        field.setName(name);
        field.setWidth(width);
        field.setLock(lock);
        field.setMaxLength(dataLength);
        if (fixedField.contains(key)) {
            field.setFixed(true);
        }
        if (hide) {
            field.setVisible("");
        }
        field.setEntityMetadata(entityMetadata);
        field.setFeatures(copyAndExport);
        return field;
    }

    public static DynamicObjectCollection getCalPersonData(List<Long> selectedRowIdList, String permItemId) {
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        String fields = "id,calstatus,taxstatus,onholdstatus,filenumber,name,empnumber,salaryfile.id,caltask.country.id";
        QFilter idCondition = new QFilter("id", "in", selectedRowIdList);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)permItemId);
        if (authorizedDataRuleQFilter != null) {
            filterList.addAll(authorizedDataRuleQFilter);
        } else {
            filterList.add(new QFilter("1", "!=", (Object)1));
        }
        filterList.add(idCondition);
        logger.info("getCalPersonData_filter:{}", (Object)((Object)filterList).toString());
        return calPersonHelper.queryOriginalCollection(fields, filterList.toArray(new QFilter[filterList.size()]), "filenumber asc");
    }

    public static List<Map<String, String>> assembleSelectedProrationCoverDataList(Long taskId, List<String> selectedIdStrList, boolean exportAll) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_proratecoverdata");
        QFilter filter = exportAll ? new QFilter("caltaskid", "=", (Object)taskId) : CalResultCoverHelper.getProrationQFilterByIdstrList(selectedIdStrList);
        String fields = "caltaskid,calperson,salaryitem.id,salaryitem.name,salaryitem.calblock,startdate,enddate,covervalue,datasource";
        DynamicObjectCollection objects = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        Set<Long> personIdSet = objects.stream().map(obj -> obj.getLong("calperson")).collect(Collectors.toSet());
        Map<String, String> prorationCoverMap = CalResultCoverHelper.getProrationCoverDataMap(objects);
        HashMap<String, String> prorationCoverDataMap = new HashMap<String, String>(16);
        if (exportAll) {
            prorationCoverDataMap.putAll(prorationCoverMap);
        } else {
            selectedIdStrList.stream().forEach(idstr -> {
                String cfr_ignored_0 = (String)prorationCoverDataMap.put((String)idstr, (String)prorationCoverMap.get(idstr));
            });
        }
        Map<String, Map<String, String>> personDataMap = CalResultCoverHelper.getPersonDataMap(personIdSet);
        List<DynamicObject> dataList = objects.stream().collect(Collectors.toList());
        return CalResultCoverHelper.assembleProrationCoverCacheData(true, prorationCoverDataMap, personDataMap, dataList);
    }

    public static List<Map<String, String>> assembleProrationItemCoverDataList(Long taskId, List<DynamicObject> personProrationItemList, boolean isView) {
        Set<Long> personIdSet = personProrationItemList.stream().map(person -> person.getLong("calpersonid")).collect(Collectors.toSet());
        Set itemIdSet = personProrationItemList.stream().map(data -> data.getLong("salaryitem.id")).collect(Collectors.toSet());
        Map<Long, String> declareStatusMap = CalResultCoverHelper.getCalPersonTaxDeclareStatus(taskId, new ArrayList<Long>(personIdSet));
        logger.info("assembleProrationItemCoverDataList_declareStatusMap:{}", (Object)declareStatusMap.toString());
        ArrayList<Long> lockedPersonIdList = new ArrayList<Long>(10);
        for (Map.Entry<Long, String> entry : declareStatusMap.entrySet()) {
            if (!SWCStringUtils.equals((String)"1", (String)entry.getValue())) continue;
            lockedPersonIdList.add(entry.getKey());
        }
        if (!isView) {
            personIdSet.removeAll(lockedPersonIdList);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_proratecoverdata");
        QFilter filter = new QFilter("calperson", "in", personIdSet);
        filter.and("salaryitem.id", "in", itemIdSet);
        String fields = "caltaskid,calperson,salaryitem.id,salaryitem.name,salaryitem.calblock,startdate,enddate,covervalue,datasource";
        long start = System.currentTimeMillis();
        logger.info("queryProrationCoverData begin");
        DynamicObjectCollection objects = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        logger.info("queryProrationCoverData end cost:{} ms", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        Map<String, String> prorationCoverMap = CalResultCoverHelper.getProrationCoverDataMap(objects);
        Map<String, Map<String, String>> personDataMap = CalResultCoverHelper.getPersonDataMap(personIdSet);
        logger.info("getProrationPersonDataMap cost:{} ms", (Object)(System.currentTimeMillis() - start));
        List<Object> dataList = isView ? objects.stream().collect(Collectors.toList()) : personProrationItemList;
        return CalResultCoverHelper.assembleProrationCoverCacheData(isView, prorationCoverMap, personDataMap, dataList);
    }

    private static List<Map<String, String>> assembleProrationCoverCacheData(boolean isView, Map<String, String> prorationCoverMap, Map<String, Map<String, String>> personDataMap, List<DynamicObject> dataList) {
        ArrayList prorationCoverDataList = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject obj : dataList) {
            HashMap personItemMap = Maps.newHashMapWithExpectedSize((int)8);
            String personId = isView ? obj.getString("calperson") : obj.getString("calpersonid");
            Map<String, String> tempPersonMap = personDataMap.get(personId);
            if (tempPersonMap == null || tempPersonMap.size() == 0) continue;
            String calStatus = tempPersonMap.get("calstatus");
            String itemId = obj.getString("salaryitem.id");
            String startDate = SWCDateTimeUtils.format((Date)obj.getDate("startdate"), (String)"yyyy-MM-dd");
            String endDate = SWCDateTimeUtils.format((Date)obj.getDate("enddate"), (String)"yyyy-MM-dd");
            StringBuilder rowsIdSb = new StringBuilder();
            rowsIdSb.append(personId).append('#').append(itemId).append('#').append(startDate).append('#').append(endDate);
            String idStr = rowsIdSb.toString();
            if (isView && !prorationCoverMap.containsKey(idStr)) continue;
            personItemMap.put("idstr", idStr);
            personItemMap.put("personid", personId);
            personItemMap.put("filenumber", tempPersonMap.get("filenumber"));
            personItemMap.put("salaryfileid", tempPersonMap.get("salaryfileid"));
            personItemMap.put("name", tempPersonMap.get("name"));
            personItemMap.put("empnumber", tempPersonMap.get("empnumber"));
            personItemMap.put("itemid", itemId);
            personItemMap.put("itemname", obj.getString("salaryitem.name"));
            personItemMap.put("startdate", startDate);
            personItemMap.put("enddate", endDate);
            personItemMap.put("calstatus", calStatus);
            personItemMap.put("calblock", obj.getString("salaryitem.calblock"));
            String coverValue = prorationCoverMap.get(idStr);
            if (SWCStringUtils.isNotEmpty((String)coverValue)) {
                personItemMap.put("covervalue", coverValue);
            }
            prorationCoverDataList.add(personItemMap);
        }
        return prorationCoverDataList;
    }

    public static Map<String, Map<String, String>> getPersonDataMap(Collection<Long> personIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", personIdSet);
        DynamicObjectCollection personObjs = helper.queryOriginalCollection("id,salaryfile.id,filenumber,name,empnumber,calstatus", new QFilter[]{filter});
        HashMap<String, Map<String, String>> personDataMap = new HashMap<String, Map<String, String>>(16);
        for (DynamicObject personObj : personObjs) {
            String pid = personObj.getString("id");
            HashMap<String, String> dataMap = new HashMap<String, String>(3);
            dataMap.put("filenumber", personObj.getString("filenumber"));
            dataMap.put("name", personObj.getString("name"));
            dataMap.put("empnumber", personObj.getString("empnumber"));
            dataMap.put("calstatus", personObj.getString("calstatus"));
            dataMap.put("salaryfileid", personObj.getString("salaryfile.id"));
            personDataMap.put(pid, dataMap);
        }
        return personDataMap;
    }

    private static Map<String, String> getProrationCoverDataMap(DynamicObjectCollection objects) {
        HashMap prorationCoverMap = Maps.newHashMapWithExpectedSize((int)10);
        if (!SWCListUtils.isEmpty((List)objects)) {
            for (DynamicObject coverObj : objects) {
                StringBuilder idStrSb = new StringBuilder();
                String personId = coverObj.getString("calperson");
                String itemId = coverObj.getString("salaryitem.id");
                String startDate = SWCDateTimeUtils.format((Date)coverObj.getDate("startdate"), (String)"yyyy-MM-dd");
                String endDate = SWCDateTimeUtils.format((Date)coverObj.getDate("enddate"), (String)"yyyy-MM-dd");
                String coverValue = coverObj.getString("covervalue");
                idStrSb.append(personId).append('#').append(itemId).append('#').append(startDate).append('#').append(endDate);
                prorationCoverMap.put(idStrSb.toString(), coverValue);
            }
        }
        return prorationCoverMap;
    }

    public static Map<String, Map<String, String>> assembleCalPersonSimpleDataMap(List<DynamicObject> validCalPersonList, Long taskId, boolean isView) {
        LinkedHashMap<String, Map<String, String>> calPersonSimpleDataMap = new LinkedHashMap<String, Map<String, String>>(validCalPersonList.size());
        if (SWCListUtils.isEmpty(validCalPersonList)) {
            return calPersonSimpleDataMap;
        }
        List<Long> personIdList = validCalPersonList.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
        Map<Long, String> declareStatusMap = CalResultCoverHelper.getCalPersonTaxDeclareStatus(taskId, personIdList);
        Map<String, String> sortColumnMap = CalResultCoverHelper.assemblePersonSortColumnMap(taskId);
        for (DynamicObject obj : validCalPersonList) {
            long personId = obj.getLong("id");
            String taxStatus = declareStatusMap.get(personId);
            if (!isView && SWCStringUtils.equals((String)"1", (String)taxStatus)) continue;
            Map dataMap = calPersonSimpleDataMap.getOrDefault(personId + "", new HashMap(7));
            dataMap.put("id", obj.getString("id"));
            dataMap.put("name", obj.getString("name"));
            dataMap.put("filenumber", obj.getString("filenumber"));
            dataMap.put("empnumber", obj.getString("empnumber"));
            dataMap.put("calstatus", obj.getString("calstatus"));
            dataMap.put("taxstatus", obj.getString("taxstatus"));
            dataMap.put("salaryfile", obj.getString("salaryfile.id"));
            dataMap.put("locked", taxStatus);
            if (sortColumnMap != null && sortColumnMap.size() > 0) {
                for (String sortKey : sortColumnMap.values()) {
                    String sortKeyValue;
                    String[] split = sortKey.split("\\|");
                    String column = split[0];
                    if (SWCStringUtils.isEmpty((String)column) || !SWCStringUtils.isEmpty((String)(sortKeyValue = (String)dataMap.get(column)))) continue;
                    dataMap.put(column, obj.getString(column));
                }
            }
            calPersonSimpleDataMap.put(personId + "", dataMap);
        }
        return calPersonSimpleDataMap;
    }

    public static Map<Long, Map<Long, Map<String, Object>>> getCalDataMap(Long taskId, List<Long> calResultIdList) {
        DynamicObject[] calTables;
        HashMap<Long, Map<Long, Map<String, Object>>> calDataMap = new HashMap<Long, Map<Long, Map<String, Object>>>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        String calTableFields = "id,calpersonid,hsas_caltableentry.salaryitem,hsas_caltableentry.calamountvalue,hsas_caltableentry.textvalue,hsas_caltableentry.numvalue,hsas_caltableentry.datevalue,hsas_caltableentry.isnull";
        QFilter calTableFilter = new QFilter("caltask", "=", (Object)taskId);
        calTableFilter.and("id", "in", calResultIdList);
        for (DynamicObject object : calTables = helper.queryOriginalArray(calTableFields, new QFilter[]{calTableFilter})) {
            long personId = object.getLong("calpersonid");
            Map dataMap = calDataMap.getOrDefault(personId, new HashMap(16));
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            data.put("itemId", object.getLong("hsas_caltableentry.salaryitem"));
            data.put("numvalue", object.getInt("hsas_caltableentry.numvalue"));
            data.put("datevalue", object.getDate("hsas_caltableentry.datevalue"));
            data.put("textvalue", object.getString("hsas_caltableentry.textvalue"));
            data.put("calamountvalue", object.getBigDecimal("hsas_caltableentry.calamountvalue"));
            dataMap.put(object.getLong("hsas_caltableentry.salaryitem"), data);
            calDataMap.put(personId, dataMap);
        }
        return calDataMap;
    }

    public static Map<String, String> assemblePersonSortColumnMap(Long calTaskId) {
        CalResultCoverService coverService = new CalResultCoverService();
        return coverService.getPersonSortColumnInfo(calTaskId);
    }

    public static Map<Long, String> getCalPersonTaxDeclareStatus(Long taskId, List<Long> calPersonIdList) {
        Map responese;
        logger.info("getCalPersonTaxDeclareStatus begin");
        long start = System.currentTimeMillis();
        HashMap<Long, String> statusResultMap = new HashMap<Long, String>(16);
        if (SWCListUtils.isEmpty(calPersonIdList)) {
            return statusResultMap;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        DynamicObjectCollection taskObjs = helper.queryOriginalCollection("paydate,country.id", new QFilter[]{filter});
        String countryId = String.valueOf(((DynamicObject)taskObjs.get(0)).getLong("country.id"));
        Date payDate = ((DynamicObject)taskObjs.get(0)).getDate("paydate");
        HashMap<String, Object> request = new HashMap<String, Object>(4);
        request.put("srcType", "1");
        request.put("langCode", Lang.get().getLangTag());
        request.put("data", calPersonIdList);
        request.put("country", countryId);
        request.put("payDate", payDate);
        try {
            responese = (Map)SWCMServiceUtils.invokeSITService((String)"sitcs", (String)"IndividualTaxCalService", (String)"getDataStatus", (Object[])new Object[]{request});
        }
        catch (Exception exception) {
            logger.error("getDataStatus error", (Throwable)exception);
            return statusResultMap;
        }
        if (responese == null || responese.size() == 0) {
            logger.error("\u4e2a\u7a0e\u63a5\u53e3\u8fd4\u56denull");
            return statusResultMap;
        }
        Boolean success = (Boolean)responese.get("success");
        if (!success.booleanValue()) {
            logger.error("getDataStatus error,msg={}", responese.get("message"));
            return statusResultMap;
        }
        Map dataMap = (Map)responese.get("data");
        if (null == dataMap || dataMap.size() == 0) {
            logger.error("\u65e0\u4e2a\u7a0e\u8fd4\u56de\u6570\u636e");
            return statusResultMap;
        }
        Map tempDataMap = null;
        for (Map.Entry entry : dataMap.entrySet()) {
            tempDataMap = (Map)entry.getValue();
            String srcDataKey = (String)tempDataMap.get("srcDataKey");
            String dataState = (String)tempDataMap.get("dataStatus");
            if (!((Boolean)tempDataMap.get("success")).booleanValue()) continue;
            String taxState = SWCStringUtils.isNotEmpty((String)dataState) && Integer.parseInt(dataState) >= 25 ? "1" : "0";
            statusResultMap.put(Long.valueOf(srcDataKey), taxState);
        }
        logger.info("getCalPersonTaxDeclareStatus end cost:{} ms", (Object)(System.currentTimeMillis() - start));
        return statusResultMap;
    }

    public static void assembleSelectedSalaryItemData(Long calPayRollTaskId, Map<Long, Map<String, String>> salaryItemMap, Map<Long, Map<String, String>> personSimpleDataMap) {
        if (personSimpleDataMap == null || personSimpleDataMap.size() == 0) {
            return;
        }
        Boolean taxCalEnable = TaxCalServiceHelper.getTaxCalEnableStatusByTaskId((Long)calPayRollTaskId);
        for (Map.Entry<Long, Map<String, String>> personEntry : personSimpleDataMap.entrySet()) {
            for (Map.Entry<Long, Map<String, String>> itemEntry : salaryItemMap.entrySet()) {
                String itemKey = String.valueOf(itemEntry.getKey());
                if (taxCalEnable.booleanValue()) {
                    boolean flag;
                    String calStatus = personEntry.getValue().get("calstatus");
                    String taxStatus = personEntry.getValue().get("taxstatus");
                    String calBlock = itemEntry.getValue().get("calblock");
                    if (SWCStringUtils.equals((String)"1", (String)calBlock)) {
                        if (SWCStringUtils.equals((String)CalStateEnum.AUDIT.getCode(), (String)calStatus) && SWCStringUtils.equals((String)TaxStateEnum.CONFIRM.getCode(), (String)taxStatus)) {
                            personEntry.getValue().put(itemKey, "0");
                        } else {
                            personEntry.getValue().put(itemKey, "1");
                        }
                    }
                    if (!SWCStringUtils.equals((String)"0", (String)calBlock)) continue;
                    boolean bl = flag = SWCStringUtils.equals((String)CalStateEnum.TAX_CALED.getCode(), (String)calStatus) && SWCStringUtils.equals((String)TaxStateEnum.GOBACK.getCode(), (String)taxStatus) || SWCStringUtils.equals((String)CalStateEnum.TAX_CALED.getCode(), (String)calStatus) && SWCStringUtils.equals((String)TaxStateEnum.PULLED.getCode(), (String)taxStatus) || SWCStringUtils.equals((String)CalStateEnum.AUDIT.getCode(), (String)calStatus) && SWCStringUtils.equals((String)TaxStateEnum.CONFIRM.getCode(), (String)taxStatus);
                    if (flag) {
                        personEntry.getValue().put(itemKey, "0");
                        continue;
                    }
                    personEntry.getValue().put(itemKey, "1");
                    continue;
                }
                personEntry.getValue().put(itemKey, "1");
            }
        }
    }

    public static void assembleSalaryItemData(Map<Long, Map<String, String>> salaryItemMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitem");
        String fields = "id,calblock,datatype.storagetype,dataprecision.scale,datalength,dataround.id";
        QFilter filter = new QFilter("id", "in", salaryItemMap.keySet());
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return;
        }
        for (DynamicObject obj : dynamicObjects) {
            Map<String, String> itemMap = salaryItemMap.get(obj.getLong("id"));
            itemMap.put("calblock", obj.getString("calblock"));
            itemMap.put("datatype", obj.getString("datatype.storagetype"));
            itemMap.put("scale", obj.getString("dataprecision.scale"));
            itemMap.put("datalength", obj.getString("datalength"));
            itemMap.put("dataround", obj.getString("dataround.id"));
        }
    }

    public static List<Long> getValidPersonIdList(List<Long> personIdList, Boolean taxCalEnable) {
        List<String> taxOnValidCalStatus = Arrays.asList(CalStateEnum.UNCAL.getCode(), CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.ALL_CALED.getCode(), CalStateEnum.PRECAL_ERROR.getCode(), CalStateEnum.PUSHTAX_ERROR.getCode(), CalStateEnum.TAXCAL_ERROR.getCode(), CalStateEnum.PULLTAX_ERROR.getCode(), CalStateEnum.AFTERCAL_ERROR.getCode(), CalStateEnum.CANCELCAL_ERROR.getCode());
        List<String> taxOffValidCalStatus = Arrays.asList(CalStateEnum.UNCAL.getCode(), CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.ALL_CALED.getCode(), CalStateEnum.PRECAL_ERROR.getCode(), CalStateEnum.AFTERCAL_ERROR.getCode(), CalStateEnum.CANCELCAL_ERROR.getCode());
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        if (SWCListUtils.isEmpty(personIdList)) {
            return new ArrayList<Long>(0);
        }
        QFilter filter = new QFilter("id", "in", personIdList);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        filterList.add(filter);
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"4730fc9f000003ae");
        if (authorizedDataRuleQFilter != null) {
            filterList.addAll(authorizedDataRuleQFilter);
        } else {
            filterList.add(new QFilter("1", "!=", (Object)1));
        }
        filterList.add(filter);
        logger.info("getValidPersonIdList.filter:{}", (Object)((Object)filterList).toString());
        DynamicObjectCollection personObjs = calPersonHelper.queryOriginalCollection("id,calstatus", filterList.toArray(new QFilter[filterList.size()]));
        if (SWCListUtils.isEmpty((List)personObjs)) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> idList = new ArrayList<Long>(personObjs.size());
        for (DynamicObject personObj : personObjs) {
            long personId = personObj.getLong("id");
            String calStatus = personObj.getString("calstatus");
            boolean valid = taxCalEnable != false && taxOnValidCalStatus.contains(calStatus) || taxCalEnable == false && taxOffValidCalStatus.contains(calStatus);
            if (!valid) continue;
            idList.add(personId);
        }
        return idList;
    }

    public static DynamicObject[] getCalPersonData(List<Long> selectedRowIdList, Long taskId, boolean selectAll, String permItemId) {
        QFilter filter;
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        String fields = "id,calstatus,taxstatus,onholdstatus,filenumber,name,empnumber,salaryfile.id,caltask.country.id";
        Map<String, String> sortColumnMap = CalResultCoverHelper.assemblePersonSortColumnMap(taskId);
        StringBuilder fieldSb = new StringBuilder();
        fieldSb.append(fields);
        if (sortColumnMap != null && sortColumnMap.size() > 0) {
            for (String sortKey : sortColumnMap.values()) {
                String[] split = sortKey.split("\\|");
                String column = split[0];
                if (fields.contains(column)) continue;
                fieldSb.append(',').append(column);
            }
        }
        if (selectAll) {
            filter = new QFilter("caltask.id", "=", (Object)taskId);
        } else if (!SWCListUtils.isEmpty(selectedRowIdList)) {
            filter = new QFilter("id", "in", selectedRowIdList);
        } else {
            return new DynamicObject[0];
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)permItemId);
        if (authorizedDataRuleQFilter != null) {
            filterList.addAll(authorizedDataRuleQFilter);
        } else {
            filterList.add(new QFilter("1", "!=", (Object)1));
        }
        filterList.add(filter);
        logger.info("getCalPersonData_filter:{}", (Object)((Object)filterList).toString());
        DynamicObjectCollection dynamicObjects = calPersonHelper.queryOriginalCollection(fieldSb.toString(), filterList.toArray(new QFilter[filterList.size()]), "filenumber asc");
        if (SWCListUtils.isEmpty((List)dynamicObjects)) {
            return new DynamicObject[0];
        }
        List<DynamicObject> objectList = dynamicObjects.stream().collect(Collectors.toList());
        return objectList.toArray(new DynamicObject[objectList.size()]);
    }

    public static List<DynamicObject> checkValidCalPersonList(Long taskId, Boolean taxCalEnable, DynamicObject[] calPersons) {
        List<String> taxOnValidCalStatus = Arrays.asList(CalStateEnum.UNCAL.getCode(), CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.ALL_CALED.getCode(), CalStateEnum.PRECAL_ERROR.getCode(), CalStateEnum.PUSHTAX_ERROR.getCode(), CalStateEnum.TAXCAL_ERROR.getCode(), CalStateEnum.PULLTAX_ERROR.getCode(), CalStateEnum.AFTERCAL_ERROR.getCode(), CalStateEnum.CANCELCAL_ERROR.getCode());
        List<String> taxOffValidCalStatus = Arrays.asList(CalStateEnum.UNCAL.getCode(), CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.ALL_CALED.getCode(), CalStateEnum.PRECAL_ERROR.getCode(), CalStateEnum.AFTERCAL_ERROR.getCode(), CalStateEnum.CANCELCAL_ERROR.getCode());
        List<Object> validCalPersonList = taxCalEnable != false ? Arrays.stream(calPersons).filter(data -> taxOnValidCalStatus.contains(data.getString("calstatus"))).collect(Collectors.toList()) : Arrays.stream(calPersons).filter(data -> taxOffValidCalStatus.contains(data.getString("calstatus"))).collect(Collectors.toList());
        if (validCalPersonList == null) {
            validCalPersonList = new ArrayList(0);
        }
        if (!SWCListUtils.isEmpty(validCalPersonList)) {
            List<Long> personIdList = validCalPersonList.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
            Map<Long, String> declareStatusMap = CalResultCoverHelper.getCalPersonTaxDeclareStatus(taskId, personIdList);
            logger.info("checkValidCalPersonList_declareStatusMap:{}", (Object)declareStatusMap.toString());
            Iterator<DynamicObject> iterator = validCalPersonList.iterator();
            while (iterator.hasNext()) {
                DynamicObject next = iterator.next();
                Long personId = next.getLong("id");
                String taxStatus = declareStatusMap.get(personId);
                if (!SWCStringUtils.equals((String)"1", (String)taxStatus)) continue;
                iterator.remove();
            }
        }
        return validCalPersonList;
    }

    public static List<DynamicObject> getProrationItemDataList(Long calRuleVid, List<Long> calPersonsIdList, boolean selectAll, Long taskId) {
        QFilter filter;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrule");
        DynamicObject calRulev = helper.queryOne((Object)calRuleVid);
        if (calRulev == null || SWCListUtils.isEmpty((List)calRulev.getDynamicObjectCollection("calruleitementry"))) {
            return new ArrayList<DynamicObject>(0);
        }
        ArrayList<Long> itemIdList = new ArrayList<Long>(10);
        DynamicObjectCollection calRuleItemEntry = calRulev.getDynamicObjectCollection("calruleitementry");
        for (DynamicObject item : calRuleItemEntry) {
            if (!SWCStringUtils.equals((String)"1", (String)item.getString("allowresultcover")) || !SWCStringUtils.isNotEmpty((String)item.getString("salaryitem.id"))) continue;
            itemIdList.add(item.getLong("salaryitem.id"));
        }
        helper = new SWCDataServiceHelper("hsas_slprorationrecord");
        String fields = "calpersonid,salaryitem.id,salaryitem.calblock,salaryitem.name,startdate,enddate";
        if (selectAll) {
            SWCDataServiceHelper personHelper = new SWCDataServiceHelper("hsas_calperson");
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
            List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"47150e89000000ac");
            if (authorizedDataRuleQFilter != null) {
                filterList.addAll(authorizedDataRuleQFilter);
            } else {
                filterList.add(new QFilter("1", "!=", (Object)1));
            }
            filter = new QFilter("caltask", "=", (Object)taskId);
            filterList.add(filter);
            logger.info("personDataAuthFilter:{}", (Object)((Object)filterList).toString());
            DynamicObjectCollection personObjs = personHelper.queryOriginalCollection("id", filterList.toArray(new QFilter[filterList.size()]));
            if (SWCListUtils.isEmpty((List)personObjs)) {
                return new ArrayList<DynamicObject>(0);
            }
            List tempPersonIdList = personObjs.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
            filter = new QFilter("calpersonid", "in", tempPersonIdList);
        } else {
            filter = new QFilter("calpersonid", "in", calPersonsIdList);
        }
        if (!SWCListUtils.isEmpty(itemIdList)) {
            filter.and(new QFilter("salaryitem.id", "in", itemIdList));
        }
        DynamicObjectCollection objects = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        return objects.stream().collect(Collectors.toList());
    }

    public static Map<String, Map<String, String>> sortSumPersonData(Map<String, String> personSortColumnMap, Map<String, Map<String, String>> personDataInfo) {
        LinkedHashMap<String, Map<String, String>> dataMap = new LinkedHashMap<String, Map<String, String>>(16);
        List sortKeyList = personSortColumnMap.values().stream().collect(Collectors.toList());
        List personIdList = personDataInfo.keySet().stream().map(id -> Long.parseLong(id)).collect(Collectors.toList());
        StringBuilder fieldSb = new StringBuilder();
        fieldSb.append("id");
        StringBuilder orderBySb = new StringBuilder();
        for (String sortKey : sortKeyList) {
            String[] split = sortKey.split("\\|");
            String column = split[0];
            String sort = split[1];
            fieldSb.append(',').append(column);
            if (SWCStringUtils.equals((String)"asc", (String)sort)) {
                orderBySb.append(column).append(" asc,");
                continue;
            }
            orderBySb.append(column).append(" desc,");
        }
        String orderByStr = "";
        if (orderBySb.length() > 0) {
            orderByStr = orderBySb.toString().substring(0, orderBySb.length() - 1);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", personIdList);
        DynamicObjectCollection personObjs = helper.queryOriginalCollection(fieldSb.toString(), new QFilter[]{filter}, orderByStr);
        if (SWCListUtils.isEmpty((List)personObjs)) {
            return dataMap;
        }
        for (DynamicObject personObj : personObjs) {
            String idStr = personObj.getString("id");
            dataMap.put(idStr, personDataInfo.get(idStr));
        }
        return dataMap;
    }

    public static List<Long> getSortedPersonIdList(List<Long> personIdList, Long taskId) {
        StringBuilder fieldSb = new StringBuilder();
        fieldSb.append("id");
        String orderByStr = CalResultCoverHelper.getOrderByStr(taskId, fieldSb);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", personIdList);
        DynamicObjectCollection personObjs = helper.queryOriginalCollection(fieldSb.toString(), new QFilter[]{filter}, orderByStr);
        if (SWCListUtils.isEmpty((List)personObjs)) {
            return personIdList;
        }
        ArrayList idList = Lists.newArrayListWithExpectedSize((int)personObjs.size());
        for (DynamicObject obj : personObjs) {
            idList.add(obj.getLong("id"));
        }
        return idList;
    }

    public static void sortProrationDataList(Map<String, String> personSortColumnMap, List<Map<String, String>> prorationCoverDataList) {
        ArrayList dataList = Lists.newArrayListWithCapacity((int)prorationCoverDataList.size());
        personSortColumnMap.remove("6");
        personSortColumnMap.remove("7");
        List sortKeyList = personSortColumnMap.values().stream().collect(Collectors.toList());
        HashSet<Long> personIdSet = new HashSet<Long>(16);
        HashMap<Long, List> dataMap = new HashMap<Long, List>(16);
        for (Map<String, String> map : prorationCoverDataList) {
            String idstr = map.get("idstr");
            String[] split = idstr.split("#");
            long personId = Long.parseLong(split[0]);
            personIdSet.add(personId);
            List list = dataMap.computeIfAbsent(personId, single -> new ArrayList(10));
            list.add(map);
        }
        StringBuilder fieldSb = new StringBuilder();
        fieldSb.append("id");
        StringBuilder orderBySb = new StringBuilder();
        for (String sortKey : sortKeyList) {
            String[] split = sortKey.split("\\|");
            String column = split[0];
            String sort = split[1];
            fieldSb.append(',').append(column);
            if (SWCStringUtils.equals((String)"asc", (String)sort)) {
                orderBySb.append(column).append(" asc,");
                continue;
            }
            orderBySb.append(column).append(" desc,");
        }
        String orderByStr = "";
        if (orderBySb.length() > 0) {
            orderByStr = orderBySb.toString().substring(0, orderBySb.length() - 1);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", personIdSet);
        DynamicObjectCollection personObjs = helper.queryOriginalCollection(fieldSb.toString(), new QFilter[]{filter}, orderByStr);
        if (SWCListUtils.isEmpty((List)personObjs)) {
            return;
        }
        for (DynamicObject personObj : personObjs) {
            Long personId = personObj.getLong("id");
            dataList.addAll((Collection)dataMap.get(personId));
        }
        prorationCoverDataList.clear();
        prorationCoverDataList.addAll(dataList);
    }

    private static void sortResultCoverData(List<Map<String, String>> collect, List<String> sortKeyList) {
        collect.sort((v1, v2) -> {
            int compare = 0;
            for (int index = sortKeyList.size(); index > 0 && (compare = CalResultCoverHelper.getCompare(v1, v2, (String)sortKeyList.get(sortKeyList.size() - index))) == 0; --index) {
            }
            return compare;
        });
    }

    private static int getCompare(Map<String, String> v1, Map<String, String> v2, String sortKey) {
        String[] split = sortKey.split("\\|");
        String column = split[0];
        int compare = SWCStringUtils.equals((String)"asc", (String)split[1]) ? (v1.get(column) == null ? 0 : v1.get(column).compareTo(v2.get(column))) : (v2.get(column) == null ? 0 : v2.get(column).compareTo(v1.get(column)));
        return compare;
    }

    public static void sortProrationPersonData(Map<String, String> personSortColumnMap, List<Map<String, String>> personDataList) {
        List<String> sortKeyList = personSortColumnMap.values().stream().collect(Collectors.toList());
        CalResultCoverHelper.sortResultCoverData(personDataList, sortKeyList);
        CalResultCoverHelper.sortProrationDataList(personSortColumnMap, personDataList);
    }

    public static Map<Long, Set<Long>> assembleExistPersonItemMap(List<Long> personIdList, List<Long> itemIds, String coverType) {
        DynamicObjectCollection objects;
        HashMap<Long, Set<Long>> existPersonItemMap = new HashMap<Long, Set<Long>>(16);
        QFilter filter = new QFilter("calperson", "in", personIdList);
        SWCDataServiceHelper helper = SWCStringUtils.equals((String)"2", (String)coverType) ? new SWCDataServiceHelper("hsas_calresultcoverdata") : new SWCDataServiceHelper("hsas_proratecoverdata");
        String fields = "calperson,salaryitem.id";
        if (!SWCListUtils.isEmpty(itemIds)) {
            filter.and("salaryitem.id", "in", itemIds);
        }
        if (SWCListUtils.isEmpty((List)(objects = helper.queryOriginalCollection(fields, new QFilter[]{filter})))) {
            return existPersonItemMap;
        }
        for (DynamicObject obj : objects) {
            long personId = obj.getLong("calperson");
            Set itemSet = existPersonItemMap.computeIfAbsent(personId, value -> new HashSet(16));
            itemSet.add(obj.getLong("salaryitem.id"));
        }
        return existPersonItemMap;
    }

    public static ResultCoverService getResultCoverService(String coverType) {
        if (SWCStringUtils.equals((String)"2", (String)coverType)) {
            return new ResultCoverSumService();
        }
        if (SWCStringUtils.equals((String)"1", (String)coverType)) {
            return new ResultCoverProrationService();
        }
        return new ResultCoverSumService();
    }

    public static void readExcelData(String url, final List<Map<Integer, String>> dataHead, final List<Map<Integer, String>> dataRow) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream in = service.getInputStream(url);){
            new ExcelReader().read(in, new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow row) {
                    if (row.getRowNum() <= 2) {
                        dataHead.add(row.getData());
                    } else {
                        dataRow.add(row.getData());
                    }
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void cacheRowsIdMap(Long taskId, String personPageId, Map<String, String> rowsIdMap) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        if (appCache == null) {
            return;
        }
        String cacheKey = String.format(Locale.ROOT, "rowsIdMap_%d_%s", taskId, personPageId);
        appCache.put(cacheKey, rowsIdMap);
    }

    private static void addProrationCoverEntryData(Map<String, String> memoChangeData, boolean isView, List<String> waitDeletePersonIdList, Map<String, String> rowsIdMap, int pageRows, int pageIndex, int precision, DynamicObjectCollection entryEntities, List<Map<String, String>> coverDataList, Map<Long, Set<Long>> existPersonItemMap, Map<String, List<Integer>> lockCellMap) {
        int rowIndex = pageRows * (pageIndex - 1) - 1;
        try {
            for (Map<String, String> dataMap : coverDataList) {
                String coverValue;
                ++rowIndex;
                Long personId = Long.valueOf(dataMap.get("personid"));
                Long itemId = Long.valueOf(dataMap.get("itemid"));
                DynamicObject singleEntry = entryEntities.addNew();
                singleEntry.set("personid", (Object)personId);
                singleEntry.set("filenumber", (Object)dataMap.get("filenumber"));
                singleEntry.set("name", (Object)dataMap.get("name"));
                singleEntry.set("empnumber", (Object)dataMap.get("empnumber"));
                singleEntry.set("itemid", (Object)itemId);
                singleEntry.set("itemname", (Object)dataMap.get("itemname"));
                singleEntry.set("startdate", (Object)SWCDateTimeUtils.parseDate((String)dataMap.get("startdate"), (String)"yyyy-MM-dd"));
                singleEntry.set("enddate", (Object)SWCDateTimeUtils.parseDate((String)dataMap.get("enddate"), (String)"yyyy-MM-dd"));
                String idStr = dataMap.get("idstr");
                if ((SWCListUtils.isEmpty(waitDeletePersonIdList) || !waitDeletePersonIdList.contains(idStr)) && SWCStringUtils.isNotEmpty((String)(coverValue = dataMap.get("covervalue"))) && !SWCStringUtils.equals((String)"null", (String)coverValue)) {
                    singleEntry.set("value", (Object)new BigDecimal(coverValue).setScale(precision, 4).toPlainString());
                }
                if (!isView && memoChangeData != null) {
                    singleEntry.set("memo", (Object)memoChangeData.get(idStr));
                }
                singleEntry.set("idstr", (Object)idStr);
                rowsIdMap.put(rowIndex + "", idStr);
                Set<Long> itemSet = existPersonItemMap.get(personId);
                if (itemSet == null || itemSet.size() == 0 || !itemSet.contains(itemId)) continue;
                List itemCellList = lockCellMap.computeIfAbsent("value", value -> new ArrayList(10));
                itemCellList.add(rowIndex);
            }
        }
        catch (ParseException exception) {
            logger.error("date parse error", (Throwable)exception);
        }
    }

    public static List<Map<String, String>> getProrationCoverDataForImport(List<Long> personIdList, Long taskId) {
        DynamicObject task = CalPayrollTaskHelper.queryTaskInfoById(taskId);
        DynamicObject calRuleHisObj = task.getDynamicObject("calrulev");
        List<DynamicObject> personProrationItemList = CalResultCoverHelper.getProrationItemDataList(calRuleHisObj.getLong("id"), personIdList, false, taskId);
        if (SWCListUtils.isEmpty(personProrationItemList)) {
            return new ArrayList<Map<String, String>>(0);
        }
        Set itemIdSet = personProrationItemList.stream().map(single -> single.getLong("salaryitem.id")).collect(Collectors.toSet());
        Map<String, Map<String, String>> personDataMap = CalResultCoverHelper.getPersonDataMap(personIdList);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitem");
        String fields = "id,name";
        QFilter filter = new QFilter("id", "in", itemIdSet);
        DynamicObjectCollection objects = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        HashMap<Long, String> itemMap = new HashMap<Long, String>(16);
        for (DynamicObject obj : objects) {
            itemMap.put(obj.getLong("id"), obj.getString("name"));
        }
        ArrayList<Map<String, String>> prorationCoverDataList = new ArrayList<Map<String, String>>(personProrationItemList.size());
        for (DynamicObject obj : personProrationItemList) {
            HashMap personItemMap = Maps.newHashMapWithExpectedSize((int)8);
            String personId = obj.getString("calpersonid");
            String itemId = obj.getString("salaryitem.id");
            String startDate = SWCDateTimeUtils.format((Date)obj.getDate("startdate"), (String)"yyyy-MM-dd");
            String endDate = SWCDateTimeUtils.format((Date)obj.getDate("enddate"), (String)"yyyy-MM-dd");
            Map<String, String> tempPersonMap = personDataMap.get(personId);
            if (tempPersonMap == null || tempPersonMap.size() == 0) continue;
            StringBuilder rowsIdSb = new StringBuilder();
            rowsIdSb.append(personId).append('#').append(itemId).append('#').append(startDate).append('#').append(endDate);
            String idStr = rowsIdSb.toString();
            personItemMap.put("idstr", idStr);
            personItemMap.put("filenumber", tempPersonMap.get("filenumber"));
            personItemMap.put("name", tempPersonMap.get("name"));
            personItemMap.put("empnumber", tempPersonMap.get("empnumber"));
            personItemMap.put("itemname", itemMap.get(Long.parseLong(itemId)));
            personItemMap.put("startdate", startDate);
            personItemMap.put("enddate", endDate);
            prorationCoverDataList.add(personItemMap);
        }
        return prorationCoverDataList;
    }

    public static Map<Long, Long> getProrationPersonSalaryfileMap(List<String> personIdStrList) {
        HashMap<Long, Long> personSalaryfileMap = new HashMap<Long, Long>(16);
        if (SWCListUtils.isEmpty(personIdStrList)) {
            return personSalaryfileMap;
        }
        HashSet<Long> personIdSet = new HashSet<Long>(16);
        for (String idStr : personIdStrList) {
            String[] split = idStr.split("#");
            String personId = split[0];
            personIdSet.add(Long.parseLong(personId));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", personIdSet);
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection("id,salaryfile.id", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)dynamicObjects)) {
            return personSalaryfileMap;
        }
        for (DynamicObject personObj : dynamicObjects) {
            long personId = personObj.getLong("id");
            long salaryFileId = personObj.getLong("salaryfile.id");
            personSalaryfileMap.put(personId, salaryFileId);
        }
        return personSalaryfileMap;
    }

    public static List<Map<String, String>> getCacheProrationCoverDataList(Long taskId, String personPageId, boolean isView) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        if (appCache == null) {
            return new ArrayList<Map<String, String>>(0);
        }
        String cacheKey = String.format(Locale.ROOT, "prorationCoverData_%d_%s", taskId, personPageId);
        List prorationCoverDataList = (List)appCache.get(cacheKey, List.class);
        Map<String, Object> prorationCoverChangeDataMap = CalResultCoverHelper.getProrationChangeData(personPageId, taskId);
        if (SWCListUtils.isEmpty((List)prorationCoverDataList)) {
            return new ArrayList<Map<String, String>>(0);
        }
        List<String> idStrList = prorationCoverDataList.stream().map(single -> (String)single.get("idstr")).collect(Collectors.toList());
        List<Map<String, String>> existCoverDataList = CalResultCoverHelper.assembleSelectedProrationCoverDataList(taskId, idStrList, isView);
        if (!SWCListUtils.isEmpty(existCoverDataList)) {
            Iterator existDataMap = existCoverDataList.stream().collect(Collectors.toMap(key -> (String)key.get("idstr"), Function.identity()));
            for (Map dataMap : prorationCoverDataList) {
                String idstr = (String)dataMap.get("idstr");
                Map singleMap = (Map)existDataMap.get(idstr);
                if (singleMap != null) {
                    dataMap.put("covervalue", singleMap.get("covervalue"));
                    continue;
                }
                dataMap.remove("covervalue");
            }
        } else {
            for (Map dataMap : prorationCoverDataList) {
                dataMap.remove("covervalue");
            }
        }
        if (prorationCoverChangeDataMap != null && prorationCoverChangeDataMap.size() > 0) {
            for (Map dataMap : prorationCoverDataList) {
                String idstr = (String)dataMap.get("idstr");
                Object coverValue = prorationCoverChangeDataMap.get(idstr);
                if (coverValue == null) continue;
                dataMap.put("covervalue", coverValue + "");
            }
        }
        if (isView) {
            Iterator iterator = prorationCoverDataList.iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                if (!SWCStringUtils.isEmpty((String)((String)map.get("covervalue")))) continue;
                iterator.remove();
            }
        }
        return prorationCoverDataList;
    }

    private static void addSumCoverEntryData(Map<String, String> memoChangeData, Map<String, String> rowsIdMap, int precision, boolean isView, int pageRows, DynamicObjectCollection entryEntities, int pageIndex, Map<String, Map<String, String>> salaryItemMap, Map<String, Map<String, String>> matchPersonDataMap, List<Long> personIdList, Map<Long, Map<Long, Object>> itemDataMap, Map<String, List<Integer>> lockCellMap, Map<Long, Set<Long>> existProrationCoverDataMap) {
        int rowIndex = pageRows * (pageIndex - 1) - 1;
        for (Long personId : personIdList) {
            Map<Long, Object> itemMap = itemDataMap.get(personId);
            if (itemMap == null || itemMap.size() == 0) continue;
            boolean isEmpty = CalResultCoverHelper.checkItemDataEmpty(itemMap);
            if (isView && isEmpty) continue;
            ++rowIndex;
            Set<Long> existItemSet = existProrationCoverDataMap.get(personId);
            DynamicObject singleEntry = entryEntities.addNew();
            Map<String, String> personMap = matchPersonDataMap.get(personId + "");
            String fielNumber = personMap.get("filenumber");
            String name = personMap.get("name");
            String empNumber = personMap.get("empnumber");
            singleEntry.set("idstr", (Object)(personId + ""));
            singleEntry.set("personid", (Object)personId);
            singleEntry.set("filenumber", (Object)fielNumber);
            singleEntry.set("name", (Object)name);
            singleEntry.set("empnumber", (Object)empNumber);
            if (!isView && memoChangeData != null) {
                singleEntry.set("memo", (Object)memoChangeData.get(personId + ""));
            }
            CalResultCoverHelper.addSumTypeFieldData(rowIndex, singleEntry, salaryItemMap, itemMap, personMap, lockCellMap, precision, existItemSet);
            rowsIdMap.put(rowIndex + "", personId + "");
        }
    }

    public static void cacheSearchText(String searchText, Long taskId, String personPageId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        String cacheKey = String.format(Locale.ROOT, "curSearchText_%d_%s", taskId, personPageId);
        appCache.put(cacheKey, (Object)searchText);
    }

    public static void cleanCacheSearchText(Long taskId, String personPageId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        String cacheKey = String.format(Locale.ROOT, "curSearchText_%d_%s", taskId, personPageId);
        appCache.remove(cacheKey);
    }

    public static String getCacheSearchText(Long taskId, String pageId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        if (appCache == null) {
            return "";
        }
        String cacheKey = String.format(Locale.ROOT, "curSearchText_%d_%s", taskId, pageId);
        String searchText = (String)appCache.get(cacheKey, String.class);
        if (SWCStringUtils.isEmpty((String)searchText)) {
            searchText = "";
        }
        return searchText;
    }

    private static boolean checkItemDataEmpty(Map<Long, Object> itemData) {
        boolean isEmpty = true;
        for (Map.Entry<Long, Object> data : itemData.entrySet()) {
            if (SWCObjectUtils.isEmpty((Object)data.getValue())) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }

    private static void addSumTypeFieldData(int rowIndex, DynamicObject singleEntry, Map<String, Map<String, String>> itemMap, Map<Long, Object> itemDataMap, Map<String, String> personMap, Map<String, List<Integer>> lockCellMap, int precision, Set<Long> existItemSet) {
        try {
            for (Map.Entry<String, Map<String, String>> entry : itemMap.entrySet()) {
                String itemId = entry.getKey();
                String key = "key_" + itemId;
                String dataType = entry.getValue().get("datatype");
                String scale = entry.getValue().get("scale");
                String dataround = entry.getValue().get("dataround");
                Object value = itemDataMap.get(Long.valueOf(itemId));
                if (SWCStringUtils.equals((String)SWCShowType.DATE.getCode(), (String)dataType) && value != null) {
                    singleEntry.set(key, value);
                } else if (SWCStringUtils.equals((String)SWCShowType.AMOUNT.getCode(), (String)dataType) && value != null) {
                    singleEntry.set(key, (Object)new BigDecimal(value.toString()).setScale(precision, 4).toPlainString());
                } else if (SWCStringUtils.equals((String)SWCShowType.NUM.getCode(), (String)dataType) && value != null) {
                    singleEntry.set(key, (Object)new BigDecimal(value.toString()).setScale(Integer.parseInt(scale), CalResultCoverHelper.getRoundingMode(Long.parseLong(dataround))).toPlainString());
                } else {
                    singleEntry.set(key, value);
                }
                if (existItemSet == null || !existItemSet.contains(Long.valueOf(itemId))) continue;
                List itemCellList = lockCellMap.computeIfAbsent(key, list -> new ArrayList(10));
                itemCellList.add(rowIndex);
            }
        }
        catch (Exception exception) {
            logger.error("date parse error", (Throwable)exception);
        }
    }

    public static RoundingMode getRoundingMode(long dataRoundId) {
        if (dataRoundId == 1010L) {
            return RoundingMode.HALF_UP;
        }
        if (dataRoundId == 1020L) {
            return RoundingMode.DOWN;
        }
        if (dataRoundId == 1030L) {
            return RoundingMode.UP;
        }
        return RoundingMode.HALF_UP;
    }

    public static Map<String, Map<String, String>> getMatchSumPersonDataMap(Map<String, Map<String, String>> cachePersonSimpleDataMap, String searchText) {
        LinkedHashMap<String, Map<String, String>> matchPersonDataMap = new LinkedHashMap<String, Map<String, String>>(16);
        if (SWCStringUtils.isEmpty((String)searchText)) {
            matchPersonDataMap.putAll(cachePersonSimpleDataMap);
            return matchPersonDataMap;
        }
        for (Map.Entry<String, Map<String, String>> entry : cachePersonSimpleDataMap.entrySet()) {
            Map<String, String> valueMap = entry.getValue();
            String name = valueMap.get("name");
            String filenumber = valueMap.get("filenumber");
            String empnumber = valueMap.get("empnumber");
            boolean flag = SWCStringUtils.isNotEmpty((String)name) && name.contains(searchText) || SWCStringUtils.isNotEmpty((String)filenumber) && filenumber.contains(searchText) || SWCStringUtils.isNotEmpty((String)empnumber) && empnumber.contains(searchText);
            if (!flag) continue;
            matchPersonDataMap.put(entry.getKey(), entry.getValue());
        }
        return matchPersonDataMap;
    }

    public static List<Map<String, String>> getMatchProrationPersonDataList(List<Map<String, String>> personDataList, String searchText) {
        ArrayList<Map<String, String>> matchPersonDataList = new ArrayList<Map<String, String>>(10);
        if (SWCStringUtils.isEmpty((String)searchText)) {
            matchPersonDataList.addAll(personDataList);
            return matchPersonDataList;
        }
        for (Map<String, String> data : personDataList) {
            String name = data.get("name");
            String fileNumber = data.get("filenumber");
            String empNumber = data.get("empnumber");
            String itemName = data.get("itemname");
            boolean filter = SWCStringUtils.isNotEmpty((String)name) && name.contains(searchText) || SWCStringUtils.isNotEmpty((String)fileNumber) && fileNumber.contains(searchText) || SWCStringUtils.isNotEmpty((String)empNumber) && empNumber.contains(searchText) || SWCStringUtils.isNotEmpty((String)itemName) && itemName.contains(searchText);
            if (!filter) continue;
            matchPersonDataList.add(data);
        }
        return matchPersonDataList;
    }

    public static Map<Long, Map<Long, Object>> assembleSalaryItemDataMap(List<String> waitDeletePersonIdList, Map<String, Map<String, Object>> changeData, List<Long> personIds, List<Long> itemIds) {
        Map<Long, Map<Long, Object>> coverResultMap = CalResultCoverHelper.assembleCoverResultMap(waitDeletePersonIdList, personIds, itemIds);
        Map<Long, Map<Long, Object>> itemDataMap = CalResultCoverHelper.assembleItemDataMap(personIds, changeData, coverResultMap);
        return itemDataMap;
    }

    public static Map<String, String> assembleExportDescInfo(Long calTaskId) {
        HashMap<String, String> exportDescInfo = new HashMap<String, String>(16);
        HSASCalListHelper helper = new HSASCalListHelper();
        DynamicObject taskInfo = helper.getTaskInfo(calTaskId);
        exportDescInfo.put("taskName", taskInfo.getString("name"));
        exportDescInfo.put("payrollGroupName", taskInfo.getString("payrollgroup.name"));
        exportDescInfo.put("payrollScene", taskInfo.getString("payrollscene.name"));
        exportDescInfo.put("taskType", taskInfo.getString("tasktype"));
        exportDescInfo.put("payrollDate", SWCDateTimeUtils.format((Date)taskInfo.getDate("payrolldate"), (String)"yyyyMM"));
        exportDescInfo.put("calCount", taskInfo.getString("calcount"));
        exportDescInfo.put("currency", taskInfo.getString("payrollgroupv.currency.name"));
        return exportDescInfo;
    }

    public static Map<String, Object> getTaskCurrencyPrecision(Long calTaskId) {
        HashMap<String, Object> taskMap = new HashMap<String, Object>(2);
        SWCDataServiceHelper calPayrollHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String fields = "name,payrollgroupv.currency.amtprecision,payrollgroupv.currency.id";
        DynamicObject taskInfo = calPayrollHelper.queryOne(fields, (Object)calTaskId);
        if (taskInfo == null) {
            return taskMap;
        }
        int precision = taskInfo.getInt("payrollgroupv.currency.amtprecision");
        Long currencyId = taskInfo.getLong("payrollgroupv.currency.id");
        taskMap.put("precision", precision);
        taskMap.put("currencyId", currencyId);
        taskMap.put("name", taskInfo.getString("name"));
        return taskMap;
    }

    public static Map<Long, Map<Long, Object>> assembleItemDataMap(List<Long> personIdList, Map<String, Map<String, Object>> changeData, Map<Long, Map<Long, Object>> coverResultMap) {
        LinkedHashMap<Long, Map<Long, Object>> dataMap = new LinkedHashMap<Long, Map<Long, Object>>(16);
        for (Long l : personIdList) {
            dataMap.put(l, new HashMap(16));
        }
        dataMap.putAll(coverResultMap);
        for (Map.Entry entry : changeData.entrySet()) {
            Long personId = Long.valueOf((String)entry.getKey());
            Map value = (Map)entry.getValue();
            Map coverValueMap = dataMap.getOrDefault(personId, new HashMap(16));
            for (Map.Entry valueEntry : value.entrySet()) {
                String itemKey = (String)valueEntry.getKey();
                coverValueMap.put(Long.valueOf(itemKey.substring(4)), valueEntry.getValue());
            }
            dataMap.put(personId, coverValueMap);
        }
        return dataMap;
    }

    public static Map<Long, Map<Long, Object>> assembleCoverResultMap(List<String> waitDeletePersonIdList, List<Long> personIds, List<Long> itemIds) {
        long st = System.currentTimeMillis();
        LinkedHashMap<Long, Map<Long, Object>> coverResultMap = new LinkedHashMap<Long, Map<Long, Object>>(16);
        for (Long personId : personIds) {
            coverResultMap.put(personId, new HashMap(16));
        }
        CalResultCoverHelper.initEmptyItemValue(coverResultMap, itemIds);
        logger.info("initEmptyItemValue_cost:{} ms", (Object)(System.currentTimeMillis() - st));
        st = System.currentTimeMillis();
        ArrayList<Long> tempPersonIdList = new ArrayList<Long>(10);
        tempPersonIdList.addAll(personIds);
        if (CollectionUtils.isNotEmpty(waitDeletePersonIdList)) {
            List waitDeleteIdList = waitDeletePersonIdList.stream().map(single -> Long.valueOf(single)).collect(Collectors.toList());
            tempPersonIdList.removeAll(waitDeleteIdList);
        }
        if (SWCListUtils.isEmpty(tempPersonIdList)) {
            return coverResultMap;
        }
        QFilter filter = new QFilter("calperson", "in", tempPersonIdList);
        filter.and("salaryitem.id", "in", itemIds);
        String fields = "calperson,salaryitem.id,salaryitem.datatype.id,numvalue,datevalue,textvalue,calamountvalue";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"hsas_calresultcoverdata", (String)fields, (QFilter[])new QFilter[]{filter});
        logger.info("querycalresultcoverdata_finish,cost:{} ms", (Object)(System.currentTimeMillis() - st));
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return coverResultMap;
        }
        for (DynamicObject obj : dynamicObjects) {
            Map itemMap = (Map)coverResultMap.get(obj.getLong("calperson"));
            Object value = CalResultCoverHelper.getItemCoverValue(obj);
            itemMap.put(obj.getLong("salaryitem.id"), value);
        }
        return coverResultMap;
    }

    public static Map<String, Map<String, String>> getTaskPersonMap(long taskId, List<Long> personIdList, List<String> fileNumberList, List<Long> resultIdList) {
        HashMap<String, Map<String, String>> taskPersonMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"4730fc9f000003ae");
        QFilter filter = new QFilter("caltask.id", "=", (Object)taskId);
        if (authorizedDataRuleQFilter != null) {
            filterList.addAll(authorizedDataRuleQFilter);
        } else {
            filterList.add(new QFilter("1", "!=", (Object)1));
        }
        filterList.add(filter);
        if (!SWCListUtils.isEmpty(fileNumberList)) {
            filterList.add(new QFilter("filenumber", "in", fileNumberList));
        }
        logger.info("importCoverData_getTaskPersonMap_filter:{}", (Object)((Object)filterList).toString());
        String fields = "id,salaryfile.id,filenumber,name,empnumber,calstatus,taxstatus,calresultid";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"hsas_calperson", (String)fields, (QFilter[])filterList.toArray(new QFilter[filterList.size()]));
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return taskPersonMap;
        }
        for (DynamicObject object : dynamicObjects) {
            String filenumber = object.getString("filenumber");
            Map personMap = taskPersonMap.getOrDefault(filenumber, new HashMap(16));
            long personId = object.getLong("id");
            long resultId = object.getLong("calresultid");
            personMap.put("id", String.valueOf(personId));
            personMap.put("filenumber", filenumber);
            personMap.put("name", object.getString("name"));
            personMap.put("empnumber", object.getString("empnumber"));
            personMap.put("calstatus", object.getString("calstatus"));
            personMap.put("taxstatus", object.getString("taxstatus"));
            personMap.put("salaryfileid", object.getString("salaryfile.id"));
            taskPersonMap.put(filenumber, personMap);
            personIdList.add(personId);
            if (resultId <= 0L) continue;
            resultIdList.add(resultId);
        }
        return taskPersonMap;
    }

    public static void doCalBack(Long calTaskId, List<Long> personIdList) {
        if (personIdList.size() == 0) {
            return;
        }
        PayrollTaskHelper.tryLock((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)CalPersonOperationEnum.OP_CAL_RESULT_COVER.getOperationKey());
        try {
            CalRollBackService calRollBackService = new CalRollBackService(calTaskId, personIdList);
            calRollBackService.calRollBack("resultcover", null);
        }
        catch (Exception ex) {
            logger.error("CalRollBackService.calRollBack is fail,calTaskId = {}", (Object)calTaskId);
            logger.error((Throwable)ex);
        }
        finally {
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)CalPersonOperationEnum.OP_CAL_RESULT_COVER.getOperationKey());
        }
    }

    public static Object getItemCoverValue(DynamicObject obj) {
        long dataType = obj.getLong("salaryitem.datatype.id");
        Object value = 1010L == dataType ? obj.getBigDecimal("numvalue") : (1020L == dataType ? obj.getBigDecimal("calamountvalue") : (1030L == dataType ? obj.getString("textvalue") : (1050L == dataType ? obj.getDate("datevalue") : null)));
        return value;
    }

    public static void initEmptyItemValue(Map<Long, Map<Long, Object>> itemResultMap, List<Long> itemIds) {
        for (Map.Entry<Long, Map<Long, Object>> entry : itemResultMap.entrySet()) {
            Map<Long, Object> itemMap = entry.getValue();
            for (Long itemId : itemIds) {
                itemMap.put(itemId, null);
            }
        }
    }

    public static List<QFilter> getCalPersonFilters(List<Long> personIdList, Long taskId, String searchText) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        QFilter personFilter = new QFilter("id", "in", personIdList);
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"47150e89000000ac");
        if (authorizedDataRuleQFilter != null) {
            filterList.addAll(authorizedDataRuleQFilter);
        } else {
            filterList.add(new QFilter("1", "!=", (Object)1));
        }
        if (SWCStringUtils.isNotEmpty((String)searchText)) {
            QFilter filterLike = new QFilter("filenumber", "like", (Object)("%" + searchText + "%"));
            filterLike.or("name", "like", (Object)("%" + searchText + "%"));
            filterLike.or("empnumber", "like", (Object)("%" + searchText + "%"));
            filterList.add(filterLike);
        }
        filterList.add(personFilter);
        return filterList;
    }

    public static Map<String, Map<String, Object>> getSumChangeData(String personPageId, long taskId) {
        Map<String, Map<String, Map<String, Object>>> sumChangeData = CalResultCoverHelper.getSumChangeDataAllPage(personPageId, taskId);
        HashMap<String, Map<String, Object>> dataMap = new HashMap<String, Map<String, Object>>(16);
        for (Map.Entry<String, Map<String, Map<String, Object>>> entry : sumChangeData.entrySet()) {
            for (Map.Entry<String, Map<String, Object>> valueEntry : entry.getValue().entrySet()) {
                String personIdStr = valueEntry.getKey();
                if (dataMap.containsKey(personIdStr)) continue;
                dataMap.put(personIdStr, valueEntry.getValue());
            }
        }
        return dataMap;
    }

    public static Map<String, String> getMemoChangeData(String personPageId, long taskId) {
        Map<String, Map<String, String>> memoChangeData = CalResultCoverHelper.getMemoChangeDataAllPage(personPageId, taskId);
        HashMap<String, String> dataMap = new HashMap<String, String>(16);
        for (Map.Entry<String, Map<String, String>> entry : memoChangeData.entrySet()) {
            for (Map.Entry<String, String> valueEntry : entry.getValue().entrySet()) {
                String personIdStr = valueEntry.getKey();
                if (dataMap.containsKey(personIdStr)) continue;
                dataMap.put(personIdStr, valueEntry.getValue());
            }
        }
        return dataMap;
    }

    public static Map<String, Map<String, Map<String, Object>>> getSumChangeDataAllPage(String personPageId, long taskId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        if (appCache == null) {
            return new HashMap<String, Map<String, Map<String, Object>>>(0);
        }
        String cacheKey = String.format(Locale.ROOT, "changeData_%d_%s", taskId, personPageId);
        String changeDataStr = (String)appCache.get(cacheKey, String.class);
        if (SWCStringUtils.isEmpty((String)changeDataStr)) {
            return new HashMap<String, Map<String, Map<String, Object>>>(0);
        }
        Map changeData = (Map)SerializationUtils.deSerializeFromBase64((String)changeDataStr);
        return changeData;
    }

    public static Map<String, Map<String, String>> getMemoChangeDataAllPage(String personPageId, long taskId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        if (appCache == null) {
            return new HashMap<String, Map<String, String>>(0);
        }
        String cacheKey = String.format(Locale.ROOT, "memoChangeData_%d_%s", taskId, personPageId);
        HashMap changeData = (HashMap)appCache.get(cacheKey, Map.class);
        if (changeData == null) {
            changeData = new HashMap(0);
        }
        return changeData;
    }

    public static Map<String, Map<String, Object>> getProrationChangeDataAllPage(String personPageId, long taskId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        if (appCache == null) {
            return new HashMap<String, Map<String, Object>>(0);
        }
        String cacheKey = String.format(Locale.ROOT, "prorationChangeData_%d_%s", taskId, personPageId);
        HashMap changeData = (HashMap)appCache.get(cacheKey, Map.class);
        if (changeData == null) {
            changeData = new HashMap(0);
        }
        return changeData;
    }

    public static Map<String, Object> getProrationChangeData(String personPageId, long taskId) {
        Map<String, Map<String, Object>> changeDataAllPage = CalResultCoverHelper.getProrationChangeDataAllPage(personPageId, taskId);
        HashMap<String, Object> changeData = new HashMap<String, Object>(16);
        for (Map.Entry<String, Map<String, Object>> entry : changeDataAllPage.entrySet()) {
            changeData.putAll(entry.getValue());
        }
        return changeData;
    }

    public static List<String> getWaitDeleteData(String personPageId, long taskId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        String cacheKey = String.format(Locale.ROOT, "waitDeleteData_%d_%s", taskId, personPageId);
        List personIdList = (List)appCache.get(cacheKey, List.class);
        return personIdList == null ? new ArrayList(0) : personIdList;
    }

    public static void updateWaitDeleteData(List<String> personIdList, String personPageId, long taskId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        String cacheKey = String.format(Locale.ROOT, "waitDeleteData_%d_%s", taskId, personPageId);
        appCache.put(cacheKey, personIdList);
    }

    public static List<Long> getCurPagePersonIdList(Map<String, Map<String, String>> personSimpleDataMap, int pageSize, int pageIndex) {
        List personIdList = personSimpleDataMap.keySet().stream().map(personId -> Long.valueOf(personId)).collect(Collectors.toList());
        List split = SWCListUtils.split(personIdList, (int)pageSize);
        HashMap personIdMap = Maps.newHashMapWithExpectedSize((int)split.size());
        for (int i = 0; i < split.size(); ++i) {
            personIdMap.put(i + 1, split.get(i));
        }
        return (List)personIdMap.get(pageIndex);
    }

    public static List<Map<String, String>> getCurPageProrationCoverDataList(List<Map<String, String>> prorationCoverDataList, int pageSize, int pageIndex) {
        List split = SWCListUtils.split(prorationCoverDataList, (int)pageSize);
        HashMap personIdMap = Maps.newHashMapWithExpectedSize((int)split.size());
        for (int i = 0; i < split.size(); ++i) {
            personIdMap.put(i + 1, split.get(i));
        }
        return (List)personIdMap.get(pageIndex);
    }

    private static int getProrationResultCoverViewPersonDataMap(List<Map<String, String>> curPageProrationCoverDataList, Long taskId, String personPageId, int pageRows, Integer pageIndex, String searchText) {
        long st = System.currentTimeMillis();
        List<Long> personIds = CalResultCoverHelper.getProrationCoverDataPersonIdList(taskId, "2DXPU453B4ZK");
        logger.info("getProrationCoverDataPersonIdList cost:{} ms", (Object)(System.currentTimeMillis() - st));
        if (SWCListUtils.isEmpty(personIds)) {
            CalResultCoverHelper.cacheResultCoverDataCount(taskId, personPageId, 0);
            return 1;
        }
        st = System.currentTimeMillis();
        List<Long> validIdList = CalResultCoverHelper.getMatchProrationCalPersonIdList(personIds, taskId, searchText);
        logger.info("getMatchProrationCalPersonIdList cost:{} ms", (Object)(System.currentTimeMillis() - st));
        st = System.currentTimeMillis();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_proratecoverdata");
        int count = helper.count(new QFilter[]{new QFilter("calperson", "in", validIdList)});
        logger.info("countprorationcoverdata cost:{} ms", (Object)(System.currentTimeMillis() - st));
        CalResultCoverHelper.cacheResultCoverDataCount(taskId, personPageId, count);
        st = System.currentTimeMillis();
        if (count < pageRows) {
            pageIndex = 1;
        }
        List<DynamicObject> prorationDataDyObjList = CalResultCoverHelper.getProrationDataDyObjListByPageSize(validIdList, pageRows, pageIndex);
        logger.info("getProrationDataDyObjListByPageSize cost:{} ms", (Object)(System.currentTimeMillis() - st));
        while (SWCListUtils.isEmpty(prorationDataDyObjList)) {
            if (pageIndex > 0) {
                pageIndex = pageIndex - 1;
                prorationDataDyObjList = CalResultCoverHelper.getProrationDataDyObjListByPageSize(validIdList, pageRows, pageIndex);
                continue;
            }
            pageIndex = 1;
            break;
        }
        Set personIdSet = prorationDataDyObjList.stream().map(single -> single.getLong("calperson")).collect(Collectors.toSet());
        List<DynamicObject> personDataList = CalResultCoverHelper.getCalPersonDyObjList(new ArrayList<Long>(personIdSet), taskId, "");
        List<Map<String, String>> matchPersonDataList = CalResultCoverHelper.assembleProrationDataList(personDataList, taskId, prorationDataDyObjList);
        curPageProrationCoverDataList.addAll(matchPersonDataList);
        return pageIndex;
    }

    public static int getProrationCoverDataCount(Long taskId, String searchText) {
        List<Long> personIds = CalResultCoverHelper.getProrationCoverDataPersonIdList(taskId, "4730fc9f000004ae");
        List<Long> validIdList = CalResultCoverHelper.getMatchProrationCalPersonIdList(personIds, taskId, searchText);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_proratecoverdata");
        return helper.count(new QFilter[]{new QFilter("calperson", "in", validIdList)});
    }

    public static int getResultCoverViewPersonDataMap(Map<Long, Map<Long, Object>> itemDataMap, Map<String, Map<String, String>> matchPersonDataMap, Long taskId, String personPageId, int pageSize, int pageIndex, String searchText) {
        List<Long> personIds = CalResultCoverHelper.getResultCoverDataPersonIdList(taskId, "2DXPU453B4ZK", "2");
        if (SWCListUtils.isEmpty(personIds)) {
            CalResultCoverHelper.cacheResultCoverDataCount(taskId, personPageId, 0);
            return 1;
        }
        int count = CalResultCoverHelper.getCalPersonDyObjCount(personIds, taskId, searchText);
        CalResultCoverHelper.cacheResultCoverDataCount(taskId, personPageId, count);
        if (count < pageSize) {
            pageIndex = 1;
        }
        List<DynamicObject> calPersonDyObjList = CalResultCoverHelper.getCalPersonDyObjListByPageSize(personIds, taskId, searchText, pageSize, pageIndex);
        while (SWCListUtils.isEmpty(calPersonDyObjList)) {
            if (pageIndex > 0) {
                calPersonDyObjList = CalResultCoverHelper.getCalPersonDyObjListByPageSize(personIds, taskId, searchText, pageSize, --pageIndex);
                continue;
            }
            pageIndex = 1;
            break;
        }
        Map<String, Map<String, String>> personDataMap = CalResultCoverHelper.assemblePersonDataMap(itemDataMap, calPersonDyObjList, taskId, personPageId);
        matchPersonDataMap.putAll(personDataMap);
        return pageIndex;
    }

    private static Map<String, Map<String, String>> assemblePersonDataMap(Map<Long, Map<Long, Object>> itemDataMap, List<DynamicObject> calPersonDyObjList, Long taskId, String personPageId) {
        LinkedHashMap<String, Map<String, String>> calPersonSimpleDataMap = new LinkedHashMap<String, Map<String, String>>(calPersonDyObjList.size());
        if (SWCListUtils.isEmpty(calPersonDyObjList)) {
            return calPersonSimpleDataMap;
        }
        List<Long> personIdList = calPersonDyObjList.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
        Map<Long, String> declareStatusMap = CalResultCoverHelper.getCalPersonTaxDeclareStatus(taskId, personIdList);
        for (DynamicObject obj : calPersonDyObjList) {
            long personId = obj.getLong("id");
            String taxStatus = declareStatusMap.get(personId);
            Map dataMap = calPersonSimpleDataMap.getOrDefault(personId + "", new HashMap(7));
            dataMap.put("id", obj.getString("id"));
            dataMap.put("name", obj.getString("name"));
            dataMap.put("filenumber", obj.getString("filenumber"));
            dataMap.put("empnumber", obj.getString("empnumber"));
            dataMap.put("calstatus", obj.getString("calstatus"));
            dataMap.put("taxstatus", obj.getString("taxstatus"));
            dataMap.put("salaryfile", obj.getString("salaryfile.id"));
            dataMap.put("locked", taxStatus);
            calPersonSimpleDataMap.put(personId + "", dataMap);
        }
        Map<String, Map<String, String>> salaryItemMap = CalResultCoverHelper.getCacheSalaryItemMap(taskId, personPageId);
        if (salaryItemMap == null || salaryItemMap.size() == 0) {
            return calPersonSimpleDataMap;
        }
        List<Long> itemIds = salaryItemMap.keySet().stream().map(id -> Long.valueOf(id)).collect(Collectors.toList());
        Map<Long, Map<Long, Object>> itemDataMapTemp = CalResultCoverHelper.assembleCoverResultMap(new ArrayList<String>(0), personIdList, itemIds);
        itemDataMap.putAll(itemDataMapTemp);
        return CalResultCoverHelper.assembleSumItemDataMap(itemDataMap, calPersonSimpleDataMap);
    }

    private static Map<String, Map<String, String>> assembleProrationObjDataMap(Map<String, Map<String, String>> calPersonSimpleDataMap, List<DynamicObject> objects) {
        LinkedHashMap prorationDataMap = Maps.newLinkedHashMapWithExpectedSize((int)objects.size());
        for (DynamicObject obj : objects) {
            String personId = obj.getString("calperson");
            Map<String, String> tempPersonMap = calPersonSimpleDataMap.get(personId);
            if (tempPersonMap == null || tempPersonMap.size() == 0) continue;
            String calStatus = tempPersonMap.get("calstatus");
            String itemId = obj.getString("salaryitem.id");
            String startDate = SWCDateTimeUtils.format((Date)obj.getDate("startdate"), (String)"yyyy-MM-dd");
            String endDate = SWCDateTimeUtils.format((Date)obj.getDate("enddate"), (String)"yyyy-MM-dd");
            StringBuilder rowsIdSb = new StringBuilder();
            rowsIdSb.append(personId).append('#').append(itemId).append('#').append(startDate).append('#').append(endDate);
            String idStr = rowsIdSb.toString();
            Map personItemMap = prorationDataMap.computeIfAbsent(idStr, single -> new HashMap(16));
            personItemMap.put("idstr", idStr);
            personItemMap.put("personid", personId);
            personItemMap.put("filenumber", tempPersonMap.get("filenumber"));
            personItemMap.put("salaryfileid", tempPersonMap.get("salaryfileid"));
            personItemMap.put("name", tempPersonMap.get("name"));
            personItemMap.put("empnumber", tempPersonMap.get("empnumber"));
            personItemMap.put("itemid", itemId);
            personItemMap.put("itemname", obj.getString("salaryitem.name"));
            personItemMap.put("startdate", startDate);
            personItemMap.put("enddate", endDate);
            personItemMap.put("calstatus", calStatus);
            personItemMap.put("calblock", obj.getString("salaryitem.calblock"));
            personItemMap.put("covervalue", obj.getString("covervalue"));
        }
        return prorationDataMap;
    }

    private static Map<String, Map<String, String>> assembleSumItemDataMap(Map<Long, Map<Long, Object>> itemDataMap, Map<String, Map<String, String>> calPersonSimpleDataMap) {
        LinkedHashMap<String, Map<String, String>> resultDataMap = new LinkedHashMap<String, Map<String, String>>(16);
        for (Map.Entry<String, Map<String, String>> entry : calPersonSimpleDataMap.entrySet()) {
            boolean isEmpty;
            Map<Long, Object> dataMap = itemDataMap.get(Long.parseLong(entry.getKey()));
            if (dataMap == null || dataMap.size() == 0 || (isEmpty = CalResultCoverHelper.checkItemDataEmpty(dataMap))) continue;
            resultDataMap.put(entry.getKey(), entry.getValue());
        }
        return resultDataMap;
    }

    public static List<Long> getProrationCoverDataPersonIdList(Long taskId, String permItemId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_proratecoverdata");
        List<Long> personIdList = CalResultCoverHelper.getValidDataAuthPersonIdList(taskId, permItemId);
        if (SWCListUtils.isEmpty(personIdList)) {
            return new ArrayList<Long>(0);
        }
        QFilter filter = new QFilter("caltaskid", "=", (Object)taskId);
        filter.and("calperson", "in", personIdList);
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection("calperson", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)dynamicObjects)) {
            return new ArrayList<Long>(0);
        }
        Set personIdSet = dynamicObjects.stream().map(obj -> obj.getLong("calperson")).collect(Collectors.toSet());
        return new ArrayList<Long>(personIdSet);
    }

    public static List<Long> getValidDataAuthPersonIdList(Long taskId, String permItemId) {
        SWCDataServiceHelper personHelper = new SWCDataServiceHelper("hsas_calperson");
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)permItemId);
        if (authorizedDataRuleQFilter != null) {
            filterList.addAll(authorizedDataRuleQFilter);
        } else {
            filterList.add(new QFilter("1", "!=", (Object)1));
        }
        QFilter filter = new QFilter("caltask", "=", (Object)taskId);
        filterList.add(filter);
        logger.info("getValidDataAuthPersonIdList.filter:{}", (Object)((Object)filterList).toString());
        DynamicObjectCollection personObjs = personHelper.queryOriginalCollection("id", filterList.toArray(new QFilter[filterList.size()]));
        if (SWCListUtils.isEmpty((List)personObjs)) {
            return new ArrayList<Long>(0);
        }
        return personObjs.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
    }

    public static List<Long> getResultCoverDataPersonIdList(Long taskId, String permItemId, String coverType) {
        QFilter filter;
        SWCDataServiceHelper helper;
        if (SWCStringUtils.equals((String)"2", (String)coverType)) {
            helper = new SWCDataServiceHelper("hsas_calresultcoverdata");
            filter = new QFilter("caltask", "=", (Object)taskId);
        } else {
            helper = new SWCDataServiceHelper("hsas_proratecoverdata");
            filter = new QFilter("caltaskid", "=", (Object)taskId);
        }
        List<Long> personIdList = CalResultCoverHelper.getValidDataAuthPersonIdList(taskId, permItemId);
        if (SWCListUtils.isEmpty(personIdList)) {
            return new ArrayList<Long>(0);
        }
        filter.and("calperson", "in", personIdList);
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection("calperson", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)dynamicObjects)) {
            return new ArrayList<Long>(0);
        }
        Set personIdSet = dynamicObjects.stream().map(obj -> obj.getLong("calperson")).collect(Collectors.toSet());
        return new ArrayList<Long>(personIdSet);
    }

    public static List<Map<String, String>> assembleProrationDataList(List<DynamicObject> personDataList, Long taskId, List<DynamicObject> prorationDataList) {
        Map<String, Map<String, String>> tempDataMap = CalResultCoverHelper.assembleCalPersonSimpleDataMap(personDataList, taskId, true);
        Map<String, Map<String, String>> prorationDataMap = CalResultCoverHelper.assembleProrationObjDataMap(tempDataMap, prorationDataList);
        return prorationDataMap.values().stream().collect(Collectors.toList());
    }

    public static List<Map<String, String>> assembleProrationDataList(List<Long> personIdList, Long taskId, String searchText, String personPageId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        if (appCache == null) {
            return new ArrayList<Map<String, String>>(0);
        }
        String cacheKey = String.format(Locale.ROOT, "viewprorationcoverdata_%d_%s", taskId, personPageId);
        List dataList = (List)appCache.get(cacheKey, List.class);
        String cacheViewSearchText = CalResultCoverHelper.getCacheViewSearchText(taskId, personPageId);
        if (dataList == null || !SWCStringUtils.equals((String)searchText, (String)cacheViewSearchText)) {
            DynamicObject task = CalPayrollTaskHelper.queryTaskInfoById(taskId);
            DynamicObject calRuleHisObj = task.getDynamicObject("calrulev");
            List<DynamicObject> calPersonDyObjList = CalResultCoverHelper.getCalPersonDyObjList(personIdList, taskId, searchText);
            if (SWCListUtils.isEmpty(calPersonDyObjList)) {
                return new ArrayList<Map<String, String>>(0);
            }
            List<Long> idList = calPersonDyObjList.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
            List<DynamicObject> prorationItemDataList = CalResultCoverHelper.getProrationItemDataList(calRuleHisObj.getLong("id"), idList, false, taskId);
            List<Map<String, String>> list = CalResultCoverHelper.assembleProrationItemCoverDataList(taskId, prorationItemDataList, true);
            appCache.put(cacheKey, list);
            String searchCacheKey = String.format(Locale.ROOT, "viewsearchtext_%d_%s", taskId, personPageId);
            appCache.put(searchCacheKey, (Object)searchText);
            return list;
        }
        return dataList;
    }

    private static int getCacheResultCoverDataCount(Long taskId, String personPageId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        String cacheKey = String.format(Locale.ROOT, "resultcoverdatacount_%d_%s", taskId, personPageId);
        if (appCache == null) {
            return 0;
        }
        Integer count = (Integer)appCache.get(cacheKey, Integer.class);
        return count == null ? 0 : count;
    }

    private static String getCacheViewSearchText(Long taskId, String personPageId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        String searchCacheKey = String.format(Locale.ROOT, "viewsearchtext_%d_%s", taskId, personPageId);
        String searchText = (String)appCache.get(searchCacheKey, String.class);
        return searchText == null ? "" : searchText;
    }

    private static void cacheResultCoverDataCount(Long taskId, String personPageId, int count) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        String cacheKey = String.format(Locale.ROOT, "resultcoverdatacount_%d_%s", taskId, personPageId);
        appCache.put(cacheKey, (Object)count);
    }

    public static void removeResultCoverDataCountCache(Long taskId, String personPageId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        String cacheKey = String.format(Locale.ROOT, "resultcoverdatacount_%d_%s", taskId, personPageId);
        appCache.remove(cacheKey);
    }

    private static String getOrderByStr(Long taskId, StringBuilder fieldSb) {
        StringBuilder orderBySb = new StringBuilder();
        Map<String, String> sortColumnMap = CalResultCoverHelper.assemblePersonSortColumnMap(taskId);
        ArrayList<String> sortKeyList = new ArrayList<String>(sortColumnMap.values());
        for (String sortKey : sortKeyList) {
            String[] split = sortKey.split("\\|");
            String column = split[0];
            String sort = split[1];
            if (SWCStringUtils.isEmpty((String)column)) continue;
            fieldSb.append(',').append(column);
            if (SWCStringUtils.equals((String)"asc", (String)sort)) {
                orderBySb.append(column).append(" asc,");
                continue;
            }
            orderBySb.append(column).append(" desc,");
        }
        String orderByStr = "";
        if (orderBySb.length() > 0) {
            orderByStr = orderBySb.toString().substring(0, orderBySb.length() - 1);
        }
        return orderByStr;
    }

    public static Map<String, Map<String, String>> assembleSumPersonDataMapForView(List<Long> personIdList, Long taskId, String searchText, String personPageId) {
        long st = System.currentTimeMillis();
        logger.info("getCalPersonDyObjList size:{}", (Object)personIdList.size());
        List<DynamicObject> personDataList = CalResultCoverHelper.getCalPersonDyObjList(personIdList, taskId, searchText);
        logger.info("getCalPersonDyObjList cost:{} ms", (Object)(System.currentTimeMillis() - st));
        if (SWCListUtils.isEmpty(personDataList)) {
            return new HashMap<String, Map<String, String>>(0);
        }
        Map<String, Map<String, String>> tempDataMap = CalResultCoverHelper.assembleCalPersonSimpleDataMap(personDataList, taskId, true);
        Map<String, Map<String, String>> salaryItemMap = CalResultCoverHelper.getCacheSalaryItemMap(taskId, personPageId);
        List<Long> itemIds = salaryItemMap.keySet().stream().map(id -> Long.valueOf(id)).collect(Collectors.toList());
        Map<Long, Map<Long, Object>> itemDataMap = CalResultCoverHelper.assembleCoverResultMap(new ArrayList<String>(0), personIdList, itemIds);
        Map<String, Map<String, String>> resultDataMap = CalResultCoverHelper.assembleSumItemDataMap(itemDataMap, tempDataMap);
        return resultDataMap;
    }

    public static int getCalPersonDyObjCount(List<Long> personIdList, Long taskId, String searchText) {
        if (SWCListUtils.isEmpty(personIdList)) {
            return 0;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        List<QFilter> calPersonFilters = CalResultCoverHelper.getCalPersonFilters(personIdList, taskId, searchText);
        return helper.count(calPersonFilters.toArray(new QFilter[calPersonFilters.size()]));
    }

    public static List<Long> getMatchProrationCalPersonIdList(List<Long> personIdList, Long taskId, String searchText) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        List<QFilter> calPersonFilters = CalResultCoverHelper.getCalPersonFilters(personIdList, taskId, searchText);
        DynamicObjectCollection personObjs = helper.queryOriginalCollection("id", calPersonFilters.toArray(new QFilter[calPersonFilters.size()]));
        if (SWCListUtils.isEmpty((List)personObjs)) {
            return new ArrayList<Long>(0);
        }
        return personObjs.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
    }

    private static List<DynamicObject> getProrationDataDyObjListByPageSize(List<Long> personIdList, int pageSize, int pageIndex) {
        String fields = "caltaskid,calperson,salaryitem.id,salaryitem.name,salaryitem.calblock,startdate,enddate,covervalue,datasource,modifytime";
        QFilter filter = new QFilter("calperson", "in", personIdList);
        DynamicObject[] prorationDataObjs = BusinessDataServiceHelper.load((String)"hsas_proratecoverdata", (String)fields, (QFilter[])new QFilter[]{filter}, (String)"modifytime desc", (int)(pageIndex - 1), (int)pageSize);
        if (prorationDataObjs == null || prorationDataObjs.length == 0) {
            return new ArrayList<DynamicObject>(0);
        }
        return new ArrayList<DynamicObject>(Arrays.asList(prorationDataObjs));
    }

    private static List<DynamicObject> getCalPersonDyObjListByPageSize(List<Long> personIdList, Long taskId, String searchText, int pageSize, int pageIndex) {
        List<QFilter> calPersonFilters = CalResultCoverHelper.getCalPersonFilters(personIdList, taskId, searchText);
        StringBuilder fields = new StringBuilder("id,filenumber,name,empnumber,calstatus,taxstatus,salaryfile.id");
        String orderByStr = CalResultCoverHelper.getOrderByStr(taskId, fields);
        QFilter[] filters = calPersonFilters.toArray(new QFilter[calPersonFilters.size()]);
        DynamicObject[] personObjs = BusinessDataServiceHelper.load((String)"hsas_calperson", (String)fields.toString(), (QFilter[])filters, (String)orderByStr, (int)(pageIndex - 1), (int)pageSize);
        if (personObjs == null || personObjs.length == 0) {
            return new ArrayList<DynamicObject>(0);
        }
        return new ArrayList<DynamicObject>(Arrays.asList(personObjs));
    }

    private static List<DynamicObject> getCalPersonDyObjList(List<Long> personIdList, Long taskId, String searchText) {
        List<QFilter> calPersonFilters = CalResultCoverHelper.getCalPersonFilters(personIdList, taskId, searchText);
        StringBuilder fields = new StringBuilder("id,filenumber,name,empnumber,calstatus,taxstatus,salaryfile.id");
        String orderByStr = CalResultCoverHelper.getOrderByStr(taskId, fields);
        QFilter[] filters = calPersonFilters.toArray(new QFilter[calPersonFilters.size()]);
        DynamicObject[] personObjs = BusinessDataServiceHelper.load((String)"hsas_calperson", (String)fields.toString(), (QFilter[])filters, (String)orderByStr);
        if (personObjs == null || personObjs.length == 0) {
            return new ArrayList<DynamicObject>(0);
        }
        return new ArrayList<DynamicObject>(Arrays.asList(personObjs));
    }

    public static Map<String, Map<String, String>> getCachePersonSimpleDataMap(Long taskId, String personPageId, boolean isView) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        if (appCache == null) {
            return new HashMap<String, Map<String, String>>(0);
        }
        String cacheKey = String.format(Locale.ROOT, "personSimpleData_%d_%s", taskId, personPageId);
        Map personSimpleDataMap = (Map)appCache.get(cacheKey, Map.class);
        try {
            logger.info("personSimpleDataMap:{}", (Object)SWCJSONUtils.toString((Object)personSimpleDataMap));
        }
        catch (IOException exception) {
            logger.error("json parse error", (Throwable)exception);
        }
        if (personSimpleDataMap == null) {
            return new HashMap<String, Map<String, String>>(0);
        }
        if (isView) {
            Map<String, Map<String, String>> salaryItemMap = CalResultCoverHelper.getCacheSalaryItemMap(taskId, personPageId);
            List<String> waitDeleteData = CalResultCoverHelper.getWaitDeleteData(personPageId, taskId);
            List<Long> itemIds = salaryItemMap.keySet().stream().map(id -> Long.valueOf(id)).collect(Collectors.toList());
            HashMap<String, Map<String, String>> personDataMap = new HashMap<String, Map<String, String>>(16);
            ArrayList<Long> personIdList = new ArrayList<Long>(0);
            Map<Long, Map<Long, Object>> coverDataMap = CalResultCoverHelper.assembleCoverResultMap(waitDeleteData, personIdList, itemIds);
            for (Map.Entry entry : personSimpleDataMap.entrySet()) {
                boolean isEmpty;
                Map<Long, Object> dataMap = coverDataMap.get(Long.parseLong((String)entry.getKey()));
                if (dataMap == null || dataMap.size() == 0 || (isEmpty = CalResultCoverHelper.checkItemDataEmpty(dataMap))) continue;
                personDataMap.put((String)entry.getKey(), (Map<String, String>)entry.getValue());
            }
            return personDataMap;
        }
        return personSimpleDataMap;
    }

    public static void updateSumCachePersonDataMap(Map<String, Map<String, String>> personMap, Long taskId, String personPageId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        String cacheKey = String.format(Locale.ROOT, "personSimpleData_%d_%s", taskId, personPageId);
        appCache.put(cacheKey, personMap);
    }

    public static void updateProrationCachePersonDataMap(List<Map<String, String>> personDataList, Long taskId, String personPageId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        String cacheKey = String.format(Locale.ROOT, "prorationCoverData_%d_%s", taskId, personPageId);
        appCache.put(cacheKey, personDataList);
    }

    public static int getRowCount(IPageCache pageCache, Long taskId, String personPageId, String coverType, boolean isView) {
        int rowCount;
        Map<String, Map<String, String>> personSimpleDataMap = CalResultCoverHelper.getCachePersonSimpleDataMap(taskId, personPageId, isView);
        List<Map<String, String>> prorationCoverDataList = CalResultCoverHelper.getCacheProrationCoverDataList(taskId, personPageId, isView);
        String searchText = CalResultCoverHelper.getCacheSearchText(taskId, personPageId);
        if (SWCStringUtils.equals((String)"2", (String)coverType)) {
            if (personSimpleDataMap.size() == 0) {
                return 0;
            }
            if (SWCStringUtils.isNotEmpty((String)searchText)) {
                personSimpleDataMap = CalResultCoverHelper.getMatchSumPersonDataMap(personSimpleDataMap, searchText);
            }
            rowCount = personSimpleDataMap.size();
        } else {
            List<Map<String, String>> matchProrationPersonDataList = CalResultCoverHelper.getMatchProrationPersonDataList(prorationCoverDataList, searchText);
            rowCount = matchProrationPersonDataList.size();
        }
        pageCache.put("rowCount", rowCount + "");
        return rowCount;
    }

    public static Map<String, Map<String, String>> getCacheSalaryItemMap(Long calTaskId, String pageId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", calTaskId));
        if (appCache == null) {
            return new HashMap<String, Map<String, String>>(0);
        }
        String cacheKey = String.format(Locale.ROOT, "salaryItemTransfer_%d_%s", calTaskId, pageId);
        Map salaryItemMap = (Map)appCache.get(cacheKey, Map.class);
        return salaryItemMap;
    }

    public static Control findControl(List<Control> controls, String key) {
        for (Control control : controls) {
            Control subResult;
            String target = control.getKey();
            if (StringUtils.equals((String)target, (String)key)) {
                return control;
            }
            if (!(control instanceof Container) || (subResult = CalResultCoverHelper.findControl(((Container)control).getItems(), key)) == null) continue;
            return subResult;
        }
        return null;
    }

    public static int findControlIndex(List<Control> controls, String key) {
        int index = -1;
        for (int i = 0; i < controls.size(); ++i) {
            String target = controls.get(i).getKey();
            if (!StringUtils.equals((String)target, (String)key)) continue;
            index = i;
            break;
        }
        return index;
    }

    public static int[] getRowIndex(DynamicObjectCollection rows) {
        int[] rowIndexes = new int[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            rowIndexes[i] = i;
        }
        return rowIndexes;
    }

    public static Map<String, Object> assembleCoverSalaryItemMap(Long calRuleVid) {
        LinkedHashMap<String, Object> salaryItemMap = new LinkedHashMap<String, Object>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrule");
        DynamicObject calRulev = helper.queryOne((Object)calRuleVid);
        if (calRulev == null || SWCListUtils.isEmpty((List)calRulev.getDynamicObjectCollection("calruleitementry"))) {
            return salaryItemMap;
        }
        DynamicObjectCollection calRuleItemEntry = calRulev.getDynamicObjectCollection("calruleitementry");
        for (DynamicObject item : calRuleItemEntry) {
            if (!SWCStringUtils.equals((String)"1", (String)item.getString("allowresultcover")) || !SWCStringUtils.isNotEmpty((String)item.getString("salaryitem.id"))) continue;
            salaryItemMap.put(item.getString("salaryitem.id"), item.getString("salaryitem.name"));
        }
        return salaryItemMap;
    }

    public static List<Long> getValidPersonIdList(long taskId, List<Long> personIdList) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"2DXPSF5JTISP");
        QFilter filter = new QFilter("caltask.id", "=", (Object)taskId);
        if (authorizedDataRuleQFilter != null) {
            filterList.addAll(authorizedDataRuleQFilter);
        } else {
            filterList.add(new QFilter("1", "!=", (Object)1));
        }
        filterList.add(filter);
        logger.info("CalResultCoverHelper.getValidPersonIdList_filter:{}", (Object)((Object)filterList).toString());
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection("id", filterList.toArray(new QFilter[filterList.size()]));
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return new ArrayList<Long>(0);
        }
        List idList = dynamicObjects.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
        Iterator<Long> iterator = personIdList.iterator();
        while (iterator.hasNext()) {
            Long id = iterator.next();
            if (idList.contains(id)) continue;
            iterator.remove();
        }
        return personIdList;
    }

    public static Map<String, String> assembleTaskInfo(Long calTaskId) {
        HashMap<String, String> taskInfoMap = new HashMap<String, String>(16);
        HSASCalListHelper helper = new HSASCalListHelper();
        DynamicObject taskInfo = helper.getTaskInfo(calTaskId);
        taskInfoMap.put("taskName", taskInfo.getString("name"));
        taskInfoMap.put("taskNumber", taskInfo.getString("number"));
        taskInfoMap.put("payrollGroupName", taskInfo.getString("payrollgroup.name"));
        taskInfoMap.put("payrollScene", taskInfo.getString("payrollscene.name"));
        taskInfoMap.put("taskType", taskInfo.getString("tasktype"));
        taskInfoMap.put("payrollDate", SWCDateTimeUtils.format((Date)taskInfo.getDate("payrolldate"), (String)"yyyyMM"));
        taskInfoMap.put("calCount", taskInfo.getString("calcount"));
        taskInfoMap.put("currency", taskInfo.getString("payrollgroupv.currency.number"));
        return taskInfoMap;
    }

    public static void checkAndCalBack(List<Long> personIdList, Long taskId) {
        DynamicObjectCollection calPersonData = CalResultCoverHelper.getCalPersonData(personIdList, "2DXPSF5JTISP");
        if (SWCListUtils.isEmpty((List)calPersonData)) {
            return;
        }
        ArrayList<Long> needCalbackPersonIds = new ArrayList<Long>(10);
        List<String> caledStatusList = Arrays.asList(CalStateEnum.ALL_CALED.getCode(), CalStateEnum.PARTIAL_CALED.getCode());
        for (DynamicObject person : calPersonData) {
            long personId = person.getLong("id");
            String calStatus = person.getString("calstatus");
            if (!caledStatusList.contains(calStatus)) continue;
            needCalbackPersonIds.add(personId);
        }
        if (needCalbackPersonIds.size() > 0) {
            logger.info("doCalBack personIdList.size:{}", (Object)needCalbackPersonIds.size());
            CalResultCoverHelper.doCalBack(taskId, needCalbackPersonIds);
        }
    }

    public static List<Long> invokeResultCoverSalaryItemExtPoint(Long taskId) {
        CalResultCoverSalaryItemEvent event = new CalResultCoverSalaryItemEvent();
        CalResultCoverSalaryItemExtPlugin resultCoverExtPlugin = new CalResultCoverSalaryItemExtPlugin();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)resultCoverExtPlugin, ICalResultCoverSalaryItemExtPlugin.class, (String)"kd.sdk.swc.hsas.formplugin.extpoint.resultcover.ICalResultCoverSalaryItemExtPlugin#fillExtSalaryItem", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.fillExtSalaryItem(event);
            return null;
        });
        Long calTaskId = event.getCalTaskId();
        if (calTaskId == null || calTaskId.compareTo(taskId) != 0) {
            logger.info("invokeResultCoverSalaryItemExtPoint taskid:{} error", (Object)calTaskId);
            return null;
        }
        return event.getExcludeItemIdList();
    }
}

