/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.helper;

import java.util.Arrays;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCGridUtils;

public class CalSchemeViewHelper {
    private static final String COLUMN_ENTRY_ENTITY = "columnentryentity";
    private static final String CALCOLOR = "calcolor";

    public void rebuildColor(DynamicObjectCollection entryEntity, IFormView view) {
        IClientViewProxy clientService = (IClientViewProxy)view.getService(IClientViewProxy.class);
        int i = 0;
        for (DynamicObject dynamicObject : entryEntity) {
            String calColorNumber = dynamicObject.getString("calcolor.number");
            SWCGridUtils.setGridStyle((IClientViewProxy)clientService, (String)COLUMN_ENTRY_ENTITY, (int)i, (String)"color", (String)calColorNumber);
            ++i;
        }
    }

    public void setCalSchemeViewColor(Map<String, Object> returnData, int[] rowIndexs, IFormView view) {
        Object colorIdObj = returnData.get("colorId");
        if (colorIdObj == null) {
            return;
        }
        DynamicObject calSchemeColor = this.getCalSchemeColor(Long.valueOf(colorIdObj.toString()));
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity(COLUMN_ENTRY_ENTITY);
        for (int i = 0; i < rowIndexs.length; ++i) {
            int rowIndex = rowIndexs[i];
            DynamicObject rowIndexDynamicObject = (DynamicObject)entryEntity.get(rowIndex);
            rowIndexDynamicObject.set(CALCOLOR, (Object)calSchemeColor);
            rowIndexDynamicObject.set("isdisplay", (Object)Boolean.TRUE);
        }
        this.rebuildColor(entryEntity, view);
        view.updateView(COLUMN_ENTRY_ENTITY);
    }

    public int[] moveIndexUp(int[] selectedRows, int rowCount) {
        int[] indexs = new int[rowCount];
        indexs[0] = selectedRows[0];
        int j = 0;
        int index = 1;
        int i = 1;
        while (i < selectedRows.length) {
            int sum = selectedRows[i] - selectedRows[i - 1] - 1;
            while (sum > 0) {
                if (Arrays.binarySearch(selectedRows, j) < 0) {
                    indexs[index++] = j++;
                    --sum;
                    continue;
                }
                ++j;
            }
            indexs[index++] = selectedRows[i++];
        }
        while (j < rowCount) {
            if (Arrays.binarySearch(selectedRows, j) >= 0) {
                ++j;
                continue;
            }
            indexs[index++] = j++;
        }
        return indexs;
    }

    public int[] moveIndexDown(int[] selectedRows, int rowCount) {
        int[] indexs = new int[rowCount];
        indexs[rowCount - 1] = selectedRows[selectedRows.length - 1];
        int j = rowCount - 1;
        int index = rowCount - 2;
        int i = selectedRows.length - 2;
        while (i >= 0) {
            int sum = selectedRows[i + 1] - selectedRows[i] - 1;
            while (sum > 0) {
                if (Arrays.binarySearch(selectedRows, j) < 0) {
                    indexs[index--] = j--;
                    --sum;
                    continue;
                }
                --j;
            }
            indexs[index--] = selectedRows[i--];
        }
        while (j >= 0) {
            if (Arrays.binarySearch(selectedRows, j) >= 0) {
                --j;
                continue;
            }
            indexs[index--] = j--;
        }
        return indexs;
    }

    public DynamicObject getCalSchemeColor(Long colorId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calcolor");
        QFilter filter = new QFilter("id", "=", (Object)colorId);
        return helper.queryOne("id,number", new QFilter[]{filter});
    }
}

