/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hsas.business.extpoint.approve.IApproveBillExtService;
import kd.sdk.swc.hsas.common.events.approve.CreateApproveBillSetValueEvent;
import kd.swc.hsas.business.cal.impl.ApproveBillExtServiceImpl;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class HSASCalApproveBillHelper {
    private static final Log logger = LogFactory.getLog(HSASCalApproveBillHelper.class);

    public DynamicObject[] getNeedUpdateCalPersonList(List<Long> approveBillIdList, SWCDataServiceHelper calHelper) {
        SWCDataServiceHelper approveHelper = new SWCDataServiceHelper("hsas_approvebill");
        DynamicObject[] approveBills = approveHelper.loadDynamicObjectArray(approveBillIdList.toArray());
        ArrayList<Long> calPersonIdList = new ArrayList<Long>();
        for (DynamicObject approveBill : approveBills) {
            DynamicObjectCollection dynamicObjectCollection = approveBill.getDynamicObjectCollection("calentryentity");
            for (DynamicObject calEntryEntityDy : dynamicObjectCollection) {
                Long calPersonId = calEntryEntityDy.getLong("calpersonid");
                calPersonIdList.add(calPersonId);
            }
        }
        return calHelper.query("id,calstatus,calresultid", new QFilter[]{new QFilter("id", "in", calPersonIdList)});
    }

    public Map<Long, Integer> getNotPassCalPersonIds(List<Long> calTaskIdList, Map<Long, Integer> unAuditCalPersonMap) {
        SWCDataServiceHelper approveHelper = new SWCDataServiceHelper("hsas_approvebill");
        String approveBillFields = "id,calentryentity,calpersonid,unauditstatus";
        QFilter filter = new QFilter("caltasks.fbasedataid_id", "in", calTaskIdList);
        filter.and("billstatus", "=", (Object)"E");
        DynamicObject[] calTableList = approveHelper.query(approveBillFields, new QFilter[]{filter});
        HashMap<Long, Integer> calTableMap = new HashMap<Long, Integer>(16);
        for (DynamicObject dynamicObject : calTableList) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("calentryentity");
            for (DynamicObject calEntryEntityDy : dynamicObjectCollection) {
                String unauditstatus = calEntryEntityDy.getString("unauditstatus");
                Long calPersonId = calEntryEntityDy.getLong("calpersonid");
                if ("1".equals(unauditstatus)) {
                    unAuditCalPersonMap.put(calPersonId, 1);
                }
                calTableMap.put(calPersonId, 1);
            }
        }
        return calTableMap;
    }

    public int getSuccessSize(OperationResult operationResult) {
        List successPkIdsObj = operationResult.getSuccessPkIds();
        return successPkIdsObj.size();
    }

    public String createDefaultBillName(String orgName, Date date) {
        int year = SWCDateTimeUtils.getYear((Date)date);
        int month = SWCDateTimeUtils.getMonth((Date)date);
        int day = SWCDateTimeUtils.getDay((Date)date);
        StringBuilder sb = new StringBuilder();
        String dateInfo = ResManager.loadKDString((String)"{0}\u5e74{1}\u6708{2}\u65e5", (String)"HSASCalApproveBillHelper_24", (String)"swc-hsas-business", (Object[])new Object[]{String.valueOf(year), month, day});
        logger.info("calapproveBillName{}", (Object)dateInfo);
        return sb.append(orgName).append('-').append(dateInfo).toString();
    }

    public static void setCalTasks(DynamicObject approveBillDy, String calTaskIdStr) {
        String[] caltaskIds = calTaskIdStr.split(",");
        DynamicObjectCollection caltasks = approveBillDy.getDynamicObjectCollection("caltasks");
        DynamicObjectType dynamicObjectType = caltasks.getDynamicObjectType();
        MainEntityType taskType = EntityMetadataCache.getDataEntityType((String)"hsas_calpayrolltask");
        for (String caltaskId : caltaskIds) {
            DynamicObject instance = (DynamicObject)dynamicObjectType.createInstance();
            DynamicObject task = (DynamicObject)taskType.createInstance();
            task.set("id", (Object)Long.valueOf(caltaskId));
            instance.set("fbasedataid", (Object)task);
            caltasks.add((Object)instance);
        }
    }

    public static void setPayRollGroups(DynamicObject approveBillDy, String payRollGroupStr) {
        if (SWCStringUtils.isEmpty((String)payRollGroupStr)) {
            return;
        }
        String[] payRollGroupStrs = payRollGroupStr.split(",");
        HashSet<Long> payRollGroupIds = new HashSet<Long>(payRollGroupStrs.length);
        for (String payRollGroupId : payRollGroupStrs) {
            payRollGroupIds.add(Long.valueOf(payRollGroupId));
        }
        HSASCalApproveBillHelper.setPayRollGroups(approveBillDy, payRollGroupIds);
    }

    public static void setPayRollGroups(DynamicObject approveBillDy, Set<Long> payRollGroupIds) {
        DynamicObjectCollection payRollGroups = approveBillDy.getDynamicObjectCollection("payrollgroups");
        DynamicObjectType dynamicObjectType = payRollGroups.getDynamicObjectType();
        MainEntityType taskType = EntityMetadataCache.getDataEntityType((String)"hsas_payrollgrp");
        for (Long payRollGroupId : payRollGroupIds) {
            DynamicObject instance = (DynamicObject)dynamicObjectType.createInstance();
            DynamicObject payRollGroup = (DynamicObject)taskType.createInstance();
            payRollGroup.set("id", (Object)payRollGroupId);
            instance.set("fbasedataid", (Object)payRollGroup);
            payRollGroups.add((Object)instance);
        }
    }

    public static boolean validateGrpPerm(Set<Long> payrollGrpSetByPermItem, List<Long> payRollGroupIds) {
        if (payRollGroupIds == null || payRollGroupIds.size() == 0) {
            return false;
        }
        if (payrollGrpSetByPermItem == null) {
            return true;
        }
        payRollGroupIds.removeAll(payrollGrpSetByPermItem);
        return payRollGroupIds.size() == 0;
    }

    public static Map<Long, Boolean> validateGrpPerm(String permItemId, List<Long> approveBillIds) {
        Set payrollGrpSetByPermItem = SWCPermissionServiceHelper.getPayrollGrpSetByPermItem((String)"/UHMBBGZQ65X", (String)"hsas_approvebill", (String)permItemId);
        if (payrollGrpSetByPermItem == null) {
            return null;
        }
        HashMap<Long, Boolean> approveBillGrpPermMaps = new HashMap<Long, Boolean>(approveBillIds.size());
        Map<Long, List<Long>> approveBillPayRollGroupMaps = HSASCalApproveBillHelper.getApproveBillPayRollGroups(approveBillIds);
        for (Long approveBillId : approveBillIds) {
            List<Long> payRollGroupIds = approveBillPayRollGroupMaps.get(approveBillId);
            approveBillGrpPermMaps.put(approveBillId, HSASCalApproveBillHelper.validateGrpPerm(payrollGrpSetByPermItem, payRollGroupIds));
        }
        return approveBillGrpPermMaps;
    }

    private static Map<Long, List<Long>> getApproveBillPayRollGroups(List<Long> approveBillIds) {
        DynamicObject[] query;
        HashMap<Long, List<Long>> approveBillPayRollGroupMaps = new HashMap<Long, List<Long>>(approveBillIds.size());
        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hsas_approvebill");
        for (DynamicObject approveBill : query = swcDataServiceHelper.query("id,payrollgroups", new QFilter[]{new QFilter("id", "in", approveBillIds)})) {
            DynamicObjectCollection payrollgroups = approveBill.getDynamicObjectCollection("payrollgroups");
            ArrayList<Long> payRollGroupIds = new ArrayList<Long>(payrollgroups.size());
            for (DynamicObject payrollgroup : payrollgroups) {
                payRollGroupIds.add(payrollgroup.getLong("fbasedataid_id"));
            }
            approveBillPayRollGroupMaps.put(approveBill.getLong("id"), payRollGroupIds);
        }
        return approveBillPayRollGroupMaps;
    }

    public static String getPayRollGroupStrByTaskId(Set<Long> calTaskIds) {
        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject[] calPayRollTaskArray = swcDataServiceHelper.queryOriginalArray("id,payrollgroup.id", new QFilter[]{new QFilter("id", "in", calTaskIds)});
        StringBuilder sb = new StringBuilder();
        for (DynamicObject dynamicObject : calPayRollTaskArray) {
            sb.append(dynamicObject.getLong("payrollgroup.id"));
            sb.append(',');
        }
        String payRollGroupIds = sb.length() > 0 ? sb.substring(0, sb.length() - 1) : sb.toString();
        return payRollGroupIds;
    }

    public static String getPayRollGroupStr(List<CalPayRollTask> calPayRollTasks) {
        HashSet<Long> calTaskIds = new HashSet<Long>(calPayRollTasks.size());
        for (CalPayRollTask calPayRollTask : calPayRollTasks) {
            calTaskIds.add(calPayRollTask.getCalPayRollTaskId());
        }
        return HSASCalApproveBillHelper.getPayRollGroupStrByTaskId(calTaskIds);
    }

    public static List<Long> getCalTask(DynamicObject approveBillDy) {
        ArrayList<Long> calTaskIds = new ArrayList<Long>(10);
        if (approveBillDy != null) {
            DynamicObjectCollection caltasks = approveBillDy.getDynamicObjectCollection("caltasks");
            for (DynamicObject caltask : caltasks) {
                calTaskIds.add(caltask.getLong("fbasedataid_id"));
            }
        }
        return calTaskIds;
    }

    public static DynamicObject queyTaskDateById(long taskId) {
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        return helper.queryOne("payrolldate,calcount", new QFilter[]{filter});
    }

    public static Map<Long, Set<Long>> queryPayDetails(Set<Long> unPayDetailCalPersonIds) {
        SWCDataServiceHelper payDetailDataServiceHelper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter calPersonIdsFilter = new QFilter("calpersonid", "in", unPayDetailCalPersonIds);
        calPersonIdsFilter.and(new QFilter("abandonedstatus", "=", (Object)Boolean.FALSE));
        DynamicObject[] payDetails = payDetailDataServiceHelper.query("id, calpersonid", new QFilter[]{calPersonIdsFilter});
        HashMap<Long, Set<Long>> payDetailMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject payDetail : payDetails) {
            long calPersonId = payDetail.getLong("calpersonid");
            long id = payDetail.getLong("id");
            Set idSet = (Set)payDetailMap.get(calPersonId);
            if (!CollectionUtils.isEmpty((Collection)idSet)) {
                idSet.add(id);
                payDetailMap.put(calPersonId, idSet);
                continue;
            }
            HashSet<Long> payDetailSet = new HashSet<Long>(16);
            payDetailSet.add(id);
            payDetailMap.put(calPersonId, payDetailSet);
        }
        return payDetailMap;
    }

    public void afterSetBillData(DynamicObject approveBillDy, List<Long> calTaskIdList) {
        CreateApproveBillSetValueEvent event = new CreateApproveBillSetValueEvent();
        event.setApproveBillDy(approveBillDy);
        event.setCalTaskIdList(calTaskIdList);
        ApproveBillExtServiceImpl approveBillExtService = new ApproveBillExtServiceImpl();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)approveBillExtService, IApproveBillExtService.class, (String)"kd.sdk.swc.hsas.business.extpoint.approve.IApproveBillExtService#afterSetApproveBillData", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.afterSetApproveBillData(event);
            return null;
        });
    }
}

