/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.helper;

import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import org.apache.commons.lang3.time.DateUtils;

public class HSASCalListFilterParser {
    private static final String FIELD_NAME = "FieldName";
    private static final String COMPARE = "Compare";
    private static final String VALUE = "Value";
    private static Map<String, CompareTypeEnum> compareTypeMap = new HashMap<String, CompareTypeEnum>();
    private static Set<CompareTypeEnum> nomalCompareTypes;
    private static Set<CompareTypeEnum> dateCompareTypes;

    public QFilter[] parseSchemeFilter(List<LinkedHashMap<String, List<Object>>> schemeFilter) {
        if (schemeFilter.size() == 0) {
            return null;
        }
        QFilter[] filters = new QFilter[schemeFilter.size()];
        Map schemeMap = null;
        Object value = "";
        int size = schemeFilter.size();
        for (int i = 0; i < size; ++i) {
            schemeMap = schemeFilter.get(i);
            String fieldName = (String)((List)schemeMap.get(FIELD_NAME)).get(0);
            String compare = (String)((List)schemeMap.get(COMPARE)).get(0);
            List values = (List)schemeMap.get(VALUE);
            if (values.size() > 0) {
                value = values.size() == 1 ? ((List)schemeMap.get(VALUE)).get(0) : values;
            }
            filters[i] = this.buildFilter(fieldName, compare, value);
        }
        return filters;
    }

    public QFilter[] parseFastFilter(List<LinkedHashMap<String, List<Object>>> fastFilter) {
        if (fastFilter.size() == 0) {
            return null;
        }
        QFilter filter = null;
        int size = fastFilter.size();
        for (int i = 0; i < size; ++i) {
            Map fastMap = fastFilter.get(i);
            if (fastMap == null) continue;
            List fields = (List)fastMap.get(FIELD_NAME);
            List values = (List)fastMap.get(VALUE);
            if (values == null || fields == null) continue;
            int fieldSize = fields.size();
            for (int j = 0; j < fieldSize; ++j) {
                String fieldName = fields.get(j).toString();
                for (Object value : values) {
                    if (filter == null) {
                        filter = this.buildFilter(fieldName, CompareTypeEnum.LIKE.getId(), value);
                        continue;
                    }
                    filter = filter.or(this.buildFilter(fieldName, CompareTypeEnum.LIKE.getId(), value));
                }
            }
        }
        QFilter[] filters = new QFilter[]{filter};
        return filters;
    }

    public QFilter[] parseFastFilterUseAnd(List<LinkedHashMap<String, List<Object>>> fastFilter) {
        if (fastFilter.size() == 0) {
            return null;
        }
        QFilter filter = null;
        int size = fastFilter.size();
        for (int i = 0; i < size; ++i) {
            Map fastMap = fastFilter.get(i);
            if (fastMap == null) continue;
            List fields = (List)fastMap.get(FIELD_NAME);
            List values = (List)fastMap.get(VALUE);
            if (values == null || fields == null) continue;
            QFilter qFilter = null;
            for (Object field : fields) {
                String fieldName = field.toString();
                for (Object value : values) {
                    if (qFilter == null) {
                        qFilter = this.buildFilter(fieldName, CompareTypeEnum.LIKE.getId(), value);
                        continue;
                    }
                    qFilter = qFilter.or(this.buildFilter(fieldName, CompareTypeEnum.LIKE.getId(), value));
                }
            }
            filter = filter == null ? qFilter : filter.and(qFilter);
        }
        QFilter[] filters = new QFilter[]{filter};
        return filters;
    }

    public QFilter[] parseCustomFilter(List<LinkedHashMap<String, List<Object>>> customFilter) {
        if (customFilter.size() == 0) {
            return null;
        }
        QFilter[] filters = new QFilter[customFilter.size()];
        Map customMap = null;
        String fieldName = "";
        List values = null;
        int size = customFilter.size();
        for (int i = 0; i < size; ++i) {
            customMap = customFilter.get(i);
            fieldName = (String)((List)customMap.get(FIELD_NAME)).get(0);
            values = (List)customMap.get(VALUE);
            if (values == null || values.isEmpty() || SWCObjectUtils.isEmpty(values.get(0))) continue;
            QFilter tempQFilter = null;
            for (Object value : values) {
                if (fieldName.endsWith(".id")) {
                    value = Long.parseLong(String.valueOf(value));
                }
                tempQFilter = this.buildFilter(fieldName, CompareTypeEnum.EQUAL.getId(), value);
                if (filters[i] == null) {
                    filters[i] = tempQFilter;
                    continue;
                }
                filters[i].or(tempQFilter);
            }
        }
        return filters;
    }

    private QFilter buildFilter(String fieldName, String compare, Object value) {
        QFilter qFilter = null;
        CompareTypeEnum compareTypeEnum = compareTypeMap.get(compare);
        if (nomalCompareTypes.contains(compareTypeEnum)) {
            Map<String, Object> compareParams = this.getNomalCompareParams(compareTypeEnum, value);
            qFilter = new QFilter(fieldName, String.valueOf(compareParams.get("compareType")), compareParams.get("compareValue"));
        }
        if (dateCompareTypes.contains(compareTypeEnum)) {
            Map<String, Date> dateParams = this.getDateCompareParams(compareTypeEnum, value);
            Date startDate = dateParams.get("startDate");
            Date endDate = dateParams.get("endDate");
            if (startDate != null && endDate != null) {
                qFilter = new QFilter(fieldName, ">=", (Object)startDate);
                qFilter.and(fieldName, "<", (Object)endDate);
            } else if (startDate != null) {
                qFilter = new QFilter(fieldName, ">=", (Object)startDate);
            } else if (endDate != null) {
                qFilter = new QFilter(fieldName, "<", (Object)endDate);
            }
        }
        return qFilter;
    }

    private Map<String, Date> getDateCompareParams(CompareTypeEnum compareTypeEnum, Object value) {
        HashMap<CompareTypeEnum, Date> startDateMap = new HashMap<CompareTypeEnum, Date>(16);
        HashMap<CompareTypeEnum, Date> endDateMap = new HashMap<CompareTypeEnum, Date>(16);
        startDateMap.put(CompareTypeEnum.TODAY, this.addDays(0));
        endDateMap.put(CompareTypeEnum.TODAY, this.addDays(1));
        startDateMap.put(CompareTypeEnum.YESTERDAY, this.addDays(-1));
        endDateMap.put(CompareTypeEnum.YESTERDAY, this.addDays(0));
        startDateMap.put(CompareTypeEnum.THISWEEK, KDDateUtils.getTheWeekStart((int)0));
        endDateMap.put(CompareTypeEnum.THISWEEK, KDDateUtils.getTheWeekEnd((int)0));
        startDateMap.put(CompareTypeEnum.LASTWEEK, KDDateUtils.getTheWeekStart((int)-1));
        endDateMap.put(CompareTypeEnum.LASTWEEK, KDDateUtils.getTheWeekEnd((int)-1));
        startDateMap.put(CompareTypeEnum.THISMONTH, KDDateUtils.getTheMonthStart((int)0));
        endDateMap.put(CompareTypeEnum.THISMONTH, KDDateUtils.getTheMonthEnd((int)0));
        startDateMap.put(CompareTypeEnum.LASTMONTH, KDDateUtils.getTheMonthStart((int)-1));
        endDateMap.put(CompareTypeEnum.LASTMONTH, KDDateUtils.getTheMonthEnd((int)-1));
        startDateMap.put(CompareTypeEnum.LASTTHREEMONTH, this.getTheMonthWithoutOffsetStart(-3));
        endDateMap.put(CompareTypeEnum.LASTTHREEMONTH, this.addDays(1));
        startDateMap.put(CompareTypeEnum.THISQUARTER, KDDateUtils.getTheQuarterStart((int)0));
        endDateMap.put(CompareTypeEnum.THISQUARTER, KDDateUtils.getTheQuarterEnd((int)0));
        startDateMap.put(CompareTypeEnum.LASTQUARTER, KDDateUtils.getTheQuarterStart((int)-1));
        endDateMap.put(CompareTypeEnum.LASTQUARTER, KDDateUtils.getTheQuarterEnd((int)-1));
        startDateMap.put(CompareTypeEnum.THISYEAR, KDDateUtils.getTheYearStart((int)0));
        endDateMap.put(CompareTypeEnum.THISYEAR, KDDateUtils.getTheYearEnd((int)0));
        startDateMap.put(CompareTypeEnum.LASTYEAR, KDDateUtils.getTheYearStart((int)-1));
        endDateMap.put(CompareTypeEnum.LASTYEAR, KDDateUtils.getTheYearEnd((int)-1));
        startDateMap.put(CompareTypeEnum.TOMORROW, this.addDays(1));
        endDateMap.put(CompareTypeEnum.TOMORROW, this.addDays(2));
        startDateMap.put(CompareTypeEnum.NEXTWEEK, KDDateUtils.getTheWeekStart((int)1));
        endDateMap.put(CompareTypeEnum.NEXTWEEK, KDDateUtils.getTheWeekEnd((int)1));
        startDateMap.put(CompareTypeEnum.NEXTMONTH, KDDateUtils.getTheMonthStart((int)1));
        endDateMap.put(CompareTypeEnum.NEXTMONTH, KDDateUtils.getTheMonthEnd((int)1));
        startDateMap.put(CompareTypeEnum.NEXTQUARTER, KDDateUtils.getTheQuarterStart((int)1));
        endDateMap.put(CompareTypeEnum.NEXTQUARTER, KDDateUtils.getTheQuarterEnd((int)1));
        startDateMap.put(CompareTypeEnum.NEXTYEAR, KDDateUtils.getTheYearStart((int)1));
        endDateMap.put(CompareTypeEnum.NEXTYEAR, KDDateUtils.getTheYearEnd((int)1));
        startDateMap.put(CompareTypeEnum.TODAYBEFORE, null);
        endDateMap.put(CompareTypeEnum.TODAYBEFORE, this.addDays(1));
        startDateMap.put(CompareTypeEnum.LESSTHANOREQUALTODAY, null);
        endDateMap.put(CompareTypeEnum.LESSTHANOREQUALTODAY, this.addDays(1));
        startDateMap.put(CompareTypeEnum.MORETHANOREQUALTODAY, this.addDays(0));
        endDateMap.put(CompareTypeEnum.MORETHANOREQUALTODAY, null);
        Date startDate = (Date)startDateMap.get(compareTypeEnum);
        Date endDate = (Date)endDateMap.get(compareTypeEnum);
        HashMap<String, Date> dateMap = new HashMap<String, Date>();
        dateMap.put("startDate", startDate);
        dateMap.put("endDate", endDate);
        return dateMap;
    }

    Date addDays(int diff) {
        return DateUtils.addDays((Date)KDDateUtils.today(), (int)diff);
    }

    Date getTheMonthWithoutOffsetStart(int diff) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(KDDateUtils.now());
        ((Calendar)calendar).add(2, diff);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private Map<String, Object> getNomalCompareParams(CompareTypeEnum compareTypeEnum, Object value) {
        HashMap<String, Object> compareMap = new HashMap<String, Object>();
        String compareType = "";
        Object compareValue = value;
        switch (compareTypeEnum) {
            case EQUAL: {
                compareType = "=";
                break;
            }
            case NOTEQUAL: {
                compareType = "!=";
                break;
            }
            case CHECKBOXEQUAL: {
                compareType = "=";
                break;
            }
            case CURRENTUSERINCHARGEDEPT: {
                compareType = "!=";
                break;
            }
            case LIKE: {
                compareType = "like";
                compareValue = "%" + value + "%";
                break;
            }
            case LEFTLIKE: {
                compareType = "like";
                compareValue = value + "%";
                break;
            }
            case RIGHTLIKE: {
                compareType = "like";
                compareValue = "%" + value;
                break;
            }
            case NOTLIKE: {
                compareType = "not like";
                compareValue = "%" + value + "%";
                break;
            }
            case IN: {
                compareType = "in";
                break;
            }
            case CHECKBOXIN: {
                compareType = "in";
                break;
            }
            case NOTIN: {
                compareType = "not in";
                break;
            }
            case CHECKBOXNOTIN: {
                compareType = "not in";
                break;
            }
            case ISNULL: {
                compareType = "is null";
                break;
            }
            case ISNOTNULL: {
                compareType = "is not null";
                break;
            }
            case GREATER: {
                compareType = ">";
                break;
            }
            case LESS: {
                compareType = "<";
                break;
            }
            case GREATEROREQUAL: {
                compareType = ">=";
                break;
            }
            case LESSOREQUAL: {
                compareType = "<=";
                break;
            }
        }
        compareMap.put("compareType", compareType);
        compareMap.put("compareValue", compareValue);
        return compareMap;
    }

    static {
        for (CompareTypeEnum compareTypeEnum : CompareTypeEnum.values()) {
            compareTypeMap.put(compareTypeEnum.getId(), compareTypeEnum);
        }
        nomalCompareTypes = EnumSet.allOf(CompareTypeEnum.class);
        nomalCompareTypes.add(CompareTypeEnum.EQUAL);
        nomalCompareTypes.add(CompareTypeEnum.NOTEQUAL);
        nomalCompareTypes.add(CompareTypeEnum.CHECKBOXEQUAL);
        nomalCompareTypes.add(CompareTypeEnum.CURRENTUSERINCHARGEDEPT);
        nomalCompareTypes.add(CompareTypeEnum.LIKE);
        nomalCompareTypes.add(CompareTypeEnum.LEFTLIKE);
        nomalCompareTypes.add(CompareTypeEnum.RIGHTLIKE);
        nomalCompareTypes.add(CompareTypeEnum.NOTLIKE);
        nomalCompareTypes.add(CompareTypeEnum.CHECKBOXIN);
        nomalCompareTypes.add(CompareTypeEnum.IN);
        nomalCompareTypes.add(CompareTypeEnum.CHECKBOXNOTIN);
        nomalCompareTypes.add(CompareTypeEnum.NOTIN);
        nomalCompareTypes.add(CompareTypeEnum.ISNULL);
        nomalCompareTypes.add(CompareTypeEnum.ISNOTNULL);
        nomalCompareTypes.add(CompareTypeEnum.GREATER);
        nomalCompareTypes.add(CompareTypeEnum.LESS);
        nomalCompareTypes.add(CompareTypeEnum.GREATEROREQUAL);
        nomalCompareTypes.add(CompareTypeEnum.LESSOREQUAL);
        dateCompareTypes = EnumSet.allOf(CompareTypeEnum.class);
        dateCompareTypes.add(CompareTypeEnum.TODAY);
        dateCompareTypes.add(CompareTypeEnum.YESTERDAY);
        dateCompareTypes.add(CompareTypeEnum.THISWEEK);
        dateCompareTypes.add(CompareTypeEnum.LASTWEEK);
        dateCompareTypes.add(CompareTypeEnum.THISMONTH);
        dateCompareTypes.add(CompareTypeEnum.LASTMONTH);
        dateCompareTypes.add(CompareTypeEnum.LASTTHREEMONTH);
        dateCompareTypes.add(CompareTypeEnum.THISQUARTER);
        dateCompareTypes.add(CompareTypeEnum.LASTQUARTER);
        dateCompareTypes.add(CompareTypeEnum.THISYEAR);
        dateCompareTypes.add(CompareTypeEnum.LASTYEAR);
        dateCompareTypes.add(CompareTypeEnum.TOMORROW);
        dateCompareTypes.add(CompareTypeEnum.NEXTWEEK);
        dateCompareTypes.add(CompareTypeEnum.NEXTMONTH);
        dateCompareTypes.add(CompareTypeEnum.NEXTQUARTER);
        dateCompareTypes.add(CompareTypeEnum.NEXTYEAR);
        dateCompareTypes.add(CompareTypeEnum.TODAYBEFORE);
        dateCompareTypes.add(CompareTypeEnum.LESSTHANOREQUALTODAY);
        dateCompareTypes.add(CompareTypeEnum.MORETHANOREQUALTODAY);
    }
}

