/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.helper;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.service.CalSalarySlipService;
import kd.swc.hsas.common.enums.ReleaseSalarySlipEnum;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipMSGDTO;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipOperationDTO;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipViewDTO;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.EncryptLevelEnum;
import kd.swc.hsbp.common.enums.EncryptTypeEnum;
import kd.swc.hsbp.common.enums.ReleaseStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PaySalarySlipHelper {
    private static final Log LOG = LogFactory.getLog(PaySalarySlipHelper.class);
    private static final String UN_PAY = "1";
    private static final String UN_CREATE = "2";
    private static final String SELECTLIST = "selectList";
    private static final String VIEW = "view";
    private static final String USEOLDVIEW = "useoldview";
    public static final String UN_PAY_COUNT = "unPayCount";
    public static final String PAYED_COUNT = "payedCount";
    public static final String CAL_PERSON_COUNT = "calPersonTotalCount";
    public static final String SOURCE = "source";
    public static final String SOURCE_PAY_ROLL_TASK = "payRollTask";
    public static final String SOURCE_CAL_PERSON = "calPerson";
    public static final String PAY_ROLL_TASK_COUNT = "payRollTaskCount";

    public static void setSalaryViewValue(IFormView view, IDataModel model, DynamicObject salaryView) {
        if (salaryView != null) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryslipview");
            QFilter filter = new QFilter("enable", "=", (Object)UN_PAY);
            filter.and(new QFilter("id", "=", salaryView.get("id")));
            DynamicObject viewObject = helper.queryOriginalOne("defaulttitle,autoendnote,isshowpayflow,issendbyauto,issendbymail", new QFilter[]{filter});
            boolean isSend = viewObject.getBoolean("issendbyauto");
            if (!isSend) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u90ae\u4ef6\u53d1\u5e03\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u663e\u793a\u65b9\u6848\u3002", (String)"PaySalarySlipHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]));
                model.setValue("salaryview", (Object)"");
                return;
            }
            model.setValue("caption", SWCStringUtils.isEmpty((String)viewObject.getString("defaulttitle")) ? null : viewObject.getString("defaulttitle"));
            model.setValue("remark", SWCStringUtils.isEmpty((String)viewObject.getString("autoendnote")) ? null : viewObject.getString("autoendnote"));
        } else {
            model.setValue("caption", null);
            model.setValue("remark", null);
        }
    }

    public static boolean checkEncrypt(IFormView view) {
        SWCDataServiceHelper helper;
        Map paramMap = SWCSalaryParameterServiceHelper.getSalaryParam((String)"salaryslip_encrypt");
        String encryptLevel = "";
        if (paramMap == null || paramMap.get("encryptlevel") == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u5de5\u8d44\u6761\u5931\u8d25\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u6570\u636e\u52a0\u5bc6\u65b9\u5f0f\u8bbe\u7f6e\u3002", (String)"PaySalarySlipHelper_4", (String)"swc-hsas-business", (Object[])new Object[0]));
            return false;
        }
        encryptLevel = paramMap.get("encryptlevel").toString();
        String encryptType = UN_PAY;
        view.getPageCache().put("encryptlevel", encryptLevel);
        view.getPageCache().put("encrypttype", encryptType);
        if (UN_PAY.equals(encryptLevel) && (helper = new SWCDataServiceHelper("hsas_secretkey")).count(new QFilter[0]) == 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u5de5\u8d44\u6761\u5931\u8d25\uff0c\u8bf7\u5148\u8fdb\u884c\u5de5\u8d44\u6761\u5b89\u5168\u8bbe\u7f6e\u3002", (String)"PaySalarySlipHelper_5", (String)"swc-hsas-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static Boolean checkSalarySlipParameterLock(IFormView view) {
        DLockInfo lockInfo = DLock.getLockInfo((String)"salaryslipparameterlock");
        if (null != lockInfo) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u5de5\u8d44\u6761\u6570\u636e\u52a0\u5bc6\u65b9\u5f0f\u914d\u7f6e\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PaySalarySlipHelper_8", (String)"swc-hsas-business", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void unSalarySlipLock(List<Long> calTaskIds, String key) {
        for (Long calTaskId : calTaskIds) {
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)key);
        }
    }

    public static List<QFilter> getPermFilter() {
        return SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"47150e89000000ac");
    }

    public static QFilter[] getQFilterArray(QFilter[] qFilters, List<QFilter> filters) {
        return (QFilter[])ArrayUtils.addAll((Object[])qFilters, (Object[])filters.toArray());
    }

    public static void saveSalarySlipReleaseRecord(IDataModel model) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryslipview");
        DynamicObject viewObjct = (DynamicObject)model.getValue("salaryview");
        if (viewObjct != null) {
            QFilter filter = new QFilter("boid", "=", viewObjct.get("id"));
            filter.and(new QFilter("datastatus", "in", (Object)new String[]{UN_PAY, UN_CREATE, "0"}));
            BaseDataHisHelper.addHisVerFilter((QFilter)filter);
            DynamicObject viewV = helper.queryOriginalOne("id", new QFilter[]{filter});
            helper = new SWCDataServiceHelper("hsas_releasesalsliprecord");
            DynamicObject object = helper.generateEmptyDynamicObject();
            Date operateDate = new Date();
            object.set("salaryview", model.getValue("salaryview"));
            object.set("salaryviewv", viewV.get("id"));
            object.set("caption", model.getValue("caption"));
            object.set("remark", model.getValue("remark"));
            object.set("creator", (Object)RequestContext.get().getCurrUserId());
            object.set("modifier", (Object)RequestContext.get().getCurrUserId());
            object.set("createtime", (Object)operateDate);
            object.set("modifytime", (Object)operateDate);
            helper.saveOne(object);
        }
    }

    public static boolean checkValue(IDataModel model, IFormView view) {
        String msg;
        DynamicObject dyObj = model.getDataEntity();
        DynamicObject salaryView = dyObj.getDynamicObject("salaryview");
        String caption = dyObj.getString("caption");
        boolean isLegal = true;
        if (StringUtils.isEmpty((CharSequence)caption)) {
            msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199 \u201c\u5de5\u8d44\u6761\u6807\u9898\u201d\u3002", (String)"PaySalarySlipHelper_7", (String)"swc-hsas-business", (Object[])new Object[0]);
            view.showErrorNotification(msg);
            isLegal = false;
        }
        if (salaryView == null) {
            msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199 \u201c\u5de5\u8d44\u6761\u663e\u793a\u65b9\u6848\u201d\u3002", (String)"PaySalarySlipHelper_6", (String)"swc-hsas-business", (Object[])new Object[0]);
            view.showErrorNotification(msg);
            isLegal = false;
        }
        return isLegal;
    }

    public static CalSalarySlipViewDTO getCalSalarySlipViewDTO(DynamicObject dyObj) {
        Long salaryViewId = dyObj.getLong("salaryview.id");
        Long salaryviewvId = dyObj.getLong("salaryview.sourcevid");
        int invalidDay = dyObj.getInt("salaryview.validduration");
        Boolean isunlimited = dyObj.getBoolean("salaryview.isunlimited");
        Date invalidDate = PaySalarySlipHelper.getInvalidDate(invalidDay, isunlimited);
        String caption = dyObj.getString("caption");
        String remark = dyObj.getString("remark");
        Boolean ispushnotify = dyObj.getBoolean("salaryview.ispushnotify");
        ArrayList<CalSalarySlipMSGDTO> msgdtos = new ArrayList<CalSalarySlipMSGDTO>(10);
        if (ispushnotify.booleanValue()) {
            DynamicObject[] query;
            ArrayList<Long> msgIds = new ArrayList<Long>();
            DynamicObjectCollection msgs = dyObj.getDynamicObjectCollection("salaryview.msgtemplate");
            for (DynamicObject msg : msgs) {
                Long id = msg.getLong("fbasedataid_id");
                msgIds.add(id);
            }
            SWCDataServiceHelper helper = new SWCDataServiceHelper("msg_template");
            QFilter filter = new QFilter("id", "in", msgIds);
            for (DynamicObject msg : query = helper.query("msgchannel,msgscenevalue", new QFilter[]{filter})) {
                String channel = msg.getString("msgchannel");
                String msgscene = "hsas_releasesalaryslip";
                CalSalarySlipMSGDTO msgdto = new CalSalarySlipMSGDTO();
                msgdto.setNotifyType(channel);
                msgdto.setTplScenel(msgscene);
                msgdtos.add(msgdto);
            }
        }
        return new CalSalarySlipViewDTO(salaryViewId, salaryviewvId, caption, remark, invalidDate, msgdtos);
    }

    public static Date getInvalidDate(int invalidDay, Boolean isunlimited) {
        if (isunlimited.booleanValue()) {
            invalidDay = -1;
        }
        if (invalidDay == -1) {
            String dataString = "2099-12-31 23:59:59";
            try {
                return SWCDateTimeUtils.parseDate((String)dataString);
            }
            catch (ParseException e) {
                LOG.error("datetime convert error");
            }
        }
        return SWCDateTimeUtils.addDay((Date)new Date(), (long)invalidDay);
    }

    public static void setCalSalarySlipView(IFormView view, CalSalarySlipViewDTO dto) {
        SWCPageCache cache = new SWCPageCache(view);
        String encryptlevel = (String)cache.get("encryptlevel", String.class);
        String encrypttype = (String)cache.get("encrypttype", String.class);
        dto.setEncryptLevel(EncryptLevelEnum.getEncryptLevelEnumByCode((String)encryptlevel));
        dto.setEncryptType(EncryptTypeEnum.getEncryptTypeEnumByCode((String)encrypttype));
    }

    public static boolean releaseSalarySlip(IFormView view, CalSalarySlipViewDTO calSalarySlipViewDTO, List<Long> taskIdList, List<Long> calList, Boolean isUseOldView, Boolean isPayUnCreate, Boolean isPayCreate) {
        if (PaySalarySlipHelper.checkSalarySlipParameterLock(view).booleanValue()) {
            PaySalarySlipHelper.releaseTaskLock(taskIdList);
            return false;
        }
        if (!PaySalarySlipHelper.checkEncrypt(view)) {
            PaySalarySlipHelper.releaseTaskLock(taskIdList);
            return false;
        }
        PaySalarySlipHelper.setCalSalarySlipView(view, calSalarySlipViewDTO);
        CalSalarySlipService salarySlipService = new CalSalarySlipService();
        CalSalarySlipOperationDTO dto = new CalSalarySlipOperationDTO(calSalarySlipViewDTO, taskIdList, calList, isUseOldView, isPayUnCreate, isPayCreate);
        try {
            salarySlipService.sendSalarySlip(dto);
        }
        catch (Exception e) {
            LOG.error("release salaryslip error ", (Object)e.getMessage());
        }
        return true;
    }

    private static void releaseTaskLock(List<Long> taskIdList) {
        taskIdList.forEach(taskId -> PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(taskId), (String)CalPersonOperationEnum.OP_CREATESALARY.getOperationKey()));
    }

    public static void recoverSalarySlip(List<Long> taskIdList, List<Long> calList) {
        CalSalarySlipService salarySlipService = new CalSalarySlipService();
        try {
            salarySlipService.recoverSalarySlip(taskIdList, calList);
        }
        catch (Exception e) {
            LOG.error("recover salaryslip error ", (Object)e.getMessage());
        }
    }

    public static Map<Long, ReleaseSalarySlipEnum> getReleaseSalarySlip(List<Long> taskIdList) {
        HashMap<Long, ReleaseSalarySlipEnum> result = new HashMap<Long, ReleaseSalarySlipEnum>(taskIdList.size());
        SWCDataServiceHelper calPayRollTaskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter taskIdFilter = new QFilter("id", "in", taskIdList);
        DynamicObject[] calPayRollTasks = calPayRollTaskHelper.query("tasktype,payrollscene,payrollgroupv,payrollscenev.lssuepayslip,payrollscenev.releasesalaryslip", new QFilter[]{taskIdFilter});
        HashSet<Long> payRollGroupVIDs = new HashSet<Long>(calPayRollTasks.length);
        HashMap payRollTaskGroupScenev = new HashMap(calPayRollTasks.length);
        HashMap<Long, DynamicObject> calPayRollTaskPayRollSceneVersion = new HashMap<Long, DynamicObject>(calPayRollTasks.length);
        for (DynamicObject calPayRollTask : calPayRollTasks) {
            if (SWCStringUtils.equals((String)UN_CREATE, (String)calPayRollTask.getString("tasktype"))) {
                result.put(calPayRollTask.getLong("id"), ReleaseSalarySlipEnum.APPROVE);
                continue;
            }
            long payRollGroupVID = calPayRollTask.getLong("payrollgroupv.id");
            payRollGroupVIDs.add(payRollGroupVID);
            HashMap<Long, Long> payRollGroupScene = new HashMap<Long, Long>();
            payRollGroupScene.put(payRollGroupVID, calPayRollTask.getLong("payrollscene.id"));
            payRollTaskGroupScenev.put(calPayRollTask.getLong("id"), payRollGroupScene);
            calPayRollTaskPayRollSceneVersion.put(calPayRollTask.getLong("id"), calPayRollTask.getDynamicObject("payrollscenev"));
        }
        SWCDataServiceHelper calPayRollGroupHelper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter payRollGroupVIDFilter = new QFilter("id", "in", payRollGroupVIDs);
        DynamicObject[] calPayRollGroupVersions = calPayRollGroupHelper.query("payrollsceneentry.lssuepayslip,payrollsceneentry.releasesalaryslip,payrollsceneentry.payrollscene,payrollsceneentry.payrollscene.lssuepayslip,payrollsceneentry.payrollscene.releasesalaryslip", new QFilter[]{payRollGroupVIDFilter});
        Set payRollTaskGroupScenevEntrySet = payRollTaskGroupScenev.entrySet();
        for (Map.Entry payRollTaskGroupScenevEntry : payRollTaskGroupScenevEntrySet) {
            Long calPayRollTaskId = (Long)payRollTaskGroupScenevEntry.getKey();
            Map payRollGroupScene = (Map)payRollTaskGroupScenevEntry.getValue();
            Set payRollGroupSceneEntrySet = payRollGroupScene.entrySet();
            for (Map.Entry payRollGroupSceneEntry : payRollGroupSceneEntrySet) {
                Long payRollGroupVID = (Long)payRollGroupSceneEntry.getKey();
                block3: for (DynamicObject calPayRollGroupVersion : calPayRollGroupVersions) {
                    if (payRollGroupVID.longValue() != calPayRollGroupVersion.getLong("id")) continue;
                    DynamicObjectCollection payRollSceneEntry = calPayRollGroupVersion.getDynamicObjectCollection("payrollsceneentry");
                    for (DynamicObject dynamicObject : payRollSceneEntry) {
                        if (((Long)payRollGroupSceneEntry.getValue()).longValue() != dynamicObject.getLong("payrollscene.id")) continue;
                        String releaseSalarySlip = dynamicObject.getString("releasesalaryslip");
                        String lssuePaySlip = dynamicObject.getString("lssuepayslip");
                        DynamicObject payRollSceneVersion = (DynamicObject)calPayRollTaskPayRollSceneVersion.get(calPayRollTaskId);
                        if (UN_PAY.equals(lssuePaySlip) && SWCStringUtils.isNotEmpty((String)releaseSalarySlip)) {
                            result.put(calPayRollTaskId, ReleaseSalarySlipEnum.getReleaseSalarySlipEnum((String)releaseSalarySlip));
                            continue block3;
                        }
                        if ((!UN_PAY.equals(lssuePaySlip) || !SWCStringUtils.isEmpty((String)releaseSalarySlip)) && !SWCStringUtils.isEmpty((String)lssuePaySlip) || payRollSceneVersion == null) continue block3;
                        releaseSalarySlip = payRollSceneVersion.getString("releasesalaryslip");
                        boolean lssuePaySlipInSC = payRollSceneVersion.getBoolean("lssuepayslip");
                        if (!lssuePaySlipInSC || !SWCStringUtils.isNotEmpty((String)releaseSalarySlip)) continue block3;
                        result.put(calPayRollTaskId, ReleaseSalarySlipEnum.getReleaseSalarySlipEnum((String)releaseSalarySlip));
                        continue block3;
                    }
                }
            }
        }
        return result;
    }

    public static QFilter getCanReleaseSalaryCalPersonFilter(ReleaseSalarySlipEnum releaseSalarySlipEnum) {
        QFilter qFilter;
        if (releaseSalarySlipEnum == null) {
            return new QFilter(UN_PAY, "=", (Object)1);
        }
        switch (releaseSalarySlipEnum) {
            case AUDIT: {
                qFilter = new QFilter("calstatus", "in", (Object)ReleaseSalarySlipEnum.getAuditCalState());
                break;
            }
            case APPROVE: {
                qFilter = new QFilter("calstatus", "in", (Object)ReleaseSalarySlipEnum.getApproveCalState());
                break;
            }
            case PAY: {
                qFilter = new QFilter("paystatus", "=", (Object)ReleaseSalarySlipEnum.getPayState());
                break;
            }
            default: {
                LOG.error("\u672a\u77e5\u679a\u4e3e\u503c{}", (Object)releaseSalarySlipEnum);
                qFilter = new QFilter(UN_PAY, "=", (Object)1);
            }
        }
        return qFilter;
    }

    public static QFilter getCanReleaseSalaryCalPersonSalaryStatusUnPayFilter() {
        QFilter salaryUnPayFilter = new QFilter("salarystatus", "=", (Object)ReleaseStateEnum.RELEASEFAILED.getCode());
        salaryUnPayFilter.or(new QFilter("salarystatus", "=", (Object)ReleaseStateEnum.UNRELEASE.getCode()));
        return salaryUnPayFilter;
    }

    public static QFilter getCanReleaseSalaryCalPersonSalaryStatusPayedFilter() {
        QFilter salaryPayedFilter = new QFilter("salarystatus", "=", (Object)ReleaseStateEnum.RECOVERED.getCode());
        salaryPayedFilter.or(new QFilter("salarystatus", "=", (Object)ReleaseStateEnum.INVALID.getCode()));
        return salaryPayedFilter;
    }

    public static FormShowParameter getReleaseSalaryViewForm(int unPayCount, int payedCount) {
        String formId = payedCount == 0 ? "hsas_paysalaryconfirm" : (unPayCount == 0 ? "hsas_paysalarypromptbox" : "hsas_manybothpayconfirm");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        return showParameter;
    }

    public static Long getDefaultSalarySlipView(Long calTaskPayRollTaskId, List<Long> orgList) {
        long payRollScenevId;
        SWCDataServiceHelper payRollSceneHelper;
        DynamicObject payRollSceneVDynamicObject;
        SWCDataServiceHelper calPayRollTaskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject calPayRollTask = calPayRollTaskHelper.queryOne("tasktype,payrollscene,payrollgroupv,payrollscenev.salaryslipview", (Object)calTaskPayRollTaskId);
        Long salarySlipViewId = 0L;
        Long payRollGroupVid = calPayRollTask.getLong("payrollgroupv.id");
        Long payRollSceneId = calPayRollTask.getLong("payrollscene.id");
        SWCDataServiceHelper payRollGroupHelper = new SWCDataServiceHelper("hsas_payrollgrp");
        DynamicObject payRollGroupVersion = payRollGroupHelper.queryOne("payrollsceneentry.payrollscene,payrollsceneentry.salaryslipview", (Object)payRollGroupVid);
        if (payRollGroupVersion != null) {
            DynamicObjectCollection payRollSceneEntries = payRollGroupVersion.getDynamicObjectCollection("payrollsceneentry");
            for (DynamicObject payRollSceneEntry : payRollSceneEntries) {
                if (payRollSceneId.longValue() != payRollSceneEntry.getLong("payrollscene.id")) continue;
                DynamicObject salarySlipView = payRollSceneEntry.getDynamicObject("salaryslipview");
                if (salarySlipView == null) break;
                salarySlipViewId = salarySlipView.getLong("id");
                break;
            }
        }
        if ((payRollSceneVDynamicObject = (payRollSceneHelper = new SWCDataServiceHelper("hsas_payrollscene")).queryOne("salaryslipview", (Object)(payRollScenevId = calPayRollTask.getLong("payrollscenev.id")))) != null) {
            salarySlipViewId = payRollSceneVDynamicObject.getLong("salaryslipview.id");
        }
        QFilter idFilter = new QFilter("id", "=", (Object)salarySlipViewId);
        QFilter baseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_salaryslipview", orgList, (boolean)true);
        if (baseDataFilter != null) {
            idFilter.and(baseDataFilter);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryslipview");
        if (helper.isExists(new QFilter[]{idFilter})) {
            return salarySlipViewId;
        }
        return 0L;
    }

    public static FormShowParameter getPaySalConfirm(int unPayNum, int payedNum, int calPersonCount, String source, int calPayRollTaskCount) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("hsas_paysalconfirm");
        parameters.setCustomParam(UN_PAY_COUNT, (Object)unPayNum);
        parameters.setCustomParam(PAYED_COUNT, (Object)payedNum);
        parameters.setCustomParam(CAL_PERSON_COUNT, (Object)calPersonCount);
        parameters.setCustomParam(SOURCE, (Object)source);
        parameters.setCustomParam(PAY_ROLL_TASK_COUNT, (Object)calPayRollTaskCount);
        return parameters;
    }
}

