/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.itemresult;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.itemresult.BaseItemResultFactory;
import kd.swc.hsas.common.dto.calitem.BaseItemResultDTO;
import kd.swc.hsas.common.dto.calitem.OtherItemResultDTO;
import kd.swc.hsbp.business.formula.enums.SaveDataTypeEnum;
import kd.swc.hsbp.business.item.utils.ItemDataUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalResultItemEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class BcDataResultFactory
extends BaseItemResultFactory {
    public BcDataResultFactory(Long calTableId, Boolean isProration, DynamicObject currency) {
        super(calTableId, isProration, currency);
    }

    @Override
    public List<BaseItemResultDTO> createItemResultDTOList(Map<Long, String> dataTypeMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        QFilter filter = new QFilter("id", "=", (Object)this.getCalTableId());
        filter.and(new QFilter("hsas_calbcentry.id", "!=", (Object)0L));
        DynamicObjectCollection calTablebcDataEntry = this.getCalTableBcDataEntry(helper, filter, null);
        Object bcEntryList = calTablebcDataEntry;
        if (this.isProration().booleanValue()) {
            LinkedHashMap<Long, List> entryListMap = new LinkedHashMap<Long, List>(bcEntryList.size());
            Iterator<Object> iterator = bcEntryList.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry2 = (DynamicObject)iterator.next();
                List entryList = entryListMap.computeIfAbsent(entry2.getLong("hsas_calbcentry.fetchitem.id"), key -> new LinkedList());
                entryList.add(entry2);
            }
            bcEntryList = new LinkedList();
            for (List entryList : entryListMap.values()) {
                entryList.sort(Comparator.comparingInt(entry -> entry.getInt("hsas_calbcentry.ftprorationindex")));
                bcEntryList.addAll(entryList);
            }
        }
        List<BaseItemResultDTO> list = this.getList((List<DynamicObject>)bcEntryList, dataTypeMap);
        return list;
    }

    private List<BaseItemResultDTO> getList(List<DynamicObject> calTablebcDataEntry, Map<Long, String> dataTypeMap) {
        ArrayList<BaseItemResultDTO> dtoList = new ArrayList<BaseItemResultDTO>(10);
        for (DynamicObject entry : calTablebcDataEntry) {
            Long fetchItemId = entry.getLong("hsas_calbcentry.fetchitem.id");
            OtherItemResultDTO itemResultDTO = new OtherItemResultDTO();
            if (fetchItemId == 0L) {
                itemResultDTO.setError(Boolean.TRUE);
                dtoList.add((BaseItemResultDTO)itemResultDTO);
                continue;
            }
            Long dataType = entry.getLong("hsas_calbcentry.fetchitem.datatype.id");
            String showType = dataTypeMap.get(dataType);
            String name = entry.getString("hsas_calbcentry.fetchitem.name");
            Date startDate = entry.getDate("hsas_calbcentry.bcstartdate");
            Date endDate = entry.getDate("hsas_calbcentry.bcenddate");
            SaveDataTypeEnum dataTypeEnum = SaveDataTypeEnum.getDataType((String)showType);
            String itemResult = this.getBcResultDataByDataType(dataTypeEnum, entry);
            String calBlock = entry.getString("hsas_calbcentry.bccalblock");
            this.setBaseItemResultData((BaseItemResultDTO)itemResultDTO, null, dataTypeEnum.getCodeByEnum(), itemResult, startDate, endDate, calBlock);
            itemResultDTO.setItemEnum(CalResultItemEnum.SYSITEM);
            itemResultDTO.setItemName(name);
            itemResultDTO.setItemNumber(entry.getString("hsas_calbcentry.fetchitem.number"));
            itemResultDTO.setError(Boolean.FALSE);
            itemResultDTO.setProrationIndex(Integer.valueOf(entry.getInt("hsas_calbcentry.ftprorationindex")));
            dtoList.add((BaseItemResultDTO)itemResultDTO);
        }
        return dtoList;
    }

    private DynamicObjectCollection getCalTableBcDataEntry(SWCDataServiceHelper helper, QFilter filter, String orderBy) {
        String selectFields = "id,calmainid,hsas_calbcentry.bctextvalue,hsas_calbcentry.bcnumvalue,hsas_calbcentry.bcdatevalue,hsas_calbcentry.id,hsas_calbcentry.fetchitem.id,hsas_calbcentry.fetchitem.name,hsas_calbcentry.fetchitem.datatype.id,hsas_calbcentry.bcproratetype,hsas_calbcentry.fetchitem.number,hsas_calbcentry.fetchitem.dataprecision.id,hsas_calbcentry.fetchitem.dataround.id,hsas_calbcentry.bcstartdate,hsas_calbcentry.bcenddate,hsas_calbcentry.bccalblock,hsas_calbcentry.ftprorationindex";
        return helper.queryOriginalCollection(selectFields, new QFilter[]{filter}, orderBy);
    }

    private String getBcResultDataByDataType(SaveDataTypeEnum dataTypeEnum, DynamicObject entry) {
        String value = "";
        switch (dataTypeEnum) {
            case NUM: {
                long precision = entry.getLong("hsas_calbcentry.fetchitem.dataprecision.id");
                long dataRound = entry.getLong("hsas_calbcentry.fetchitem.dataround.id");
                BigDecimal tempValue = entry.getBigDecimal("hsas_calbcentry.bcnumvalue");
                if (precision > 0L && dataRound > 0L) {
                    value = tempValue.setScale(ItemDataUtils.getScal((long)precision), ItemDataUtils.getRoundingMode((long)dataRound)).toPlainString();
                    break;
                }
                value = tempValue.toPlainString();
                break;
            }
            case DATE: {
                Date date = entry.getDate("hsas_calbcentry.bcdatevalue");
                if (date == null) break;
                value = SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
                break;
            }
            case TEXT: {
                value = entry.getString("hsas_calbcentry.bctextvalue");
                break;
            }
        }
        return value;
    }
}

