/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.itemresult;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.itemresult.BaseItemResultFactory;
import kd.swc.hsas.common.dto.calitem.BaseItemResultDTO;
import kd.swc.hsas.common.dto.calitem.BsItemResultDTO;
import kd.swc.hsbp.business.formula.enums.SaveDataTypeEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class BsItemResultFactory
extends BaseItemResultFactory {
    public BsItemResultFactory(Long calTableId, Boolean isProration, DynamicObject currency) {
        super(calTableId, isProration, currency);
    }

    @Override
    public List<BaseItemResultDTO> createItemResultDTOList(Map<Long, String> dataTypeMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        QFilter filter = new QFilter("id", "=", (Object)this.getCalTableId());
        filter.and(new QFilter("hsas_calbsentry.id", "!=", (Object)0L));
        DynamicObjectCollection calTableBsItemEntry = this.getCalTableBsItemEntry(helper, filter, null);
        List<BaseItemResultDTO> list = this.getList(calTableBsItemEntry, dataTypeMap);
        return list;
    }

    private List<BaseItemResultDTO> getList(DynamicObjectCollection calTableBsItemEntry, Map<Long, String> dataTypeMap) {
        ArrayList<BaseItemResultDTO> dtoList = new ArrayList<BaseItemResultDTO>(10);
        Object bsEntryList = calTableBsItemEntry;
        if (this.isProration().booleanValue()) {
            LinkedHashMap<Long, List> entryListMap = new LinkedHashMap<Long, List>(calTableBsItemEntry.size());
            for (DynamicObject entry2 : calTableBsItemEntry) {
                List entryList = entryListMap.computeIfAbsent(entry2.getLong("hsas_calbsentry.bizitem.id"), key -> new LinkedList());
                entryList.add(entry2);
            }
            bsEntryList = new LinkedList();
            for (List entryList : entryListMap.values()) {
                entryList.sort(Comparator.comparingInt(entry -> entry.getInt("hsas_calbsentry.bsprorationindex")));
                bsEntryList.addAll(entryList);
            }
        }
        Iterator iterator = bsEntryList.iterator();
        while (iterator.hasNext()) {
            DynamicObject entry3 = (DynamicObject)iterator.next();
            Long itemId = entry3.getLong("hsas_calbsentry.bizitem.id");
            Long dataType = entry3.getLong("hsas_calbsentry.bizitem.datatype.id");
            Date startDate = entry3.getDate("hsas_calbsentry.bsstartdate");
            Date endDate = entry3.getDate("hsas_calbsentry.bsenddate");
            String calBlock = entry3.getString("hsas_calbsentry.bscalblock");
            String showType = dataTypeMap.get(dataType);
            SaveDataTypeEnum dataTypeEnum = SaveDataTypeEnum.getDataType((String)showType);
            String itemResult = this.getBsResultDataByDataType(dataTypeEnum, entry3);
            BsItemResultDTO itemResultDTO = new BsItemResultDTO();
            this.setBaseItemResultData((BaseItemResultDTO)itemResultDTO, itemId, showType, itemResult, startDate, endDate, calBlock);
            itemResultDTO.setProrationIndex(Integer.valueOf(entry3.getInt("hsas_calbsentry.bsprorationindex")));
            itemResultDTO.setBizItemType(entry3.getString("hsas_calbsentry.bizitemtype"));
            dtoList.add((BaseItemResultDTO)itemResultDTO);
        }
        return dtoList;
    }

    private DynamicObjectCollection getCalTableBsItemEntry(SWCDataServiceHelper helper, QFilter filter, String orderBy) {
        String selectFields = "id,calmainid,hsas_calbsentry.bizitem,hsas_calbsentry.bstextvalue,hsas_calbsentry.bsnumvalue,hsas_calbsentry.bsdatevalue,hsas_calbsentry.bscalamountvalue,hsas_calbsentry.bsoriamountvalue,hsas_calbsentry.bsoricurrency,hsas_calbsentry.id,hsas_calbsentry.bizitem.name,hsas_calbsentry.bizitem.id,hsas_calbsentry.bizitem.number,hsas_calbsentry.bsproratetype,hsas_calbsentry.bizitem.datatype.id,hsas_calbsentry.bizitem.scalelimit,hsas_calbsentry.bsstartdate,hsas_calbsentry.bsenddate,hsas_calbsentry.bscalblock,hsas_calbsentry.bsprorationindex, hsas_calbsentry.bizitemtype";
        DynamicObjectCollection bsItemCollection = helper.queryOriginalCollection(selectFields, new QFilter[]{filter}, orderBy);
        return bsItemCollection;
    }

    private String getBsResultDataByDataType(SaveDataTypeEnum dataTypeEnum, DynamicObject entry) {
        String value = "";
        switch (dataTypeEnum) {
            case NUM: {
                BigDecimal numValue = entry.getBigDecimal("hsas_calbsentry.bsnumvalue");
                int numScale = Integer.parseInt(entry.getString("hsas_calbsentry.bizitem.scalelimit"));
                value = numValue.setScale(numScale, 1).toPlainString();
                break;
            }
            case DATE: {
                Date dateValue = entry.getDate("hsas_calbsentry.bsdatevalue");
                if (dateValue == null) break;
                value = SWCDateTimeUtils.format((Date)dateValue, (String)"yyyy-MM-dd");
                break;
            }
            case TEXT: {
                value = entry.getString("hsas_calbsentry.bstextvalue");
                break;
            }
            case AMOUNT: {
                BigDecimal amountValue = entry.getBigDecimal("hsas_calbsentry.bscalamountvalue");
                int amountScale = this.getCurrency().getInt("amtprecision");
                value = amountValue.setScale(amountScale, 1).toPlainString();
                break;
            }
        }
        return value;
    }
}

