/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.itemresult;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.itemresult.BaseItemResultFactory;
import kd.swc.hsas.common.dto.calitem.BaseItemResultDTO;
import kd.swc.hsas.common.dto.calitem.OtherItemResultDTO;
import kd.swc.hsbp.business.formula.enums.SaveDataTypeEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalResultItemEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class SpItemResultFactory
extends BaseItemResultFactory {
    private Map<Long, Integer> dataPrecisionMap;
    private Date startDate;
    private Date endDate;

    public SpItemResultFactory(Long calTableId, Boolean isProration, Map<Long, Integer> dataPrecisionMap, DynamicObject currency, Date startDate, Date endDate) {
        super(calTableId, isProration, currency);
        this.dataPrecisionMap = dataPrecisionMap;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    @Override
    public List<BaseItemResultDTO> createItemResultDTOList(Map<Long, String> dataTypeMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        QFilter filter = new QFilter("id", "=", (Object)this.getCalTableId());
        filter.and(new QFilter("hsas_calspentry.id", "!=", (Object)0L));
        DynamicObjectCollection calTableSpDataEntry = this.getcalTableSpDataEntry(helper, filter, null);
        List<BaseItemResultDTO> list = this.getList(calTableSpDataEntry, dataTypeMap);
        return list;
    }

    private List<BaseItemResultDTO> getList(DynamicObjectCollection calTableSpDataEntry, Map<Long, String> dataTypeMap) {
        ArrayList<BaseItemResultDTO> dtoList = new ArrayList<BaseItemResultDTO>(10);
        for (DynamicObject entry : calTableSpDataEntry) {
            Long itemId = entry.getLong("hsas_calspentry.supportitem.id");
            Long dataType = entry.getLong("hsas_calspentry.supportitem.dataType.id");
            String itemName = entry.getString("hsas_calspentry.supportitem.name");
            String calBlock = entry.getString("hsas_calspentry.spcalblock");
            String showType = dataTypeMap.get(dataType);
            SaveDataTypeEnum dataTypeEnum = SaveDataTypeEnum.getDataType((String)showType);
            String itemResult = this.getSpResultDataByDataType(dataTypeEnum, entry);
            OtherItemResultDTO itemResultDTO = new OtherItemResultDTO();
            this.setBaseItemResultData((BaseItemResultDTO)itemResultDTO, itemId, dataTypeEnum.getCodeByEnum(), itemResult, this.startDate, this.endDate, calBlock);
            itemResultDTO.setItemEnum(CalResultItemEnum.SUPPORTITEM);
            itemResultDTO.setItemName(itemName);
            itemResultDTO.setItemNumber(entry.getString("hsas_calspentry.supportitem.number"));
            itemResultDTO.setProrationIndex(Integer.valueOf(0));
            dtoList.add((BaseItemResultDTO)itemResultDTO);
        }
        return dtoList;
    }

    private DynamicObjectCollection getcalTableSpDataEntry(SWCDataServiceHelper helper, QFilter filter, String orderBy) {
        String selectFields = "id,calmainid,hsas_calspentry.sptextvalue,hsas_calspentry.spnumvalue,hsas_calspentry.spdatevalue,hsas_calspentry.id,hsas_calspentry.supportitem.id,hsas_calspentry.supportitem.name,hsas_calspentry.supportitem.dataType.id,hsas_calspentry.supportitem.number,hsas_calspentry.supportitem.dataprecision.id,hsas_calspentry.supportitem.dataround.id,hsas_calspentry.spproratetype,hsas_calspentry.spstartdate,hsas_calspentry.spenddate,hsas_calspentry.spcalblock";
        return helper.queryOriginalCollection(selectFields, new QFilter[]{filter}, orderBy);
    }

    private String getSpResultDataByDataType(SaveDataTypeEnum dataTypeEnum, DynamicObject entry) {
        String value = "";
        switch (dataTypeEnum) {
            case NUM: {
                Long id = entry.getLong("hsas_calspentry.supportitem.dataprecision.id");
                Integer scale = this.dataPrecisionMap.get(id);
                Long dataRoundId = entry.getLong("hsas_calspentry.supportitem.dataround.id");
                BigDecimal numValue = entry.getBigDecimal("hsas_calspentry.spnumvalue");
                BigDecimal bigDecimal = numValue.setScale((int)scale, this.getRoundingMode(dataRoundId));
                value = bigDecimal.toPlainString();
                break;
            }
            case DATE: {
                Date dateValue = entry.getDate("hsas_calspentry.spdatevalue");
                if (dateValue == null) break;
                value = SWCDateTimeUtils.format((Date)dateValue, (String)"yyyy-MM-dd");
                break;
            }
            case TEXT: {
                value = entry.getString("hsas_calspentry.sptextvalue");
                break;
            }
            case AMOUNT: {
                BigDecimal amountValue = entry.getBigDecimal("hsas_calspentry.spcalamountvalue");
                int itemScale = this.getCurrency().getInt("amtprecision");
                value = amountValue.setScale(itemScale, RoundingMode.HALF_UP).toPlainString();
                break;
            }
        }
        return value;
    }
}

