/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.helper.CalHelper;
import kd.swc.hsas.business.calpayrolltask.CalPayrollTaskHelper;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.calrequest.CalRequestHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.CalRequestStatusEnum;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalRollBackService {
    private static final Log logger = LogFactory.getLog(CalRollBackService.class);
    private long calTaskId;
    private List<Long> calPersonIdList;

    public CalRollBackService(long calTaskId, List<Long> calPersonIdList) {
        this.calTaskId = calTaskId;
        this.calPersonIdList = calPersonIdList;
    }

    public long calRollBack(String cancelType, String batchNum) {
        long calRecordId = CalHelper.getCalRecordPkId();
        logger.info("calRollBack-start,calTaskId = {},calRecordId = {},cancelType = {}", new Object[]{this.calTaskId, calRecordId, cancelType});
        int salaryItemCount = this.assembleSalaryItemCount();
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        DynamicObject[] calPersons = this.getCalPersonData();
        HashMap<String, String> calPersonStatusMap = new HashMap<String, String>(calPersons.length);
        for (DynamicObject calPerson : calPersons) {
            calPersonStatusMap.put(String.valueOf(calPerson.getLong("id")), calPerson.getString("calstatus"));
            calPerson.set("calstatus", (Object)CalStateEnum.CANCELCALING.getCode());
            calPerson.set("modifytime", (Object)new Date());
            calPerson.set("modifier", (Object)RequestContext.get().getCurrUserId());
        }
        try (TXHandle txHandle = TX.requiresNew();){
            this.saveCalRecordData(this.calPersonIdList.size(), salaryItemCount, calRecordId);
            CalRequestHelper.saveCalRequest((Long)this.calTaskId, (int)this.calPersonIdList.size(), (String)"uncal", (String)CalRequestStatusEnum.DOING.getCode(), (Long)calRecordId, (String)batchNum);
            ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_%s", calRecordId));
            appCache.put(String.format(Locale.ROOT, "cache_calPersonIdList_Key_%s", calRecordId), this.calPersonIdList);
            calPersonHelper.update(calPersons);
            appCache.put(String.format(Locale.ROOT, "RECOVER_CALSTATUS_%s", calRecordId), calPersonStatusMap);
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(this.calTaskId), (String)CalPersonOperationEnum.CANCEL_CAL.getOperationKey());
            txHandle.commit();
        }
        boolean isFail = false;
        try {
            SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"IHSCSService", (String)"cancelCal", (Object[])new Object[]{this.calTaskId, calRecordId, this.calPersonIdList, cancelType});
        }
        catch (Exception ex) {
            isFail = true;
            logger.error("invoke IHSCSService.cancelCal error.", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
        }
        finally {
            if (isFail) {
                this.handleExceptionData(calPersonStatusMap, calRecordId);
            }
        }
        logger.info("calRollBack-end,calTaskId = {},calRecordId = {},cancelType = {}", new Object[]{this.calTaskId, calRecordId, cancelType});
        return calRecordId;
    }

    private DynamicObject[] getCalPersonData() {
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        DynamicObject[] calPersons = calPersonHelper.query("id,calstatus,modifytime,modifier", new QFilter[]{new QFilter("id", "in", this.calPersonIdList)});
        return calPersons;
    }

    private void handleExceptionData(Map<String, String> calPersonStatusMap, long calRecordId) {
        logger.info("handleExceptionData start");
        DynamicObject[] calPersons = this.getCalPersonData();
        String calStatus = null;
        for (DynamicObject calPerson : calPersons) {
            calStatus = calPersonStatusMap.get(String.valueOf(calPerson.getLong("id")));
            if (!SWCStringUtils.isNotEmpty((String)calStatus)) continue;
            calPerson.set("calstatus", (Object)calStatus);
            calPerson.set("modifytime", (Object)new Date());
            calPerson.set("modifier", (Object)RequestContext.get().getCurrUserId());
        }
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        calPersonHelper.update(calPersons);
        this.deleteCalRecord(calRecordId);
        this.deleteCalRequest(calRecordId);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_%s", calRecordId));
        appCache.remove(String.format(Locale.ROOT, "cache_calPersonIdList_Key_%s", calRecordId));
        appCache.remove(String.format(Locale.ROOT, "RECOVER_CALSTATUS_%s", calRecordId));
        logger.info("handleExceptionData end");
    }

    private void deleteCalRequest(long calRecordId) {
        SWCDataServiceHelper calRequestHelper = new SWCDataServiceHelper("hsas_calrequest");
        QFilter filter = new QFilter("calrecord.id", "=", (Object)calRecordId);
        calRequestHelper.deleteByFilter(new QFilter[]{filter});
    }

    private void deleteCalRecord(long calRecordId) {
        SWCDataServiceHelper calRecordHelper = new SWCDataServiceHelper("hsas_calrecord");
        calRecordHelper.deleteOne((Object)calRecordId);
    }

    private int assembleSalaryItemCount() {
        DynamicObject task = CalPayrollTaskHelper.queryTaskInfoById(this.calTaskId);
        DynamicObject calRuleHisObj = task.getDynamicObject("calrulev");
        SWCDataServiceHelper calRuleHisHelper = new SWCDataServiceHelper("hsas_calrule");
        QFilter qFilter = new QFilter("id", "=", (Object)calRuleHisObj.getLong("id"));
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        DynamicObjectCollection calRuleData = calRuleHisHelper.queryOriginalCollection("id,name,calruleitementry.id", new QFilter[]{qFilter});
        return calRuleData.size();
    }

    private void saveCalRecordData(int totalCount, Integer salaryItemCount, long calRecordId) {
        SWCDataServiceHelper calRecordHelper = new SWCDataServiceHelper("hsas_calrecord");
        Date nowDate = new Date();
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject calRecord = calRecordHelper.generateEmptyDynamicObject();
        calRecord.set("id", (Object)calRecordId);
        calRecord.set("caltask", (Object)this.calTaskId);
        calRecord.set("totalcount", (Object)totalCount);
        calRecord.set("starttime", (Object)nowDate);
        calRecord.set("calstatus", (Object)"1");
        calRecord.set("salaryitemcount", (Object)salaryItemCount);
        calRecord.set("createtime", (Object)nowDate);
        calRecord.set("modifytime", (Object)nowDate);
        calRecord.set("creator", (Object)userId);
        calRecord.set("modifier", (Object)userId);
        calRecord.set("reportnum", (Object)CalHelper.getReportNum());
        calRecord.set("optype", (Object)"2");
        calRecordHelper.saveOne(calRecord);
    }
}

