/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.service;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;

public class WorkCalendarLoadService {
    public static final String ID = "id";
    public static final String WORK_DATE = "workDate";
    public static final String DATE_TYPE = "dateType";
    public static final String WORKCALENDAR_ENTITY = "bd_workcalendar";
    public static final String WORK_DAY = "1";
    private static Log logger = LogFactory.getLog(WorkCalendarLoadService.class);

    public static Map<String, String> getHrcsCalendarData(Long workcalenderId, Date startDate, Date endDate) {
        return (Map)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSCalendarService", (String)"getCalendarDataWithDay", (Object[])new Object[]{workcalenderId, startDate, endDate});
    }

    public static List<Map<String, String>> loadThreeYearWorkCalendar(Date date, Long wpId) {
        int year = SWCDateTimeUtils.getYear((Date)date);
        String dateFrom = year - 1 + "-01-01";
        String dateTo = year + 1 + "-12-31";
        return WorkCalendarLoadService.load(wpId, dateFrom, dateTo);
    }

    public static Date getWorkDate(Date date, boolean isBiggerDays, Integer workDayNum, List<Map<String, String>> workCalendar, boolean isContainsCurrentDate) {
        if (workDayNum == 0) {
            return date;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = format.format(date);
        Date workDate = null;
        int dayIndexInWorkCalendar = WorkCalendarLoadService.getDayIndexInWorkCalendar(date, workCalendar);
        if (dayIndexInWorkCalendar < 0) {
            return isBiggerDays ? SWCDateTimeUtils.addDay((Date)date, (long)(workDayNum - 1)) : SWCDateTimeUtils.addDay((Date)date, (long)(1 - workDayNum));
        }
        ArrayList<String> workDayList = new ArrayList<String>(workDayNum);
        Map<String, String> curMap = workCalendar.get(dayIndexInWorkCalendar);
        String curDateType = curMap.get(DATE_TYPE);
        String curTargetDate = curMap.get(WORK_DATE);
        if (isContainsCurrentDate && WORK_DAY.equals(curDateType) && dateStr.equals(curTargetDate)) {
            workDayList.add(curTargetDate);
        }
        while (workDayList.size() < workDayNum) {
            Map<String, String> map = workCalendar.get(dayIndexInWorkCalendar);
            String dateType = map.get(DATE_TYPE);
            String targetDate = map.get(WORK_DATE);
            if (WORK_DAY.equals(dateType) && !dateStr.equals(targetDate)) {
                workDayList.add(targetDate);
            }
            int n = dayIndexInWorkCalendar = isBiggerDays ? dayIndexInWorkCalendar + 1 : dayIndexInWorkCalendar - 1;
            if (dayIndexInWorkCalendar < workCalendar.size() && dayIndexInWorkCalendar >= 0) continue;
            break;
        }
        if (dayIndexInWorkCalendar >= workCalendar.size() || dayIndexInWorkCalendar < 0) {
            if (workDayList.size() == 1 && workDayNum == 1) {
                try {
                    workDate = format.parse((String)workDayList.get(workDayNum - 1));
                }
                catch (ParseException e) {
                    logger.error("workCalendar date parse fail !", (Throwable)e);
                    return isBiggerDays ? SWCDateTimeUtils.addDay((Date)date, (long)(workDayNum - 1)) : SWCDateTimeUtils.addDay((Date)date, (long)(1 - workDayNum));
                }
                return workDate;
            }
            return isBiggerDays ? SWCDateTimeUtils.addDay((Date)date, (long)(workDayNum - 1)) : SWCDateTimeUtils.addDay((Date)date, (long)(1 - workDayNum));
        }
        try {
            workDate = format.parse((String)workDayList.get(workDayNum - 1));
        }
        catch (ParseException e) {
            logger.error("workCalendar date parse fail !", (Throwable)e);
            return isBiggerDays ? SWCDateTimeUtils.addDay((Date)date, (long)(workDayNum - 1)) : SWCDateTimeUtils.addDay((Date)date, (long)(1 - workDayNum));
        }
        return workDate;
    }

    public static int getDayIndexInWorkCalendar(Date date, List<Map<String, String>> workCalendar) {
        if (workCalendar == null || workCalendar.isEmpty()) {
            return -1;
        }
        SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = SDF.format(date);
        for (int i = 0; i < workCalendar.size(); ++i) {
            Map<String, String> map = workCalendar.get(i);
            String workDateStr = map.get(WORK_DATE);
            if (!dateStr.equals(workDateStr)) continue;
            return i;
        }
        return -1;
    }

    private static List<Map<String, String>> load(Long wpId, String rangeStart, String rangeEnd) {
        List<Map<String, String>> workDataList = new ArrayList<Map<String, String>>(10);
        try {
            Date start = SWCDateTimeUtils.parseDate((String)rangeStart);
            Date end = SWCDateTimeUtils.parseDate((String)rangeEnd);
            Map dateMap = (Map)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSCalendarService", (String)"getCalendarDataWithDay", (Object[])new Object[]{wpId, start, end});
            for (Map.Entry entry : dateMap.entrySet()) {
                HashMap dateTypeMap = Maps.newHashMapWithExpectedSize((int)2);
                dateTypeMap.put(WORK_DATE, entry.getKey());
                dateTypeMap.put(DATE_TYPE, entry.getValue());
                workDataList.add(dateTypeMap);
            }
            workDataList = workDataList.stream().sorted(Comparator.comparing(map -> {
                try {
                    return SWCDateTimeUtils.parseDate((String)((String)map.get(WORK_DATE)));
                }
                catch (ParseException e) {
                    logger.error((Throwable)e);
                    return new Date(0L);
                }
            })).collect(Collectors.toList());
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
        }
        return workDataList;
    }
}

