/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.service.calperson;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.swc.hsas.business.cal.helper.CalPayRollTaskCalHelper;
import kd.swc.hsas.business.cal.service.calperson.ProcessHandler;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.cal.vo.CalPayRollTaskContext;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;

public class DefaultProcessHandler
implements ProcessHandler {
    @Override
    public void open(IFormView formView, String caption, Map<String, Object> param) {
        FormShowParameter processFormShowParameter = CalPayRollTaskCalHelper.getModalFormShowParameter("hsas_payrolltaskprocess");
        processFormShowParameter.setCaption(caption);
        if (param != null) {
            processFormShowParameter.getCustomParams().putAll(param);
            Object closeCallBack = param.get("closeCallBack");
            processFormShowParameter.setCloseCallBack((CloseCallBack)closeCallBack);
        }
        formView.showForm(processFormShowParameter);
    }

    @Override
    public void update(int successCount, int failCount, String batchId, Long calPayRollTaskId) {
        ISWCAppCache appCache = SWCAppCache.get((String)"SWC_PAYROLL_TASK");
        HashMap<String, Integer> process = (HashMap<String, Integer>)appCache.get("process" + batchId + calPayRollTaskId, HashMap.class);
        if (process == null) {
            process = new HashMap<String, Integer>(2);
            process.put("successCount", successCount);
            process.put("failCount", failCount);
        } else {
            process.put("successCount", (Integer)process.get("successCount") + successCount);
            process.put("failCount", (Integer)process.get("failCount") + failCount);
        }
        appCache.put("process" + batchId + calPayRollTaskId, process);
    }

    public static Map<String, Object> get(CalPayRollTaskContext calPayRollTaskContext) {
        String traceId = calPayRollTaskContext.getTraceId();
        List<CalPayRollTask> validDatas = calPayRollTaskContext.getValidDatas();
        List<CalPayRollTask> invalidDatas = calPayRollTaskContext.getInvalidDatas();
        return DefaultProcessHandler.get(traceId, validDatas, invalidDatas);
    }

    public static Map<String, Object> get(String traceId, List<CalPayRollTask> validDatas, List<CalPayRollTask> invalidDatas) {
        ISWCAppCache appCache = SWCAppCache.get((String)"SWC_PAYROLL_TASK");
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        int sumCount = 0;
        int sumSuccessCount = 0;
        int sumFailCount = 0;
        for (CalPayRollTask validData : validDatas) {
            sumCount += validData.getCountCalPersons();
            HashMap map = (HashMap)appCache.get("process" + traceId + validData.getCalPayRollTaskId(), HashMap.class);
            if (map == null) continue;
            Integer successCount = (Integer)map.get("successCount");
            Integer failCount = (Integer)map.get("failCount");
            sumSuccessCount += successCount.intValue();
            sumFailCount += failCount.intValue();
        }
        for (CalPayRollTask invalidData : invalidDatas) {
            int countCalTables = invalidData.getCountCalPersons();
            invalidData.setSumFailCount(countCalTables);
            sumFailCount += countCalTables;
            sumCount += invalidData.getCountCalPersons();
        }
        result.put("sumFailCount", sumFailCount);
        result.put("sumSuccessCount", sumSuccessCount);
        result.put("sumCount", sumCount);
        if (sumCount == 0) {
            result.put("progress", new BigDecimal("100"));
            return result;
        }
        BigDecimal process = new BigDecimal(String.valueOf(sumSuccessCount + sumFailCount)).divide(new BigDecimal(String.valueOf(sumCount)), 2, 4).multiply(new BigDecimal("100"));
        if (process.intValue() == 100 && sumSuccessCount + sumFailCount != sumCount) {
            process = new BigDecimal("99");
        }
        result.put("progress", process);
        return result;
    }
}

