/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cal.thread;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.cal.helper.CalResultCoverHelper;
import kd.swc.hsas.business.cal.service.ResultCoverService;

public class CalResultCoverImportTask
implements Callable<Map<String, Object>> {
    private static final Log log = LogFactory.getLog(CalResultCoverImportTask.class);
    private CountDownLatch countDownLatch;
    private int precision;
    private Long taskId;
    private Map<String, Map<String, String>> salaryItemMap;
    private List<Map<Integer, String>> dataRow;
    private List<Map<Integer, String>> dataHead;
    private int dataIndex;
    private Boolean taxCalEnable;
    List<Long> needReCalList = new ArrayList<Long>(10);
    List<DynamicObject> validCoverDataList = new ArrayList<DynamicObject>(10);
    Map<String, Object> importResult = new HashMap<String, Object>(16);
    List<DynamicObject> coverLogDataList = new ArrayList<DynamicObject>(10);
    List<Map<String, String>> errDataList = new ArrayList<Map<String, String>>(10);
    Map<Long, List<Long>> importData = new HashMap<Long, List<Long>>(16);
    private RequestContext requestContext;
    private String coverType;

    public CalResultCoverImportTask(String coverType, int dataIndex, CountDownLatch countDownLatch, int precision, Long taskId, Map<String, Map<String, String>> salaryItemMap, List<Map<Integer, String>> dataRow, List<Map<Integer, String>> dataHead, Boolean taxCalEnable, RequestContext requestContext) {
        this.countDownLatch = countDownLatch;
        this.precision = precision;
        this.taskId = taskId;
        this.salaryItemMap = salaryItemMap;
        this.dataRow = dataRow;
        this.dataHead = dataHead;
        this.taxCalEnable = taxCalEnable;
        this.requestContext = requestContext;
        this.dataIndex = dataIndex;
        this.coverType = coverType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> call() {
        RequestContext.copyAndSet((RequestContext)this.requestContext);
        String traceId = this.getTraceId();
        log.info("begin resultCover import traceId:{}", (Object)traceId);
        ResultCoverService resultCoverService = CalResultCoverHelper.getResultCoverService(this.coverType);
        try {
            resultCoverService.doSaveImportResultCoverData(this.dataIndex, this.needReCalList, this.precision, this.salaryItemMap, this.dataHead.get(2), this.dataRow, this.taskId, this.validCoverDataList, this.errDataList, this.coverLogDataList, this.importData, this.taxCalEnable);
        }
        catch (Exception exception) {
            log.error("importResultCoverData_error", (Throwable)exception);
        }
        finally {
            this.countDownLatch.countDown();
        }
        this.importResult.put("importData", this.importData);
        this.importResult.put("errDataList", this.errDataList);
        return this.importResult;
    }

    private String getTraceId() {
        return UUID.randomUUID().toString();
    }

    public RoundingMode getRoundingMode(long dataRoundId) {
        if (dataRoundId == 1010L) {
            return RoundingMode.HALF_UP;
        }
        if (dataRoundId == 1020L) {
            return RoundingMode.DOWN;
        }
        if (dataRoundId == 1030L) {
            return RoundingMode.UP;
        }
        return RoundingMode.HALF_UP;
    }
}

