/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.callistrule;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.swc.hsbp.common.enums.RuleOperatorEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.ConditionExpressInfo;
import kd.swc.hsbp.common.vo.ConditionInfo;
import kd.swc.hsbp.common.vo.RuleConditionInfo;

public class CalListRuleHelper {
    public static String getParamValues(String conditions) {
        RuleConditionInfo conditionInfo = (RuleConditionInfo)JSON.parseObject((String)conditions, RuleConditionInfo.class);
        List conditionList = conditionInfo.getConditionList();
        List conditionExpressList = conditionInfo.getConditionExpressList();
        if (conditionList == null || conditionExpressList == null) {
            return null;
        }
        Map<String, ConditionInfo> conditionMap = conditionList.stream().collect(Collectors.toMap(ConditionInfo::getName, info -> info, (o1, o2) -> o1));
        StringBuilder sb = new StringBuilder();
        for (ConditionExpressInfo conditionExpressInfo : conditionExpressList) {
            CalListRuleHelper.appendConditionHtml(conditionMap, sb, conditionExpressInfo);
            String logic = null;
            if (!SWCStringUtils.isEmpty((String)conditionExpressInfo.getLogical())) {
                logic = "and".equals(conditionExpressInfo.getLogical().trim()) ? ResManager.loadKDString((String)"\u5e76\u4e14", (String)"CalListRuleEdit_22", (String)"swc-hsas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6216\u8005", (String)"CalListRuleEdit_23", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            }
            sb.append(CalListRuleHelper.tranNullToEmpty(logic));
            sb.append('\n');
        }
        return sb.toString();
    }

    private static void appendConditionHtml(Map<String, ConditionInfo> conditionMap, StringBuilder sb, ConditionExpressInfo conditionExpressInfo) {
        String name = conditionExpressInfo.getName();
        ConditionInfo condition = conditionMap.get(name);
        if (condition == null) {
            return;
        }
        sb.append(CalListRuleHelper.tranNullToEmpty(conditionExpressInfo.getLeftBracket()));
        sb.append('\u3010').append(CalListRuleHelper.tranNullToEmpty(condition.getDisplayParam())).append('\u3011');
        sb.append(CalListRuleHelper.tranNullToEmpty(RuleOperatorEnum.getEnum((String)condition.getOperators()).getName()));
        if (SWCStringUtils.equals((String)condition.getValueType(), (String)"1")) {
            sb.append('\u3010');
        } else {
            sb.append(" \"");
        }
        if (SWCStringUtils.isNotEmpty((String)condition.getDisplayValue())) {
            sb.append(condition.getDisplayValue());
        }
        if (SWCStringUtils.equals((String)condition.getValueType(), (String)"1")) {
            sb.append('\u3011');
        } else {
            sb.append("\" ");
        }
        sb.append(CalListRuleHelper.tranNullToEmpty(conditionExpressInfo.getRightBracket()));
        sb.append('\n');
    }

    private static String tranNullToEmpty(String str) {
        if (SWCStringUtils.isEmpty((String)str)) {
            str = "";
        }
        return str;
    }
}

