/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.calpayrolltask;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.vo.CalPayRollTaskMutex;

public class CalPayrollTaskHelper {
    private static final Log LOGGER = LogFactory.getLog(CalPayrollTaskHelper.class);

    public static DynamicObject queryTaskInfoById(Long id) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String selPros = "id,number,taskstatus, name, startdate, enddate, ishandleproration,taxitemschemev,country,org,calrulev,paysubjectv,calversionno,tasktype,payrollgroupv.currency.amtprecision,islimitadd";
        return helper.queryOne(selPros, (Object)id);
    }

    public static DynamicObject queryOriginalTaskInfoById(String selectProp, Long id) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        return helper.queryOriginalOne(selectProp, (Object)id);
    }

    public static ListShowParameter getCalTableListForm(String parentPageId, long calTaskId) {
        Map<String, String> taskInfo = CalPayrollTaskHelper.getTaskInfo(calTaskId);
        if (taskInfo == null) {
            return null;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("hsas_calpersonlist");
        showParameter.setBillFormId("hsas_calperson");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("payrolltaskdatanumber", (Object)taskInfo.get("payrolltaskdatanumber"));
        showParameter.setCustomParam("payrolltaskdataid", (Object)calTaskId);
        showParameter.setCustomParam("org", (Object)taskInfo.get("orgId"));
        showParameter.setCustomParam("name", (Object)taskInfo.get("name"));
        showParameter.setCustomParam("startdate", (Object)taskInfo.get("startdate"));
        showParameter.setCustomParam("enddate", (Object)taskInfo.get("enddate"));
        showParameter.setCustomParam("calListViewVid", (Object)taskInfo.get("calListViewVid"));
        showParameter.setCustomParam("payrollgroup", (Object)taskInfo.get("payrollgroup"));
        showParameter.setCustomParam("payrollgroupv", (Object)taskInfo.get("payrollgroupv"));
        showParameter.setCustomParam("payrolldate", (Object)taskInfo.get("payrolldate"));
        showParameter.setCustomParam("calTaskType", (Object)taskInfo.get("calTaskType"));
        showParameter.setCustomParam("payRollSceneVId", (Object)taskInfo.get("payRollSceneVId"));
        showParameter.setCustomParam("calPeriodId", (Object)taskInfo.get("calPeriodVId"));
        showParameter.setCustomParam("calRuleId", (Object)taskInfo.get("calRuleId"));
        showParameter.setCustomParam("calRuleVId", (Object)taskInfo.get("calRuleVId"));
        showParameter.setCustomParam("calTimes", (Object)taskInfo.get("calCount"));
        showParameter.setCustomParam("orgName", (Object)taskInfo.get("orgName"));
        showParameter.setCustomParam("taskstatus", (Object)taskInfo.get("taskstatus"));
        showParameter.setCustomParam("countryId", (Object)taskInfo.get("countryId"));
        showParameter.setCustomParam("isEdit", (Object)Boolean.FALSE);
        showParameter.setCustomParam("isSplitPage", (Object)Boolean.TRUE);
        showParameter.setCustomParam("isShowNotCover", (Object)Boolean.TRUE);
        showParameter.setCustomParam("notShowColumns", null);
        showParameter.setCustomParam("editColumns", null);
        showParameter.setCustomParam("isShowSalaryItem", (Object)Boolean.FALSE);
        showParameter.setPageId(parentPageId + "bill" + calTaskId);
        return showParameter;
    }

    private static Map<String, String> getTaskInfo(Long taskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        HashMap<String, String> map = new HashMap<String, String>(16);
        DynamicObject dy = helper.queryOne("org.id,name,startdate,enddate,calcount,calrule.id,calrulev.id,org.name,taskstatus,country.id,payrollgroup.id,payrolldate,payrollgroupv.id,tasktype,payrollscenev.id,period.id,callistviewv.id", (Object)taskId);
        if (null == dy) {
            return null;
        }
        String orgStr = dy.getString("org.id");
        String name = dy.getString("name");
        String startDate = dy.getString("startdate");
        String endDate = dy.getString("enddate");
        String calCount = dy.getString("calcount");
        String calRuleId = dy.getString("calrule.id");
        String calRuleVId = dy.getString("calrulev.id");
        String orgName = dy.getString("org.name");
        String taskstatus = dy.getString("taskstatus");
        String calListViewVid = dy.getString("callistviewv.id");
        long countryId = dy.getLong("country.id");
        String calTaskType = dy.getString("tasktype");
        String payRollSceneId = dy.getString("payrollscenev.id");
        String calPeriodId = dy.getString("period.id");
        map.put("payrolltaskdatanumber", dy.getString("number"));
        map.put("orgId", orgStr);
        map.put("name", name);
        map.put("startdate", startDate);
        map.put("enddate", endDate);
        map.put("calCount", calCount);
        map.put("calRuleId", calRuleId);
        map.put("calRuleVId", calRuleVId);
        map.put("orgName", orgName);
        map.put("taskstatus", taskstatus);
        map.put("countryId", String.valueOf(countryId));
        map.put("payrollgroup", dy.getString("payrollgroup.id"));
        map.put("payrollgroupv", dy.getString("payrollgroupv.id"));
        map.put("payrolldate", dy.getString("payrolldate"));
        map.put("calTaskType", calTaskType);
        map.put("payRollSceneVId", payRollSceneId);
        map.put("calPeriodVId", calPeriodId);
        map.put("calListViewVid", calListViewVid);
        return map;
    }

    public static Map<String, Object> getStatusMap(Long pkId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter qFilter = new QFilter("id", "=", (Object)pkId);
        String selectProps = "id, taskstatus, calpersoncount,tasktype";
        DynamicObject calPayrollTask = serviceHelper.queryOne(selectProps, new QFilter[]{qFilter});
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("taskstatus", calPayrollTask.getString("taskstatus"));
        map.put("calpersoncount", calPayrollTask.getInt("calpersoncount"));
        map.put("taskType", calPayrollTask.getString("tasktype"));
        return map;
    }

    public static void openCalPersonListView(AbstractFormPlugin formPlugin, Long calTaskId) {
        ListShowParameter listShowParameter = CalPayrollTaskHelper.getCalTableListForm(formPlugin.getView().getPageId(), calTaskId);
        if (listShowParameter == null) {
            String errorTips = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CalPayrollTaskHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]);
            formPlugin.getView().showErrorNotification(errorTips);
            return;
        }
        formPlugin.getView().showForm((FormShowParameter)listShowParameter);
    }

    public static int getSerialIndex(String number) {
        int serialIndex = 0;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_serialnumber");
        QFilter filter = new QFilter("prefixserial", "=", (Object)number);
        filter.and(new QFilter("entityid", "=", (Object)"hsas_calpayrolltask"));
        DynamicObject dy = helper.queryOne("serialnumber", new QFilter[]{filter});
        serialIndex = null == dy ? 1 : dy.getInt("serialnumber") + 1;
        return serialIndex;
    }

    public static void saveSerialNumber(Integer serialIndex, String numberPrefix, String entityName) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_serialnumber");
        QFilter filter = new QFilter("entityid", "=", (Object)entityName);
        filter.and(new QFilter("prefixserial", "=", (Object)numberPrefix));
        DynamicObject dyObj = helper.queryOne("serialnumber", new QFilter[]{filter});
        if (null == dyObj) {
            dyObj = helper.generateEmptyDynamicObject();
            dyObj.set("prefixserial", (Object)numberPrefix);
            dyObj.set("entityid", (Object)entityName);
            dyObj.set("serialnumber", (Object)serialIndex);
            helper.saveOne(dyObj);
        } else {
            dyObj.set("serialnumber", (Object)serialIndex);
            helper.saveOne(dyObj);
        }
    }

    public static String checkCalPayRollTaskIsMutex(CalPayRollTask calPayRollTask, CalPersonOperationEnum calPersonOperationEnum) {
        String lockKey = "calPayRolTaskMutexLock_" + calPayRollTask.getCalPayRollTaskId();
        String msg = null;
        try (DLock lock = DLock.create((String)lockKey);){
            if (lock.tryLock(60000L)) {
                CalPayRollTaskMutex calPayRollTaskMutex = PayrollTaskHelper.tryLock((String)"hsas_calpayrolltask", (String)String.valueOf(calPayRollTask.getCalPayRollTaskId()), (String)calPersonOperationEnum.getOperationKey());
                if (calPayRollTaskMutex != null) {
                    LOGGER.info("operationMutexError:{}", (Object)calPersonOperationEnum.getOperationKey());
                    CalPersonOperationEnum currentOperation = calPayRollTaskMutex.getCalPersonOperationEnum();
                    msg = MessageFormat.format(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u4efb\u52a1\u6b63\u5728{0}\u4e2d\uff0c\u65e0\u6cd5\u8fdb\u884c{1}\u64cd\u4f5c\u3002", (String)"CalPayrollTaskHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]), currentOperation.getOperationName(), calPersonOperationEnum.getOperationName());
                    String errorMessage = ResManager.loadKDString((String)"\u7f16\u7801\u4e3a{0}\u7684\u6838\u7b97\u4efb\u52a1\uff1a\u6b63\u5728{1}\u4e2d\uff0c\u65e0\u6cd5{2}\u3002", (String)"CalPayrollTaskHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]);
                    calPayRollTask.setCalPayRollTaskValidatorErrorMsg(MessageFormat.format(errorMessage, calPayRollTask.getNumber(), currentOperation.getOperationName(), calPersonOperationEnum.getOperationName()));
                }
                LOGGER.info("operationMutexSuccess:{}", (Object)calPersonOperationEnum.getOperationKey());
            } else {
                LOGGER.error("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u8d85\u65f6");
            }
        }
        catch (Exception e) {
            LOGGER.error("checkCalPayRollTaskIsMutex  create DLock error", (Throwable)e);
        }
        return msg;
    }
}

