/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.calpayrolltask;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.swc.hsas.business.calpayrolltask.entity.AddPersonRequest;
import kd.swc.hsas.business.calpayrolltask.entity.AddPersonResult;
import kd.swc.hsas.business.calpayrolltask.entity.CreateAndCalResult;
import kd.swc.hsas.business.calpayrolltask.entity.CreateTaskAddPersonRequest;
import kd.swc.hsas.business.calpayrolltask.entity.CreateTaskAddPersonResult;
import kd.swc.hsas.business.calpayrolltask.entity.CreateTaskRequest;
import kd.swc.hsas.business.calpayrolltask.entity.CreateTaskResult;
import kd.swc.hsas.business.payrolltask.helper.PayRollTaskHelper;
import kd.swc.hsas.business.payrolltask.service.PayRollTaskService;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.coderule.CodeRuleHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.enums.CalPersonLockEnum;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang.ObjectUtils;

public class TaskService {
    private static final Log logger = LogFactory.getLog(TaskService.class);
    private Map<String, Map<String, DynamicObject>> paramDyObjMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, List<DynamicObject>> salaryFileMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, DynamicObject> groupMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, DynamicObject> sceneMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, DynamicObject> periodMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, List<Long>> groupSceneMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, List<Long>> scenePeriodMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, DynamicObject> periodTypeMap = Maps.newHashMapWithExpectedSize((int)16);
    private static final String SYSTEM_TYPE = "swc-hsas-business";
    private Map<String, Long> existTaskIdMap = Maps.newHashMapWithExpectedSize((int)16);

    public Map<String, String> checkCreateTaskAndPersonParams(List<CreateTaskAddPersonRequest> params) {
        HashMap<String, String> checkMsgMap = new HashMap<String, String>(params.size());
        ArrayList payrollGrpIds = Lists.newArrayListWithCapacity((int)10);
        ArrayList payrollSceneIds = Lists.newArrayListWithCapacity((int)10);
        ArrayList periodIds = Lists.newArrayListWithCapacity((int)10);
        this.assembleParamsIds(params, payrollGrpIds, payrollSceneIds, periodIds);
        this.queryParamDyObjs(null, payrollGrpIds, payrollSceneIds, periodIds);
        ArrayList<String> existUniqueCodeList = new ArrayList<String>(10);
        ArrayList<String> existTaskIdStrList = new ArrayList<String>(10);
        ArrayList<String> existTaskNameList = new ArrayList<String>(10);
        for (CreateTaskAddPersonRequest param : params) {
            PayRollTaskService payRollTaskService;
            DynamicObject attPeriodObj;
            String uniqueCode = param.getUnionId();
            if (existUniqueCodeList.contains(uniqueCode)) {
                checkMsgMap.put(uniqueCode, ResManager.loadKDString((String)"\u8be5\u7ec4\u552f\u4e00\u7f16\u7801\u53c2\u6570\u91cd\u590d\u3002", (String)"TaskService_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            existUniqueCodeList.add(uniqueCode);
            Long payrollGroupId = param.getPayrollGroupId();
            Long payrollSceneId = param.getPayrollSceneId();
            Long periodId = param.getPeriodId();
            String taskType = param.getTaskType();
            String taskParamStr = this.getTaskParamStr(payrollGroupId + "", payrollSceneId + "", periodId + "", taskType);
            if (existTaskIdStrList.contains(taskParamStr)) {
                checkMsgMap.put(uniqueCode, ResManager.loadKDString((String)"\u8be5\u7ec4\u53c2\u6570\u91cd\u590d\u3002", (String)"TaskService_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            existTaskIdStrList.add(taskParamStr);
            boolean emptyCheck = this.checkMustInputParam(param);
            if (emptyCheck) {
                checkMsgMap.put(uniqueCode, ResManager.loadKDString((String)"\u521b\u5efa\u4efb\u52a1\u5931\u8d25\uff0c\u5fc5\u586b\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"TaskService_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            String validCheckMsg = this.checkValid(param.getPayrollGroupId(), param.getPayrollSceneId(), param.getPeriodId());
            if (SWCStringUtils.isNotEmpty((String)validCheckMsg)) {
                checkMsgMap.put(uniqueCode, validCheckMsg);
                continue;
            }
            List<Long> sceneIdList = this.groupSceneMap.get(payrollGroupId);
            if (!sceneIdList.contains(param.getPayrollSceneId())) {
                checkMsgMap.put(uniqueCode, ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4\u4e0e\u85aa\u8d44\u6838\u7b97\u573a\u666f\u4e0d\u5339\u914d\u3002", (String)"TaskService_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            List<Long> periodIdList = this.scenePeriodMap.get(payrollSceneId);
            if (SWCListUtils.isEmpty(periodIdList) || !periodIdList.contains(periodId)) {
                checkMsgMap.put(uniqueCode, ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u573a\u666f\u4e0e\u85aa\u8d44\u671f\u95f4\u4e0d\u5339\u914d\u3002", (String)"TaskService_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            String taskTypeCheckMsg = this.checkTaskType(param, existTaskNameList);
            if (SWCStringUtils.isNotEmpty((String)taskTypeCheckMsg)) {
                checkMsgMap.put(uniqueCode, taskTypeCheckMsg);
                continue;
            }
            DynamicObject sceneDyObj = this.sceneMap.get(payrollSceneId);
            DynamicObject periodDyObj = this.periodMap.get(periodId);
            Date endDate = periodDyObj.getDate("enddate");
            DynamicObject[] calRuleVArr = PayRollTaskHelper.queryCalRuleVersionArr(sceneDyObj.getLong("calrule.id"), endDate);
            if (calRuleVArr.length == 0 || calRuleVArr[0].getLong("id") == 0L) {
                checkMsgMap.put(param.getUnionId(), ResManager.loadKDString((String)"\u4efb\u52a1\u521b\u5efa\u5931\u8d25\u3002\u85aa\u8d44\u6838\u7b97\u573a\u666f\u672a\u5173\u8054\u8ba1\u7b97\u89c4\u5219\u7248\u672c\u3002", (String)"TaskService_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            HashMap singleParamDyObjMap = Maps.newHashMapWithExpectedSize((int)16);
            DynamicObject sceneVObj = this.queryDyVObjById(payrollSceneId, "hsas_payrollscene", "id,callistview.id,periodtype.id,calrule.id,callistrule.id,aftercal, isenableatt, matchattperiod,islimitadd");
            if (sceneVObj.getBoolean("isenableatt") && SWCObjectUtils.isEmpty((Object)(attPeriodObj = (payRollTaskService = PayRollTaskService.createInstance()).getAttDateRange(sceneVObj, periodDyObj, sceneVObj.getDynamicObject("periodtype"))))) {
                checkMsgMap.put(param.getUnionId(), ResManager.loadKDString((String)"\u4efb\u52a1\u521b\u5efa\u5931\u8d25\u3002\u5f53\u524d\u85aa\u8d44\u671f\u95f4\u65e0\u53ef\u7528\u7684\u201c\u4e0a\u4e2a\u671f\u95f4\u201d\u6216\u201c\u4e0a\u4e0a\u4e2a\u671f\u95f4\u201d\u3002\u8003\u52e4\u8d77\u6b62\u65e5\u671f\u751f\u6210\u5931\u8d25\u3002", (String)"TaskService_24", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            DynamicObject grpVObj = this.queryDyVObjById(payrollGroupId, "hsas_payrollgrp", "id,name,org,country.id");
            DynamicObject ruleVObj = this.queryDyVObjById(calRuleVArr[0].getLong("boid"), "hsas_calrule", "id,name");
            long calListViewId = sceneVObj.getLong("callistview.id");
            DynamicObject calListViewVObj = this.queryDyObjById(calListViewId, "hsas_callistview", "id,name");
            singleParamDyObjMap.put("payrollgroup", this.groupMap.get(payrollGroupId));
            singleParamDyObjMap.put("payrollgroupv", grpVObj);
            singleParamDyObjMap.put("payrollscene", sceneDyObj);
            singleParamDyObjMap.put("payrollscenev", sceneVObj);
            singleParamDyObjMap.put("callistviewv", calListViewVObj);
            singleParamDyObjMap.put("period", periodDyObj);
            singleParamDyObjMap.put("calrulev", ruleVObj);
            this.paramDyObjMap.put(uniqueCode, singleParamDyObjMap);
        }
        return checkMsgMap;
    }

    public Map<String, String> checkCreateTaskParams(List<CreateTaskRequest> params) {
        HashMap<String, String> checkMsgMap = new HashMap<String, String>(params.size());
        ArrayList salaryFileIds = Lists.newArrayListWithCapacity((int)10);
        ArrayList payrollGrpIds = Lists.newArrayListWithCapacity((int)10);
        ArrayList payrollSceneIds = Lists.newArrayListWithCapacity((int)10);
        ArrayList periodIds = Lists.newArrayListWithCapacity((int)10);
        this.assembleParamsIdList(params, salaryFileIds, payrollGrpIds, payrollSceneIds, periodIds);
        this.queryParamDyObjs(salaryFileIds, payrollGrpIds, payrollSceneIds, periodIds);
        ArrayList<String> existUniqueCodeList = new ArrayList<String>(10);
        ArrayList<String> existTaskIdStrList = new ArrayList<String>(10);
        for (CreateTaskRequest param : params) {
            PayRollTaskService payRollTaskService;
            DynamicObject attPeriodObj;
            String uniqueCode = param.getUnionId();
            if (existUniqueCodeList.contains(uniqueCode)) {
                checkMsgMap.put(uniqueCode, ResManager.loadKDString((String)"\u8be5\u7ec4\u552f\u4e00\u7f16\u7801\u53c2\u6570\u91cd\u590d\u3002", (String)"TaskService_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            existUniqueCodeList.add(uniqueCode);
            Long payrollGroupId = param.getPayrollGroupId();
            Long payrollSceneId = param.getPayrollSceneId();
            Long periodId = param.getPeriodId();
            String taskType = param.getTaskType();
            String taskParamStr = this.getTaskParamStr(payrollGroupId + "", payrollSceneId + "", periodId + "", taskType);
            if (existTaskIdStrList.contains(taskParamStr)) {
                checkMsgMap.put(uniqueCode, ResManager.loadKDString((String)"\u8be5\u7ec4\u53c2\u6570\u91cd\u590d\u3002", (String)"TaskService_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            existTaskIdStrList.add(taskParamStr);
            boolean emptyCheck = this.checkMustInputParam(param);
            if (emptyCheck) {
                checkMsgMap.put(uniqueCode, ResManager.loadKDString((String)"\u521b\u5efa\u4efb\u52a1\u5931\u8d25\uff0c\u5fc5\u586b\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"TaskService_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            String validCheckMsg = this.checkValid(param.getPayrollGroupId(), param.getPayrollSceneId(), param.getPeriodId());
            if (SWCStringUtils.isNotEmpty((String)validCheckMsg)) {
                checkMsgMap.put(uniqueCode, validCheckMsg);
                continue;
            }
            List<Long> sceneIdList = this.groupSceneMap.get(payrollGroupId);
            if (!sceneIdList.contains(param.getPayrollSceneId())) {
                checkMsgMap.put(uniqueCode, ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4\u4e0e\u85aa\u8d44\u6838\u7b97\u573a\u666f\u4e0d\u5339\u914d\u3002", (String)"TaskService_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            List<Long> periodIdList = this.scenePeriodMap.get(payrollSceneId);
            if (SWCListUtils.isEmpty(periodIdList) || !periodIdList.contains(periodId)) {
                checkMsgMap.put(uniqueCode, ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u573a\u666f\u4e0e\u85aa\u8d44\u671f\u95f4\u4e0d\u5339\u914d\u3002", (String)"TaskService_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            String taskTypeCheckMsg = this.checkTaskType(param);
            if (SWCStringUtils.isNotEmpty((String)taskTypeCheckMsg)) {
                checkMsgMap.put(uniqueCode, taskTypeCheckMsg);
                continue;
            }
            DynamicObject sceneDyObj = this.sceneMap.get(payrollSceneId);
            DynamicObject periodDyObj = this.periodMap.get(periodId);
            Date endDate = periodDyObj.getDate("enddate");
            Date startDate = periodDyObj.getDate("startdate");
            DynamicObject[] calRuleVArr = PayRollTaskHelper.queryCalRuleVersionArr(sceneDyObj.getLong("calrule.id"), endDate);
            if (calRuleVArr.length == 0 || calRuleVArr[0].getLong("id") == 0L) {
                checkMsgMap.put(param.getUnionId(), ResManager.loadKDString((String)"\u4efb\u52a1\u521b\u5efa\u5931\u8d25\u3002\u85aa\u8d44\u6838\u7b97\u573a\u666f\u672a\u5173\u8054\u8ba1\u7b97\u89c4\u5219\u7248\u672c\u3002", (String)"TaskService_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            String salaryFileCheckMsg = this.checkSalaryFile(param, startDate, endDate);
            if (SWCStringUtils.isNotEmpty((String)salaryFileCheckMsg)) {
                checkMsgMap.put(uniqueCode, salaryFileCheckMsg);
                continue;
            }
            HashMap singleParamDyObjMap = Maps.newHashMapWithExpectedSize((int)16);
            DynamicObject sceneVObj = this.queryDyVObjById(payrollSceneId, "hsas_payrollscene", "id,callistview.id,periodtype.id,calrule.id,callistrule.id,aftercal, isenableatt, matchattperiod,islimitadd");
            if (sceneVObj.getBoolean("isenableatt") && SWCObjectUtils.isEmpty((Object)(attPeriodObj = (payRollTaskService = PayRollTaskService.createInstance()).getAttDateRange(sceneVObj, periodDyObj, sceneVObj.getDynamicObject("periodtype"))))) {
                checkMsgMap.put(param.getUnionId(), ResManager.loadKDString((String)"\u4efb\u52a1\u521b\u5efa\u5931\u8d25\u3002\u5f53\u524d\u85aa\u8d44\u671f\u95f4\u65e0\u53ef\u7528\u7684\u201c\u4e0a\u4e2a\u671f\u95f4\u201d\u6216\u201c\u4e0a\u4e0a\u4e2a\u671f\u95f4\u201d\u3002\u8003\u52e4\u8d77\u6b62\u65e5\u671f\u751f\u6210\u5931\u8d25\u3002", (String)"TaskService_24", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            DynamicObject grpVObj = this.queryDyVObjById(payrollGroupId, "hsas_payrollgrp", "id,name,org,country.id");
            DynamicObject ruleVObj = this.queryDyVObjById(calRuleVArr[0].getLong("boid"), "hsas_calrule", "id,name");
            long calListViewId = sceneVObj.getLong("callistview.id");
            DynamicObject calListViewVObj = this.queryDyObjById(calListViewId, "hsas_callistview", "id,name");
            singleParamDyObjMap.put("payrollgroup", this.groupMap.get(payrollGroupId));
            singleParamDyObjMap.put("payrollgroupv", grpVObj);
            singleParamDyObjMap.put("payrollscene", sceneDyObj);
            singleParamDyObjMap.put("payrollscenev", sceneVObj);
            singleParamDyObjMap.put("callistviewv", calListViewVObj);
            singleParamDyObjMap.put("period", periodDyObj);
            singleParamDyObjMap.put("calrulev", ruleVObj);
            this.paramDyObjMap.put(uniqueCode, singleParamDyObjMap);
        }
        return checkMsgMap;
    }

    private String checkSalaryFile(CreateTaskRequest param, Date startDate, Date endDate) {
        List<Long> salaryFileIdList = param.getSalaryFileIdList();
        Iterator<Long> iterator = salaryFileIdList.iterator();
        HashMap salaryFileMapTemp = new HashMap(this.salaryFileMap.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : this.salaryFileMap.entrySet()) {
            ArrayList tempList = new ArrayList(10);
            tempList.addAll(entry.getValue());
            salaryFileMapTemp.put(entry.getKey(), tempList);
        }
        while (iterator.hasNext()) {
            Long salaryFileId = iterator.next();
            List salaryFileObjs = (List)salaryFileMapTemp.get(salaryFileId);
            if (SWCListUtils.isEmpty((List)salaryFileObjs)) {
                iterator.remove();
                continue;
            }
            Iterator fileIterator = salaryFileObjs.iterator();
            while (fileIterator.hasNext()) {
                DynamicObject salaryFileObj = (DynamicObject)fileIterator.next();
                long tempGrpId = salaryFileObj.getLong("payrollgroup.id");
                Date bsed = salaryFileObj.getDate("bsed");
                Date bsled = salaryFileObj.getDate("bsled");
                if (param.getPayrollGroupId() - tempGrpId == 0L && !bsed.after(endDate) && !bsled.before(startDate)) continue;
                fileIterator.remove();
            }
            if (salaryFileObjs.size() != 0) continue;
            iterator.remove();
        }
        if (salaryFileIdList.size() == 0) {
            return ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u4e0e\u85aa\u8d44\u6838\u7b97\u7ec4\u4e0d\u5339\u914d\uff0c\u6216\u8005\u85aa\u8d44\u6863\u6848\u751f\u5931\u6548\u65e5\u671f\u4e0e\u671f\u95f4\u65e0\u4ea4\u96c6\u3002", (String)"TaskService_8", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        return "";
    }

    private String checkTaskType(CreateTaskAddPersonRequest param, List<String> existTaskNameList) {
        String taskName;
        String msg = "";
        String taskType = param.getTaskType();
        if (!SWCStringUtils.equals((String)"1", (String)taskType) && !SWCStringUtils.equals((String)"0", (String)taskType)) {
            return ResManager.loadKDString((String)"\u5165\u53c2\u5b57\u6bb5\u201c\u4efb\u52a1\u7c7b\u578b\u201d\u503c\u975e\u6cd5\u3002", (String)"TaskService_11", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        Boolean repeat = param.getRepeat();
        if (!repeat.booleanValue()) {
            String uniqueCode = param.getUnionId();
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
            QFilter filter = new QFilter("payrollgroup.id", "=", (Object)param.getPayrollGroupId());
            filter.and("payrollscene.id", "=", (Object)param.getPayrollSceneId());
            filter.and("period.id", "=", (Object)param.getPeriodId());
            filter.and("tasktype", "=", (Object)param.getTaskType());
            filter.and("hide", "!=", (Object)Boolean.TRUE);
            DynamicObjectCollection taskObjs = helper.queryOriginalCollection("id", new QFilter[]{filter});
            if (!SWCListUtils.isEmpty((List)taskObjs)) {
                this.existTaskIdMap.put(uniqueCode, ((DynamicObject)taskObjs.get(0)).getLong("id"));
                StringJoiner joiner = new StringJoiner(",");
                for (DynamicObject taskObj : taskObjs) {
                    joiner.add(taskObj.getLong("id") + "");
                }
                return ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u85aa\u8d44\u6838\u7b97\u7ec4\u3001\u85aa\u8d44\u6838\u7b97\u573a\u666f\u3001\u671f\u95f4\u3001\u4efb\u52a1\u7c7b\u578b\u7684\u6838\u7b97\u4efb\u52a1\uff0c\u4efb\u52a1ID\uff1a{0}\u3002", (String)"TaskService_15", (String)SYSTEM_TYPE, (Object[])new Object[]{joiner.toString()});
            }
        }
        if (SWCStringUtils.isEmpty((String)(taskName = param.getTaskName()))) {
            taskName = this.getCalPayRollTaskDefaultName(this.groupMap.get(param.getPayrollGroupId()).getString("name"), this.sceneMap.get(param.getPayrollSceneId()).getString("name"), this.periodMap.get(param.getPeriodId()).getString("name"), "");
        }
        this.checkAndSetTaskName(taskName, param, existTaskNameList, false);
        return msg;
    }

    private void checkAndSetTaskName(String taskName, CreateTaskAddPersonRequest param, List<String> existTaskNameList, boolean inner) {
        if (taskName.length() > 100) {
            taskName = taskName.substring(0, 100);
        }
        int index = 0;
        if (existTaskNameList.contains(taskName)) {
            Collections.sort(existTaskNameList);
            String tempTaskName = existTaskNameList.get(existTaskNameList.size() - 1);
            boolean isLastThreeDigits = tempTaskName.matches(".*\\d{3}$");
            String[] split = tempTaskName.split("-");
            index = isLastThreeDigits && split.length > 1 && split[split.length - 1].length() == 3 ? Integer.parseInt(split[split.length - 1]) + 1 : 1;
        } else {
            existTaskNameList.add(taskName);
            QFilter nameFilter = new QFilter("name", "like", (Object)(taskName + "%"));
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
            DynamicObjectCollection taskObjs = helper.queryOriginalCollection("id,name", new QFilter[]{nameFilter}, "name desc");
            if (SWCListUtils.isEmpty((List)taskObjs)) {
                param.setTaskName(taskName);
                return;
            }
            List taskNameList = taskObjs.stream().map(single -> single.getString("name")).collect(Collectors.toList());
            if (!taskNameList.contains(taskName)) {
                param.setTaskName(taskName);
                return;
            }
            String maxName = (String)taskNameList.get(0);
            boolean isLastThreeDigits = maxName.matches(".*\\d{3}$");
            String[] split = maxName.split("-");
            index = isLastThreeDigits && split.length > 1 && split[split.length - 1].length() == 3 ? Integer.parseInt(split[split.length - 1]) + 1 : 1;
        }
        String indexStr = String.format(Locale.ROOT, "%03d", index);
        if (taskName.length() > 96) {
            taskName = taskName.substring(0, 96);
        }
        taskName = inner ? taskName.substring(0, taskName.lastIndexOf(45)) + "-" + indexStr : taskName + "-" + indexStr;
        param.setTaskName(taskName);
        this.checkAndSetTaskName(taskName, param, existTaskNameList, true);
    }

    private String checkTaskType(CreateTaskRequest param) {
        QFilter nameFilter;
        boolean exists;
        String taskName;
        String msg = "";
        String taskType = param.getTaskType();
        if (!SWCStringUtils.equals((String)"1", (String)taskType) && !SWCStringUtils.equals((String)"0", (String)taskType)) {
            return ResManager.loadKDString((String)"\u5165\u53c2\u5b57\u6bb5\u201c\u4efb\u52a1\u7c7b\u578b\u201d\u503c\u975e\u6cd5\u3002", (String)"TaskService_11", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        String uniqueCode = param.getUnionId();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter filter = new QFilter("payrollgroup.id", "=", (Object)param.getPayrollGroupId());
        filter.and("payrollscene.id", "=", (Object)param.getPayrollSceneId());
        filter.and("period.id", "=", (Object)param.getPeriodId());
        DynamicObjectCollection taskObjs = helper.queryOriginalCollection("id,tasktype,hide", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)taskObjs)) {
            if (SWCStringUtils.equals((String)"1", (String)taskType)) {
                msg = ResManager.loadKDString((String)"\u4efb\u52a1\u521b\u5efa\u5931\u8d25\u3002\u65e0\u6cd5\u627e\u5230\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u3001\u201c\u85aa\u8d44\u6838\u7b97\u573a\u666f\u201d\u548c\u201c\u671f\u95f4\u201d\u5bf9\u5e94\u7684\u5e38\u89c4\u4efb\u52a1\u3002", (String)"TaskService_7", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            }
        } else {
            ArrayList<DynamicObject> existCommonObjs = new ArrayList<DynamicObject>(10);
            ArrayList<DynamicObject> existHideCommonObjs = new ArrayList<DynamicObject>(10);
            ArrayList<DynamicObject> existAddObjs = new ArrayList<DynamicObject>(10);
            Boolean paramHide = param.getHide();
            for (DynamicObject taskObj : taskObjs) {
                boolean hide = taskObj.getBoolean("hide");
                String type = taskObj.getString("tasktype");
                if (SWCStringUtils.equals((String)"0", (String)type)) {
                    existCommonObjs.add(taskObj);
                    if (Boolean.compare(hide, paramHide) != 0) continue;
                    existHideCommonObjs.add(taskObj);
                    continue;
                }
                if (!SWCStringUtils.equals((String)"1", (String)type) || !hide) continue;
                existAddObjs.add(taskObj);
            }
            List<Long> salaryFileIdList = param.getSalaryFileIdList();
            List existTaskIdList = existCommonObjs.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
            existTaskIdList.addAll(existHideCommonObjs.stream().map(single -> single.getLong("id")).collect(Collectors.toList()));
            helper = new SWCDataServiceHelper("hsas_calperson");
            QFilter personFilter = new QFilter("caltask.id", "in", existTaskIdList);
            personFilter.and("salaryfile.id", "in", salaryFileIdList);
            DynamicObjectCollection personObjs = helper.queryOriginalCollection("salaryfile.id,caltask.id,caltask.hide", new QFilter[]{personFilter});
            if (SWCStringUtils.equals((String)"0", (String)taskType)) {
                if (paramHide.booleanValue()) {
                    List existHideTasks;
                    if (!(SWCListUtils.isEmpty(existHideCommonObjs) || SWCListUtils.isEmpty((List)personObjs) || SWCListUtils.isEmpty(existHideTasks = personObjs.stream().filter(val -> val.getBoolean("caltask.hide")).collect(Collectors.toList())))) {
                        List existTaskIds = existHideTasks.stream().map(single -> single.getLong("caltask.id")).collect(Collectors.toList());
                        this.existTaskIdMap.put(uniqueCode, (Long)existTaskIds.get(0));
                    }
                } else if (!SWCListUtils.isEmpty(existCommonObjs) && !SWCListUtils.isEmpty((List)personObjs)) {
                    List existTaskIds = personObjs.stream().map(single -> single.getLong("caltask.id")).collect(Collectors.toList());
                    this.existTaskIdMap.put(uniqueCode, (Long)existTaskIds.get(0));
                }
            } else if (SWCListUtils.isEmpty(existCommonObjs)) {
                msg = ResManager.loadKDString((String)"\u4efb\u52a1\u521b\u5efa\u5931\u8d25\u3002\u65e0\u6cd5\u627e\u5230\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u3001\u201c\u85aa\u8d44\u6838\u7b97\u573a\u666f\u201d\u548c\u201c\u671f\u95f4\u201d\u5bf9\u5e94\u7684\u5e38\u89c4\u4efb\u52a1\u3002", (String)"TaskService_7", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            } else {
                if (!SWCListUtils.isEmpty(existAddObjs)) {
                    this.existTaskIdMap.put(uniqueCode, ((DynamicObject)existAddObjs.get(0)).getLong("id"));
                }
                if (SWCListUtils.isEmpty((List)personObjs)) {
                    DynamicObject sceneVObj = this.queryDyVObjById(param.getPayrollSceneId(), "hsas_payrollscene", "id,islimitadd");
                    boolean isLimitAdd = sceneVObj.getBoolean("islimitadd");
                    if (isLimitAdd) {
                        msg = ResManager.loadKDString((String)"\u4efb\u52a1\u521b\u5efa\u5931\u8d25\u3002\u6863\u6848\u4e0d\u5b58\u5728\u4e8e\u5e38\u89c4\u4efb\u52a1\u4e2d\u3002", (String)"TaskService_13", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                    }
                } else {
                    List<Long> validSalaryFielIdList = personObjs.stream().map(single -> single.getLong("salaryfile.id")).collect(Collectors.toList());
                    param.setSalaryFileIdList(validSalaryFielIdList);
                }
            }
        }
        if (SWCStringUtils.isNotEmpty((String)(taskName = param.getTaskName())) && (exists = (helper = new SWCDataServiceHelper("hsas_calpayrolltask")).isExists(new QFilter[]{nameFilter = new QFilter("name", "=", (Object)taskName)}))) {
            String defaultName = this.getCalPayRollTaskDefaultName(this.groupMap.get(param.getPayrollGroupId()), this.sceneMap.get(param.getPayrollSceneId()), this.periodMap.get(param.getPeriodId()));
            param.setTaskName(defaultName);
        }
        return msg;
    }

    private DynamicObject queryDyVObjById(Long objVid, String entity, String fields) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entity);
        QFilter filterId = new QFilter("boid", "=", (Object)objVid);
        QFilter validFilter = new QFilter("datastatus", "=", (Object)"1");
        BaseDataHisHelper.addHisVerFilter((QFilter)validFilter);
        return helper.queryOne(fields, new QFilter[]{filterId, validFilter});
    }

    private DynamicObject queryDyObjById(Long objId, String entity, String fields) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entity);
        QFilter filterId = new QFilter("id", "=", (Object)objId);
        return helper.queryOne(fields, new QFilter[]{filterId});
    }

    private String checkValid(Long payrollGroupId, Long payrollSceneId, Long periodId) {
        if (this.groupMap.get(payrollGroupId) == null) {
            return ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4\u4e0d\u4e3a\u5df2\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\u3002", (String)"TaskService_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        if (this.sceneMap.get(payrollSceneId) == null) {
            return ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u573a\u666f\u4e0d\u4e3a\u5df2\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\u3002", (String)"TaskService_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        DynamicObject periodObj = this.periodMap.get(periodId);
        if (periodObj == null) {
            return ResManager.loadKDString((String)"\u85aa\u8d44\u671f\u95f4\u4e0d\u4e3a\u5df2\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\u3002", (String)"TaskService_4", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        long periodTypeId = periodObj.getLong("periodtypeid");
        DynamicObject periodTypeObj = this.periodTypeMap.get(periodTypeId);
        if (periodTypeObj == null) {
            return ResManager.loadKDString((String)"\u85aa\u8d44\u671f\u95f4\u7c7b\u578b\u4e0d\u4e3a\u5df2\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\u3002", (String)"TaskService_14", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        return "";
    }

    private void queryParamDyObjs(List<Long> salaryFileIdList, List<Long> payrollGrpIdList, List<Long> payrollSceneIdList, List<Long> periodIdList) {
        QFilter periodFilter;
        DynamicObjectCollection periodDyObjs;
        QFilter sceneFilter;
        DynamicObject[] sceneDyObjs;
        QFilter grpFilter;
        DynamicObject[] grpDyObjs;
        QFilter validFilter = new QFilter("status", "=", (Object)"C");
        validFilter.and("enable", "=", (Object)"1");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        if (!SWCListUtils.isEmpty(salaryFileIdList)) {
            QFilter salaryFileFilter = new QFilter("boid", "in", salaryFileIdList);
            salaryFileFilter.and("paystatus", "=", (Object)"1");
            salaryFileFilter.and("salaryfile.status", "!=", (Object)"E");
            BaseDataHisHelper.addHisVerFilter((QFilter)salaryFileFilter);
            salaryFileFilter.and("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
            DynamicObjectCollection salaryFileObjs = helper.queryOriginalCollection("id,boid,payrollgroup.id,bsed,bsled", new QFilter[]{validFilter, salaryFileFilter});
            if (!SWCListUtils.isEmpty((List)salaryFileObjs)) {
                this.salaryFileMap = salaryFileObjs.stream().collect(Collectors.groupingBy(file -> file.getLong("boid")));
            }
        }
        if ((grpDyObjs = (helper = new SWCDataServiceHelper("hsas_payrollgrp")).query("id,name,bsed,bsled,payrollsceneentry.payrollscene", new QFilter[]{validFilter, grpFilter = new QFilter("id", "in", payrollGrpIdList)})) != null && grpDyObjs.length > 0) {
            this.groupMap = Arrays.stream(grpDyObjs).collect(Collectors.toMap(grp -> grp.getLong("id"), Function.identity()));
            for (DynamicObject grpDyObj : grpDyObjs) {
                long groupId = grpDyObj.getLong("id");
                DynamicObjectCollection groupSceneObjs = grpDyObj.getDynamicObjectCollection("payrollsceneentry");
                if (SWCListUtils.isEmpty((List)groupSceneObjs)) continue;
                List sceneIdList = groupSceneObjs.stream().map(single -> single.getLong("payrollscene.id")).collect(Collectors.toList());
                this.groupSceneMap.put(groupId, sceneIdList);
            }
        }
        if ((sceneDyObjs = (helper = new SWCDataServiceHelper("hsas_payrollscene")).query("id,name,calrule,periodtype.entryentity", new QFilter[]{validFilter, sceneFilter = new QFilter("id", "in", payrollSceneIdList)})) != null && sceneDyObjs.length > 0) {
            for (DynamicObject sceneDyObj : sceneDyObjs) {
                long sceneId = sceneDyObj.getLong("id");
                this.sceneMap.put(sceneId, sceneDyObj);
                DynamicObjectCollection periodObjs = sceneDyObj.getDynamicObjectCollection("periodtype.entryentity");
                if (SWCListUtils.isEmpty((List)periodObjs)) continue;
                this.scenePeriodMap.put(sceneId, periodObjs.stream().map(single -> single.getLong("id")).collect(Collectors.toList()));
            }
        }
        if (!SWCListUtils.isEmpty((List)(periodDyObjs = (helper = new SWCDataServiceHelper("hsbs_calperiod")).queryOriginalCollection("id,name,periodcalfrequency.id,startdate,enddate,ratedate,paydate,perioddate,periodtypeid", new QFilter[]{validFilter, periodFilter = new QFilter("id", "in", periodIdList)})))) {
            this.periodMap = periodDyObjs.stream().collect(Collectors.toMap(period -> period.getLong("id"), Function.identity()));
            helper = new SWCDataServiceHelper("hsbs_calperiodtype");
            Set peroidTypeIdSet = periodDyObjs.stream().map(single -> single.getLong("periodtypeid")).collect(Collectors.toSet());
            QFilter typeIdFilter = new QFilter("id", "in", peroidTypeIdSet);
            DynamicObjectCollection periodTypeDyObjs = helper.queryOriginalCollection("id,name", new QFilter[]{validFilter, typeIdFilter});
            if (!SWCListUtils.isEmpty((List)periodTypeDyObjs)) {
                this.periodTypeMap = periodTypeDyObjs.stream().collect(Collectors.toMap(single -> single.getLong("id"), Function.identity()));
            }
        }
    }

    private void assembleParamsIdList(List<CreateTaskRequest> params, List<Long> salaryFileIdList, List<Long> payrollGrpIdList, List<Long> payrollSceneIdList, List<Long> periodIdList) {
        for (CreateTaskRequest param : params) {
            List<Long> fileIdList = param.getSalaryFileIdList();
            Long grpId = param.getPayrollGroupId();
            Long sceneId = param.getPayrollSceneId();
            Long periodId = param.getPeriodId();
            if (!SWCListUtils.isEmpty(fileIdList)) {
                salaryFileIdList.addAll(fileIdList);
            }
            if (grpId != null && grpId > 0L) {
                payrollGrpIdList.add(grpId);
            }
            if (sceneId != null && sceneId > 0L) {
                payrollSceneIdList.add(sceneId);
            }
            if (periodId == null || periodId <= 0L) continue;
            periodIdList.add(periodId);
        }
    }

    private void assembleParamsIds(List<CreateTaskAddPersonRequest> params, List<Long> payrollGrpIdList, List<Long> payrollSceneIdList, List<Long> periodIdList) {
        for (CreateTaskAddPersonRequest param : params) {
            Long grpId = param.getPayrollGroupId();
            Long sceneId = param.getPayrollSceneId();
            Long periodId = param.getPeriodId();
            if (grpId != null && grpId > 0L) {
                payrollGrpIdList.add(grpId);
            }
            if (sceneId != null && sceneId > 0L) {
                payrollSceneIdList.add(sceneId);
            }
            if (periodId == null || periodId <= 0L) continue;
            periodIdList.add(periodId);
        }
    }

    private boolean checkMustInputParam(CreateTaskRequest param) {
        String taskType = param.getTaskType();
        String uniqueCode = param.getUnionId();
        Long payrollGroupId = (Long)ObjectUtils.defaultIfNull((Object)param.getPayrollGroupId(), (Object)0L);
        Long payrollSceneId = (Long)ObjectUtils.defaultIfNull((Object)param.getPayrollSceneId(), (Object)0L);
        List<Long> salaryFileIdList = param.getSalaryFileIdList();
        Long periodId = (Long)ObjectUtils.defaultIfNull((Object)param.getPeriodId(), (Object)0L);
        Boolean hide = param.getHide();
        return hide == null || SWCStringUtils.isEmpty((String)uniqueCode) || SWCStringUtils.isEmpty((String)taskType) || payrollGroupId == 0L || payrollSceneId == 0L || periodId == 0L || SWCListUtils.isEmpty(salaryFileIdList);
    }

    private boolean checkMustInputParam(CreateTaskAddPersonRequest param) {
        String taskType = param.getTaskType();
        String uniqueCode = param.getUnionId();
        Long payrollGroupId = (Long)ObjectUtils.defaultIfNull((Object)param.getPayrollGroupId(), (Object)0L);
        Long payrollSceneId = (Long)ObjectUtils.defaultIfNull((Object)param.getPayrollSceneId(), (Object)0L);
        Long periodId = (Long)ObjectUtils.defaultIfNull((Object)param.getPeriodId(), (Object)0L);
        Boolean autoAddPerson = param.getAutoAddPerson();
        Boolean repeat = param.getRepeat();
        return autoAddPerson == null || SWCStringUtils.isEmpty((String)uniqueCode) || SWCStringUtils.isEmpty((String)taskType) || payrollGroupId == 0L || payrollSceneId == 0L || periodId == 0L || repeat == null;
    }

    public List<CreateTaskResult> createTaskAndAddPerson(List<CreateTaskRequest> params) {
        ArrayList<CreateTaskResult> resultList = new ArrayList<CreateTaskResult>(params.size());
        logger.info("existTaskIdMap:{}", (Object)this.existTaskIdMap.toString());
        for (CreateTaskRequest param : params) {
            Long taskId;
            String uniqueCode = param.getUnionId();
            Map<String, DynamicObject> paramObjsMap = this.paramDyObjMap.get(uniqueCode);
            if (paramObjsMap == null || paramObjsMap.size() == 0) {
                logger.info("paramObjsMap is null,unionId:{},paramDyObjMap.keyset:{}", (Object)uniqueCode, this.paramDyObjMap.keySet());
                continue;
            }
            Long existTaskId = this.existTaskIdMap.get(uniqueCode);
            CreateTaskResult ret = new CreateTaskResult(uniqueCode);
            if (existTaskId != null) {
                taskId = existTaskId;
            } else {
                taskId = this.createTask(param.getUnionId(), param.getPayrollGroupId(), param.getPayrollSceneId(), param.getPeriodId(), param.getTaskType(), param.getTaskName(), param.getTracker(), Boolean.TRUE);
                logger.info("createTask finish taskId:{}", (Object)taskId);
            }
            ret.setTaskId(taskId);
            if (taskId == 0L) {
                ret.setPersonIdList(new ArrayList<Long>(0));
            } else {
                Boolean updateExistPerson = param.getUpdateExistPerson() == null ? Boolean.FALSE : param.getUpdateExistPerson();
                Boolean updatePerson = param.getHide() != false && updateExistPerson != false;
                List<Long> personIdList = this.addCalPerson(param.getSalaryFileIdList(), taskId, updatePerson);
                logger.info("addCalPerson personIdList:{}", personIdList);
                ret.setPersonIdList(personIdList);
                PayrollTaskHelper.updateCalpayrollTaskPersonCount((Long)taskId);
            }
            resultList.add(ret);
        }
        return resultList;
    }

    public List<CreateTaskAddPersonResult> createTaskAndAddPersonAuto(List<CreateTaskAddPersonRequest> params) {
        ArrayList<CreateTaskAddPersonResult> resultList = new ArrayList<CreateTaskAddPersonResult>(params.size());
        logger.info("existTaskIdMap:{}", (Object)this.existTaskIdMap.toString());
        for (CreateTaskAddPersonRequest param : params) {
            String unionId = param.getUnionId();
            Map<String, DynamicObject> paramObjsMap = this.paramDyObjMap.get(unionId);
            if (paramObjsMap == null || paramObjsMap.size() == 0) {
                logger.info("paramObjsMap is null,unionId:{},paramDyObjMap.keyset:{}", (Object)unionId, this.paramDyObjMap.keySet());
                continue;
            }
            Long existTaskId = this.existTaskIdMap.get(unionId);
            CreateTaskAddPersonResult ret = new CreateTaskAddPersonResult(unionId);
            Long taskId = param.getRepeat() != false || existTaskId == null ? this.createTask(param.getUnionId(), param.getPayrollGroupId(), param.getPayrollSceneId(), param.getPeriodId(), param.getTaskType(), param.getTaskName(), param.getTracker(), Boolean.FALSE) : existTaskId;
            logger.info("createTask finish taskId:{}", (Object)taskId);
            ret.setTaskId(taskId);
            if (taskId > 0L) {
                MultiLangEnumBridge opDescBridge;
                if (param.getAutoAddPerson().booleanValue()) {
                    PayRollTaskService payRollTaskService = PayRollTaskService.createInstance();
                    String errorCode = payRollTaskService.autoAddCalPerson(taskId);
                    if (SWCStringUtils.isNotEmpty((String)errorCode)) {
                        String desc = CalPersonLockEnum.getDesc((String)errorCode);
                        if (SWCStringUtils.isEmpty((String)desc)) {
                            ret.setMessage(errorCode);
                        }
                        ret.setMessage(desc);
                        opDescBridge = new MultiLangEnumBridge("\u4fdd\u5b58\u5931\u8d25\u3002", "TaskService_23", SYSTEM_TYPE);
                    } else {
                        opDescBridge = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f\u3002", "TaskService_22", SYSTEM_TYPE);
                        ret.setMessage(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4efb\u52a1\u521b\u5efa\u6210\u529f\uff0c\u6838\u7b97\u4eba\u5458\u6dfb\u52a0\u4e2d\uff0c\u4efb\u52a1ID\uff1a%s\u3002", (String)"TaskService_18", (String)SYSTEM_TYPE, (Object[])new Object[0]), taskId));
                    }
                } else {
                    opDescBridge = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f\u3002", "TaskService_22", SYSTEM_TYPE);
                    ret.setMessage(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4efb\u52a1\u521b\u5efa\u6210\u529f\uff0c\u4efb\u52a1ID\uff1a%s\u3002", (String)"TaskService_19", (String)SYSTEM_TYPE, (Object[])new Object[0]), taskId));
                }
                MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "TaskService_21", SYSTEM_TYPE);
                SWCOpLogServiceHelper.addOpLog((String)"/UHMBBGZQ65X", (String)"hsas_calpayrolltask", (String)"save", (MultiLangEnumBridge)opNameBridge, null, (MultiLangEnumBridge)opDescBridge, null);
            }
            resultList.add(ret);
        }
        return resultList;
    }

    public String getCalCount(Long payRollGroupId, Long payRollSceneId, Long payPeriodId, String taskType) {
        QFilter filter = new QFilter("payrollgroup", "=", (Object)payRollGroupId);
        filter.and("payrollscene", "=", (Object)payRollSceneId);
        filter.and("period", "=", (Object)payPeriodId);
        filter.and("tasktype", "=", (Object)taskType);
        filter.and("taskstatus", "!=", (Object)CalPayrollTaskStateEnum.DISUSED.getCode());
        int maxCount = PayRollTaskHelper.queryTotalCalCount(filter);
        return maxCount + 1 + "";
    }

    private List<Long> addCalPerson(List<Long> salaryFileIdList, Long taskId, Boolean updatePerson) {
        return (List)SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"ICalPersonService", (String)"addCalPersonForApi", (Object[])new Object[]{taskId, salaryFileIdList, updatePerson});
    }

    private Long createTask(String unionId, Long payrollGroupId, Long payrollSceneId, Long periodId, String taskType, String taskName, List<Long> taskTracer, Boolean hide) {
        SWCDataServiceHelper calTaskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_calpayrolltask");
        DynamicObject calTask = (DynamicObject)type.createInstance();
        Map<String, DynamicObject> paramObjsMap = this.paramDyObjMap.get(unionId);
        if (paramObjsMap == null || paramObjsMap.size() == 0) {
            logger.info("createTask.paramObjsMap is null ");
            return 0L;
        }
        Long payrollTaskId = this.fillCalTaskDy(unionId, payrollGroupId, payrollSceneId, periodId, taskType, taskName, taskTracer, calTask, hide);
        String number = CodeRuleHelper.getNumber((DynamicObject)calTask, null);
        calTask.set("number", (Object)number);
        try (TXHandle txHandle = TX.requiresNew();){
            calTaskHelper.saveOne(calTask);
        }
        return payrollTaskId;
    }

    private Long fillCalTaskDy(String unionId, Long payrollGroupId, Long payrollSceneId, Long periodId, String taskType, String taskName, List<Long> taskTracer, DynamicObject calTask, Boolean hide) {
        DynamicObject calPeriodObj;
        Map<String, DynamicObject> paramObjsMap = this.paramDyObjMap.get(unionId);
        DynamicObject payrollGroupInfo = paramObjsMap.get("payrollgroup");
        DynamicObject payrollGroupVInfo = paramObjsMap.get("payrollgroupv");
        DynamicObject payrollSceneInfo = paramObjsMap.get("payrollscene");
        DynamicObject payrollSceneVInfo = paramObjsMap.get("payrollscenev");
        DynamicObject calListViewVInfo = paramObjsMap.get("callistviewv");
        DynamicObject periodInfo = paramObjsMap.get("period");
        DynamicObject calRuleVInfo = paramObjsMap.get("calrulev");
        String calCount = this.getCalCount(payrollGroupId, payrollSceneId, periodId, taskType);
        calTask.set("calcount", (Object)calCount);
        long payrollTaskId = DB.genLongId((String)"hsas_calpayrolltask");
        calTask.set("masterid", (Object)payrollTaskId);
        calTask.set("id", (Object)payrollTaskId);
        if (SWCStringUtils.isNotEmpty((String)taskName)) {
            calTask.set("name", (Object)taskName);
        } else {
            calTask.set("name", (Object)this.getCalPayRollTaskDefaultName(payrollGroupInfo, payrollSceneInfo, periodInfo));
        }
        calTask.set("hide", (Object)hide);
        calTask.set("simplename", (Object)"");
        calTask.set("calpersoncount", (Object)0);
        calTask.set("handlestate", (Object)"0");
        calTask.set("viewdetailfield", (Object)"0");
        calTask.set("handlestate", (Object)"0");
        calTask.set("tasktype", (Object)taskType);
        calTask.set("payrollgroup", (Object)payrollGroupInfo.getLong("id"));
        calTask.set("country", (Object)payrollGroupVInfo.getLong("country.id"));
        calTask.set("payrollscene", (Object)payrollSceneInfo.getLong("id"));
        calTask.set("payrollscenev", (Object)payrollSceneVInfo);
        calTask.set("callistviewv", (Object)calListViewVInfo);
        calTask.set("period", (Object)periodInfo.getLong("id"));
        calTask.set("isautoaddperson", (Object)false);
        if (!SWCListUtils.isEmpty(taskTracer)) {
            this.copyMulBaseDataField(taskTracer, calTask);
        }
        if (SWCStringUtils.equals((String)"0", (String)taskType)) {
            calTask.set("islimitadd", (Object)Boolean.FALSE);
        } else if (SWCStringUtils.equals((String)"1", (String)taskType)) {
            calTask.set("islimitadd", (Object)payrollSceneVInfo.getBoolean("islimitadd"));
        }
        calTask.set("description", (Object)"");
        calTask.set("calrule", (Object)payrollSceneVInfo.getDynamicObject("calrule"));
        calTask.set("calrulev", (Object)calRuleVInfo);
        DynamicObject periodTypeInfo = payrollSceneVInfo.getDynamicObject("periodtype");
        calTask.set("periodtype", (Object)periodTypeInfo);
        calTask.set("calfrequency", (Object)periodInfo.getLong("periodcalfrequency.id"));
        calTask.set("STARTDATE", (Object)periodInfo.getDate("startdate"));
        calTask.set("ENDDATE", (Object)periodInfo.getDate("enddate"));
        calTask.set("exratedate", (Object)periodInfo.getDate("ratedate"));
        calTask.set("paydate", (Object)periodInfo.getDate("paydate"));
        Date payRollDate = periodInfo.getDate("perioddate");
        if (payRollDate != null) {
            int payrollYear = SWCDateTimeUtils.getYear((Date)payRollDate);
            int month = SWCDateTimeUtils.getMonth((Date)payRollDate);
            calTask.set("payrollyear", (Object)payrollYear);
            Calendar calendar = Calendar.getInstance();
            calendar.set(payrollYear, month - 1, 1);
            calTask.set("payrollmonth", (Object)month);
            calTask.set("payrolldate", (Object)payRollDate);
            if (payrollYear != 0) {
                calendar.set(1, payrollYear);
                calTask.set("payrollyearshow", (Object)calendar.getTime());
            }
        }
        calTask.set("payrollgroupv", (Object)payrollGroupVInfo);
        calTask.set("org", (Object)payrollGroupVInfo.getDynamicObject("org"));
        calTask.set("aftercal", (Object)payrollSceneVInfo.getString("aftercal"));
        calTask.set("tasknewmethod", (Object)"1");
        calTask.set("tasknewtplhis", null);
        calTask.set("taskstatus", (Object)CalPayrollTaskStateEnum.CREATE.getCode());
        calTask.set("createtime", (Object)new Date());
        calTask.set("creator", (Object)RequestContext.get().getCurrUserId());
        calTask.set("modifytime", null);
        calTask.set("modifier", (Object)0L);
        calTask.set("status", (Object)"A");
        calTask.set("disabler", (Object)0L);
        calTask.set("disabledate", null);
        calTask.set("enable", (Object)"1");
        calTask.set("index", (Object)0);
        calTask.set("issyspreset", (Object)"0");
        calTask.set("ishandleproration", (Object)PayRollTaskHelper.getProrationCalValue(payrollGroupVInfo.getLong("id"), payrollSceneInfo.getLong("id")));
        PayRollTaskService payRollTaskService = PayRollTaskService.createInstance();
        if (payrollSceneVInfo.getBoolean("isenableatt") && !SWCObjectUtils.isEmpty((Object)(calPeriodObj = payRollTaskService.getAttDateRange(payrollSceneVInfo, periodInfo, periodTypeInfo)))) {
            calTask.set("ATTSTARTDATE", (Object)calPeriodObj.getDate("STARTDATE"));
            calTask.set("ATTENDDATE", (Object)calPeriodObj.getDate("ENDDATE"));
        }
        calTask.set("ishandleproration", (Object)PayRollTaskHelper.getProrationCalValue(payrollGroupVInfo.getLong("id"), payrollSceneInfo.getLong("id")));
        return payrollTaskId;
    }

    private void copyMulBaseDataField(List<Long> tracker, DynamicObject calTask) {
        MulBasedataProp mulBasedataProp = (MulBasedataProp)calTask.getDataEntityType().getProperties().get((Object)"tracker");
        DynamicObjectType subEntityType = mulBasedataProp.getDynamicCollectionItemPropertyType();
        BasedataProp baseDataProp = (BasedataProp)subEntityType.getProperties().get((Object)"fbasedataid");
        DynamicObjectCollection rows = (DynamicObjectCollection)mulBasedataProp.getValue((Object)calTask);
        for (Long userId : tracker) {
            DynamicObject newRow = new DynamicObject(subEntityType);
            rows.add((Object)newRow);
            DynamicObject newBaseDataObj = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (DynamicObjectType)baseDataProp.getDynamicComplexPropertyType());
            baseDataProp.setValue((Object)newRow, (Object)newBaseDataObj);
        }
    }

    private String getCalPayRollTaskDefaultName(DynamicObject payrollGroupInfo, DynamicObject payrollSceneInfo, DynamicObject periodInfo) {
        StringJoiner taskName = new StringJoiner("-");
        taskName.add(payrollGroupInfo.getString("name"));
        taskName.add(payrollSceneInfo.getString("name"));
        taskName.add(periodInfo.getString("name"));
        return taskName.toString().length() > 255 ? taskName.toString().substring(0, 255) : taskName.toString();
    }

    private String getCalPayRollTaskDefaultName(String groupName, String sceneName, String periodName, String index) {
        StringJoiner taskName = new StringJoiner("-");
        taskName.add(groupName);
        taskName.add(sceneName);
        taskName.add(periodName);
        if (SWCStringUtils.isNotEmpty((String)index)) {
            taskName.add(index);
        }
        return taskName.toString().length() > 96 ? taskName.toString().substring(0, 96) : taskName.toString();
    }

    private String getTaskParamStr(String groupIdStr, String sceneIdStr, String periodIdStr, String taskType) {
        StringJoiner taskParamStr = new StringJoiner("-");
        taskParamStr.add(groupIdStr);
        taskParamStr.add(sceneIdStr);
        taskParamStr.add(periodIdStr);
        taskParamStr.add(taskType);
        return taskParamStr.toString();
    }

    public void delHideCommonTask(Set<Long> taskIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter filter = new QFilter("id", "in", taskIdSet);
        helper.deleteByFilter(new QFilter[]{filter});
        helper = new SWCDataServiceHelper("hsas_calperson");
        filter = new QFilter("caltask.id", "in", taskIdSet);
        helper.deleteByFilter(new QFilter[]{filter});
    }

    public boolean checkCreateParamType(Map<String, Object> param, List<CreateAndCalResult> resultList) {
        String unionId = String.valueOf(param.get("unionId"));
        Object updateExistPerson = param.get("updateExistPerson");
        Object hide = param.get("hide");
        List tracker = (List)param.get("tracker");
        if (updateExistPerson != null && !(updateExistPerson instanceof Boolean)) {
            CreateAndCalResult errResult = new CreateAndCalResult(unionId, null, ResManager.loadKDString((String)"\u5165\u53c2\u5b57\u6bb5\u201c\u66f4\u65b0\u5df2\u5b58\u5728\u7684\u540d\u5355\u201d\u503c\u975e\u6cd5\u3002", (String)"TaskService_32", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            resultList.add(errResult);
            return false;
        }
        if (!(hide instanceof Boolean)) {
            CreateAndCalResult errResult = new CreateAndCalResult(unionId, null, ResManager.loadKDString((String)"\u5165\u53c2\u5b57\u6bb5\u201c\u662f\u5426\u9690\u85cf\u201d\u503c\u975e\u6cd5\u3002", (String)"TaskService_33", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            resultList.add(errResult);
            return false;
        }
        if (!SWCListUtils.isEmpty((List)tracker)) {
            for (Object val : tracker) {
                if (val instanceof Long || val instanceof Integer) continue;
                CreateAndCalResult errResult = new CreateAndCalResult(unionId, null, ResManager.loadKDString((String)"\u8ddf\u8e2a\u4eba\u5b57\u6bb5\u503c\u7c7b\u578b\u9519\u8bef\u3002", (String)"TaskService_20", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                resultList.add(errResult);
                return false;
            }
        }
        return true;
    }

    public boolean checkParamType(Map<String, Object> param, List<CreateTaskAddPersonResult> resultList) {
        String unionId = String.valueOf(param.get("unionId"));
        Object autoAddPerson = param.get("autoAddPerson");
        Object repeat = param.get("repeat");
        List tracker = (List)param.get("tracker");
        if (!(autoAddPerson instanceof Boolean)) {
            CreateTaskAddPersonResult errResult = new CreateTaskAddPersonResult(unionId, null, ResManager.loadKDString((String)"\u81ea\u52a8\u6dfb\u52a0\u540d\u5355\u5b57\u6bb5\u503c\u7c7b\u578b\u9519\u8bef\u3002", (String)"TaskService_16", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            resultList.add(errResult);
            return false;
        }
        if (!(repeat instanceof Boolean)) {
            CreateTaskAddPersonResult errResult = new CreateTaskAddPersonResult(unionId, null, ResManager.loadKDString((String)"\u201c\u5141\u8bb8\u91cd\u590d\u521b\u5efa\u5b57\u6bb5\u503c\u201d\u7c7b\u578b\u9519\u8bef\u3002", (String)"TaskService_17", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            resultList.add(errResult);
            return false;
        }
        if (!SWCListUtils.isEmpty((List)tracker)) {
            for (Object val : tracker) {
                if (val instanceof Long || val instanceof Integer) continue;
                CreateTaskAddPersonResult errResult = new CreateTaskAddPersonResult(unionId, null, ResManager.loadKDString((String)"\u8ddf\u8e2a\u4eba\u5b57\u6bb5\u503c\u7c7b\u578b\u9519\u8bef\u3002", (String)"TaskService_20", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                resultList.add(errResult);
                return false;
            }
        }
        return true;
    }

    public Map<String, String> checkPersonParams(List<AddPersonRequest> paramList, Map<Long, Integer> taskPersonCountMap, Map<String, List<Long>> invalidFileIdMap) {
        HashMap<String, String> checkMsgMap = new HashMap<String, String>(16);
        HashSet<Long> taskIdSet = new HashSet<Long>(16);
        HashSet<Long> salaryFileIdSet = new HashSet<Long>(16);
        ArrayList<String> existUniqueIdList = new ArrayList<String>(10);
        this.assembleParamsIds(paramList, checkMsgMap, taskIdSet, salaryFileIdSet, existUniqueIdList);
        if (checkMsgMap.size() == paramList.size()) {
            return checkMsgMap;
        }
        List<String> invalidStatusList = Arrays.asList("4", "6");
        Map<Long, Map<String, Object>> validTaskIdMap = this.assembleValidTaskObjs(taskIdSet);
        Map<Long, List<Long>> validSalaryFileMap = this.assembleValidSalaryFileMap(salaryFileIdSet);
        for (AddPersonRequest param : paramList) {
            String unionId = param.getUnionId();
            Long taskId = param.getTaskId();
            Map<String, Object> taskMap = validTaskIdMap.get(taskId);
            if (taskMap == null) {
                checkMsgMap.put(unionId, ResManager.loadKDString((String)"\u5165\u53c2\u5b57\u6bb5\u6838\u7b97\u4efb\u52a1\u4e0d\u5b58\u5728\u3002", (String)"TaskService_31", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            String taskStatus = (String)taskMap.get("taskStatus");
            if (invalidStatusList.contains(taskStatus)) {
                checkMsgMap.put(unionId, ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\u72b6\u6001\u4e3a\u201c\u5ba1\u6279\u901a\u8fc7\u201d\u6216\u201c\u5df2\u5e9f\u5f03\u201d\uff0c\u4e0d\u53ef\u4ee5\u6dfb\u52a0\u6838\u7b97\u4eba\u5458\u3002", (String)"TaskService_26", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            List<Long> salaryFiles = param.getSalaryFiles();
            ArrayList<Long> fileList = new ArrayList<Long>(salaryFiles.size());
            if (SWCListUtils.isEmpty(salaryFiles)) {
                checkMsgMap.put(unionId, ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskService_28", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            List invalidFiles = invalidFileIdMap.computeIfAbsent(unionId, single -> new ArrayList(10));
            for (Long salaryFile : salaryFiles) {
                List<Long> personIdList = validSalaryFileMap.get(salaryFile);
                if (!SWCListUtils.isEmpty(personIdList)) {
                    fileList.addAll(personIdList);
                    continue;
                }
                invalidFiles.add(salaryFile);
            }
            taskPersonCountMap.put(taskId, salaryFiles.size());
            if (SWCListUtils.isEmpty(fileList)) {
                checkMsgMap.put(unionId, ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u201c\u5df2\u5ba1\u6838\u201d\u3002", (String)"TaskService_27", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            String taskType = (String)taskMap.get("taskType");
            Long payrollGroupId = (Long)taskMap.get("payrollGroupId");
            Long payrollSceneId = (Long)taskMap.get("payrollSceneId");
            Long periodId = (Long)taskMap.get("periodId");
            Boolean isLimitAdd = taskMap.get("isLimitAdd") == null ? Boolean.FALSE : (Boolean)taskMap.get("isLimitAdd");
            Set<Long> existFileSet = this.queryExistFile(taskId, payrollGroupId, payrollSceneId, periodId);
            if (SWCStringUtils.equals((String)"0", (String)taskType)) {
                salaryFiles.removeIf(single -> existFileSet.contains(single));
                if (SWCListUtils.isEmpty(salaryFiles)) {
                    checkMsgMap.put(unionId, ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u6838\u7b97\u540d\u5355\u6dfb\u52a0\u6761\u4ef6\u3002", (String)"TaskService_34", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    continue;
                }
            }
            if (!SWCStringUtils.equals((String)"1", (String)taskType) || !isLimitAdd.booleanValue()) continue;
            salaryFiles.removeIf(single -> !existFileSet.contains(single));
            if (!SWCListUtils.isEmpty(salaryFiles)) continue;
            checkMsgMap.put(unionId, ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u6838\u7b97\u540d\u5355\u6dfb\u52a0\u6761\u4ef6\u3002", (String)"TaskService_34", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        return checkMsgMap;
    }

    private Set<Long> queryExistFile(Long taskId, Long payrollGroupId, Long payrollSceneId, Long periodId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter filter = new QFilter("id", "!=", (Object)taskId);
        filter.and("payrollgroup.id", "=", (Object)payrollGroupId);
        filter.and("payrollscene.id", "=", (Object)payrollSceneId);
        filter.and("period.id", "=", (Object)periodId);
        filter.and("tasktype", "=", (Object)"0");
        DynamicObjectCollection taskObjs = helper.queryOriginalCollection("id", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)taskObjs)) {
            return new HashSet<Long>(0);
        }
        List existTaskIds = taskObjs.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
        helper = new SWCDataServiceHelper("hsas_calperson");
        filter = new QFilter("caltask.id", "in", existTaskIds);
        DynamicObjectCollection personObjs = helper.queryOriginalCollection("salaryfile.id", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)personObjs)) {
            return new HashSet<Long>(0);
        }
        return personObjs.stream().map(single -> single.getLong("salaryfile.id")).collect(Collectors.toSet());
    }

    private Map<Long, List<Long>> assembleValidSalaryFileMap(Set<Long> salaryFileIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter validFilter = new QFilter("status", "=", (Object)"C");
        validFilter.and("enable", "=", (Object)"1");
        validFilter.and("paystatus", "=", (Object)"1");
        validFilter.and("salaryfile.status", "!=", (Object)"E");
        QFilter filter = new QFilter("boid", "in", salaryFileIdSet);
        BaseDataHisHelper.addHisVerFilter((QFilter)filter);
        filter.and("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        DynamicObjectCollection salaryfileObjs = helper.queryOriginalCollection("id,boid", new QFilter[]{filter, validFilter});
        if (SWCListUtils.isEmpty((List)salaryfileObjs)) {
            return new HashMap<Long, List<Long>>(0);
        }
        Map<Long, List<Long>> validSalaryFileMap = salaryfileObjs.stream().collect(Collectors.groupingBy(single -> single.getLong("boid"), Collectors.mapping(obj -> obj.getLong("id"), Collectors.toList())));
        return validSalaryFileMap;
    }

    private Map<Long, Map<String, Object>> assembleValidTaskObjs(Set<Long> taskIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter validFilter = new QFilter("enable", "=", (Object)"1");
        QFilter filter = new QFilter("id", "in", taskIdSet);
        DynamicObjectCollection taskObjs = helper.queryOriginalCollection("id, taskstatus,tasktype, payrollgroup.id,payrollscene.id,period.id,islimitadd", new QFilter[]{filter, validFilter});
        if (SWCListUtils.isEmpty((List)taskObjs)) {
            return new HashMap<Long, Map<String, Object>>(0);
        }
        HashMap<Long, Map<String, Object>> taskMap = new HashMap<Long, Map<String, Object>>(16);
        for (DynamicObject taskObj : taskObjs) {
            Long taskId = taskObj.getLong("id");
            Map singleMap = taskMap.computeIfAbsent(taskId, single -> new HashMap(16));
            singleMap.put("taskStatus", taskObj.getString("taskstatus"));
            singleMap.put("taskType", taskObj.getString("tasktype"));
            singleMap.put("payrollGroupId", taskObj.getLong("payrollgroup.id"));
            singleMap.put("payrollSceneId", taskObj.getLong("payrollscene.id"));
            singleMap.put("periodId", taskObj.getLong("period.id"));
            singleMap.put("isLimitAdd", taskObj.getBoolean("islimitadd"));
        }
        return taskMap;
    }

    private void assembleParamsIds(List<AddPersonRequest> paramList, Map<String, String> checkMsgMap, Set<Long> taskIdSet, Set<Long> salaryfileIdSet, List<String> existUniqueIdList) {
        for (AddPersonRequest request : paramList) {
            String unionId = request.getUnionId();
            Long taskId = request.getTaskId();
            List<Long> salaryFiles = request.getSalaryFiles();
            if (SWCStringUtils.isEmpty((String)unionId) || taskId == null || SWCListUtils.isEmpty(salaryFiles)) {
                checkMsgMap.put(unionId, ResManager.loadKDString((String)"\u5fc5\u586b\u6570\u636e\u5b58\u5728\u7a7a\u503c\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"TaskService_25", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            if (existUniqueIdList.contains(unionId)) {
                checkMsgMap.put(unionId, ResManager.loadKDString((String)"\u8be5\u7ec4\u552f\u4e00\u7f16\u7801\u53c2\u6570\u91cd\u590d\u3002", (String)"TaskService_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            existUniqueIdList.add(unionId);
            taskIdSet.add(taskId);
            salaryfileIdSet.addAll(salaryFiles);
        }
    }

    public List<AddPersonResult> addPerson(List<AddPersonRequest> paramList, Map<Long, Integer> taskPersonCountMap, Map<String, List<Long>> invalidFileIdMap) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)paramList.size());
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u6dfb\u52a0\u6210\u529f\u3002", "TaskService_37", SYSTEM_TYPE);
        for (AddPersonRequest param : paramList) {
            Long taskId = param.getTaskId();
            String unionId = param.getUnionId();
            List<Long> salaryFiles = param.getSalaryFiles();
            ArrayList<Long> totalFilesList = new ArrayList<Long>(salaryFiles.size());
            totalFilesList.addAll(salaryFiles);
            List<Long> personIdList = new ArrayList(10);
            try {
                personIdList = (List)SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"ICalPersonService", (String)"addPerson", (Object[])new Object[]{taskId, salaryFiles});
            }
            catch (Exception exception) {
                logger.error("addPerson error", (Throwable)exception);
            }
            Integer total = taskPersonCountMap.get(taskId);
            String message = ResManager.loadKDString((String)"\u4eba\u5458\u6dfb\u52a0\u5b8c\u6210\uff0c\u5171{0}\u4eba\uff0c\u6dfb\u52a0\u6210\u529f{1}\u4eba\uff0c\u5931\u8d25{2}\u4eba\u3002", (String)"TaskService_29", (String)SYSTEM_TYPE, (Object[])new Object[]{total, personIdList.size(), total - personIdList.size()});
            List<Object> succSalaryFileList = new ArrayList(10);
            if (!SWCListUtils.isEmpty(personIdList)) {
                succSalaryFileList = this.assembleSuccFileId(personIdList);
            }
            totalFilesList.removeAll(succSalaryFileList);
            List<Long> invalidFiles = invalidFileIdMap.get(unionId);
            totalFilesList.addAll(invalidFiles);
            String msg = "";
            if (!SWCListUtils.isEmpty(totalFilesList)) {
                List salaryFileIdStrList = totalFilesList.stream().map(single -> single + "").collect(Collectors.toList());
                String fileIdStr = String.join((CharSequence)",", salaryFileIdStrList);
                msg = ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a\u201c\u4e0d\u7b26\u5408\u6838\u7b97\u540d\u5355\u6dfb\u52a0\u6761\u4ef6\u201d\uff0c\u5931\u8d25\u660e\u7ec6\uff1a{0}", (String)"TaskService_30", (String)SYSTEM_TYPE, (Object[])new Object[]{fileIdStr});
                opDescBridge = new MultiLangEnumBridge("\u6dfb\u52a0\u5931\u8d25\u3002", "TaskService_36", SYSTEM_TYPE);
            } else {
                opDescBridge = new MultiLangEnumBridge("\u6dfb\u52a0\u6210\u529f\u3002", "TaskService_37", SYSTEM_TYPE);
            }
            AddPersonResult result = new AddPersonResult(unionId, message + "\uff0c" + msg, personIdList);
            resultList.add(result);
        }
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u6dfb\u52a0\u4eba\u5458", "TaskService_35", SYSTEM_TYPE);
        SWCOpLogServiceHelper.addOpLog((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"save", (MultiLangEnumBridge)opNameBridge, null, (MultiLangEnumBridge)opDescBridge, null);
        return resultList;
    }

    private List<Long> assembleSuccFileId(List<Long> personIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", personIdList);
        DynamicObjectCollection personObjs = helper.queryOriginalCollection("id,salaryfile.id", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)personObjs)) {
            return new ArrayList<Long>(0);
        }
        return personObjs.stream().map(single -> single.getLong("salaryfile.id")).collect(Collectors.toList());
    }
}

