/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.calplatform;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.business.calresulttpl.helper.CalResultTplAddItemServiceHelper;
import kd.swc.hsas.business.salarydeatilresult.helper.SalaryDetailResultListHelper;
import kd.swc.hsas.common.enums.SalaryChartEnum;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.jetbrains.annotations.Nullable;

public class CalPlatformHelper {
    private static final Log logger = LogFactory.getLog(CalPlatformHelper.class);
    public static final String KEY_DEFALTTEMPATE = "1";
    public static final String KEY_SINGLECHECK = "hsas_singlecheckcard";

    public static ListShowParameter beforeCalRuleSelect(BeforeF7SelectEvent beforeF7SelectEvent, DynamicObject payrollgroup, IFormView view) {
        Set<Long> entryIds = CalPlatformHelper.getPayrollSceneIds(payrollgroup, view);
        if (entryIds == null) {
            return null;
        }
        ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        QFilter entryFilter = new QFilter("id", "in", entryIds);
        beforeF7SelectEvent.addCustomQFilter(entryFilter);
        return param;
    }

    @Nullable
    public static Set<Long> getPayrollSceneIds(DynamicObject payrollgroup, IFormView view) {
        if (payrollgroup == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u7684\u503c\u3002", (String)"CalPlatformHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]));
            return null;
        }
        SWCDataServiceHelper groupHisHelper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter verFilter = BaseDataHisHelper.getHisVerFilter();
        DynamicObject[] groupHisArr = groupHisHelper.query("payrollsceneentry,payrollsceneentry.payrollscene", new QFilter[]{new QFilter("boid", "=", (Object)payrollgroup.getLong("id")), verFilter});
        HashSet<Long> entryIds = new HashSet<Long>(16);
        for (DynamicObject group : groupHisArr) {
            DynamicObjectCollection payrollsceneentry = group.getDynamicObjectCollection("payrollsceneentry");
            for (DynamicObject entry : payrollsceneentry) {
                entryIds.add(entry.getLong("payrollscene.id"));
            }
        }
        return entryIds;
    }

    public static FormShowParameter getEmptyPage(String message, String target) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(target);
        showParameter.setFormId("hsas_calplatformemptypage");
        showParameter.setCustomParam("message", (Object)message);
        return showParameter;
    }

    public static void setInitChartConfig(IDataModel model, String entryName) {
        for (SalaryChartEnum value : SalaryChartEnum.values()) {
            int rowIndex = model.createNewEntryRow(entryName);
            model.setValue("itemname", (Object)value.getCode(), rowIndex);
            model.setValue("itemshowname", (Object)value.getName(), rowIndex);
            model.setValue("isshow", (Object)Boolean.TRUE, rowIndex);
            model.setValue("charttype", (Object)(SWCStringUtils.equals((String)value.getType(), (String)"sum") ? "bar" : "line"), rowIndex);
        }
    }

    public static void setSystemFieldValue(DynamicObject dynamicObject, boolean isUpdate) {
        long userId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        if (!isUpdate) {
            dynamicObject.set("creator", (Object)userId);
            dynamicObject.set("createtime", (Object)now);
        }
        dynamicObject.set("modifier", (Object)userId);
        dynamicObject.set("modifytime", (Object)now);
    }

    public static void dealCalReslutTpl(Long payRollGroupId, Long calTaskId, List<Long> calPersonList, IFormView view, CloseCallBack callBack) {
        QFilter filter = new QFilter("payrollgroups.fbasedataid_id", "=", (Object)payRollGroupId);
        filter.and("bsed", "<=", (Object)SWCDateTimeUtils.getDateWithoutMinTs((Date)new Date()));
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)KEY_DEFALTTEMPATE);
        SWCDataServiceHelper resultTplHelper = new SWCDataServiceHelper("hsas_calresulttpl");
        DynamicObject[] tpls = resultTplHelper.query("id,isdefault", new QFilter[]{filter});
        if (tpls == null || tpls.length == 0) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u85aa\u8d44\u6838\u7b97\u7ec4\u672a\u8bbe\u7f6e\u85aa\u8d44\u660e\u7ec6\u7ed3\u679c\u6a21\u677f\u3002", (String)"HSASCalResultDetailPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            view.showTipNotification(msg);
            return;
        }
        if (tpls.length == 1) {
            Long tplId = tpls[0].getLong("id");
            if (KEY_SINGLECHECK.equals(view.getEntityId())) {
                ListShowParameter formShowParameter = (ListShowParameter)SalaryDetailResultListHelper.openCalResultDetailPage(tplId, calTaskId, view.getPageId());
                CalPlatformHelper.showSalaryResultPage(formShowParameter, calPersonList, view);
            } else {
                HashMap<String, Object> params = new HashMap<String, Object>(16);
                params.put("personList", calPersonList);
                params.put("taskid", calTaskId);
                params.put("tplid", tplId);
                view.returnDataToParent(params);
                view.close();
            }
        } else {
            Optional<DynamicObject> optDy = Arrays.stream(tpls).filter(tpl -> KEY_DEFALTTEMPATE.equals(tpl.getString("isdefault"))).findFirst();
            if (!optDy.isPresent()) {
                ListShowParameter listShowParameter = CalPlatformHelper.openCalResultTplPage(payRollGroupId);
                if (listShowParameter == null) {
                    String msg = ResManager.loadKDString((String)"\u5f53\u524d\u85aa\u8d44\u6838\u7b97\u7ec4\u672a\u8bbe\u7f6e\u85aa\u8d44\u660e\u7ec6\u7ed3\u679c\u6a21\u677f\u3002", (String)"HSASCalResultDetailPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    view.showTipNotification(msg);
                    return;
                }
                view.getPageCache().put("tplpageid", CalPlatformHelper.setParamCache(calPersonList, calTaskId));
                listShowParameter.setCloseCallBack(callBack);
                view.showForm((FormShowParameter)listShowParameter);
            } else {
                Long tplId = optDy.get().getLong("id");
                if (KEY_SINGLECHECK.equals(view.getEntityId())) {
                    ListShowParameter formShowParameter = (ListShowParameter)SalaryDetailResultListHelper.openCalResultDetailPage(tplId, calTaskId, view.getPageId());
                    CalPlatformHelper.showSalaryResultPage(formShowParameter, calPersonList, view);
                } else {
                    HashMap<String, Object> params = new HashMap<String, Object>(16);
                    params.put("personList", calPersonList);
                    params.put("taskid", calTaskId);
                    params.put("tplid", tplId);
                    view.returnDataToParent(params);
                    view.close();
                }
            }
        }
    }

    public static ListShowParameter openCalResultTplPage(Long payRollGroupId) {
        CalResultTplAddItemServiceHelper helper = new CalResultTplAddItemServiceHelper();
        DynamicObjectCollection calResultTpls = helper.getCalResultTpl(payRollGroupId);
        if (calResultTpls == null || calResultTpls.size() == 0) {
            return null;
        }
        Set calResultTplIds = calResultTpls.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        QFilter filter = new QFilter("payrollgroups.fbasedataid_id", "=", (Object)payRollGroupId);
        filter.and("bsed", "<=", (Object)SWCDateTimeUtils.getDateWithoutMinTs((Date)new Date()));
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)KEY_DEFALTTEMPATE);
        filter.and("id", "in", calResultTplIds);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(filter);
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("hsas_calresulttpl");
        showParameter.setFormId("bos_listf7");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u6a21\u677f", (String)"HSASCalResultDetailPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setListFilterParameter(new ListFilterParameter(filters, null));
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(false);
        showParameter.setShowTitle(false);
        return showParameter;
    }

    public static String setParamCache(List<Long> personList, Long calTaskId) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("personList", personList);
        params.put("taskid", calTaskId);
        String result = JSON.toJSONString(params);
        return result;
    }

    public static void showSalaryResultPage(ListShowParameter formShowParameter, List<Long> calPersonList, IFormView view) {
        if (formShowParameter == null) {
            return;
        }
        if (calPersonList != null && calPersonList.size() > 0) {
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            filterList.add(new QFilter("id", "in", calPersonList));
            ListFilterParameter listFilter = formShowParameter.getListFilterParameter();
            listFilter.setQFilters(filterList);
            view.showForm((FormShowParameter)formShowParameter);
        }
    }

    public static void addGroupOrSceneAuthFilter(List<QFilter> filterList, String type, boolean isGroup) {
        HasPermOrgResult permOrgs;
        boolean isHasPerm;
        String entityNum = "";
        String propKey = "payrollscene";
        if (SWCStringUtils.equals((String)KEY_DEFALTTEMPATE, (String)type)) {
            entityNum = "hsas_payschedule";
            if (isGroup) {
                propKey = "payrollgrp";
            }
        } else {
            entityNum = "hsas_calpayrolltask";
            if (isGroup) {
                propKey = "payrollgroup";
            }
        }
        if (!(isHasPerm = SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)entityNum, (String)"47150e89000000ac"))) {
            filterList.add(new QFilter(KEY_DEFALTTEMPATE, "!=", (Object)1));
            return;
        }
        QFilter dataRuleForBdProp = SWCPermissionServiceHelper.getDataRuleForBdProp((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)entityNum, (String)propKey, (String)"47150e89000000ac");
        if (dataRuleForBdProp != null) {
            filterList.add(dataRuleForBdProp);
        }
        if (!(permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)entityNum, (String)"47150e89000000ac")).hasAllOrgPerm()) {
            filterList.add(new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs()));
        }
        logger.info("filterList:{}", filterList);
    }
}

