/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.calresulttpl.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hsas.common.events.calperson.CalResultTplQueryParamEvent;
import kd.sdk.swc.hsas.formplugin.extpoint.salarydetailresult.ICalResultTplQueryExtPlugin;
import kd.swc.hsas.business.calresulttpl.CalResultTplQueryExtPlugin;
import kd.swc.hsas.common.enums.AttBizItemtypeEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class CalResultTplAddItemServiceHelper {
    public static final String ATTBIZITEM = "1";

    public Map<String, Map<String, Map<String, Object>>> getAllItemData(long orgId, boolean needAccItem) {
        HashMap<String, Map<String, Map<String, Object>>> dataMap = new HashMap<String, Map<String, Map<String, Object>>>(4);
        Map<String, Map<String, Object>> ftItemMap = this.getFTItemList(null);
        Map<String, Map<String, Object>> bsItemMap = this.getBSItemList(null, orgId);
        Map<String, Map<String, Object>> bsAttItemMap = CalResultTplAddItemServiceHelper.getAttBSItemList(null, orgId);
        Map<String, Map<String, Object>> spItemMap = this.getSPItemList(null, orgId);
        Map<String, Map<String, Object>> salaryItemMap = this.getSalaryItemList(false, null, null, orgId);
        Map<String, Map<String, Object>> accItemMap = needAccItem ? this.getAccDataMap(null, orgId) : null;
        dataMap.put("salaryitemkey", salaryItemMap);
        dataMap.put("ftitemkey", ftItemMap);
        dataMap.put("bsitemkey", bsItemMap);
        dataMap.put("bsattitemkey", bsAttItemMap);
        dataMap.put("spitemkey", spItemMap);
        if (accItemMap != null) {
            dataMap.put("ackey", accItemMap);
        }
        return dataMap;
    }

    private Map<String, Map<String, Object>> getAccDataMap(QFilter countryQFilter, long orgId) {
        QFilter useOrgFilter;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accumulator");
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)ATTBIZITEM));
        if (null != countryQFilter) {
            filter.and(countryQFilter);
        }
        if ((useOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsas_accumulator", (Long)orgId)) != null) {
            filter.and(useOrgFilter);
        }
        LinkedHashMap<String, Map<String, Object>> accMap = new LinkedHashMap<String, Map<String, Object>>(16);
        String fields = "id,number,name,datatype.showtype,uniquecode";
        DynamicObjectCollection accDataList = helper.queryOriginalCollection(fields, new QFilter[]{filter}, "number asc");
        HashMap<String, Object> tempMap = null;
        for (DynamicObject acc : accDataList) {
            tempMap = new HashMap<String, Object>(5);
            tempMap.put("id", acc.getLong("id"));
            tempMap.put("name", acc.getString("name"));
            tempMap.put("number", acc.getString("number"));
            tempMap.put("datatype", acc.getString("datatype.showtype"));
            tempMap.put("uniquecode", acc.getString("uniquecode"));
            accMap.put(acc.getString("name"), tempMap);
        }
        return accMap;
    }

    private Map<String, Map<String, Object>> getSalaryItemList(boolean isProrationFormula, QFilter countryQFilter, QFilter calBlockQFilter, long orgId) {
        LinkedHashMap<String, Map<String, Object>> salaryItemMap = new LinkedHashMap<String, Map<String, Object>>(16);
        if (isProrationFormula) {
            return salaryItemMap;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (null != countryQFilter) {
            qFilters.add(countryQFilter);
        }
        if (null != calBlockQFilter) {
            qFilters.add(calBlockQFilter);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitem");
        String queryField = "id,number,name,salaryitemtype.number,salaryitemtype.name,uniquecode,datatype.showtype";
        QFilter filter = new QFilter("enable", "=", (Object)ATTBIZITEM);
        filter.and(new QFilter("status", "=", (Object)"C"));
        QFilter useOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_salaryitem", (Long)orgId);
        qFilters.add(useOrgFilter);
        qFilters.add(filter);
        QFilter[] newFilters = new QFilter[qFilters.size()];
        newFilters = qFilters.toArray(newFilters);
        String orderBy = "salaryitemtype.index asc,salaryitemtype.number asc,index asc,number asc";
        DynamicObjectCollection result = helper.queryOriginalCollection(queryField, newFilters, orderBy);
        HashMap<String, Object> tempMap = null;
        for (DynamicObject item : result) {
            tempMap = new HashMap<String, Object>(6);
            tempMap.put("id", item.getLong("id"));
            tempMap.put("number", item.getString("number"));
            tempMap.put("name", item.getString("name"));
            tempMap.put("salaryitemtype_number", item.getString("salaryitemtype.number"));
            tempMap.put("salaryitemtype_name", item.getString("salaryitemtype.name"));
            tempMap.put("uniquecode", item.getString("uniquecode"));
            tempMap.put("showtype", item.getString("datatype.showtype"));
            salaryItemMap.put(item.getString("name"), tempMap);
        }
        return salaryItemMap;
    }

    private Map<String, Map<String, Object>> getFTItemList(QFilter countryQFilter) {
        LinkedHashMap<String, Map<String, Object>> ftItemMap = new LinkedHashMap<String, Map<String, Object>>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchitem");
        String queryField = "id,number,name,datatype,fetchitemgroupid.name,fetchitemgroupid.number,uniquecode";
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)ATTBIZITEM));
        if (null != countryQFilter) {
            filter.and(countryQFilter);
        }
        String orderBy = "index asc";
        DynamicObjectCollection result = helper.queryOriginalCollection(queryField, new QFilter[]{filter}, orderBy);
        HashMap<String, Object> tempMap = null;
        for (DynamicObject item : result) {
            tempMap = new HashMap<String, Object>(5);
            tempMap.put("id", item.getLong("id"));
            tempMap.put("number", item.getString("number"));
            tempMap.put("name", item.getString("name"));
            tempMap.put("datatype", item.getLong("datatype"));
            tempMap.put("ftItemGroupNumber", item.getString("fetchitemgroupid.number"));
            tempMap.put("ftItemGroupName", item.getString("fetchitemgroupid.name"));
            tempMap.put("uniquecode", item.getString("uniquecode"));
            ftItemMap.put(item.getString("name"), tempMap);
        }
        return ftItemMap;
    }

    private Map<String, Map<String, Object>> getBSItemList(QFilter countryQFilter, long orgId) {
        LinkedHashMap<String, Map<String, Object>> bsItemMap = new LinkedHashMap<String, Map<String, Object>>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitem");
        String queryField = "id,number,name,bizitemcategory.number,bizitemcategory.name,uniquecode,datatype.showtype,classification";
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)ATTBIZITEM));
        filter.and(new QFilter("classification", "!=", (Object)ATTBIZITEM));
        if (null != countryQFilter) {
            filter.and(countryQFilter);
        }
        QFilter useOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_bizitem", (Long)orgId);
        filter.and(useOrgFilter);
        String orderBy = "index asc";
        DynamicObjectCollection result = helper.queryOriginalCollection(queryField, new QFilter[]{filter}, orderBy);
        HashMap<String, Object> tempMap = null;
        for (DynamicObject item : result) {
            tempMap = new HashMap<String, Object>(8);
            tempMap.put("id", item.getLong("id"));
            tempMap.put("number", item.getString("number"));
            tempMap.put("name", item.getString("name"));
            tempMap.put("bizTypeNumber", item.getString("bizitemcategory.number"));
            tempMap.put("bizTypeName", item.getString("bizitemcategory.name"));
            tempMap.put("datatype", item.getString("datatype.showtype"));
            tempMap.put("uniquecode", item.getString("uniquecode"));
            bsItemMap.put(item.getString("name"), tempMap);
        }
        return bsItemMap;
    }

    private static Map<String, Map<String, Object>> getAttBSItemList(QFilter countryQFilter, long orgId) {
        QFilter useOrgQFilter;
        LinkedHashMap<String, Map<String, Object>> bsItemMap = new LinkedHashMap<String, Map<String, Object>>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_attbizitem");
        String queryField = "id,number,name,uniquecode,datatype.showtype,isextprop,bizitemprop,classification,attitemtype";
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)ATTBIZITEM));
        filter.and(new QFilter("classification", "=", (Object)ATTBIZITEM));
        if (orgId > 0L && null != (useOrgQFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_attbizitem", (Long)orgId))) {
            filter.and(useOrgQFilter);
        }
        if (null != countryQFilter) {
            filter.and(countryQFilter);
        }
        String orderBy = "index asc";
        DynamicObject[] result = helper.query(queryField, new QFilter[]{filter}, orderBy);
        Object tempPropList = null;
        HashMap<String, Object> tempMap = null;
        for (DynamicObject item : result) {
            tempMap = new HashMap<String, Object>(9);
            tempMap.put("id", item.getLong("id"));
            tempMap.put("number", item.getString("number"));
            tempMap.put("name", item.getString("name"));
            tempMap.put("bizTypeNumber", item.getString("attitemtype"));
            tempMap.put("bizTypeName", AttBizItemtypeEnum.getDesc((String)item.getString("attitemtype")));
            tempMap.put("datatype", item.getString("datatype.showtype"));
            tempMap.put("uniquecode", item.getString("uniquecode"));
            tempMap.put("classification", item.getString("classification"));
            bsItemMap.put(item.getString("name"), tempMap);
        }
        return bsItemMap;
    }

    private Map<String, Map<String, Object>> getSPItemList(QFilter countryQFilter, long orgId) {
        LinkedHashMap<String, Map<String, Object>> spItemMap = new LinkedHashMap<String, Map<String, Object>>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_supportitem");
        String queryField = "id,number,name,uniquecode,datatype.showtype";
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)ATTBIZITEM));
        if (null != countryQFilter) {
            filter.and(countryQFilter);
        }
        QFilter useOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_supportitem", (Long)orgId);
        filter.and(useOrgFilter);
        String orderBy = "index asc";
        DynamicObjectCollection result = helper.queryOriginalCollection(queryField, new QFilter[]{filter}, orderBy);
        HashMap<String, Object> tempMap = null;
        for (DynamicObject item : result) {
            tempMap = new HashMap<String, Object>(5);
            tempMap.put("id", item.getLong("id"));
            tempMap.put("number", item.getString("number"));
            tempMap.put("name", item.getString("name"));
            tempMap.put("datatype", item.getString("datatype.showtype"));
            tempMap.put("uniquecode", item.getString("uniquecode"));
            spItemMap.put(item.getString("name"), tempMap);
        }
        return spItemMap;
    }

    public DynamicObjectCollection getCalResultTpl(Long payRollGroupId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calresulttpl");
        String queryField = "id,number,name,isdefault";
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)ATTBIZITEM));
        filter.and("payrollgroups.fbasedataid_id", "=", (Object)payRollGroupId);
        filter.and("bsed", "<=", (Object)SWCDateTimeUtils.getDateWithoutMinTs((Date)new Date()));
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        CalResultTplQueryParamEvent paramEvent = new CalResultTplQueryParamEvent(filterList);
        CalResultTplQueryExtPlugin calResultTplQueryExtPlugin = new CalResultTplQueryExtPlugin();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)calResultTplQueryExtPlugin, ICalResultTplQueryExtPlugin.class, (String)"kd.sdk.swc.hsas.formplugin.extpoint.salarydetailresult.ICalResultTplQueryExtPlugin#addExtFilter", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.addExtFilter(paramEvent);
            return null;
        });
        List filters = paramEvent.getFilters();
        if (filters != null && filters.size() > 0) {
            filterList.addAll(filters);
        }
        filterList.add(filter);
        DynamicObjectCollection result = helper.queryOriginalCollection(queryField, filterList.toArray(new QFilter[0]));
        return result;
    }
}

