/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cloudcolla;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.cloudcolla.StandardCloudCollaTaskExecuteHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.CollaActContext;
import kd.swc.hsbp.common.vo.CollaRuleExecuteContext;

@Deprecated
public class HSASCloudCollaHelper {
    private static final Log LOGGER = LogFactory.getLog(HSASCloudCollaHelper.class);
    private static final String CLOUD_SWC = "/U+QDTL900//";
    private static final String CLOUD_SIT = "17+ZA9TOOB66";

    private HSASCloudCollaHelper() {
    }

    public static final HSASCloudCollaHelper getInstance() {
        return Load.INSTANCE;
    }

    public void setEntryIsSysPreset(ChangeData changeData, IFormView view, String presetFieldKey) {
        Object object = changeData.getNewValue();
        if (object instanceof DynamicObject) {
            int entryIndex = changeData.getRowIndex();
            DynamicObject dyobj = (DynamicObject)object;
            view.getModel().setValue(presetFieldKey, (Object)(dyobj.getBoolean("issyspreset") ? "1" : "0"), entryIndex);
        }
    }

    public void initEntryIsSysPreset(IFormView view, String fieldKey, String presetFieldKey) {
        DynamicObject dyobj = view.getModel().getDataEntity();
        DynamicObjectCollection entryentities = dyobj.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryentity : entryentities) {
            DynamicObject triggerCollaDyobj = entryentity.getDynamicObject(fieldKey);
            if (null == triggerCollaDyobj) continue;
            entryentity.set(presetFieldKey, (Object)(triggerCollaDyobj.getBoolean("issyspreset") ? "1" : "0"));
        }
    }

    public Map<String, Boolean> getPayRollActGrpIsMustFieldMap(DynamicObjectCollection entryentities) {
        List<Long> payRollActIds;
        DynamicObject[] payRollActDyobjs;
        Map<String, Boolean> payRollActIsMustFieldMapRel = new HashMap<String, Boolean>(16);
        if (!entryentities.isEmpty() && null != (payRollActDyobjs = this.getPayRollActDyobjs(payRollActIds = entryentities.stream().map(tplEntryentity -> tplEntryentity.getLong("payrollact.id")).collect(Collectors.toList())))) {
            Map<String, Boolean> triggerCollaIsMustFieldMaps = this.getTriggerCollaIsMustFieldMap(payRollActDyobjs);
            payRollActIsMustFieldMapRel = this.getPayRollActIsMustFieldMapRel(payRollActDyobjs, triggerCollaIsMustFieldMaps);
        }
        return payRollActIsMustFieldMapRel;
    }

    private Map<String, Boolean> getPayRollActIsMustFieldMapRel(DynamicObject[] payRollActDyobjs, Map<String, Boolean> triggerCollaIsMustFieldMaps) {
        HashMap<String, Boolean> payRollActIsMustFieldMapRel = new HashMap<String, Boolean>(16);
        for (DynamicObject payRollActDyobj : payRollActDyobjs) {
            Boolean isMust = Boolean.FALSE;
            DynamicObjectCollection triggerCollas = payRollActDyobj.getDynamicObjectCollection("entryentity");
            for (DynamicObject triggerColla : triggerCollas) {
                if (isMust.booleanValue()) break;
                Boolean isMustFieldMap = triggerCollaIsMustFieldMaps.get(triggerColla.getString("triggercolla.id"));
                isMust = isMust | isMustFieldMap;
            }
            payRollActIsMustFieldMapRel.put(payRollActDyobj.getString("id"), isMust);
        }
        return payRollActIsMustFieldMapRel;
    }

    private Map<String, Boolean> getTriggerCollaIsMustFieldMap(DynamicObject[] payRollActDyobjs) {
        DynamicObject[] triggetCollaDyobjs;
        ArrayList triggerCollaIds = new ArrayList(10);
        Arrays.asList(payRollActDyobjs).stream().forEach(payRollActDyobj -> {
            DynamicObjectCollection triggerCollaDyobjs = payRollActDyobj.getDynamicObjectCollection("entryentity");
            triggerCollaDyobjs.forEach(triggerCollaDyobj -> triggerCollaIds.add(triggerCollaDyobj.getLong("triggercolla.id")));
        });
        HashMap<String, Boolean> triggerCollaIsMustFieldMapRel = new HashMap<String, Boolean>(16);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_triggercolla");
        QFilter qFilter = new QFilter("id", "in", triggerCollaIds);
        for (DynamicObject triggerCollaDyobj : triggetCollaDyobjs = serviceHelper.query("ismustfieldmapping", new QFilter[]{qFilter})) {
            triggerCollaIsMustFieldMapRel.put(triggerCollaDyobj.getString("id"), "1".equals(triggerCollaDyobj.getString("ismustfieldmapping")));
        }
        return triggerCollaIsMustFieldMapRel;
    }

    private DynamicObject[] getPayRollActDyobjs(List<Long> payRollActIds) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_payrollact");
        QFilter qFilter = new QFilter("id", "in", payRollActIds);
        return serviceHelper.query("issyspreset, entryentity.triggercolla", new QFilter[]{qFilter});
    }

    @Deprecated
    public Map<String, Object> queryCollaDataByIds(String entityNumber, List<Long> ids) {
        return this.queryCollaDataByIds(entityNumber, ids, null);
    }

    @Deprecated
    public Map<String, Object> queryCollaDataByIds(String entityNumber, List<Long> ids, Boolean isUseBoid) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        try {
            SWCDataServiceHelper entityOrm = new SWCDataServiceHelper(entityNumber);
            if (isUseBoid == null) {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                isUseBoid = dataEntityType.getProperties().containsKey((Object)"boid");
            }
            QFilter idFilter = new QFilter(isUseBoid != false ? "boid" : "id", "in", ids);
            DynamicObject[] query = entityOrm.query(SWCHisBaseDataHelper.getSelectProperties((String)entityNumber), new QFilter[]{idFilter});
            List result = Arrays.stream(query).collect(Collectors.toList());
            resultMap.put("success", Boolean.TRUE);
            resultMap.put("data", result);
            return resultMap;
        }
        catch (Exception ex) {
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("message", ex.getMessage());
            return resultMap;
        }
    }

    @Deprecated
    public Map<String, Object> isLaborRelRecordExpired(Long employeeId, Date effectTime) {
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        String resultKey = "isLaborRelRecordExpired";
        result.put(resultKey, Boolean.FALSE);
        if (employeeId == null || employeeId == 0L || effectTime == null) {
            LOGGER.info("[colla] call isLaborRelRecordExpired condition = (employeeId == null || employeeId == 0L || effectTime == null),employeeId = {} ,effectTime = {}", (Object)employeeId, (Object)effectTime);
            return result;
        }
        LOGGER.info("[colla] call isLaborRelRecordExpired,employeeId = {} ,effectTime = {}", (Object)employeeId, (Object)effectTime.getTime());
        List invokeResult = (List)SWCMServiceUtils.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listInfo", (Object[])new Object[]{"hrpi_laborrelrecord", null, null, employeeId});
        if (CollectionUtils.isEmpty((Collection)invokeResult)) {
            LOGGER.info("[colla] call isLaborRelRecordExpired condition = CollectionUtils.isEmpty(invokeResult)");
            return result;
        }
        Optional<Map> first = invokeResult.stream().filter(item -> (Boolean)item.get("iscurrentversion")).findFirst();
        if (!first.isPresent()) {
            LOGGER.info("[colla] call isLaborRelRecordExpired condition = !first.isPresent()");
            return result;
        }
        Map laborRecord = first.get();
        Date enddate = (Date)laborRecord.get("enddate");
        if (enddate == null) {
            LOGGER.info("[colla] call isLaborRelRecordExpired condition = enddate == null");
            return result;
        }
        LOGGER.info("[colla] call isLaborRelRecordExpired enddate = {}", (Object)enddate.getTime());
        result.put(resultKey, !SWCDateTimeUtils.dayBefore((Date)effectTime, (Date)enddate));
        LOGGER.info("[colla] call isLaborRelRecordExpired success,resultKey = {} ,value = {}", (Object)resultKey, (Object)(!SWCDateTimeUtils.dayBefore((Date)effectTime, (Date)enddate) ? 1 : 0));
        return result;
    }

    private List<DynamicObject> getCollaRuleByIds(List<Long> collaRuleIds) {
        SWCDataServiceHelper orm = new SWCDataServiceHelper("hsas_payrollactg");
        DynamicObject[] query = orm.query(SWCHisBaseDataHelper.getSelectProperties((String)"hsas_payrollactg"), new QFilter[]{new QFilter("id", "in", collaRuleIds)});
        return Arrays.asList(query);
    }

    @Deprecated
    public Map<String, Object> callCollaRule(Map<String, Object> param) {
        if (CollectionUtils.isEmpty(param)) {
            return this.getResponseResultTips("param");
        }
        Map convertedApiResult = (Map)param.get("convertedApiResult");
        Map paramMap = (Map)param.get("paramMap");
        List collaRuleIds = (List)param.get("collaRuleIds");
        if (CollectionUtils.isEmpty((Map)convertedApiResult)) {
            return this.getResponseResultTips("convertedApiResult");
        }
        if (CollectionUtils.isEmpty((Map)paramMap)) {
            return this.getResponseResultTips("paramMap");
        }
        if (CollectionUtils.isEmpty((Collection)collaRuleIds)) {
            return this.getResponseResultTips("collaRuleIds");
        }
        List<DynamicObject> collaRules = this.getCollaRuleByIds(collaRuleIds);
        if (CollectionUtils.isEmpty(collaRules)) {
            return this.getResponseResult(true, null, null);
        }
        Long orgId = (Long)paramMap.get("orgId");
        Date effectTime = (Date)paramMap.get("effectTime");
        String flowType = (String)paramMap.get("flowType");
        String buNumber = (String)paramMap.get("buNumber");
        Map msgEntity = paramMap.getOrDefault("msgEntity", Collections.emptyMap());
        HashMap<Long, Map<String, Object>> originalDataMap = new HashMap<Long, Map<String, Object>>(collaRules.size());
        HashMap<Long, Map<String, String>> exePreRule = new HashMap<Long, Map<String, String>>(16);
        for (DynamicObject collaRule : collaRules) {
            CollaRuleExecuteContext executeInfo = new CollaRuleExecuteContext();
            executeInfo.setConvertedApiDatas(convertedApiResult);
            executeInfo.setOrgId(orgId);
            executeInfo.setEffectTime(effectTime);
            executeInfo.setFlowType(flowType);
            executeInfo.setOrgNumber(buNumber);
            executeInfo.setMsgEntity(msgEntity);
            long collaRuleId = collaRule.getLong("id");
            long policyId = collaRule.getLong("policy.id");
            String sceneNumber = collaRule.getString("scene.number");
            long sceneId = collaRule.getLong("scene.id");
            String sceneAppNumber = collaRule.getString("scene.bizappid.number");
            DynamicObjectCollection entryEntity = collaRule.getDynamicObjectCollection("entryentity");
            for (DynamicObject actionEntryEntity : entryEntity) {
                CollaActContext collaActContext = new CollaActContext();
                long payRollActId = actionEntryEntity.getLong("payrollact.id");
                long ruleDesignId = actionEntryEntity.getLong("ruledesign.id");
                Map exePreRuleSet = exePreRule.getOrDefault(collaRuleId, new HashMap());
                if (ruleDesignId != 0L) {
                    exePreRuleSet.put(policyId + "#" + ruleDesignId, actionEntryEntity.getString("payrollact.name"));
                }
                exePreRule.put(collaRuleId, exePreRuleSet);
                DynamicObjectCollection fieldRuleSubEntry = actionEntryEntity.getDynamicObjectCollection("fieldrulesubentryentity");
                collaActContext.setRuleId(Long.valueOf(ruleDesignId));
                collaActContext.setPolicyId(Long.valueOf(policyId));
                collaActContext.setPayRollActId(Long.valueOf(payRollActId));
                collaActContext.setSceneNumber(sceneNumber);
                collaActContext.setSceneAppNumber(sceneAppNumber);
                collaActContext.setSceneId(Long.valueOf(sceneId));
                if (CollectionUtils.isEmpty((Collection)fieldRuleSubEntry)) continue;
                List policyIds = fieldRuleSubEntry.stream().map(item -> item.getLong("frpolicy.id")).collect(Collectors.toList());
                collaActContext.setPolicyIds(policyIds);
                executeInfo.getCollaActContext().add(collaActContext);
            }
            StandardCloudCollaTaskExecuteHelper helper = new StandardCloudCollaTaskExecuteHelper(executeInfo);
            try {
                Map original = helper.callRuleEngineOriginal(executeInfo);
                originalDataMap.put(collaRuleId, original);
            }
            catch (Exception ex) {
                LOGGER.info("[colla] call rule engine error.", (Object)ex);
                return this.getResponseResult(false, ResManager.loadKDString((String)"\u6267\u884c\u89c4\u5219\u5f15\u64ce\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{0}\u3002", (String)"HSASCloudCollaHelper_1", (String)"swc-hsas-business", (Object[])new Object[]{ex.getMessage()}), null);
            }
        }
        if (CollectionUtils.isEmpty(originalDataMap)) {
            return this.getResponseResult(true, null, null);
        }
        return this.getResponseResult(true, null, this.convertRuleEngineData(originalDataMap, exePreRule));
    }

    private Map<String, Object> convertRuleEngineData(Map<Long, Map<String, Object>> originalDataMap, Map<Long, Map<String, String>> exePreRule) {
        HashMap<String, Object> result = new HashMap<String, Object>(originalDataMap.size());
        originalDataMap.forEach((ruleId, collaRuleResult) -> {
            String responseCode = (String)collaRuleResult.get("responseCode");
            String responseDesc = (String)collaRuleResult.get("responseDesc");
            String errorMsg = (String)collaRuleResult.get("errorMsg");
            if (!"200".equals(responseCode)) {
                result.put(String.valueOf(ruleId), this.getResponseResult(false, errorMsg, null));
                return;
            }
            List policyResults = (List)collaRuleResult.get("policyResults");
            if (CollectionUtils.isEmpty((Collection)policyResults)) {
                result.put(String.valueOf(ruleId), this.getResponseResult(true, responseDesc, null));
                return;
            }
            HashMap<String, Object> ruleDataResult = new HashMap<String, Object>(policyResults.size());
            HashMap<String, Object> exePreConditionResult = new HashMap<String, Object>(policyResults.size());
            Map exePreSet = (Map)exePreRule.get(ruleId);
            for (Map policyResult : policyResults) {
                Map<String, Object> fieldValue;
                Map<String, Object> ruleResult = HSASCloudCollaHelper.getRuleResult(exePreConditionResult, exePreSet, policyResult);
                if (ruleResult == null || CollectionUtils.isEmpty(fieldValue = this.getFieldValue(ruleResult, ruleDataResult))) continue;
                ruleDataResult.putAll(fieldValue);
            }
            Map<String, Object> checkResult = this.checkExePreConditionResult(exePreConditionResult, exePreSet);
            boolean success = (Boolean)checkResult.get("success");
            String msg = (String)checkResult.get("msg");
            result.put(String.valueOf(ruleId), this.getResponseResult(success, SWCStringUtils.isEmpty((String)msg) ? null : msg, ruleDataResult, success ? null : checkResult));
        });
        return result;
    }

    private Map<String, Object> checkExePreConditionResult(Map<String, Object> exePreConditionResult, Map<String, String> exePreSet) {
        HashMap<String, Object> result = new HashMap<String, Object>(exePreSet.size());
        result.put("success", Boolean.TRUE);
        ArrayList<String> resultMsg = new ArrayList<String>(exePreSet.size());
        ArrayList errorData = new ArrayList(exePreSet.size());
        for (Map.Entry<String, String> dataEntry : exePreSet.entrySet()) {
            String key = dataEntry.getKey();
            String name = dataEntry.getValue();
            Object value = exePreConditionResult.get(key);
            if (value != null && "success".equalsIgnoreCase(String.valueOf(exePreConditionResult.get(key)))) continue;
            resultMsg.add(ResManager.loadKDString((String)"\u201c{0}\u201d\u6267\u884c\u524d\u63d0\u6761\u4ef6\u4e0d\u6ee1\u8db3\u3002", (String)"HSASCloudCollaHelper_2", (String)"swc-hsas-business", (Object[])new Object[]{name}));
            result.put("success", Boolean.FALSE);
            HashMap<String, String> errorDataMap = new HashMap<String, String>(16);
            errorDataMap.put("code", "COLLA_RULE_ERROR_001");
            errorDataMap.put("actName", name);
            errorData.add(errorDataMap);
        }
        if (!CollectionUtils.isEmpty(errorData)) {
            result.put("errorData", errorData);
        }
        if (!CollectionUtils.isEmpty(resultMsg)) {
            result.put("msg", resultMsg.stream().collect(Collectors.joining(System.lineSeparator())));
        }
        return result;
    }

    private Map<String, Object> getFieldValue(Map<String, Object> ruleResult, Map<String, Object> ruleDataResult) {
        Object value = ruleResult.get("value");
        if (value == null) {
            return null;
        }
        String field = (String)ruleResult.get("field");
        String entityType = (String)ruleResult.get("entityType");
        String fieldType = (String)ruleResult.get("fieldType");
        String key = field;
        Object fieldValue = value;
        if (SWCStringUtils.isNotEmpty((String)entityType)) {
            DynamicObject object = (DynamicObject)ruleDataResult.getOrDefault(entityType, new SWCDataServiceHelper(entityType).generateEmptyDynamicObject(entityType));
            key = entityType;
            String[] split = field.split("\\.");
            if (split.length < 2) {
                return null;
            }
            String formId = split[1];
            object.set(formId, HSASCloudCollaHelper.parseRuleEngineResult(value, entityType, fieldType, formId));
            fieldValue = object;
        } else if ("date".equals(fieldType)) {
            try {
                fieldValue = SWCDateTimeUtils.parseDate((String)String.valueOf(value));
            }
            catch (ParseException ex) {
                LOGGER.info("[colla] parse datetime error.", (Object)ex);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(key, fieldValue);
        return result;
    }

    private static Object parseRuleEngineResult(Object value, String entityType, String fieldType, String formId) {
        if (value == null || "null".equalsIgnoreCase(String.valueOf(value))) {
            return null;
        }
        Object result = value;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityType);
        DynamicProperty property = dataEntityType.getProperty(formId);
        if ("dynamicObject".equalsIgnoreCase(fieldType)) {
            String baseEntityId = ((BasedataProp)property).getBaseEntityId();
            result = new SWCDataServiceHelper(baseEntityId).generateDynamicObject(value, SWCHisBaseDataHelper.getSelectProperties((String)baseEntityId));
        } else if ("date".equalsIgnoreCase(fieldType)) {
            try {
                result = SWCDateTimeUtils.parseDate((String)String.valueOf(value));
            }
            catch (ParseException ex) {
                LOGGER.info("[colla] parse datetime error.", (Object)ex);
                result = null;
            }
        } else if ("boolean".equalsIgnoreCase(fieldType)) {
            result = Boolean.parseBoolean(String.valueOf(value));
        } else if ("number".equalsIgnoreCase(fieldType)) {
            try {
                Long tempData;
                BigDecimal tempValue = new BigDecimal(String.valueOf(value));
                result = property instanceof DecimalProp ? tempValue : (0L == (tempData = Long.valueOf(tempValue.longValue())) ? null : tempData);
            }
            catch (Exception ex) {
                LOGGER.info("[colla] parse number error.", (Object)ex);
                result = null;
            }
        }
        return result;
    }

    private static Map<String, Object> getRuleResult(Map<String, Object> exePreConditionResult, Map<String, String> exePreSet, Map<String, Object> policyResult) {
        Map ruleResult = null;
        List ruleResults = (List)policyResult.get("ruleResults");
        String policyId = (String)policyResult.get("policyId");
        if (CollectionUtils.isEmpty((Collection)ruleResults)) {
            List defaultResults = (List)policyResult.get("defaultResults");
            ruleResult = defaultResults != null && defaultResults.size() > 0 ? (Map)defaultResults.get(0) : null;
        } else {
            for (Map ruleData : ruleResults) {
                String ruleDesignId = (String)ruleData.get("ruleDesignId");
                String key = policyId + "#" + ruleDesignId;
                if (exePreSet.containsKey(key)) {
                    exePreConditionResult.put(key, ((Map)((List)ruleData.get("matchResults")).get(0)).get("value"));
                    continue;
                }
                List matchResults = (List)ruleData.get("matchResults");
                ruleResult = (Map)matchResults.get(0);
            }
        }
        return ruleResult;
    }

    private Map<String, Object> getResponseResultTips(String paramName) {
        return this.getResponseResult(false, ResManager.loadKDString((String)"\u53c2\u6570\u201c{0}\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HSASCloudCollaHelper_0", (String)"swc-hsas-business", (Object[])new Object[]{paramName}), null);
    }

    private Map<String, Object> getResponseResult(boolean isSuccess, String msg, Object data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", isSuccess);
        result.put("msg", msg);
        result.put("data", data);
        return result;
    }

    private Map<String, Object> getResponseResult(boolean isSuccess, String msg, Object data, Object errorData) {
        Map<String, Object> responseResult = this.getResponseResult(isSuccess, msg, data);
        if (errorData != null) {
            responseResult.put("errorDataList", errorData);
        }
        return responseResult;
    }

    @Deprecated
    public Map<String, Object> getSceneIdByMsgSubId(Long msgSubId) {
        if (msgSubId == null || msgSubId == 0L) {
            return null;
        }
        SWCDataServiceHelper orm = new SWCDataServiceHelper("hsas_msgscene");
        DynamicObject[] query = orm.query("id,scene.id,msgsubscriber.id", new QFilter[]{new QFilter("msgsubscriber.id", "=", (Object)msgSubId)});
        ArrayList<Long> result = new ArrayList<Long>();
        if (query == null || query.length == 0) {
            return this.getResponseResult(true, null, result);
        }
        for (DynamicObject dynamicObject : query) {
            long sceneId = dynamicObject.getLong("scene.id");
            if (sceneId == 0L) continue;
            result.add(sceneId);
        }
        return this.getResponseResult(true, null, result);
    }

    public static List<String> getDefaultCloudIds() {
        ArrayList<String> cloudIds = new ArrayList<String>(2);
        cloudIds.add(CLOUD_SWC);
        cloudIds.add(CLOUD_SIT);
        return cloudIds;
    }

    private static class Load {
        private static final HSASCloudCollaHelper INSTANCE = new HSASCloudCollaHelper();

        private Load() {
        }
    }
}

