/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cloudcolla;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.hr.ruleengine.controls.DefaultResult;
import kd.bos.ext.hr.ruleengine.controls.RuleControl;
import kd.bos.ext.hr.ruleengine.enums.RuleOperatorEnum;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.workflow.engine.impl.util.DynamicObjectJsonSerializer;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.swc.hsas.common.constants.PayRollActGrpConstants;
import kd.swc.hsas.common.dto.HRPolicyDTO;
import kd.swc.hsas.common.dto.HRRuleDTO;
import kd.swc.hsas.common.dto.HRUsableRangeDTO;
import kd.swc.hsas.common.dto.ResponseDTO;
import kd.swc.hsbp.business.coderule.CodeRuleHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PayRollActGrpHelper
implements PayRollActGrpConstants {
    private static final Log LOGGER = LogFactory.getLog(PayRollActGrpHelper.class);
    private static final String ERROR_MSG = "errorMsg";
    private static final char EMPTY_CHAR = ' ';
    private static final String DELETE = "delete";
    private static final String NEW = "new";
    private static final String MODIFY = "modify";
    private static final String REPLACE_STR = "...";
    private static final String POLICY_FIELDS = "id,number,bizappid,createbu,description,enable,name,policymode,retrundefault,results,scene,entryrulelist.id,entryrulelist.filtercondition,entryrulelist.filterresult,entryrulelist.ruledescription,entryrulelist.ruleenable,entryrulelist.rulename,entryrulelist.rulenumber,entryrulelist.ruleorder,entrybulist.id,entrybulist.entitybu,entrybulist.containssub";
    private static final String RESULT_CODE = "resultCode";
    private static final String SUCCESS_CODE = "200";
    private static final String ERROR_CODE = "500";
    public static String BIZ_APP_ID;

    public static ResponseDTO<Map<String, Long>> batchInsertOrUpdateHrPolicy(List<HRPolicyDTO> policyList) {
        HashMap<String, Long> numberIdMap = new HashMap<String, Long>(16);
        if (CollectionUtils.isEmpty(policyList)) {
            return new ResponseDTO(SUCCESS_CODE, numberIdMap, null);
        }
        ArrayList<HRPolicyDTO> insertList = new ArrayList<HRPolicyDTO>();
        ArrayList<HRPolicyDTO> updateList = new ArrayList<HRPolicyDTO>();
        List numbers = policyList.stream().map(HRPolicyDTO::getNumber).collect(Collectors.toList());
        SWCDataServiceHelper policyOrm = new SWCDataServiceHelper("brm_policy_edit");
        DynamicObject[] query = policyOrm.query("id,number", new QFilter[]{new QFilter("number", "in", numbers)});
        HashMap<String, Long> queryNumberIdMap = new HashMap<String, Long>(16);
        if (null != query && query.length > 0) {
            for (DynamicObject dynamicObject : query) {
                queryNumberIdMap.put(dynamicObject.getString("number"), dynamicObject.getLong("id"));
            }
        }
        for (HRPolicyDTO policy : policyList) {
            if (queryNumberIdMap.containsKey(policy.getNumber())) {
                policy.setId((Long)queryNumberIdMap.get(policy.getNumber()));
                updateList.add(policy);
                continue;
            }
            insertList.add(policy);
        }
        try {
            if (PayRollActGrpHelper.saveInsertList(numberIdMap, insertList).booleanValue() && PayRollActGrpHelper.saveUpdateList(numberIdMap, updateList).booleanValue()) {
                return new ResponseDTO(SUCCESS_CODE, numberIdMap, null);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8f6c\u6362\u6570\u636e\u9519\u8bef", (Throwable)e);
            return new ResponseDTO(ERROR_CODE, null, e.getMessage());
        }
        return new ResponseDTO(ERROR_CODE, null, null);
    }

    public static ResponseDTO<List<HRPolicyDTO>> getHrPolicyListByIdOrNumber(List<Long> ids, List<Number> numbers) {
        if (CollectionUtils.isEmpty(ids) && CollectionUtils.isEmpty(numbers)) {
            return new ResponseDTO(SUCCESS_CODE, null, null);
        }
        SWCDataServiceHelper policyOrm = new SWCDataServiceHelper("brm_policy_edit");
        DynamicObject[] query = policyOrm.query(POLICY_FIELDS, new QFilter[]{new QFilter("id", "in", ids).or(new QFilter("number", "in", numbers))});
        List<HRPolicyDTO> result = PayRollActGrpHelper.convertBrmPolicyDynamicToHrPolicys(query);
        return new ResponseDTO(SUCCESS_CODE, result, null);
    }

    public static ResponseDTO<Boolean> disableHrPolicys(List<Long> ids, List<Number> numbers) {
        try {
            return PayRollActGrpHelper.setHrPolicyEnableValue(ids, numbers, Boolean.FALSE);
        }
        catch (Exception e) {
            return new ResponseDTO(ERROR_CODE, null, e.getMessage());
        }
    }

    public static ResponseDTO<Boolean> enableHrPolicys(List<Long> ids, List<Number> numbers) {
        try {
            return PayRollActGrpHelper.setHrPolicyEnableValue(ids, numbers, Boolean.TRUE);
        }
        catch (Exception e) {
            return new ResponseDTO(ERROR_CODE, null, e.getMessage());
        }
    }

    public static ResponseDTO<Boolean> deleteHrPolicys(List<Long> ids) {
        int result = (Integer)SWCMServiceUtils.invokeHRMPService((String)"brm", (String)"IBRMPolicyService", (String)"deletePolicy", (Object[])new Object[]{ids});
        if (result < 0) {
            return new ResponseDTO(ERROR_CODE, null, null);
        }
        return new ResponseDTO(SUCCESS_CODE, null, null);
    }

    public static String newPolicyNumber() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"hsas_policyconfig");
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)dynamicObject.getDataEntityType().getName(), (DynamicObject)dynamicObject, null);
        return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)dynamicObject);
    }

    public static String newRuleNumber() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"hsas_ruledesignconfig");
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)dynamicObject.getDataEntityType().getName(), (DynamicObject)dynamicObject, null);
        return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)dynamicObject);
    }

    public static String[] newPolicyNumbers(int count) {
        if (count <= 0) {
            return new String[0];
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"hsas_policyconfig");
        return CodeRuleHelper.getBatchNumber((DynamicObject)dynamicObject, null, (int)count);
    }

    public static String[] newRuleNumbers(int count) {
        if (count <= 0) {
            return new String[0];
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"hsas_ruledesignconfig");
        return CodeRuleHelper.getBatchNumber((DynamicObject)dynamicObject, null, (int)count);
    }

    public static String getDefaultResultString() {
        HashMap result = new HashMap(1);
        HashMap<String, Object> cell = new HashMap<String, Object>(16);
        cell.put("paramType", "string");
        cell.put("displayValue", "success");
        cell.put("param", "result_str");
        cell.put("displayParam", ResManager.loadKDString((String)"\u7ed3\u679c\u503c(\u5b57\u7b26\u4e32)", (String)"PayRollActGrpHelper_03", (String)"swc-hsas-business", (Object[])new Object[0]));
        cell.put("operators", "==");
        cell.put("index", 0);
        cell.put("value", "success");
        ArrayList<HashMap<String, Object>> cellList = new ArrayList<HashMap<String, Object>>();
        cellList.add(cell);
        result.put("resultList", cellList);
        String resultStr = null;
        try {
            resultStr = SWCJSONUtils.toString(result);
        }
        catch (IOException e) {
            LOGGER.info("\u9ed8\u8ba4\u7ed3\u679c\u5b57\u6bb5\u8f6cjson\u9519\u8bef\u3002", (Object)e);
        }
        return resultStr;
    }

    public static String formatRuleConditionInfo(String ruleConditionJsonStr) {
        if (SWCStringUtils.isEmpty((String)ruleConditionJsonStr)) {
            return null;
        }
        JSONObject ruleObj = JSONObject.parseObject((String)ruleConditionJsonStr);
        if (null == ruleObj) {
            return null;
        }
        JSONArray conditionList = ruleObj.getJSONArray("conditionList");
        if (CollectionUtils.isEmpty((Collection)conditionList)) {
            return null;
        }
        HashMap<String, String> conditionMap = new HashMap<String, String>(16);
        for (Object condition : conditionList) {
            JSONObject conditionObj = (JSONObject)condition;
            String param = conditionObj.getString("displayParam");
            String name = conditionObj.getString("name");
            String operator = conditionObj.getString("operators");
            String value = conditionObj.getString("displayValue");
            operator = PayRollActGrpHelper.processOperatorStr(operator, value);
            conditionMap.put(name, param + ' ' + operator);
        }
        JSONArray conditionExpressList = ruleObj.getJSONArray("conditionExpressList");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < conditionExpressList.size(); ++i) {
            StringBuilder tmp = new StringBuilder();
            Object express = conditionExpressList.get(i);
            JSONObject expressObj = (JSONObject)express;
            String logical = expressObj.getString("logical");
            if (i == conditionExpressList.size() - 1) {
                logical = null;
            }
            String name = expressObj.getString("name");
            String leftBracket = expressObj.getString("leftBracket");
            String rightBracket = expressObj.getString("rightBracket");
            tmp.append(leftBracket == null ? "" : leftBracket).append((String)conditionMap.get(name)).append(rightBracket == null ? "" : rightBracket).append(logical == null ? "" : logical);
            result.append((CharSequence)tmp);
        }
        return result.toString();
    }

    public static String formatRuleResultInfo(String ruleResultJsonStr) {
        if (SWCStringUtils.isEmpty((String)ruleResultJsonStr)) {
            return null;
        }
        JSONObject ruleResult = JSONObject.parseObject((String)ruleResultJsonStr);
        if (null == ruleResult) {
            return null;
        }
        JSONArray resultList = ruleResult.getJSONArray("resultList");
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return null;
        }
        ArrayList<String> resultStrList = new ArrayList<String>();
        for (Object result : resultList) {
            JSONObject resultObj = (JSONObject)result;
            String param = resultObj.getString("displayParam");
            String operators = resultObj.getString("operators");
            String displayValue = resultObj.getString("displayValue");
            String processOperatorStr = PayRollActGrpHelper.processOperatorStr(operators, displayValue);
            resultStrList.add(param + ' ' + processOperatorStr);
        }
        return String.join((CharSequence)", ", resultStrList);
    }

    public static List<HRPolicyDTO> convertBrmPolicyDynamicToHrPolicys(DynamicObject[] dataEntitys) {
        ArrayList<HRPolicyDTO> result = new ArrayList<HRPolicyDTO>();
        if (null == dataEntitys || dataEntitys.length < 1) {
            return result;
        }
        for (DynamicObject dynamicObject : dataEntitys) {
            HRPolicyDTO convertDy = PayRollActGrpHelper.convertBrmPolicyDynamicToHrPolicy(dynamicObject);
            if (null == convertDy) continue;
            result.add(convertDy);
        }
        return result;
    }

    public static HRPolicyDTO convertBrmPolicyDynamicToHrPolicy(DynamicObject policyDynamicObject) {
        if (null == policyDynamicObject) {
            return null;
        }
        if (!"brm_policy_edit".equals(policyDynamicObject.getDataEntityType().getName())) {
            return null;
        }
        HRPolicyDTO policy = new HRPolicyDTO();
        policy.setBizAppId(policyDynamicObject.getString("bizappid.id"));
        policy.setCreateBu(Long.valueOf(policyDynamicObject.getLong("createbu.id")));
        policy.setDescription(policyDynamicObject.getString("description"));
        policy.setEnable(policyDynamicObject.getString("enable"));
        Long policyId = policyDynamicObject.getLong("id");
        if (policyId != null && policyId > 0L) {
            policy.setId(policyId);
        }
        policy.setName(policyDynamicObject.getString("name"));
        policy.setNumber(policyDynamicObject.getString("number"));
        policy.setPolicyMode(policyDynamicObject.getString("policymode"));
        policy.setIsDefaultResult(Boolean.valueOf(policyDynamicObject.getBoolean("retrundefault")));
        if (null != policy.getIsDefaultResult() && policy.getIsDefaultResult().booleanValue()) {
            policy.setResults(policyDynamicObject.getString("results"));
        }
        policy.setScene(Long.valueOf(policyDynamicObject.getLong("scene.id")));
        policy.setEntryRuleList(PayRollActGrpHelper.getHrRuleFromEntity(policyDynamicObject));
        policy.setEntryBuList(PayRollActGrpHelper.getHrEnableRangeFromEntity(policyDynamicObject.getDynamicObjectCollection("entrybulist")));
        return policy;
    }

    private static HRPolicyDTO getHrPolicyFromPolicyConfigView(IFormView policyView) {
        if (null == policyView) {
            return null;
        }
        DynamicObject hsasPolicyConfig = policyView.getModel().getDataEntity();
        if (!"hsas_policyconfig".equals(hsasPolicyConfig.getDataEntityType().getName())) {
            return null;
        }
        HRPolicyDTO policy = new HRPolicyDTO();
        Long policyId = hsasPolicyConfig.getLong("id");
        if (policyId != null && policyId > 0L) {
            policy.setId(policyId);
        }
        policy.setName(hsasPolicyConfig.getString("name"));
        policy.setNumber(hsasPolicyConfig.getString("number"));
        policy.setIsDefaultResult(Boolean.valueOf(hsasPolicyConfig.getBoolean("retrundefault")));
        policy.setEntryRuleList(PayRollActGrpHelper.getHrRuleFromEntity(policyView.getModel().getEntryEntity("entryrulelist"), hsasPolicyConfig.getBoolean("enable")));
        DefaultResult control = (DefaultResult)policyView.getControl("defaultresultap");
        if (null != policy.getIsDefaultResult() && policy.getIsDefaultResult().booleanValue()) {
            policy.setResults(control.getValue());
        }
        return policy;
    }

    private static ResponseDTO<Boolean> setHrPolicyEnableValue(List<Long> ids, List<Number> numbers, Boolean value) throws Exception {
        ResponseDTO<List<HRPolicyDTO>> response = PayRollActGrpHelper.getHrPolicyListByIdOrNumber(ids, numbers);
        if (!response.isSuccess()) {
            return new ResponseDTO(ERROR_CODE, null, null);
        }
        List result = (List)response.getResult();
        if (CollectionUtils.isEmpty((Collection)result)) {
            return new ResponseDTO(SUCCESS_CODE, null, null);
        }
        for (HRPolicyDTO hrPolicy : result) {
            List entryBuList;
            hrPolicy.setEnable(value);
            List entryRuleList = hrPolicy.getEntryRuleList();
            if (!CollectionUtils.isEmpty((Collection)entryRuleList)) {
                for (HRRuleDTO hrRule : entryRuleList) {
                    hrRule.setModifyStatus(MODIFY);
                    hrRule.setRuleEnable(value);
                }
            }
            if (CollectionUtils.isEmpty((Collection)(entryBuList = hrPolicy.getEntryBuList()))) continue;
            for (HRUsableRangeDTO hrBu : entryBuList) {
                hrBu.setModifyStatus(MODIFY);
            }
        }
        List<Map<String, Object>> updateMap = PayRollActGrpHelper.convertObjectToMap(result);
        Map requestResult = (Map)SWCMServiceUtils.invokeHRMPService((String)"brm", (String)"IBRMPolicyService", (String)"batchModifyPolicy", (Object[])new Object[]{updateMap});
        if (SUCCESS_CODE.equals(String.valueOf(requestResult.get(RESULT_CODE)))) {
            return new ResponseDTO(SUCCESS_CODE, null, null);
        }
        throw new Exception(requestResult.get(ERROR_MSG).toString());
    }

    private static Boolean saveUpdateList(Map<String, Long> numberIdMap, List<HRPolicyDTO> updateList) throws Exception {
        if (CollectionUtils.isEmpty(updateList)) {
            return Boolean.TRUE;
        }
        SWCDataServiceHelper policyOrm = new SWCDataServiceHelper("brm_policy_edit");
        List ids = updateList.stream().map(HRPolicyDTO::getId).collect(Collectors.toList());
        DynamicObject[] query = policyOrm.query("id,name,number,entryrulelist,entryrulelist.id,entryrulelist.rulenumber,entrybulist,entrybulist.id", new QFilter[]{new QFilter("id", "in", ids)});
        if (query != null && query.length > 0) {
            PayRollActGrpHelper.dispatcherUpdatePolicy(updateList, query);
            List<Map<String, Object>> updateMap = PayRollActGrpHelper.convertObjectToMap(updateList);
            LOGGER.info("\u5f00\u59cb\u8c03\u7528\u4e2d\u53f0\u5fae\u670d\u52a1IBRMPolicyService.batchModifyPolicy\u4fee\u6539\u6570\u636e,updateMap = {}", (Object)SWCJSONUtils.toString(updateMap));
            Map requestResult = (Map)SWCMServiceUtils.invokeHRMPService((String)"brm", (String)"IBRMPolicyService", (String)"batchModifyPolicy", (Object[])new Object[]{updateMap});
            if (SUCCESS_CODE.equals(String.valueOf(requestResult.get(RESULT_CODE)))) {
                if (null != numberIdMap) {
                    numberIdMap.putAll(PayRollActGrpHelper.getSuccessNumberIdMap(requestResult));
                }
                return Boolean.TRUE;
            }
            throw new Exception(requestResult.get(ERROR_MSG).toString());
        }
        return Boolean.FALSE;
    }

    private static Map<String, Long> getSuccessNumberIdMap(Map<String, Object> requestResult) {
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        List jsonArray = (List)requestResult.get("policyResults");
        for (Map object : jsonArray) {
            String number = (String)object.get("policyNumber");
            Long id = (Long)object.get("policyId");
            map.put(number, id);
        }
        return map;
    }

    private static List<Map<String, Object>> convertObjectToMap(List<HRPolicyDTO> policyList) throws IOException {
        String updateStr = SWCJSONUtils.toString(policyList);
        List result = (List)SWCJSONUtils.cast((String)updateStr, List.class, (Class[])new Class[]{Map.class});
        for (Map map : result) {
            PayRollActGrpHelper.convertParamType(map, "id");
            PayRollActGrpHelper.convertParamType(map, "createbu");
            List ruleList = (List)map.get("entryrulelist");
            for (Map rule : ruleList) {
                PayRollActGrpHelper.convertParamType(rule, "id");
            }
            List buList = (List)map.get("entrybulist");
            for (Map bu : buList) {
                PayRollActGrpHelper.convertParamType(bu, "id");
                PayRollActGrpHelper.convertParamType(bu, "entitybu");
            }
        }
        return result;
    }

    private static void convertParamType(Map<String, Object> map, String paramName) {
        Object buId = map.get(paramName);
        if (null == buId) {
            return;
        }
        map.put(paramName, PayRollActGrpHelper.getLongValue(buId));
    }

    private static Long getLongValue(Object obj) {
        if (obj instanceof Integer) {
            if ((Integer)obj == 0) {
                return null;
            }
            return ((Integer)obj).longValue();
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        return null;
    }

    private static Boolean saveInsertList(Map<String, Long> numberIdMap, List<HRPolicyDTO> insertList) throws Exception {
        if (CollectionUtils.isEmpty(insertList)) {
            return Boolean.TRUE;
        }
        List<Map<String, Object>> insertMap = PayRollActGrpHelper.convertObjectToMap(insertList);
        LOGGER.info("\u5f00\u59cb\u8c03\u7528\u4e2d\u53f0\u5fae\u670d\u52a1IBRMPolicyService.batchAddPolicy\u65b0\u589e\u6570\u636e,insertMap = {}", (Object)SWCJSONUtils.toString(insertMap));
        Map requestResult = (Map)SWCMServiceUtils.invokeHRMPService((String)"brm", (String)"IBRMPolicyService", (String)"batchAddPolicy", (Object[])new Object[]{insertMap});
        if (SUCCESS_CODE.equals(String.valueOf(requestResult.get(RESULT_CODE)))) {
            if (null != numberIdMap) {
                numberIdMap.putAll(PayRollActGrpHelper.getSuccessNumberIdMap(requestResult));
            }
            return Boolean.TRUE;
        }
        throw new Exception(requestResult.get(ERROR_MSG).toString());
    }

    private static void dispatcherUpdatePolicy(List<HRPolicyDTO> updateList, DynamicObject[] query) {
        HashMap<Long, Map<String, Long>> ruleMap = new HashMap<Long, Map<String, Long>>(16);
        HashMap<Long, List<Long>> buIdMap = new HashMap<Long, List<Long>>(16);
        for (DynamicObject dy : query) {
            DynamicObjectCollection entryBuList;
            DynamicObjectCollection entryRuleList = dy.getDynamicObjectCollection("entryrulelist");
            if (!CollectionUtils.isEmpty((Collection)entryRuleList)) {
                HashMap<String, Long> tempMap = new HashMap<String, Long>(16);
                for (DynamicObject dynamicObject : entryRuleList) {
                    tempMap.put(dynamicObject.getString("rulenumber"), dynamicObject.getLong("id"));
                }
                ruleMap.put(dy.getLong("id"), tempMap);
            }
            if (CollectionUtils.isEmpty((Collection)(entryBuList = dy.getDynamicObjectCollection("entrybulist")))) continue;
            ArrayList<Long> buIdList = new ArrayList<Long>();
            for (DynamicObject dynamicObject : entryBuList) {
                buIdList.add(dynamicObject.getLong("id"));
            }
            buIdMap.put(dy.getLong("id"), buIdList);
        }
        for (HRPolicyDTO policy : updateList) {
            PayRollActGrpHelper.processRuleData(ruleMap, policy);
            PayRollActGrpHelper.processBuData(buIdMap, policy);
        }
    }

    private static void processBuData(Map<Long, List<Long>> buIdMap, HRPolicyDTO policy) {
        List<Long> buIds = buIdMap.get(policy.getId());
        List entryBuList = policy.getEntryBuList();
        if (CollectionUtils.isEmpty(buIds)) {
            for (HRUsableRangeDTO bu : entryBuList) {
                bu.setModifyStatus(NEW);
            }
            return;
        }
        ArrayList<Long> existBuIds = new ArrayList<Long>(10);
        Iterator<Object> iterator = entryBuList.iterator();
        while (iterator.hasNext()) {
            HRUsableRangeDTO bu;
            bu.setModifyStatus(buIds.contains((bu = (HRUsableRangeDTO)iterator.next()).getId()) ? MODIFY : NEW);
            existBuIds.add(bu.getId());
        }
        for (Long id : buIds) {
            if (existBuIds.contains(id)) continue;
            HRUsableRangeDTO tempRule = new HRUsableRangeDTO();
            tempRule.setId(id);
            tempRule.setModifyStatus(DELETE);
            entryBuList.add(tempRule);
        }
    }

    private static void processRuleData(Map<Long, Map<String, Long>> ruleIdMap, HRPolicyDTO policy) {
        Map<String, Long> ruleIds;
        ArrayList<HRRuleDTO> entryRuleList = policy.getEntryRuleList();
        if (entryRuleList == null) {
            entryRuleList = new ArrayList<HRRuleDTO>(10);
        }
        if (CollectionUtils.isEmpty(ruleIds = ruleIdMap.get(policy.getId()))) {
            for (HRRuleDTO ruleDTO : entryRuleList) {
                ruleDTO.setModifyStatus(NEW);
            }
            return;
        }
        ArrayList<String> existRuleIds = new ArrayList<String>(10);
        for (HRRuleDTO ruleDTO : entryRuleList) {
            String ruleNumber = ruleDTO.getRuleNumber();
            Long ruleId = ruleIds.get(ruleNumber);
            if (ruleId != null) {
                ruleDTO.setModifyStatus(MODIFY);
                ruleDTO.setId(ruleId);
            } else {
                ruleDTO.setModifyStatus(NEW);
            }
            existRuleIds.add(ruleNumber);
        }
        Set<Map.Entry<String, Long>> entrySet = ruleIds.entrySet();
        for (Map.Entry<String, Long> entry : entrySet) {
            if (existRuleIds.contains(entry.getKey())) continue;
            HRRuleDTO tempRule = new HRRuleDTO();
            tempRule.setId(entry.getValue());
            tempRule.setModifyStatus(DELETE);
            entryRuleList.add(tempRule);
        }
    }

    private static List<HRRuleDTO> getHrRuleFromEntity(DynamicObject policyDynamincObject) {
        DynamicObjectCollection entryRuleList = policyDynamincObject.getDynamicObjectCollection("entryrulelist");
        return PayRollActGrpHelper.getHrRuleFromEntity(entryRuleList, policyDynamincObject.getBoolean("enable"));
    }

    private static List<HRRuleDTO> getHrRuleFromEntity(DynamicObjectCollection entryRuleList, Boolean isRuleEnable) {
        ArrayList<HRRuleDTO> result = new ArrayList<HRRuleDTO>(10);
        if (CollectionUtils.isEmpty((Collection)entryRuleList)) {
            return result;
        }
        boolean isContainOrder = ((DynamicObject)entryRuleList.get(0)).getDataEntityType().getProperties().containsKey((Object)"ruleorder");
        for (int i = 0; i < entryRuleList.size(); ++i) {
            DynamicObject dy = (DynamicObject)entryRuleList.get(i);
            HRRuleDTO hrRule = new HRRuleDTO();
            hrRule.setFilterCondition(dy.getString("filtercondition"));
            hrRule.setFilterResult(dy.getString("filterresult"));
            hrRule.setRuleName(dy.getString("rulename"));
            hrRule.setRuleNumber(dy.getString("rulenumber"));
            if (isContainOrder) {
                hrRule.setRuleOrder(Integer.valueOf(dy.getInt("ruleorder")));
            } else {
                hrRule.setRuleOrder(Integer.valueOf(i + 1));
            }
            hrRule.setId(Long.valueOf(dy.getLong("id")));
            hrRule.setRuleEnable(isRuleEnable);
            result.add(hrRule);
        }
        return result.stream().sorted(Comparator.comparingInt(HRRuleDTO::getRuleOrder)).collect(Collectors.toList());
    }

    private static String processOperatorStr(String operator, String value) {
        RuleOperatorEnum operatorEnum = RuleOperatorEnum.getEnum((String)operator);
        if (null == operatorEnum) {
            return operator + ' ' + value;
        }
        String name = operatorEnum.getName();
        if (name.contains(REPLACE_STR)) {
            return name.replace(REPLACE_STR, ' ' + value + ' ');
        }
        if (SWCStringUtils.isEmpty((String)value)) {
            return name;
        }
        return name + ' ' + value;
    }

    public static List<TreeNode> getAllChildrenTreeNodeList(List<TreeNode> treeNodeList) {
        if (CollectionUtils.isEmpty(treeNodeList)) {
            return null;
        }
        ArrayList<TreeNode> result = new ArrayList<TreeNode>(10);
        for (TreeNode currentNode : treeNodeList) {
            List nextNode = currentNode.getChildren();
            if (CollectionUtils.isEmpty((Collection)nextNode)) continue;
            result.addAll(nextNode);
        }
        return result;
    }

    public static Integer isPolicyDataExist(IFormView view, String frPayRollActId, String frTriggerCollaId, String fieldKey, String policyNumber, Integer currentRow) {
        DynamicObject entryRowEntity = view.getModel().getEntryRowEntity("entryentity", currentRow.intValue());
        DynamicObjectCollection subEntryEntitys = entryRowEntity.getDynamicObjectCollection("fieldrulesubentryentity");
        if (CollectionUtils.isEmpty((Collection)subEntryEntitys)) {
            return -1;
        }
        for (int i = 0; i < subEntryEntitys.size(); ++i) {
            DynamicObject dy = (DynamicObject)subEntryEntitys.get(i);
            String dyFieldKey = dy.getString("frfieldkey");
            String dyPayRollActId = dy.getString("frpayrollact.id");
            String dyTriggerCollaId = dy.getString("frtriggercolla.id");
            if (!frPayRollActId.equals(dyPayRollActId) || !frTriggerCollaId.equals(dyTriggerCollaId) || !fieldKey.equals(dyFieldKey)) continue;
            return i;
        }
        return -1;
    }

    public static void writeBackExePreRulePolicyId(IFormView view, HRPolicyDTO policy) {
        if (policy == null) {
            return;
        }
        view.getModel().setValue("policy", (Object)policy.getId());
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            String tempNumber = (String)view.getModel().getValue("ruledesignnumber", i);
            if (SWCStringUtils.isEmpty((String)tempNumber)) {
                view.getModel().setValue("ruledesign", null, i);
                continue;
            }
            SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("brm_ruledesign");
            DynamicObject query = swcDataServiceHelper.queryOne(new QFilter[]{new QFilter("number", "=", (Object)tempNumber)});
            view.getModel().setValue("ruledesign", query == null ? null : query.getPkValue(), i);
        }
    }

    public static HRPolicyDTO getExePreRulePolicyFromCache(IFormView view) {
        String policyName;
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return null;
        }
        DynamicObject dataEntity = view.getModel().getDataEntity();
        HRPolicyDTO exePreRule = new HRPolicyDTO();
        String subName = policyName.substring(0, (policyName = String.valueOf(view.getModel().getValue("name"))).length() > 20 ? 19 : policyName.length());
        exePreRule.setBizAppId(PayRollActGrpHelper.getCurrentSceneAppId(view));
        exePreRule.setScene(PayRollActGrpHelper.getCurrentSceneId(view));
        exePreRule.setCreateBu(PayRollActGrpHelper.getCurrentCreateBuId(view));
        exePreRule.setPolicyMode("FullMatch");
        exePreRule.setEnable(PayRollActGrpHelper.getCurrentEnable(view));
        Long policyId = PayRollActGrpHelper.getCurrentPolicyId(view);
        if (null != policyId && policyId > 0L) {
            exePreRule.setId(policyId);
            exePreRule.setNumber(dataEntity.getString("policy.number"));
        } else {
            exePreRule.setNumber(PayRollActGrpHelper.newPolicyNumber());
        }
        exePreRule.setName(ResManager.loadKDString((String)"{0}-\u6267\u884c\u524d\u63d0-{1}", (String)"PayRollActGrpHelper_02", (String)"swc-hsas-business", (Object[])new Object[]{subName, exePreRule.getNumber().substring(5)}));
        List<HRRuleDTO> entryRuleList = PayRollActGrpHelper.getEntryRuleList(view, entryEntity);
        List<HRUsableRangeDTO> defaultEntryBuList = PayRollActGrpHelper.getDefaultEntryBuList(view);
        exePreRule.setEntryRuleList(entryRuleList);
        exePreRule.setEntryBuList(defaultEntryBuList);
        return exePreRule;
    }

    private static List<HRRuleDTO> getEntryRuleList(IFormView view, DynamicObjectCollection entryEntity) {
        SWCPageCache swcPageCache = new SWCPageCache(view);
        Map map = (Map)swcPageCache.get("CACHE_RULE_DESIGN_DATA", Map.class);
        ArrayList<HRRuleDTO> entryRuleList = new ArrayList<HRRuleDTO>(10);
        if (!CollectionUtils.isEmpty((Collection)entryEntity) && !CollectionUtils.isEmpty((Map)map)) {
            for (DynamicObject entity : entryEntity) {
                try {
                    HRRuleDTO rule;
                    String ruleNumber = entity.getString("ruledesignnumber");
                    String cacheData = (String)map.get(ruleNumber);
                    if (SWCStringUtils.isEmpty((String)cacheData) || null == (rule = (HRRuleDTO)SWCJSONUtils.cast((String)cacheData, HRRuleDTO.class))) continue;
                    rule.setId(Long.valueOf(entity.getLong("id")));
                    rule.setFilterResult(PayRollActGrpHelper.getDefaultResultString());
                    rule.setRuleEnable(Boolean.TRUE);
                    rule.setSceneId(PayRollActGrpHelper.getCurrentSceneId(view));
                    rule.setRuleOrder(Integer.valueOf(entryRuleList.size() + 1));
                    entryRuleList.add(rule);
                }
                catch (IOException e) {
                    LOGGER.info("\u89e3\u6790json\u5b57\u7b26\u4e32\u51fa\u9519\u3002", (Object)e);
                }
            }
        }
        return entryRuleList;
    }

    public static HRPolicyDTO getFullHrPolicyFromView(IFormView parentView, String policyPageId) {
        if (null == parentView || SWCStringUtils.isEmpty((String)policyPageId)) {
            return null;
        }
        IFormView policyView = parentView.getView(policyPageId);
        HRPolicyDTO policy = PayRollActGrpHelper.getHrPolicyFromPolicyConfigView(policyView);
        if (null == policy) {
            return null;
        }
        policy.setEnable(PayRollActGrpHelper.getCurrentEnable(parentView));
        policy.setBizAppId(PayRollActGrpHelper.getCurrentSceneAppId(parentView));
        policy.setCreateBu(PayRollActGrpHelper.getCurrentCreateBuId(parentView));
        policy.setPolicyMode("FirstMatch");
        policy.setScene(PayRollActGrpHelper.getCurrentSceneId(parentView));
        policy.setEntryBuList(PayRollActGrpHelper.getDefaultEntryBuList(parentView));
        return policy;
    }

    private static List<HRUsableRangeDTO> getHrEnableRangeFromEntity(DynamicObjectCollection buList) {
        ArrayList<HRUsableRangeDTO> result = new ArrayList<HRUsableRangeDTO>();
        if (CollectionUtils.isEmpty((Collection)buList)) {
            return result;
        }
        long rootOrgId = PayRollActGrpHelper.getHrRootId(((DynamicObject)buList.get(0)).getLong("entitybu.id"));
        for (DynamicObject dy : buList) {
            HRUsableRangeDTO usableRange = new HRUsableRangeDTO();
            usableRange.setEntityBu(Long.valueOf(rootOrgId));
            usableRange.setIsContainsSub(Boolean.valueOf(dy.getBoolean("containssub")));
            result.add(usableRange);
        }
        return result;
    }

    public static List<HRUsableRangeDTO> getDefaultEntryBuList(IFormView view) {
        ArrayList<HRUsableRangeDTO> entryBuList = new ArrayList<HRUsableRangeDTO>(10);
        HRUsableRangeDTO hrUsableRangeDTO = new HRUsableRangeDTO();
        hrUsableRangeDTO.setEntityBu(PayRollActGrpHelper.getHrRootId(view.getModel().getDataEntity().getLong("createOrg.id")));
        hrUsableRangeDTO.setIsContainsSub(Boolean.TRUE);
        entryBuList.add(hrUsableRangeDTO);
        return entryBuList;
    }

    private static Long getHrRootId(Long defaultOrgId) {
        return OrgServiceUtil.getHRRootOrgId();
    }

    public static List<TreeNode> getThirdLevelTreeNodeList(IFormView view) throws IOException {
        String fieldRuleCacheData = view.getPageCache().get("FIELD_RULE_TREE_DATA");
        if (SWCStringUtils.isEmpty((String)fieldRuleCacheData)) {
            return null;
        }
        List firstLeverTreeNodes = (List)SWCJSONUtils.cast((String)fieldRuleCacheData, List.class, (Class[])new Class[]{TreeNode.class});
        return PayRollActGrpHelper.getAllChildrenTreeNodeList(PayRollActGrpHelper.getAllChildrenTreeNodeList(firstLeverTreeNodes));
    }

    public static DynamicObject getPayRollActGrpTplById(long payrollactgtplId) {
        SWCDataServiceHelper payrollactgtplHelper = new SWCDataServiceHelper("hsas_payrollactgtpl");
        QFilter idFilter = new QFilter("id", "=", (Object)payrollactgtplId);
        return payrollactgtplHelper.queryOne("entryentity,entryentity.payrollact", new QFilter[]{idFilter});
    }

    public static DynamicObject[] getTriggerListByIds(List<Long> triggerIds) {
        SWCDataServiceHelper triggercollaOrm = new SWCDataServiceHelper("hsas_triggercolla");
        return triggercollaOrm.query("entityobject,paramentryentity.fieldkey,pfieldkey,pfieldname,pfieldtype,pismustinput,pissetrule", new QFilter[]{new QFilter("id", "in", triggerIds)});
    }

    public static void writeBackPolicyId(List<HRPolicyDTO> policyList, Map<String, Long> numberIdMap) {
        if (CollectionUtils.isEmpty(policyList) || CollectionUtils.isEmpty(numberIdMap)) {
            return;
        }
        for (HRPolicyDTO policy : policyList) {
            policy.setId(numberIdMap.get(policy.getNumber()));
        }
    }

    private static List<String> findObjectByCurrentFieldRuleNode(IFormView view) {
        String fieldMapTreeStr = view.getPageCache().get("FIELD_MAP_TREE_DATA");
        String isFieldMapEnabled = view.getPageCache().get("IS_FIELD_MAP_ENABLED_DATA");
        TreeView fieldMapTree = (TreeView)view.getControl("fieldmaptree");
        String nodeId = fieldMapTree.getTreeState().getFocusNodeId();
        List treeNodes = new ArrayList(10);
        try {
            treeNodes = (List)SWCJSONUtils.cast((String)fieldMapTreeStr, List.class, (Class[])new Class[]{TreeNode.class});
        }
        catch (IOException e) {
            LOGGER.info("\u89e3\u6790\u5b57\u6bb5\u89c4\u5219json\u5b57\u7b26\u4e32\u5931\u8d25\u3002", (Object)e);
            return null;
        }
        JSONObject fieldMapEnabledData = JSONObject.parseObject((String)isFieldMapEnabled);
        if (CollectionUtils.isEmpty(treeNodes) || SWCStringUtils.isEmpty((String)isFieldMapEnabled)) {
            return null;
        }
        TreeNode treeNode = null;
        for (TreeNode tempTreeNode : treeNodes) {
            if (!nodeId.equals(tempTreeNode.getId())) continue;
            treeNode = tempTreeNode;
            break;
        }
        if (treeNode == null) {
            return null;
        }
        JSONObject map = fieldMapEnabledData.getJSONObject(treeNode.getId().split("#")[1]);
        ArrayList<String> ids = new ArrayList<String>(10);
        DynamicObject payRollActDyObj = DynamicObjectJsonSerializer.parseDynamicObjectJson((String)treeNode.getData().toString(), (String)"hsas_payrollact");
        DynamicObjectCollection payRollActEntryEntity = payRollActDyObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryEntity : payRollActEntryEntity) {
            DynamicObject triggerColla = entryEntity.getDynamicObject("triggercolla");
            Long triggerId = triggerColla.getLong("id");
            JSONObject trigger = map.getJSONObject(String.valueOf(triggerId));
            if (!trigger.getBooleanValue("isMust")) continue;
            ids.add(String.valueOf(trigger.getString("objectId")));
        }
        return ids;
    }

    public static List<QFilter> getFiledMapObjctFilter(IFormView view, Integer row) {
        int count = view.getModel().getEntryRowCount("fieldmapviewentryentity");
        if (count == 0 || row < 0) {
            return null;
        }
        List<String> ids = PayRollActGrpHelper.findObjectByCurrentFieldRuleNode(view);
        ArrayList notInIds = new ArrayList(10);
        for (int i = 0; i < count; ++i) {
            DynamicObject fieldMapObjecs;
            DynamicObjectCollection dynamicObjectCollection;
            if (row.equals(i) || CollectionUtils.isEmpty((Collection)(dynamicObjectCollection = (fieldMapObjecs = view.getModel().getEntryRowEntity("fieldmapviewentryentity", i)).getDynamicObjectCollection("actgfieldmapobjview")))) continue;
            notInIds.addAll(dynamicObjectCollection.stream().map(obj -> obj.getString("fbasedataid.id")).collect(Collectors.toList()));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("id", "in", ids));
        filters.add(new QFilter("id", "not in", notInIds));
        return filters;
    }

    public static List<TreeNode> getAllTreeNodes(List<TreeNode> treeNodes) {
        LinkedList<TreeNode> allTreeNodes = new LinkedList<TreeNode>();
        for (TreeNode treeNode : treeNodes) {
            allTreeNodes.add(treeNode);
            if (null == treeNode.getChildren()) continue;
            allTreeNodes.addAll(PayRollActGrpHelper.getAllTreeNodes(treeNode.getChildren()));
        }
        return allTreeNodes;
    }

    public static void putPolicyPageMapCache(IFormView view, String nodeId, String pageId) {
        SWCPageCache swcPageCache = new SWCPageCache(view);
        HashMap<String, String> map = (HashMap<String, String>)swcPageCache.get("CACHE_NODE_PAGE_ID_MAP", Map.class);
        if (CollectionUtils.isEmpty((Map)map)) {
            map = new HashMap<String, String>(16);
        }
        map.put(nodeId, pageId);
        swcPageCache.put("CACHE_NODE_PAGE_ID_MAP", map);
    }

    public static String getPageIdByNodeIdFromCache(IFormView view, String nodeId) {
        SWCPageCache swcPageCache = new SWCPageCache(view);
        Map map = (Map)swcPageCache.get("CACHE_NODE_PAGE_ID_MAP", Map.class);
        if (!CollectionUtils.isEmpty((Map)map)) {
            return (String)map.get(nodeId);
        }
        return null;
    }

    public static Integer getRowIndexByPayRollActId(IFormView view, String payRollActId) {
        if (SWCStringUtils.isEmpty((String)payRollActId)) {
            return null;
        }
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return null;
        }
        Integer index = null;
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = ((DynamicObject)entryEntity.get(i)).getDynamicObject("payrollact");
            if (null == dynamicObject || !payRollActId.equals(String.valueOf(dynamicObject.getPkValue()))) continue;
            index = i;
            break;
        }
        return index;
    }

    public static Boolean validPolicyResults(HRPolicyDTO policy) {
        if (null == policy || null == policy.getIsDefaultResult() || !policy.getIsDefaultResult().booleanValue()) {
            return Boolean.TRUE;
        }
        String results = policy.getResults();
        if (SWCStringUtils.isEmpty((String)results)) {
            return Boolean.FALSE;
        }
        Map jsonToMap = null;
        try {
            jsonToMap = (Map)SWCJSONUtils.cast((String)results, Map.class);
        }
        catch (IOException e) {
            LOGGER.info("[payrollact] json parse error.", (Object)e.getMessage());
        }
        if (jsonToMap == null) {
            return Boolean.FALSE;
        }
        List resultList = (List)jsonToMap.get("resultList");
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return Boolean.FALSE;
        }
        for (Map map : resultList) {
            String value;
            String operators;
            String param = PayRollActGrpHelper.getJsonStringValue(map, "param");
            if (!PayRollActGrpHelper.isAnyEmpty(param, operators = PayRollActGrpHelper.getJsonStringValue(map, "operators"), value = PayRollActGrpHelper.getJsonStringValue(map, "value"))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static String getJsonStringValue(Map<String, Object> map, String param) {
        return map.get(param) == null ? null : String.valueOf(map.get(param));
    }

    private static boolean isAnyEmpty(String ... params) {
        if (null == params || params.length < 1) {
            return true;
        }
        for (int i = 0; i < params.length; ++i) {
            if (!SWCStringUtils.isEmpty((String)params[i])) continue;
            return true;
        }
        return false;
    }

    public static Map<Long, Map<Long, Map<String, Object>>> getAllTriggerCollaIsFiledMaps(IFormView view) {
        if (view == null) {
            return new HashMap<Long, Map<Long, Map<String, Object>>>(16);
        }
        return PayRollActGrpHelper.getAllTriggerCollaIsFiledMaps(view.getModel().getDataEntity().getDynamicObjectCollection("entryentity"));
    }

    public static Map<Long, Map<Long, Map<String, Object>>> getAllTriggerCollaIsFiledMaps(DynamicObjectCollection entryEntity) {
        DynamicObject[] triggetCollaDyobjs;
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return new HashMap<Long, Map<Long, Map<String, Object>>>(16);
        }
        List payRollActIds = entryEntity.stream().map(dy -> dy.getLong("payrollact.id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(payRollActIds)) {
            return new HashMap<Long, Map<Long, Map<String, Object>>>(16);
        }
        SWCDataServiceHelper payRollActOrm = new SWCDataServiceHelper("hsas_payrollact");
        DynamicObject[] payRollActDyObjs = payRollActOrm.query("issyspreset, entryentity.triggercolla", new QFilter[]{new QFilter("id", "in", payRollActIds)});
        if (null == payRollActDyObjs || payRollActDyObjs.length == 0) {
            return new HashMap<Long, Map<Long, Map<String, Object>>>(16);
        }
        ArrayList<Long> triggerCollaIds = new ArrayList<Long>(10);
        HashMap<Long, Map<Long, Map<String, Object>>> resultMap = new HashMap<Long, Map<Long, Map<String, Object>>>(16);
        for (DynamicObject dynamicObject : payRollActDyObjs) {
            DynamicObjectCollection triggerCollas = dynamicObject.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)triggerCollas)) {
                resultMap.put((Long)dynamicObject.getPkValue(), null);
                continue;
            }
            HashMap<Long, Object> subMap = new HashMap<Long, Object>(16);
            for (DynamicObject tc : triggerCollas) {
                Long tcId = tc.getLong("triggercolla.id");
                triggerCollaIds.add(tcId);
                subMap.put(tcId, null);
            }
            resultMap.put((Long)dynamicObject.getPkValue(), subMap);
        }
        HashMap triggerCollaIsMustFieldMapRel = new HashMap(16);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_triggercolla");
        for (DynamicObject triggerCollaDyobj : triggetCollaDyobjs = serviceHelper.query("ismustfieldmapping,entityobject", new QFilter[]{new QFilter("id", "in", triggerCollaIds)})) {
            HashMap<String, Object> subMap = new HashMap<String, Object>(16);
            subMap.put("isMust", "1".equals(triggerCollaDyobj.getString("ismustfieldmapping")));
            triggerCollaDyobj.get("entityobject.id");
            subMap.put("objectId", triggerCollaDyobj.getString("entityobject.id"));
            triggerCollaIsMustFieldMapRel.put(triggerCollaDyobj.getLong("id"), subMap);
        }
        resultMap.forEach((key, value) -> {
            Map map = (Map)resultMap.get(key);
            if (null != map) {
                map.forEach((subKey, subValue) -> {
                    Map cfr_ignored_0 = (Map)map.replace(subKey, triggerCollaIsMustFieldMapRel.get(subKey));
                });
            }
        });
        return resultMap;
    }

    public static List<TreeNode> getChildPathNodesByNodeId(IFormView view, String nodeId) {
        return PayRollActGrpHelper.getChildPathNodesByNodeId(view, nodeId, null);
    }

    public static List<TreeNode> getChildPathNodesByNodeId(IFormView view, String nodeId, String fieldRuleTreeStr) {
        ArrayList<TreeNode> result = new ArrayList<TreeNode>(10);
        try {
            if (SWCStringUtils.isEmpty((String)fieldRuleTreeStr)) {
                fieldRuleTreeStr = view.getPageCache().get("FIELD_RULE_TREE_DATA");
            }
            if (SWCStringUtils.isEmpty((String)fieldRuleTreeStr)) {
                return result;
            }
            List treeNodes = (List)SWCJSONUtils.cast((String)fieldRuleTreeStr, List.class, (Class[])new Class[]{TreeNode.class});
            if (CollectionUtils.isEmpty((Collection)treeNodes)) {
                return result;
            }
            for (TreeNode node : treeNodes) {
                List tempChildPathNodes = node.getChildPathNodes(nodeId);
                if (CollectionUtils.isEmpty((Collection)tempChildPathNodes)) continue;
                return tempChildPathNodes;
            }
        }
        catch (IOException e) {
            LOGGER.info("\u89e3\u6790\u6811\u5f62\u8282\u70b9json\u6570\u636e\u5931\u8d25\u3002", (Object)e);
        }
        return result;
    }

    public static List<DynamicObject> findPayRollActSettingEntry(IFormView view, List<Long> payRollActIds) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        if (CollectionUtils.isEmpty(payRollActIds)) {
            return result;
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_payrollactgtpl");
        QFilter idFilter = new QFilter("id", "=", (Object)view.getModel().getDataEntity().getLong("payrollactgtpl.id"));
        DynamicObject payRollActgTplObj = serviceHelper.queryOne("entryentity,entryentity.ismustexecute,entryentity.executeseq,entryentity.ispayrollactsyspreset,entryentity.payrollact", new QFilter[]{idFilter});
        if (null == payRollActgTplObj) {
            return result;
        }
        DynamicObjectCollection tempObjs = payRollActgTplObj.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)tempObjs)) {
            return result;
        }
        DynamicObjectCollection tempEntryEntitys = view.getModel().getEntryEntity("entryentity");
        Set pagePayRollActIdSet = tempEntryEntitys.stream().map(item -> item.getLong("payrollact.id")).collect(Collectors.toSet());
        pagePayRollActIdSet.addAll(payRollActIds);
        List<DynamicObject> entryEntitys = tempObjs.stream().filter(item -> pagePayRollActIdSet.contains(item.getLong("payrollact.id"))).collect(Collectors.toList());
        return entryEntitys;
    }

    private static boolean isPayRollActMustFieldMap(DynamicObject payRollActDyobj, Map<String, Boolean> triggerCollaIsMustFieldMapRel) {
        boolean isMust = false;
        DynamicObjectCollection triggerCollas = payRollActDyobj.getDynamicObjectCollection("entryentity");
        for (DynamicObject triggerColla : triggerCollas) {
            if (isMust) break;
            Boolean tempData = triggerCollaIsMustFieldMapRel.get(triggerColla.getString("triggercolla.id"));
            if (tempData == null) continue;
            isMust = tempData;
        }
        return isMust;
    }

    private static Map<String, Boolean> getTriggerCollaIsMustFieldMap(DynamicObject[] payRollActDyobjs) {
        DynamicObject[] triggetCollaDyobjs;
        ArrayList triggerCollaIds = new ArrayList(10);
        Arrays.asList(payRollActDyobjs).forEach(payRollActDyobj -> {
            DynamicObjectCollection triggerCollaDyobjs = payRollActDyobj.getDynamicObjectCollection("entryentity");
            triggerCollaDyobjs.forEach(triggerCollaDyobj -> triggerCollaIds.add(triggerCollaDyobj.getLong("triggercolla.id")));
        });
        HashMap<String, Boolean> triggerCollaIsMustFieldMapRel = new HashMap<String, Boolean>(16);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_triggercolla");
        QFilter qFilter = new QFilter("id", "in", triggerCollaIds);
        for (DynamicObject triggerCollaDyobj : triggetCollaDyobjs = serviceHelper.query("ismustfieldmapping", new QFilter[]{qFilter})) {
            triggerCollaIsMustFieldMapRel.put(triggerCollaDyobj.getString("id"), "1".equals(triggerCollaDyobj.getString("ismustfieldmapping")));
        }
        return triggerCollaIsMustFieldMapRel;
    }

    public static Table<String, String, Boolean> getPayRollActProps(DynamicObjectCollection tplEntryentities) {
        HashBasedTable payRollActProps = HashBasedTable.create();
        List payRollActIds = tplEntryentities.stream().map(tplEntryentity -> tplEntryentity.getLong("payrollact.id")).collect(Collectors.toList());
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_payrollact");
        QFilter qFilter = new QFilter("id", "in", payRollActIds);
        DynamicObject[] payRollActDyobjs = serviceHelper.query("issyspreset, entryentity.triggercolla", new QFilter[]{qFilter});
        if (null != payRollActDyobjs) {
            Map<String, Boolean> triggerCollaIsMustFieldMapRel = PayRollActGrpHelper.getTriggerCollaIsMustFieldMap(payRollActDyobjs);
            for (DynamicObject payRollActDyobj : payRollActDyobjs) {
                payRollActProps.put((Object)payRollActDyobj.getString("id"), (Object)"issyspreset", (Object)payRollActDyobj.getBoolean("issyspreset"));
                if (PayRollActGrpHelper.isPayRollActMustFieldMap(payRollActDyobj, triggerCollaIsMustFieldMapRel)) continue;
                payRollActProps.put((Object)payRollActDyobj.getString("id"), (Object)"ismustfieldmapping", (Object)Boolean.FALSE);
            }
        }
        return payRollActProps;
    }

    public static Set<Long> getApiIds(String msgSubNo) {
        List apiInfos = (List)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSMsgService", (String)"getAPIInfoByMsgSubNo", (Object[])new Object[]{msgSubNo});
        LOGGER.info("\u8c03\u7528IHRCSMsgService.getAPIInfoByMsgSubNo()\u7684\u6d88\u606f\u7ed3\u679c\u4e3a\uff1a{}", (Object)apiInfos);
        HashSet<Long> apiIds = null;
        if (null != apiInfos) {
            apiIds = new HashSet<Long>(apiInfos.size());
            if (!apiInfos.isEmpty()) {
                for (Map apiInfo : apiInfos) {
                    String apiInfoId = (String)apiInfo.get("id");
                    if (SWCStringUtils.isEmpty((String)apiInfoId)) continue;
                    apiIds.add(Long.parseLong(apiInfoId));
                }
            }
        }
        return apiIds;
    }

    public static DynamicObject querySceneByMsgSubscriberId(Long msgSubscriberId) {
        SWCDataServiceHelper msgSceneOrm = new SWCDataServiceHelper("hsas_msgscene");
        return msgSceneOrm.queryOne("msgsubscriber,scene", new QFilter[]{new QFilter("msgsubscriber", "=", (Object)msgSubscriberId)});
    }

    public static Long getCurrentCreateBuId(IFormView view) {
        return view.getModel().getDataEntity().getLong("createorg.id");
    }

    public static String getCurrentSceneAppId(IFormView view) {
        return view.getModel().getDataEntity().getString("scene.bizappid.id");
    }

    public static Long getCurrentSceneId(IFormView view) {
        return view.getModel().getDataEntity().getLong("scene.id");
    }

    public static Long getCurrentPolicyId(IFormView view) {
        return view.getModel().getDataEntity().getLong("policy.id");
    }

    public static Boolean getCurrentEnable(IFormView view) {
        DynamicObject dataEntity;
        String status;
        if (null == view) {
            return Boolean.FALSE;
        }
        String name = view.getModel().getDataEntity().getDataEntityType().getName();
        if ("hsas_payrollactg".equalsIgnoreCase(name) ? "C".equalsIgnoreCase(status = (dataEntity = view.getModel().getDataEntity()).getString("status")) : "hsas_payrollactghis".equalsIgnoreCase(name) && "1".equalsIgnoreCase(status = (dataEntity = view.getModel().getDataEntity()).getString("datastatus"))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static HRPolicyDTO getHrPolicyFromSubEntity(IFormView view, String nodeId) {
        int entryCount = view.getModel().getEntryRowCount("entryentity");
        ArrayList tempFieldRuleEntryEntityList = new ArrayList(10);
        for (int i = 0; i < entryCount; ++i) {
            DynamicObject entryRowEntity = view.getModel().getEntryRowEntity("entryentity", i);
            DynamicObjectCollection fieldRuleEntry = entryRowEntity.getDynamicObjectCollection("fieldrulesubentryentity");
            if (CollectionUtils.isEmpty((Collection)fieldRuleEntry)) continue;
            tempFieldRuleEntryEntityList.addAll(fieldRuleEntry);
        }
        if (CollectionUtils.isEmpty(tempFieldRuleEntryEntityList)) {
            return null;
        }
        for (DynamicObject dynamicObject : tempFieldRuleEntryEntityList) {
            String payRollActId = dynamicObject.getString("frpayrollact.id");
            String triggerCollaId = dynamicObject.getString("frtriggercolla.id");
            String object = dynamicObject.getString("frtriggercolla.entityobject.id");
            String fieldKeyId = dynamicObject.getString("frfieldkey");
            String key = "L3#" + String.join((CharSequence)"#", payRollActId, triggerCollaId, object, fieldKeyId);
            if (!nodeId.equalsIgnoreCase(key)) continue;
            DynamicObject policy = dynamicObject.getDynamicObject("frpolicy");
            if (policy == null) {
                return null;
            }
            DynamicObject databaseData = new SWCDataServiceHelper("brm_policy_edit").queryOne(SWCHisBaseDataHelper.getSelectProperties((String)"brm_policy_edit"), policy.getPkValue());
            if (databaseData == null) {
                return null;
            }
            return PayRollActGrpHelper.convertBrmPolicyDynamicToHrPolicy(databaseData);
        }
        return null;
    }

    public static KDException getDefaultException(Exception exception) {
        return new KDBizException((Throwable)exception, PayRollActGrpHelper.getDefaultErrorCode(), new Object[0]);
    }

    public static ErrorCode getDefaultErrorCode() {
        return new ErrorCode("PayRollActGrpHelper.DefaultException", ResManager.loadKDString((String)"\u64cd\u4f5c\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"PayRollActGrpHelper_01", (String)"swc-hsas-business", (Object[])new Object[0]));
    }

    public static boolean isValueNull(IFormView view, String fieldName) {
        if (view == null || SWCStringUtils.isEmpty((String)fieldName)) {
            return true;
        }
        Object object = view.getModel().getDataEntity().get(fieldName);
        if (object instanceof DynamicObjectCollection) {
            return CollectionUtils.isEmpty((Collection)((DynamicObjectCollection)object));
        }
        if (object instanceof String) {
            return SWCStringUtils.isEmpty((String)((String)object));
        }
        return object == null;
    }

    public static RuleValidateInfo validate(RuleControl ruleControl) {
        return ruleControl.validate();
    }

    public static List<Long> getAllPolicyIds(DynamicObject[] payRollActGrpObject) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (int i = 0; i < payRollActGrpObject.length; ++i) {
            DynamicObjectCollection entryEntity;
            DynamicObject tempPayRollActGrp = payRollActGrpObject[i];
            Long exePrePolicyId = tempPayRollActGrp.getLong("policy.id");
            if (null != exePrePolicyId) {
                ids.add(exePrePolicyId);
            }
            if (CollectionUtils.isEmpty((Collection)(entryEntity = tempPayRollActGrp.getDynamicObjectCollection("entryentity")))) continue;
            ids.addAll(PayRollActGrpHelper.getAllSubPolicy(entryEntity));
        }
        return ids;
    }

    private static List<Long> getAllSubPolicy(DynamicObjectCollection entryEntity) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (DynamicObject entry : entryEntity) {
            List ids;
            DynamicObjectCollection fieldRuleEntry = entry.getDynamicObjectCollection("fieldrulesubentryentity");
            if (CollectionUtils.isEmpty((Collection)fieldRuleEntry) || CollectionUtils.isEmpty(ids = fieldRuleEntry.stream().map(item -> item.getLong("frpolicy.id")).distinct().collect(Collectors.toList()))) continue;
            result.addAll(ids);
        }
        return result;
    }

    static {
        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("bos_devportal_bizapp");
        DynamicObject queryOne = swcDataServiceHelper.queryOne("id", new QFilter[]{new QFilter("number", "=", (Object)"hsas")});
        BIZ_APP_ID = queryOne.getString("id");
    }
}

