/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cost.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCCostConstants;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CostAllotHelper {
    public static boolean isOwnCostSetUp(Long calTaskId) {
        QFilter qFilter = CostAllotHelper.getCostSetUpPartitionFilter(calTaskId);
        SWCDataServiceHelper costSetUpHelper = new SWCDataServiceHelper("pcs_costsetuprst");
        boolean flag = costSetUpHelper.isExists(new QFilter[]{qFilter});
        return flag;
    }

    public static DynamicObject queryCostAllotByCalTaskId(Long calTaskId) {
        SWCDataServiceHelper costAllocationHelper = new SWCDataServiceHelper("pcs_allottask");
        return costAllocationHelper.queryOne("id,caltask,costtaskstatus", new QFilter[]{new QFilter("caltask.id", "=", (Object)calTaskId)});
    }

    private static QFilter getCostSetUpPartitionFilter(Long calTaskId) {
        SWCDataServiceHelper calTaskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject calTaskDy = calTaskHelper.queryOne("payrollgroup.costadaption.id,payrolldate", new QFilter[]{new QFilter("id", "=", (Object)calTaskId)});
        Date payrollDate = calTaskDy.getDate("payrolldate");
        QFilter qFilter = new QFilter("belongperiod", "=", (Object)payrollDate);
        qFilter.and(new QFilter("caltask.id", "=", (Object)calTaskId));
        DynamicObject costAdapterObj = CostAllotHelper.queryCostAdapterIdByCalTaskId(calTaskId);
        if (costAdapterObj != null) {
            long costAdapterId = costAdapterObj.getLong("id");
            SWCDataServiceHelper adaptionHelper = new SWCDataServiceHelper("lcs_costadaption");
            DynamicObject adaptionDy = adaptionHelper.queryOne("createorg.id", new QFilter[]{new QFilter("id", "=", (Object)costAdapterId)});
            long createOrgId = adaptionDy.getLong("createorg.id");
            qFilter.and(new QFilter("hrorg.id", "=", (Object)createOrgId));
        }
        return qFilter;
    }

    public static boolean isOwnErrorCostSetUp(Long calTaskId) {
        QFilter qFilter = CostAllotHelper.getCostSetUpPartitionFilter(calTaskId);
        qFilter.and(new QFilter("enable", "=", (Object)"0"));
        SWCDataServiceHelper costSetUpHelper = new SWCDataServiceHelper("pcs_costsetuprst");
        boolean flag = costSetUpHelper.isExists(new QFilter[]{qFilter});
        return flag;
    }

    public static Map<Long, DynamicObject> getSalaryItemIdListByCalTaskId(Long calTaskId) {
        DynamicObject[] queryOriginalArray;
        DynamicObject calTaskObj = CostAllotHelper.queryCalPalRollTaskObj(calTaskId);
        Long calRuleHisId = calTaskObj.getLong("calrulev.id");
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_calrule");
        DynamicObject calRuleHisObj = serviceHelper.queryOne("salaryitem,iscostallot", (Object)calRuleHisId);
        DynamicObjectCollection calRuleItemEntryColl = calRuleHisObj.getDynamicObjectCollection("calruleitementry");
        HashMap<Long, DynamicObject> salaryItemIdRefIsCostallotCostMap = new HashMap<Long, DynamicObject>(calRuleItemEntryColl.size());
        ArrayList salaryfileItemIdList = new ArrayList(calRuleItemEntryColl.size());
        calRuleItemEntryColl.forEach(calRuleItemEntry -> {
            if (calRuleItemEntry.getBoolean("iscostallot")) {
                salaryfileItemIdList.add(calRuleItemEntry.getLong("salaryitem.id"));
            }
        });
        if (salaryfileItemIdList.isEmpty()) {
            return salaryItemIdRefIsCostallotCostMap;
        }
        serviceHelper.setEntityName("hsbs_salaryitem");
        for (DynamicObject salaryfileItem : queryOriginalArray = serviceHelper.queryOriginalArray("id,name", new QFilter[]{new QFilter("id", "in", salaryfileItemIdList)})) {
            salaryItemIdRefIsCostallotCostMap.put(salaryfileItem.getLong("id"), salaryfileItem);
        }
        return salaryItemIdRefIsCostallotCostMap;
    }

    public static DynamicObject queryCalPalRollTaskObj(Long calTaskId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject calTaskObj = serviceHelper.queryOne("calrulev.id,org.id,payrollgroup.id", (Object)calTaskId);
        return calTaskObj;
    }

    public static Date queryCostAllocationModifyDate(Long calTaskId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costallocation");
        DynamicObject costAllocation = serviceHelper.queryOriginalOne("modifytime", new QFilter[]{new QFilter("caltask.id", "=", (Object)calTaskId)});
        return costAllocation.getDate("modifytime");
    }

    public static boolean existCreatedAllotDetailByTaskId(Long calTaskIds) {
        QFilter calPersonFilter = new QFilter("caltask", "in", (Object)calTaskIds);
        calPersonFilter.and(new QFilter("allotstatus", "=", (Object)"B"));
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        return calPersonHelper.isExists(new QFilter[]{calPersonFilter});
    }

    public static boolean costCfgModifyTimeIsLaterThanCostAllocationModifyDate(Long costAdapterId, Date costAllocationModifyDate) {
        SWCDataServiceHelper costSetupRstHelper = new SWCDataServiceHelper("pcs_costcfg");
        QFilter commonFilter = new QFilter("costadapter.id", "=", (Object)costAdapterId);
        commonFilter.and(new QFilter("sourcetype.id", "in", (Object)new long[]{SWCCostConstants.COST_TYPE_DEPT, SWCCostConstants.COST_TYPE_POST, SWCCostConstants.COST_TYPE_EMP, SWCCostConstants.COST_TYPE_SALARYFILE, SWCCostConstants.COST_TYPE_ITEM, SWCCostConstants.COST_TYPE_SALARYFILEITEM}));
        commonFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        commonFilter.and(new QFilter("modifytime", ">", (Object)costAllocationModifyDate));
        commonFilter.and(new QFilter("iscurrentversion", "=", (Object)"0"));
        return costSetupRstHelper.isExists(new QFilter[]{commonFilter});
    }

    public static DynamicObject queryCostAdapterIdByCalTaskId(Long calTaskId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject calTaskObj = serviceHelper.queryOne("payrollgroupv", (Object)calTaskId);
        Long payrollGroupVid = calTaskObj.getLong("payrollgroupv.id");
        serviceHelper.setEntityName("pcs_costadaptionmap");
        DynamicObject dynamicObject = serviceHelper.queryOne("costadaption", new QFilter[]{new QFilter("mapobj", "=", (Object)SWCCostConstants.MAPOBJ_PAYROLLGROUP), new QFilter("source", "=", (Object)payrollGroupVid), new QFilter("status", "=", (Object)"C")}, "modifytime desc");
        return dynamicObject == null ? null : dynamicObject.getDynamicObject("costadaption");
    }

    public static boolean validateCert(CalPayRollTask calPayRollTask) {
        String groupIdByBizObjID = HRCertCommonHelper.getGroupIdByBizObjID((String)"1ANC8T4UC434", (String)"pcs_allotdetail");
        if (SWCStringUtils.isEmpty((String)groupIdByBizObjID)) {
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            return false;
        }
        return true;
    }
}

