/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.datagrade.helper;

import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.swc.hsbp.business.datagrade.enums.DataGradeValueTypeEnum;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class DataGradeHelper {
    public Boolean checkConditionRequired(DynamicObjectCollection conditionDatas, IFormView view) {
        int size = conditionDatas.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject currencyObj;
            DynamicObject dataObj = (DynamicObject)conditionDatas.get(i);
            String name = dataObj.getString("conditionitemname");
            if (SWCStringUtils.isEmpty((String)name)) {
                String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u7b2c%s\u884c\uff0c\u6761\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataGradeBaseEdit_26", (String)"swc-hsas-formplugin", (Object[])new Object[0]), i + 1);
                view.showTipNotification(msg);
                return Boolean.TRUE;
            }
            DynamicObject valTypeObj = dataObj.getDynamicObject("conditionvaltype");
            if (SWCObjectUtils.isEmpty((Object)valTypeObj)) {
                String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u7b2c%s\u884c\uff0c\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataGradeBaseEdit_27", (String)"swc-hsas-formplugin", (Object[])new Object[0]), i + 1);
                view.showTipNotification(msg);
                return Boolean.TRUE;
            }
            String number = valTypeObj.getString("number");
            if (SWCStringUtils.isEmpty((String)number)) {
                return Boolean.TRUE;
            }
            String valueType = this.getValueTypeDesc(number);
            if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DECIMAL.getDesc())) {
                String accuracy = dataObj.getString("conditionaccuracy");
                if (!SWCStringUtils.isEmpty((String)accuracy)) continue;
                String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u7b2c%s\u884c\uff0c\u6570\u636e\u7cbe\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataGradeBaseEdit_28", (String)"swc-hsas-formplugin", (Object[])new Object[0]), i + 1);
                view.showTipNotification(msg);
                return Boolean.TRUE;
            }
            if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.TEXT.getDesc())) {
                Integer length = dataObj.getInt("conditionlength");
                if (!SWCObjectUtils.isEmpty((Object)length) && length != 0) continue;
                String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u7b2c%s\u884c\uff0c\u6570\u636e\u957f\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataGradeBaseEdit_29", (String)"swc-hsas-formplugin", (Object[])new Object[0]), i + 1);
                view.showTipNotification(msg);
                return Boolean.TRUE;
            }
            if (!SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.AMOUNT.getDesc()) || !SWCObjectUtils.isEmpty((Object)(currencyObj = dataObj.getDynamicObject("conditioncurrency")))) continue;
            String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u7b2c%s\u884c\uff0c\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a", (String)"DataGradeBaseEdit_39", (String)"swc-hsas-formplugin", (Object[])new Object[0]), i + 1);
            view.showTipNotification(msg);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public String getValueTypeDesc(String number) {
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
            return DataGradeValueTypeEnum.DECIMAL.getDesc();
        }
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.AMOUNT.getCode())) {
            return DataGradeValueTypeEnum.AMOUNT.getDesc();
        }
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.TEXT.getCode())) {
            return DataGradeValueTypeEnum.TEXT.getDesc();
        }
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.INTEGER.getCode())) {
            return DataGradeValueTypeEnum.INTEGER.getDesc();
        }
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.DATE.getCode())) {
            return DataGradeValueTypeEnum.DATE.getDesc();
        }
        return null;
    }
}

