/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.dataport;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.sdk.swc.hsas.common.entity.ImportEntityRel;
import kd.swc.hsas.business.dataport.IPersonImportPlugin;
import kd.swc.hsas.business.dataport.PersonImportHelper;
import kd.swc.hsas.business.dataport.PersonImportLogger;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PersonImportConfig
implements Serializable {
    private static final long serialVersionUID = -5794864523728826409L;
    private static Log log = LogFactory.getLog(PersonImportConfig.class);
    public static final int BATCH_IMPORT_SIZE = 5000;
    private static final int IMPORT_MULTIPLY_SIZE = 3;
    public static final String IMPORT_CACHE_KEY = "Cached_Import_Logger";
    private IFormView formView;
    private Object logId;
    private Map<String, LinkedBlockingQueue<ImportBillData>> dataQueues = new HashMap<String, LinkedBlockingQueue<ImportBillData>>(16);
    private Map<String, PersonImportLogger> urlLoggers = new HashMap<String, PersonImportLogger>(16);
    private Set<String> completeUrls = new HashSet<String>(16);
    private ImportEntityRel importEntityRel;
    private List<IPersonImportPlugin> importPlugins = new ArrayList<IPersonImportPlugin>(10);

    public PersonImportConfig(IFormView formView, Object logId, String url, String mainEntityId) {
        this.formView = formView;
        this.logId = logId;
        this.importEntityRel = this.getImportEntityRelByMainEntityId(mainEntityId);
        this.urlLoggers.put(url, new PersonImportLogger(url));
        this.dataQueues.put(url, new LinkedBlockingQueue(15000));
        this.loadImportPlugins(mainEntityId);
    }

    private void loadImportPlugins(String mainEntityId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsbs_importplugin");
        QFilter qFilter = new QFilter("bizobject.number", "=", (Object)mainEntityId);
        DynamicObject dyobj = serviceHelper.queryOne("entryentity.enabled, entryentity.classname", new QFilter[]{qFilter});
        if (null != dyobj) {
            DynamicObjectCollection entryentities = dyobj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryentity : entryentities) {
                if (!entryentity.getBoolean("enabled")) continue;
                this.addImportPlugin(entryentity);
            }
        }
    }

    private void addImportPlugin(DynamicObject entryentity) {
        String className = entryentity.getString("classname");
        try {
            IPersonImportPlugin plugin = (IPersonImportPlugin)Class.forName(className).newInstance();
            this.importPlugins.add(plugin);
        }
        catch (KDBizException e) {
            log.error((Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u5bfc\u5165\u63d2\u4ef6{0}\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff1a{1}\u3002", (String)"PersonImportConfig_0", (String)"swc-hsas-business", (Object[])new Object[]{className, e.getMessage()})), new Object[0]);
        }
        catch (Throwable e) {
            log.error(e);
            throw new KDBizException(e, new ErrorCode("", ResManager.loadKDString((String)"\u5bfc\u5165\u63d2\u4ef6{0}\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff1a{1}\u3002", (String)"PersonImportConfig_0", (String)"swc-hsas-business", (Object[])new Object[]{className, ImportLogger.formatException((Throwable)e)})), new Object[0]);
        }
    }

    private ImportEntityRel getImportEntityRelByMainEntityId(String mainEntityId) {
        ImportEntityRel importEntityRelResult = null;
        switch (mainEntityId) {
            case "hsas_person": {
                importEntityRelResult = PersonImportHelper.getPersonImportEntityRel();
                break;
            }
            case "hsas_salaryfile": {
                boolean hasTaxFilePerm = (Boolean)this.formView.getFormShowParameter().getCustomParam("hastaxfileperm");
                if (hasTaxFilePerm) {
                    importEntityRelResult = PersonImportHelper.getSalaryAndTaxTempImportEntityRel();
                    break;
                }
                importEntityRelResult = PersonImportHelper.getSalaryFileImportEntityRel();
                break;
            }
            case "hsas_taxfiletmp": {
                importEntityRelResult = PersonImportHelper.getTaxTempImportEntityRel();
                break;
            }
        }
        return importEntityRelResult;
    }

    public void addCompleteUrl(String completeUrl) {
        if (!StringUtils.isEmpty((String)completeUrl)) {
            this.completeUrls.add(completeUrl);
        }
    }

    public IFormView getFormView() {
        return this.formView;
    }

    public void setFormView(IFormView formView) {
        this.formView = formView;
    }

    public Object getLogId() {
        return this.logId;
    }

    public void setLogId(Object logId) {
        this.logId = logId;
    }

    public Map<String, LinkedBlockingQueue<ImportBillData>> getDataQueues() {
        return this.dataQueues;
    }

    public void setDataQueues(Map<String, LinkedBlockingQueue<ImportBillData>> dataQueues) {
        this.dataQueues = dataQueues;
    }

    public Map<String, PersonImportLogger> getUrlLoggers() {
        return this.urlLoggers;
    }

    public void setUrlLoggers(Map<String, PersonImportLogger> urlLoggers) {
        this.urlLoggers = urlLoggers;
    }

    public Set<String> getCompleteUrls() {
        return Collections.unmodifiableSet(this.completeUrls);
    }

    public void setCompleteUrls(Set<String> completeUrls) {
        this.completeUrls = Collections.unmodifiableSet(completeUrls);
    }

    public boolean isComplete(String key) {
        return this.completeUrls.contains(key);
    }

    public ImportEntityRel getImportEntityRel() {
        return this.importEntityRel;
    }

    public List<IPersonImportPlugin> getImportPlugins() {
        return Collections.unmodifiableList(this.importPlugins);
    }

    public void setImportPlugins(List<IPersonImportPlugin> importPlugins) {
        this.importPlugins = Collections.unmodifiableList(importPlugins);
    }

    public synchronized void feedbackProgress(int progress, PersonImportLogger importLogger, String errMsg) {
        JSONObject map;
        IPageCache cache = (IPageCache)this.formView.getService(IPageCache.class);
        String cachedLogStr = cache.get(IMPORT_CACHE_KEY);
        JSONObject jSONObject = map = SWCStringUtils.isEmpty((String)cachedLogStr) ? new JSONObject() : JSON.parseObject((String)cachedLogStr);
        if (progress > map.getIntValue("progress")) {
            map.put("progress", (Object)progress);
        }
        if (importLogger != null) {
            map.put("rowindex", (Object)importLogger.getRowIndex());
            map.put("lastrowindex", (Object)importLogger.getLastRowIndex());
            map.put("total", (Object)importLogger.getTotal());
            map.put("succeed", (Object)importLogger.getSuccess());
            map.put("failed", (Object)importLogger.getFailed());
        }
        if (!SWCStringUtils.isEmpty((String)errMsg)) {
            map.put("err", (Object)errMsg);
        }
        cachedLogStr = JSON.toJSONString((Object)map);
        log.info("{}---->{}", (Object)IMPORT_CACHE_KEY, (Object)cachedLogStr);
        cache.put(IMPORT_CACHE_KEY, cachedLogStr);
        try {
            Method method = cache.getClass().getMethod("saveChanges", new Class[0]);
            method.invoke((Object)cache, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

