/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.dataport;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hsas.business.extpoint.salaryfile.ISalaryFileExportExtService;
import kd.sdk.swc.hsas.business.extpoint.salaryfile.ISalaryFileImportExtService;
import kd.sdk.swc.hsas.common.entity.ImportEntity;
import kd.sdk.swc.hsas.common.entity.ImportEntityRel;
import kd.sdk.swc.hsas.common.events.salaryfile.SalaryFileExportEvent;
import kd.sdk.swc.hsas.common.events.salaryfile.SalaryFileImportEvent;
import kd.swc.hsas.business.dataport.SalaryFileExportExtService;
import kd.swc.hsas.business.dataport.SalaryFileImportExtService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import org.apache.commons.collections4.CollectionUtils;

public class PersonImportHelper {
    private static final String[] PERSON_FIELDS = new String[]{"empnumber", "name", "credentialstype.number", "credentialsnumber", "birthday"};
    private static final String[] PERSONAL_INFO_FIELDS = new String[]{"phone", "peremail", "nationality.name", "gender", "marriagestatus.name", "workplace.name", "joincompanydate", "beginservicedate"};
    private static final String[] EMP_POS_INFO_FIELDS = new String[]{"enterprise.name", "laborreltype.name", "position.number", "adminorg.number", "isprimary", "postype.name", "posstartdate", "posenddate"};
    private static final String[] DEP_EMP_FIELDS = new String[]{"orgteam.name", "dutyworkroles.name", "otclassify.number", "cmpemp.number", "isprimary", "postype.name", "startdate", "enddate", "assignno"};
    private static final String[] EMP_POS_INFO_ENT_FIELDS = new String[]{"laborrelstatus.name", "org.number", "jobscm.name", "job.number", "joblevel.name", "jobgrade.name", "entrydate", "regulardate", "quitdate", "lastworkdate", "lastworkday"};
    private static final String[] SALARY_FILE_FIELDS_IMPORT = new String[]{"number", "employee.empnumber", "depemp.number", "org.number", "payrollregion.number", "depcytype.number", "payrollgroup.name", "adminorg.number", "empgroup.number", "salarycalcstyle.name", "startpaydate", "bsed", "isupdatepayenddate", "changereason.name"};
    private static final String[] SALARY_FILE_FIELDS_FOR_TAXFILE_IMPORT = new String[]{"number", "employee.empnumber", "depemp.number", "org.number", "payrollregion.number", "depcytype.number", "payrollgroup.name", "adminorg.number", "empgroup.number", "salarycalcstyle.name", "startpaydate", "bsed", "changereason.name"};
    private static final String[] SALARY_FILE_FIELDS_EXPORT = new String[]{"number", "employee.person.name", "employee.empnumber", "firstbsed", "bsled", "salarycalcstyle.name", "salarycalcstyle.number", "paystatus", "org.name", "org.number", "payrollregion.name", "payrollregion.number", "payrollgroup.name", "payrollgroup.number", "depcytype.name", "depcytype.number", "adminorg.name", "adminorg.number", "isescrowstaff", "empgroup.name", "empgroup.number", "startpaydate", "depemp.showname", "depemp.number", "depemp.orgteam.name", "depemp.orgteam.number", "managingscope.managingscope.name", "status", "changereason.name", "modifier.name", "modifytime", "creator.name", "createtime"};
    private static final String[] TAX_FILE_TMP_IMPORT = new String[]{"number", "org.number", "taxregion.number", "empgroup.number", "taxunit.number", "isescrowstaff", "taxpayertype", "emptype", "empdate", "empsituation", "isdeductexps", "bsed"};
    private static final String[] TAX_FILE_TMP_EXPORT = new String[]{"number", "org.name", "taxregion.name", "empgroup.name", "taxunit.name", "taxunit.admindivision.name", "isescrowstaff", "taxpayertypetmp.name", "emptypetmp.name", "empdatetmp", "empsituationtmp", "isdeductexpstmp", "bsed"};
    private static final List<String> SALARYFILE_LAST_EXPORT_FIELD = Arrays.asList("managingscope.managingscope.name", "status", "modifier.name", "modifytime", "creator.name", "createtime");
    private static Map<String, List<String>> SALARYFILE_EXPORT_FIELD_MAP = new HashMap<String, List<String>>(16);

    public static ImportEntityRel getPersonImportEntityRel() {
        ImportEntity personEntity = new ImportEntity("hsas_person", "hsas", PERSON_FIELDS);
        List<ImportEntity> otherEntities = PersonImportHelper.getPersonChildEntities();
        return new ImportEntityRel(personEntity, otherEntities, true);
    }

    private static List<ImportEntity> getPersonChildEntities() {
        ArrayList<ImportEntity> importEntities = new ArrayList<ImportEntity>(10);
        ImportEntity personalInfoEntity = new ImportEntity("hsas_personalinfo", "hsas", PERSONAL_INFO_FIELDS, "hsas_person", "person");
        ImportEntity empPosInfoEntity = new ImportEntity("hsas_depemp", "hsas", DEP_EMP_FIELDS, "hsas_person", "person");
        ImportEntity empPosInfoEntEntity = new ImportEntity("hsas_empposinfoent", "hsas", EMP_POS_INFO_ENT_FIELDS, "hsas_empposinfo", "empposinfo");
        importEntities.add(personalInfoEntity);
        importEntities.add(empPosInfoEntity);
        importEntities.add(empPosInfoEntEntity);
        return importEntities;
    }

    public static String getImportFileName(String url) {
        String[] splitUrl = url.split("\\/");
        return splitUrl[splitUrl.length - 1];
    }

    public static ImportEntityRel getSalaryFileImportEntityRel() {
        ImportEntity personEntity = new ImportEntity("hsas_salaryfile", "hsas", SALARY_FILE_FIELDS_IMPORT, "import_save");
        ImportEntityRel _importEntityRel = new ImportEntityRel(personEntity, Collections.emptyList(), true);
        SalaryFileImportEvent args = new SalaryFileImportEvent(_importEntityRel);
        SalaryFileImportExtService iSalaryFileImportExtService = new SalaryFileImportExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)iSalaryFileImportExtService, ISalaryFileImportExtService.class, (String)"kd.sdk.swc.hsas.business.extpoint.salaryfile.ISalaryFileImportExtService#afterBuildSalaryFileImportEntityRel", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.afterBuildSalaryFileImportEntityRel(args);
            return null;
        });
        PersonImportHelper.dealImportEntityRel(args.getImportEntityRel(), "import");
        return args.getImportEntityRel();
    }

    public static ImportEntityRel getSalaryAndTaxTempImportEntityRel() {
        String[] fileds = Arrays.copyOf(SALARY_FILE_FIELDS_IMPORT, SALARY_FILE_FIELDS_IMPORT.length + 1);
        fileds[PersonImportHelper.SALARY_FILE_FIELDS_IMPORT.length] = "addtaxfilecheckbox";
        ImportEntity salaryFileEntity = new ImportEntity("hsas_salaryfile", "hsas", fileds, "import_save");
        ImportEntity taxFileEntity = new ImportEntity("hsas_taxfiletmp", "hsas", TAX_FILE_TMP_IMPORT, "hsas_salaryfile", "salaryfile", "addtaxfilecheckbox", "import_save");
        ArrayList otherEntities = Lists.newArrayList((Object[])new ImportEntity[]{taxFileEntity});
        ImportEntityRel _importEntityRel = new ImportEntityRel(salaryFileEntity, (List)otherEntities, true);
        SalaryFileImportEvent args = new SalaryFileImportEvent(_importEntityRel);
        SalaryFileImportExtService iSalaryFileImportExtService = new SalaryFileImportExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)iSalaryFileImportExtService, ISalaryFileImportExtService.class, (String)"kd.sdk.swc.hsas.business.extpoint.salaryfile.ISalaryFileImportExtService#afterBuildSalaryAndTaxTempImportEntityRel", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.afterBuildSalaryAndTaxTempImportEntityRel(args);
            return null;
        });
        PersonImportHelper.dealImportEntityRel(args.getImportEntityRel(), "import");
        return args.getImportEntityRel();
    }

    public static ImportEntityRel getSalaryFileExportEntityRel() {
        ImportEntity personEntity = new ImportEntity("hsas_salaryfile", "hsas", SALARY_FILE_FIELDS_EXPORT);
        ImportEntityRel _importEntityRel = new ImportEntityRel(personEntity, Collections.emptyList(), true);
        SalaryFileExportEvent args = new SalaryFileExportEvent(_importEntityRel);
        SalaryFileExportExtService iSalaryFileExportExtService = new SalaryFileExportExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)iSalaryFileExportExtService, ISalaryFileExportExtService.class, (String)"kd.sdk.swc.hsas.business.extpoint.salaryfile.ISalaryFileExportExtService#afterBuildSalaryFileExportEntityRel", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.afterBuildSalaryFileExportEntityRel(args);
            return null;
        });
        PersonImportHelper.dealImportEntityRel(args.getImportEntityRel(), "export");
        return args.getImportEntityRel();
    }

    public static ImportEntityRel getSalaryAndTaxExportEntityRel() {
        ImportEntity salaryFileEntity = new ImportEntity("hsas_salaryfile", "hsas", SALARY_FILE_FIELDS_EXPORT);
        ImportEntity taxFileEntity = new ImportEntity("itc_taxfile", "itc", TAX_FILE_TMP_EXPORT, "hsas_salaryfile", "salaryfile");
        ArrayList otherEntities = Lists.newArrayList((Object[])new ImportEntity[]{taxFileEntity});
        ImportEntityRel _importEntityRel = new ImportEntityRel(salaryFileEntity, (List)otherEntities, true);
        SalaryFileExportEvent args = new SalaryFileExportEvent(_importEntityRel);
        SalaryFileExportExtService iSalaryFileExportExtService = new SalaryFileExportExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)iSalaryFileExportExtService, ISalaryFileExportExtService.class, (String)"kd.sdk.swc.hsas.business.extpoint.salaryfile.ISalaryFileExportExtService#afterBuildSalaryAndTaxExportEntityRel", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.afterBuildSalaryAndTaxExportEntityRel(args);
            return null;
        });
        PersonImportHelper.dealImportEntityRel(args.getImportEntityRel(), "export");
        return args.getImportEntityRel();
    }

    public static ImportEntityRel getSalaryAndTaxTempExportEntityRel() {
        ImportEntity salaryFileEntity = new ImportEntity("hsas_salaryfile", "hsas", SALARY_FILE_FIELDS_FOR_TAXFILE_IMPORT);
        ImportEntity taxFileEntity = new ImportEntity("hsas_taxfiletmp", "hsas", TAX_FILE_TMP_IMPORT, "hsas_salaryfile", "salaryfile");
        ArrayList otherEntities = Lists.newArrayList((Object[])new ImportEntity[]{taxFileEntity});
        ImportEntityRel _importEntityRel = new ImportEntityRel(salaryFileEntity, (List)otherEntities, true);
        SalaryFileExportEvent args = new SalaryFileExportEvent(_importEntityRel);
        SalaryFileExportExtService iSalaryFileExportExtService = new SalaryFileExportExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)iSalaryFileExportExtService, ISalaryFileExportExtService.class, (String)"kd.sdk.swc.hsas.business.extpoint.salaryfile.ISalaryFileExportExtService#afterBuildTaxTempExportEntityRel", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.afterBuildTaxTempExportEntityRel(args);
            return null;
        });
        PersonImportHelper.dealImportEntityRel(args.getImportEntityRel(), "export");
        return args.getImportEntityRel();
    }

    public static ImportEntityRel getTaxTempImportEntityRel() {
        ImportEntity taxFileEntity = new ImportEntity("hsas_taxfiletmp", "hsas", new String[0], "import_save");
        ImportEntityRel _importEntityRel = new ImportEntityRel(taxFileEntity, Collections.emptyList(), true);
        SalaryFileImportEvent args = new SalaryFileImportEvent(_importEntityRel);
        SalaryFileImportExtService iSalaryFileImportExtService = new SalaryFileImportExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)iSalaryFileImportExtService, ISalaryFileImportExtService.class, (String)"kd.sdk.swc.hsas.business.extpoint.salaryfile.ISalaryFileImportExtService#afterBuildTaxTempImportEntityRel", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.afterBuildTaxTempImportEntityRel(args);
            return null;
        });
        return args.getImportEntityRel();
    }

    public static String openExportingPage(boolean isExportAll, IFormView formView) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_salaryfile_exporting");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("hastaxfileperm", (Object)formView.getPageCache().get("hastaxfileperm"));
        showParameter.setCustomParam("entityName", (Object)ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848", (String)"PersonImportHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]));
        showParameter.setCustomParam("targetpageid", (Object)formView.getPageId());
        showParameter.setCustomParam("isexportall", (Object)isExportAll);
        showParameter.setCustomParam("isimport", (Object)Boolean.FALSE);
        formView.showForm(showParameter);
        return showParameter.getPageId();
    }

    private static DynamicObject[] getSalaryFileExtFields() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfileextfield");
        QFilter filter = new QFilter("1", "=", (Object)1);
        return helper.query(SWCHisBaseDataHelper.getSelectProperties((String)"hsas_salaryfileextfield"), new QFilter[]{filter}, "index asc");
    }

    private static void dealImportEntityRel(ImportEntityRel args, String type) {
        ArrayList<String> resList;
        String colKey;
        if ("export".equals(type)) {
            colKey = "isexport";
        } else if ("import".equals(type)) {
            colKey = "isimport";
        } else {
            return;
        }
        Object[] extFieldArr = PersonImportHelper.getSalaryFileExtFields();
        if (SWCArrayUtils.isEmpty((Object[])extFieldArr)) {
            return;
        }
        ArrayList<String> specFieldKeys = new ArrayList<String>(10);
        ArrayList<String> disableFieldKeys = new ArrayList<String>(10);
        for (Object extField : extFieldArr) {
            String fieldKey = extField.getString("fieldkey");
            if (extField.getBoolean(colKey)) {
                specFieldKeys.add(fieldKey);
            }
            if (extField.getBoolean("enable")) continue;
            disableFieldKeys.add(fieldKey);
        }
        if (CollectionUtils.isEmpty(specFieldKeys)) {
            return;
        }
        PersonImportHelper.filterIllegalFieldKey(specFieldKeys);
        String[] fieldKeyArr = args.getMainEntity().getFieldKey();
        ArrayList<String> fieldKeys = new ArrayList<String>(fieldKeyArr.length);
        fieldKeys.addAll(Arrays.asList(fieldKeyArr));
        if (CollectionUtils.isNotEmpty(disableFieldKeys)) {
            specFieldKeys.removeAll(disableFieldKeys);
            if ("export".equals(type)) {
                disableFieldKeys.forEach(key -> {
                    if (SALARYFILE_EXPORT_FIELD_MAP.containsKey(key)) {
                        fieldKeys.removeAll((Collection)SALARYFILE_EXPORT_FIELD_MAP.get(key));
                    } else {
                        fieldKeys.remove(key);
                    }
                });
            } else {
                fieldKeys.removeAll(disableFieldKeys);
            }
        }
        if ("export".equals(type)) {
            for (Map.Entry<String, List<String>> entry : SALARYFILE_EXPORT_FIELD_MAP.entrySet()) {
                int index = specFieldKeys.indexOf(entry.getKey());
                if (-1 == index) continue;
                specFieldKeys.remove(entry.getKey());
                specFieldKeys.addAll(index, CollectionUtils.subtract((Iterable)entry.getValue(), specFieldKeys));
            }
            specFieldKeys.addAll(SALARYFILE_LAST_EXPORT_FIELD);
        }
        Collection subtractList1 = CollectionUtils.subtract(fieldKeys, specFieldKeys);
        boolean existsTaxFileField = subtractList1.remove("addtaxfilecheckbox");
        if (CollectionUtils.isNotEmpty((Collection)subtractList1)) {
            Collection subtractList2 = CollectionUtils.subtract(specFieldKeys, fieldKeys);
            fieldKeys.addAll(subtractList2);
            resList = fieldKeys;
        } else {
            resList = specFieldKeys;
        }
        if (existsTaxFileField && !specFieldKeys.contains("addtaxfilecheckbox")) {
            resList.add("addtaxfilecheckbox");
        }
        args.getMainEntity().setFieldKey(resList.toArray(new String[0]));
    }

    private static void filterIllegalFieldKey(List<String> specFieldKeys) {
        HashSet salaryFileFields = new HashSet(SWCHisBaseDataHelper.getFields((MainEntityType)EntityMetadataCache.getDataEntityType((String)"hsas_salaryfile")));
        Iterator<String> iterator = specFieldKeys.iterator();
        while (iterator.hasNext()) {
            String fieldKey = iterator.next();
            if (fieldKey.contains(".")) {
                Object[] arr = fieldKey.split("\\.");
                if (SWCArrayUtils.isEmpty((Object[])arr) || arr.length != 2) {
                    iterator.remove();
                    continue;
                }
                if (salaryFileFields.contains(arr[0]) && ("name".equals(arr[1]) || "number".equals(arr[1]) || "empnumber".equals(arr[1]))) continue;
                iterator.remove();
                continue;
            }
            if (salaryFileFields.contains(fieldKey)) continue;
            iterator.remove();
        }
    }

    static {
        SALARYFILE_EXPORT_FIELD_MAP.put("number", Collections.singletonList("number"));
        SALARYFILE_EXPORT_FIELD_MAP.put("employee.empnumber", Arrays.asList("employee.person.name", "employee.empnumber"));
        SALARYFILE_EXPORT_FIELD_MAP.put("depemp.number", Arrays.asList("depemp.showname", "depemp.number", "depemp.orgteam.name", "depemp.orgteam.number"));
        SALARYFILE_EXPORT_FIELD_MAP.put("org.number", Arrays.asList("org.name", "org.number"));
        SALARYFILE_EXPORT_FIELD_MAP.put("payrollregion.number", Arrays.asList("payrollregion.name", "payrollregion.number"));
        SALARYFILE_EXPORT_FIELD_MAP.put("depcytype.number", Arrays.asList("depcytype.name", "depcytype.number"));
        SALARYFILE_EXPORT_FIELD_MAP.put("payrollgroup.name", Arrays.asList("payrollgroup.name", "payrollgroup.number"));
        SALARYFILE_EXPORT_FIELD_MAP.put("adminorg.number", Arrays.asList("adminorg.name", "adminorg.number", "isescrowstaff"));
        SALARYFILE_EXPORT_FIELD_MAP.put("empgroup.number", Arrays.asList("empgroup.name", "empgroup.number"));
        SALARYFILE_EXPORT_FIELD_MAP.put("salarycalcstyle.name", Arrays.asList("salarycalcstyle.name", "salarycalcstyle.number", "paystatus"));
        SALARYFILE_EXPORT_FIELD_MAP.put("startpaydate", Collections.singletonList("startpaydate"));
        SALARYFILE_EXPORT_FIELD_MAP.put("bsed", Arrays.asList("firstbsed", "bsled"));
        SALARYFILE_EXPORT_FIELD_MAP.put("changereason.name", Collections.singletonList("changereason.name"));
    }
}

